#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cryptonite-conduit
version:              0.2.2
visibility:           public
id:                   cryptonite-conduit-0.2.2-5yzOY5LuGIaIx3BVxXF7X3
key:                  cryptonite-conduit-0.2.2-5yzOY5LuGIaIx3BVxXF7X3
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           vincent@snarc.org
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             https://github.com/haskell-crypto/cryptonite-conduit
synopsis:             cryptonite conduit
description:
    Conduit bridge for cryptonite

    For now only provide a conduit version for hash and hmac, but
    with contribution, this could provide cipher conduits too,
    and probably other things.

category:             Cryptography, Conduit
abi:                  0b9356b3baa78e0353b3a95d38a4837a
exposed:              True
exposed-modules:
    Crypto.Cipher.ChaChaPoly1305.Conduit Crypto.Hash.Conduit
    Crypto.MAC.HMAC.Conduit Crypto.PubKey.ECIES.Conduit

import-dirs:          /usr/lib/ghc-8.10.5/site-local/cryptonite-conduit-0.2.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/cryptonite-conduit-0.2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/cryptonite-conduit-0.2.2
hs-libraries:         HScryptonite-conduit-0.2.2-5yzOY5LuGIaIx3BVxXF7X3
depends:
    base-4.14.2.0 bytestring-0.10.12.0
    conduit-1.3.4.1-1BtK5bRX29l4VANueOokSq
    conduit-extra-1.3.5-CQ5JVlOEJjrEZl3y6az5nD
    cryptonite-0.29-DOJpzHmGf631cPBYwOScHA exceptions-0.10.4
    memory-0.16.0-E1gXzMJzgEcJ8QhI9dLs6S
    resourcet-1.2.4.2-AvaFhfxp8uvAOEEUNRGsFz transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-cryptonite-conduit/html/cryptonite-conduit.haddock

haddock-html:         /usr/share/doc/haskell-cryptonite-conduit/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

