/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.HashSet;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.engine.TestEngine;

class EngineIdValidator {
    private EngineIdValidator() {
    }

    static Iterable<TestEngine> validate(Iterable<TestEngine> testEngines) {
        HashSet<String> ids = new HashSet<String>();
        for (TestEngine testEngine : testEngines) {
            if (!EngineIdValidator.validateReservedIds(testEngine)) {
                EngineIdValidator.getLogger().warn(() -> String.format("Third-party TestEngine implementations are forbidden to use the reserved 'junit-' prefix for their ID: '%s'", testEngine.getId()));
            }
            if (ids.add(testEngine.getId())) continue;
            throw new JUnitException(String.format("Cannot create Launcher for multiple engines with the same ID '%s'.", testEngine.getId()));
        }
        return testEngines;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(EngineIdValidator.class);
    }

    private static boolean validateReservedIds(TestEngine testEngine) {
        String engineId = testEngine.getId();
        if (!engineId.startsWith("junit-")) {
            return true;
        }
        if (engineId.equals("junit-jupiter")) {
            EngineIdValidator.validateWellKnownClassName(testEngine, "org.junit.jupiter.engine.JupiterTestEngine");
            return true;
        }
        if (engineId.equals("junit-vintage")) {
            EngineIdValidator.validateWellKnownClassName(testEngine, "org.junit.vintage.engine.VintageTestEngine");
            return true;
        }
        if (engineId.equals("junit-platform-suite")) {
            EngineIdValidator.validateWellKnownClassName(testEngine, "org.junit.platform.suite.engine.SuiteTestEngine");
            return true;
        }
        return false;
    }

    private static void validateWellKnownClassName(TestEngine testEngine, String expectedClassName) {
        String actualClassName = testEngine.getClass().getName();
        if (actualClassName.equals(expectedClassName)) {
            return;
        }
        throw new JUnitException(String.format("Third-party TestEngine '%s' is forbidden to use the reserved '%s' TestEngine ID.", actualClassName, testEngine.getId()));
    }
}

