#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
---
module: wireless_controllers_provision_v1
short_description: Resource module for Wireless Controllers Provision V1
description:
- Manage operation create of the resource Wireless Controllers Provision V1.
- This API is used to provision wireless controller.
version_added: '6.15.0'
extends_documentation_fragment:
  - cisco.dnac.module
author: Rafael Campos (@racampos)
options:
  deviceId:
    description: DeviceId path parameter. Network Device ID. This value can be obtained
      by using the API call GET /dna/intent/api/v1/network-device/ip-address/${ipAddress}.
    type: str
  interfaces:
    description: Wireless Controllers Provision's interfaces.
    elements: dict
    suboptions:
      interfaceGateway:
        description: Interface Gateway.
        type: str
      interfaceIPAddress:
        description: Interface IP Address.
        type: str
      interfaceName:
        description: Interface Name.
        type: str
      interfaceNetmaskInCIDR:
        description: Interface Netmask In CIDR, range is 1-30.
        type: int
      lagOrPortNumber:
        description: Lag Or Port Number.
        type: int
      vlanId:
        description: VLAN ID range is 1 - 4094.
        type: int
    type: list
  rollingApUpgrade:
    description: Wireless Controllers Provision's rollingApUpgrade.
    suboptions:
      apRebootPercentage:
        description: AP Reboot Percentage. Permissible values - 5, 15, 25.
        type: int
      enableRollingApUpgrade:
        description: True if Rolling AP Upgrade is enabled, else False.
        type: bool
    type: dict
  skipApProvision:
    description: True if Skip AP Provision is enabled, else False.
    type: bool
requirements:
- dnacentersdk >= 2.4.9
- python >= 3.5
seealso:
- name: Cisco DNA Center documentation for Wireless WirelessControllerProvisionV1
  description: Complete reference of the WirelessControllerProvisionV1 API.
  link: https://developer.cisco.com/docs/dna-center/#!wireless-controller-provision
notes:
  - SDK Method used are
    wireless.Wireless.wireless_controller_provision_v1,

  - Paths used are
    post /dna/intent/api/v1/wirelessControllers/{deviceId}/provision,

"""

EXAMPLES = r"""
- name: Create
  cisco.dnac.wireless_controllers_provision_v1:
    dnac_host: "{{dnac_host}}"
    dnac_username: "{{dnac_username}}"
    dnac_password: "{{dnac_password}}"
    dnac_verify: "{{dnac_verify}}"
    dnac_port: "{{dnac_port}}"
    dnac_version: "{{dnac_version}}"
    dnac_debug: "{{dnac_debug}}"
    deviceId: string
    interfaces:
    - interfaceGateway: string
      interfaceIPAddress: string
      interfaceName: string
      interfaceNetmaskInCIDR: 0
      lagOrPortNumber: 0
      vlanId: 0
    rollingApUpgrade:
      apRebootPercentage: 0
      enableRollingApUpgrade: true
    skipApProvision: true

"""
RETURN = r"""
dnac_response:
  description: A dictionary or list with the response returned by the Cisco DNAC Python SDK
  returned: always
  type: dict
  sample: >
    {
      "response": {
        "taskId": "string",
        "url": "string"
      },
      "version": "string"
    }
"""
