/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbService;
import org.firebirdsql.management.FBServiceManager;
import org.firebirdsql.management.TraceManager;

public class FBTraceManager
extends FBServiceManager
implements TraceManager {
    private final Map<String, Integer> traceSessions = Collections.synchronizedMap(new HashMap());

    public FBTraceManager() {
    }

    public FBTraceManager(String gdsType) {
        super(gdsType);
    }

    public FBTraceManager(GDSType gdsType) {
        super(gdsType);
    }

    private ServiceRequestBuffer getTraceSPB(FbService service, int action) {
        ServiceRequestBuffer traceSPB = service.createServiceRequestBuffer();
        traceSPB.addArgument(action);
        return traceSPB;
    }

    private ServiceRequestBuffer getTraceSPB(FbService service, int action, int traceSessionId) {
        ServiceRequestBuffer traceSPB = this.getTraceSPB(service, action);
        traceSPB.addArgument(1, traceSessionId);
        return traceSPB;
    }

    private ServiceRequestBuffer getTraceSPB(FbService service, int action, String traceSessionName, String configuration) {
        ServiceRequestBuffer traceSPB = this.getTraceSPB(service, action);
        traceSPB.addArgument(2, traceSessionName);
        traceSPB.addArgument(3, configuration);
        return traceSPB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTraceSession(String traceSessionName, String configuration) throws SQLException {
        if (configuration == null || configuration.equals("")) {
            throw new SQLException("No configuration provided");
        }
        if (traceSessionName == null) {
            traceSessionName = "";
        }
        FBTraceManager fBTraceManager = this;
        synchronized (fBTraceManager) {
            OutputStream currentLogger = this.getLogger();
            if (currentLogger instanceof TraceStream) {
                TraceStream traceStream = (TraceStream)currentLogger;
                currentLogger = traceStream.unwrap();
            }
            this.setLogger(new TraceStream(currentLogger, traceSessionName));
            FbService service = this.attachServiceManager();
            ServiceRequestBuffer traceSPB = this.getTraceSPB(service, 22, traceSessionName, configuration);
            Thread t = new Thread(new TraceTask(service, traceSPB));
            t.start();
        }
    }

    @Override
    public void stopTraceSession(int traceSessionId) throws SQLException {
        try (FbService service = this.attachServiceManager();){
            service.startServiceAction(this.getTraceSPB(service, 23, traceSessionId));
            this.queueService(service);
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    @Override
    public void suspendTraceSession(int traceSessionId) throws SQLException {
        try (FbService service = this.attachServiceManager();){
            service.startServiceAction(this.getTraceSPB(service, 24, traceSessionId));
            this.queueService(service);
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    @Override
    public void resumeTraceSession(int traceSessionId) throws SQLException {
        try (FbService service = this.attachServiceManager();){
            service.startServiceAction(this.getTraceSPB(service, 25, traceSessionId));
            this.queueService(service);
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    @Override
    public void listTraceSessions() throws SQLException {
        try (FbService service = this.attachServiceManager();){
            service.startServiceAction(this.getTraceSPB(service, 26));
            this.queueService(service);
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    @Override
    public Integer getSessionId(String sessionName) {
        return this.traceSessions.get(sessionName);
    }

    private class TraceStream
    extends FilterOutputStream {
        private static final String START_TEXT = "Trace session ID ";
        private final String sessionName;
        private volatile boolean lookForSessionId;

        public TraceStream(OutputStream out, String sessionName) {
            super(out);
            this.lookForSessionId = true;
            this.sessionName = sessionName;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.lookForSessionId) {
                this.findSessionId(b, off, len);
                this.lookForSessionId = false;
            }
            super.write(b, off, len);
        }

        private void findSessionId(byte[] b, int off, int len) {
            String sessionStart = new String(b, off, len);
            int traceStartIdx = sessionStart.indexOf(START_TEXT);
            int sessionIdStart = -1;
            int sessionIdEnd = -1;
            if (traceStartIdx >= 0 && (sessionIdStart = traceStartIdx + START_TEXT.length()) < sessionStart.length()) {
                sessionIdEnd = sessionStart.indexOf(32, sessionIdStart);
            }
            if (sessionIdStart >= 0 && sessionIdEnd > sessionIdStart && sessionIdEnd < sessionStart.length()) {
                try {
                    int sessionId = Integer.parseInt(sessionStart.substring(sessionIdStart, sessionIdEnd));
                    FBTraceManager.this.traceSessions.put(this.sessionName, sessionId);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public OutputStream unwrap() {
            return this.out;
        }
    }

    private class TraceTask
    implements Runnable {
        private final ServiceRequestBuffer srb;
        private final FbService service;

        public TraceTask(FbService service, ServiceRequestBuffer srb) {
            this.srb = srb;
            this.service = service;
        }

        @Override
        public void run() {
            try (FbService service = this.service;){
                FBTraceManager.this.executeServicesOperation(service, this.srb);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

