/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.wasm;

import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.wasm.WebAssemblyMemoryPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssembly;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemoryObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.graalvm.collections.EconomicMap;

public class JSWebAssemblyMemory
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final int MAX_MEMORY_SIZE = 65536;
    public static final TruffleString CLASS_NAME = Strings.constant("Memory");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("Memory.prototype");
    public static final TruffleString WEB_ASSEMBLY_MEMORY = Strings.constant("WebAssembly.Memory");
    public static final JSWebAssemblyMemory INSTANCE = new JSWebAssemblyMemory();

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    public static boolean isJSWebAssemblyMemory(Object object) {
        return object instanceof JSWebAssemblyMemoryObject;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, constructor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, WebAssemblyMemoryPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putAccessorsFromContainer(realm, prototype, WebAssemblyMemoryPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, WEB_ASSEMBLY_MEMORY);
        return prototype;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWebAssemblyMemoryPrototype();
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static JSWebAssemblyMemoryObject create(JSContext context, JSRealm realm, Object wasmMemory, boolean shared) {
        return JSWebAssemblyMemory.create(context, realm, INSTANCE.getIntrinsicDefaultProto(realm), wasmMemory, shared);
    }

    public static JSWebAssemblyMemoryObject create(JSContext context, JSRealm realm, JSDynamicObject proto, Object wasmMemory, boolean shared) {
        if (shared) {
            return JSWebAssemblyMemory.createShared(context, realm, proto, wasmMemory);
        }
        Object embedderData = JSWebAssembly.getEmbedderData(realm, wasmMemory);
        if (embedderData instanceof JSWebAssemblyMemoryObject) {
            JSWebAssemblyMemoryObject webAssemblyMemory = (JSWebAssemblyMemoryObject)((Object)embedderData);
            return webAssemblyMemory;
        }
        JSWebAssemblyMemoryObject webAssemblyMemory = JSWebAssemblyMemory.createImpl(context, realm, proto, wasmMemory, false);
        JSWebAssembly.setEmbedderData(realm, wasmMemory, (Object)webAssemblyMemory);
        return webAssemblyMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSWebAssemblyMemoryObject createShared(JSContext context, JSRealm realm, JSDynamicObject proto, Object wasmMemory) {
        Object object = wasmMemory;
        synchronized (object) {
            JSWebAssemblyMemoryObject webAssemblyMemory;
            EconomicMapHolder mapHolder;
            Object embedderData = JSWebAssembly.getEmbedderData(realm, wasmMemory);
            if (embedderData instanceof EconomicMapHolder) {
                mapHolder = (EconomicMapHolder)embedderData;
                webAssemblyMemory = Boundaries.economicMapGet(mapHolder.map, realm.getAgent());
                if (webAssemblyMemory != null) {
                    return webAssemblyMemory;
                }
            } else {
                mapHolder = new EconomicMapHolder();
                JSWebAssembly.setEmbedderData(realm, wasmMemory, mapHolder);
            }
            webAssemblyMemory = JSWebAssemblyMemory.createImpl(context, realm, proto, wasmMemory, true);
            Boundaries.economicMapPut(mapHolder.map, realm.getAgent(), webAssemblyMemory);
            return webAssemblyMemory;
        }
    }

    private static JSWebAssemblyMemoryObject createImpl(JSContext context, JSRealm realm, JSDynamicObject proto, Object wasmMemory, boolean shared) {
        JSObjectFactory factory = context.getWebAssemblyMemoryFactory();
        Shape shape = factory.getShape(realm, proto);
        JSWebAssemblyMemoryObject object = factory.initProto(new JSWebAssemblyMemoryObject(shape, proto, wasmMemory, shared), realm, proto);
        return factory.trackAllocation(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetBuffers(JSRealm realm, Object wasmMemory) {
        Object embedderData = JSWebAssembly.getEmbedderData(realm, wasmMemory);
        if (embedderData instanceof JSWebAssemblyMemoryObject) {
            JSWebAssemblyMemoryObject webAssemblyMemory = (JSWebAssemblyMemoryObject)((Object)embedderData);
            webAssemblyMemory.resetBufferObject();
        } else if (embedderData instanceof EconomicMapHolder) {
            EconomicMapHolder mapHolder = (EconomicMapHolder)embedderData;
            Object object = wasmMemory;
            synchronized (object) {
                for (JSWebAssemblyMemoryObject webAssemblyMemory : mapHolder.map.getValues()) {
                    webAssemblyMemory.resetBufferObject();
                }
            }
        }
    }

    static class EconomicMapHolder
    implements TruffleObject {
        final EconomicMap<JSAgent, JSWebAssemblyMemoryObject> map = Boundaries.economicMapCreate();

        EconomicMapHolder() {
        }
    }
}

