/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Range;
import com.oracle.truffle.regex.charset.RangesBuffer;
import com.oracle.truffle.regex.charset.SortedListOfRanges;
import com.oracle.truffle.regex.tregex.parser.CaseUnfoldingTrie;
import com.oracle.truffle.regex.tregex.string.Encodings;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;

public class CaseFoldData {
    private static final int INTEGER_OFFSET = 1;
    private static final int DIRECT_MAPPING = 2;
    private static final int ALTERNATING_UL = 3;
    private static final int ALTERNATING_AL = 4;
    private static final int ALTERNATING_UL_NEG = 5;
    private static final int ALTERNATING_AL_NEG = 6;
    private static final int DIRECT_SINGLE = 7;
    private static final CaseFoldEquivalenceTable ASCII = new CaseFoldEquivalenceTable(null, new CodePointSet[0], new int[]{65, 90, 1, 32, 97, 122, 1, -32});
    private static final String[] MULTI_CHAR_SEQUENCES = new String[]{"i\u0307", "SS", "FF", "FI", "FL", "FFI", "FFL", "ST", "\u0535\u0552", "\u0544\u0546", "\u0544\u0535", "\u0544\u053b", "\u054e\u0546", "\u0544\u053d", "\u02bcN", "\u0399\u0308\u0301", "\u03a5\u0308\u0301", "J\u030c", "H\u0331", "T\u0308", "W\u030a", "Y\u030a", "A\u02be", "\u03a5\u0313", "\u03a5\u0313\u0300", "\u03a5\u0313\u0301", "\u03a5\u0313\u0342", "\u0391\u0342", "\u0397\u0342", "\u0399\u0308\u0300", "\u0399\u0342", "\u0399\u0308\u0342", "\u03a5\u0308\u0300", "\u03a1\u0313", "\u03a5\u0342", "\u03a5\u0308\u0342", "\u03a9\u0342", "\u1f08\u0399", "\u1f09\u0399", "\u1f0a\u0399", "\u1f0b\u0399", "\u1f0c\u0399", "\u1f0d\u0399", "\u1f0e\u0399", "\u1f0f\u0399", "\u1f28\u0399", "\u1f29\u0399", "\u1f2a\u0399", "\u1f2b\u0399", "\u1f2c\u0399", "\u1f2d\u0399", "\u1f2e\u0399", "\u1f2f\u0399", "\u1f68\u0399", "\u1f69\u0399", "\u1f6a\u0399", "\u1f6b\u0399", "\u1f6c\u0399", "\u1f6d\u0399", "\u1f6e\u0399", "\u1f6f\u0399", "\u0391\u0399", "\u0397\u0399", "\u03a9\u0399", "\u1fba\u0399", "\u0386\u0399", "\u1fca\u0399", "\u0389\u0399", "\u1ffa\u0399", "\u038f\u0399", "\u0391\u0342\u0399", "\u0397\u0342\u0399", "\u03a9\u0342\u0399", "ss", "\u02bcn", "j\u030c", "\u03b9\u0308\u0301", "\u03c5\u0308\u0301", "\u0565\u0582", "h\u0331", "t\u0308", "w\u030a", "y\u030a", "a\u02be", "\u03c5\u0313", "\u03c5\u0313\u0300", "\u03c5\u0313\u0301", "\u03c5\u0313\u0342", "\u1f00\u03b9", "\u1f01\u03b9", "\u1f02\u03b9", "\u1f03\u03b9", "\u1f04\u03b9", "\u1f05\u03b9", "\u1f06\u03b9", "\u1f07\u03b9", "\u1f20\u03b9", "\u1f21\u03b9", "\u1f22\u03b9", "\u1f23\u03b9", "\u1f24\u03b9", "\u1f25\u03b9", "\u1f26\u03b9", "\u1f27\u03b9", "\u1f60\u03b9", "\u1f61\u03b9", "\u1f62\u03b9", "\u1f63\u03b9", "\u1f64\u03b9", "\u1f65\u03b9", "\u1f66\u03b9", "\u1f67\u03b9", "\u1f70\u03b9", "\u03b1\u03b9", "\u03ac\u03b9", "\u03b1\u0342", "\u03b1\u0342\u03b9", "\u1f74\u03b9", "\u03b7\u03b9", "\u03ae\u03b9", "\u03b7\u0342", "\u03b7\u0342\u03b9", "\u03b9\u0308\u0300", "\u03b9\u0342", "\u03b9\u0308\u0342", "\u03c5\u0308\u0300", "\u03c1\u0313", "\u03c5\u0342", "\u03c5\u0308\u0342", "\u1f7c\u03b9", "\u03c9\u03b9", "\u03ce\u03b9", "\u03c9\u0342", "\u03c9\u0342\u03b9", "ff", "fi", "fl", "ffi", "ffl", "st", "\u0574\u0576", "\u0574\u0565", "\u0574\u056b", "\u057e\u0576", "\u0574\u056d", "ij", "oe", "lj", "nj", "dz", "d\u0292", "d\u0291", "ts", "t\u0283", "t\u0255", "co", "no", "sm", "del", "tm", "ii", "iii", "iv", "vi", "vii", "viii", "ix", "xi", "xii", "fo"};
    public static final int MAX_MULTI_CHAR_SEQUENCE_LENGTH = 4;
    private static final CaseFoldEquivalenceTable UNICODE_16_0_0_EQ_SIMPLE = new CaseFoldEquivalenceTable(null, new CodePointSet[]{CaseFoldData.rangeSet(75, 75, 107, 107, 8490, 8490), CaseFoldData.rangeSet(83, 83, 115, 115, 383, 383), CaseFoldData.rangeSet(181, 181, 924, 924, 956, 956), CaseFoldData.rangeSet(197, 197, 229, 229, 8491, 8491), CaseFoldData.rangeSet(452, 454), CaseFoldData.rangeSet(455, 457), CaseFoldData.rangeSet(458, 460), CaseFoldData.rangeSet(497, 499), CaseFoldData.rangeSet(837, 837, 921, 921, 953, 953, 8126, 8126), CaseFoldData.rangeSet(914, 914, 946, 946, 976, 976), CaseFoldData.rangeSet(917, 917, 949, 949, 1013, 1013), CaseFoldData.rangeSet(920, 920, 952, 952, 977, 977, 1012, 1012), CaseFoldData.rangeSet(922, 922, 954, 954, 1008, 1008), CaseFoldData.rangeSet(928, 928, 960, 960, 982, 982), CaseFoldData.rangeSet(929, 929, 961, 961, 1009, 1009), CaseFoldData.rangeSet(931, 931, 962, 963), CaseFoldData.rangeSet(934, 934, 966, 966, 981, 981), CaseFoldData.rangeSet(937, 937, 969, 969, 8486, 8486), CaseFoldData.rangeSet(1042, 1042, 1074, 1074, 7296, 7296), CaseFoldData.rangeSet(1044, 1044, 1076, 1076, 7297, 7297), CaseFoldData.rangeSet(1054, 1054, 1086, 1086, 7298, 7298), CaseFoldData.rangeSet(1057, 1057, 1089, 1089, 7299, 7299), CaseFoldData.rangeSet(1058, 1058, 1090, 1090, 7300, 7301), CaseFoldData.rangeSet(1066, 1066, 1098, 1098, 7302, 7302), CaseFoldData.rangeSet(1122, 1123, 7303, 7303), CaseFoldData.rangeSet(7304, 7304, 42570, 42571), CaseFoldData.rangeSet(7776, 7777, 7835, 7835)}, new int[]{65, 74, 1, 32, 75, 75, 2, 0, 76, 82, 1, 32, 83, 83, 2, 1, 84, 90, 1, 32, 97, 106, 1, -32, 107, 107, 2, 0, 108, 114, 1, -32, 115, 115, 2, 1, 116, 122, 1, -32, 181, 181, 2, 2, 192, 196, 1, 32, 197, 197, 2, 3, 198, 214, 1, 32, 216, 222, 1, 32, 223, 223, 1, 7615, 224, 228, 1, -32, 229, 229, 2, 3, 230, 246, 1, -32, 248, 254, 1, -32, 255, 255, 1, 121, 256, 303, 4, 0, 306, 311, 4, 0, 313, 328, 3, 0, 330, 375, 4, 0, 376, 376, 1, -121, 377, 382, 3, 0, 383, 383, 2, 1, 384, 384, 1, 195, 385, 385, 1, 210, 386, 389, 4, 0, 390, 390, 1, 206, 391, 392, 3, 0, 393, 394, 1, 205, 395, 396, 3, 0, 398, 398, 1, 79, 399, 399, 1, 202, 400, 400, 1, 203, 401, 402, 3, 0, 403, 403, 1, 205, 404, 404, 1, 207, 405, 405, 1, 97, 406, 406, 1, 211, 407, 407, 1, 209, 408, 409, 4, 0, 410, 410, 1, 163, 411, 411, 1, 42561, 412, 412, 1, 211, 413, 413, 1, 213, 414, 414, 1, 130, 415, 415, 1, 214, 416, 421, 4, 0, 422, 422, 1, 218, 423, 424, 3, 0, 425, 425, 1, 218, 428, 429, 4, 0, 430, 430, 1, 218, 431, 432, 3, 0, 433, 434, 1, 217, 435, 438, 3, 0, 439, 439, 1, 219, 440, 441, 4, 0, 444, 445, 4, 0, 447, 447, 1, 56, 452, 454, 2, 4, 455, 457, 2, 5, 458, 460, 2, 6, 461, 476, 3, 0, 477, 477, 1, -79, 478, 495, 4, 0, 497, 499, 2, 7, 500, 501, 4, 0, 502, 502, 1, -97, 503, 503, 1, -56, 504, 543, 4, 0, 544, 544, 1, -130, 546, 563, 4, 0, 570, 570, 1, 10795, 571, 572, 3, 0, 573, 573, 1, -163, 574, 574, 1, 10792, 575, 576, 1, 10815, 577, 578, 3, 0, 579, 579, 1, -195, 580, 580, 1, 69, 581, 581, 1, 71, 582, 591, 4, 0, 592, 592, 1, 10783, 593, 593, 1, 10780, 594, 594, 1, 10782, 595, 595, 1, -210, 596, 596, 1, -206, 598, 599, 1, -205, 601, 601, 1, -202, 603, 603, 1, -203, 604, 604, 1, 42319, 608, 608, 1, -205, 609, 609, 1, 42315, 611, 611, 1, -207, 612, 612, 1, 42343, 613, 613, 1, 42280, 614, 614, 1, 42308, 616, 616, 1, -209, 617, 617, 1, -211, 618, 618, 1, 42308, 619, 619, 1, 10743, 620, 620, 1, 42305, 623, 623, 1, -211, 625, 625, 1, 10749, 626, 626, 1, -213, 629, 629, 1, -214, 637, 637, 1, 10727, 640, 640, 1, -218, 642, 642, 1, 42307, 643, 643, 1, -218, 647, 647, 1, 42282, 648, 648, 1, -218, 649, 649, 1, -69, 650, 651, 1, -217, 652, 652, 1, -71, 658, 658, 1, -219, 669, 669, 1, 42261, 670, 670, 1, 42258, 837, 837, 2, 8, 880, 883, 4, 0, 886, 887, 4, 0, 891, 893, 1, 130, 895, 895, 1, 116, 902, 902, 1, 38, 904, 906, 1, 37, 908, 908, 1, 64, 910, 911, 1, 63, 912, 912, 1, 7235, 913, 913, 1, 32, 914, 914, 2, 9, 915, 916, 1, 32, 917, 917, 2, 10, 918, 919, 1, 32, 920, 920, 2, 11, 921, 921, 2, 8, 922, 922, 2, 12, 923, 923, 1, 32, 924, 924, 2, 2, 925, 927, 1, 32, 928, 928, 2, 13, 929, 929, 2, 14, 931, 931, 2, 15, 932, 933, 1, 32, 934, 934, 2, 16, 935, 936, 1, 32, 937, 937, 2, 17, 938, 939, 1, 32, 940, 940, 1, -38, 941, 943, 1, -37, 944, 944, 1, 7219, 945, 945, 1, -32, 946, 946, 2, 9, 947, 948, 1, -32, 949, 949, 2, 10, 950, 951, 1, -32, 952, 952, 2, 11, 953, 953, 2, 8, 954, 954, 2, 12, 955, 955, 1, -32, 956, 956, 2, 2, 957, 959, 1, -32, 960, 960, 2, 13, 961, 961, 2, 14, 962, 963, 2, 15, 964, 965, 1, -32, 966, 966, 2, 16, 967, 968, 1, -32, 969, 969, 2, 17, 970, 971, 1, -32, 972, 972, 1, -64, 973, 974, 1, -63, 975, 975, 1, 8, 976, 976, 2, 9, 977, 977, 2, 11, 981, 981, 2, 16, 982, 982, 2, 13, 983, 983, 1, -8, 984, 1007, 4, 0, 1008, 1008, 2, 12, 1009, 1009, 2, 14, 1010, 1010, 1, 7, 1011, 1011, 1, -116, 1012, 1012, 2, 11, 1013, 1013, 2, 10, 1015, 1016, 3, 0, 1017, 1017, 1, -7, 1018, 1019, 4, 0, 1021, 1023, 1, -130, 1024, 1039, 1, 80, 1040, 1041, 1, 32, 1042, 1042, 2, 18, 1043, 1043, 1, 32, 1044, 1044, 2, 19, 1045, 1053, 1, 32, 1054, 1054, 2, 20, 1055, 1056, 1, 32, 1057, 1057, 2, 21, 1058, 1058, 2, 22, 1059, 1065, 1, 32, 1066, 1066, 2, 23, 1067, 1071, 1, 32, 1072, 1073, 1, -32, 1074, 1074, 2, 18, 1075, 1075, 1, -32, 1076, 1076, 2, 19, 1077, 1085, 1, -32, 1086, 1086, 2, 20, 1087, 1088, 1, -32, 1089, 1089, 2, 21, 1090, 1090, 2, 22, 1091, 1097, 1, -32, 1098, 1098, 2, 23, 1099, 1103, 1, -32, 1104, 1119, 1, -80, 1120, 1121, 4, 0, 1122, 1123, 2, 24, 1124, 1153, 4, 0, 1162, 1215, 4, 0, 1216, 1216, 1, 15, 1217, 1230, 3, 0, 1231, 1231, 1, -15, 1232, 1327, 4, 0, 1329, 1366, 1, 48, 1377, 1414, 1, -48, 4256, 4293, 1, 7264, 4295, 4295, 1, 7264, 4301, 4301, 1, 7264, 4304, 4346, 1, 3008, 4349, 4351, 1, 3008, 5024, 5103, 1, 38864, 5104, 5109, 1, 8, 5112, 5117, 1, -8, 7296, 7296, 2, 18, 7297, 7297, 2, 19, 7298, 7298, 2, 20, 7299, 7299, 2, 21, 7300, 7301, 2, 22, 7302, 7302, 2, 23, 7303, 7303, 2, 24, 7304, 7304, 2, 25, 7305, 7306, 3, 0, 7312, 7354, 1, -3008, 7357, 7359, 1, -3008, 7545, 7545, 1, 35332, 7549, 7549, 1, 3814, 7566, 7566, 1, 35384, 7680, 7775, 4, 0, 7776, 7777, 2, 26, 7778, 7829, 4, 0, 7835, 7835, 2, 26, 7838, 7838, 1, -7615, 7840, 7935, 4, 0, 7936, 7943, 1, 8, 7944, 7951, 1, -8, 7952, 7957, 1, 8, 7960, 7965, 1, -8, 7968, 7975, 1, 8, 7976, 7983, 1, -8, 7984, 7991, 1, 8, 7992, 7999, 1, -8, 8000, 8005, 1, 8, 8008, 8013, 1, -8, 8017, 8017, 1, 8, 8019, 8019, 1, 8, 8021, 8021, 1, 8, 8023, 8023, 1, 8, 8025, 8025, 1, -8, 8027, 8027, 1, -8, 8029, 8029, 1, -8, 8031, 8031, 1, -8, 8032, 8039, 1, 8, 8040, 8047, 1, -8, 8048, 8049, 1, 74, 8050, 8053, 1, 86, 8054, 8055, 1, 100, 8056, 8057, 1, 128, 8058, 8059, 1, 112, 8060, 8061, 1, 126, 8064, 8071, 1, 8, 8072, 8079, 1, -8, 8080, 8087, 1, 8, 8088, 8095, 1, -8, 8096, 8103, 1, 8, 8104, 8111, 1, -8, 8112, 8113, 1, 8, 8115, 8115, 1, 9, 8120, 8121, 1, -8, 8122, 8123, 1, -74, 8124, 8124, 1, -9, 8126, 8126, 2, 8, 8131, 8131, 1, 9, 8136, 8139, 1, -86, 8140, 8140, 1, -9, 8144, 8145, 1, 8, 8147, 8147, 1, -7235, 8152, 8153, 1, -8, 8154, 8155, 1, -100, 8160, 8161, 1, 8, 8163, 8163, 1, -7219, 8165, 8165, 1, 7, 8168, 8169, 1, -8, 8170, 8171, 1, -112, 8172, 8172, 1, -7, 8179, 8179, 1, 9, 8184, 8185, 1, -128, 8186, 8187, 1, -126, 8188, 8188, 1, -9, 8486, 8486, 2, 17, 8490, 8490, 2, 0, 8491, 8491, 2, 3, 8498, 8498, 1, 28, 8526, 8526, 1, -28, 8544, 8559, 1, 16, 8560, 8575, 1, -16, 8579, 8580, 3, 0, 9398, 9423, 1, 26, 9424, 9449, 1, -26, 11264, 11311, 1, 48, 11312, 11359, 1, -48, 11360, 11361, 4, 0, 11362, 11362, 1, -10743, 11363, 11363, 1, -3814, 11364, 11364, 1, -10727, 11365, 11365, 1, -10795, 11366, 11366, 1, -10792, 11367, 11372, 3, 0, 11373, 11373, 1, -10780, 11374, 11374, 1, -10749, 11375, 11375, 1, -10783, 11376, 11376, 1, -10782, 11378, 11379, 4, 0, 11381, 11382, 3, 0, 11390, 11391, 1, -10815, 11392, 11491, 4, 0, 11499, 11502, 3, 0, 11506, 11507, 4, 0, 11520, 11557, 1, -7264, 11559, 11559, 1, -7264, 11565, 11565, 1, -7264, 42560, 42569, 4, 0, 42570, 42571, 2, 25, 42572, 42605, 4, 0, 42624, 42651, 4, 0, 42786, 42799, 4, 0, 42802, 42863, 4, 0, 42873, 42876, 3, 0, 42877, 42877, 1, -35332, 42878, 42887, 4, 0, 42891, 42892, 3, 0, 42893, 42893, 1, -42280, 42896, 42899, 4, 0, 42900, 42900, 1, 48, 42902, 42921, 4, 0, 42922, 42922, 1, -42308, 42923, 42923, 1, -42319, 42924, 42924, 1, -42315, 42925, 42925, 1, -42305, 42926, 42926, 1, -42308, 42928, 42928, 1, -42258, 42929, 42929, 1, -42282, 42930, 42930, 1, -42261, 42931, 42931, 1, 928, 42932, 42947, 4, 0, 42948, 42948, 1, -48, 42949, 42949, 1, -42307, 42950, 42950, 1, -35384, 42951, 42954, 3, 0, 42955, 42955, 1, -42343, 42956, 42957, 4, 0, 42960, 42961, 4, 0, 42966, 42971, 4, 0, 42972, 42972, 1, -42561, 42997, 42998, 3, 0, 43859, 43859, 1, -928, 43888, 43967, 1, -38864, 64261, 64262, 3, 0, 65313, 65338, 1, 32, 65345, 65370, 1, -32, 66560, 66599, 1, 40, 66600, 66639, 1, -40, 66736, 66771, 1, 40, 66776, 66811, 1, -40, 66928, 66938, 1, 39, 66940, 66954, 1, 39, 66956, 66962, 1, 39, 66964, 66965, 1, 39, 66967, 66977, 1, -39, 66979, 66993, 1, -39, 66995, 67001, 1, -39, 67003, 67004, 1, -39, 68736, 68786, 1, 64, 68800, 68850, 1, -64, 68944, 68965, 1, 32, 68976, 68997, 1, -32, 71840, 71871, 1, 32, 71872, 71903, 1, -32, 93760, 93791, 1, 32, 93792, 93823, 1, -32, 125184, 125217, 1, 34, 125218, 125251, 1, -34});
    private static final CaseFoldEquivalenceTable UNICODE_16_0_0_JS = new CaseFoldEquivalenceTable(UNICODE_16_0_0_EQ_SIMPLE, new CodePointSet[]{CaseFoldData.rangeSet(920, 920, 952, 952, 977, 977)}, new int[]{75, 90, 1, 32, 107, 122, 1, -32, 197, 214, 1, 32, 223, 223, 1, 0, 229, 246, 1, -32, 383, 383, 1, 0, 912, 912, 1, 0, 920, 920, 2, 0, 937, 939, 1, 32, 944, 944, 1, 0, 952, 952, 2, 0, 969, 971, 1, -32, 977, 977, 2, 0, 1012, 1012, 1, 0, 7838, 7838, 1, 0, 8064, 8071, 1, 0, 8072, 8079, 1, 0, 8080, 8087, 1, 0, 8088, 8095, 1, 0, 8096, 8103, 1, 0, 8104, 8111, 1, 0, 8115, 8115, 1, 0, 8124, 8124, 1, 0, 8131, 8131, 1, 0, 8140, 8140, 1, 0, 8147, 8147, 1, 0, 8163, 8163, 1, 0, 8179, 8179, 1, 0, 8188, 8188, 1, 0, 8486, 8486, 1, 0, 8490, 8490, 1, 0, 8491, 8491, 1, 0, 64261, 64262, 1, 0, 66560, 66599, 1, 0, 66600, 66639, 1, 0, 66736, 66771, 1, 0, 66776, 66811, 1, 0, 66928, 66938, 1, 0, 66940, 66954, 1, 0, 66956, 66962, 1, 0, 66964, 66965, 1, 0, 66967, 66977, 1, 0, 66979, 66993, 1, 0, 66995, 67001, 1, 0, 67003, 67004, 1, 0, 68736, 68786, 1, 0, 68800, 68850, 1, 0, 68944, 68965, 1, 0, 68976, 68997, 1, 0, 71840, 71871, 1, 0, 71872, 71903, 1, 0, 93760, 93791, 1, 0, 93792, 93823, 1, 0, 125184, 125217, 1, 0, 125218, 125251, 1, 0});
    private static final CaseFoldEquivalenceTable UNICODE_15_1_0_PY = new CaseFoldEquivalenceTable(UNICODE_16_0_0_EQ_SIMPLE, new CodePointSet[]{CaseFoldData.rangeSet(73, 73, 105, 105, 304, 305)}, new int[]{73, 73, 2, 0, 105, 105, 2, 0, 304, 305, 2, 0, 411, 411, 1, 0, 612, 612, 1, 0, 7305, 7306, 1, 0, 42955, 42955, 1, 0, 42956, 42957, 1, 0, 42970, 42971, 1, 0, 42972, 42972, 1, 0, 68944, 68965, 1, 0, 68976, 68997, 1, 0});
    private static final CaseFoldEquivalenceTable UNICODE_15_0_0_JAVA = new CaseFoldEquivalenceTable(UNICODE_15_1_0_PY, new CodePointSet[0], new int[0]);
    private static final CaseFoldEquivalenceTable UNICODE_16_0_0_JAVA = new CaseFoldEquivalenceTable(UNICODE_16_0_0_EQ_SIMPLE, new CodePointSet[]{CaseFoldData.rangeSet(73, 73, 105, 105, 304, 305)}, new int[]{73, 73, 2, 0, 105, 105, 2, 0, 304, 305, 2, 0});
    private static final CaseFoldTable UNICODE_15_1_0_CF_FULL = new CaseFoldTable(null, new int[]{65, 90, 1, 32, 181, 181, 1, 775, 192, 214, 1, 32, 216, 222, 1, 32, 223, 223, 1, 1113962, 256, 302, 4, 0, 304, 304, 1, 1113808, 306, 310, 4, 0, 313, 327, 3, 0, 329, 329, 1, 0x10FF01, 330, 374, 4, 0, 376, 376, 1, -121, 377, 381, 3, 0, 383, 383, 1, -268, 385, 385, 1, 210, 386, 388, 4, 0, 390, 390, 1, 206, 391, 391, 3, 0, 393, 394, 1, 205, 395, 395, 3, 0, 398, 398, 1, 79, 399, 399, 1, 202, 400, 400, 1, 203, 401, 401, 3, 0, 403, 403, 1, 205, 404, 404, 1, 207, 406, 406, 1, 211, 407, 407, 1, 209, 408, 408, 4, 0, 412, 412, 1, 211, 413, 413, 1, 213, 415, 415, 1, 214, 416, 420, 4, 0, 422, 422, 1, 218, 423, 423, 3, 0, 425, 425, 1, 218, 428, 428, 4, 0, 430, 430, 1, 218, 431, 431, 3, 0, 433, 434, 1, 217, 435, 437, 3, 0, 439, 439, 1, 219, 440, 440, 4, 0, 444, 444, 4, 0, 452, 453, 7, 454, 455, 456, 7, 457, 458, 459, 7, 460, 461, 475, 3, 0, 478, 494, 4, 0, 496, 496, 1, 1113691, 497, 498, 7, 499, 500, 500, 4, 0, 502, 502, 1, -97, 503, 503, 1, -56, 504, 542, 4, 0, 544, 544, 1, -130, 546, 562, 4, 0, 570, 570, 1, 10795, 571, 571, 3, 0, 573, 573, 1, -163, 574, 574, 1, 10792, 577, 577, 3, 0, 579, 579, 1, -195, 580, 580, 1, 69, 581, 581, 1, 71, 582, 590, 4, 0, 837, 837, 1, 116, 880, 882, 4, 0, 886, 886, 4, 0, 895, 895, 1, 116, 902, 902, 1, 38, 904, 906, 1, 37, 908, 908, 1, 64, 910, 911, 1, 63, 912, 912, 1, 1113276, 913, 929, 1, 32, 931, 939, 1, 32, 944, 944, 1, 1113245, 962, 962, 4, 0, 975, 975, 1, 8, 976, 976, 1, -30, 977, 977, 1, -25, 981, 981, 1, -15, 982, 982, 1, -22, 984, 1006, 4, 0, 1008, 1008, 1, -54, 1009, 1009, 1, -48, 1012, 1012, 1, -60, 1013, 1013, 1, -64, 1015, 1015, 3, 0, 1017, 1017, 1, -7, 1018, 1018, 4, 0, 1021, 1023, 1, -130, 1024, 1039, 1, 80, 1040, 1071, 1, 32, 1120, 1152, 4, 0, 1162, 1214, 4, 0, 1216, 1216, 1, 15, 1217, 1229, 3, 0, 1232, 1326, 4, 0, 1329, 1366, 1, 48, 1415, 1415, 1, 1112775, 4256, 4293, 1, 7264, 4295, 4295, 1, 7264, 4301, 4301, 1, 7264, 5112, 5117, 1, -8, 7296, 7296, 1, -6222, 7297, 7297, 1, -6221, 7298, 7298, 1, -6212, 7299, 7300, 1, -6210, 7301, 7301, 1, -6211, 7302, 7302, 1, -6204, 7303, 7303, 1, -6180, 7304, 7304, 1, 35267, 7312, 7354, 1, -3008, 7357, 7359, 1, -3008, 7680, 7828, 4, 0, 7830, 7834, 1, 1106361, 7835, 7835, 1, -58, 7838, 7838, 1, 1106347, 7840, 7934, 4, 0, 7944, 7951, 1, -8, 7960, 7965, 1, -8, 7976, 7983, 1, -8, 7992, 7999, 1, -8, 8008, 8013, 1, -8, 8016, 8016, 1, 1106180, 8018, 8018, 1, 1106179, 8020, 8020, 1, 1106178, 8022, 8022, 1, 0x10E101, 8025, 8025, 1, -8, 8027, 8027, 1, -8, 8029, 8029, 1, -8, 8031, 8031, 1, -8, 8040, 8047, 1, -8, 8064, 8071, 1, 1106136, 8072, 8087, 1, 1106128, 8088, 8103, 1, 1106120, 8104, 8111, 1, 1106112, 8114, 8116, 1, 1106110, 8118, 8119, 1, 1106109, 8120, 8121, 1, -8, 8122, 8123, 1, -74, 8124, 8124, 1, 1106101, 8126, 8126, 1, -7173, 8130, 8132, 1, 1106099, 8134, 8135, 1, 1106098, 8136, 8139, 1, -86, 8140, 8140, 1, 1106090, 8146, 8146, 1, 1106088, 8147, 8147, 1, 1106041, 8150, 8151, 1, 1106085, 8152, 8153, 1, -8, 8154, 8155, 1, -100, 8162, 8162, 1, 1106075, 8163, 8163, 1, 1106026, 8164, 8164, 1, 1106074, 8166, 8167, 1, 1106073, 8168, 8169, 1, -8, 8170, 8171, 1, -112, 8172, 8172, 1, -7, 8178, 8180, 1, 1106063, 8182, 8183, 1, 1106062, 8184, 8185, 1, -128, 8186, 8187, 1, -126, 8188, 8188, 1, 1106054, 8486, 8486, 1, -7517, 8490, 8490, 1, -8383, 8491, 8491, 1, -8262, 8498, 8498, 1, 28, 8544, 8559, 1, 16, 8579, 8579, 3, 0, 9398, 9423, 1, 26, 11264, 11311, 1, 48, 11360, 11360, 4, 0, 11362, 11362, 1, -10743, 11363, 11363, 1, -3814, 11364, 11364, 1, -10727, 11367, 11371, 3, 0, 11373, 11373, 1, -10780, 11374, 11374, 1, -10749, 11375, 11375, 1, -10783, 11376, 11376, 1, -10782, 11378, 11378, 4, 0, 11381, 11381, 3, 0, 11390, 11391, 1, -10815, 11392, 11490, 4, 0, 11499, 11501, 3, 0, 11506, 11506, 4, 0, 42560, 42604, 4, 0, 42624, 42650, 4, 0, 42786, 42798, 4, 0, 42802, 42862, 4, 0, 42873, 42875, 3, 0, 42877, 42877, 1, -35332, 42878, 42886, 4, 0, 42891, 42891, 3, 0, 42893, 42893, 1, -42280, 42896, 42898, 4, 0, 42902, 42920, 4, 0, 42922, 42922, 1, -42308, 42923, 42923, 1, -42319, 42924, 42924, 1, -42315, 42925, 42925, 1, -42305, 42926, 42926, 1, -42308, 42928, 42928, 1, -42258, 42929, 42929, 1, -42282, 42930, 42930, 1, -42261, 42931, 42931, 1, 928, 42932, 42946, 4, 0, 42948, 42948, 1, -48, 42949, 42949, 1, -42307, 42950, 42950, 1, -35384, 42951, 42953, 3, 0, 42960, 42960, 4, 0, 42966, 42968, 4, 0, 42997, 42997, 3, 0, 43888, 43967, 1, -38864, 64256, 64261, 1, 1049990, 64262, 64262, 1, 1049989, 64275, 64279, 1, 1049977, 65313, 65338, 1, 32, 66560, 66599, 1, 40, 66736, 66771, 1, 40, 66928, 66938, 1, 39, 66940, 66954, 1, 39, 66956, 66962, 1, 39, 66964, 66965, 1, 39, 68736, 68786, 1, 64, 71840, 71871, 1, 32, 93760, 93791, 1, 32, 125184, 125217, 1, 34});
    private static final CaseFoldTable UNICODE_15_1_0_CF_SIMPLE = new CaseFoldTable(UNICODE_15_1_0_CF_FULL, new int[]{223, 223, 1, 0, 304, 304, 1, 0, 329, 329, 1, 0, 496, 496, 1, 0, 912, 912, 1, 0, 944, 944, 1, 0, 1415, 1415, 1, 0, 7830, 7834, 1, 0, 7838, 7838, 1, -7615, 8016, 8016, 1, 0, 8018, 8018, 1, 0, 8020, 8020, 1, 0, 8022, 8022, 1, 0, 8064, 8071, 1, 0, 8072, 8079, 1, -8, 8080, 8087, 1, 0, 8088, 8095, 1, -8, 8096, 8103, 1, 0, 8104, 8111, 1, -8, 8114, 8116, 1, 0, 8118, 8119, 1, 0, 8124, 8124, 1, -9, 8130, 8132, 1, 0, 8134, 8135, 1, 0, 8140, 8140, 1, -9, 8146, 8146, 1, 0, 8147, 8147, 1, -7235, 8150, 8151, 1, 0, 8162, 8162, 1, 0, 8163, 8163, 1, -7219, 8164, 8164, 1, 0, 8166, 8167, 1, 0, 8178, 8180, 1, 0, 8182, 8183, 1, 0, 8188, 8188, 1, -9, 64256, 64260, 1, 0, 64261, 64261, 3, 0, 64262, 64262, 1, 0, 64275, 64279, 1, 0});
    private static final CaseFoldTable UNICODE_16_0_0_CF_SIMPLE = new CaseFoldTable(UNICODE_15_1_0_CF_SIMPLE, new int[]{7305, 7305, 3, 0, 42955, 42955, 1, -42343, 42956, 42956, 4, 0, 42969, 42970, 4, 0, 42972, 42972, 1, -42561, 68944, 68965, 1, 32});
    private static final CaseFoldTable UNICODE_15_0_0_ODB_FULL = new CaseFoldTable(UNICODE_15_1_0_CF_FULL, new int[]{8072, 8079, 1, -8, 8088, 8095, 1, -8, 8104, 8111, 1, -8, 8124, 8124, 1, -9, 8140, 8140, 1, -9, 8188, 8188, 1, -9});
    private static final CaseFoldTable UNICODE_15_0_0_ODB_SIMPLE = new CaseFoldTable(UNICODE_15_1_0_CF_SIMPLE, new int[]{181, 181, 1, 0, 304, 304, 1, -199, 383, 383, 1, 0, 837, 837, 1, 0, 962, 962, 1, 0, 976, 976, 1, 0, 977, 977, 1, 0, 981, 981, 1, 0, 982, 982, 1, 0, 1008, 1008, 1, 0, 1009, 1009, 1, 0, 1013, 1013, 1, 0, 5024, 5103, 1, 38864, 5104, 5109, 1, 8, 5112, 5117, 1, 0, 7296, 7296, 1, 0, 7297, 7297, 1, 0, 7298, 7298, 1, 0, 7299, 7300, 1, 0, 7301, 7301, 1, 0, 7302, 7302, 1, 0, 7303, 7303, 1, 0, 7304, 7304, 1, 0, 7835, 7835, 1, 0, 8126, 8126, 1, 0, 8147, 8147, 1, 0, 8163, 8163, 1, 0, 43888, 43967, 1, 0, 64261, 64261, 1, 0});
    private static final CaseFoldTable UNICODE_15_0_0_ODB_AI = new CaseFoldTable(null, new int[]{65, 90, 1, 32, 132, 132, 4, 0, 169, 169, 1, -70, 170, 170, 1, -73, 174, 174, 1, -60, 178, 179, 1, -128, 181, 181, 1, 775, 185, 185, 1, -136, 186, 186, 1, -75, 192, 197, 7, 97, 198, 198, 1, 32, 199, 199, 1, -100, 200, 203, 7, 101, 204, 207, 7, 105, 208, 208, 1, 32, 209, 210, 1, -99, 211, 214, 7, 111, 216, 216, 1, -105, 217, 220, 7, 117, 221, 221, 1, -100, 222, 222, 1, 32, 223, 223, 1, 1113962, 224, 229, 7, 97, 231, 231, 1, -132, 232, 235, 7, 101, 236, 239, 7, 105, 241, 242, 1, -131, 243, 246, 7, 111, 248, 248, 1, -137, 249, 252, 7, 117, 253, 253, 1, -132, 255, 255, 1, -134, 256, 261, 7, 97, 262, 269, 7, 99, 270, 273, 7, 100, 274, 283, 7, 101, 284, 291, 7, 103, 292, 295, 7, 104, 296, 305, 7, 105, 306, 307, 7, 0x110091, 308, 309, 7, 106, 310, 312, 7, 107, 313, 320, 7, 108, 321, 321, 3, 0, 322, 322, 1, -214, 323, 328, 7, 110, 330, 330, 4, 0, 332, 337, 7, 111, 338, 339, 7, 1114258, 340, 345, 7, 114, 346, 353, 7, 115, 354, 357, 7, 116, 358, 358, 4, 0, 359, 360, 1, -243, 361, 371, 7, 117, 372, 373, 7, 119, 374, 376, 7, 121, 377, 382, 7, 122, 383, 383, 1, -268, 385, 385, 1, 210, 386, 388, 4, 0, 390, 390, 1, 206, 391, 391, 3, 0, 393, 394, 1, 205, 395, 395, 3, 0, 398, 398, 1, 79, 399, 399, 1, 202, 400, 400, 1, 203, 401, 401, 3, 0, 403, 403, 1, 205, 404, 404, 1, 207, 406, 406, 1, 211, 407, 407, 1, 209, 408, 408, 4, 0, 412, 412, 1, 211, 413, 413, 1, 213, 415, 415, 1, 214, 416, 417, 7, 111, 418, 420, 4, 0, 422, 422, 1, 218, 423, 423, 3, 0, 425, 425, 1, 218, 428, 428, 4, 0, 430, 430, 1, 218, 431, 432, 7, 117, 433, 434, 1, 217, 435, 437, 3, 0, 439, 439, 1, 219, 440, 440, 4, 0, 444, 444, 4, 0, 452, 454, 7, 499, 455, 457, 7, 1114259, 458, 460, 7, 1114260, 461, 462, 7, 97, 463, 464, 7, 105, 465, 466, 7, 111, 467, 476, 7, 117, 478, 481, 7, 97, 482, 483, 7, 230, 484, 484, 4, 0, 486, 487, 7, 103, 488, 489, 7, 107, 490, 493, 7, 111, 494, 494, 1, -55, 495, 495, 1, 163, 496, 496, 1, -390, 497, 499, 7, 1114261, 500, 501, 7, 103, 502, 502, 1, -97, 503, 503, 1, -56, 504, 505, 7, 110, 506, 507, 7, 97, 508, 509, 7, 230, 510, 511, 7, 111, 512, 515, 7, 97, 516, 519, 7, 101, 520, 523, 7, 105, 524, 527, 7, 111, 528, 531, 7, 114, 532, 535, 7, 117, 536, 537, 7, 115, 538, 539, 7, 116, 540, 540, 4, 0, 542, 543, 7, 104, 546, 548, 4, 0, 550, 551, 7, 97, 552, 553, 7, 101, 554, 561, 7, 111, 562, 563, 7, 121, 675, 680, 1, 1113586, 688, 688, 1, -584, 689, 689, 1, -75, 690, 690, 1, -584, 691, 691, 1, -577, 692, 692, 1, -59, 693, 693, 1, -58, 694, 694, 1, -53, 695, 695, 1, -576, 696, 696, 1, -575, 736, 736, 1, -125, 737, 737, 1, -629, 738, 738, 1, -623, 740, 740, 1, -79, 836, 836, 1, -60, 901, 901, 1, -733, 902, 902, 1, 43, 904, 904, 1, 45, 905, 905, 1, 46, 906, 906, 1, 47, 908, 908, 1, 51, 910, 910, 1, 55, 911, 911, 1, 58, 912, 912, 1, 41, 913, 929, 1, 32, 931, 937, 1, 32, 938, 938, 1, 15, 939, 939, 1, 26, 940, 940, 1, 5, 941, 941, 1, 8, 942, 942, 1, 9, 943, 943, 1, 10, 944, 944, 1, 21, 962, 962, 4, 0, 970, 970, 1, -17, 971, 971, 1, -6, 972, 972, 1, -13, 973, 973, 1, -8, 974, 974, 1, -5, 976, 976, 1, -30, 977, 977, 1, -25, 978, 980, 7, 965, 981, 981, 1, -15, 982, 982, 1, -22, 986, 1006, 4, 0, 1008, 1008, 1, -54, 1009, 1009, 1, -48, 1010, 1010, 1, -47, 1012, 1012, 1, -60, 1024, 1025, 7, 1077, 1026, 1026, 1, 80, 1027, 1027, 1, 48, 1028, 1030, 1, 80, 1031, 1031, 1, 79, 1032, 1035, 1, 80, 1036, 1036, 1, 46, 1037, 1037, 1, 43, 1038, 1038, 1, 53, 1039, 1039, 1, 80, 1040, 1048, 1, 32, 1049, 1049, 1, 31, 1050, 1071, 1, 32, 1081, 1081, 5, 0, 1104, 1105, 7, 1077, 1107, 1107, 1, -32, 1111, 1111, 5, 0, 1116, 1116, 1, -34, 1117, 1117, 1, -37, 1118, 1118, 1, -27, 1120, 1140, 4, 0, 1142, 1142, 6, 0, 1143, 1143, 1, -2, 1144, 1152, 4, 0, 1164, 1166, 4, 0, 1168, 1169, 7, 1075, 1170, 1214, 4, 0, 1217, 1218, 7, 1078, 1219, 1219, 3, 0, 1223, 1223, 3, 0, 1227, 1227, 3, 0, 1232, 1235, 7, 1072, 1236, 1236, 4, 0, 1238, 1239, 7, 1077, 1240, 1240, 4, 0, 1242, 1242, 6, 0, 1243, 1243, 1, -2, 1244, 1245, 7, 1078, 1246, 1247, 7, 1079, 1248, 1248, 4, 0, 1250, 1253, 7, 1080, 1254, 1255, 7, 1086, 1256, 1256, 4, 0, 1258, 1258, 6, 0, 1259, 1259, 1, -2, 1260, 1261, 7, 1101, 1262, 1267, 7, 1091, 1268, 1269, 7, 1095, 1272, 1273, 7, 1099, 1329, 1366, 1, 48, 1498, 1498, 4, 0, 1501, 1503, 3, 0, 1507, 1509, 3, 0, 1570, 1571, 7, 1575, 1572, 1572, 1, 36, 1573, 1573, 1, 2, 1574, 1574, 1, 36, 1632, 1641, 1, -1584, 1728, 1728, 1, 21, 1730, 1730, 6, 0, 1747, 1747, 5, 0, 1776, 1785, 1, -1728, 2345, 2345, 5, 0, 2353, 2353, 5, 0, 2356, 2356, 6, 0, 2507, 2508, 7, 2503, 2888, 2888, 6, 0, 2891, 2892, 7, 2887, 2964, 2964, 1, -2, 3018, 3019, 1, -4, 3020, 3020, 1, -6, 3144, 3144, 1, -2, 3264, 3264, 6, 0, 3271, 3271, 5, 0, 3272, 3272, 1, -2, 3274, 3275, 7, 3270, 3402, 3403, 1, -4, 3404, 3404, 1, -6, 3546, 3546, 6, 0, 3548, 3550, 7, 3545, 3955, 3955, 1, -2, 3957, 3957, 1, -4, 3969, 3969, 1, -16, 4134, 4134, 6, 0, 4256, 4293, 1, 48, 7680, 7681, 7, 97, 7682, 7687, 7, 98, 7688, 7689, 7, 99, 7690, 7699, 7, 100, 7700, 7709, 7, 101, 7710, 7711, 7, 102, 7712, 7713, 7, 103, 7714, 7723, 7, 104, 7724, 7727, 7, 105, 7728, 7733, 7, 107, 7734, 7741, 7, 108, 7742, 7747, 7, 109, 7748, 7755, 7, 110, 7756, 7763, 7, 111, 7764, 7767, 7, 112, 7768, 7775, 7, 114, 7776, 7785, 7, 115, 7786, 7793, 7, 116, 7794, 7803, 7, 117, 7804, 7807, 7, 118, 7808, 7817, 7, 119, 7818, 7821, 7, 120, 7822, 7823, 7, 121, 7824, 7829, 7, 122, 7830, 7830, 1, -7726, 7831, 7831, 1, -7715, 7832, 7832, 1, -7713, 7833, 7833, 1, -7712, 7834, 7834, 1, 1106361, 7835, 7835, 1, -7720, 7840, 7863, 7, 97, 7864, 7879, 7, 101, 7880, 7883, 7, 105, 7884, 7907, 7, 111, 7908, 7921, 7, 117, 7922, 7929, 7, 121, 7936, 7951, 7, 945, 7952, 7957, 7, 949, 7960, 7965, 7, 949, 7968, 7983, 7, 951, 7984, 7999, 7, 953, 8000, 8005, 7, 959, 8008, 8013, 7, 959, 8016, 8023, 7, 965, 8025, 8025, 1, -7060, 8027, 8027, 1, -7062, 8029, 8029, 1, -7064, 8031, 8031, 1, -7066, 8032, 8047, 7, 969, 8048, 8048, 1, -7103, 8050, 8050, 1, -7101, 8052, 8052, 1, -7101, 8054, 8054, 1, -7101, 8056, 8056, 1, -7097, 8058, 8058, 1, -7093, 8060, 8060, 1, -7091, 8064, 8079, 7, 945, 8080, 8095, 7, 951, 8096, 8111, 7, 969, 8112, 8116, 7, 945, 8118, 8122, 7, 945, 8123, 8123, 1, -74, 8124, 8124, 1, -7179, 8126, 8126, 1, -7173, 8129, 8129, 1, -7961, 8130, 8132, 7, 951, 8134, 8135, 7, 951, 8136, 8136, 1, -7187, 8137, 8137, 1, -86, 8138, 8138, 1, -7187, 8139, 8139, 1, -86, 8140, 8140, 1, -7189, 8141, 8143, 7, 8127, 8144, 8146, 7, 953, 8150, 8154, 7, 953, 8155, 8155, 1, -100, 8157, 8159, 7, 8190, 8160, 8162, 7, 965, 8164, 8165, 7, 961, 8166, 8170, 7, 965, 8171, 8171, 1, -112, 8172, 8172, 1, -7211, 8173, 8173, 1, -8005, 8178, 8180, 7, 969, 8182, 8183, 7, 969, 8184, 8184, 1, -7225, 8185, 8185, 1, -128, 8186, 8186, 1, -7217, 8187, 8187, 1, -126, 8188, 8188, 1, -7219, 8304, 8304, 1, -8256, 8308, 8313, 1, -8256, 8319, 8319, 1, -8209, 8320, 8329, 1, -8272, 8450, 8451, 7, 99, 8453, 8453, 1, 1105814, 8457, 8459, 1, -8355, 8460, 8463, 7, 104, 8464, 8465, 7, 105, 8466, 8467, 7, 108, 8469, 8469, 1, -8359, 8470, 8470, 1, 1105798, 8473, 8475, 1, -8361, 8476, 8477, 7, 114, 8480, 8482, 1, 1105789, 8484, 8484, 1, -8362, 8486, 8486, 1, -7517, 8488, 8488, 1, -8366, 8490, 8490, 1, -8383, 8491, 8492, 1, -8394, 8495, 8496, 7, 101, 8497, 8497, 1, -8395, 8499, 8499, 1, -8390, 8500, 8500, 1, -8389, 8543, 8543, 1, -8494, 8544, 8544, 1, -8439, 8545, 8547, 1, 1105727, 8548, 8548, 1, -8430, 8549, 8552, 1, 1105726, 8553, 8553, 1, -8433, 8554, 8555, 1, 1105725, 8556, 8556, 1, -8448, 8557, 8558, 1, -8458, 8559, 8559, 1, -8450, 8560, 8560, 1, -8455, 8561, 8563, 1, 1105711, 8564, 8564, 1, -8446, 8565, 8568, 1, 1105710, 8569, 8569, 1, -8449, 8570, 8571, 1, 1105709, 8572, 8572, 1, -8464, 8573, 8574, 1, -8474, 8575, 8575, 1, -8466, 8602, 8602, 1, -10, 8603, 8603, 1, -9, 8622, 8622, 1, -26, 8653, 8653, 1, 3, 8654, 8654, 1, 6, 8655, 8655, 1, 3, 8708, 8708, 6, 0, 8713, 8713, 5, 0, 8716, 8716, 6, 0, 8738, 8738, 4, 0, 8740, 8742, 6, 0, 8769, 8769, 1, -5, 8772, 8772, 6, 0, 8775, 8775, 1, -2, 8777, 8777, 5, 0, 8800, 8800, 1, -8739, 8802, 8802, 6, 0, 8813, 8813, 1, -32, 8814, 8814, 1, -8754, 8815, 8815, 1, -8753, 8816, 8817, 1, -12, 8820, 8821, 1, -2, 8824, 8825, 1, -2, 8832, 8833, 1, -6, 8836, 8837, 1, -2, 8840, 8841, 1, -2, 8876, 8876, 1, -10, 8877, 8878, 1, -5, 8879, 8879, 1, -4, 8928, 8929, 1, -100, 8930, 8931, 1, -81, 8938, 8941, 1, -56, 9312, 9320, 1, -9263, 9332, 9340, 1, -9283, 9352, 9360, 1, -9303, 9372, 9397, 1, -9275, 9398, 9423, 1, -9301, 9424, 9449, 1, -9327, 9450, 9450, 1, -9402, 10109, 10110, 1, -10053, 10119, 10120, 1, -10063, 10129, 10130, 1, -10073, 12295, 12295, 1, -12247, 12321, 12329, 1, -12272, 12364, 12386, 6, 0, 12389, 12393, 5, 0, 12400, 12400, 6, 0, 12401, 12401, 1, -2, 12403, 12403, 5, 0, 12404, 12404, 1, -2, 12406, 12406, 6, 0, 12407, 12407, 1, -2, 12409, 12409, 5, 0, 12410, 12410, 1, -2, 12412, 12412, 6, 0, 12413, 12413, 1, -2, 12436, 12436, 1, -78, 12446, 12446, 6, 0, 12460, 12482, 6, 0, 12485, 12489, 5, 0, 12496, 12496, 6, 0, 12497, 12497, 1, -2, 12499, 12499, 5, 0, 12500, 12500, 1, -2, 12502, 12502, 6, 0, 12503, 12503, 1, -2, 12505, 12505, 5, 0, 12506, 12506, 1, -2, 12508, 12508, 6, 0, 12509, 12509, 1, -2, 12532, 12532, 1, -78, 12535, 12538, 1, -8, 12542, 12542, 6, 0, 63714, 63715, 7, 1102, 63716, 63717, 7, 1099, 63718, 63719, 7, 1098, 63720, 63721, 7, 1091, 63722, 63723, 7, 1086, 63724, 63725, 7, 1080, 63726, 63727, 7, 1101, 63728, 63729, 7, 1072, 63734, 63734, 1, -63615, 63735, 63735, 1, -63625, 63736, 63736, 1, -63631, 63737, 63737, 1, -63618, 63738, 63738, 1, -63633, 64256, 64256, 1, 1050025, 64257, 64261, 1, 1049990, 64262, 64262, 1, 1049989, 65296, 65305, 1, -65248, 65313, 65338, 1, -65216, 65345, 65370, 1, -65248, 66560, 66597, 1, 40});
    public static final CodePointSet FOLDABLE_CHARACTERS = CaseFoldData.rangeSet(65, 90, 181, 181, 192, 214, 216, 222, 256, 256, 258, 258, 260, 260, 262, 262, 264, 264, 266, 266, 268, 268, 270, 270, 272, 272, 274, 274, 276, 276, 278, 278, 280, 280, 282, 282, 284, 284, 286, 286, 288, 288, 290, 290, 292, 292, 294, 294, 296, 296, 298, 298, 300, 300, 302, 302, 306, 306, 308, 308, 310, 310, 313, 313, 315, 315, 317, 317, 319, 319, 321, 321, 323, 323, 325, 325, 327, 327, 330, 330, 332, 332, 334, 334, 336, 336, 338, 338, 340, 340, 342, 342, 344, 344, 346, 346, 348, 348, 350, 350, 352, 352, 354, 354, 356, 356, 358, 358, 360, 360, 362, 362, 364, 364, 366, 366, 368, 368, 370, 370, 372, 372, 374, 374, 376, 377, 379, 379, 381, 381, 383, 383, 385, 386, 388, 388, 390, 391, 393, 395, 398, 401, 403, 404, 406, 408, 412, 413, 415, 416, 418, 418, 420, 420, 422, 423, 425, 425, 428, 428, 430, 431, 433, 435, 437, 437, 439, 440, 444, 444, 452, 453, 455, 456, 458, 459, 461, 461, 463, 463, 465, 465, 467, 467, 469, 469, 471, 471, 473, 473, 475, 475, 478, 478, 480, 480, 482, 482, 484, 484, 486, 486, 488, 488, 490, 490, 492, 492, 494, 494, 497, 498, 500, 500, 502, 504, 506, 506, 508, 508, 510, 510, 512, 512, 514, 514, 516, 516, 518, 518, 520, 520, 522, 522, 524, 524, 526, 526, 528, 528, 530, 530, 532, 532, 534, 534, 536, 536, 538, 538, 540, 540, 542, 542, 544, 544, 546, 546, 548, 548, 550, 550, 552, 552, 554, 554, 556, 556, 558, 558, 560, 560, 562, 562, 570, 571, 573, 574, 577, 577, 579, 582, 584, 584, 586, 586, 588, 588, 590, 590, 837, 837, 880, 880, 882, 882, 886, 886, 895, 895, 902, 902, 904, 906, 908, 908, 910, 911, 913, 929, 931, 939, 962, 962, 975, 977, 981, 982, 984, 984, 986, 986, 988, 988, 990, 990, 992, 992, 994, 994, 996, 996, 998, 998, 1000, 1000, 1002, 1002, 1004, 1004, 1006, 1006, 1008, 1009, 1012, 1013, 1015, 1015, 1017, 1018, 1021, 1071, 1120, 1120, 1122, 1122, 1124, 1124, 1126, 1126, 1128, 1128, 1130, 1130, 1132, 1132, 1134, 1134, 1136, 1136, 1138, 1138, 1140, 1140, 1142, 1142, 1144, 1144, 1146, 1146, 1148, 1148, 1150, 1150, 1152, 1152, 1162, 1162, 1164, 1164, 1166, 1166, 1168, 1168, 1170, 1170, 1172, 1172, 1174, 1174, 1176, 1176, 1178, 1178, 1180, 1180, 1182, 1182, 1184, 1184, 1186, 1186, 1188, 1188, 1190, 1190, 1192, 1192, 1194, 1194, 1196, 1196, 1198, 1198, 1200, 1200, 1202, 1202, 1204, 1204, 1206, 1206, 1208, 1208, 1210, 1210, 1212, 1212, 1214, 1214, 1216, 1217, 1219, 1219, 1221, 1221, 1223, 1223, 1225, 1225, 1227, 1227, 1229, 1229, 1232, 1232, 1234, 1234, 1236, 1236, 1238, 1238, 1240, 1240, 1242, 1242, 1244, 1244, 1246, 1246, 1248, 1248, 1250, 1250, 1252, 1252, 1254, 1254, 1256, 1256, 1258, 1258, 1260, 1260, 1262, 1262, 1264, 1264, 1266, 1266, 1268, 1268, 1270, 1270, 1272, 1272, 1274, 1274, 1276, 1276, 1278, 1278, 1280, 1280, 1282, 1282, 1284, 1284, 1286, 1286, 1288, 1288, 1290, 1290, 1292, 1292, 1294, 1294, 1296, 1296, 1298, 1298, 1300, 1300, 1302, 1302, 1304, 1304, 1306, 1306, 1308, 1308, 1310, 1310, 1312, 1312, 1314, 1314, 1316, 1316, 1318, 1318, 1320, 1320, 1322, 1322, 1324, 1324, 1326, 1326, 1329, 1366, 4256, 4293, 4295, 4295, 4301, 4301, 5112, 5117, 7296, 7305, 7312, 7354, 7357, 7359, 7680, 7680, 7682, 7682, 7684, 7684, 7686, 7686, 7688, 7688, 7690, 7690, 7692, 7692, 7694, 7694, 7696, 7696, 7698, 7698, 7700, 7700, 7702, 7702, 7704, 7704, 7706, 7706, 7708, 7708, 7710, 7710, 7712, 7712, 7714, 7714, 7716, 7716, 7718, 7718, 7720, 7720, 7722, 7722, 7724, 7724, 7726, 7726, 7728, 7728, 7730, 7730, 7732, 7732, 7734, 7734, 7736, 7736, 7738, 7738, 7740, 7740, 7742, 7742, 7744, 7744, 7746, 7746, 7748, 7748, 7750, 7750, 7752, 7752, 7754, 7754, 7756, 7756, 7758, 7758, 7760, 7760, 7762, 7762, 7764, 7764, 7766, 7766, 7768, 7768, 7770, 7770, 7772, 7772, 7774, 7774, 7776, 7776, 7778, 7778, 7780, 7780, 7782, 7782, 7784, 7784, 7786, 7786, 7788, 7788, 7790, 7790, 7792, 7792, 7794, 7794, 7796, 7796, 7798, 7798, 7800, 7800, 7802, 7802, 7804, 7804, 7806, 7806, 7808, 7808, 7810, 7810, 7812, 7812, 7814, 7814, 7816, 7816, 7818, 7818, 7820, 7820, 7822, 7822, 7824, 7824, 7826, 7826, 7828, 7828, 7835, 7835, 7838, 7838, 7840, 7840, 7842, 7842, 7844, 7844, 7846, 7846, 7848, 7848, 7850, 7850, 7852, 7852, 7854, 7854, 7856, 7856, 7858, 7858, 7860, 7860, 7862, 7862, 7864, 7864, 7866, 7866, 7868, 7868, 7870, 7870, 7872, 7872, 7874, 7874, 7876, 7876, 7878, 7878, 7880, 7880, 7882, 7882, 7884, 7884, 7886, 7886, 7888, 7888, 7890, 7890, 7892, 7892, 7894, 7894, 7896, 7896, 7898, 7898, 7900, 7900, 7902, 7902, 7904, 7904, 7906, 7906, 7908, 7908, 7910, 7910, 7912, 7912, 7914, 7914, 7916, 7916, 7918, 7918, 7920, 7920, 7922, 7922, 7924, 7924, 7926, 7926, 7928, 7928, 7930, 7930, 7932, 7932, 7934, 7934, 7944, 7951, 7960, 7965, 7976, 7983, 7992, 7999, 8008, 8013, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8031, 8040, 8047, 8072, 8079, 8088, 8095, 8104, 8111, 8120, 8124, 8126, 8126, 8136, 8140, 8147, 8147, 8152, 8155, 8163, 8163, 8168, 8172, 8184, 8188, 8486, 8486, 8490, 8491, 8498, 8498, 8544, 8559, 8579, 8579, 9398, 9423, 11264, 11311, 11360, 11360, 11362, 11364, 11367, 11367, 11369, 11369, 11371, 11371, 11373, 11376, 11378, 11378, 11381, 11381, 11390, 11392, 11394, 11394, 11396, 11396, 11398, 11398, 11400, 11400, 11402, 11402, 11404, 11404, 11406, 11406, 11408, 11408, 11410, 11410, 11412, 11412, 11414, 11414, 11416, 11416, 11418, 11418, 11420, 11420, 11422, 11422, 11424, 11424, 11426, 11426, 11428, 11428, 11430, 11430, 11432, 11432, 11434, 11434, 11436, 11436, 11438, 11438, 11440, 11440, 11442, 11442, 11444, 11444, 11446, 11446, 11448, 11448, 11450, 11450, 11452, 11452, 11454, 11454, 11456, 11456, 11458, 11458, 11460, 11460, 11462, 11462, 11464, 11464, 11466, 11466, 11468, 11468, 11470, 11470, 11472, 11472, 11474, 11474, 11476, 11476, 11478, 11478, 11480, 11480, 11482, 11482, 11484, 11484, 11486, 11486, 11488, 11488, 11490, 11490, 11499, 11499, 11501, 11501, 11506, 11506, 42560, 42560, 42562, 42562, 42564, 42564, 42566, 42566, 42568, 42568, 42570, 42570, 42572, 42572, 42574, 42574, 42576, 42576, 42578, 42578, 42580, 42580, 42582, 42582, 42584, 42584, 42586, 42586, 42588, 42588, 42590, 42590, 42592, 42592, 42594, 42594, 42596, 42596, 42598, 42598, 42600, 42600, 42602, 42602, 42604, 42604, 42624, 42624, 42626, 42626, 42628, 42628, 42630, 42630, 42632, 42632, 42634, 42634, 42636, 42636, 42638, 42638, 42640, 42640, 42642, 42642, 42644, 42644, 42646, 42646, 42648, 42648, 42650, 42650, 42786, 42786, 42788, 42788, 42790, 42790, 42792, 42792, 42794, 42794, 42796, 42796, 42798, 42798, 42802, 42802, 42804, 42804, 42806, 42806, 42808, 42808, 42810, 42810, 42812, 42812, 42814, 42814, 42816, 42816, 42818, 42818, 42820, 42820, 42822, 42822, 42824, 42824, 42826, 42826, 42828, 42828, 42830, 42830, 42832, 42832, 42834, 42834, 42836, 42836, 42838, 42838, 42840, 42840, 42842, 42842, 42844, 42844, 42846, 42846, 42848, 42848, 42850, 42850, 42852, 42852, 42854, 42854, 42856, 42856, 42858, 42858, 42860, 42860, 42862, 42862, 42873, 42873, 42875, 42875, 42877, 42878, 42880, 42880, 42882, 42882, 42884, 42884, 42886, 42886, 42891, 42891, 42893, 42893, 42896, 42896, 42898, 42898, 42902, 42902, 42904, 42904, 42906, 42906, 42908, 42908, 42910, 42910, 42912, 42912, 42914, 42914, 42916, 42916, 42918, 42918, 42920, 42920, 42922, 42926, 42928, 42932, 42934, 42934, 42936, 42936, 42938, 42938, 42940, 42940, 42942, 42942, 42944, 42944, 42946, 42946, 42948, 42951, 42953, 42953, 42955, 42956, 42960, 42960, 42966, 42966, 42968, 42968, 42970, 42970, 42972, 42972, 42997, 42997, 43888, 43967, 64261, 64261, 65313, 65338, 66560, 66599, 66736, 66771, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 68736, 68786, 68944, 68965, 71840, 71871, 93760, 93791, 125184, 125217);
    private static final CaseUnfoldingTrie UNFOLDING_TRIE_RUBY = CaseFoldData.getTable(CaseFoldAlgorithm.Ruby).createCaseUnfoldTrie();
    private static final CaseUnfoldingTrie UNFOLDING_TRIE_ORACLE_DB = CaseFoldData.getTable(CaseFoldAlgorithm.OracleDB).createCaseUnfoldTrie();
    private static final CaseUnfoldingTrie UNFOLDING_TRIE_ORACLE_DB_AI = CaseFoldData.getTable(CaseFoldAlgorithm.OracleDBAI).createCaseUnfoldTrie();
    public static final CodePointSet FOLDED_CHARACTERS = FOLDABLE_CHARACTERS.createInverse(Encodings.UTF_32);

    private static CaseFoldEquivalenceTable getTable(CaseFoldUnfoldAlgorithm algorithm) {
        switch (algorithm.ordinal()) {
            case 1: {
                return UNICODE_16_0_0_JS;
            }
            case 2: {
                return UNICODE_16_0_0_EQ_SIMPLE;
            }
            case 0: {
                return ASCII;
            }
            case 3: {
                return UNICODE_15_0_0_JAVA;
            }
            case 4: {
                return UNICODE_16_0_0_JAVA;
            }
            case 6: {
                return UNICODE_15_1_0_PY;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public static CaseFoldTable getTable(CaseFoldAlgorithm algorithm) {
        switch (algorithm.ordinal()) {
            case 0: 
            case 2: {
                return UNICODE_16_0_0_CF_SIMPLE;
            }
            case 1: 
            case 3: {
                return UNICODE_15_1_0_CF_SIMPLE;
            }
            case 4: {
                return UNICODE_15_1_0_CF_FULL;
            }
            case 5: {
                return UNICODE_15_0_0_ODB_FULL;
            }
            case 6: {
                return UNICODE_15_0_0_ODB_SIMPLE;
            }
            case 7: {
                return UNICODE_15_0_0_ODB_AI;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public static CaseUnfoldingTrie getUnfoldingTrie(CaseFoldAlgorithm algorithm) {
        switch (algorithm.ordinal()) {
            case 4: {
                return UNFOLDING_TRIE_RUBY;
            }
            case 5: {
                return UNFOLDING_TRIE_ORACLE_DB;
            }
            case 7: {
                return UNFOLDING_TRIE_ORACLE_DB_AI;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public static String simpleCaseFold(CaseFoldAlgorithm algorithm, String string) {
        int[] folded = string.codePoints().map(c -> CaseFoldData.simpleCaseFold(algorithm, c)).toArray();
        return new String(folded, 0, folded.length);
    }

    public static int simpleCaseFold(CaseFoldAlgorithm algorithm, int codepoint) {
        int[] caseFolded = CaseFoldData.getTable(algorithm).caseFold(codepoint);
        assert (caseFolded == null || caseFolded.length == 1);
        return caseFolded == null ? codepoint : caseFolded[0];
    }

    static CodePointSet rangeSet(int ... ranges) {
        return CodePointSet.createNoDedup(ranges);
    }

    public static void applyCaseFoldUnfold(CodePointSetAccumulator codePointSet, CodePointSetAccumulator tmp, CaseFoldUnfoldAlgorithm algorithm) {
        codePointSet.copyTo(tmp);
        CaseFoldData.getTable(algorithm).applyCaseFold(codePointSet, tmp);
    }

    public static CodePointSet simpleCaseFold(CodePointSet codePointSet, CodePointSetAccumulator tmp) {
        tmp.addSet(codePointSet);
        UNICODE_16_0_0_EQ_SIMPLE.applyCaseFold(tmp, codePointSet);
        tmp.intersectWith(FOLDED_CHARACTERS);
        return tmp.toCodePointSet();
    }

    public static enum CaseFoldUnfoldAlgorithm {
        Ascii,
        ECMAScriptNonUnicode,
        ECMAScriptUnicode,
        JavaUnicode15,
        JavaUnicode16,
        OracleDBSimple,
        PythonUnicode;


        public BiPredicate<Integer, Integer> getEqualsPredicate() {
            return (codePointA, codePointB) -> CaseFoldData.getTable(this).equalsIgnoreCase((int)codePointA, (int)codePointB);
        }
    }

    public static final class CaseFoldEquivalenceTable
    implements SortedListOfRanges {
        private final CaseFoldEquivalenceTable parent;
        private final CodePointSet[] directMappings;
        private final int[] ranges;

        CaseFoldEquivalenceTable(CaseFoldEquivalenceTable parent, CodePointSet[] directMappings, int[] ranges) {
            this.parent = parent;
            this.directMappings = directMappings;
            this.ranges = ranges;
        }

        void applyCaseFold(CodePointSetAccumulator dst, Iterable<Range> src) {
            for (Range r : src) {
                this.applyCaseFold(dst, r);
            }
        }

        private void applyCaseFold(CodePointSetAccumulator dst, Range r) {
            int search = this.binarySearch(r.lo);
            if (this.binarySearchExactMatch(search, r.lo, r.hi)) {
                this.apply(dst, search, r.lo, r.hi);
                return;
            }
            int firstIntersection = this.binarySearchGetFirstIntersecting(search, r.lo, r.hi);
            if (this.binarySearchNoIntersectingFound(firstIntersection)) {
                if (this.parent != null) {
                    this.parent.applyCaseFold(dst, r);
                }
                return;
            }
            int lastIntersectionHi = r.lo - 1;
            for (int j = firstIntersection; j < this.size() && !this.rightOf(j, r.lo, r.hi); ++j) {
                assert (this.intersects(j, r.lo, r.hi));
                int intersectionLo = Math.max(this.getLo(j), r.lo);
                int intersectionHi = Math.min(this.getHi(j), r.hi);
                this.apply(dst, j, intersectionLo, intersectionHi);
                if (this.parent != null && intersectionLo > lastIntersectionHi + 1) {
                    this.parent.applyCaseFold(dst, new Range(lastIntersectionHi + 1, intersectionLo - 1));
                }
                lastIntersectionHi = intersectionHi;
            }
            if (this.parent != null && r.hi > lastIntersectionHi) {
                this.parent.applyCaseFold(dst, new Range(lastIntersectionHi + 1, r.hi));
            }
        }

        private void apply(CodePointSetAccumulator codePointSet, int tblEntryIndex, int intersectionLo, int intersectionHi) {
            switch (this.ranges[tblEntryIndex * 4 + 2]) {
                case 1: {
                    int delta = this.ranges[tblEntryIndex * 4 + 3];
                    CaseFoldEquivalenceTable.addRange(codePointSet, intersectionLo + delta, intersectionHi + delta);
                    break;
                }
                case 2: {
                    CodePointSet set = this.directMappings[this.ranges[tblEntryIndex * 4 + 3]];
                    assert (set.getMax() <= 0x10FFFF) : "CaseFoldEquivalenceTable is currently used for single-character mappings only";
                    codePointSet.addSet(set);
                    break;
                }
                case 3: {
                    int loUL = Math.min((intersectionLo - 1 ^ 1) + 1, (intersectionHi - 1 ^ 1) + 1);
                    int hiUL = Math.max((intersectionLo - 1 ^ 1) + 1, (intersectionHi - 1 ^ 1) + 1);
                    if (SortedListOfRanges.contains(intersectionLo, intersectionHi, loUL, hiUL)) break;
                    CaseFoldEquivalenceTable.addRange(codePointSet, loUL, hiUL);
                    break;
                }
                case 4: {
                    int loAL = Math.min(intersectionLo ^ 1, intersectionHi ^ 1);
                    int hiAL = Math.max(intersectionLo ^ 1, intersectionHi ^ 1);
                    if (SortedListOfRanges.contains(intersectionLo, intersectionHi, loAL, hiAL)) break;
                    CaseFoldEquivalenceTable.addRange(codePointSet, loAL, hiAL);
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
        }

        private static void addRange(CodePointSetAccumulator codePointSet, int lo, int hi) {
            assert (lo <= 0x10FFFF) : "CaseFoldEquivalenceTable is currently used for single-character mappings only";
            codePointSet.addRange(lo, hi);
        }

        boolean equalsIgnoreCase(int codePointA, int codePointB) {
            if (codePointA == codePointB) {
                return true;
            }
            int search = this.binarySearch(codePointA);
            if (this.binarySearchExactMatch(search, codePointA, codePointA)) {
                return this.equalsIgnoreCase(search, codePointA, codePointB);
            }
            int firstIntersection = this.binarySearchGetFirstIntersecting(search, codePointA, codePointA);
            if (this.binarySearchNoIntersectingFound(firstIntersection) || this.rightOf(firstIntersection, codePointA, codePointA)) {
                return this.parent != null && this.parent.equalsIgnoreCase(codePointA, codePointB);
            }
            assert (this.intersects(firstIntersection, codePointA, codePointA));
            return this.equalsIgnoreCase(firstIntersection, codePointA, codePointB);
        }

        private boolean equalsIgnoreCase(int tblEntryIndex, int codePointA, int codePointB) {
            switch (this.ranges[tblEntryIndex * 4 + 2]) {
                case 1: {
                    int delta = this.ranges[tblEntryIndex * 4 + 3];
                    return codePointA + delta == codePointB;
                }
                case 2: {
                    CodePointSet set = this.directMappings[this.ranges[tblEntryIndex * 4 + 3]];
                    return set.contains(codePointB);
                }
                case 3: {
                    return (codePointA - 1 ^ 1) + 1 == codePointB;
                }
                case 4: {
                    return (codePointA ^ 1) == codePointB;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public int getLo(int i) {
            return this.ranges[i * 4];
        }

        @Override
        public int getHi(int i) {
            return this.ranges[i * 4 + 1];
        }

        @Override
        public int size() {
            return this.ranges.length / 4;
        }

        @Override
        public void appendRangesTo(RangesBuffer buffer, int startIndex, int endIndex) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    public static enum CaseFoldAlgorithm {
        Unicode16Simple,
        Unicode15Simple,
        ECMAScriptUnicode,
        PythonUnicode,
        Ruby,
        OracleDB,
        OracleDBSimple,
        OracleDBAI;

    }

    public static final class CaseFoldTable
    implements SortedListOfRanges {
        private final CaseFoldTable parent;
        private final int[] ranges;

        CaseFoldTable(CaseFoldTable parent, int[] ranges) {
            this.parent = parent;
            this.ranges = ranges;
        }

        public int[] caseFold(int codepoint) {
            int[][] ret = new int[1][];
            this.caseFold(new Range(codepoint, codepoint), (Integer cp, int[] caseFolded) -> {
                ret[0] = caseFolded;
            });
            return ret[0];
        }

        public void caseFold(CodePointSet cps, BiConsumer<Integer, int[]> caseFoldItem) {
            for (Range r : cps) {
                this.caseFold(r, caseFoldItem);
            }
        }

        public void caseFold(CodePointSetAccumulator cps, BiConsumer<Integer, int[]> caseFoldItem) {
            for (Range r : cps) {
                this.caseFold(r, caseFoldItem);
            }
        }

        public void caseFold(Range r, BiConsumer<Integer, int[]> caseFoldItem) {
            int search = this.binarySearch(r.lo);
            if (this.binarySearchExactMatch(search, r.lo, r.hi)) {
                this.apply(search, r.lo, r.hi, caseFoldItem);
                return;
            }
            int firstIntersection = this.binarySearchGetFirstIntersecting(search, r.lo, r.hi);
            if (this.binarySearchNoIntersectingFound(firstIntersection)) {
                if (this.parent != null) {
                    this.parent.caseFold(r, caseFoldItem);
                }
                return;
            }
            int lastIntersectionHi = r.lo - 1;
            for (int j = firstIntersection; j < this.size() && !this.rightOf(j, r.lo, r.hi); ++j) {
                assert (this.intersects(j, r.lo, r.hi));
                int intersectionLo = Math.max(this.getLo(j), r.lo);
                int intersectionHi = Math.min(this.getHi(j), r.hi);
                this.apply(j, intersectionLo, intersectionHi, caseFoldItem);
                if (this.parent != null && intersectionLo > lastIntersectionHi + 1) {
                    this.parent.caseFold(new Range(lastIntersectionHi + 1, intersectionLo - 1), caseFoldItem);
                }
                lastIntersectionHi = intersectionHi;
            }
            if (this.parent != null && r.hi > lastIntersectionHi) {
                this.parent.caseFold(new Range(lastIntersectionHi + 1, r.hi), caseFoldItem);
            }
        }

        private void apply(int tblEntryIndex, int intersectionLo, int intersectionHi, BiConsumer<Integer, int[]> caseFoldItem) {
            int kind = this.ranges[tblEntryIndex * 4 + 2];
            switch (kind) {
                case 1: {
                    int delta = this.ranges[tblEntryIndex * 4 + 3];
                    if (delta == 0) break;
                    for (int i = intersectionLo; i <= intersectionHi; ++i) {
                        CaseFoldTable.applyMapping(i, i + delta, caseFoldItem);
                    }
                    break;
                }
                case 3: 
                case 4: {
                    int loUL;
                    for (int i = loUL = kind == 3 ? intersectionLo | 1 : intersectionLo + (intersectionLo & 1); i <= intersectionHi; i += 2) {
                        CaseFoldTable.applyMapping(i, i + 1, caseFoldItem);
                    }
                    break;
                }
                case 5: 
                case 6: {
                    int loUL;
                    for (int i = loUL = kind == 5 ? intersectionLo | 1 : intersectionLo + (intersectionLo & 1); i <= intersectionHi; i += 2) {
                        CaseFoldTable.applyMapping(i, i - 1, caseFoldItem);
                    }
                    break;
                }
                case 7: {
                    int dst = this.ranges[tblEntryIndex * 4 + 3];
                    for (int i = intersectionLo; i <= intersectionHi; ++i) {
                        CaseFoldTable.applyMapping(i, dst, caseFoldItem);
                    }
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
        }

        private static void applyMapping(int from, int to, BiConsumer<Integer, int[]> caseFoldItem) {
            assert (from <= 0x10FFFF);
            caseFoldItem.accept(from, CaseFoldTable.mappingToCodepoints(to));
        }

        private static int[] mappingToCodepoints(int mapping) {
            if (mapping > 0x10FFFF) {
                return MULTI_CHAR_SEQUENCES[mapping - 0x110000].codePoints().toArray();
            }
            return new int[]{mapping};
        }

        private CaseUnfoldingTrie createCaseUnfoldTrie() {
            CaseUnfoldingTrie trie = new CaseUnfoldingTrie(0);
            if (this.parent == null) {
                block6: for (int i = 0; i < this.ranges.length; i += 4) {
                    switch (this.ranges[i + 2]) {
                        case 1: {
                            int j;
                            for (j = this.ranges[i]; j <= this.ranges[i + 1]; ++j) {
                                trie.add(j, CaseFoldTable.mappingToCodepoints(j + this.ranges[i + 3]), 0);
                            }
                            continue block6;
                        }
                        case 3: 
                        case 4: {
                            int j;
                            for (j = this.ranges[i]; j <= this.ranges[i + 1]; j += 2) {
                                trie.add(j, CaseFoldTable.mappingToCodepoints(j + 1), 0);
                            }
                            continue block6;
                        }
                        case 5: 
                        case 6: {
                            int j;
                            for (j = this.ranges[i]; j <= this.ranges[i + 1]; j += 2) {
                                trie.add(j, CaseFoldTable.mappingToCodepoints(j - 1), 0);
                            }
                            continue block6;
                        }
                        case 7: {
                            int j;
                            for (j = this.ranges[i]; j <= this.ranges[i + 1]; ++j) {
                                trie.add(j, CaseFoldTable.mappingToCodepoints(this.ranges[i + 3]), 0);
                            }
                            continue block6;
                        }
                        default: {
                            throw CompilerDirectives.shouldNotReachHere();
                        }
                    }
                }
            } else {
                this.caseFold(new Range(0, 0x10FFFF), (Integer from, int[] to) -> trie.add((int)from, (int[])to, 0));
            }
            return trie;
        }

        @Override
        public int getLo(int i) {
            return this.ranges[i * 4];
        }

        @Override
        public int getHi(int i) {
            return this.ranges[i * 4 + 1];
        }

        @Override
        public int size() {
            return this.ranges.length / 4;
        }

        @Override
        public void appendRangesTo(RangesBuffer buffer, int startIndex, int endIndex) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }
}

