/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.exception.TopLevelExceptionHandler;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNode;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNodeGen;
import com.oracle.graal.python.nodes.frame.ReadCallerFrameNode;
import com.oracle.graal.python.nodes.util.ExceptionStateNodes;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.bytecode.ContinuationRootNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;

public abstract class ExecutionContext {

    public static abstract class IndirectCalleeContext {
        public static Object enterIndirect(PythonLanguage language, PythonContext context, Object[] pArguments) {
            return IndirectCalleeContext.enter(context.getThreadState(language), pArguments, true);
        }

        public static Object enterIndirect(PythonContext.PythonThreadState threadState, Object[] pArguments) {
            return IndirectCalleeContext.enter(threadState, pArguments, true);
        }

        public static Object enter(PythonLanguage language, PythonContext context, Object[] pArguments, RootCallTarget callTarget) {
            PRootNode calleeRootNode = (PRootNode)callTarget.getRootNode();
            return IndirectCalleeContext.enter(context.getThreadState(language), pArguments, calleeRootNode.needsExceptionState());
        }

        public static Object enter(PythonContext.PythonThreadState threadState, Object[] pArguments, RootCallTarget callTarget) {
            PRootNode calleeRootNode = (PRootNode)callTarget.getRootNode();
            return IndirectCalleeContext.enter(threadState, pArguments, calleeRootNode.needsExceptionState());
        }

        private static Object enter(PythonContext.PythonThreadState threadState, Object[] pArguments, boolean needsExceptionState) {
            PFrame.Reference popTopFrameInfo = threadState.popTopFrameInfo();
            PArguments.setCallerFrameInfo(pArguments, popTopFrameInfo);
            if (needsExceptionState) {
                AbstractTruffleException curExc = threadState.getCaughtException();
                if (curExc != null) {
                    threadState.setCaughtException(null);
                }
                PArguments.setException(pArguments, curExc);
                return new IndirectCallState(popTopFrameInfo, curExc);
            }
            return popTopFrameInfo;
        }

        public static void exit(PythonLanguage language, PythonContext context, Object state) {
            IndirectCalleeContext.exit(context.getThreadState(language), state);
        }

        public static void exit(PythonContext.PythonThreadState threadState, Object state) {
            if (state instanceof IndirectCallState) {
                IndirectCallState indirectCallState = (IndirectCallState)state;
                threadState.setTopFrameInfo(indirectCallState.info);
                threadState.setCaughtException(indirectCallState.curExc);
            } else {
                threadState.setTopFrameInfo((PFrame.Reference)state);
            }
        }
    }

    public static abstract class IndirectCallContext {
        public static Object enter(VirtualFrame frame, PythonLanguage language, PythonContext context, IndirectCallData indirectCallData) {
            if (frame == null || indirectCallData.isUncached()) {
                return null;
            }
            boolean needsCallerFrame = indirectCallData.calleeNeedsCallerFrame();
            boolean needsExceptionState = indirectCallData.calleeNeedsExceptionState();
            if (!needsCallerFrame && !needsExceptionState) {
                return null;
            }
            PythonContext.PythonThreadState pythonThreadState = context.getThreadState(language);
            return IndirectCallContext.enter(frame, pythonThreadState, needsCallerFrame, needsExceptionState);
        }

        public static Object enter(VirtualFrame frame, Node node, IndirectCallData indirectCallData) {
            if (frame == null || indirectCallData.isUncached()) {
                return null;
            }
            boolean needsCallerFrame = indirectCallData.calleeNeedsCallerFrame();
            boolean needsExceptionState = indirectCallData.calleeNeedsExceptionState();
            if (!needsCallerFrame && !needsExceptionState) {
                return null;
            }
            PythonContext context = PythonContext.get(node);
            PythonContext.PythonThreadState pythonThreadState = context.getThreadState(context.getLanguage(node));
            return IndirectCallContext.enter(frame, pythonThreadState, needsCallerFrame, needsExceptionState);
        }

        public static Object enter(VirtualFrame frame, PythonContext.PythonThreadState pythonThreadState, IndirectCallData indirectCallData) {
            if (frame == null || indirectCallData.isUncached()) {
                return null;
            }
            return IndirectCallContext.enter(frame, pythonThreadState, indirectCallData.calleeNeedsCallerFrame(), indirectCallData.calleeNeedsExceptionState());
        }

        private static IndirectCallState enter(VirtualFrame frame, PythonContext.PythonThreadState pythonThreadState, boolean needsCallerFrame, boolean needsExceptionState) {
            PFrame.Reference info = null;
            if (needsCallerFrame) {
                PFrame.Reference prev = pythonThreadState.popTopFrameInfo();
                assert (prev == null) : "trying to call from Python to a foreign function, but we didn't clear the topframeref. This indicates that a call into Python code happened without a proper enter through ForeignToPythonCallContext";
                info = PArguments.getCurrentFrameInfo((Frame)frame);
                pythonThreadState.setTopFrameInfo(info);
            }
            AbstractTruffleException curExc = pythonThreadState.getCaughtException();
            AbstractTruffleException exceptionState = PArguments.getException((Frame)frame);
            if (needsExceptionState) {
                pythonThreadState.setCaughtException(exceptionState);
            } else if (exceptionState != curExc) {
                pythonThreadState.setCaughtException(null);
            }
            if (curExc == null && info == null) {
                return null;
            }
            return new IndirectCallState(info, curExc);
        }

        public static void exit(VirtualFrame frame, PythonLanguage language, PythonContext context, Object savedState) {
            if (savedState != null && frame != null && context != null) {
                IndirectCallContext.exit(frame, context.getThreadState(language), savedState);
                return;
            }
            assert (savedState == null) : "tried to exit an indirect call with state, but without frame/context";
        }

        public static void exit(VirtualFrame frame, Node node, IndirectCallData indirectCallData, Object savedState) {
            PythonContext context;
            if (savedState != null && frame != null && !indirectCallData.isUncached() && (context = PythonContext.get(node)) != null) {
                PythonLanguage language = context.getLanguage(node);
                IndirectCallContext.exit(frame, context.getThreadState(language), savedState);
                return;
            }
            assert (savedState == null) : "tried to exit an indirect call with state, but without frame/context";
        }

        public static void exit(VirtualFrame frame, PythonContext.PythonThreadState pythonThreadState, Object savedState) {
            if (frame == null) {
                assert (savedState == null) : "tried to exit an indirect call with state, but without frame";
                return;
            }
            if (savedState == null) {
                return;
            }
            IndirectCallState state = (IndirectCallState)savedState;
            if (state.info != null) {
                pythonThreadState.popTopFrameInfo();
            }
            pythonThreadState.setCaughtException(state.curExc);
        }
    }

    @CompilerDirectives.ValueType
    private static final class IndirectCallState {
        private final PFrame.Reference info;
        private final AbstractTruffleException curExc;

        private IndirectCallState(PFrame.Reference info, AbstractTruffleException curExc) {
            this.info = info;
            this.curExc = curExc;
        }
    }

    public static final class CalleeContext
    extends Node {
        @Node.Child
        private MaterializeFrameNode materializeNode;
        @CompilerDirectives.CompilationFinal
        private boolean everEscaped = false;

        public Node copy() {
            return new CalleeContext();
        }

        public void enter(VirtualFrame frame) {
            PFrame.Reference thisFrameRef = new PFrame.Reference(this.getRootNode(), PArguments.getCallerFrameInfo((Frame)frame));
            PArguments.setCurrentFrameInfo((Frame)frame, thisFrameRef);
        }

        public void exit(VirtualFrame frame, PRootNode node) {
            this.exit(frame, node, (Node)node);
        }

        public void exit(VirtualFrame frame, PRootNode node, Node location) {
            PFrame.Reference info = PArguments.getCurrentFrameInfo((Frame)frame);
            CompilerAsserts.partialEvaluationConstant((Object)((Object)node));
            if (node.getFrameEscapedProfile().profile(info.isEscaped())) {
                this.exitEscaped(frame, node, location, info);
            }
        }

        @HostCompilerDirectives.InliningCutoff
        private void exitEscaped(VirtualFrame frame, PRootNode node, Node location, PFrame.Reference info) {
            PFrame.Reference callerInfo;
            if (!this.everEscaped) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.everEscaped = true;
                this.reportPolymorphicSpecialize();
            }
            if ((callerInfo = PArguments.getCallerFrameInfo((Frame)frame)) == null) {
                CompilerDirectives.transferToInterpreter();
                ReadCallerFrameNode.StackWalkResult callerFrameResult = ReadCallerFrameNode.getCallerFrame(info, FrameInstance.FrameAccess.READ_ONLY, ReadCallerFrameNode.AllFramesSelector.INSTANCE, 0);
                callerInfo = callerFrameResult != null ? PArguments.getCurrentFrameInfo(callerFrameResult.frame()) : PFrame.Reference.EMPTY;
                assert (node.needsCallerFrame()) : "stack walk did not invalidate caller frame assumption";
            }
            this.ensureMaterializeNode().execute((Frame)frame, location, false, true);
            callerInfo.markAsEscaped();
            info.setBackref(callerInfo);
        }

        private MaterializeFrameNode ensureMaterializeNode() {
            if (this.materializeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.materializeNode = (MaterializeFrameNode)this.insert(MaterializeFrameNodeGen.create());
            }
            return this.materializeNode;
        }

        @NeverDefault
        public static CalleeContext create() {
            return new CalleeContext();
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class CallContext
    extends Node {
        public void prepareIndirectCall(VirtualFrame frame, Object[] callArguments, Node callNode) {
            this.executePrepareCall(frame, CallContext.getActualCallArguments(callArguments), callNode, true, true);
        }

        private static Object[] getActualCallArguments(Object[] callArguments) {
            Object object;
            if (callArguments.length == 2 && (object = callArguments[0]) instanceof MaterializedFrame) {
                MaterializedFrame materialized = (MaterializedFrame)object;
                return materialized.getArguments();
            }
            return callArguments;
        }

        public void prepareCall(VirtualFrame frame, Object[] callArguments, RootCallTarget callTarget, Node callNode) {
            boolean needsExceptionState;
            Object[] actualCallArguments;
            PRootNode calleeRootNode;
            RootNode rootNode = callTarget.getRootNode();
            if (rootNode instanceof ContinuationRootNode) {
                ContinuationRootNode continuationRoot = (ContinuationRootNode)rootNode;
                calleeRootNode = (PRootNode)continuationRoot.getSourceRootNode();
                assert (callArguments.length == 2);
                actualCallArguments = ((MaterializedFrame)callArguments[0]).getArguments();
                needsExceptionState = calleeRootNode.needsExceptionState() && !PArguments.hasException(actualCallArguments);
            } else {
                calleeRootNode = (PRootNode)rootNode;
                actualCallArguments = callArguments;
                needsExceptionState = calleeRootNode.needsExceptionState();
            }
            this.executePrepareCall(frame, actualCallArguments, callNode, calleeRootNode.needsCallerFrame(), needsExceptionState);
        }

        protected abstract void executePrepareCall(VirtualFrame var1, Object[] var2, Node var3, boolean var4, boolean var5);

        @Specialization
        protected static void prepareCall(VirtualFrame frame, Object[] callArguments, Node callNode, boolean needsCallerFrame, boolean needsExceptionState, @Bind Node inliningTarget, @Cached PassCallerFrameNode passCallerFrame, @Cached PassExceptionStateNode passExceptionState) {
            assert (PArguments.isPythonFrame((Frame)frame) || callNode.getRootNode() instanceof TopLevelExceptionHandler) : "calling from non-Python or non-top-level frame";
            passCallerFrame.execute(frame, inliningTarget, callArguments, callNode, needsCallerFrame);
            passExceptionState.execute(frame, inliningTarget, callArguments, needsExceptionState);
        }

        @GenerateCached(value=false)
        @GenerateUncached
        @GenerateInline
        @ImportStatic(value={PArguments.class})
        protected static abstract class PassCallerFrameNode
        extends Node {
            protected PassCallerFrameNode() {
            }

            protected abstract void execute(VirtualFrame var1, Node var2, Object[] var3, Node var4, boolean var5);

            @Specialization(guards={"!needsCallerFrame"})
            protected static void dontPassCallerFrame(Object[] callArguments, Node callNode, boolean needsCallerFrame) {
            }

            @Specialization(guards={"needsCallerFrame", "isPythonFrame(frame)"})
            protected static void passCallerFrame(VirtualFrame frame, Object[] callArguments, Node callNode, boolean needsCallerFrame, @Cached(inline=false) MaterializeFrameNode materialize) {
                PFrame.Reference thisInfo = PArguments.getCurrentFrameInfo((Frame)frame);
                PFrame pyFrame = materialize.execute((Frame)frame, callNode, false, true);
                assert (thisInfo.getPyFrame() == pyFrame);
                assert (pyFrame.getRef() == thisInfo);
                PArguments.setCallerFrameInfo(callArguments, thisInfo);
            }

            @Specialization(guards={"needsCallerFrame", "!isPythonFrame(frame)"})
            protected static void passEmptyCallerFrame(VirtualFrame frame, Object[] callArguments, Node callNode, boolean needsCallerFrame) {
                PArguments.setCallerFrameInfo(callArguments, PFrame.Reference.EMPTY);
            }
        }

        @GenerateCached(value=false)
        @GenerateUncached
        @GenerateInline
        @ImportStatic(value={PArguments.class})
        protected static abstract class PassExceptionStateNode
        extends Node {
            protected PassExceptionStateNode() {
            }

            protected abstract void execute(VirtualFrame var1, Node var2, Object[] var3, boolean var4);

            @Specialization(guards={"!needsExceptionState"})
            protected static void dontPassExceptionState(VirtualFrame frame, Node inliningTarget, Object[] callArguments, boolean needsExceptionState, @Cached InlinedConditionProfile hasNoException) {
                AbstractTruffleException curExc = PArguments.getException((Frame)frame);
                if (hasNoException.profile(inliningTarget, curExc == PException.NO_EXCEPTION)) {
                    PArguments.setException(callArguments, curExc);
                }
            }

            @Specialization(guards={"needsExceptionState", "isPythonFrame(frame)", "getException(frame) == null"})
            protected static void passExceptionStateFromStackWalk(VirtualFrame frame, Node inliningTarget, Object[] callArguments, boolean needsExceptionState) {
                AbstractTruffleException fromStackWalk = ExceptionStateNodes.GetCaughtExceptionNode.fullStackWalk();
                if (fromStackWalk == null) {
                    fromStackWalk = PException.NO_EXCEPTION;
                }
                PArguments.setException((Frame)frame, fromStackWalk);
                PArguments.setException(callArguments, fromStackWalk);
            }

            @Specialization(guards={"needsExceptionState", "isPythonFrame(frame)", "curExc != null"}, replaces={"passExceptionStateFromStackWalk"})
            protected static void passGivenExceptionState(VirtualFrame frame, Node inliningTarget, Object[] callArguments, boolean needsExceptionState, @Bind(value="getException(frame)") AbstractTruffleException curExc) {
                PArguments.setException(callArguments, curExc);
            }

            @Specialization(guards={"needsExceptionState", "isPythonFrame(frame)"}, replaces={"passGivenExceptionState"})
            @ReportPolymorphism.Megamorphic
            protected static void passExceptionStateFromFrameOrStack(VirtualFrame frame, Node inliningTarget, Object[] callArguments, boolean needsExceptionState, @Cached InlinedCountingConditionProfile needsStackWalk) {
                AbstractTruffleException curExc = PArguments.getException((Frame)frame);
                if (needsStackWalk.profile(inliningTarget, curExc == null)) {
                    PassExceptionStateNode.passExceptionStateFromStackWalk(frame, inliningTarget, callArguments, needsExceptionState);
                } else {
                    PassExceptionStateNode.passGivenExceptionState(frame, inliningTarget, callArguments, needsExceptionState, curExc);
                }
            }

            @Specialization(guards={"needsExceptionState", "!isPythonFrame(frame)"})
            protected static void passNoExceptionState(VirtualFrame frame, Node inliningTarget, Object[] callArguments, boolean needsExceptionState) {
                PArguments.setException(callArguments, (AbstractTruffleException)PException.NO_EXCEPTION);
            }
        }
    }
}

