/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.tokenize;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.compiler.ParserCallbacksImpl;
import com.oracle.graal.python.pegparser.ParserCallbacks;
import com.oracle.graal.python.pegparser.tokenizer.CodePoints;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.graal.python.pegparser.tokenizer.Token;
import com.oracle.graal.python.pegparser.tokenizer.Tokenizer;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.EnumSet;

public final class PTokenizerIter
extends PythonBuiltinObject {
    private final ParserCallbacksImpl parserCallbacks = new ParserCallbacksImpl(this::getSource, PythonOptions.isPExceptionWithJavaStacktrace(PythonLanguage.get(null)));
    final Tokenizer tokenizer;
    private int lastLineNo = -1;
    private TruffleString lastLine;
    private boolean done;
    private Source cachedSource;

    @CompilerDirectives.TruffleBoundary
    public PTokenizerIter(Object cls, Shape instanceShape, Supplier<int[]> inputSupplier, boolean extraTokens) {
        super(cls, instanceShape);
        EnumSet<Tokenizer.Flag> flags = EnumSet.of(Tokenizer.Flag.EXEC_INPUT);
        if (extraTokens) {
            flags.add(Tokenizer.Flag.EXTRA_TOKENS);
        }
        this.tokenizer = Tokenizer.fromReadline(this.parserCallbacks, flags, inputSupplier);
    }

    boolean isDone() {
        return this.done;
    }

    @CompilerDirectives.TruffleBoundary
    Token getNextToken() {
        Token token = this.tokenizer.next();
        this.parserCallbacks.triggerAndClearDeprecationWarnings();
        if (token.type == 66) {
            this.reportTokenizerError();
        }
        if (token.type == 0) {
            this.done = true;
        }
        return token;
    }

    @CompilerDirectives.TruffleBoundary
    CodePoints getTokenCodePoints(Token token) {
        return this.tokenizer.getTokenCodePoints(token);
    }

    TruffleString getLine(Token token, TruffleString.FromIntArrayUTF32Node fromIntArrayUTF32Node, TruffleString.SwitchEncodingNode switchEncodingNode) {
        if (this.tokenizer.getCurrentLineNumber() == this.lastLineNo) {
            return this.lastLine;
        }
        CodePoints line = this.tokenizer.getTokenLine(token.type);
        this.lastLine = line.isEmpty() ? PythonUtils.TS_ENCODING.getEmpty() : switchEncodingNode.execute((AbstractTruffleString)fromIntArrayUTF32Node.execute(line.getBuffer(), line.getOffset(), line.getLength()), PythonUtils.TS_ENCODING);
        this.lastLineNo = this.tokenizer.getCurrentLineNumber();
        return this.lastLine;
    }

    private void reportTokenizerError() {
        ParserCallbacks.ErrorType errorType = ParserCallbacks.ErrorType.Syntax;
        int colOffset = Math.max(0, this.tokenizer.getCodePointsInputLength() - this.tokenizer.getLineStartIndex() - 1);
        throw this.parserCallbacks.raiseSyntaxError(errorType, new SourceRange(this.tokenizer.getCurrentLineNumber(), colOffset, -1, -1), switch (this.tokenizer.getDone()) {
            case Tokenizer.StatusCode.BAD_TOKEN -> "invalid token";
            case Tokenizer.StatusCode.EOF -> "unexpected EOF in multi-line statement";
            case Tokenizer.StatusCode.DEDENT_INVALID -> {
                errorType = ParserCallbacks.ErrorType.Indentation;
                yield "unindent does not match any outer indentation level";
            }
            case Tokenizer.StatusCode.TABS_SPACES_INCONSISTENT -> {
                errorType = ParserCallbacks.ErrorType.Tab;
                yield "inconsistent use of tabs and spaces in indentation";
            }
            case Tokenizer.StatusCode.TOO_DEEP_INDENTATION -> {
                errorType = ParserCallbacks.ErrorType.Indentation;
                yield "too many levels of indentation";
            }
            case Tokenizer.StatusCode.LINE_CONTINUATION_ERROR -> "unexpected character after line continuation character";
            default -> "unknown tokenization error";
        });
    }

    private Source getSource() {
        if (this.cachedSource == null) {
            String src = this.tokenizer.getCodePointsInput().toJavaString();
            this.cachedSource = Source.newBuilder((String)"python", (CharSequence)src, (String)"<string>").build();
        }
        return this.cachedSource;
    }
}

