/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import com.oracle.common.internal.net.ipclw.mql.LocalQueue;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.ns.NetException;

@DefaultLogger(value="oracle.net")
@Supports(value={Feature.NET})
public class NTMQProtocolHandler {
    private ByteBuffer remoteQueueNameBuffer;
    private byte ntmqVersion;
    private byte msgqltProtocolType;
    private byte packetType;
    private byte packetFlag;
    private byte[] sessionIdentifier;
    private int tduMTUSize;
    private int headerPacketSize;
    private short connectFlag;
    private short endianess;
    private short messageQueueLength;
    private boolean sendSessionIdentifier;
    private boolean sendSessionIdentifierIMD;
    private boolean rcvSessionIdentifier;
    private boolean rcvSessionIdentifierIMD;
    private boolean fcEnabled;
    private short fcInitialPostCount;
    private long remoteFcbAddr;
    private ByteBuffer remoteFcbKey;
    protected static final byte NTMQHTCN = 1;
    protected static final byte NTMQHTDC = 2;
    protected static final byte NTMQHTRF = 3;
    protected static final byte NTMQHTDA = 4;
    protected static final byte NTMQHTEO = 5;
    protected static final byte NTMQHTIR = 6;
    protected static final byte NTMQHTDI = 7;
    protected static final byte NTMQHFARQ = 1;
    protected static final byte NTMQHFARS = 2;
    protected static final byte NTMQHFSID = 4;
    protected static final byte NTMQHFPAD = 8;
    private static final short NTMQCFSI = 1;
    private static final short NTMQCFSIIMD = 2;
    private static final short NTMQ_BIG_ENDIAN = 1;
    private static final short NTMQ_LITTLE_ENDIAN = 256;
    protected static final byte NO_SID_HEADER_SIZE = 2;
    protected static final int SESSION_IDENTIFIER_SIZE = 16;
    protected static final byte WITH_SID_HEADER_SIZE = 18;
    protected static final int MIN_CONNECT_PACKET_SIZE = 28;
    protected static final int MIN_FLOW_CONTROL_PACKET_SIZE = 12;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;

    NTMQProtocolHandler(byte msgqltProtocolType, boolean queueMsgRequireSID, boolean rdmaMsgRequireSID) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$23, null, msgqltProtocolType, queueMsgRequireSID, rdmaMsgRequireSID);
            }
            this.packetType = (byte)-1;
            this.packetFlag = (byte)-1;
            this.headerPacketSize = 2;
            this.msgqltProtocolType = msgqltProtocolType;
            this.rcvSessionIdentifier = queueMsgRequireSID;
            this.rcvSessionIdentifierIMD = rdmaMsgRequireSID;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$23, null);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$23, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$23, null, throwable2);
            }
            throw throwable;
        }
    }

    protected byte getPacketType() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$0, this, new Object[0]);
            }
            byte by = this.packetType;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$0, this, by);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$0, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processNTMQPacket(ByteBuffer byteBuffer) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void message;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$1, this, byteBuffer);
            }
            ByteOrder originalByteOrder = message.order();
            message.order(ByteOrder.LITTLE_ENDIAN);
            this.parseHeaderPacket((ByteBuffer)message);
            if (bl) {
                this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "JAVANET : <NTMQ> Packet Type is " + this.packetType);
            }
            if (this.packetType == 1) {
                this.parseConnectPacket((ByteBuffer)message);
            } else if (this.packetType < 1 || this.packetType > 7) {
                NetException netException = new NetException(26);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$1, this, netException);
                }
                throw netException;
            }
            message.order(originalByteOrder);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void parseHeaderPacket(ByteBuffer byteBuffer) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void headerPacket;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$2, this, byteBuffer);
            }
            ByteOrder originalByteOrder = headerPacket.order();
            headerPacket.order(ByteOrder.LITTLE_ENDIAN);
            this.packetType = headerPacket.get();
            this.packetFlag = headerPacket.get();
            headerPacket.order(originalByteOrder);
            if (bl) {
                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "JAVANET : <NTMQ> Header Packet received on remoteQueue : size = " + headerPacket.position() + " packet Type = " + this.packetType + " packetFlag = " + this.packetFlag);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void parseConnectPacket(ByteBuffer byteBuffer) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void connectPacket;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$3, this, byteBuffer);
            }
            this.ntmqVersion = connectPacket.get();
            this.msgqltProtocolType = connectPacket.get();
            this.connectFlag = connectPacket.getShort();
            if ((this.connectFlag & 1) != 0) {
                this.sendSessionIdentifier = true;
                this.headerPacketSize = 18;
            } else {
                this.sendSessionIdentifier = false;
                this.headerPacketSize = 2;
            }
            if ((this.connectFlag & 2) != 0) {
                this.sendSessionIdentifierIMD = true;
            }
            this.sessionIdentifier = new byte[16];
            connectPacket.get(this.sessionIdentifier, 0, 16);
            this.tduMTUSize = connectPacket.getInt();
            this.endianess = connectPacket.getShort();
            this.messageQueueLength = connectPacket.getShort();
            this.remoteQueueNameBuffer = ByteBuffer.allocate(this.messageQueueLength);
            byte[] remoteQueueNameByteArray = new byte[this.messageQueueLength];
            this.remoteQueueNameBuffer.order(ByteOrder.LITTLE_ENDIAN);
            connectPacket.get(remoteQueueNameByteArray, 0, this.messageQueueLength);
            this.remoteQueueNameBuffer.put(remoteQueueNameByteArray);
            this.remoteQueueNameBuffer.flip();
            this.parseFlowControlPacket((ByteBuffer)connectPacket);
            if (bl) {
                this.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "JAVANET : <NTMQ> Connect Packet received on RemoteQueue : size = " + connectPacket.limit() + " ntmqVersion = " + this.ntmqVersion + " msgltProtocolType = " + this.msgqltProtocolType + " connectFlag = " + this.connectFlag + " sendSessionIdentifier = " + this.sendSessionIdentifier + " tduMTUsize = " + this.tduMTUSize + " endianess = " + this.endianess + " messageQueueLength = " + this.messageQueueLength);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void parseFlowControlPacket(ByteBuffer byteBuffer) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void flowControlPacket;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$4, this, byteBuffer);
            }
            ByteOrder originalByteOrder = flowControlPacket.order();
            flowControlPacket.order(ByteOrder.LITTLE_ENDIAN);
            byte enabled = flowControlPacket.get();
            boolean bl2 = this.fcEnabled = enabled != 0;
            if (this.fcEnabled) {
                int keySize = flowControlPacket.get() & 0xFF;
                this.fcInitialPostCount = flowControlPacket.getShort();
                this.remoteFcbAddr = flowControlPacket.getLong();
                this.remoteFcbKey = ByteBuffer.allocateDirect(keySize);
                this.remoteFcbKey.put((ByteBuffer)flowControlPacket).flip();
                if (bl) {
                    this.debug($$$loggerRef$$$4, Level.FINEST, $$$methodRef$$$4, "Flow Control Packet Received: enabled: " + this.fcEnabled + " initialPostCount=" + this.fcInitialPostCount + " rva=" + Long.toHexString(this.remoteFcbAddr) + " keySize=" + keySize);
                }
            }
            flowControlPacket.order(originalByteOrder);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void prepareConnectPacket(ByteBuffer byteBuffer, byte[] byArray, int n2, ByteOrder byteOrder, LocalQueue localQueue) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void tduMDUSize;
            byte[] sessionIdentifier;
            void connectPacket;
            void localQueue2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$5, this, byteBuffer, byArray, n2, byteOrder, localQueue);
            }
            ByteBuffer localQueueName = localQueue2.getName().getBuffer();
            localQueueName.rewind();
            localQueueName.position(0);
            connectPacket.order(ByteOrder.LITTLE_ENDIAN);
            connectPacket.put((byte)localQueue2.getContext().getMajorVersion());
            connectPacket.put(this.msgqltProtocolType);
            short connectFlag = 0;
            if (this.rcvSessionIdentifier) {
                connectFlag = (short)(connectFlag | 1);
            }
            if (this.rcvSessionIdentifierIMD) {
                connectFlag = (short)(connectFlag | 2);
            }
            connectPacket.putShort(connectFlag);
            if (sessionIdentifier == null || sessionIdentifier.length != 16) {
                if (this.rcvSessionIdentifier | this.rcvSessionIdentifierIMD && bl) {
                    this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "JAVANET : <NTMQ> Session identifier is required, but no session ID was found");
                }
                sessionIdentifier = new byte[16];
                for (int i2 = 0; i2 < 16; ++i2) {
                    sessionIdentifier[i2] = 0;
                }
            }
            connectPacket.put(sessionIdentifier);
            connectPacket.putInt((int)tduMDUSize);
            connectPacket.putShort((short)1);
            connectPacket.putShort((short)localQueueName.limit());
            connectPacket.put(localQueueName);
            if (bl) {
                this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "JAVANET : <NTMQ> Connect Packet to be sent to Remote Queue : size = " + connectPacket.limit() + " ntmqVersion = " + localQueue2.getContext().getMajorVersion() + " msgqltProtocolType = " + this.msgqltProtocolType + " rcvSessionIdentifier = " + this.rcvSessionIdentifier + " tduMDUSize = " + (int)tduMDUSize + " endianess = " + connectPacket.order() + " localQueueNameLength = " + localQueueName.limit());
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void appendFlowControlPacket(ByteBuffer byteBuffer, boolean bl, short s2, long l2, ByteBuffer byteBuffer2) {
        boolean bl2 = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void connectPacket;
            void enabled;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$6, this, byteBuffer, bl, s2, l2, byteBuffer2);
            }
            if (enabled != false) {
                void fcbAddr;
                void postCount;
                void fcbKey;
                connectPacket.put((byte)1);
                connectPacket.put((byte)fcbKey.remaining());
                connectPacket.putShort((short)postCount);
                connectPacket.putLong((long)fcbAddr);
                fcbKey.order(ByteOrder.LITTLE_ENDIAN);
                connectPacket.put((ByteBuffer)fcbKey);
                if (bl2) {
                    this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "Flow Control Packet to be sent to RemoteQueue: enabled=" + (boolean)enabled + " keySize=" + fcbKey.flip().remaining() + " initialPostCount=" + (short)postCount + " rva=" + (long)fcbAddr);
                }
            } else {
                int flowControlPacketLength = connectPacket.remaining();
                byte[] flowControlData = new byte[flowControlPacketLength];
                for (int i2 = 0; i2 < flowControlPacketLength; ++i2) {
                    flowControlData[i2] = 0;
                }
                connectPacket.put(flowControlData);
                if (bl2) {
                    this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "JDBC disables Flow Control");
                }
            }
            connectPacket.flip();
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int prepareHeaderPacket(ByteBuffer byteBuffer, byte by, byte by2, byte[] byArray, boolean bl) {
        boolean bl2 = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte flag;
            void immediateMsg;
            boolean includeSID;
            void packetType;
            void headerPacket;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$7, this, byteBuffer, by, by2, byArray, bl);
            }
            headerPacket.rewind();
            headerPacket.order(ByteOrder.LITTLE_ENDIAN);
            headerPacket.put((byte)packetType);
            boolean bl3 = includeSID = this.sendSessionIdentifier || immediateMsg != false && this.sendSessionIdentifierIMD;
            if (includeSID) {
                flag = (byte)(flag | 4);
            }
            headerPacket.put(flag);
            if (includeSID) {
                void sessionIdentifier;
                if (sessionIdentifier == null || ((void)sessionIdentifier).length != 16) {
                    if (bl2) {
                        this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "JAVANET : <NTMQ> Session identifier is required, but no session ID was found");
                    }
                } else {
                    headerPacket.put((byte[])sessionIdentifier);
                }
            }
            headerPacket.flip();
            if (bl2) {
                this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "JAVANET : <NTMQ> Header Packet to be sent to RemoteQueue: size = " + headerPacket.limit() + " packetType = " + (byte)packetType + " sendSessionIdentifier = " + this.sendSessionIdentifier + " flag = " + flag);
            }
            int n2 = headerPacket.limit();
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$7, this, n2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$7, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    protected int getHeaderPacketSize() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$8, this, new Object[0]);
            }
            int n2 = this.headerPacketSize;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$8, this, n2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$8, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    protected boolean isConnectPacket() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$9, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.packetType == 1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$9, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$9, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    protected boolean isDataPacket() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$10, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.packetType == 4 || this.packetType == 7;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$10, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$10, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    protected boolean isDisconnectPacket() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$11, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.packetType == 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$11, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$11, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isDataIRPacket() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$12, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.packetType == 7;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$12, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$12, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    protected byte getPacketFlag() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$13, this, new Object[0]);
            }
            byte by = this.packetFlag;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$13, this, by);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$13, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    protected ByteBuffer getRemoteQueueNameBuffer() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$14, this, new Object[0]);
            }
            ByteBuffer byteBuffer = this.remoteQueueNameBuffer;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$14, this, byteBuffer);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$14, this, null);
            }
            return byteBuffer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    protected int getTduMtu() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$15, this, new Object[0]);
            }
            int n2 = this.tduMTUSize;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$15, this, n2);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$15, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    protected byte[] getSID() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$16, this, new Object[0]);
            }
            byte[] byArray = this.sessionIdentifier;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$16, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$16, this, null);
            }
            return this.sessionIdentifier;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    protected boolean isSIDRequiredForRqMsg() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$17, this, new Object[0]);
            }
            boolean bl2 = this.sendSessionIdentifier;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$17, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$17, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    protected boolean isSIDRequiredForRdmaMsg() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$18, this, new Object[0]);
            }
            boolean bl2 = this.sendSessionIdentifierIMD;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$18, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$18, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    protected boolean isFlowControlEnabled() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$19, this, new Object[0]);
            }
            boolean bl2 = this.fcEnabled;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$19, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$19, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    protected short getFcPostCount() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$20, this, new Object[0]);
            }
            short s2 = this.fcInitialPostCount;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$20, this, s2);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$20, this, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    protected long getFcAddr() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$21, this, new Object[0]);
            }
            long l2 = this.remoteFcbAddr;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$21, this, l2);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$21, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    protected ByteBuffer getFcKey() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$22, this, new Object[0]);
            }
            ByteBuffer byteBuffer = this.remoteFcbKey;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$22, this, byteBuffer);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$22, this, null);
            }
            return byteBuffer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, NTMQProtocolHandler.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$23 = NTMQProtocolHandler.class.getDeclaredConstructor(Byte.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$22 = NTMQProtocolHandler.class.getDeclaredMethod("getFcKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$21 = NTMQProtocolHandler.class.getDeclaredMethod("getFcAddr", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$20 = NTMQProtocolHandler.class.getDeclaredMethod("getFcPostCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$19 = NTMQProtocolHandler.class.getDeclaredMethod("isFlowControlEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$18 = NTMQProtocolHandler.class.getDeclaredMethod("isSIDRequiredForRdmaMsg", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$17 = NTMQProtocolHandler.class.getDeclaredMethod("isSIDRequiredForRqMsg", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$16 = NTMQProtocolHandler.class.getDeclaredMethod("getSID", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$15 = NTMQProtocolHandler.class.getDeclaredMethod("getTduMtu", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$14 = NTMQProtocolHandler.class.getDeclaredMethod("getRemoteQueueNameBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$13 = NTMQProtocolHandler.class.getDeclaredMethod("getPacketFlag", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$12 = NTMQProtocolHandler.class.getDeclaredMethod("isDataIRPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$11 = NTMQProtocolHandler.class.getDeclaredMethod("isDisconnectPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$10 = NTMQProtocolHandler.class.getDeclaredMethod("isDataPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$9 = NTMQProtocolHandler.class.getDeclaredMethod("isConnectPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$8 = NTMQProtocolHandler.class.getDeclaredMethod("getHeaderPacketSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$7 = NTMQProtocolHandler.class.getDeclaredMethod("prepareHeaderPacket", ByteBuffer.class, Byte.TYPE, Byte.TYPE, byte[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$6 = NTMQProtocolHandler.class.getDeclaredMethod("appendFlowControlPacket", ByteBuffer.class, Boolean.TYPE, Short.TYPE, Long.TYPE, ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$5 = NTMQProtocolHandler.class.getDeclaredMethod("prepareConnectPacket", ByteBuffer.class, byte[].class, Integer.TYPE, ByteOrder.class, LocalQueue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$4 = NTMQProtocolHandler.class.getDeclaredMethod("parseFlowControlPacket", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$3 = NTMQProtocolHandler.class.getDeclaredMethod("parseConnectPacket", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$2 = NTMQProtocolHandler.class.getDeclaredMethod("parseHeaderPacket", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$1 = NTMQProtocolHandler.class.getDeclaredMethod("processNTMQPacket", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$0 = NTMQProtocolHandler.class.getDeclaredMethod("getPacketType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
    }
}

