/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.dcn.RowChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.NTFDCNRowChanges;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class NTFDCNTableChanges
implements TableChangeDescription {
    private static final byte OPERATION_ANY = 0;
    private static final byte OPERATION_UNKNOWN = 64;
    final EnumSet<TableChangeDescription.TableOperation> opcode;
    String tableName;
    final int objectNumber;
    final int numberOfRows;
    ArrayList<EnumSet<RowChangeDescription.RowOperation>> rowOpcode;
    final int[] rowIdLength;
    final byte[][] rowid;
    final CharacterSet charset;
    private AtomicReference<NTFDCNRowChanges[]> rowsDescriptionRef;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    NTFDCNTableChanges(ByteBuffer buffer, int _csid) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$6, null, buffer, _csid);
            }
            this.rowsDescriptionRef = new AtomicReference();
            this.charset = CharacterSet.make(_csid);
            this.opcode = TableChangeDescription.TableOperation.getTableOperations(buffer.getInt());
            short tableNameLength = buffer.getShort();
            byte[] tableNameBuffer = new byte[tableNameLength];
            buffer.get(tableNameBuffer, 0, tableNameLength);
            this.tableName = this.charset.toStringWithReplacement(tableNameBuffer, 0, tableNameLength);
            this.objectNumber = buffer.getInt();
            if (!this.opcode.contains((Object)TableChangeDescription.TableOperation.ALL_ROWS)) {
                this.numberOfRows = buffer.getShort();
                this.rowOpcode = new ArrayList(this.numberOfRows);
                this.rowIdLength = new int[this.numberOfRows];
                this.rowid = new byte[this.numberOfRows][];
                for (int i2 = 0; i2 < this.numberOfRows; ++i2) {
                    this.rowOpcode.add(RowChangeDescription.RowOperation.getRowOperations(buffer.getInt()));
                    this.rowIdLength[i2] = buffer.getShort();
                    this.rowid[i2] = new byte[this.rowIdLength[i2]];
                    buffer.get(this.rowid[i2], 0, this.rowIdLength[i2]);
                }
            } else {
                this.numberOfRows = 0;
                this.rowid = null;
                this.rowOpcode = null;
                this.rowIdLength = null;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getTableName() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$0, this, new Object[0]);
            }
            String string = this.tableName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$0, this, string);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$0, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getObjectNumber() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$1, this, new Object[0]);
            }
            int n2 = this.objectNumber;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$1, this, n2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$1, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public RowChangeDescription[] getRowChangeDescription() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$2, this, new Object[0]);
            }
            RowChangeDescription[] rowChangeDescriptionArray = this.rowsDescriptionRef.updateAndGet(nTFDCNRowChangesArray -> {
                boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
                try {
                    void rdArray;
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$4, this, nTFDCNRowChangesArray);
                    }
                    if (rdArray == null) {
                        NTFDCNRowChanges[] rowsDescription = new NTFDCNRowChanges[this.numberOfRows];
                        Arrays.setAll(rowsDescription, n2 -> {
                            boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
                            try {
                                void i2;
                                if (bl) {
                                    ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$5, this, n2);
                                }
                                NTFDCNRowChanges nTFDCNRowChanges = new NTFDCNRowChanges(this.rowOpcode.get((int)i2), this.rowIdLength[i2], this.rowid[i2]);
                                if (bl) {
                                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$5, this, nTFDCNRowChanges);
                                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$5, this, null);
                                }
                                return nTFDCNRowChanges;
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                if (bl) {
                                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$5, this, throwable2);
                                }
                                throw throwable;
                            }
                        });
                        NTFDCNRowChanges[] nTFDCNRowChangesArray2 = rowsDescription;
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$4, this, nTFDCNRowChangesArray2);
                            ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$4, this, null);
                        }
                        return rowsDescription;
                    }
                    void var4_5 = rdArray;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$4, this, var4_5);
                        ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$4, this, null);
                    }
                    return var4_5;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$4, this, throwable2);
                    }
                    throw throwable;
                }
            });
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$2, this, rowChangeDescriptionArray);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$2, this, null);
            }
            return rowChangeDescriptionArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public EnumSet<TableChangeDescription.TableOperation> getTableOperations() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$3, this, new Object[0]);
            }
            EnumSet<TableChangeDescription.TableOperation> enumSet = this.opcode;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$3, this, enumSet);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$3, this, null);
            }
            return enumSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFDCNTableChanges.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    operation=" + this.getTableOperations() + ", tableName=" + this.tableName + ", objectNumber=" + this.objectNumber + "\n");
        RowChangeDescription[] rdesc = this.getRowChangeDescription();
        if (rdesc != null && rdesc.length > 0) {
            sb.append("    Row Change Description (length=" + rdesc.length + "):\n");
            for (int i2 = 0; i2 < rdesc.length; ++i2) {
                sb.append(rdesc[i2].toString());
            }
        }
        return sb.toString();
    }

    static {
        try {
            $$$methodRef$$$6 = NTFDCNTableChanges.class.getDeclaredConstructor(ByteBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFDCNTableChanges.class.getDeclaredMethod("lambda$getRowChangeDescription$0", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFDCNTableChanges.class.getDeclaredMethod("lambda$getRowChangeDescription$1", NTFDCNRowChanges[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFDCNTableChanges.class.getDeclaredMethod("getTableOperations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFDCNTableChanges.class.getDeclaredMethod("getRowChangeDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFDCNTableChanges.class.getDeclaredMethod("getObjectNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFDCNTableChanges.class.getDeclaredMethod("getTableName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

