/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataRestriction;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLQuantifiedDataRestriction;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.HasIncrementalSignatureGenerationSupport;
import uk.ac.manchester.cs.owl.owlapi.OWLQuantifiedRestrictionImpl;

public abstract class OWLQuantifiedDataRestrictionImpl
extends OWLQuantifiedRestrictionImpl<OWLDataRange>
implements OWLDataRestriction {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLDataPropertyExpression property;

    public OWLQuantifiedDataRestrictionImpl(@Nonnull OWLDataPropertyExpression property, @Nonnull OWLDataRange filler) {
        super(filler);
        this.property = OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        this.addSignatureEntitiesToSetForValue(entities, this.getFiller());
        this.addSignatureEntitiesToSetForValue(entities, this.property);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        this.addAnonymousIndividualsToSetForValue(anons, this.getFiller());
        this.addAnonymousIndividualsToSetForValue(anons, this.property);
        if (this.property instanceof HasIncrementalSignatureGenerationSupport) {
            HasIncrementalSignatureGenerationSupport property1 = (HasIncrementalSignatureGenerationSupport)((Object)this.property);
            property1.addAnonymousIndividualsToSet(anons);
        }
    }

    @Override
    public OWLDataPropertyExpression getProperty() {
        return this.property;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLPropertyExpression p2;
        OWLQuantifiedDataRestriction other = (OWLQuantifiedDataRestriction)object;
        OWLDataPropertyExpression p1 = this.getProperty();
        int diff = p1.compareTo(p2 = other.getProperty());
        if (diff != 0) {
            return diff;
        }
        return ((OWLDataRange)this.getFiller()).compareTo(other.getFiller());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLDataRestriction)) {
            return false;
        }
        return this.getProperty().equals(((OWLDataRestriction)obj).getProperty());
    }
}

