/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.io.IOException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.swing.Icon;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.inspector.IconManager;

public class XMBean {
    private final MBeansTab mbeansTab;
    private final ObjectName objectName;
    private Icon icon;
    private String text;
    private Boolean broadcaster;
    private final Object broadcasterLock = new Object();
    private MBeanInfo mbeanInfo;
    private final Object mbeanInfoLock = new Object();

    public XMBean(ObjectName objectName, MBeansTab mbeansTab) {
        this.mbeansTab = mbeansTab;
        this.objectName = objectName;
        this.text = objectName.getKeyProperty("name");
        if (this.text == null) {
            this.text = objectName.getDomain();
        }
        this.icon = MBeanServerDelegate.DELEGATE_NAME.equals(objectName) ? IconManager.MBEANSERVERDELEGATE : IconManager.MBEAN;
    }

    MBeanServerConnection getMBeanServerConnection() {
        return this.mbeansTab.getMBeanServerConnection();
    }

    ProxyClient.SnapshotMBeanServerConnection getSnapshotMBeanServerConnection() {
        return this.mbeansTab.getSnapshotMBeanServerConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isBroadcaster() {
        Object object = this.broadcasterLock;
        synchronized (object) {
            if (this.broadcaster == null) {
                try {
                    this.broadcaster = this.getMBeanServerConnection().isInstanceOf(this.getObjectName(), "javax.management.NotificationBroadcaster");
                }
                catch (Exception e) {
                    if (JConsole.isDebug()) {
                        System.err.println("Couldn't check if MBean [" + this.objectName + "] is a notification broadcaster");
                        e.printStackTrace();
                    }
                    return false;
                }
            }
            return this.broadcaster;
        }
    }

    public Object invoke(String operationName) throws Exception {
        Object result = this.getMBeanServerConnection().invoke(this.getObjectName(), operationName, new Object[0], new String[0]);
        return result;
    }

    public Object invoke(String operationName, Object[] params, String[] sig) throws Exception {
        Object result = this.getMBeanServerConnection().invoke(this.getObjectName(), operationName, params, sig);
        return result;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        this.getMBeanServerConnection().setAttribute(this.getObjectName(), attribute);
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.getSnapshotMBeanServerConnection().getAttribute(this.getObjectName(), attributeName);
    }

    public AttributeList getAttributes(String[] attributeNames) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.getSnapshotMBeanServerConnection().getAttributes(this.getObjectName(), attributeNames);
    }

    public AttributeList getAttributes(MBeanAttributeInfo[] attributeNames) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        String[] attributeString = new String[attributeNames.length];
        for (int i = 0; i < attributeNames.length; ++i) {
            attributeString[i] = attributeNames[i].getName();
        }
        return this.getAttributes(attributeString);
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanInfo getMBeanInfo() throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        Object object = this.mbeanInfoLock;
        synchronized (object) {
            if (this.mbeanInfo == null) {
                this.mbeanInfo = this.getMBeanServerConnection().getMBeanInfo(this.objectName);
            }
            return this.mbeanInfo;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XMBean)) {
            return false;
        }
        XMBean that = (XMBean)obj;
        return this.getObjectName().equals(that.getObjectName());
    }

    public int hashCode() {
        return this.objectName == null ? 0 : this.objectName.hashCode();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String toString() {
        return this.getText();
    }
}

