/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.files;

import com.android.dx.command.DxConsole;
import com.android.dx.command.dexer.Main;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.files.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;

public class JavaToDex {
    private static final String CHARSET_NAME = "UTF-8";
    private String dxErrors;

    public byte[] convert(String javaFile) throws JadxException {
        ByteArrayOutputStream errOut = new ByteArrayOutputStream();
        try {
            DxConsole.err = new PrintStream((OutputStream)errOut, true, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new JadxException(e.getMessage(), e);
        }
        PrintStream oldOut = System.out;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            System.setOut(new PrintStream((OutputStream)baos, true, CHARSET_NAME));
            DxArgs args = new DxArgs("-", new String[]{javaFile});
            this.resetOutDexVar();
            Main.run((Main.Arguments)args);
        }
        catch (Throwable e) {
            throw new JadxException("dx exception: " + e.getMessage(), e);
        }
        finally {
            FileUtils.close(baos);
            System.setOut(oldOut);
        }
        try {
            this.dxErrors = errOut.toString(CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new JadxException("Can't save error output", e);
        }
        return baos.toByteArray();
    }

    private void resetOutDexVar() throws JadxException {
        try {
            Field outputDex = Main.class.getDeclaredField("outputDex");
            outputDex.setAccessible(true);
            outputDex.set(null, null);
        }
        catch (Exception e) {
            throw new JadxException("Failed to reset outputDex field", e);
        }
    }

    public String getDxErrors() {
        return this.dxErrors;
    }

    public boolean isError() {
        return this.dxErrors != null && !this.dxErrors.isEmpty();
    }

    public static class DxArgs
    extends Main.Arguments {
        public DxArgs(String dexFile, String[] input) {
            this.outName = dexFile;
            this.fileNames = input;
            this.jarOutput = false;
            this.optimize = true;
            this.localInfo = true;
            this.coreLibrary = true;
            this.debug = true;
        }
    }
}

