#!/usr/bin/env node
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 80:
/***/ ((module) => {

module.exports = require("open");

/***/ }),

/***/ 329:
/***/ ((module) => {

module.exports = require("argon2");

/***/ }),

/***/ 330:
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"name":"@bitwarden/cli","description":"A secure and free password manager for all of your devices.","version":"2025.5.0","keywords":["bitwarden","password","vault","password manager","cli"],"author":"Bitwarden Inc. <hello@bitwarden.com> (https://bitwarden.com)","homepage":"https://bitwarden.com","repository":{"type":"git","url":"https://github.com/bitwarden/clients"},"license":"SEE LICENSE IN LICENSE.txt","scripts":{"clean":"rimraf dist","build:oss":"cross-env NODE_OPTIONS=\\"--max-old-space-size=8192\\" webpack","build:oss:debug":"npm run build:oss && node --inspect ./build/bw.js","build:oss:watch":"webpack --watch","build:oss:prod":"cross-env NODE_ENV=production webpack","build:oss:prod:watch":"cross-env NODE_ENV=production webpack --watch","debug":"node --inspect ./build/bw.js","publish:npm":"npm run build:oss:prod && npm publish --access public","build:bit":"cross-env NODE_OPTIONS=\\"--max-old-space-size=8192\\" webpack -c ../../bitwarden_license/bit-cli/webpack.config.js","build:bit:debug":"npm run build:bit && node --inspect ./build/bw.js","build:bit:watch":"webpack --watch -c ../../bitwarden_license/bit-cli/webpack.config.js","build:bit:prod":"cross-env NODE_ENV=production npm run build:bit","build:bit:prod:watch":"cross-env NODE_ENV=production npm run build:bit:watch","dist:oss:win":"npm run build:oss:prod && npm run clean && npm run package:oss:win","dist:oss:mac":"npm run build:oss:prod && npm run clean && npm run package:oss:mac","dist:oss:mac-arm64":"npm run build:oss:prod && npm run clean && npm run package:oss:mac-arm64","dist:oss:lin":"npm run build:oss:prod && npm run clean && npm run package:oss:lin","dist:oss:lin-arm64":"npm run build:oss:prod && npm run clean && npm run package:oss:lin-arm64","dist:bit:win":"npm run build:bit:prod && npm run clean && npm run package:bit:win","dist:bit:mac":"npm run build:bit:prod && npm run clean && npm run package:bit:mac","dist:bit:mac-arm64":"npm run build:bit:prod && npm run clean && npm run package:bit:mac-arm64","dist:bit:lin":"npm run build:bit:prod && npm run clean && npm run package:bit:lin","dist:bit:lin-arm64":"npm run build:bit:prod && npm run clean && npm run package:bit:lin-arm64","package:oss:win":"pkg . --targets win-x64 --output ./dist/oss/windows/bw.exe","package:oss:mac":"pkg . --targets macos-x64 --output ./dist/oss/macos/bw","package:oss:mac-arm64":"pkg . --targets macos-arm64 --output ./dist/oss/macos-arm64/bw","package:oss:lin":"pkg . --targets linux-x64 --output ./dist/oss/linux/bw","package:oss:lin-arm64":"pkg . --targets linux-arm64 --output ./dist/oss/linux-arm64/bw","package:bit:win":"pkg . --targets win-x64 --output ./dist/bit/windows/bw.exe","package:bit:mac":"pkg . --targets macos-x64 --output ./dist/bit/macos/bw","package:bit:mac-arm64":"pkg . --targets macos-arm64 --output ./dist/bit/macos-arm64/bw","package:bit:lin":"pkg . --targets linux-x64 --output ./dist/bit/linux/bw","package:bit:lin-arm64":"pkg . --targets linux-arm64 --output ./dist/bit/linux-arm64/bw","test":"jest","test:watch":"jest --watch","test:watch:all":"jest --watchAll"},"bin":{"bw":"build/bw.js"},"pkg":{"assets":["./build/**/*","../../node_modules/argon2/**/*"]},"dependencies":{"@koa/multer":"3.1.0","@koa/router":"13.1.0","argon2":"0.41.1","big-integer":"1.6.52","browser-hrtime":"1.1.8","chalk":"4.1.2","commander":"11.1.0","core-js":"3.40.0","form-data":"4.0.1","https-proxy-agent":"7.0.6","inquirer":"8.2.6","jsdom":"26.1.0","jszip":"3.10.1","koa":"2.16.1","koa-bodyparser":"4.4.1","koa-json":"2.0.2","lowdb":"1.0.0","lunr":"2.3.9","multer":"1.4.5-lts.2","node-fetch":"2.6.12","node-forge":"1.3.1","open":"8.4.2","papaparse":"5.5.2","proper-lockfile":"4.1.2","rxjs":"7.8.1","tldts":"7.0.1","zxcvbn":"4.4.2"}}');

/***/ }),

/***/ 414:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $Pc: () => (/* binding */ __wbg_new_8a6f238a6ece86ea),
/* harmony export */   $Uh: () => (/* binding */ __wbg_debug_e17b51583ca6a632),
/* harmony export */   BFX: () => (/* binding */ __wbg_setmode_5dc300b865044b65),
/* harmony export */   BGI: () => (/* binding */ __wbindgen_jsval_eq),
/* harmony export */   BZb: () => (/* binding */ __wbindgen_object_clone_ref),
/* harmony export */   CB9: () => (/* binding */ __wbg_crypto_574e78ad8b13b65f),
/* harmony export */   CF8: () => (/* binding */ __wbg_signal_aaf9ad74119f20a4),
/* harmony export */   DMD: () => (/* binding */ __wbindgen_bigint_get_as_i64),
/* harmony export */   DS5: () => (/* binding */ __wbg_setTimeout_2e707715f8cc9497),
/* harmony export */   Dn4: () => (/* binding */ __wbg_next_6574e1a8a62d1055),
/* harmony export */   FHK: () => (/* binding */ __wbg_buffer_609cc3eee51ed158),
/* harmony export */   FPO: () => (/* binding */ __wbg_getwithrefkey_1dc361bd10053bfe),
/* harmony export */   Fxh: () => (/* binding */ __wbg_msCrypto_a61aeb35a24c1329),
/* harmony export */   GQG: () => (/* binding */ __wbg_then_44b73946d2fb3e7d),
/* harmony export */   Geh: () => (/* binding */ init_sdk),
/* harmony export */   GuA: () => (/* binding */ __wbindgen_is_string),
/* harmony export */   HBq: () => (/* binding */ __wbg_set_65595bdd868b3009),
/* harmony export */   HSm: () => (/* binding */ __wbg_has_a5ea9117f258a0ec),
/* harmony export */   HtP: () => (/* binding */ __wbg_newwithlength_a381634e90c276d4),
/* harmony export */   HvI: () => (/* binding */ __wbg_ipcclientsubscription_new),
/* harmony export */   Hzn: () => (/* binding */ __wbg_instanceof_Response_f2cc20d9f7dfd644),
/* harmony export */   IEs: () => (/* binding */ PureCrypto),
/* harmony export */   IZ7: () => (/* binding */ __wbg_randomFillSync_ac0988aba3254290),
/* harmony export */   KDQ: () => (/* binding */ __wbindgen_closure_wrapper2876),
/* harmony export */   KhK: () => (/* binding */ __wbg_parse_def2e24ef1252aff),
/* harmony export */   KwY: () => (/* binding */ __wbg_versions_c01dfd4722a88165),
/* harmony export */   L1P: () => (/* binding */ __wbg_setvariant_d1d41b778dfe9c17),
/* harmony export */   L3p: () => (/* binding */ __wbg_instanceof_Map_f3469ce2244d2430),
/* harmony export */   LCp: () => (/* binding */ __wbindgen_cb_drop),
/* harmony export */   LMq: () => (/* binding */ __wbg_value_cd1ffa7b1ab794f1),
/* harmony export */   M2: () => (/* binding */ __wbg_new_78feb108b6472713),
/* harmony export */   Moj: () => (/* binding */ __wbg_headers_9cb51cfd2ac780a4),
/* harmony export */   NDY: () => (/* binding */ __wbg_clearTimeout_86721db0036bea98),
/* harmony export */   NJs: () => (/* binding */ __wbg_set_3f1d0b984ed272ed),
/* harmony export */   NhE: () => (/* binding */ __wbindgen_boolean_get),
/* harmony export */   Nhd: () => (/* binding */ __wbg_setbody_5923b78a95eedf29),
/* harmony export */   Oyk: () => (/* binding */ __wbg_String_8f0eb39a4a4c2f66),
/* harmony export */   PPV: () => (/* binding */ __wbg_getTime_46267b1c24877e30),
/* harmony export */   PRY: () => (/* binding */ __wbindgen_is_function),
/* harmony export */   Py0: () => (/* binding */ __wbindgen_memory),
/* harmony export */   QRK: () => (/* binding */ __wbindgen_number_new),
/* harmony export */   Qg3: () => (/* binding */ __wbindgen_bigint_from_u64),
/* harmony export */   Qnr: () => (/* binding */ __wbindgen_throw),
/* harmony export */   RG9: () => (/* binding */ __wbg_new_e25e5aab09ff45db),
/* harmony export */   RKd: () => (/* binding */ __wbg_info_033d8b8a0838f1d3),
/* harmony export */   RKz: () => (/* binding */ __wbg_get_b9b93047fe3cf45b),
/* harmony export */   RR8: () => (/* binding */ __wbg_new_018dcc2d6c8c2f6a),
/* harmony export */   RXH: () => (/* binding */ __wbg_fetch_d36a73832f0a45e8),
/* harmony export */   RjG: () => (/* binding */ __wbindgen_error_new),
/* harmony export */   Ry: () => (/* binding */ __wbg_length_e2d2a49132c1b256),
/* harmony export */   SJf: () => (/* binding */ __wbg_instanceof_Uint8Array_17156bcf118086a9),
/* harmony export */   St$: () => (/* binding */ __wbg_incomingmessage_new),
/* harmony export */   TOc: () => (/* binding */ __wbg_subarray_aa9065fa9dc5df96),
/* harmony export */   Tbm: () => (/* binding */ __wbg_append_8c7dd8d641a5f01b),
/* harmony export */   Tp3: () => (/* binding */ __wbg_url_ae10c34ca209681d),
/* harmony export */   Tt0: () => (/* binding */ __wbg_send_9b8fc6bb517867dd),
/* harmony export */   U8c: () => (/* binding */ __wbindgen_jsval_loose_eq),
/* harmony export */   VrZ: () => (/* binding */ __wbg_newnoargs_105ed471475aaf50),
/* harmony export */   WYM: () => (/* binding */ __wbg_error_7534b8e9a36f1ab4),
/* harmony export */   WqA: () => (/* binding */ __wbg_append_b2d1fc16de2a0e81),
/* harmony export */   Xb8: () => (/* binding */ __wbg_done_769e5ede4b31c67b),
/* harmony export */   Y6F: () => (/* binding */ __wbg_stringify_f7ed6987935b4a24),
/* harmony export */   Yb6: () => (/* binding */ __wbg_isSafeInteger_343e2beeeece1bb0),
/* harmony export */   YkQ: () => (/* binding */ __wbindgen_is_bigint),
/* harmony export */   Z87: () => (/* binding */ __wbg_error_80de38b3f7cc3c3c),
/* harmony export */   ZD9: () => (/* binding */ __wbg_warn_aaf1f4664a035bd6),
/* harmony export */   _hX: () => (/* binding */ __wbg_setmethod_3c5280fe5d890842),
/* harmony export */   _mt: () => (/* binding */ __wbg_queueMicrotask_97d92b4fcc8a61c5),
/* harmony export */   a4S: () => (/* binding */ __wbg_settype_39ed370d3edd403c),
/* harmony export */   apR: () => (/* binding */ __wbg_getRandomValues_3d90134a348e46b3),
/* harmony export */   bkt: () => (/* binding */ __wbindgen_object_drop_ref),
/* harmony export */   c6u: () => (/* binding */ __wbg_new_23a2665fac83c611),
/* harmony export */   cVx: () => (/* binding */ __wbg_append_299d5d48292c0495),
/* harmony export */   ce0: () => (/* binding */ __wbindgen_bigint_from_i64),
/* harmony export */   d_N: () => (/* binding */ __wbg_append_b44785ebeb668479),
/* harmony export */   du5: () => (/* binding */ __wbg_senderror_new),
/* harmony export */   dzD: () => (/* binding */ __wbg_get_67b2ba62fc30de12),
/* harmony export */   eIr: () => (/* binding */ __wbg_length_a446193dc22c12f8),
/* harmony export */   eW0: () => (/* binding */ __wbg_iterator_9a24c88df860dc65),
/* harmony export */   fb$: () => (/* binding */ __wbg_static_accessor_SELF_37c5d418e4bf5819),
/* harmony export */   gGA: () => (/* binding */ __wbg_instanceof_ArrayBuffer_e14585432e3737fc),
/* harmony export */   gHg: () => (/* binding */ __wbg_entries_3265d4158b33e5dc),
/* harmony export */   gMQ: () => (/* binding */ __wbg_abort_775ef1d17fc65868),
/* harmony export */   gRe: () => (/* binding */ __wbg_fetch_509096533071c657),
/* harmony export */   gae: () => (/* binding */ BitwardenClient),
/* harmony export */   gtG: () => (/* binding */ __wbg_text_7805bea50de2af49),
/* harmony export */   hI8: () => (/* binding */ __wbg_newwithbyteoffsetandlength_d97e637ebe145a9a),
/* harmony export */   heb: () => (/* binding */ __wbg_newwithstrandinit_06c535e0a867c635),
/* harmony export */   ii7: () => (/* binding */ __wbg_static_accessor_GLOBAL_88a902d13a557d07),
/* harmony export */   k2R: () => (/* binding */ __wbg_queueMicrotask_d3219def82552485),
/* harmony export */   kK3: () => (/* binding */ __wbg_status_f6360336ca686bf0),
/* harmony export */   l0x: () => (/* binding */ __wbg_setsignal_75b21ef3a81de905),
/* harmony export */   lIU: () => (/* binding */ __wbg_set_wasm),
/* harmony export */   lU$: () => (/* binding */ __wbg_node_905d3e251edff8a2),
/* harmony export */   mEh: () => (/* binding */ __wbg_require_60cc747a6bc5215a),
/* harmony export */   n8S: () => (/* binding */ __wbg_abort_410ec47a64ac6117),
/* harmony export */   p8e: () => (/* binding */ __wbg_set_37837023f3d740e8),
/* harmony export */   qNE: () => (/* binding */ __wbindgen_string_get),
/* harmony export */   qe7: () => (/* binding */ __wbg_newwithu8arraysequenceandoptions_068570c487f69127),
/* harmony export */   qmw: () => (/* binding */ __wbindgen_as_number),
/* harmony export */   qvD: () => (/* binding */ __wbindgen_is_object),
/* harmony export */   rQI: () => (/* binding */ __wbg_log_cad59bb680daec67),
/* harmony export */   rk2: () => (/* binding */ __wbg_setheaders_834c0bdb6a8949ad),
/* harmony export */   rl: () => (/* binding */ __wbindgen_debug_string),
/* harmony export */   sWe: () => (/* binding */ __wbindgen_number_get),
/* harmony export */   shm: () => (/* binding */ __wbg_receiveerror_new),
/* harmony export */   tTc: () => (/* binding */ __wbg_setname_c0e2d6f348c746f4),
/* harmony export */   tZf: () => (/* binding */ __wbg_push_737cfc8c1432c2c6),
/* harmony export */   typ: () => (/* binding */ __wbg_getRandomValues_b8f5dbd5f3995a9e),
/* harmony export */   uod: () => (/* binding */ __wbg_isArray_a1eab7e0d067391b),
/* harmony export */   uw1: () => (/* binding */ __wbg_setcredentials_c3a22f1cd105a2c6),
/* harmony export */   vUM: () => (/* binding */ __wbindgen_is_undefined),
/* harmony export */   vUh: () => (/* binding */ __wbg_new_f24b6d53abe5bc82),
/* harmony export */   vVD: () => (/* binding */ __wbg_new_a12002a7f91c75be),
/* harmony export */   vZk: () => (/* binding */ __wbindgen_closure_wrapper3269),
/* harmony export */   va5: () => (/* binding */ __wbg_new_405e22f390576ce2),
/* harmony export */   w6e: () => (/* binding */ __wbg_static_accessor_GLOBAL_THIS_56578be7e9f832b0),
/* harmony export */   w9h: () => (/* binding */ __wbg_call_7cccdd69e0791ae2),
/* harmony export */   wHY: () => (/* binding */ __wbg_call_672a4d21634d4a24),
/* harmony export */   wJz: () => (/* binding */ __wbg_resolve_4851785c9c5f573d),
/* harmony export */   wd3: () => (/* binding */ __wbg_new_c68d7209be747379),
/* harmony export */   x$X: () => (/* binding */ __wbg_stack_0ed75d68575b0f3c),
/* harmony export */   x0C: () => (/* binding */ __wbg_static_accessor_WINDOW_5de37043a91a9c40),
/* harmony export */   x2q: () => (/* binding */ __wbg_process_dc0fbacc7c1c06f7),
/* harmony export */   xV_: () => (/* binding */ __wbg_then_48b406749878a531),
/* harmony export */   yU8: () => (/* binding */ __wbg_new0_f788a2397c7ca929),
/* harmony export */   ycJ: () => (/* binding */ __wbindgen_string_new),
/* harmony export */   yqB: () => (/* binding */ __wbg_next_25feadfc0913fea9),
/* harmony export */   z09: () => (/* binding */ __wbg_new_9fd39a253424609a),
/* harmony export */   zEy: () => (/* binding */ __wbindgen_in)
/* harmony export */ });
/* unused harmony exports isEncryptionSettingsError, isCryptoError, isExportError, isPasswordError, isPassphraseError, isChannelError, isDeserializeError, isSshKeyExportError, isSshKeyImportError, isKeyGenerationError, isDecryptError, isEncryptError, isTotpError, isCipherError, isDecryptFileError, isEncryptFileError, set_log_level, generate_ssh_key, import_ssh_key, isTestError, CardLinkedIdType, CipherRepromptType, CipherType, FieldType, IdentityLinkedIdType, LogLevel, LoginLinkedIdType, SecureNoteType, UriMatchType, AttachmentsClient, CiphersClient, CryptoClient, ExporterClient, FoldersClient, GeneratorClient, IncomingMessage, IpcClient, IpcClientSubscription, IpcCommunicationBackend, OutgoingMessage, ReceiveError, SendError, TotpClient, VaultClient */
/* module decorator */ module = __webpack_require__.hmd(module);
let wasm;
function __wbg_set_wasm(val) {
  wasm = val;
}

const heap = new Array(128).fill(undefined);

heap.push(undefined, null, true, false);

function getObject(idx) {
  return heap[idx];
}

let WASM_VECTOR_LEN = 0;

let cachedUint8ArrayMemory0 = null;

function getUint8ArrayMemory0() {
  if (cachedUint8ArrayMemory0 === null || cachedUint8ArrayMemory0.byteLength === 0) {
    cachedUint8ArrayMemory0 = new Uint8Array(wasm.memory.buffer);
  }
  return cachedUint8ArrayMemory0;
}

const lTextEncoder =
  typeof TextEncoder === "undefined" ? (0, module.require)("util").TextEncoder : TextEncoder;

let cachedTextEncoder = new lTextEncoder("utf-8");

const encodeString =
  typeof cachedTextEncoder.encodeInto === "function"
    ? function (arg, view) {
        return cachedTextEncoder.encodeInto(arg, view);
      }
    : function (arg, view) {
        const buf = cachedTextEncoder.encode(arg);
        view.set(buf);
        return {
          read: arg.length,
          written: buf.length,
        };
      };

function passStringToWasm0(arg, malloc, realloc) {
  if (realloc === undefined) {
    const buf = cachedTextEncoder.encode(arg);
    const ptr = malloc(buf.length, 1) >>> 0;
    getUint8ArrayMemory0()
      .subarray(ptr, ptr + buf.length)
      .set(buf);
    WASM_VECTOR_LEN = buf.length;
    return ptr;
  }

  let len = arg.length;
  let ptr = malloc(len, 1) >>> 0;

  const mem = getUint8ArrayMemory0();

  let offset = 0;

  for (; offset < len; offset++) {
    const code = arg.charCodeAt(offset);
    if (code > 0x7f) break;
    mem[ptr + offset] = code;
  }

  if (offset !== len) {
    if (offset !== 0) {
      arg = arg.slice(offset);
    }
    ptr = realloc(ptr, len, (len = offset + arg.length * 3), 1) >>> 0;
    const view = getUint8ArrayMemory0().subarray(ptr + offset, ptr + len);
    const ret = encodeString(arg, view);

    offset += ret.written;
    ptr = realloc(ptr, len, offset, 1) >>> 0;
  }

  WASM_VECTOR_LEN = offset;
  return ptr;
}

let cachedDataViewMemory0 = null;

function getDataViewMemory0() {
  if (
    cachedDataViewMemory0 === null ||
    cachedDataViewMemory0.buffer.detached === true ||
    (cachedDataViewMemory0.buffer.detached === undefined &&
      cachedDataViewMemory0.buffer !== wasm.memory.buffer)
  ) {
    cachedDataViewMemory0 = new DataView(wasm.memory.buffer);
  }
  return cachedDataViewMemory0;
}

const lTextDecoder =
  typeof TextDecoder === "undefined" ? (0, module.require)("util").TextDecoder : TextDecoder;

let cachedTextDecoder = new lTextDecoder("utf-8", { ignoreBOM: true, fatal: true });

cachedTextDecoder.decode();

function getStringFromWasm0(ptr, len) {
  ptr = ptr >>> 0;
  return cachedTextDecoder.decode(getUint8ArrayMemory0().subarray(ptr, ptr + len));
}

let heap_next = heap.length;

function addHeapObject(obj) {
  if (heap_next === heap.length) heap.push(heap.length + 1);
  const idx = heap_next;
  heap_next = heap[idx];

  heap[idx] = obj;
  return idx;
}

function handleError(f, args) {
  try {
    return f.apply(this, args);
  } catch (e) {
    wasm.__wbindgen_exn_store(addHeapObject(e));
  }
}

function dropObject(idx) {
  if (idx < 132) return;
  heap[idx] = heap_next;
  heap_next = idx;
}

function takeObject(idx) {
  const ret = getObject(idx);
  dropObject(idx);
  return ret;
}

function getArrayU8FromWasm0(ptr, len) {
  ptr = ptr >>> 0;
  return getUint8ArrayMemory0().subarray(ptr / 1, ptr / 1 + len);
}

function isLikeNone(x) {
  return x === undefined || x === null;
}

const CLOSURE_DTORS =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((state) => {
        wasm.__wbindgen_export_4.get(state.dtor)(state.a, state.b);
      });

function makeMutClosure(arg0, arg1, dtor, f) {
  const state = { a: arg0, b: arg1, cnt: 1, dtor };
  const real = (...args) => {
    // First up with a closure we increment the internal reference
    // count. This ensures that the Rust closure environment won't
    // be deallocated while we're invoking it.
    state.cnt++;
    const a = state.a;
    state.a = 0;
    try {
      return f(a, state.b, ...args);
    } finally {
      if (--state.cnt === 0) {
        wasm.__wbindgen_export_4.get(state.dtor)(a, state.b);
        CLOSURE_DTORS.unregister(state);
      } else {
        state.a = a;
      }
    }
  };
  real.original = state;
  CLOSURE_DTORS.register(real, state, state);
  return real;
}

function debugString(val) {
  // primitive types
  const type = typeof val;
  if (type == "number" || type == "boolean" || val == null) {
    return `${val}`;
  }
  if (type == "string") {
    return `"${val}"`;
  }
  if (type == "symbol") {
    const description = val.description;
    if (description == null) {
      return "Symbol";
    } else {
      return `Symbol(${description})`;
    }
  }
  if (type == "function") {
    const name = val.name;
    if (typeof name == "string" && name.length > 0) {
      return `Function(${name})`;
    } else {
      return "Function";
    }
  }
  // objects
  if (Array.isArray(val)) {
    const length = val.length;
    let debug = "[";
    if (length > 0) {
      debug += debugString(val[0]);
    }
    for (let i = 1; i < length; i++) {
      debug += ", " + debugString(val[i]);
    }
    debug += "]";
    return debug;
  }
  // Test for built-in
  const builtInMatches = /\[object ([^\]]+)\]/.exec(toString.call(val));
  let className;
  if (builtInMatches && builtInMatches.length > 1) {
    className = builtInMatches[1];
  } else {
    // Failed to match the standard '[object ClassName]'
    return toString.call(val);
  }
  if (className == "Object") {
    // we're a user defined class or Object
    // JSON.stringify avoids problems with cycles, and is generally much
    // easier than looping through ownProperties of `val`.
    try {
      return "Object(" + JSON.stringify(val) + ")";
    } catch (_) {
      return "Object";
    }
  }
  // errors
  if (val instanceof Error) {
    return `${val.name}: ${val.message}\n${val.stack}`;
  }
  // TODO we could test for more things here, like `Set`s and `Map`s.
  return className;
}

let stack_pointer = 128;

function addBorrowedObject(obj) {
  if (stack_pointer == 1) throw new Error("out of js stack");
  heap[--stack_pointer] = obj;
  return stack_pointer;
}
/**
 * @param {any} error
 * @returns {boolean}
 */
function isEncryptionSettingsError(error) {
  try {
    const ret = wasm.isEncryptionSettingsError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isCryptoError(error) {
  try {
    const ret = wasm.isCryptoError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

function passArrayJsValueToWasm0(array, malloc) {
  const ptr = malloc(array.length * 4, 4) >>> 0;
  const mem = getDataViewMemory0();
  for (let i = 0; i < array.length; i++) {
    mem.setUint32(ptr + 4 * i, addHeapObject(array[i]), true);
  }
  WASM_VECTOR_LEN = array.length;
  return ptr;
}

function getArrayJsValueFromWasm0(ptr, len) {
  ptr = ptr >>> 0;
  const mem = getDataViewMemory0();
  const result = [];
  for (let i = ptr; i < ptr + 4 * len; i += 4) {
    result.push(takeObject(mem.getUint32(i, true)));
  }
  return result;
}
/**
 * @param {any} error
 * @returns {boolean}
 */
function isExportError(error) {
  try {
    const ret = wasm.isExportError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isPasswordError(error) {
  try {
    const ret = wasm.isPasswordError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isPassphraseError(error) {
  try {
    const ret = wasm.isPassphraseError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

function passArray8ToWasm0(arg, malloc) {
  const ptr = malloc(arg.length * 1, 1) >>> 0;
  getUint8ArrayMemory0().set(arg, ptr / 1);
  WASM_VECTOR_LEN = arg.length;
  return ptr;
}

function _assertClass(instance, klass) {
  if (!(instance instanceof klass)) {
    throw new Error(`expected instance of ${klass.name}`);
  }
}
/**
 * @param {any} error
 * @returns {boolean}
 */
function isChannelError(error) {
  try {
    const ret = wasm.isChannelError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isDeserializeError(error) {
  try {
    const ret = wasm.isDeserializeError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isSshKeyExportError(error) {
  try {
    const ret = wasm.isSshKeyExportError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isSshKeyImportError(error) {
  try {
    const ret = wasm.isSshKeyImportError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isKeyGenerationError(error) {
  try {
    const ret = wasm.isKeyGenerationError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isDecryptError(error) {
  try {
    const ret = wasm.isDecryptError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isEncryptError(error) {
  try {
    const ret = wasm.isEncryptError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isTotpError(error) {
  try {
    const ret = wasm.isTotpError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isCipherError(error) {
  try {
    const ret = wasm.isCipherError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isDecryptFileError(error) {
  try {
    const ret = wasm.isDecryptFileError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isEncryptFileError(error) {
  try {
    const ret = wasm.isEncryptFileError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {LogLevel} level
 */
function set_log_level(level) {
  wasm.set_log_level(level);
}

/**
 * @param {LogLevel | null} [log_level]
 */
function init_sdk(log_level) {
  wasm.init_sdk(isLikeNone(log_level) ? 5 : log_level);
}

/**
 * Generate a new SSH key pair
 *
 * # Arguments
 * - `key_algorithm` - The algorithm to use for the key pair
 *
 * # Returns
 * - `Ok(SshKey)` if the key was successfully generated
 * - `Err(KeyGenerationError)` if the key could not be generated
 * @param {KeyAlgorithm} key_algorithm
 * @returns {SshKeyView}
 */
function generate_ssh_key(key_algorithm) {
  try {
    const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
    wasm.generate_ssh_key(retptr, addHeapObject(key_algorithm));
    var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
    var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
    var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
    if (r2) {
      throw takeObject(r1);
    }
    return takeObject(r0);
  } finally {
    wasm.__wbindgen_add_to_stack_pointer(16);
  }
}

/**
 * Convert a PCKS8 or OpenSSH encrypted or unencrypted private key
 * to an OpenSSH private key with public key and fingerprint
 *
 * # Arguments
 * - `imported_key` - The private key to convert
 * - `password` - The password to use for decrypting the key
 *
 * # Returns
 * - `Ok(SshKey)` if the key was successfully coneverted
 * - `Err(PasswordRequired)` if the key is encrypted and no password was provided
 * - `Err(WrongPassword)` if the password provided is incorrect
 * - `Err(ParsingError)` if the key could not be parsed
 * - `Err(UnsupportedKeyType)` if the key type is not supported
 * @param {string} imported_key
 * @param {string | null} [password]
 * @returns {SshKeyView}
 */
function import_ssh_key(imported_key, password) {
  try {
    const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
    const ptr0 = passStringToWasm0(imported_key, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    var ptr1 = isLikeNone(password)
      ? 0
      : passStringToWasm0(password, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len1 = WASM_VECTOR_LEN;
    wasm.import_ssh_key(retptr, ptr0, len0, ptr1, len1);
    var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
    var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
    var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
    if (r2) {
      throw takeObject(r1);
    }
    return takeObject(r0);
  } finally {
    wasm.__wbindgen_add_to_stack_pointer(16);
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isTestError(error) {
  try {
    const ret = wasm.isTestError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

function __wbg_adapter_50(arg0, arg1) {
  wasm._dyn_core__ops__function__FnMut_____Output___R_as_wasm_bindgen__closure__WasmClosure___describe__invoke__hbd39acb59da78aff(
    arg0,
    arg1,
  );
}

function __wbg_adapter_53(arg0, arg1, arg2) {
  wasm._dyn_core__ops__function__FnMut__A____Output___R_as_wasm_bindgen__closure__WasmClosure___describe__invoke__h1fa3d18f05e030bb(
    arg0,
    arg1,
    addHeapObject(arg2),
  );
}

function __wbg_adapter_237(arg0, arg1, arg2, arg3) {
  wasm.wasm_bindgen__convert__closures__invoke2_mut__h2a33b0877ef96682(
    arg0,
    arg1,
    addHeapObject(arg2),
    addHeapObject(arg3),
  );
}

/**
 * @enum {300 | 301 | 302 | 303 | 304 | 305}
 */
const CardLinkedIdType = Object.freeze({
  CardholderName: 300,
  300: "CardholderName",
  ExpMonth: 301,
  301: "ExpMonth",
  ExpYear: 302,
  302: "ExpYear",
  Code: 303,
  303: "Code",
  Brand: 304,
  304: "Brand",
  Number: 305,
  305: "Number",
});
/**
 * @enum {0 | 1}
 */
const CipherRepromptType = Object.freeze({
  None: 0,
  0: "None",
  Password: 1,
  1: "Password",
});
/**
 * @enum {1 | 2 | 3 | 4 | 5}
 */
const CipherType = Object.freeze({
  Login: 1,
  1: "Login",
  SecureNote: 2,
  2: "SecureNote",
  Card: 3,
  3: "Card",
  Identity: 4,
  4: "Identity",
  SshKey: 5,
  5: "SshKey",
});
/**
 * @enum {0 | 1 | 2 | 3}
 */
const FieldType = Object.freeze({
  Text: 0,
  0: "Text",
  Hidden: 1,
  1: "Hidden",
  Boolean: 2,
  2: "Boolean",
  Linked: 3,
  3: "Linked",
});
/**
 * @enum {400 | 401 | 402 | 403 | 404 | 405 | 406 | 407 | 408 | 409 | 410 | 411 | 412 | 413 | 414 | 415 | 416 | 417 | 418}
 */
const IdentityLinkedIdType = Object.freeze({
  Title: 400,
  400: "Title",
  MiddleName: 401,
  401: "MiddleName",
  Address1: 402,
  402: "Address1",
  Address2: 403,
  403: "Address2",
  Address3: 404,
  404: "Address3",
  City: 405,
  405: "City",
  State: 406,
  406: "State",
  PostalCode: 407,
  407: "PostalCode",
  Country: 408,
  408: "Country",
  Company: 409,
  409: "Company",
  Email: 410,
  410: "Email",
  Phone: 411,
  411: "Phone",
  Ssn: 412,
  412: "Ssn",
  Username: 413,
  413: "Username",
  PassportNumber: 414,
  414: "PassportNumber",
  LicenseNumber: 415,
  415: "LicenseNumber",
  FirstName: 416,
  416: "FirstName",
  LastName: 417,
  417: "LastName",
  FullName: 418,
  418: "FullName",
});
/**
 * @enum {0 | 1 | 2 | 3 | 4}
 */
const LogLevel = Object.freeze({
  Trace: 0,
  0: "Trace",
  Debug: 1,
  1: "Debug",
  Info: 2,
  2: "Info",
  Warn: 3,
  3: "Warn",
  Error: 4,
  4: "Error",
});
/**
 * @enum {100 | 101}
 */
const LoginLinkedIdType = Object.freeze({
  Username: 100,
  100: "Username",
  Password: 101,
  101: "Password",
});
/**
 * @enum {0}
 */
const SecureNoteType = Object.freeze({
  Generic: 0,
  0: "Generic",
});
/**
 * @enum {0 | 1 | 2 | 3 | 4 | 5}
 */
const UriMatchType = Object.freeze({
  Domain: 0,
  0: "Domain",
  Host: 1,
  1: "Host",
  StartsWith: 2,
  2: "StartsWith",
  Exact: 3,
  3: "Exact",
  RegularExpression: 4,
  4: "RegularExpression",
  Never: 5,
  5: "Never",
});

const __wbindgen_enum_RequestCredentials = ["omit", "same-origin", "include"];

const __wbindgen_enum_RequestMode = ["same-origin", "no-cors", "cors", "navigate"];

const AttachmentsClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_attachmentsclient_free(ptr >>> 0, 1));

class AttachmentsClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(AttachmentsClient.prototype);
    obj.__wbg_ptr = ptr;
    AttachmentsClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    AttachmentsClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_attachmentsclient_free(ptr, 0);
  }
  /**
   * Decrypts an attachment's encrypted content
   * @param {Cipher} cipher
   * @param {AttachmentView} attachment
   * @param {Uint8Array} encrypted_buffer
   * @returns {Uint8Array}
   */
  decrypt_buffer(cipher, attachment, encrypted_buffer) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(encrypted_buffer, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.attachmentsclient_decrypt_buffer(
        retptr,
        this.__wbg_ptr,
        addHeapObject(cipher),
        addHeapObject(attachment),
        ptr0,
        len0,
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v2 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v2;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const BitwardenClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_bitwardenclient_free(ptr >>> 0, 1));

class BitwardenClient {
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    BitwardenClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_bitwardenclient_free(ptr, 0);
  }
  /**
   * @param {ClientSettings | null} [settings]
   */
  constructor(settings) {
    const ret = wasm.bitwardenclient_new(isLikeNone(settings) ? 0 : addHeapObject(settings));
    this.__wbg_ptr = ret >>> 0;
    BitwardenClientFinalization.register(this, this.__wbg_ptr, this);
    return this;
  }
  /**
   * Test method, echoes back the input
   * @param {string} msg
   * @returns {string}
   */
  echo(msg) {
    let deferred2_0;
    let deferred2_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(msg, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.bitwardenclient_echo(retptr, this.__wbg_ptr, ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      deferred2_0 = r0;
      deferred2_1 = r1;
      return getStringFromWasm0(r0, r1);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred2_0, deferred2_1, 1);
    }
  }
  /**
   * @returns {string}
   */
  version() {
    let deferred1_0;
    let deferred1_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.bitwardenclient_version(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      deferred1_0 = r0;
      deferred1_1 = r1;
      return getStringFromWasm0(r0, r1);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
  }
  /**
   * @param {string} msg
   */
  throw(msg) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(msg, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.bitwardenclient_throw(retptr, this.__wbg_ptr, ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Test method, calls http endpoint
   * @param {string} url
   * @returns {Promise<string>}
   */
  http_get(url) {
    const ptr0 = passStringToWasm0(url, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.bitwardenclient_http_get(this.__wbg_ptr, ptr0, len0);
    return takeObject(ret);
  }
  /**
   * @returns {CryptoClient}
   */
  crypto() {
    const ret = wasm.bitwardenclient_crypto(this.__wbg_ptr);
    return CryptoClient.__wrap(ret);
  }
  /**
   * @returns {VaultClient}
   */
  vault() {
    const ret = wasm.bitwardenclient_crypto(this.__wbg_ptr);
    return VaultClient.__wrap(ret);
  }
  /**
   * Constructs a specific client for generating passwords and passphrases
   * @returns {GeneratorClient}
   */
  generator() {
    const ret = wasm.bitwardenclient_generator(this.__wbg_ptr);
    return GeneratorClient.__wrap(ret);
  }
  /**
   * @returns {ExporterClient}
   */
  exporters() {
    const ret = wasm.bitwardenclient_crypto(this.__wbg_ptr);
    return ExporterClient.__wrap(ret);
  }
}

const CiphersClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_ciphersclient_free(ptr >>> 0, 1));

class CiphersClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(CiphersClient.prototype);
    obj.__wbg_ptr = ptr;
    CiphersClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    CiphersClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_ciphersclient_free(ptr, 0);
  }
  /**
   * Encrypt cipher
   *
   * # Arguments
   * - `cipher_view` - The decrypted cipher to encrypt
   *
   * # Returns
   * - `Ok(Cipher)` containing the encrypted cipher
   * - `Err(EncryptError)` if encryption fails
   * @param {CipherView} cipher_view
   * @returns {Cipher}
   */
  encrypt(cipher_view) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.ciphersclient_encrypt(retptr, this.__wbg_ptr, addHeapObject(cipher_view));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Decrypt cipher
   *
   * # Arguments
   * - `cipher` - The encrypted cipher to decrypt
   *
   * # Returns
   * - `Ok(CipherView)` containing the decrypted cipher
   * - `Err(DecryptError)` if decryption fails
   * @param {Cipher} cipher
   * @returns {CipherView}
   */
  decrypt(cipher) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.ciphersclient_decrypt(retptr, this.__wbg_ptr, addHeapObject(cipher));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Decrypt list of ciphers
   *
   * # Arguments
   * - `ciphers` - The list of encrypted ciphers to decrypt
   *
   * # Returns
   * - `Ok(Vec<CipherListView>)` containing the decrypted ciphers
   * - `Err(DecryptError)` if decryption fails
   * @param {Cipher[]} ciphers
   * @returns {CipherListView[]}
   */
  decrypt_list(ciphers) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArrayJsValueToWasm0(ciphers, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.ciphersclient_decrypt_list(retptr, this.__wbg_ptr, ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v2 = getArrayJsValueFromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 4, 4);
      return v2;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Decrypt FIDO2 credentials
   *
   * # Arguments
   * - `cipher_view` - Cipher to encrypt containing the FIDO2 credential
   *
   * # Returns
   * - `Ok(Vec<Fido2CredentialView>)` containing the decrypted FIDO2 credentials
   * - `Err(DecryptError)` if decryption fails
   * @param {CipherView} cipher_view
   * @returns {Fido2CredentialView[]}
   */
  decrypt_fido2_credentials(cipher_view) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.ciphersclient_decrypt_fido2_credentials(
        retptr,
        this.__wbg_ptr,
        addHeapObject(cipher_view),
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v1 = getArrayJsValueFromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 4, 4);
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Decrypt key
   *
   * This method is a temporary solution to allow typescript client access to decrypted key
   * values, particularly for FIDO2 credentials.
   *
   * # Arguments
   * - `cipher_view` - Decrypted cipher containing the key
   *
   * # Returns
   * - `Ok(String)` containing the decrypted key
   * - `Err(CipherError)`
   * @param {CipherView} cipher_view
   * @returns {string}
   */
  decrypt_fido2_private_key(cipher_view) {
    let deferred2_0;
    let deferred2_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.ciphersclient_decrypt_fido2_private_key(
        retptr,
        this.__wbg_ptr,
        addHeapObject(cipher_view),
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr1 = r0;
      var len1 = r1;
      if (r3) {
        ptr1 = 0;
        len1 = 0;
        throw takeObject(r2);
      }
      deferred2_0 = ptr1;
      deferred2_1 = len1;
      return getStringFromWasm0(ptr1, len1);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred2_0, deferred2_1, 1);
    }
  }
}

const CryptoClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_cryptoclient_free(ptr >>> 0, 1));

class CryptoClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(CryptoClient.prototype);
    obj.__wbg_ptr = ptr;
    CryptoClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    CryptoClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_cryptoclient_free(ptr, 0);
  }
  /**
   * Initialization method for the user crypto. Needs to be called before any other crypto
   * operations.
   * @param {InitUserCryptoRequest} req
   * @returns {Promise<void>}
   */
  initialize_user_crypto(req) {
    const ret = wasm.cryptoclient_initialize_user_crypto(this.__wbg_ptr, addHeapObject(req));
    return takeObject(ret);
  }
  /**
   * Initialization method for the organization crypto. Needs to be called after
   * `initialize_user_crypto` but before any other crypto operations.
   * @param {InitOrgCryptoRequest} req
   * @returns {Promise<void>}
   */
  initialize_org_crypto(req) {
    const ret = wasm.cryptoclient_initialize_org_crypto(this.__wbg_ptr, addHeapObject(req));
    return takeObject(ret);
  }
  /**
   * Generates a new key pair and encrypts the private key with the provided user key.
   * Crypto initialization not required.
   * @param {string} user_key
   * @returns {MakeKeyPairResponse}
   */
  make_key_pair(user_key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(user_key, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.cryptoclient_make_key_pair(retptr, this.__wbg_ptr, ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Verifies a user's asymmetric keys by decrypting the private key with the provided user
   * key. Returns if the private key is decryptable and if it is a valid matching key.
   * Crypto initialization not required.
   * @param {VerifyAsymmetricKeysRequest} request
   * @returns {VerifyAsymmetricKeysResponse}
   */
  verify_asymmetric_keys(request) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.cryptoclient_verify_asymmetric_keys(retptr, this.__wbg_ptr, addHeapObject(request));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const ExporterClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_exporterclient_free(ptr >>> 0, 1));

class ExporterClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(ExporterClient.prototype);
    obj.__wbg_ptr = ptr;
    ExporterClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    ExporterClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_exporterclient_free(ptr, 0);
  }
  /**
   * @param {Folder[]} folders
   * @param {Cipher[]} ciphers
   * @param {ExportFormat} format
   * @returns {string}
   */
  export_vault(folders, ciphers, format) {
    let deferred4_0;
    let deferred4_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArrayJsValueToWasm0(folders, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArrayJsValueToWasm0(ciphers, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.exporterclient_export_vault(
        retptr,
        this.__wbg_ptr,
        ptr0,
        len0,
        ptr1,
        len1,
        addHeapObject(format),
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr3 = r0;
      var len3 = r1;
      if (r3) {
        ptr3 = 0;
        len3 = 0;
        throw takeObject(r2);
      }
      deferred4_0 = ptr3;
      deferred4_1 = len3;
      return getStringFromWasm0(ptr3, len3);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred4_0, deferred4_1, 1);
    }
  }
  /**
   * @param {Collection[]} collections
   * @param {Cipher[]} ciphers
   * @param {ExportFormat} format
   * @returns {string}
   */
  export_organization_vault(collections, ciphers, format) {
    let deferred4_0;
    let deferred4_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArrayJsValueToWasm0(collections, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArrayJsValueToWasm0(ciphers, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.exporterclient_export_organization_vault(
        retptr,
        this.__wbg_ptr,
        ptr0,
        len0,
        ptr1,
        len1,
        addHeapObject(format),
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr3 = r0;
      var len3 = r1;
      if (r3) {
        ptr3 = 0;
        len3 = 0;
        throw takeObject(r2);
      }
      deferred4_0 = ptr3;
      deferred4_1 = len3;
      return getStringFromWasm0(ptr3, len3);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred4_0, deferred4_1, 1);
    }
  }
  /**
   * Credential Exchange Format (CXF)
   *
   * *Warning:* Expect this API to be unstable, and it will change in the future.
   *
   * For use with Apple using [ASCredentialExportManager](https://developer.apple.com/documentation/authenticationservices/ascredentialexportmanager).
   * Ideally the input should be immediately serialized from [ASImportableAccount](https://developer.apple.com/documentation/authenticationservices/asimportableaccount).
   * @param {Account} account
   * @param {Cipher[]} ciphers
   * @returns {string}
   */
  export_cxf(account, ciphers) {
    let deferred3_0;
    let deferred3_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArrayJsValueToWasm0(ciphers, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.exporterclient_export_cxf(retptr, this.__wbg_ptr, addHeapObject(account), ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr2 = r0;
      var len2 = r1;
      if (r3) {
        ptr2 = 0;
        len2 = 0;
        throw takeObject(r2);
      }
      deferred3_0 = ptr2;
      deferred3_1 = len2;
      return getStringFromWasm0(ptr2, len2);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred3_0, deferred3_1, 1);
    }
  }
  /**
   * Credential Exchange Format (CXF)
   *
   * *Warning:* Expect this API to be unstable, and it will change in the future.
   *
   * For use with Apple using [ASCredentialExportManager](https://developer.apple.com/documentation/authenticationservices/ascredentialexportmanager).
   * Ideally the input should be immediately serialized from [ASImportableAccount](https://developer.apple.com/documentation/authenticationservices/asimportableaccount).
   * @param {string} payload
   * @returns {Cipher[]}
   */
  import_cxf(payload) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(payload, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.exporterclient_import_cxf(retptr, this.__wbg_ptr, ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v2 = getArrayJsValueFromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 4, 4);
      return v2;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const FoldersClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_foldersclient_free(ptr >>> 0, 1));

class FoldersClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(FoldersClient.prototype);
    obj.__wbg_ptr = ptr;
    FoldersClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    FoldersClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_foldersclient_free(ptr, 0);
  }
  /**
   * Decrypt folder
   * @param {Folder} folder
   * @returns {FolderView}
   */
  decrypt(folder) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.foldersclient_decrypt(retptr, this.__wbg_ptr, addHeapObject(folder));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const GeneratorClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_generatorclient_free(ptr >>> 0, 1));

class GeneratorClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(GeneratorClient.prototype);
    obj.__wbg_ptr = ptr;
    GeneratorClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    GeneratorClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_generatorclient_free(ptr, 0);
  }
  /**
   * Generates a password from a provided request
   *
   * # Arguments
   * - `request` - Settings for the character sets and password length
   *
   * # Returns
   * - `Ok(String)` containing the generated password
   * - `Err(PasswordError)` if password generation fails
   * @param {PasswordGeneratorRequest} request
   * @returns {string}
   */
  password(request) {
    let deferred2_0;
    let deferred2_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.generatorclient_password(retptr, this.__wbg_ptr, addHeapObject(request));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr1 = r0;
      var len1 = r1;
      if (r3) {
        ptr1 = 0;
        len1 = 0;
        throw takeObject(r2);
      }
      deferred2_0 = ptr1;
      deferred2_1 = len1;
      return getStringFromWasm0(ptr1, len1);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred2_0, deferred2_1, 1);
    }
  }
  /**
   * Generates a passphrase from a provided request
   *
   * # Arguments
   * - `request` - Settings for the word count, word separators character sets
   *
   * # Returns
   * - `Ok(String)` containing the generated passphrase
   * - `Err(PassphraseError)` if passphrase generation fails
   * @param {PassphraseGeneratorRequest} request
   * @returns {string}
   */
  passphrase(request) {
    let deferred2_0;
    let deferred2_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.generatorclient_passphrase(retptr, this.__wbg_ptr, addHeapObject(request));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr1 = r0;
      var len1 = r1;
      if (r3) {
        ptr1 = 0;
        len1 = 0;
        throw takeObject(r2);
      }
      deferred2_0 = ptr1;
      deferred2_1 = len1;
      return getStringFromWasm0(ptr1, len1);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred2_0, deferred2_1, 1);
    }
  }
}

const IncomingMessageFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_incomingmessage_free(ptr >>> 0, 1));

class IncomingMessage {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(IncomingMessage.prototype);
    obj.__wbg_ptr = ptr;
    IncomingMessageFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    IncomingMessageFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_incomingmessage_free(ptr, 0);
  }
  /**
   * @returns {Uint8Array}
   */
  get payload() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.__wbg_get_incomingmessage_payload(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var v1 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {Uint8Array} arg0
   */
  set payload(arg0) {
    const ptr0 = passArray8ToWasm0(arg0, wasm.__wbindgen_malloc);
    const len0 = WASM_VECTOR_LEN;
    wasm.__wbg_set_incomingmessage_payload(this.__wbg_ptr, ptr0, len0);
  }
  /**
   * @returns {Endpoint}
   */
  get destination() {
    const ret = wasm.__wbg_get_incomingmessage_destination(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @param {Endpoint} arg0
   */
  set destination(arg0) {
    wasm.__wbg_set_incomingmessage_destination(this.__wbg_ptr, addHeapObject(arg0));
  }
  /**
   * @returns {Endpoint}
   */
  get source() {
    const ret = wasm.__wbg_get_incomingmessage_source(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @param {Endpoint} arg0
   */
  set source(arg0) {
    wasm.__wbg_set_incomingmessage_source(this.__wbg_ptr, addHeapObject(arg0));
  }
  /**
   * @returns {string | undefined}
   */
  get topic() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.__wbg_get_incomingmessage_topic(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      let v1;
      if (r0 !== 0) {
        v1 = getStringFromWasm0(r0, r1).slice();
        wasm.__wbindgen_free(r0, r1 * 1, 1);
      }
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {string | null} [arg0]
   */
  set topic(arg0) {
    var ptr0 = isLikeNone(arg0)
      ? 0
      : passStringToWasm0(arg0, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len0 = WASM_VECTOR_LEN;
    wasm.__wbg_set_incomingmessage_topic(this.__wbg_ptr, ptr0, len0);
  }
  /**
   * @param {Uint8Array} payload
   * @param {Endpoint} destination
   * @param {Endpoint} source
   * @param {string | null} [topic]
   */
  constructor(payload, destination, source, topic) {
    const ptr0 = passArray8ToWasm0(payload, wasm.__wbindgen_malloc);
    const len0 = WASM_VECTOR_LEN;
    var ptr1 = isLikeNone(topic)
      ? 0
      : passStringToWasm0(topic, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len1 = WASM_VECTOR_LEN;
    const ret = wasm.incomingmessage_new(
      ptr0,
      len0,
      addHeapObject(destination),
      addHeapObject(source),
      ptr1,
      len1,
    );
    this.__wbg_ptr = ret >>> 0;
    IncomingMessageFinalization.register(this, this.__wbg_ptr, this);
    return this;
  }
  /**
   * Try to parse the payload as JSON.
   * @returns {any} The parsed JSON value, or undefined if the payload is not valid JSON.
   */
  parse_payload_as_json() {
    const ret = wasm.incomingmessage_parse_payload_as_json(this.__wbg_ptr);
    return takeObject(ret);
  }
}

const IpcClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_ipcclient_free(ptr >>> 0, 1));

class IpcClient {
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    IpcClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_ipcclient_free(ptr, 0);
  }
  /**
   * @param {IpcCommunicationBackend} communication_provider
   */
  constructor(communication_provider) {
    _assertClass(communication_provider, IpcCommunicationBackend);
    var ptr0 = communication_provider.__destroy_into_raw();
    const ret = wasm.ipcclient_new(ptr0);
    this.__wbg_ptr = ret >>> 0;
    IpcClientFinalization.register(this, this.__wbg_ptr, this);
    return this;
  }
  /**
   * @param {OutgoingMessage} message
   * @returns {Promise<void>}
   */
  send(message) {
    _assertClass(message, OutgoingMessage);
    var ptr0 = message.__destroy_into_raw();
    const ret = wasm.ipcclient_send(this.__wbg_ptr, ptr0);
    return takeObject(ret);
  }
  /**
   * @returns {Promise<IpcClientSubscription>}
   */
  subscribe() {
    const ret = wasm.ipcclient_subscribe(this.__wbg_ptr);
    return takeObject(ret);
  }
}

const IpcClientSubscriptionFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_ipcclientsubscription_free(ptr >>> 0, 1));

class IpcClientSubscription {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(IpcClientSubscription.prototype);
    obj.__wbg_ptr = ptr;
    IpcClientSubscriptionFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    IpcClientSubscriptionFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_ipcclientsubscription_free(ptr, 0);
  }
  /**
   * @returns {Promise<IncomingMessage>}
   */
  receive() {
    const ret = wasm.ipcclientsubscription_receive(this.__wbg_ptr);
    return takeObject(ret);
  }
}

const IpcCommunicationBackendFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_ipccommunicationbackend_free(ptr >>> 0, 1));

class IpcCommunicationBackend {
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    IpcCommunicationBackendFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_ipccommunicationbackend_free(ptr, 0);
  }
  /**
   * @param {IpcCommunicationBackendSender} sender
   */
  constructor(sender) {
    const ret = wasm.ipccommunicationbackend_new(addHeapObject(sender));
    this.__wbg_ptr = ret >>> 0;
    IpcCommunicationBackendFinalization.register(this, this.__wbg_ptr, this);
    return this;
  }
  /**
   * JavaScript function to provide a received message to the backend/IPC framework.
   * @param {IncomingMessage} message
   */
  deliver_message(message) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      _assertClass(message, IncomingMessage);
      var ptr0 = message.__destroy_into_raw();
      wasm.ipccommunicationbackend_deliver_message(retptr, this.__wbg_ptr, ptr0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const OutgoingMessageFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_outgoingmessage_free(ptr >>> 0, 1));

class OutgoingMessage {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(OutgoingMessage.prototype);
    obj.__wbg_ptr = ptr;
    OutgoingMessageFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    OutgoingMessageFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_outgoingmessage_free(ptr, 0);
  }
  /**
   * @returns {Uint8Array}
   */
  get payload() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.__wbg_get_outgoingmessage_payload(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var v1 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {Uint8Array} arg0
   */
  set payload(arg0) {
    const ptr0 = passArray8ToWasm0(arg0, wasm.__wbindgen_malloc);
    const len0 = WASM_VECTOR_LEN;
    wasm.__wbg_set_outgoingmessage_payload(this.__wbg_ptr, ptr0, len0);
  }
  /**
   * @returns {Endpoint}
   */
  get destination() {
    const ret = wasm.__wbg_get_incomingmessage_destination(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @param {Endpoint} arg0
   */
  set destination(arg0) {
    wasm.__wbg_set_incomingmessage_destination(this.__wbg_ptr, addHeapObject(arg0));
  }
  /**
   * @returns {string | undefined}
   */
  get topic() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.__wbg_get_outgoingmessage_topic(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      let v1;
      if (r0 !== 0) {
        v1 = getStringFromWasm0(r0, r1).slice();
        wasm.__wbindgen_free(r0, r1 * 1, 1);
      }
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {string | null} [arg0]
   */
  set topic(arg0) {
    var ptr0 = isLikeNone(arg0)
      ? 0
      : passStringToWasm0(arg0, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len0 = WASM_VECTOR_LEN;
    wasm.__wbg_set_outgoingmessage_topic(this.__wbg_ptr, ptr0, len0);
  }
  /**
   * @param {Uint8Array} payload
   * @param {Endpoint} destination
   * @param {string | null} [topic]
   */
  constructor(payload, destination, topic) {
    const ptr0 = passArray8ToWasm0(payload, wasm.__wbindgen_malloc);
    const len0 = WASM_VECTOR_LEN;
    var ptr1 = isLikeNone(topic)
      ? 0
      : passStringToWasm0(topic, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len1 = WASM_VECTOR_LEN;
    const ret = wasm.outgoingmessage_new(ptr0, len0, addHeapObject(destination), ptr1, len1);
    this.__wbg_ptr = ret >>> 0;
    OutgoingMessageFinalization.register(this, this.__wbg_ptr, this);
    return this;
  }
  /**
   * Create a new message and encode the payload as JSON.
   * @param {any} payload
   * @param {Endpoint} destination
   * @param {string | null} [topic]
   * @returns {OutgoingMessage}
   */
  static new_json_payload(payload, destination, topic) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      var ptr0 = isLikeNone(topic)
        ? 0
        : passStringToWasm0(topic, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      var len0 = WASM_VECTOR_LEN;
      wasm.outgoingmessage_new_json_payload(
        retptr,
        addHeapObject(payload),
        addHeapObject(destination),
        ptr0,
        len0,
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return OutgoingMessage.__wrap(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const PureCryptoFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_purecrypto_free(ptr >>> 0, 1));
/**
 * This module represents a stopgap solution to provide access to primitive crypto functions for JS
 * clients. It is not intended to be used outside of the JS clients and this pattern should not be
 * proliferated. It is necessary because we want to use SDK crypto prior to the SDK being fully
 * responsible for state and keys.
 */
class PureCrypto {
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    PureCryptoFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_purecrypto_free(ptr, 0);
  }
  /**
   * @param {string} enc_string
   * @param {Uint8Array} key
   * @returns {string}
   */
  static symmetric_decrypt(enc_string, key) {
    let deferred4_0;
    let deferred4_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(enc_string, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_symmetric_decrypt(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr3 = r0;
      var len3 = r1;
      if (r3) {
        ptr3 = 0;
        len3 = 0;
        throw takeObject(r2);
      }
      deferred4_0 = ptr3;
      deferred4_1 = len3;
      return getStringFromWasm0(ptr3, len3);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred4_0, deferred4_1, 1);
    }
  }
  /**
   * @param {string} enc_string
   * @param {Uint8Array} key
   * @returns {Uint8Array}
   */
  static symmetric_decrypt_to_bytes(enc_string, key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(enc_string, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_symmetric_decrypt_to_bytes(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v3 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v3;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {Uint8Array} enc_bytes
   * @param {Uint8Array} key
   * @returns {Uint8Array}
   */
  static symmetric_decrypt_array_buffer(enc_bytes, key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(enc_bytes, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_symmetric_decrypt_array_buffer(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v3 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v3;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {string} plain
   * @param {Uint8Array} key
   * @returns {string}
   */
  static symmetric_encrypt(plain, key) {
    let deferred4_0;
    let deferred4_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(plain, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_symmetric_encrypt(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr3 = r0;
      var len3 = r1;
      if (r3) {
        ptr3 = 0;
        len3 = 0;
        throw takeObject(r2);
      }
      deferred4_0 = ptr3;
      deferred4_1 = len3;
      return getStringFromWasm0(ptr3, len3);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred4_0, deferred4_1, 1);
    }
  }
  /**
   * @param {Uint8Array} plain
   * @param {Uint8Array} key
   * @returns {Uint8Array}
   */
  static symmetric_encrypt_to_array_buffer(plain, key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(plain, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_symmetric_encrypt_to_array_buffer(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v3 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v3;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const ReceiveErrorFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_receiveerror_free(ptr >>> 0, 1));

class ReceiveError {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(ReceiveError.prototype);
    obj.__wbg_ptr = ptr;
    ReceiveErrorFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    ReceiveErrorFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_receiveerror_free(ptr, 0);
  }
  /**
   * @returns {boolean}
   */
  get timeout() {
    const ret = wasm.__wbg_get_receiveerror_timeout(this.__wbg_ptr);
    return ret !== 0;
  }
  /**
   * @param {boolean} arg0
   */
  set timeout(arg0) {
    wasm.__wbg_set_receiveerror_timeout(this.__wbg_ptr, arg0);
  }
  /**
   * @returns {any}
   */
  get crypto() {
    const ret = wasm.__wbg_get_receiveerror_crypto(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @param {any} arg0
   */
  set crypto(arg0) {
    wasm.__wbg_set_receiveerror_crypto(this.__wbg_ptr, addHeapObject(arg0));
  }
  /**
   * @returns {any}
   */
  get communication() {
    const ret = wasm.__wbg_get_receiveerror_communication(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @param {any} arg0
   */
  set communication(arg0) {
    wasm.__wbg_set_receiveerror_communication(this.__wbg_ptr, addHeapObject(arg0));
  }
}

const SendErrorFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_senderror_free(ptr >>> 0, 1));

class SendError {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(SendError.prototype);
    obj.__wbg_ptr = ptr;
    SendErrorFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    SendErrorFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_senderror_free(ptr, 0);
  }
  /**
   * @returns {any}
   */
  get crypto() {
    const ret = wasm.__wbg_get_receiveerror_crypto(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @param {any} arg0
   */
  set crypto(arg0) {
    wasm.__wbg_set_receiveerror_crypto(this.__wbg_ptr, addHeapObject(arg0));
  }
  /**
   * @returns {any}
   */
  get communication() {
    const ret = wasm.__wbg_get_receiveerror_communication(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @param {any} arg0
   */
  set communication(arg0) {
    wasm.__wbg_set_receiveerror_communication(this.__wbg_ptr, addHeapObject(arg0));
  }
}

const TotpClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_totpclient_free(ptr >>> 0, 1));

class TotpClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(TotpClient.prototype);
    obj.__wbg_ptr = ptr;
    TotpClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    TotpClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_totpclient_free(ptr, 0);
  }
  /**
   * Generates a TOTP code from a provided key
   *
   * # Arguments
   * - `key` - Can be:
   *     - A base32 encoded string
   *     - OTP Auth URI
   *     - Steam URI
   * - `time_ms` - Optional timestamp in milliseconds
   *
   * # Returns
   * - `Ok(TotpResponse)` containing the generated code and period
   * - `Err(TotpError)` if code generation fails
   * @param {string} key
   * @param {number | null} [time_ms]
   * @returns {TotpResponse}
   */
  generate_totp(key, time_ms) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(key, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.totpclient_generate_totp(
        retptr,
        this.__wbg_ptr,
        ptr0,
        len0,
        !isLikeNone(time_ms),
        isLikeNone(time_ms) ? 0 : time_ms,
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const VaultClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_vaultclient_free(ptr >>> 0, 1));

class VaultClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(VaultClient.prototype);
    obj.__wbg_ptr = ptr;
    VaultClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    VaultClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_vaultclient_free(ptr, 0);
  }
  /**
   * @returns {AttachmentsClient}
   */
  attachments() {
    const ret = wasm.vaultclient_attachments(this.__wbg_ptr);
    return AttachmentsClient.__wrap(ret);
  }
  /**
   * @returns {CiphersClient}
   */
  ciphers() {
    const ret = wasm.vaultclient_attachments(this.__wbg_ptr);
    return CiphersClient.__wrap(ret);
  }
  /**
   * @returns {FoldersClient}
   */
  folders() {
    const ret = wasm.vaultclient_attachments(this.__wbg_ptr);
    return FoldersClient.__wrap(ret);
  }
  /**
   * @returns {TotpClient}
   */
  totp() {
    const ret = wasm.vaultclient_totp(this.__wbg_ptr);
    return TotpClient.__wrap(ret);
  }
}

function __wbg_String_8f0eb39a4a4c2f66(arg0, arg1) {
  const ret = String(getObject(arg1));
  const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  const len1 = WASM_VECTOR_LEN;
  getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
}

function __wbg_abort_410ec47a64ac6117(arg0, arg1) {
  getObject(arg0).abort(getObject(arg1));
}

function __wbg_abort_775ef1d17fc65868(arg0) {
  getObject(arg0).abort();
}

function __wbg_append_299d5d48292c0495() {
  return handleError(function (arg0, arg1, arg2, arg3, arg4) {
    getObject(arg0).append(getStringFromWasm0(arg1, arg2), getStringFromWasm0(arg3, arg4));
  }, arguments);
}

function __wbg_append_8c7dd8d641a5f01b() {
  return handleError(function (arg0, arg1, arg2, arg3, arg4) {
    getObject(arg0).append(getStringFromWasm0(arg1, arg2), getStringFromWasm0(arg3, arg4));
  }, arguments);
}

function __wbg_append_b2d1fc16de2a0e81() {
  return handleError(function (arg0, arg1, arg2, arg3, arg4, arg5) {
    getObject(arg0).append(
      getStringFromWasm0(arg1, arg2),
      getObject(arg3),
      getStringFromWasm0(arg4, arg5),
    );
  }, arguments);
}

function __wbg_append_b44785ebeb668479() {
  return handleError(function (arg0, arg1, arg2, arg3) {
    getObject(arg0).append(getStringFromWasm0(arg1, arg2), getObject(arg3));
  }, arguments);
}

function __wbg_buffer_609cc3eee51ed158(arg0) {
  const ret = getObject(arg0).buffer;
  return addHeapObject(ret);
}

function __wbg_call_672a4d21634d4a24() {
  return handleError(function (arg0, arg1) {
    const ret = getObject(arg0).call(getObject(arg1));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_call_7cccdd69e0791ae2() {
  return handleError(function (arg0, arg1, arg2) {
    const ret = getObject(arg0).call(getObject(arg1), getObject(arg2));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_clearTimeout_86721db0036bea98(arg0) {
  const ret = clearTimeout(takeObject(arg0));
  return addHeapObject(ret);
}

function __wbg_crypto_574e78ad8b13b65f(arg0) {
  const ret = getObject(arg0).crypto;
  return addHeapObject(ret);
}

function __wbg_debug_e17b51583ca6a632(arg0, arg1, arg2, arg3) {
  console.debug(getObject(arg0), getObject(arg1), getObject(arg2), getObject(arg3));
}

function __wbg_done_769e5ede4b31c67b(arg0) {
  const ret = getObject(arg0).done;
  return ret;
}

function __wbg_entries_3265d4158b33e5dc(arg0) {
  const ret = Object.entries(getObject(arg0));
  return addHeapObject(ret);
}

function __wbg_error_7534b8e9a36f1ab4(arg0, arg1) {
  let deferred0_0;
  let deferred0_1;
  try {
    deferred0_0 = arg0;
    deferred0_1 = arg1;
    console.error(getStringFromWasm0(arg0, arg1));
  } finally {
    wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
  }
}

function __wbg_error_80de38b3f7cc3c3c(arg0, arg1, arg2, arg3) {
  console.error(getObject(arg0), getObject(arg1), getObject(arg2), getObject(arg3));
}

function __wbg_fetch_509096533071c657(arg0, arg1) {
  const ret = getObject(arg0).fetch(getObject(arg1));
  return addHeapObject(ret);
}

function __wbg_fetch_d36a73832f0a45e8(arg0) {
  const ret = fetch(getObject(arg0));
  return addHeapObject(ret);
}

function __wbg_getRandomValues_3d90134a348e46b3() {
  return handleError(function (arg0, arg1) {
    globalThis.crypto.getRandomValues(getArrayU8FromWasm0(arg0, arg1));
  }, arguments);
}

function __wbg_getRandomValues_b8f5dbd5f3995a9e() {
  return handleError(function (arg0, arg1) {
    getObject(arg0).getRandomValues(getObject(arg1));
  }, arguments);
}

function __wbg_getTime_46267b1c24877e30(arg0) {
  const ret = getObject(arg0).getTime();
  return ret;
}

function __wbg_get_67b2ba62fc30de12() {
  return handleError(function (arg0, arg1) {
    const ret = Reflect.get(getObject(arg0), getObject(arg1));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_get_b9b93047fe3cf45b(arg0, arg1) {
  const ret = getObject(arg0)[arg1 >>> 0];
  return addHeapObject(ret);
}

function __wbg_getwithrefkey_1dc361bd10053bfe(arg0, arg1) {
  const ret = getObject(arg0)[getObject(arg1)];
  return addHeapObject(ret);
}

function __wbg_has_a5ea9117f258a0ec() {
  return handleError(function (arg0, arg1) {
    const ret = Reflect.has(getObject(arg0), getObject(arg1));
    return ret;
  }, arguments);
}

function __wbg_headers_9cb51cfd2ac780a4(arg0) {
  const ret = getObject(arg0).headers;
  return addHeapObject(ret);
}

function __wbg_incomingmessage_new(arg0) {
  const ret = IncomingMessage.__wrap(arg0);
  return addHeapObject(ret);
}

function __wbg_info_033d8b8a0838f1d3(arg0, arg1, arg2, arg3) {
  console.info(getObject(arg0), getObject(arg1), getObject(arg2), getObject(arg3));
}

function __wbg_instanceof_ArrayBuffer_e14585432e3737fc(arg0) {
  let result;
  try {
    result = getObject(arg0) instanceof ArrayBuffer;
  } catch (_) {
    result = false;
  }
  const ret = result;
  return ret;
}

function __wbg_instanceof_Map_f3469ce2244d2430(arg0) {
  let result;
  try {
    result = getObject(arg0) instanceof Map;
  } catch (_) {
    result = false;
  }
  const ret = result;
  return ret;
}

function __wbg_instanceof_Response_f2cc20d9f7dfd644(arg0) {
  let result;
  try {
    result = getObject(arg0) instanceof Response;
  } catch (_) {
    result = false;
  }
  const ret = result;
  return ret;
}

function __wbg_instanceof_Uint8Array_17156bcf118086a9(arg0) {
  let result;
  try {
    result = getObject(arg0) instanceof Uint8Array;
  } catch (_) {
    result = false;
  }
  const ret = result;
  return ret;
}

function __wbg_ipcclientsubscription_new(arg0) {
  const ret = IpcClientSubscription.__wrap(arg0);
  return addHeapObject(ret);
}

function __wbg_isArray_a1eab7e0d067391b(arg0) {
  const ret = Array.isArray(getObject(arg0));
  return ret;
}

function __wbg_isSafeInteger_343e2beeeece1bb0(arg0) {
  const ret = Number.isSafeInteger(getObject(arg0));
  return ret;
}

function __wbg_iterator_9a24c88df860dc65() {
  const ret = Symbol.iterator;
  return addHeapObject(ret);
}

function __wbg_length_a446193dc22c12f8(arg0) {
  const ret = getObject(arg0).length;
  return ret;
}

function __wbg_length_e2d2a49132c1b256(arg0) {
  const ret = getObject(arg0).length;
  return ret;
}

function __wbg_log_cad59bb680daec67(arg0, arg1, arg2, arg3) {
  console.log(getObject(arg0), getObject(arg1), getObject(arg2), getObject(arg3));
}

function __wbg_msCrypto_a61aeb35a24c1329(arg0) {
  const ret = getObject(arg0).msCrypto;
  return addHeapObject(ret);
}

function __wbg_new0_f788a2397c7ca929() {
  const ret = new Date();
  return addHeapObject(ret);
}

function __wbg_new_018dcc2d6c8c2f6a() {
  return handleError(function () {
    const ret = new Headers();
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_new_23a2665fac83c611(arg0, arg1) {
  try {
    var state0 = { a: arg0, b: arg1 };
    var cb0 = (arg0, arg1) => {
      const a = state0.a;
      state0.a = 0;
      try {
        return __wbg_adapter_237(a, state0.b, arg0, arg1);
      } finally {
        state0.a = a;
      }
    };
    const ret = new Promise(cb0);
    return addHeapObject(ret);
  } finally {
    state0.a = state0.b = 0;
  }
}

function __wbg_new_405e22f390576ce2() {
  const ret = new Object();
  return addHeapObject(ret);
}

function __wbg_new_78feb108b6472713() {
  const ret = new Array();
  return addHeapObject(ret);
}

function __wbg_new_8a6f238a6ece86ea() {
  const ret = new Error();
  return addHeapObject(ret);
}

function __wbg_new_9fd39a253424609a() {
  return handleError(function () {
    const ret = new FormData();
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_new_a12002a7f91c75be(arg0) {
  const ret = new Uint8Array(getObject(arg0));
  return addHeapObject(ret);
}

function __wbg_new_c68d7209be747379(arg0, arg1) {
  const ret = new Error(getStringFromWasm0(arg0, arg1));
  return addHeapObject(ret);
}

function __wbg_new_e25e5aab09ff45db() {
  return handleError(function () {
    const ret = new AbortController();
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_new_f24b6d53abe5bc82(arg0, arg1) {
  let deferred0_0;
  let deferred0_1;
  try {
    deferred0_0 = arg0;
    deferred0_1 = arg1;
    const ret = new Error(getStringFromWasm0(arg0, arg1));
    return addHeapObject(ret);
  } finally {
    wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
  }
}

function __wbg_newnoargs_105ed471475aaf50(arg0, arg1) {
  const ret = new Function(getStringFromWasm0(arg0, arg1));
  return addHeapObject(ret);
}

function __wbg_newwithbyteoffsetandlength_d97e637ebe145a9a(arg0, arg1, arg2) {
  const ret = new Uint8Array(getObject(arg0), arg1 >>> 0, arg2 >>> 0);
  return addHeapObject(ret);
}

function __wbg_newwithlength_a381634e90c276d4(arg0) {
  const ret = new Uint8Array(arg0 >>> 0);
  return addHeapObject(ret);
}

function __wbg_newwithstrandinit_06c535e0a867c635() {
  return handleError(function (arg0, arg1, arg2) {
    const ret = new Request(getStringFromWasm0(arg0, arg1), getObject(arg2));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_newwithu8arraysequenceandoptions_068570c487f69127() {
  return handleError(function (arg0, arg1) {
    const ret = new Blob(getObject(arg0), getObject(arg1));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_next_25feadfc0913fea9(arg0) {
  const ret = getObject(arg0).next;
  return addHeapObject(ret);
}

function __wbg_next_6574e1a8a62d1055() {
  return handleError(function (arg0) {
    const ret = getObject(arg0).next();
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_node_905d3e251edff8a2(arg0) {
  const ret = getObject(arg0).node;
  return addHeapObject(ret);
}

function __wbg_parse_def2e24ef1252aff() {
  return handleError(function (arg0, arg1) {
    const ret = JSON.parse(getStringFromWasm0(arg0, arg1));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_process_dc0fbacc7c1c06f7(arg0) {
  const ret = getObject(arg0).process;
  return addHeapObject(ret);
}

function __wbg_push_737cfc8c1432c2c6(arg0, arg1) {
  const ret = getObject(arg0).push(getObject(arg1));
  return ret;
}

function __wbg_queueMicrotask_97d92b4fcc8a61c5(arg0) {
  queueMicrotask(getObject(arg0));
}

function __wbg_queueMicrotask_d3219def82552485(arg0) {
  const ret = getObject(arg0).queueMicrotask;
  return addHeapObject(ret);
}

function __wbg_randomFillSync_ac0988aba3254290() {
  return handleError(function (arg0, arg1) {
    getObject(arg0).randomFillSync(takeObject(arg1));
  }, arguments);
}

function __wbg_receiveerror_new(arg0) {
  const ret = ReceiveError.__wrap(arg0);
  return addHeapObject(ret);
}

function __wbg_require_60cc747a6bc5215a() {
  return handleError(function () {
    const ret = module.require;
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_resolve_4851785c9c5f573d(arg0) {
  const ret = Promise.resolve(getObject(arg0));
  return addHeapObject(ret);
}

function __wbg_send_9b8fc6bb517867dd() {
  return handleError(function (arg0, arg1) {
    const ret = getObject(arg0).send(OutgoingMessage.__wrap(arg1));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_senderror_new(arg0) {
  const ret = SendError.__wrap(arg0);
  return addHeapObject(ret);
}

function __wbg_setTimeout_2e707715f8cc9497(arg0, arg1) {
  const ret = setTimeout(getObject(arg0), arg1);
  return addHeapObject(ret);
}

function __wbg_set_37837023f3d740e8(arg0, arg1, arg2) {
  getObject(arg0)[arg1 >>> 0] = takeObject(arg2);
}

function __wbg_set_3f1d0b984ed272ed(arg0, arg1, arg2) {
  getObject(arg0)[takeObject(arg1)] = takeObject(arg2);
}

function __wbg_set_65595bdd868b3009(arg0, arg1, arg2) {
  getObject(arg0).set(getObject(arg1), arg2 >>> 0);
}

function __wbg_setbody_5923b78a95eedf29(arg0, arg1) {
  getObject(arg0).body = getObject(arg1);
}

function __wbg_setcredentials_c3a22f1cd105a2c6(arg0, arg1) {
  getObject(arg0).credentials = __wbindgen_enum_RequestCredentials[arg1];
}

function __wbg_setheaders_834c0bdb6a8949ad(arg0, arg1) {
  getObject(arg0).headers = getObject(arg1);
}

function __wbg_setmethod_3c5280fe5d890842(arg0, arg1, arg2) {
  getObject(arg0).method = getStringFromWasm0(arg1, arg2);
}

function __wbg_setmode_5dc300b865044b65(arg0, arg1) {
  getObject(arg0).mode = __wbindgen_enum_RequestMode[arg1];
}

function __wbg_setname_c0e2d6f348c746f4(arg0, arg1, arg2) {
  let deferred0_0;
  let deferred0_1;
  try {
    deferred0_0 = arg1;
    deferred0_1 = arg2;
    getObject(arg0).name = getStringFromWasm0(arg1, arg2);
  } finally {
    wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
  }
}

function __wbg_setsignal_75b21ef3a81de905(arg0, arg1) {
  getObject(arg0).signal = getObject(arg1);
}

function __wbg_settype_39ed370d3edd403c(arg0, arg1, arg2) {
  getObject(arg0).type = getStringFromWasm0(arg1, arg2);
}

function __wbg_setvariant_d1d41b778dfe9c17(arg0, arg1, arg2) {
  let deferred0_0;
  let deferred0_1;
  try {
    deferred0_0 = arg1;
    deferred0_1 = arg2;
    getObject(arg0).variant = getStringFromWasm0(arg1, arg2);
  } finally {
    wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
  }
}

function __wbg_signal_aaf9ad74119f20a4(arg0) {
  const ret = getObject(arg0).signal;
  return addHeapObject(ret);
}

function __wbg_stack_0ed75d68575b0f3c(arg0, arg1) {
  const ret = getObject(arg1).stack;
  const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  const len1 = WASM_VECTOR_LEN;
  getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
}

function __wbg_static_accessor_GLOBAL_88a902d13a557d07() {
  const ret = typeof global === "undefined" ? null : global;
  return isLikeNone(ret) ? 0 : addHeapObject(ret);
}

function __wbg_static_accessor_GLOBAL_THIS_56578be7e9f832b0() {
  const ret = typeof globalThis === "undefined" ? null : globalThis;
  return isLikeNone(ret) ? 0 : addHeapObject(ret);
}

function __wbg_static_accessor_SELF_37c5d418e4bf5819() {
  const ret = typeof self === "undefined" ? null : self;
  return isLikeNone(ret) ? 0 : addHeapObject(ret);
}

function __wbg_static_accessor_WINDOW_5de37043a91a9c40() {
  const ret = typeof window === "undefined" ? null : window;
  return isLikeNone(ret) ? 0 : addHeapObject(ret);
}

function __wbg_status_f6360336ca686bf0(arg0) {
  const ret = getObject(arg0).status;
  return ret;
}

function __wbg_stringify_f7ed6987935b4a24() {
  return handleError(function (arg0) {
    const ret = JSON.stringify(getObject(arg0));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_subarray_aa9065fa9dc5df96(arg0, arg1, arg2) {
  const ret = getObject(arg0).subarray(arg1 >>> 0, arg2 >>> 0);
  return addHeapObject(ret);
}

function __wbg_text_7805bea50de2af49() {
  return handleError(function (arg0) {
    const ret = getObject(arg0).text();
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_then_44b73946d2fb3e7d(arg0, arg1) {
  const ret = getObject(arg0).then(getObject(arg1));
  return addHeapObject(ret);
}

function __wbg_then_48b406749878a531(arg0, arg1, arg2) {
  const ret = getObject(arg0).then(getObject(arg1), getObject(arg2));
  return addHeapObject(ret);
}

function __wbg_url_ae10c34ca209681d(arg0, arg1) {
  const ret = getObject(arg1).url;
  const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  const len1 = WASM_VECTOR_LEN;
  getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
}

function __wbg_value_cd1ffa7b1ab794f1(arg0) {
  const ret = getObject(arg0).value;
  return addHeapObject(ret);
}

function __wbg_versions_c01dfd4722a88165(arg0) {
  const ret = getObject(arg0).versions;
  return addHeapObject(ret);
}

function __wbg_warn_aaf1f4664a035bd6(arg0, arg1, arg2, arg3) {
  console.warn(getObject(arg0), getObject(arg1), getObject(arg2), getObject(arg3));
}

function __wbindgen_as_number(arg0) {
  const ret = +getObject(arg0);
  return ret;
}

function __wbindgen_bigint_from_i64(arg0) {
  const ret = arg0;
  return addHeapObject(ret);
}

function __wbindgen_bigint_from_u64(arg0) {
  const ret = BigInt.asUintN(64, arg0);
  return addHeapObject(ret);
}

function __wbindgen_bigint_get_as_i64(arg0, arg1) {
  const v = getObject(arg1);
  const ret = typeof v === "bigint" ? v : undefined;
  getDataViewMemory0().setBigInt64(arg0 + 8 * 1, isLikeNone(ret) ? BigInt(0) : ret, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, !isLikeNone(ret), true);
}

function __wbindgen_boolean_get(arg0) {
  const v = getObject(arg0);
  const ret = typeof v === "boolean" ? (v ? 1 : 0) : 2;
  return ret;
}

function __wbindgen_cb_drop(arg0) {
  const obj = takeObject(arg0).original;
  if (obj.cnt-- == 1) {
    obj.a = 0;
    return true;
  }
  const ret = false;
  return ret;
}

function __wbindgen_closure_wrapper2876(arg0, arg1, arg2) {
  const ret = makeMutClosure(arg0, arg1, 664, __wbg_adapter_50);
  return addHeapObject(ret);
}

function __wbindgen_closure_wrapper3269(arg0, arg1, arg2) {
  const ret = makeMutClosure(arg0, arg1, 786, __wbg_adapter_53);
  return addHeapObject(ret);
}

function __wbindgen_debug_string(arg0, arg1) {
  const ret = debugString(getObject(arg1));
  const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  const len1 = WASM_VECTOR_LEN;
  getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
}

function __wbindgen_error_new(arg0, arg1) {
  const ret = new Error(getStringFromWasm0(arg0, arg1));
  return addHeapObject(ret);
}

function __wbindgen_in(arg0, arg1) {
  const ret = getObject(arg0) in getObject(arg1);
  return ret;
}

function __wbindgen_is_bigint(arg0) {
  const ret = typeof getObject(arg0) === "bigint";
  return ret;
}

function __wbindgen_is_function(arg0) {
  const ret = typeof getObject(arg0) === "function";
  return ret;
}

function __wbindgen_is_object(arg0) {
  const val = getObject(arg0);
  const ret = typeof val === "object" && val !== null;
  return ret;
}

function __wbindgen_is_string(arg0) {
  const ret = typeof getObject(arg0) === "string";
  return ret;
}

function __wbindgen_is_undefined(arg0) {
  const ret = getObject(arg0) === undefined;
  return ret;
}

function __wbindgen_jsval_eq(arg0, arg1) {
  const ret = getObject(arg0) === getObject(arg1);
  return ret;
}

function __wbindgen_jsval_loose_eq(arg0, arg1) {
  const ret = getObject(arg0) == getObject(arg1);
  return ret;
}

function __wbindgen_memory() {
  const ret = wasm.memory;
  return addHeapObject(ret);
}

function __wbindgen_number_get(arg0, arg1) {
  const obj = getObject(arg1);
  const ret = typeof obj === "number" ? obj : undefined;
  getDataViewMemory0().setFloat64(arg0 + 8 * 1, isLikeNone(ret) ? 0 : ret, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, !isLikeNone(ret), true);
}

function __wbindgen_number_new(arg0) {
  const ret = arg0;
  return addHeapObject(ret);
}

function __wbindgen_object_clone_ref(arg0) {
  const ret = getObject(arg0);
  return addHeapObject(ret);
}

function __wbindgen_object_drop_ref(arg0) {
  takeObject(arg0);
}

function __wbindgen_string_get(arg0, arg1) {
  const obj = getObject(arg1);
  const ret = typeof obj === "string" ? obj : undefined;
  var ptr1 = isLikeNone(ret)
    ? 0
    : passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  var len1 = WASM_VECTOR_LEN;
  getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
}

function __wbindgen_string_new(arg0, arg1) {
  const ret = getStringFromWasm0(arg0, arg1);
  return addHeapObject(ret);
}

function __wbindgen_throw(arg0, arg1) {
  throw new Error(getStringFromWasm0(arg0, arg1));
}


/***/ }),

/***/ 857:
/***/ ((module) => {

module.exports = require("url");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			id: moduleId,
/******/ 			loaded: false,
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/create fake namespace object */
/******/ 	(() => {
/******/ 		var getProto = Object.getPrototypeOf ? (obj) => (Object.getPrototypeOf(obj)) : (obj) => (obj.__proto__);
/******/ 		var leafPrototypes;
/******/ 		// create a fake namespace object
/******/ 		// mode & 1: value is a module id, require it
/******/ 		// mode & 2: merge all properties of value into the ns
/******/ 		// mode & 4: return value when already ns object
/******/ 		// mode & 16: return value when it's Promise-like
/******/ 		// mode & 8|1: behave like require
/******/ 		__webpack_require__.t = function(value, mode) {
/******/ 			if(mode & 1) value = this(value);
/******/ 			if(mode & 8) return value;
/******/ 			if(typeof value === 'object' && value) {
/******/ 				if((mode & 4) && value.__esModule) return value;
/******/ 				if((mode & 16) && typeof value.then === 'function') return value;
/******/ 			}
/******/ 			var ns = Object.create(null);
/******/ 			__webpack_require__.r(ns);
/******/ 			var def = {};
/******/ 			leafPrototypes = leafPrototypes || [null, getProto({}), getProto([]), getProto(getProto)];
/******/ 			for(var current = mode & 2 && value; typeof current == 'object' && !~leafPrototypes.indexOf(current); current = getProto(current)) {
/******/ 				Object.getOwnPropertyNames(current).forEach((key) => (def[key] = () => (value[key])));
/******/ 			}
/******/ 			def['default'] = () => (value);
/******/ 			__webpack_require__.d(ns, def);
/******/ 			return ns;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/ensure chunk */
/******/ 	(() => {
/******/ 		__webpack_require__.f = {};
/******/ 		// This file contains only the entry chunk.
/******/ 		// The chunk loading function for additional chunks
/******/ 		__webpack_require__.e = (chunkId) => {
/******/ 			return Promise.all(Object.keys(__webpack_require__.f).reduce((promises, key) => {
/******/ 				__webpack_require__.f[key](chunkId, promises);
/******/ 				return promises;
/******/ 			}, []));
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/get javascript chunk filename */
/******/ 	(() => {
/******/ 		// This function allow to reference async chunks
/******/ 		__webpack_require__.u = (chunkId) => {
/******/ 			// return url for filenames based on template
/******/ 			return "" + chunkId + ".js";
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/harmony module decorator */
/******/ 	(() => {
/******/ 		__webpack_require__.hmd = (module) => {
/******/ 			module = Object.create(module);
/******/ 			if (!module.children) module.children = [];
/******/ 			Object.defineProperty(module, 'exports', {
/******/ 				enumerable: true,
/******/ 				set: () => {
/******/ 					throw new Error('ES Modules may not assign module.exports or exports.*, Use ESM export syntax, instead: ' + module.id);
/******/ 				}
/******/ 			});
/******/ 			return module;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/wasm loading */
/******/ 	(() => {
/******/ 		__webpack_require__.v = (exports, wasmModuleId, wasmModuleHash, importsObj) => {
/******/ 		
/******/ 			return new Promise(function (resolve, reject) {
/******/ 				try {
/******/ 					var { readFile } = require('fs');
/******/ 					var { join } = require('path');
/******/ 		
/******/ 					readFile(join(__dirname, "" + wasmModuleHash + ".module.wasm"), function(err, buffer){
/******/ 						if (err) return reject(err);
/******/ 		
/******/ 						// Fake fetch response
/******/ 						resolve({
/******/ 							arrayBuffer() { return buffer; }
/******/ 						});
/******/ 					});
/******/ 				} catch (err) { reject(err); }
/******/ 			})
/******/ 				.then((x) => (x.arrayBuffer()))
/******/ 				.then((bytes) => (WebAssembly.instantiate(bytes, importsObj)))
/******/ 				.then((res) => (Object.assign(exports, res.instance.exports)));
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/require chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded chunks
/******/ 		// "1" means "loaded", otherwise not loaded yet
/******/ 		var installedChunks = {
/******/ 			570: 1
/******/ 		};
/******/ 		
/******/ 		// no on chunks loaded
/******/ 		
/******/ 		var installChunk = (chunk) => {
/******/ 			var moreModules = chunk.modules, chunkIds = chunk.ids, runtime = chunk.runtime;
/******/ 			for(var moduleId in moreModules) {
/******/ 				if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 					__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 				}
/******/ 			}
/******/ 			if(runtime) runtime(__webpack_require__);
/******/ 			for(var i = 0; i < chunkIds.length; i++)
/******/ 				installedChunks[chunkIds[i]] = 1;
/******/ 		
/******/ 		};
/******/ 		
/******/ 		// require() chunk loading for javascript
/******/ 		__webpack_require__.f.require = (chunkId, promises) => {
/******/ 			// "1" is the signal for "already loaded"
/******/ 			if(!installedChunks[chunkId]) {
/******/ 				if(true) { // all chunks have JS
/******/ 					installChunk(require("./" + __webpack_require__.u(chunkId)));
/******/ 				} else installedChunks[chunkId] = 1;
/******/ 			}
/******/ 		};
/******/ 		
/******/ 		// no external install chunk
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};

// NAMESPACE OBJECT: ../../libs/tools/generator/core/src/engine/index.ts
var engine_namespaceObject = {};
__webpack_require__.r(engine_namespaceObject);
__webpack_require__.d(engine_namespaceObject, {
  Lq: () => (EmailCalculator),
  Mt: () => (EmailRandomizer),
  sF: () => (forwarder_context_ForwarderContext),
  q4: () => (key_service_randomizer_KeyServiceRandomizer),
  Zx: () => (PasswordRandomizer),
  QS: () => (UsernameRandomizer)
});

// NAMESPACE OBJECT: ../../libs/tools/generator/core/src/strategies/index.ts
var strategies_namespaceObject = {};
__webpack_require__.r(strategies_namespaceObject);
__webpack_require__.d(strategies_namespaceObject, {
  B: () => (CatchallGeneratorStrategy),
  KQ: () => (EffUsernameGeneratorStrategy),
  ji: () => (ForwarderGeneratorStrategy),
  jK: () => (PassphraseGeneratorStrategy),
  gb: () => (PasswordGeneratorStrategy),
  Vm: () => (SubaddressGeneratorStrategy)
});

;// external "core-js/proposals/explicit-resource-management"
const explicit_resource_management_namespaceObject = require("core-js/proposals/explicit-resource-management");
;// external "commander"
const external_commander_namespaceObject = require("commander");
;// external "@koa/multer"
const multer_namespaceObject = require("@koa/multer");
;// ../../libs/common/src/models/response/base.response.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore
class BaseResponse {
    constructor(response) {
        this.response = response;
    }
    getResponseProperty(propertyName, response = null, exactName = false) {
        if (propertyName == null || propertyName === "") {
            throw new Error("propertyName must not be null/empty.");
        }
        if (response == null && this.response != null) {
            response = this.response;
        }
        if (response == null) {
            return null;
        }
        if (!exactName && response[propertyName] === undefined) {
            let otherCasePropertyName = null;
            if (propertyName.charAt(0) === propertyName.charAt(0).toUpperCase()) {
                otherCasePropertyName = propertyName.charAt(0).toLowerCase();
            }
            else {
                otherCasePropertyName = propertyName.charAt(0).toUpperCase();
            }
            if (propertyName.length > 1) {
                otherCasePropertyName += propertyName.slice(1);
            }
            propertyName = otherCasePropertyName;
            if (response[propertyName] === undefined) {
                propertyName = propertyName.toLowerCase();
            }
            if (response[propertyName] === undefined) {
                propertyName = propertyName.toUpperCase();
            }
        }
        return response[propertyName];
    }
}

;// ../../libs/common/src/models/response/list.response.ts

class ListResponse extends BaseResponse {
    constructor(response, t) {
        super(response);
        const data = this.getResponseProperty("Data");
        this.data = data == null ? [] : data.map((dr) => new t(dr));
        this.continuationToken = this.getResponseProperty("ContinuationToken");
    }
}

;// ../../libs/admin-console/src/common/organization-user/models/requests/organization-user-bulk.request.ts
class OrganizationUserBulkRequest {
    constructor(ids) {
        this.ids = ids == null ? [] : ids;
    }
}

;// ../../libs/common/src/admin-console/models/api/permissions.api.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

class PermissionsApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return this;
        }
        this.accessEventLogs = this.getResponseProperty("AccessEventLogs");
        this.accessImportExport = this.getResponseProperty("AccessImportExport");
        this.accessReports = this.getResponseProperty("AccessReports");
        this.createNewCollections = this.getResponseProperty("CreateNewCollections");
        this.editAnyCollection = this.getResponseProperty("EditAnyCollection");
        this.deleteAnyCollection = this.getResponseProperty("DeleteAnyCollection");
        this.manageCiphers = this.getResponseProperty("ManageCiphers");
        this.manageGroups = this.getResponseProperty("ManageGroups");
        this.manageSso = this.getResponseProperty("ManageSso");
        this.managePolicies = this.getResponseProperty("ManagePolicies");
        this.manageUsers = this.getResponseProperty("ManageUsers");
        this.manageResetPassword = this.getResponseProperty("ManageResetPassword");
        this.manageScim = this.getResponseProperty("ManageScim");
    }
}

;// ../../libs/common/src/admin-console/models/response/selection-read-only.response.ts

class SelectionReadOnlyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.readOnly = this.getResponseProperty("ReadOnly");
        this.hidePasswords = this.getResponseProperty("HidePasswords");
        this.manage = this.getResponseProperty("Manage");
    }
}

;// ../../libs/admin-console/src/common/organization-user/models/responses/organization-user.response.ts



class OrganizationUserResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.collections = [];
        this.groups = [];
        this.id = this.getResponseProperty("Id");
        this.userId = this.getResponseProperty("UserId");
        this.type = this.getResponseProperty("Type");
        this.status = this.getResponseProperty("Status");
        this.permissions = new PermissionsApi(this.getResponseProperty("Permissions"));
        this.externalId = this.getResponseProperty("ExternalId");
        this.accessSecretsManager = this.getResponseProperty("AccessSecretsManager");
        this.resetPasswordEnrolled = this.getResponseProperty("ResetPasswordEnrolled");
        this.hasMasterPassword = this.getResponseProperty("HasMasterPassword");
        const collections = this.getResponseProperty("Collections");
        if (collections != null) {
            this.collections = collections.map((c) => new SelectionReadOnlyResponse(c));
        }
        const groups = this.getResponseProperty("Groups");
        if (groups != null) {
            this.groups = groups;
        }
    }
}
class OrganizationUserUserDetailsResponse extends OrganizationUserResponse {
    constructor(response) {
        var _a, _b;
        super(response);
        this.name = this.getResponseProperty("Name");
        this.email = this.getResponseProperty("Email");
        this.avatarColor = this.getResponseProperty("AvatarColor");
        this.twoFactorEnabled = this.getResponseProperty("TwoFactorEnabled");
        this.usesKeyConnector = (_a = this.getResponseProperty("UsesKeyConnector")) !== null && _a !== void 0 ? _a : false;
        this.managedByOrganization = (_b = this.getResponseProperty("ManagedByOrganization")) !== null && _b !== void 0 ? _b : false;
    }
}
class OrganizationUserDetailsResponse extends OrganizationUserResponse {
    constructor(response) {
        var _a;
        super(response);
        this.managedByOrganization = (_a = this.getResponseProperty("ManagedByOrganization")) !== null && _a !== void 0 ? _a : false;
        this.ssoExternalId = this.getResponseProperty("SsoExternalId");
    }
}
class OrganizationUserResetPasswordDetailsResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.organizationUserId = this.getResponseProperty("OrganizationUserId");
        this.kdf = this.getResponseProperty("Kdf");
        this.kdfIterations = this.getResponseProperty("KdfIterations");
        this.kdfMemory = this.getResponseProperty("KdfMemory");
        this.kdfParallelism = this.getResponseProperty("KdfParallelism");
        this.resetPasswordKey = this.getResponseProperty("ResetPasswordKey");
        this.encryptedPrivateKey = this.getResponseProperty("EncryptedPrivateKey");
    }
}

;// ../../libs/admin-console/src/common/organization-user/models/responses/organization-user-bulk.response.ts

class OrganizationUserBulkResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.error = this.getResponseProperty("Error");
    }
}

;// ../../libs/admin-console/src/common/organization-user/models/responses/organization-user-bulk-public-key.response.ts

class OrganizationUserBulkPublicKeyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.userId = this.getResponseProperty("UserId");
        this.key = this.getResponseProperty("Key");
    }
}

;// ../../libs/admin-console/src/common/organization-user/models/responses/organization-user-mini.response.ts

class OrganizationUserUserMiniResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.userId = this.getResponseProperty("UserId");
        this.email = this.getResponseProperty("Email");
        this.name = this.getResponseProperty("Name");
        this.type = this.getResponseProperty("Type");
        this.status = this.getResponseProperty("Status");
    }
}

;// ../../libs/admin-console/src/common/organization-user/models/responses/index.ts





;// ../../libs/admin-console/src/common/organization-user/services/default-organization-user-api.service.ts
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class DefaultOrganizationUserApiService {
    constructor(apiService) {
        this.apiService = apiService;
    }
    getOrganizationUser(organizationId, id, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const params = new URLSearchParams();
            if (options === null || options === void 0 ? void 0 : options.includeGroups) {
                params.set("includeGroups", "true");
            }
            const r = yield this.apiService.send("GET", `/organizations/${organizationId}/users/${id}?${params.toString()}`, null, true, true);
            return new OrganizationUserDetailsResponse(r);
        });
    }
    getOrganizationUserGroups(organizationId, id) {
        return __awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/users/" + id + "/groups", null, true, true);
            return r;
        });
    }
    getAllUsers(organizationId, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const params = new URLSearchParams();
            if (options === null || options === void 0 ? void 0 : options.includeCollections) {
                params.set("includeCollections", "true");
            }
            if (options === null || options === void 0 ? void 0 : options.includeGroups) {
                params.set("includeGroups", "true");
            }
            const r = yield this.apiService.send("GET", `/organizations/${organizationId}/users?${params.toString()}`, null, true, true);
            return new ListResponse(r, OrganizationUserUserDetailsResponse);
        });
    }
    getAllMiniUserDetails(organizationId) {
        return __awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", `/organizations/${organizationId}/users/mini-details`, null, true, true);
            return new ListResponse(r, OrganizationUserUserMiniResponse);
        });
    }
    getOrganizationUserResetPasswordDetails(organizationId, id) {
        return __awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/users/" + id + "/reset-password-details", null, true, true);
            return new OrganizationUserResetPasswordDetailsResponse(r);
        });
    }
    getManyOrganizationUserAccountRecoveryDetails(organizationId, ids) {
        return __awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/account-recovery-details", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserResetPasswordDetailsResponse);
        });
    }
    postOrganizationUserInvite(organizationId, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/invite", request, true, false);
    }
    postOrganizationUserReinvite(organizationId, id) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/reinvite", null, true, false);
    }
    postManyOrganizationUserReinvite(organizationId, ids) {
        return __awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/reinvite", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    postOrganizationUserAcceptInit(organizationId, id, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/accept-init", request, true, false);
    }
    postOrganizationUserAccept(organizationId, id, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/accept", request, true, false);
    }
    postOrganizationUserConfirm(organizationId, id, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/confirm", request, true, false);
    }
    postOrganizationUsersPublicKey(organizationId, ids) {
        return __awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/public-keys", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkPublicKeyResponse);
        });
    }
    postOrganizationUserBulkConfirm(organizationId, request) {
        return __awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/confirm", request, true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    putOrganizationUserBulkEnableSecretsManager(organizationId, ids) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("PUT", "/organizations/" + organizationId + "/users/enable-secrets-manager", new OrganizationUserBulkRequest(ids), true, false);
        });
    }
    putOrganizationUser(organizationId, id, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id, request, true, false);
    }
    putOrganizationUserResetPasswordEnrollment(organizationId, userId, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + userId + "/reset-password-enrollment", request, true, false);
    }
    putOrganizationUserResetPassword(organizationId, id, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id + "/reset-password", request, true, false);
    }
    removeOrganizationUser(organizationId, id) {
        return this.apiService.send("DELETE", "/organizations/" + organizationId + "/users/" + id, null, true, false);
    }
    removeManyOrganizationUsers(organizationId, ids) {
        return __awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("DELETE", "/organizations/" + organizationId + "/users", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    revokeOrganizationUser(organizationId, id) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id + "/revoke", null, true, false);
    }
    revokeManyOrganizationUsers(organizationId, ids) {
        return __awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + organizationId + "/users/revoke", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    restoreOrganizationUser(organizationId, id) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id + "/restore", null, true, false);
    }
    restoreManyOrganizationUsers(organizationId, ids) {
        return __awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + organizationId + "/users/restore", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    deleteOrganizationUser(organizationId, id) {
        return this.apiService.send("DELETE", "/organizations/" + organizationId + "/users/" + id + "/delete-account", null, true, false);
    }
    deleteManyOrganizationUsers(organizationId, ids) {
        return __awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("DELETE", "/organizations/" + organizationId + "/users/delete-account", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
}

;// ../../libs/admin-console/src/common/organization-user/services/index.ts


;// ../../libs/admin-console/src/common/organization-user/models/requests/organization-user-confirm.request.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore
class OrganizationUserConfirmRequest {
}

;// ../../libs/admin-console/src/common/organization-user/models/requests/organization-user-reset-password.request.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore
class OrganizationUserResetPasswordRequest {
}

;// ../../libs/admin-console/src/common/organization-user/models/requests/index.ts










;// ../../libs/admin-console/src/common/organization-user/models/index.ts



;// ../../libs/admin-console/src/common/organization-user/index.ts




;// ../../libs/common/src/models/view/view.ts
// See https://contributing.bitwarden.com/architecture/clients/data-model/#view for proper use.
// View models represent the decrypted state of a corresponding Domain model.
// They typically match the Domain model but contains a decrypted string for any EncString fields.
// Don't use this to represent arbitrary component view data as that isn't what it is for.
class View {
}

;// ../../libs/admin-console/src/common/collections/models/collection-access-selection.view.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

class CollectionAccessSelectionView extends View {
    constructor(response) {
        super();
        if (!response) {
            return;
        }
        this.id = response.id;
        this.readOnly = response.readOnly;
        this.hidePasswords = response.hidePasswords;
        this.manage = response.manage;
    }
}

;// ../../libs/common/src/platform/enums/encryption-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var EncryptionType;
(function (EncryptionType) {
    EncryptionType[EncryptionType["AesCbc256_B64"] = 0] = "AesCbc256_B64";
    // Type 1 was the unused and removed AesCbc128_HmacSha256_B64
    EncryptionType[EncryptionType["AesCbc256_HmacSha256_B64"] = 2] = "AesCbc256_HmacSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha256_B64"] = 3] = "Rsa2048_OaepSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha1_B64"] = 4] = "Rsa2048_OaepSha1_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha256_HmacSha256_B64"] = 5] = "Rsa2048_OaepSha256_HmacSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha1_HmacSha256_B64"] = 6] = "Rsa2048_OaepSha1_HmacSha256_B64";
})(EncryptionType || (EncryptionType = {}));
function encryptionTypeToString(encryptionType) {
    if (encryptionType in EncryptionType) {
        return EncryptionType[encryptionType];
    }
    else {
        return "Unknown encryption type " + encryptionType;
    }
}
/** The expected number of parts to a serialized EncString of the given encryption type.
 * For example, an EncString of type AesCbc256_B64 will have 2 parts
 *
 * Example of annotated serialized EncStrings:
 * 0.iv|data
 * 2.iv|data|mac
 * 3.data
 * 4.data
 *
 * @see EncString
 * @see EncryptionType
 * @see EncString.parseEncryptedString
 */
const EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE = {
    [EncryptionType.AesCbc256_B64]: 2,
    [EncryptionType.AesCbc256_HmacSha256_B64]: 3,
    [EncryptionType.Rsa2048_OaepSha256_B64]: 1,
    [EncryptionType.Rsa2048_OaepSha1_B64]: 1,
    [EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64]: 2,
    [EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64]: 2,
};

;// ../../libs/common/src/platform/enums/file-upload-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var FileUploadType;
(function (FileUploadType) {
    FileUploadType[FileUploadType["Direct"] = 0] = "Direct";
    FileUploadType[FileUploadType["Azure"] = 1] = "Azure";
})(FileUploadType || (FileUploadType = {}));

;// ../../libs/common/src/platform/enums/hash-purpose.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var HashPurpose;
(function (HashPurpose) {
    HashPurpose[HashPurpose["ServerAuthorization"] = 1] = "ServerAuthorization";
    HashPurpose[HashPurpose["LocalAuthorization"] = 2] = "LocalAuthorization";
})(HashPurpose || (HashPurpose = {}));

;// ../../libs/common/src/platform/enums/html-storage-location.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var HtmlStorageLocation;
(function (HtmlStorageLocation) {
    HtmlStorageLocation["Local"] = "local";
    HtmlStorageLocation["Memory"] = "memory";
    HtmlStorageLocation["Session"] = "session";
})(HtmlStorageLocation || (HtmlStorageLocation = {}));

;// ../../libs/common/src/platform/enums/key-suffix-options.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var KeySuffixOptions;
(function (KeySuffixOptions) {
    KeySuffixOptions["Auto"] = "auto";
    KeySuffixOptions["Pin"] = "pin";
})(KeySuffixOptions || (KeySuffixOptions = {}));

;// ../../libs/common/src/platform/enums/log-level-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var LogLevelType;
(function (LogLevelType) {
    LogLevelType[LogLevelType["Debug"] = 0] = "Debug";
    LogLevelType[LogLevelType["Info"] = 1] = "Info";
    LogLevelType[LogLevelType["Warning"] = 2] = "Warning";
    LogLevelType[LogLevelType["Error"] = 3] = "Error";
})(LogLevelType || (LogLevelType = {}));

;// ../../libs/common/src/platform/enums/storage-location.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var StorageLocation;
(function (StorageLocation) {
    StorageLocation["Both"] = "both";
    StorageLocation["Disk"] = "disk";
    StorageLocation["Memory"] = "memory";
})(StorageLocation || (StorageLocation = {}));

;// ../../libs/common/src/platform/enums/theme-type.enum.ts
/**
 * @deprecated prefer the `ThemeTypes` constants and `Theme` type over unsafe enum types
 **/
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ThemeType;
(function (ThemeType) {
    ThemeType["System"] = "system";
    ThemeType["Light"] = "light";
    ThemeType["Dark"] = "dark";
})(ThemeType || (ThemeType = {}));
const ThemeTypes = {
    System: "system",
    Light: "light",
    Dark: "dark",
};

;// ../../libs/common/src/platform/enums/index.ts









;// external "path"
const external_path_namespaceObject = require("path");
;// external "buffer/"
const _namespaceObject = require("buffer/");
;// external "rxjs"
const external_rxjs_namespaceObject = require("rxjs");
;// external "tldts"
const external_tldts_namespaceObject = require("tldts");
;// ../../libs/common/src/platform/misc/utils.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore
/* eslint-disable no-useless-escape */




// FIXME: Remove when updating file. Eslint update
// eslint-disable-next-line @typescript-eslint/no-require-imports
const nodeURL = typeof self === "undefined" ? __webpack_require__(857) : null;
class utils_Utils {
    static init() {
        if (utils_Utils.inited) {
            return;
        }
        utils_Utils.inited = true;
        utils_Utils.isNode =
            typeof process !== "undefined" &&
                process.release != null &&
                process.release.name === "node";
        utils_Utils.isBrowser = typeof window !== "undefined";
        utils_Utils.isMobileBrowser = utils_Utils.isBrowser && this.isMobile(window);
        utils_Utils.isAppleMobileBrowser = utils_Utils.isBrowser && this.isAppleMobile(window);
        if (utils_Utils.isNode) {
            utils_Utils.global = global;
        }
        else if (utils_Utils.isBrowser) {
            utils_Utils.global = window;
        }
        else {
            // If it's not browser or node then it must be a service worker
            utils_Utils.global = self;
        }
    }
    static fromB64ToArray(str) {
        if (str == null) {
            return null;
        }
        if (utils_Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "base64"));
        }
        else {
            const binaryString = utils_Utils.global.atob(str);
            const bytes = new Uint8Array(binaryString.length);
            for (let i = 0; i < binaryString.length; i++) {
                bytes[i] = binaryString.charCodeAt(i);
            }
            return bytes;
        }
    }
    static fromUrlB64ToArray(str) {
        return utils_Utils.fromB64ToArray(utils_Utils.fromUrlB64ToB64(str));
    }
    static fromHexToArray(str) {
        if (utils_Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "hex"));
        }
        else {
            const bytes = new Uint8Array(str.length / 2);
            for (let i = 0; i < str.length; i += 2) {
                bytes[i / 2] = parseInt(str.substr(i, 2), 16);
            }
            return bytes;
        }
    }
    static fromUtf8ToArray(str) {
        if (utils_Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "utf8"));
        }
        else {
            const strUtf8 = unescape(encodeURIComponent(str));
            const arr = new Uint8Array(strUtf8.length);
            for (let i = 0; i < strUtf8.length; i++) {
                arr[i] = strUtf8.charCodeAt(i);
            }
            return arr;
        }
    }
    static fromByteStringToArray(str) {
        if (str == null) {
            return null;
        }
        const arr = new Uint8Array(str.length);
        for (let i = 0; i < str.length; i++) {
            arr[i] = str.charCodeAt(i);
        }
        return arr;
    }
    static fromBufferToB64(buffer) {
        if (buffer == null) {
            return null;
        }
        if (utils_Utils.isNode) {
            return Buffer.from(buffer).toString("base64");
        }
        else {
            let binary = "";
            const bytes = new Uint8Array(buffer);
            for (let i = 0; i < bytes.byteLength; i++) {
                binary += String.fromCharCode(bytes[i]);
            }
            return utils_Utils.global.btoa(binary);
        }
    }
    static fromBufferToUrlB64(buffer) {
        return utils_Utils.fromB64toUrlB64(utils_Utils.fromBufferToB64(buffer));
    }
    static fromB64toUrlB64(b64Str) {
        return b64Str.replace(/\+/g, "-").replace(/\//g, "_").replace(/=/g, "");
    }
    static fromBufferToUtf8(buffer) {
        return _namespaceObject.Buffer.from(buffer).toString("utf8");
    }
    static fromBufferToByteString(buffer) {
        return String.fromCharCode.apply(null, new Uint8Array(buffer));
    }
    // ref: https://stackoverflow.com/a/40031979/1090359
    static fromBufferToHex(buffer) {
        if (utils_Utils.isNode) {
            return Buffer.from(buffer).toString("hex");
        }
        else {
            const bytes = new Uint8Array(buffer);
            return Array.prototype.map
                .call(bytes, (x) => ("00" + x.toString(16)).slice(-2))
                .join("");
        }
    }
    /**
     * Converts a hex string to an ArrayBuffer.
     * Note: this doesn't need any Node specific code as parseInt() / ArrayBuffer / Uint8Array
     * work the same in Node and the browser.
     * @param {string} hexString - A string of hexadecimal characters.
     * @returns {ArrayBuffer} The ArrayBuffer representation of the hex string.
     */
    static hexStringToArrayBuffer(hexString) {
        // Check if the hexString has an even length, as each hex digit represents half a byte (4 bits),
        // and it takes two hex digits to represent a full byte (8 bits).
        if (hexString.length % 2 !== 0) {
            throw "HexString has to be an even length";
        }
        // Create an ArrayBuffer with a length that is half the length of the hex string,
        // because each pair of hex digits will become a single byte.
        const arrayBuffer = new ArrayBuffer(hexString.length / 2);
        // Create a Uint8Array view on top of the ArrayBuffer (each position represents a byte)
        // as ArrayBuffers cannot be edited directly.
        const uint8Array = new Uint8Array(arrayBuffer);
        // Loop through the bytes
        for (let i = 0; i < uint8Array.length; i++) {
            // Extract two hex characters (1 byte)
            const hexByte = hexString.substr(i * 2, 2);
            // Convert hexByte into a decimal value from base 16. (ex: ff --> 255)
            const byteValue = parseInt(hexByte, 16);
            // Place the byte value into the uint8Array
            uint8Array[i] = byteValue;
        }
        return arrayBuffer;
    }
    static fromUrlB64ToB64(urlB64Str) {
        let output = urlB64Str.replace(/-/g, "+").replace(/_/g, "/");
        switch (output.length % 4) {
            case 0:
                break;
            case 2:
                output += "==";
                break;
            case 3:
                output += "=";
                break;
            default:
                throw new Error("Illegal base64url string!");
        }
        return output;
    }
    static fromUrlB64ToUtf8(urlB64Str) {
        return utils_Utils.fromB64ToUtf8(utils_Utils.fromUrlB64ToB64(urlB64Str));
    }
    static fromUtf8ToB64(utfStr) {
        if (utils_Utils.isNode) {
            return Buffer.from(utfStr, "utf8").toString("base64");
        }
        else {
            return _namespaceObject.Buffer.from(utfStr, "utf8").toString("base64");
        }
    }
    static fromUtf8ToUrlB64(utfStr) {
        return utils_Utils.fromBufferToUrlB64(utils_Utils.fromUtf8ToArray(utfStr));
    }
    static fromB64ToUtf8(b64Str) {
        if (utils_Utils.isNode) {
            return Buffer.from(b64Str, "base64").toString("utf8");
        }
        else {
            return _namespaceObject.Buffer.from(b64Str, "base64").toString("utf8");
        }
    }
    // ref: http://stackoverflow.com/a/2117523/1090359
    static newGuid() {
        return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (c) => {
            const r = (Math.random() * 16) | 0;
            const v = c === "x" ? r : (r & 0x3) | 0x8;
            return v.toString(16);
        });
    }
    static isGuid(id) {
        return RegExp(utils_Utils.guidRegex, "i").test(id);
    }
    static getHostname(uriString) {
        if (utils_Utils.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        if (uriString.startsWith("data:")) {
            return null;
        }
        if (uriString.startsWith("about:")) {
            return null;
        }
        if (uriString.startsWith("file:")) {
            return null;
        }
        // Does uriString contain invalid characters
        // TODO Needs to possibly be extended, although '!' is a reserved character
        if (uriString.indexOf("!") > 0) {
            return null;
        }
        try {
            const hostname = (0,external_tldts_namespaceObject.getHostname)(uriString, { validHosts: this.validHosts });
            if (hostname != null) {
                return hostname;
            }
        }
        catch (_a) {
            return null;
        }
        return null;
    }
    static getHost(uriString) {
        const url = utils_Utils.getUrl(uriString);
        try {
            return url != null && url.host !== "" ? url.host : null;
        }
        catch (_a) {
            return null;
        }
    }
    static getDomain(uriString) {
        if (utils_Utils.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        if (uriString.startsWith("data:")) {
            return null;
        }
        if (uriString.startsWith("about:")) {
            return null;
        }
        try {
            const parseResult = (0,external_tldts_namespaceObject.parse)(uriString, {
                validHosts: this.validHosts,
                allowPrivateDomains: true,
            });
            if (parseResult != null && parseResult.hostname != null) {
                if (parseResult.hostname === "localhost" || parseResult.isIp) {
                    return parseResult.hostname;
                }
                if (parseResult.domain != null) {
                    return parseResult.domain;
                }
                return null;
            }
        }
        catch (_a) {
            return null;
        }
        return null;
    }
    static getQueryParams(uriString) {
        const url = utils_Utils.getUrl(uriString);
        if (url == null || url.search == null || url.search === "") {
            return null;
        }
        const map = new Map();
        const pairs = (url.search[0] === "?" ? url.search.substr(1) : url.search).split("&");
        pairs.forEach((pair) => {
            const parts = pair.split("=");
            if (parts.length < 1) {
                return;
            }
            map.set(decodeURIComponent(parts[0]).toLowerCase(), parts[1] == null ? "" : decodeURIComponent(parts[1]));
        });
        return map;
    }
    static getSortFunction(i18nService, prop) {
        return (a, b) => {
            if (a[prop] == null && b[prop] != null) {
                return -1;
            }
            if (a[prop] != null && b[prop] == null) {
                return 1;
            }
            if (a[prop] == null && b[prop] == null) {
                return 0;
            }
            // The `as unknown as string` here is unfortunate because typescript doesn't property understand that the return of T[prop] will be a string
            return i18nService.collator
                ? i18nService.collator.compare(a[prop], b[prop])
                : a[prop].localeCompare(b[prop]);
        };
    }
    static isNullOrWhitespace(str) {
        return str == null || typeof str !== "string" || str.trim() === "";
    }
    static isNullOrEmpty(str) {
        return str == null || typeof str !== "string" || str == "";
    }
    static isPromise(obj) {
        return (obj != undefined && typeof obj["then"] === "function" && typeof obj["catch"] === "function");
    }
    static nameOf(name) {
        return name;
    }
    static assign(target, source) {
        return Object.assign(target, source);
    }
    static iterateEnum(obj) {
        return Object.keys(obj).filter((k) => Number.isNaN(+k)).map((k) => obj[k]);
    }
    static getUrl(uriString) {
        if (this.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        return utils_Utils.getUrlObject(uriString);
    }
    static camelToPascalCase(s) {
        return s.charAt(0).toUpperCase() + s.slice(1);
    }
    /**
     * There are a few ways to calculate text color for contrast, this one seems to fit accessibility guidelines best.
     * https://stackoverflow.com/a/3943023/6869691
     *
     * @param {string} bgColor
     * @param {number} [threshold] see stackoverflow link above
     * @param {boolean} [svgTextFill]
     * Indicates if this method is performed on an SVG <text> 'fill' attribute (e.g. <text fill="black"></text>).
     * This check is necessary because the '!important' tag cannot be used in a 'fill' attribute.
     */
    static pickTextColorBasedOnBgColor(bgColor, threshold = 186, svgTextFill = false) {
        const bgColorHexNums = bgColor.charAt(0) === "#" ? bgColor.substring(1, 7) : bgColor;
        const r = parseInt(bgColorHexNums.substring(0, 2), 16); // hexToR
        const g = parseInt(bgColorHexNums.substring(2, 4), 16); // hexToG
        const b = parseInt(bgColorHexNums.substring(4, 6), 16); // hexToB
        const blackColor = svgTextFill ? "black" : "black !important";
        const whiteColor = svgTextFill ? "white" : "white !important";
        return r * 0.299 + g * 0.587 + b * 0.114 > threshold ? blackColor : whiteColor;
    }
    static stringToColor(str) {
        let hash = 0;
        for (let i = 0; i < str.length; i++) {
            hash = str.charCodeAt(i) + ((hash << 5) - hash);
        }
        let color = "#";
        for (let i = 0; i < 3; i++) {
            const value = (hash >> (i * 8)) & 0xff;
            color += ("00" + value.toString(16)).substr(-2);
        }
        return color;
    }
    /**
     * @throws Will throw an error if the ContainerService has not been attached to the window object
     */
    static getContainerService() {
        if (this.global.bitwardenContainerService == null) {
            throw new Error("global bitwardenContainerService not initialized.");
        }
        return this.global.bitwardenContainerService;
    }
    static validateHexColor(color) {
        return /^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/.test(color);
    }
    /**
     * Converts map to a Record<string, V> with the same data. Inverse of recordToMap
     * Useful in toJSON methods, since Maps are not serializable
     * @param map
     * @returns
     */
    static mapToRecord(map) {
        if (map == null) {
            return null;
        }
        if (!(map instanceof Map)) {
            return map;
        }
        return Object.fromEntries(map);
    }
    /**
     * Converts record to a Map<string, V> with the same data. Inverse of mapToRecord
     * Useful in fromJSON methods, since Maps are not serializable
     *
     * Warning: If the record has string keys that are numbers, they will be converted to numbers in the map
     * @param record
     * @returns
     */
    static recordToMap(record) {
        if (record == null) {
            return null;
        }
        else if (record instanceof Map) {
            return record;
        }
        const entries = Object.entries(record);
        if (entries.length === 0) {
            return new Map();
        }
        if (isNaN(Number(entries[0][0]))) {
            return new Map(entries);
        }
        else {
            return new Map(entries.map((e) => [Number(e[0]), e[1]]));
        }
    }
    /** Applies Object.assign, but converts the type nicely using Type-Fest Merge<Destination, Source> */
    static merge(destination, source) {
        return Object.assign(destination, source);
    }
    /**
     * encodeURIComponent escapes all characters except the following:
     * alphabetic, decimal digits, - _ . ! ~ * ' ( )
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURIComponent#encoding_for_rfc3986
     */
    static encodeRFC3986URIComponent(str) {
        return encodeURIComponent(str).replace(/[!'()*]/g, (c) => `%${c.charCodeAt(0).toString(16).toUpperCase()}`);
    }
    /**
     * Normalizes a path for defense against attacks like traversals
     * @param denormalizedPath
     * @returns
     */
    static normalizePath(denormalizedPath) {
        return external_path_namespaceObject.normalize(decodeURIComponent(denormalizedPath)).replace(/^(\.\.(\/|\\|$))+/, "");
    }
    static isMobile(win) {
        let mobile = false;
        ((a) => {
            if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a) ||
                /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))) {
                mobile = true;
            }
        })(win.navigator.userAgent || win.navigator.vendor || win.opera);
        return mobile || win.navigator.userAgent.match(/iPad/i) != null;
    }
    static delay(ms) {
        return new Promise((resolve) => setTimeout(resolve, ms));
    }
    /**
     * Generate an observable from a function that returns a promise.
     * Similar to the rxjs function {@link from} with one big exception:
     * {@link from} will not re-execute the function when observers resubscribe.
     * {@link Util.asyncToObservable} will execute `generator` for every
     * subscribe, making it ideal if the value ever needs to be refreshed.
     * */
    static asyncToObservable(generator) {
        return (0,external_rxjs_namespaceObject.of)(undefined).pipe((0,external_rxjs_namespaceObject.switchMap)(() => generator()));
    }
    /**
     * Return the number of days remaining before a target date arrives.
     * Returns 0 if the day has already passed.
     */
    static daysRemaining(targetDate) {
        const diffTime = targetDate.getTime() - Date.now();
        const msPerDay = 86400000;
        return Math.max(0, Math.floor(diffTime / msPerDay));
    }
    static isAppleMobile(win) {
        return (win.navigator.userAgent.match(/iPhone/i) != null ||
            win.navigator.userAgent.match(/iPad/i) != null);
    }
    static getUrlObject(uriString) {
        // All the methods below require a protocol to properly parse a URL string
        // Assume http if no other protocol is present
        const hasProtocol = uriString.indexOf("://") > -1;
        if (!hasProtocol && uriString.indexOf(".") > -1) {
            uriString = "http://" + uriString;
        }
        else if (!hasProtocol) {
            return null;
        }
        try {
            if (nodeURL != null) {
                return new nodeURL.URL(uriString);
            }
            return new URL(uriString);
            // FIXME: Remove when updating file. Eslint update
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
        }
        catch (e) {
            // Ignore error
        }
        return null;
    }
}
utils_Utils.inited = false;
utils_Utils.isNode = false;
utils_Utils.isBrowser = true;
utils_Utils.isMobileBrowser = false;
utils_Utils.isAppleMobileBrowser = false;
utils_Utils.global = null;
// Transpiled version of /\p{Emoji_Presentation}/gu using https://mothereff.in/regexpu. Used for compatability in older browsers.
utils_Utils.regexpEmojiPresentation = /(?:[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u270A\u270B\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF93\uDFA0-\uDFCA\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF4\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC3E\uDC40\uDC42-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDD7A\uDD95\uDD96\uDDA4\uDDFB-\uDE4F\uDE80-\uDEC5\uDECC\uDED0-\uDED2\uDED5-\uDED7\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0C-\uDD3A\uDD3C-\uDD45\uDD47-\uDD78\uDD7A-\uDDCB\uDDCD-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6])/g;
utils_Utils.validHosts = ["localhost"];
utils_Utils.originalMinimumPasswordLength = 8;
utils_Utils.minimumPasswordLength = 12;
utils_Utils.DomainMatchBlacklist = new Map([
    ["google.com", new Set(["script.google.com"])],
]);
utils_Utils.guidRegex = /^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/;
utils_Utils.init();

;// ../../libs/common/src/platform/models/domain/enc-string.ts
var enc_string_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const DECRYPT_ERROR = "[error: cannot decrypt]";
class enc_string_EncString {
    constructor(encryptedStringOrType, data, iv, mac) {
        if (data != null) {
            this.initFromData(encryptedStringOrType, data, iv, mac);
        }
        else {
            this.initFromEncryptedString(encryptedStringOrType);
        }
    }
    get ivBytes() {
        return this.iv == null ? null : utils_Utils.fromB64ToArray(this.iv);
    }
    get macBytes() {
        return this.mac == null ? null : utils_Utils.fromB64ToArray(this.mac);
    }
    get dataBytes() {
        return this.data == null ? null : utils_Utils.fromB64ToArray(this.data);
    }
    toJSON() {
        return this.encryptedString;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return new enc_string_EncString(obj);
    }
    initFromData(encType, data, iv, mac) {
        if (iv != null) {
            this.encryptedString = (encType + "." + iv + "|" + data);
        }
        else {
            this.encryptedString = (encType + "." + data);
        }
        // mac
        if (mac != null) {
            this.encryptedString = (this.encryptedString + "|" + mac);
        }
        this.encryptionType = encType;
        this.data = data;
        this.iv = iv;
        this.mac = mac;
    }
    initFromEncryptedString(encryptedString) {
        this.encryptedString = encryptedString;
        if (!this.encryptedString) {
            return;
        }
        const { encType, encPieces } = enc_string_EncString.parseEncryptedString(this.encryptedString);
        this.encryptionType = encType;
        if (encPieces.length !== EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE[encType]) {
            return;
        }
        switch (encType) {
            case EncryptionType.AesCbc256_HmacSha256_B64:
                this.iv = encPieces[0];
                this.data = encPieces[1];
                this.mac = encPieces[2];
                break;
            case EncryptionType.AesCbc256_B64:
                this.iv = encPieces[0];
                this.data = encPieces[1];
                break;
            case EncryptionType.Rsa2048_OaepSha256_B64:
            case EncryptionType.Rsa2048_OaepSha1_B64:
                this.data = encPieces[0];
                break;
            case EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64:
            case EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64:
                this.data = encPieces[0];
                this.mac = encPieces[1];
                break;
            default:
                return;
        }
    }
    static parseEncryptedString(encryptedString) {
        const headerPieces = encryptedString.split(".");
        let encType;
        let encPieces = null;
        if (headerPieces.length === 2) {
            try {
                encType = parseInt(headerPieces[0], null);
                encPieces = headerPieces[1].split("|");
                // FIXME: Remove when updating file. Eslint update
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
            }
            catch (e) {
                return { encType: NaN, encPieces: [] };
            }
        }
        else {
            encPieces = encryptedString.split("|");
            encType = EncryptionType.AesCbc256_B64;
        }
        return {
            encType,
            encPieces,
        };
    }
    static isSerializedEncString(s) {
        if (s == null) {
            return false;
        }
        const { encType, encPieces } = this.parseEncryptedString(s);
        if (isNaN(encType) || encPieces.length === 0) {
            return false;
        }
        return EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE[encType] === encPieces.length;
    }
    decrypt(orgId_1) {
        return enc_string_awaiter(this, arguments, void 0, function* (orgId, key = null, context) {
            if (this.decryptedValue != null) {
                return this.decryptedValue;
            }
            let decryptTrace = "provided-key";
            try {
                if (key == null) {
                    key = yield this.getKeyForDecryption(orgId);
                    decryptTrace = orgId == null ? `domain-orgkey-${orgId}` : "domain-userkey|masterkey";
                    if (orgId != null) {
                        decryptTrace = `domain-orgkey-${orgId}`;
                    }
                    else {
                        const cryptoService = utils_Utils.getContainerService().getKeyService();
                        decryptTrace =
                            (yield cryptoService.getUserKey()) == null
                                ? "domain-withlegacysupport-masterkey"
                                : "domain-withlegacysupport-userkey";
                    }
                }
                if (key == null) {
                    throw new Error("No key to decrypt EncString with orgId " + orgId);
                }
                const encryptService = utils_Utils.getContainerService().getEncryptService();
                this.decryptedValue = yield encryptService.decryptToUtf8(this, key, decryptTrace == null ? context : `${decryptTrace}${context || ""}`);
                // FIXME: Remove when updating file. Eslint update
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
            }
            catch (e) {
                this.decryptedValue = DECRYPT_ERROR;
            }
            return this.decryptedValue;
        });
    }
    decryptWithKey(key_1, encryptService_1) {
        return enc_string_awaiter(this, arguments, void 0, function* (key, encryptService, decryptTrace = "domain-withkey") {
            try {
                if (key == null) {
                    throw new Error("No key to decrypt EncString");
                }
                this.decryptedValue = yield encryptService.decryptToUtf8(this, key, decryptTrace);
                // FIXME: Remove when updating file. Eslint update
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
            }
            catch (e) {
                this.decryptedValue = DECRYPT_ERROR;
            }
            return this.decryptedValue;
        });
    }
    getKeyForDecryption(orgId) {
        return enc_string_awaiter(this, void 0, void 0, function* () {
            const keyService = utils_Utils.getContainerService().getKeyService();
            return orgId != null
                ? yield keyService.getOrgKey(orgId)
                : yield keyService.getUserKeyWithLegacySupport();
        });
    }
}

;// ../../libs/common/src/platform/models/domain/domain-base.ts
var domain_base_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// https://contributing.bitwarden.com/architecture/clients/data-model#domain
class domain_base_Domain {
    buildDomainModel(domain, dataObj, map, notEncList = []) {
        for (const prop in map) {
            // eslint-disable-next-line
            if (!map.hasOwnProperty(prop)) {
                continue;
            }
            const objProp = dataObj[map[prop] || prop];
            if (notEncList.indexOf(prop) > -1) {
                domain[prop] = objProp ? objProp : null;
            }
            else {
                domain[prop] = objProp ? new enc_string_EncString(objProp) : null;
            }
        }
    }
    buildDataModel(domain, dataObj, map, notEncStringList = []) {
        for (const prop in map) {
            // eslint-disable-next-line
            if (!map.hasOwnProperty(prop)) {
                continue;
            }
            const objProp = domain[map[prop] || prop];
            if (notEncStringList.indexOf(prop) > -1) {
                dataObj[prop] = objProp != null ? objProp : null;
            }
            else {
                dataObj[prop] = objProp != null ? objProp.encryptedString : null;
            }
        }
    }
    decryptObj(domain_1, viewModel_1, props_1, orgId_1) {
        return domain_base_awaiter(this, arguments, void 0, function* (domain, viewModel, props, orgId, key = null, objectContext = "No Domain Context") {
            var _a, _b;
            for (const prop of props) {
                viewModel[prop] =
                    (_b = (yield ((_a = domain[prop]) === null || _a === void 0 ? void 0 : _a.decrypt(orgId, key, `Property: ${prop}; ObjectContext: ${objectContext}`)))) !== null && _b !== void 0 ? _b : null;
            }
            return viewModel;
        });
    }
    /**
     * Decrypts the requested properties of the domain object with the provided key and encrypt service.
     *
     * If a property is null, the result will be null.
     * @see {@link EncString.decryptWithKey} for more details on decryption behavior.
     *
     * @param encryptedProperties The properties to decrypt. Type restricted to EncString properties of the domain object.
     * @param key The key to use for decryption.
     * @param encryptService The encryption service to use for decryption.
     * @param _ The constructor of the domain object. Used for type inference if the domain object is not automatically inferred.
     * @returns An object with the requested properties decrypted and the rest of the domain object untouched.
     */
    decryptObjWithKey(encryptedProperties_1, key_1, encryptService_1) {
        return domain_base_awaiter(this, arguments, void 0, function* (encryptedProperties, key, encryptService, _ = this.constructor, objectContext = "No Domain Context") {
            const decryptedObjects = [];
            for (const prop of encryptedProperties) {
                const value = this[prop];
                const decrypted = yield this.decryptProperty(prop, value, key, encryptService, `Property: ${prop.toString()}; ObjectContext: ${objectContext}`);
                decryptedObjects.push(decrypted);
            }
            const decryptedObject = decryptedObjects.reduce((acc, obj) => {
                return Object.assign(Object.assign({}, acc), obj);
            }, Object.assign({}, this));
            return decryptedObject;
        });
    }
    decryptProperty(propertyKey, value, key, encryptService, decryptTrace) {
        return domain_base_awaiter(this, void 0, void 0, function* () {
            let decrypted = null;
            if (value) {
                decrypted = yield value.decryptWithKey(key, encryptService, decryptTrace);
            }
            return {
                [propertyKey]: decrypted,
            };
        });
    }
}

;// ../../libs/admin-console/src/common/collections/models/collection.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore


class Collection extends domain_base_Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            id: null,
            organizationId: null,
            name: null,
            externalId: null,
            readOnly: null,
            hidePasswords: null,
            manage: null,
        }, ["id", "organizationId", "readOnly", "hidePasswords", "manage"]);
    }
    decrypt(orgKey) {
        return this.decryptObj(this, new CollectionView(this), ["name"], this.organizationId, orgKey);
    }
}

;// ../../libs/admin-console/src/common/collections/models/collection.response.ts


class CollectionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.organizationId = this.getResponseProperty("OrganizationId");
        this.name = this.getResponseProperty("Name");
        this.externalId = this.getResponseProperty("ExternalId");
    }
}
class CollectionDetailsResponse extends CollectionResponse {
    constructor(response) {
        super(response);
        this.readOnly = this.getResponseProperty("ReadOnly") || false;
        this.manage = this.getResponseProperty("Manage") || false;
        this.hidePasswords = this.getResponseProperty("HidePasswords") || false;
        // Temporary until the API is updated to return this property in AC-2084
        // For now, we can assume that if the object is 'collectionDetails' then the user is assigned
        this.assigned = this.getResponseProperty("object") == "collectionDetails";
    }
}
class CollectionAccessDetailsResponse extends CollectionDetailsResponse {
    constructor(response) {
        super(response);
        this.groups = [];
        this.users = [];
        this.assigned = this.getResponseProperty("Assigned") || false;
        this.unmanaged = this.getResponseProperty("Unmanaged") || false;
        const groups = this.getResponseProperty("Groups");
        if (groups != null) {
            this.groups = groups.map((g) => new SelectionReadOnlyResponse(g));
        }
        const users = this.getResponseProperty("Users");
        if (users != null) {
            this.users = users.map((g) => new SelectionReadOnlyResponse(g));
        }
    }
}

;// ../../libs/admin-console/src/common/collections/models/collection.view.ts


const NestingDelimiter = "/";
class CollectionView {
    constructor(c) {
        this.id = null;
        this.organizationId = null;
        this.name = null;
        this.externalId = null;
        // readOnly applies to the items within a collection
        this.readOnly = null;
        this.hidePasswords = null;
        this.manage = null;
        this.assigned = null;
        if (!c) {
            return;
        }
        this.id = c.id;
        this.organizationId = c.organizationId;
        this.externalId = c.externalId;
        if (c instanceof Collection) {
            this.readOnly = c.readOnly;
            this.hidePasswords = c.hidePasswords;
            this.manage = c.manage;
            this.assigned = true;
        }
        if (c instanceof CollectionAccessDetailsResponse) {
            this.assigned = c.assigned;
        }
    }
    canEditItems(org) {
        if (org != null && org.id !== this.organizationId) {
            throw new Error("Id of the organization provided does not match the org id of the collection.");
        }
        return (org === null || org === void 0 ? void 0 : org.canEditAllCiphers) || this.manage || (this.assigned && !this.readOnly);
    }
    /**
     * Returns true if the user can edit a collection (including user and group access) from the individual vault.
     * Does not include admin permissions - see {@link CollectionAdminView.canEdit}.
     */
    canEdit(org) {
        if (org != null && org.id !== this.organizationId) {
            throw new Error("Id of the organization provided does not match the org id of the collection.");
        }
        return this.manage;
    }
    /**
     * Returns true if the user can delete a collection from the individual vault.
     * Does not include admin permissions - see {@link CollectionAdminView.canDelete}.
     */
    canDelete(org) {
        if (org != null && org.id !== this.organizationId) {
            throw new Error("Id of the organization provided does not match the org id of the collection.");
        }
        const canDeleteManagedCollections = !(org === null || org === void 0 ? void 0 : org.limitCollectionDeletion) || org.isAdmin;
        // Only use individual permissions, not admin permissions
        return canDeleteManagedCollections && this.manage;
    }
    /**
     * Returns true if the user can view collection info and access in a read-only state from the individual vault
     */
    canViewCollectionInfo(org) {
        return false;
    }
    static fromJSON(obj) {
        return Object.assign(new CollectionView(new Collection()), obj);
    }
}

;// ../../libs/admin-console/src/common/collections/models/collection-admin.view.ts


const Unassigned = "unassigned";
class collection_admin_view_CollectionAdminView extends CollectionView {
    constructor(response) {
        super(response);
        this.groups = [];
        this.users = [];
        if (!response) {
            return;
        }
        this.groups = response.groups
            ? response.groups.map((g) => new CollectionAccessSelectionView(g))
            : [];
        this.users = response.users
            ? response.users.map((g) => new CollectionAccessSelectionView(g))
            : [];
        this.assigned = response.assigned;
    }
    /**
     * Returns true if the user can edit a collection (including user and group access) from the Admin Console.
     */
    canEdit(org) {
        return ((org === null || org === void 0 ? void 0 : org.canEditAnyCollection) ||
            (this.unmanaged && (org === null || org === void 0 ? void 0 : org.canEditUnmanagedCollections)) ||
            super.canEdit(org));
    }
    /**
     * Returns true if the user can delete a collection from the Admin Console.
     */
    canDelete(org) {
        return (org === null || org === void 0 ? void 0 : org.canDeleteAnyCollection) || super.canDelete(org);
    }
    /**
     * Whether the user can modify user access to this collection
     */
    canEditUserAccess(org) {
        return ((org.permissions.manageUsers && org.allowAdminAccessToAllCollectionItems) || this.canEdit(org));
    }
    /**
     * Whether the user can modify group access to this collection
     */
    canEditGroupAccess(org) {
        return ((org.permissions.manageGroups && org.allowAdminAccessToAllCollectionItems) ||
            this.canEdit(org));
    }
    /**
     * Returns true if the user can view collection info and access in a read-only state from the Admin Console
     */
    canViewCollectionInfo(org) {
        if (this.isUnassignedCollection) {
            return false;
        }
        return this.manage || (org === null || org === void 0 ? void 0 : org.isAdmin) || (org === null || org === void 0 ? void 0 : org.permissions.editAnyCollection);
    }
    /**
     * True if this collection represents the pseudo "Unassigned" collection
     * This is different from the "unmanaged" flag, which indicates that no users or groups have access to the collection
     */
    get isUnassignedCollection() {
        return this.id === Unassigned;
    }
}

;// ../../libs/admin-console/src/common/collections/models/collection.data.ts

class collection_data_CollectionData {
    constructor(response) {
        this.id = response.id;
        this.organizationId = response.organizationId;
        this.name = response.name;
        this.externalId = response.externalId;
        this.readOnly = response.readOnly;
        this.manage = response.manage;
        this.hidePasswords = response.hidePasswords;
    }
    static fromJSON(obj) {
        return Object.assign(new collection_data_CollectionData(new CollectionDetailsResponse({})), obj);
    }
}

;// ../../libs/admin-console/src/common/collections/models/collection.request.ts
class collection_request_CollectionRequest {
    constructor(collection) {
        this.groups = [];
        this.users = [];
        if (collection == null) {
            return;
        }
        this.name = collection.name ? collection.name.encryptedString : null;
        this.externalId = collection.externalId;
    }
}

;// ../../libs/admin-console/src/common/collections/models/collection-with-id.request.ts

class CollectionWithIdRequest extends collection_request_CollectionRequest {
    constructor(collection) {
        if (collection == null) {
            return;
        }
        super(collection);
        this.id = collection.id;
    }
}

;// ../../libs/admin-console/src/common/collections/models/index.ts










;// ../../libs/admin-console/src/common/collections/services/default-collection-admin.service.ts
var default_collection_admin_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class DefaultCollectionAdminService {
    constructor(apiService, keyService, encryptService, collectionService) {
        this.apiService = apiService;
        this.keyService = keyService;
        this.encryptService = encryptService;
        this.collectionService = collectionService;
    }
    getAll(organizationId) {
        return default_collection_admin_service_awaiter(this, void 0, void 0, function* () {
            const collectionResponse = yield this.apiService.getManyCollectionsWithAccessDetails(organizationId);
            if ((collectionResponse === null || collectionResponse === void 0 ? void 0 : collectionResponse.data) == null || collectionResponse.data.length === 0) {
                return [];
            }
            return yield this.decryptMany(organizationId, collectionResponse.data);
        });
    }
    get(organizationId, collectionId) {
        return default_collection_admin_service_awaiter(this, void 0, void 0, function* () {
            const collectionResponse = yield this.apiService.getCollectionAccessDetails(organizationId, collectionId);
            if (collectionResponse == null) {
                return undefined;
            }
            const [view] = yield this.decryptMany(organizationId, [collectionResponse]);
            return view;
        });
    }
    save(collection) {
        return default_collection_admin_service_awaiter(this, void 0, void 0, function* () {
            const request = yield this.encrypt(collection);
            let response;
            if (collection.id == null) {
                response = yield this.apiService.postCollection(collection.organizationId, request);
                collection.id = response.id;
            }
            else {
                response = yield this.apiService.putCollection(collection.organizationId, collection.id, request);
            }
            if (response.assigned) {
                yield this.collectionService.upsert(new CollectionData(response));
            }
            else {
                yield this.collectionService.delete(collection.id);
            }
            return response;
        });
    }
    delete(organizationId, collectionId) {
        return default_collection_admin_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.deleteCollection(organizationId, collectionId);
        });
    }
    bulkAssignAccess(organizationId, collectionIds, users, groups) {
        return default_collection_admin_service_awaiter(this, void 0, void 0, function* () {
            const request = new BulkCollectionAccessRequest();
            request.collectionIds = collectionIds;
            request.users = users.map((u) => new SelectionReadOnlyRequest(u.id, u.readOnly, u.hidePasswords, u.manage));
            request.groups = groups.map((g) => new SelectionReadOnlyRequest(g.id, g.readOnly, g.hidePasswords, g.manage));
            yield this.apiService.send("POST", `/organizations/${organizationId}/collections/bulk-access`, request, true, false);
        });
    }
    decryptMany(organizationId, collections) {
        return default_collection_admin_service_awaiter(this, void 0, void 0, function* () {
            const orgKey = yield this.keyService.getOrgKey(organizationId);
            const promises = collections.map((c) => default_collection_admin_service_awaiter(this, void 0, void 0, function* () {
                const view = new CollectionAdminView();
                view.id = c.id;
                view.name = yield this.encryptService.decryptString(new EncString(c.name), orgKey);
                view.externalId = c.externalId;
                view.organizationId = c.organizationId;
                if (isCollectionAccessDetailsResponse(c)) {
                    view.groups = c.groups;
                    view.users = c.users;
                    view.assigned = c.assigned;
                    view.readOnly = c.readOnly;
                    view.hidePasswords = c.hidePasswords;
                    view.manage = c.manage;
                    view.unmanaged = c.unmanaged;
                }
                return view;
            }));
            return yield Promise.all(promises);
        });
    }
    encrypt(model) {
        return default_collection_admin_service_awaiter(this, void 0, void 0, function* () {
            if (model.organizationId == null) {
                throw new Error("Collection has no organization id.");
            }
            const key = yield this.keyService.getOrgKey(model.organizationId);
            if (key == null) {
                throw new Error("No key for this collection's organization.");
            }
            const collection = new CollectionRequest();
            collection.externalId = model.externalId;
            collection.name = (yield this.encryptService.encryptString(model.name, key)).encryptedString;
            collection.groups = model.groups.map((group) => new SelectionReadOnlyRequest(group.id, group.readOnly, group.hidePasswords, group.manage));
            collection.users = model.users.map((user) => new SelectionReadOnlyRequest(user.id, user.readOnly, user.hidePasswords, user.manage));
            return collection;
        });
    }
}
function isCollectionAccessDetailsResponse(response) {
    const anyResponse = response;
    return (anyResponse === null || anyResponse === void 0 ? void 0 : anyResponse.groups) instanceof Array && (anyResponse === null || anyResponse === void 0 ? void 0 : anyResponse.users) instanceof Array;
}

;// ../../libs/common/src/platform/state/derive-definition.ts
/**
 * DeriveDefinitions describe state derived from another observable, the value type of which is given by `TFrom`.
 *
 * The StateDefinition is used to describe the domain of the state, and the DeriveDefinition
 * sub-divides that domain into specific keys. These keys are used to cache data in memory and enables derived state to
 * be calculated once regardless of multiple execution contexts.
 */
class DeriveDefinition {
    /**
     * Creates a new instance of a DeriveDefinition. Derived state is always stored in memory, so the storage location
     * defined in @link{StateDefinition} is ignored.
     *
     * @param stateDefinition The state definition for which this key belongs to.
     * @param uniqueDerivationName The name of the key, this should be unique per domain.
     * @param options A set of options to customize the behavior of {@link DeriveDefinition}.
     * @param options.derive A function to use to convert values from TFrom to TTo. This is called on each emit of the parent state observable
     * and the resulting value will be emitted from the derived state observable.
     * @param options.cleanupDelayMs The number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     * Defaults to 1000ms.
     * @param options.dependencyShape An object defining the dependencies of the derive function. The keys of the object are the names of the dependencies
     * and the values are the types of the dependencies.
     * for example:
     * ```
     * {
     *   myService: MyService,
     *   myOtherService: MyOtherService,
     * }
     * ```
     *
     * @param options.deserializer A function to use to safely convert your type from json to your expected type.
     *   Your data may be serialized/deserialized at any time and this needs callback needs to be able to faithfully re-initialize
     *   from the JSON object representation of your type.
     */
    constructor(stateDefinition, uniqueDerivationName, options) {
        this.stateDefinition = stateDefinition;
        this.uniqueDerivationName = uniqueDerivationName;
        this.options = options;
    }
    /**
     * Factory that produces a {@link DeriveDefinition} from a {@link KeyDefinition} or {@link DeriveDefinition} and new name.
     *
     * If a `KeyDefinition` is passed in, the returned definition will have the same key as the given key definition, but
     * will not collide with it in storage, even if they both reside in memory.
     *
     * If a `DeriveDefinition` is passed in, the returned definition will instead use the name given in the second position
     * of the tuple. It is up to you to ensure this is unique within the domain of derived state.
     *
     * @param options A set of options to customize the behavior of {@link DeriveDefinition}.
     * @param options.derive A function to use to convert values from TFrom to TTo. This is called on each emit of the parent state observable
     * and the resulting value will be emitted from the derived state observable.
     * @param options.cleanupDelayMs The number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     * Defaults to 1000ms.
     * @param options.dependencyShape An object defining the dependencies of the derive function. The keys of the object are the names of the dependencies
     * and the values are the types of the dependencies.
     * for example:
     * ```
     * {
     *   myService: MyService,
     *   myOtherService: MyOtherService,
     * }
     * ```
     *
     * @param options.deserializer A function to use to safely convert your type from json to your expected type.
     *   Your data may be serialized/deserialized at any time and this needs callback needs to be able to faithfully re-initialize
     *   from the JSON object representation of your type.
     * @param definition
     * @param options
     * @returns
     */
    static from(definition, options) {
        if (isFromDeriveDefinition(definition)) {
            return new DeriveDefinition(definition[0].stateDefinition, definition[1], options);
        }
        else {
            return new DeriveDefinition(definition.stateDefinition, definition.key, options);
        }
    }
    static fromWithUserId(definition, options) {
        if (isFromDeriveDefinition(definition)) {
            return new DeriveDefinition(definition[0].stateDefinition, definition[1], options);
        }
        else {
            return new DeriveDefinition(definition.stateDefinition, definition.key, options);
        }
    }
    get derive() {
        return this.options.derive;
    }
    deserialize(serialized) {
        return this.options.deserializer(serialized);
    }
    get cleanupDelayMs() {
        var _a;
        return this.options.cleanupDelayMs < 0 ? 0 : ((_a = this.options.cleanupDelayMs) !== null && _a !== void 0 ? _a : 1000);
    }
    get clearOnCleanup() {
        var _a;
        return (_a = this.options.clearOnCleanup) !== null && _a !== void 0 ? _a : true;
    }
    buildCacheKey() {
        return `derived_${this.stateDefinition.name}_${this.uniqueDerivationName}`;
    }
    /**
     * Creates a {@link StorageKey} that points to the data for the given derived definition.
     * @returns A key that is ready to be used in a storage service to get data.
     */
    get storageKey() {
        return `derived_${this.stateDefinition.name}_${this.uniqueDerivationName}`;
    }
}
function isFromDeriveDefinition(definition) {
    return Array.isArray(definition);
}

;// ../../libs/common/src/platform/state/deserialization-helpers.ts
/**
 *
 * @param elementDeserializer
 * @returns
 */
function array(elementDeserializer) {
    return (array) => {
        if (array == null) {
            return null;
        }
        return array.map((element) => elementDeserializer(element));
    };
}
/**
 *
 * @param valueDeserializer
 */
function record(valueDeserializer) {
    return (jsonValue) => {
        if (jsonValue == null) {
            return null;
        }
        const output = {};
        Object.entries(jsonValue).forEach(([key, value]) => {
            output[key] = valueDeserializer(value);
        });
        return output;
    };
}

;// ../../libs/common/src/platform/state/key-definition.ts

/**
 * KeyDefinitions describe the precise location to store data for a given piece of state.
 * The StateDefinition is used to describe the domain of the state, and the KeyDefinition
 * sub-divides that domain into specific keys.
 */
class KeyDefinition {
    /**
     * Creates a new instance of a KeyDefinition
     * @param stateDefinition The state definition for which this key belongs to.
     * @param key The name of the key, this should be unique per domain.
     * @param options A set of options to customize the behavior of {@link KeyDefinition}. All options are required.
     * @param options.deserializer A function to use to safely convert your type from json to your expected type.
     *   Your data may be serialized/deserialized at any time and this needs callback needs to be able to faithfully re-initialize
     *   from the JSON object representation of your type.
     */
    constructor(stateDefinition, key, options) {
        var _a;
        this.stateDefinition = stateDefinition;
        this.key = key;
        this.options = options;
        if (options.deserializer == null) {
            throw new Error(`'deserializer' is a required property on key ${this.errorKeyName}`);
        }
        if (options.cleanupDelayMs < 0) {
            throw new Error(`'cleanupDelayMs' must be greater than or equal to 0. Value of ${options.cleanupDelayMs} passed to key ${this.errorKeyName} `);
        }
        // Normalize optional debug options
        const { enableUpdateLogging = false, enableRetrievalLogging = false } = (_a = options.debug) !== null && _a !== void 0 ? _a : {};
        this.debug = {
            enableUpdateLogging,
            enableRetrievalLogging,
        };
    }
    /**
     * Gets the deserializer configured for this {@link KeyDefinition}
     */
    get deserializer() {
        return this.options.deserializer;
    }
    /**
     * Gets the number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     */
    get cleanupDelayMs() {
        var _a;
        return this.options.cleanupDelayMs < 0 ? 0 : ((_a = this.options.cleanupDelayMs) !== null && _a !== void 0 ? _a : 1000);
    }
    /**
     * Creates a {@link KeyDefinition} for state that is an array.
     * @param stateDefinition The state definition to be added to the KeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link KeyDefinition}.
     * @returns A {@link KeyDefinition} initialized for arrays, the options run
     * the deserializer on the provided options for each element of an array.
     *
     * @example
     * ```typescript
     * const MY_KEY = KeyDefinition.array<MyArrayElement>(MY_STATE, "key", {
     *   deserializer: (myJsonElement) => convertToElement(myJsonElement),
     * });
     * ```
     */
    static array(stateDefinition, key, 
    // We have them provide options for the element of the array, depending on future options we add, this could get a little weird.
    options) {
        return new KeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: array((e) => options.deserializer(e)) }));
    }
    /**
     * Creates a {@link KeyDefinition} for state that is a record.
     * @param stateDefinition The state definition to be added to the KeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link KeyDefinition}.
     * @returns A {@link KeyDefinition} that contains a serializer that will run the provided deserializer for each
     * value in a record and returns every key as a string.
     *
     * @example
     * ```typescript
     * const MY_KEY = KeyDefinition.record<MyRecordValue>(MY_STATE, "key", {
     *   deserializer: (myJsonValue) => convertToValue(myJsonValue),
     * });
     * ```
     */
    static record(stateDefinition, key, 
    // We have them provide options for the value of the record, depending on future options we add, this could get a little weird.
    options) {
        return new KeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: record((v) => options.deserializer(v)) }));
    }
    get fullName() {
        return `${this.stateDefinition.name}_${this.key}`;
    }
    get errorKeyName() {
        return `${this.stateDefinition.name} > ${this.key}`;
    }
}
/**
 * Creates a {@link StorageKey}
 * @param keyDefinition The key definition of which data the key should point to.
 * @returns A key that is ready to be used in a storage service to get data.
 */
function globalKeyBuilder(keyDefinition) {
    return `global_${keyDefinition.stateDefinition.name}_${keyDefinition.key}`;
}

;// ../../libs/common/src/platform/state/user-key-definition.ts
var _a;


const USER_KEY_DEFINITION_MARKER = Symbol("UserKeyDefinition");
class UserKeyDefinition {
    constructor(stateDefinition, key, options) {
        var _b;
        this.stateDefinition = stateDefinition;
        this.key = key;
        this.options = options;
        this[_a] = true;
        if (options.deserializer == null) {
            throw new Error(`'deserializer' is a required property on key ${this.errorKeyName}`);
        }
        if (options.cleanupDelayMs < 0) {
            throw new Error(`'cleanupDelayMs' must be greater than or equal to 0. Value of ${options.cleanupDelayMs} passed to key ${this.errorKeyName} `);
        }
        // Filter out repeat values
        this.clearOn = Array.from(new Set(options.clearOn));
        // Normalize optional debug options
        const { enableUpdateLogging = false, enableRetrievalLogging = false } = (_b = options.debug) !== null && _b !== void 0 ? _b : {};
        this.debug = {
            enableUpdateLogging,
            enableRetrievalLogging,
        };
    }
    /**
     * Gets the deserializer configured for this {@link KeyDefinition}
     */
    get deserializer() {
        return this.options.deserializer;
    }
    /**
     * Gets the number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     */
    get cleanupDelayMs() {
        var _b;
        return this.options.cleanupDelayMs < 0 ? 0 : ((_b = this.options.cleanupDelayMs) !== null && _b !== void 0 ? _b : 1000);
    }
    /**
     * Creates a {@link UserKeyDefinition} for state that is an array.
     * @param stateDefinition The state definition to be added to the UserKeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link UserKeyDefinition}.
     * @returns A {@link UserKeyDefinition} initialized for arrays, the options run
     * the deserializer on the provided options for each element of an array
     * **unless that array is null, in which case it will return an empty list.**
     *
     * @example
     * ```typescript
     * const MY_KEY = UserKeyDefinition.array<MyArrayElement>(MY_STATE, "key", {
     *   deserializer: (myJsonElement) => convertToElement(myJsonElement),
     * });
     * ```
     */
    static array(stateDefinition, key, 
    // We have them provide options for the element of the array, depending on future options we add, this could get a little weird.
    options) {
        return new UserKeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: array((e) => options.deserializer(e)) }));
    }
    /**
     * Creates a {@link UserKeyDefinition} for state that is a record.
     * @param stateDefinition The state definition to be added to the UserKeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link UserKeyDefinition}.
     * @returns A {@link UserKeyDefinition} that contains a serializer that will run the provided deserializer for each
     * value in a record and returns every key as a string **unless that record is null, in which case it will return an record.**
     *
     * @example
     * ```typescript
     * const MY_KEY = UserKeyDefinition.record<MyRecordValue>(MY_STATE, "key", {
     *   deserializer: (myJsonValue) => convertToValue(myJsonValue),
     * });
     * ```
     */
    static record(stateDefinition, key, 
    // We have them provide options for the value of the record, depending on future options we add, this could get a little weird.
    options) {
        return new UserKeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: record((v) => options.deserializer(v)) }));
    }
    get fullName() {
        return `${this.stateDefinition.name}_${this.key}`;
    }
    buildKey(userId) {
        if (!utils_Utils.isGuid(userId)) {
            throw new Error(`You cannot build a user key without a valid UserId, building for key ${this.fullName}`);
        }
        return `user_${userId}_${this.stateDefinition.name}_${this.key}`;
    }
    get errorKeyName() {
        return `${this.stateDefinition.name} > ${this.key}`;
    }
}
_a = USER_KEY_DEFINITION_MARKER;

;// ../../libs/common/src/platform/state/state-definition.ts
/**
 * Defines the base location and instruction of where this state is expected to be located.
 */
class StateDefinition {
    /**
     * Creates a new instance of {@link StateDefinition}, the creation of which is owned by the platform team.
     * @param name The name of the state, this needs to be unique from all other {@link StateDefinition}'s.
     * @param defaultStorageLocation The location of where this state should be stored.
     */
    constructor(name, defaultStorageLocation, storageLocationOverrides) {
        this.name = name;
        this.defaultStorageLocation = defaultStorageLocation;
        this.storageLocationOverrides = storageLocationOverrides !== null && storageLocationOverrides !== void 0 ? storageLocationOverrides : {};
    }
}

;// ../../libs/common/src/platform/state/state-definitions.ts

/**
 * `StateDefinition`s comes with some rules, to facilitate a quick review from
 * platform of this file, ensure you follow these rules, the ones marked with (tested)
 * have unit tests that you can run locally.
 *
 * 1. (tested) Names should not be null or undefined
 * 2. (tested) Name and storage location should be unique
 * 3. (tested) Name and storage location can't differ from another export by only casing
 * 4. (tested) Name should be longer than 3 characters. It should be descriptive, but brief.
 * 5. (tested) Name should not contain spaces or underscores
 * 6. Name should be human readable
 * 7. Name should be in camelCase format (unit tests ensure the first character is lowercase)
 * 8. Teams should only use state definitions they have created
 * 9. StateDefinitions should only be used for keys relating to the state name they chose
 *
 */
// Admin Console
const ORGANIZATIONS_DISK = new StateDefinition("organizations", "disk");
const POLICIES_DISK = new StateDefinition("policies", "disk");
const PROVIDERS_DISK = new StateDefinition("providers", "disk");
const ORGANIZATION_MANAGEMENT_PREFERENCES_DISK = new StateDefinition("organizationManagementPreferences", "disk", {
    web: "disk-local",
});
const ACCOUNT_DEPROVISIONING_BANNER_DISK = new StateDefinition("showAccountDeprovisioningBanner", "disk", {
    web: "disk-local",
});
const DELETE_MANAGED_USER_WARNING = new StateDefinition("showDeleteManagedUserWarning", "disk", {
    web: "disk-local",
});
// Billing
const BILLING_DISK = new StateDefinition("billing", "disk");
// Auth
const ACCOUNT_DISK = new StateDefinition("account", "disk");
const ACCOUNT_MEMORY = new StateDefinition("account", "memory");
const AUTH_REQUEST_DISK_LOCAL = new StateDefinition("authRequestLocal", "disk", {
    web: "disk-local",
});
const AVATAR_DISK = new StateDefinition("avatar", "disk", { web: "disk-local" });
const DEVICE_TRUST_DISK_LOCAL = new StateDefinition("deviceTrust", "disk", {
    web: "disk-local",
    browser: "disk-backup-local-storage",
});
const KDF_CONFIG_DISK = new StateDefinition("kdfConfig", "disk");
const KEY_CONNECTOR_DISK = new StateDefinition("keyConnector", "disk");
const LOGIN_EMAIL_DISK = new StateDefinition("loginEmail", "disk", {
    web: "disk-local",
});
const LOGIN_EMAIL_MEMORY = new StateDefinition("loginEmail", "memory");
const LOGIN_STRATEGY_MEMORY = new StateDefinition("loginStrategy", "memory");
const MASTER_PASSWORD_DISK = new StateDefinition("masterPassword", "disk");
const MASTER_PASSWORD_MEMORY = new StateDefinition("masterPassword", "memory");
const PIN_DISK = new StateDefinition("pinUnlock", "disk");
const PIN_MEMORY = new StateDefinition("pinUnlock", "memory");
const ROUTER_DISK = new StateDefinition("router", "disk");
const SSO_DISK = new StateDefinition("ssoLogin", "disk");
const TOKEN_DISK = new StateDefinition("token", "disk");
const TOKEN_DISK_LOCAL = new StateDefinition("tokenDiskLocal", "disk", {
    web: "disk-local",
});
const TOKEN_MEMORY = new StateDefinition("token", "memory");
const TWO_FACTOR_MEMORY = new StateDefinition("twoFactor", "memory");
const USER_DECRYPTION_OPTIONS_DISK = new StateDefinition("userDecryptionOptions", "disk");
const ORGANIZATION_INVITE_DISK = new StateDefinition("organizationInvite", "disk");
const VAULT_TIMEOUT_SETTINGS_DISK_LOCAL = new StateDefinition("vaultTimeoutSettings", "disk", {
    web: "disk-local",
});
// Autofill
const BADGE_SETTINGS_DISK = new StateDefinition("badgeSettings", "disk");
const USER_NOTIFICATION_SETTINGS_DISK = new StateDefinition("userNotificationSettings", "disk");
const DOMAIN_SETTINGS_DISK = new StateDefinition("domainSettings", "disk");
const AUTOFILL_SETTINGS_DISK = new StateDefinition("autofillSettings", "disk");
const AUTOFILL_SETTINGS_DISK_LOCAL = new StateDefinition("autofillSettingsLocal", "disk", {
    web: "disk-local",
});
// Components
const NEW_WEB_LAYOUT_BANNER_DISK = new StateDefinition("newWebLayoutBanner", "disk", {
    web: "disk-local",
});
// Platform
const APPLICATION_ID_DISK = new StateDefinition("applicationId", "disk", {
    web: "disk-local",
});
const BIOMETRIC_SETTINGS_DISK = new StateDefinition("biometricSettings", "disk");
const CLEAR_EVENT_DISK = new StateDefinition("clearEvent", "disk");
const CONFIG_DISK = new StateDefinition("config", "disk", {
    web: "disk-local",
});
const CRYPTO_DISK = new StateDefinition("crypto", "disk");
const CRYPTO_MEMORY = new StateDefinition("crypto", "memory");
const DESKTOP_SETTINGS_DISK = new StateDefinition("desktopSettings", "disk");
const ENVIRONMENT_DISK = new StateDefinition("environment", "disk");
const ENVIRONMENT_MEMORY = new StateDefinition("environment", "memory");
const POPUP_VIEW_MEMORY = new StateDefinition("popupView", "memory", {
    browser: "memory-large-object",
});
const SYNC_DISK = new StateDefinition("sync", "disk", { web: "memory" });
const THEMING_DISK = new StateDefinition("theming", "disk", { web: "disk-local" });
const TRANSLATION_DISK = new StateDefinition("translation", "disk", { web: "disk-local" });
const ANIMATION_DISK = new StateDefinition("animation", "disk");
const TASK_SCHEDULER_DISK = new StateDefinition("taskScheduler", "disk");
const EXTENSION_INITIAL_INSTALL_DISK = new StateDefinition("extensionInitialInstall", "disk");
// Design System
const POPUP_STYLE_DISK = new StateDefinition("popupStyle", "disk");
// Secrets Manager
const SM_ONBOARDING_DISK = new StateDefinition("smOnboarding", "disk", {
    web: "disk-local",
});
// Tools
const EXTENSION_DISK = new StateDefinition("extension", "disk");
const GENERATOR_DISK = new StateDefinition("generator", "disk");
const GENERATOR_MEMORY = new StateDefinition("generator", "memory");
const BROWSER_SEND_MEMORY = new StateDefinition("sendBrowser", "memory");
const EVENT_COLLECTION_DISK = new StateDefinition("eventCollection", "disk");
const SEND_DISK = new StateDefinition("encryptedSend", "disk", {
    web: "memory",
});
const SEND_MEMORY = new StateDefinition("decryptedSend", "memory", {
    browser: "memory-large-object",
});
// Vault
const COLLECTION_DATA = new StateDefinition("collection", "disk", {
    web: "memory",
});
const FOLDER_DISK = new StateDefinition("folder", "disk", { web: "memory" });
const FOLDER_MEMORY = new StateDefinition("decryptedFolders", "memory", {
    browser: "memory-large-object",
});
const VAULT_FILTER_DISK = new StateDefinition("vaultFilter", "disk", {
    web: "disk-local",
});
const VAULT_ONBOARDING = new StateDefinition("vaultOnboarding", "disk", {
    web: "disk-local",
});
const VAULT_SETTINGS_DISK = new StateDefinition("vaultSettings", "disk", {
    web: "disk-local",
});
const VAULT_BROWSER_MEMORY = new StateDefinition("vaultBrowser", "memory", {
    browser: "memory-large-object",
});
const VAULT_SEARCH_MEMORY = new StateDefinition("vaultSearch", "memory", {
    browser: "memory-large-object",
});
const CIPHERS_DISK = new StateDefinition("ciphers", "disk", { web: "memory" });
const CIPHERS_DISK_LOCAL = new StateDefinition("ciphersLocal", "disk", {
    web: "disk-local",
});
const CIPHERS_MEMORY = new StateDefinition("ciphersMemory", "memory", {
    browser: "memory-large-object",
});
const PREMIUM_BANNER_DISK_LOCAL = new StateDefinition("premiumBannerReprompt", "disk", {
    web: "disk-local",
});
const BANNERS_DISMISSED_DISK = new StateDefinition("bannersDismissed", "disk");
const VAULT_APPEARANCE = new StateDefinition("vaultAppearance", "disk");
const SECURITY_TASKS_DISK = new StateDefinition("securityTasks", "disk");
const AT_RISK_PASSWORDS_PAGE_DISK = new StateDefinition("atRiskPasswordsPage", "disk");
const NOTIFICATION_DISK = new StateDefinition("notifications", "disk");
const NUDGES_DISK = new StateDefinition("nudges", "disk", { web: "disk-local" });
const VAULT_BROWSER_INTRO_CAROUSEL = new StateDefinition("vaultBrowserIntroCarousel", "disk");

;// ../../libs/common/src/platform/state/state-event-registrar.service.ts
var state_event_registrar_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const STATE_LOCK_EVENT = KeyDefinition.array(CLEAR_EVENT_DISK, "lock", {
    deserializer: (e) => e,
});
const STATE_LOGOUT_EVENT = KeyDefinition.array(CLEAR_EVENT_DISK, "logout", {
    deserializer: (e) => e,
});
class StateEventRegistrarService {
    constructor(globalStateProvider, storageServiceProvider) {
        this.storageServiceProvider = storageServiceProvider;
        this.stateEventStateMap = {
            lock: globalStateProvider.get(STATE_LOCK_EVENT),
            logout: globalStateProvider.get(STATE_LOGOUT_EVENT),
        };
    }
    registerEvents(keyDefinition) {
        return state_event_registrar_service_awaiter(this, void 0, void 0, function* () {
            for (const clearEvent of keyDefinition.clearOn) {
                const eventState = this.stateEventStateMap[clearEvent];
                // Determine the storage location for this
                const [storageLocation] = this.storageServiceProvider.get(keyDefinition.stateDefinition.defaultStorageLocation, keyDefinition.stateDefinition.storageLocationOverrides);
                const newEvent = {
                    state: keyDefinition.stateDefinition.name,
                    key: keyDefinition.key,
                    location: storageLocation,
                };
                // Only update the event state if the existing list doesn't have a matching entry
                yield eventState.update((existingTickets) => {
                    existingTickets !== null && existingTickets !== void 0 ? existingTickets : (existingTickets = []);
                    existingTickets.push(newEvent);
                    return existingTickets;
                }, {
                    shouldUpdate: (currentTickets) => {
                        return (
                        // If the current tickets are null, then it will for sure be added
                        currentTickets == null ||
                            // If an existing match couldn't be found, we also need to add one
                            currentTickets.findIndex((e) => e.state === newEvent.state &&
                                e.key === newEvent.key &&
                                e.location === newEvent.location) === -1);
                    },
                });
            }
        });
    }
}

;// ../../libs/common/src/platform/state/state-event-runner.service.ts
var state_event_runner_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore




class StateEventRunnerService {
    constructor(globalStateProvider, storageServiceProvider) {
        this.storageServiceProvider = storageServiceProvider;
        this.stateEventMap = {
            lock: globalStateProvider.get(STATE_LOCK_EVENT),
            logout: globalStateProvider.get(STATE_LOGOUT_EVENT),
        };
    }
    handleEvent(event, userId) {
        return state_event_runner_service_awaiter(this, void 0, void 0, function* () {
            let tickets = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateEventMap[event].state$);
            tickets !== null && tickets !== void 0 ? tickets : (tickets = []);
            const failures = [];
            for (const ticket of tickets) {
                try {
                    const [, service] = this.storageServiceProvider.get(ticket.location, {});
                    const ticketStorageKey = this.storageKeyFor(userId, ticket);
                    // Evaluate current value so we can avoid writing to state if we don't need to
                    const currentValue = yield service.get(ticketStorageKey);
                    if (currentValue != null) {
                        yield service.remove(ticketStorageKey);
                    }
                }
                catch (err) {
                    let errorMessage = "Unknown Error";
                    if (typeof err === "object" && "message" in err && typeof err.message === "string") {
                        errorMessage = err.message;
                    }
                    failures.push(`${errorMessage} in ${ticket.state} > ${ticket.key} located ${ticket.location}`);
                }
            }
            if (failures.length > 0) {
                // Throw aggregated error
                throw new Error(`One or more errors occurred while handling event '${event}' for user ${userId}.\n${failures.join("\n")}`);
            }
        });
    }
    storageKeyFor(userId, ticket) {
        const userKey = new UserKeyDefinition(new StateDefinition(ticket.state, ticket.location), ticket.key, {
            deserializer: (v) => v,
            clearOn: [],
        });
        return userKey.buildKey(userId);
    }
}

;// ../../libs/common/src/platform/state/index.ts










;// ../../libs/common/src/vault/models/domain/tree-node.ts
class TreeNode {
    constructor(node, parent, name, id) {
        this.children = [];
        this.parent = parent;
        this.node = node;
        if (name) {
            this.node.name = name;
        }
        if (id) {
            this.node.id = id;
        }
    }
}

;// ../../libs/common/src/vault/service-utils.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

class ServiceUtils {
    /**
     * Recursively adds a node to nodeTree
     * @param {TreeNode<ITreeNodeObject>[]} nodeTree - An array of TreeNodes that the node will be added to
     * @param {number} partIndex - Index of the `parts` array that is being processed
     * @param {string[]} parts - Array of strings that represent the path to the `obj` node
     * @param {ITreeNodeObject} obj - The node to be added to the tree
     * @param {ITreeNodeObject} parent - The parent node of the `obj` node
     * @param {string} delimiter - The delimiter used to split the path string, will be used to combine the path for missing nodes
     */
    static nestedTraverse(nodeTree, partIndex, parts, obj, parent, delimiter) {
        if (parts.length <= partIndex) {
            return;
        }
        const end = partIndex === parts.length - 1;
        const partName = parts[partIndex];
        for (let i = 0; i < nodeTree.length; i++) {
            if (nodeTree[i].node.name !== partName) {
                continue;
            }
            if (end && nodeTree[i].node.id !== obj.id) {
                // Another node exists with the same name as the node being added
                nodeTree.push(new TreeNode(obj, parent, partName));
                return;
            }
            // Move down the tree to the next level
            ServiceUtils.nestedTraverse(nodeTree[i].children, partIndex + 1, parts, obj, nodeTree[i], delimiter);
            return;
        }
        // If there's no node here with the same name...
        if (nodeTree.filter((n) => n.node.name === partName).length === 0) {
            // And we're at the end of the path given, add the node
            if (end) {
                nodeTree.push(new TreeNode(obj, parent, partName));
                return;
            }
            // And we're not at the end of the path, combine the current name with the next name
            // 1, *1.2, 1.2.1 becomes
            // 1, *1.2/1.2.1
            const newPartName = partName + delimiter + parts[partIndex + 1];
            ServiceUtils.nestedTraverse(nodeTree, 0, [newPartName, ...parts.slice(partIndex + 2)], obj, parent, delimiter);
        }
    }
    /**
     * Searches a tree for a node with a matching `id`
     * @param {TreeNode<T>} nodeTree - A single TreeNode branch that will be searched
     * @param {string} id - The id of the node to be found
     * @returns {TreeNode<T>} The node with a matching `id`
     */
    static getTreeNodeObject(nodeTree, id) {
        if (nodeTree.node.id === id) {
            return nodeTree;
        }
        for (let i = 0; i < nodeTree.children.length; i++) {
            if (nodeTree.children[i].children != null) {
                const node = ServiceUtils.getTreeNodeObject(nodeTree.children[i], id);
                if (node !== null) {
                    return node;
                }
            }
        }
        return null;
    }
    /**
     * Searches an array of tree nodes for a node with a matching `id`
     * @param {TreeNode<T>} nodeTree - An array of TreeNode branches that will be searched
     * @param {string} id - The id of the node to be found
     * @returns {TreeNode<T>} The node with a matching `id`
     */
    static getTreeNodeObjectFromList(nodeTree, id) {
        for (let i = 0; i < nodeTree.length; i++) {
            if (nodeTree[i].node.id === id) {
                return nodeTree[i];
            }
            else if (nodeTree[i].children != null) {
                const node = ServiceUtils.getTreeNodeObjectFromList(nodeTree[i].children, id);
                if (node !== null) {
                    return node;
                }
            }
        }
        return null;
    }
}

;// ../../libs/admin-console/src/common/collections/services/default-collection.service.ts
var default_collection_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore





const ENCRYPTED_COLLECTION_DATA_KEY = UserKeyDefinition.record(COLLECTION_DATA, "collections", {
    deserializer: (jsonData) => collection_data_CollectionData.fromJSON(jsonData),
    clearOn: ["logout"],
});
const DECRYPTED_COLLECTION_DATA_KEY = new DeriveDefinition(COLLECTION_DATA, "decryptedCollections", {
    deserializer: (obj) => obj.map((collection) => CollectionView.fromJSON(collection)),
    derive: (_a, _b) => default_collection_service_awaiter(void 0, [_a, _b], void 0, function* ([collections, orgKeys], { collectionService }) {
        if (collections == null) {
            return [];
        }
        const data = Object.values(collections).map((c) => new Collection(c));
        return yield collectionService.decryptMany(data, orgKeys);
    }),
});
const default_collection_service_NestingDelimiter = "/";
class DefaultCollectionService {
    decryptedCollectionViews$(ids) {
        return this.decryptedCollections$.pipe((0,external_rxjs_namespaceObject.map)((collections) => collections.filter((c) => ids.includes(c.id))));
    }
    constructor(keyService, encryptService, i18nService, stateProvider) {
        this.keyService = keyService;
        this.encryptService = encryptService;
        this.i18nService = i18nService;
        this.stateProvider = stateProvider;
        this.encryptedCollectionDataState = this.stateProvider.getActive(ENCRYPTED_COLLECTION_DATA_KEY);
        this.encryptedCollections$ = this.encryptedCollectionDataState.state$.pipe((0,external_rxjs_namespaceObject.map)((collections) => {
            if (collections == null) {
                return [];
            }
            return Object.values(collections).map((c) => new Collection(c));
        }));
        const encryptedCollectionsWithKeys = this.encryptedCollectionDataState.combinedState$.pipe((0,external_rxjs_namespaceObject.switchMap)(([userId, collectionData]) => (0,external_rxjs_namespaceObject.combineLatest)([(0,external_rxjs_namespaceObject.of)(collectionData), this.keyService.orgKeys$(userId)])), (0,external_rxjs_namespaceObject.shareReplay)({ refCount: false, bufferSize: 1 }));
        this.decryptedCollectionDataState = this.stateProvider.getDerived(encryptedCollectionsWithKeys, DECRYPTED_COLLECTION_DATA_KEY, { collectionService: this });
        this.decryptedCollections$ = this.decryptedCollectionDataState.state$;
    }
    clearActiveUserCache() {
        return default_collection_service_awaiter(this, void 0, void 0, function* () {
            yield this.decryptedCollectionDataState.forceValue(null);
        });
    }
    encrypt(model) {
        return default_collection_service_awaiter(this, void 0, void 0, function* () {
            if (model.organizationId == null) {
                throw new Error("Collection has no organization id.");
            }
            const key = yield this.keyService.getOrgKey(model.organizationId);
            if (key == null) {
                throw new Error("No key for this collection's organization.");
            }
            const collection = new Collection();
            collection.id = model.id;
            collection.organizationId = model.organizationId;
            collection.readOnly = model.readOnly;
            collection.externalId = model.externalId;
            collection.name = yield this.encryptService.encryptString(model.name, key);
            return collection;
        });
    }
    // TODO: this should be private and orgKeys should be required.
    // See https://bitwarden.atlassian.net/browse/PM-12375
    decryptMany(collections, orgKeys) {
        return default_collection_service_awaiter(this, void 0, void 0, function* () {
            if (collections == null || collections.length === 0) {
                return [];
            }
            const decCollections = [];
            orgKeys !== null && orgKeys !== void 0 ? orgKeys : (orgKeys = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.keyService.activeUserOrgKeys$));
            const promises = [];
            collections.forEach((collection) => {
                promises.push(collection
                    .decrypt(orgKeys[collection.organizationId])
                    .then((c) => decCollections.push(c)));
            });
            yield Promise.all(promises);
            return decCollections.sort(utils_Utils.getSortFunction(this.i18nService, "name"));
        });
    }
    get(id) {
        return default_collection_service_awaiter(this, void 0, void 0, function* () {
            var _a;
            return ((_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.encryptedCollections$.pipe((0,external_rxjs_namespaceObject.map)((cs) => cs.find((c) => c.id === id)))))) !== null && _a !== void 0 ? _a : null);
        });
    }
    getAll() {
        return default_collection_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.encryptedCollections$);
        });
    }
    getAllDecrypted() {
        return default_collection_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.decryptedCollections$);
        });
    }
    getAllNested() {
        return default_collection_service_awaiter(this, arguments, void 0, function* (collections = null) {
            if (collections == null) {
                collections = yield this.getAllDecrypted();
            }
            const nodes = [];
            collections.forEach((c) => {
                const collectionCopy = new CollectionView();
                collectionCopy.id = c.id;
                collectionCopy.organizationId = c.organizationId;
                const parts = c.name != null ? c.name.replace(/^\/+|\/+$/g, "").split(default_collection_service_NestingDelimiter) : [];
                ServiceUtils.nestedTraverse(nodes, 0, parts, collectionCopy, null, default_collection_service_NestingDelimiter);
            });
            return nodes;
        });
    }
    /**
     * @deprecated August 30 2022: Moved to new Vault Filter Service
     * Remove when Desktop and Browser are updated
     */
    getNested(id) {
        return default_collection_service_awaiter(this, void 0, void 0, function* () {
            const collections = yield this.getAllNested();
            return ServiceUtils.getTreeNodeObjectFromList(collections, id);
        });
    }
    upsert(toUpdate) {
        return default_collection_service_awaiter(this, void 0, void 0, function* () {
            if (toUpdate == null) {
                return;
            }
            yield this.encryptedCollectionDataState.update((collections) => {
                if (collections == null) {
                    collections = {};
                }
                if (Array.isArray(toUpdate)) {
                    toUpdate.forEach((c) => {
                        collections[c.id] = c;
                    });
                }
                else {
                    collections[toUpdate.id] = toUpdate;
                }
                return collections;
            });
        });
    }
    replace(collections, userId) {
        return default_collection_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateProvider
                .getUser(userId, ENCRYPTED_COLLECTION_DATA_KEY)
                .update(() => collections);
        });
    }
    clear(userId) {
        return default_collection_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                yield this.encryptedCollectionDataState.update(() => null);
                yield this.decryptedCollectionDataState.forceValue(null);
            }
            else {
                yield this.stateProvider.getUser(userId, ENCRYPTED_COLLECTION_DATA_KEY).update(() => null);
            }
        });
    }
    delete(id) {
        return default_collection_service_awaiter(this, void 0, void 0, function* () {
            yield this.encryptedCollectionDataState.update((collections) => {
                if (collections == null) {
                    collections = {};
                }
                if (typeof id === "string") {
                    delete collections[id];
                }
                else {
                    id.forEach((i) => {
                        delete collections[i];
                    });
                }
                return collections;
            });
        });
    }
}

;// ../../libs/admin-console/src/common/collections/services/index.ts



;// ../../libs/admin-console/src/common/collections/index.ts




;// ../../libs/admin-console/src/common/index.ts



;// ../../libs/common/src/models/response/error.response.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

class ErrorResponse extends BaseResponse {
    constructor(response, status, identityResponse) {
        super(response);
        let errorModel = null;
        if (response != null) {
            const responseErrorModel = this.getResponseProperty("ErrorModel");
            if (responseErrorModel && identityResponse) {
                errorModel = responseErrorModel;
            }
            else {
                errorModel = response;
            }
        }
        if (status === 429) {
            this.message = "Rate limit exceeded. Try again later.";
        }
        else if (errorModel) {
            this.message = this.getResponseProperty("Message", errorModel);
            this.validationErrors = this.getResponseProperty("ValidationErrors", errorModel);
        }
        this.statusCode = status;
    }
    getSingleMessage() {
        if (this.validationErrors == null) {
            return this.message;
        }
        for (const key in this.validationErrors) {
            // eslint-disable-next-line
            if (!this.validationErrors.hasOwnProperty(key)) {
                continue;
            }
            if (this.validationErrors[key].length) {
                return this.validationErrors[key][0];
            }
        }
        return this.message;
    }
    getAllMessages() {
        const messages = [];
        if (this.validationErrors == null) {
            return messages;
        }
        for (const key in this.validationErrors) {
            // eslint-disable-next-line
            if (!this.validationErrors.hasOwnProperty(key)) {
                continue;
            }
            this.validationErrors[key].forEach((item) => {
                let prefix = "";
                if (key.indexOf("[") > -1 && key.indexOf("]") > -1) {
                    const lastSep = key.lastIndexOf(".");
                    prefix = key.substr(0, lastSep > -1 ? lastSep : key.length) + ": ";
                }
                messages.push(prefix + item);
            });
        }
        return messages;
    }
}

;// ./src/models/response.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

function getErrorMessage(error) {
    if (typeof error === "string") {
        return error;
    }
    if (error instanceof ErrorResponse) {
        const message = error.getSingleMessage();
        if (message) {
            return message;
        }
    }
    if (error instanceof Error) {
        return String(error);
    }
    if (error) {
        const errorWithMessage = error; // To placate TypeScript.
        if (errorWithMessage.message && typeof errorWithMessage.message === "string") {
            return errorWithMessage.message;
        }
    }
    return JSON.stringify(error);
}
class bw_Response {
    static error(error, data) {
        const res = new bw_Response();
        res.success = false;
        res.message = getErrorMessage(error);
        res.data = data;
        return res;
    }
    static notFound() {
        return bw_Response.error("Not found.");
    }
    static noEditPermission() {
        return bw_Response.error("You do not have permission to edit this item");
    }
    static badRequest(message) {
        return bw_Response.error(message);
    }
    static multipleResults(ids) {
        let msg = "More than one result was found. Try getting a specific object by `id` instead. " +
            "The following objects were found:";
        ids.forEach((id) => {
            msg += "\n" + id;
        });
        return bw_Response.error(msg, ids);
    }
    static success(data) {
        const res = new bw_Response();
        res.success = true;
        res.data = data;
        return res;
    }
}

;// ./src/admin-console/commands/confirm.command.ts
var confirm_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore



class ConfirmCommand {
    constructor(apiService, keyService, encryptService, organizationUserApiService) {
        this.apiService = apiService;
        this.keyService = keyService;
        this.encryptService = encryptService;
        this.organizationUserApiService = organizationUserApiService;
    }
    run(object, id, cmdOptions) {
        return confirm_command_awaiter(this, void 0, void 0, function* () {
            if (id != null) {
                id = id.toLowerCase();
            }
            const normalizedOptions = new Options(cmdOptions);
            switch (object.toLowerCase()) {
                case "org-member":
                    return yield this.confirmOrganizationMember(id, normalizedOptions);
                default:
                    return bw_Response.badRequest("Unknown object.");
            }
        });
    }
    confirmOrganizationMember(id, options) {
        return confirm_command_awaiter(this, void 0, void 0, function* () {
            if (options.organizationId == null || options.organizationId === "") {
                return bw_Response.badRequest("--organizationid <organizationid> required.");
            }
            if (!utils_Utils.isGuid(id)) {
                return bw_Response.badRequest("`" + id + "` is not a GUID.");
            }
            if (!utils_Utils.isGuid(options.organizationId)) {
                return bw_Response.badRequest("`" + options.organizationId + "` is not a GUID.");
            }
            try {
                const orgKey = yield this.keyService.getOrgKey(options.organizationId);
                if (orgKey == null) {
                    throw new Error("No encryption key for this organization.");
                }
                const orgUser = yield this.organizationUserApiService.getOrganizationUser(options.organizationId, id);
                if (orgUser == null) {
                    throw new Error("Member id does not exist for this organization.");
                }
                const publicKeyResponse = yield this.apiService.getUserPublicKey(orgUser.userId);
                const publicKey = utils_Utils.fromB64ToArray(publicKeyResponse.publicKey);
                const key = yield this.encryptService.encapsulateKeyUnsigned(orgKey, publicKey);
                const req = new OrganizationUserConfirmRequest();
                req.key = key.encryptedString;
                yield this.organizationUserApiService.postOrganizationUserConfirm(options.organizationId, id, req);
                return bw_Response.success();
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
}
class Options {
    constructor(passedOptions) {
        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);
    }
}

;// ../../libs/common/src/auth/abstractions/account.service.ts
function accountInfoEqual(a, b) {
    if (a == null && b == null) {
        return true;
    }
    if (a == null || b == null) {
        return false;
    }
    const keys = new Set([...Object.keys(a), ...Object.keys(b)]);
    for (const key of keys) {
        if (a[key] !== b[key]) {
            return false;
        }
    }
    return true;
}
class AccountService {
}
class InternalAccountService extends (/* unused pure expression or super */ null && (AccountService)) {
}

;// ../../libs/common/src/auth/services/account.service.ts
var account_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore




const ACCOUNT_ACCOUNTS = KeyDefinition.record(ACCOUNT_DISK, "accounts", {
    deserializer: (accountInfo) => accountInfo,
});
const ACCOUNT_ACTIVE_ACCOUNT_ID = new KeyDefinition(ACCOUNT_DISK, "activeAccountId", {
    deserializer: (id) => id,
});
const ACCOUNT_ACTIVITY = KeyDefinition.record(ACCOUNT_DISK, "activity", {
    deserializer: (activity) => new Date(activity),
});
const ACCOUNT_VERIFY_NEW_DEVICE_LOGIN = new UserKeyDefinition(ACCOUNT_DISK, "verifyNewDeviceLogin", {
    deserializer: (verifyDevices) => verifyDevices,
    clearOn: ["logout"],
});
const LOGGED_OUT_INFO = {
    email: "",
    emailVerified: false,
    name: undefined,
};
/**
 * An rxjs map operator that extracts the UserId from an account, or throws if the account or UserId are null.
 */
const getUserId = (0,external_rxjs_namespaceObject.map)((account) => {
    if (account == null) {
        throw new Error("Null or undefined account");
    }
    return account.id;
});
/**
 * An rxjs map operator that extracts the UserId from an account, or returns undefined if the account or UserId are null.
 */
const getOptionalUserId = (0,external_rxjs_namespaceObject.map)((account) => { var _a; return (_a = account === null || account === void 0 ? void 0 : account.id) !== null && _a !== void 0 ? _a : null; });
class AccountServiceImplementation {
    constructor(messagingService, logService, globalStateProvider, singleUserStateProvider) {
        this.messagingService = messagingService;
        this.logService = logService;
        this.globalStateProvider = globalStateProvider;
        this.singleUserStateProvider = singleUserStateProvider;
        this.accountsState = this.globalStateProvider.get(ACCOUNT_ACCOUNTS);
        this.activeAccountIdState = this.globalStateProvider.get(ACCOUNT_ACTIVE_ACCOUNT_ID);
        this.accounts$ = this.accountsState.state$.pipe((0,external_rxjs_namespaceObject.map)((accounts) => (accounts == null ? {} : accounts)));
        this.activeAccount$ = this.activeAccountIdState.state$.pipe((0,external_rxjs_namespaceObject.combineLatestWith)(this.accounts$), (0,external_rxjs_namespaceObject.map)(([id, accounts]) => (id ? Object.assign({ id }, accounts[id]) : null)), (0,external_rxjs_namespaceObject.distinctUntilChanged)((a, b) => (a === null || a === void 0 ? void 0 : a.id) === (b === null || b === void 0 ? void 0 : b.id) && accountInfoEqual(a, b)), (0,external_rxjs_namespaceObject.shareReplay)({ bufferSize: 1, refCount: false }));
        this.accountActivity$ = this.globalStateProvider
            .get(ACCOUNT_ACTIVITY)
            .state$.pipe((0,external_rxjs_namespaceObject.map)((activity) => activity !== null && activity !== void 0 ? activity : {}));
        this.sortedUserIds$ = this.accountActivity$.pipe((0,external_rxjs_namespaceObject.map)((activity) => {
            return Object.entries(activity)
                .map(([userId, lastActive]) => ({ userId, lastActive }))
                .sort((a, b) => b.lastActive.getTime() - a.lastActive.getTime()) // later dates first
                .map((a) => a.userId);
        }));
        this.nextUpAccount$ = (0,external_rxjs_namespaceObject.combineLatest)([
            this.accounts$,
            this.activeAccount$,
            this.sortedUserIds$,
        ]).pipe((0,external_rxjs_namespaceObject.map)(([accounts, activeAccount, sortedUserIds]) => {
            const nextId = sortedUserIds.find((id) => id !== (activeAccount === null || activeAccount === void 0 ? void 0 : activeAccount.id) && accounts[id] != null);
            return nextId ? Object.assign({ id: nextId }, accounts[nextId]) : null;
        }));
        this.accountVerifyNewDeviceLogin$ = this.activeAccountIdState.state$.pipe((0,external_rxjs_namespaceObject.switchMap)((userId) => this.singleUserStateProvider.get(userId, ACCOUNT_VERIFY_NEW_DEVICE_LOGIN).state$));
    }
    addAccount(userId, accountData) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            if (!utils_Utils.isGuid(userId)) {
                throw new Error("userId is required");
            }
            yield this.accountsState.update((accounts) => {
                accounts || (accounts = {});
                accounts[userId] = accountData;
                return accounts;
            });
            yield this.setAccountActivity(userId, new Date());
        });
    }
    setAccountName(userId, name) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            yield this.setAccountInfo(userId, { name });
        });
    }
    setAccountEmail(userId, email) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            yield this.setAccountInfo(userId, { email });
        });
    }
    setAccountEmailVerified(userId, emailVerified) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            yield this.setAccountInfo(userId, { emailVerified });
        });
    }
    clean(userId) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            yield this.setAccountInfo(userId, LOGGED_OUT_INFO);
            yield this.removeAccountActivity(userId);
        });
    }
    switchAccount(userId) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            let updateActivity = false;
            yield this.activeAccountIdState.update((_, __) => {
                updateActivity = true;
                return userId;
            }, {
                combineLatestWith: this.accountsState.state$.pipe((0,external_rxjs_namespaceObject.filter)((accounts) => {
                    if (userId == null) {
                        // Don't worry about accounts when we are about to set active user to null
                        return true;
                    }
                    return (accounts === null || accounts === void 0 ? void 0 : accounts[userId]) != null;
                }), 
                // If we don't get the desired account with enough time, just return empty as that will result in the same error
                (0,external_rxjs_namespaceObject.timeout)({ first: 1000, with: () => (0,external_rxjs_namespaceObject.of)({}) })),
                shouldUpdate: (id, accounts) => {
                    if (userId != null && (accounts === null || accounts === void 0 ? void 0 : accounts[userId]) == null) {
                        throw new Error("Account does not exist");
                    }
                    // update only if userId changes
                    return id !== userId;
                },
            });
            if (updateActivity) {
                yield this.setAccountActivity(userId, new Date());
            }
        });
    }
    setAccountActivity(userId, lastActivity) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            if (!utils_Utils.isGuid(userId)) {
                // only store for valid userIds
                return;
            }
            yield this.globalStateProvider.get(ACCOUNT_ACTIVITY).update((activity) => {
                activity || (activity = {});
                activity[userId] = lastActivity;
                return activity;
            }, {
                shouldUpdate: (oldActivity) => { var _a; return ((_a = oldActivity === null || oldActivity === void 0 ? void 0 : oldActivity[userId]) === null || _a === void 0 ? void 0 : _a.getTime()) !== (lastActivity === null || lastActivity === void 0 ? void 0 : lastActivity.getTime()); },
            });
        });
    }
    setAccountVerifyNewDeviceLogin(userId, setVerifyNewDeviceLogin) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            if (!utils_Utils.isGuid(userId)) {
                // only store for valid userIds
                return;
            }
            yield this.singleUserStateProvider.get(userId, ACCOUNT_VERIFY_NEW_DEVICE_LOGIN).update(() => {
                return setVerifyNewDeviceLogin;
            });
        });
    }
    removeAccountActivity(userId) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            yield this.globalStateProvider.get(ACCOUNT_ACTIVITY).update((activity) => {
                if (activity == null) {
                    return activity;
                }
                delete activity[userId];
                return activity;
            }, { shouldUpdate: (oldActivity) => (oldActivity === null || oldActivity === void 0 ? void 0 : oldActivity[userId]) != null });
        });
    }
    // TODO: update to use our own account status settings. Requires inverting direction of state service accounts flow
    delete() {
        return account_service_awaiter(this, void 0, void 0, function* () {
            var _a;
            try {
                (_a = this.messagingService) === null || _a === void 0 ? void 0 : _a.send("logout");
            }
            catch (e) {
                this.logService.error(e);
                throw e;
            }
        });
    }
    setAccountInfo(userId, update) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            function newAccountInfo(oldAccountInfo) {
                return Object.assign(Object.assign({}, oldAccountInfo), update);
            }
            yield this.accountsState.update((accounts) => {
                accounts[userId] = newAccountInfo(accounts[userId]);
                return accounts;
            }, {
                // Avoid unnecessary updates
                // TODO: Faster comparison, maybe include a hash on the objects?
                shouldUpdate: (accounts) => {
                    if ((accounts === null || accounts === void 0 ? void 0 : accounts[userId]) == null) {
                        throw new Error("Account does not exist");
                    }
                    return !accountInfoEqual(accounts[userId], newAccountInfo(accounts[userId]));
                },
            });
        });
    }
}

;// external "fs"
const external_fs_namespaceObject = require("fs");
;// external "inquirer"
const external_inquirer_namespaceObject = require("inquirer");
;// external "jszip"
const external_jszip_namespaceObject = require("jszip");
;// external "readline"
const external_readline_namespaceObject = require("readline");
;// ../../libs/node/src/node-utils.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore



class NodeUtils {
    static mkdirpSync(targetDir, mode = "700", relative = false, relativeDir = null) {
        const initialDir = external_path_namespaceObject.isAbsolute(targetDir) ? external_path_namespaceObject.sep : "";
        const baseDir = relative ? (relativeDir != null ? relativeDir : __dirname) : ".";
        targetDir.split(external_path_namespaceObject.sep).reduce((parentDir, childDir) => {
            const dir = external_path_namespaceObject.resolve(baseDir, parentDir, childDir);
            if (!external_fs_namespaceObject.existsSync(dir)) {
                external_fs_namespaceObject.mkdirSync(dir, mode);
            }
            return dir;
        }, initialDir);
    }
    static readFirstLine(fileName) {
        return new Promise((resolve, reject) => {
            const readStream = external_fs_namespaceObject.createReadStream(fileName, { encoding: "utf8" });
            const readInterface = external_readline_namespaceObject.createInterface(readStream);
            readInterface
                .on("line", (line) => {
                readStream.close();
                resolve(line);
            })
                .on("error", (err) => reject(err));
        });
    }
    // https://stackoverflow.com/a/31394257
    static bufferToArrayBuffer(buf) {
        return buf.buffer.slice(buf.byteOffset, buf.byteOffset + buf.byteLength);
    }
}

;// ./src/models/response/message.response.ts
class MessageResponse {
    constructor(title, message) {
        this.noColor = false;
        this.object = "message";
        this.title = title;
        this.message = message;
    }
}

;// ./src/utils.ts
var utils_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore








class CliUtils {
    static writeLn(s, finalLine = false, error = false) {
        const stream = error ? process.stderr : process.stdout;
        if (finalLine && (process.platform === "win32" || !stream.isTTY)) {
            stream.write(s);
        }
        else {
            stream.write(s + "\n");
        }
    }
    static readFile(input) {
        return new Promise((resolve, reject) => {
            let p = null;
            if (input != null && input !== "") {
                const osInput = external_path_namespaceObject.join(input);
                if (osInput.indexOf(external_path_namespaceObject.sep) === -1) {
                    p = external_path_namespaceObject.join(process.cwd(), osInput);
                }
                else {
                    p = osInput;
                }
            }
            else {
                reject("You must specify a file path.");
            }
            external_fs_namespaceObject.readFile(p, "utf8", (err, data) => {
                if (err != null) {
                    reject(err.message);
                }
                resolve(data);
            });
        });
    }
    static extractZipContent(input, filepath) {
        return new Promise((resolve, reject) => {
            let p = null;
            if (input != null && input !== "") {
                const osInput = external_path_namespaceObject.join(input);
                if (osInput.indexOf(external_path_namespaceObject.sep) === -1) {
                    p = external_path_namespaceObject.join(process.cwd(), osInput);
                }
                else {
                    p = osInput;
                }
            }
            else {
                reject("You must specify a file path.");
            }
            external_fs_namespaceObject.readFile(p, function (err, data) {
                if (err) {
                    reject(err);
                }
                external_jszip_namespaceObject.loadAsync(data).then((zip) => {
                    resolve(zip.file(filepath).async("string"));
                }, (reason) => {
                    reject(reason);
                });
            });
        });
    }
    /**
     * Save the given data to a file and determine the target file if necessary.
     * If output is non-empty, it is used as target filename. Otherwise the target filename is
     * built from the current working directory and the given defaultFileName.
     *
     * @param data to be written to the file.
     * @param output file to write to or empty to choose automatically.
     * @param defaultFileName to use when no explicit output filename is given.
     * @return the chosen output file.
     */
    static saveFile(data, output, defaultFileName) {
        let p = null;
        let mkdir = false;
        if (output != null && output !== "") {
            const osOutput = external_path_namespaceObject.join(output);
            if (osOutput.indexOf(external_path_namespaceObject.sep) === -1) {
                p = external_path_namespaceObject.join(process.cwd(), osOutput);
            }
            else {
                mkdir = true;
                if (osOutput.endsWith(external_path_namespaceObject.sep)) {
                    p = external_path_namespaceObject.join(osOutput, defaultFileName);
                }
                else {
                    p = osOutput;
                }
            }
        }
        else {
            p = external_path_namespaceObject.join(process.cwd(), defaultFileName);
        }
        p = external_path_namespaceObject.resolve(p);
        if (mkdir) {
            const dir = p.substring(0, p.lastIndexOf(external_path_namespaceObject.sep));
            if (!external_fs_namespaceObject.existsSync(dir)) {
                NodeUtils.mkdirpSync(dir, "700");
            }
        }
        return new Promise((resolve, reject) => {
            external_fs_namespaceObject.writeFile(p, data, { encoding: "utf8", mode: 0o600 }, (err) => {
                if (err != null) {
                    reject("Cannot save file to " + p);
                }
                resolve(p);
            });
        });
    }
    /**
     * Process the given data and write it to a file if possible. If the user requested RAW output and
     * no output name is given, the file is directly written to stdout. The resulting Response contains
     * an otherwise empty message then to prevent writing other information to stdout.
     *
     * If an output is given or no RAW output is requested, the rules from [saveFile] apply.
     *
     * @param data to be written to the file or stdout.
     * @param output file to write to or empty to choose automatically.
     * @param defaultFileName to use when no explicit output filename is given.
     * @return an empty [Response] if written to stdout or a [Response] with the chosen output file otherwise.
     */
    static saveResultToFile(data, output, defaultFileName) {
        return utils_awaiter(this, void 0, void 0, function* () {
            if ((output == null || output === "") && process.env.BW_RAW === "true") {
                // No output is given and the user expects raw output. Since the command result is about content,
                // we directly return the command result to stdout (and suppress further messages).
                process.stdout.write(data);
                return bw_Response.success();
            }
            const filePath = yield this.saveFile(data, output, defaultFileName);
            const res = new MessageResponse("Saved " + filePath, null);
            res.raw = filePath;
            return bw_Response.success(res);
        });
    }
    static readStdin() {
        return new Promise((resolve, reject) => {
            let input = "";
            if (process.stdin.isTTY) {
                resolve(input);
                return;
            }
            process.stdin.setEncoding("utf8");
            process.stdin.on("readable", () => {
                // eslint-disable-next-line
                while (true) {
                    const chunk = process.stdin.read();
                    if (chunk == null) {
                        break;
                    }
                    input += chunk;
                }
            });
            process.stdin.on("end", () => {
                resolve(input);
            });
        });
    }
    static searchFolders(folders, search) {
        search = search.toLowerCase();
        return folders.filter((f) => {
            if (f.name != null && f.name.toLowerCase().indexOf(search) > -1) {
                return true;
            }
            return false;
        });
    }
    static searchCollections(collections, search) {
        search = search.toLowerCase();
        return collections.filter((c) => {
            if (c.name != null && c.name.toLowerCase().indexOf(search) > -1) {
                return true;
            }
            return false;
        });
    }
    static searchOrganizations(organizations, search) {
        search = search.toLowerCase();
        return organizations.filter((o) => {
            if (o.name != null && o.name.toLowerCase().indexOf(search) > -1) {
                return true;
            }
            return false;
        });
    }
    /**
     * Gets a password from all available sources. In order of priority these are:
     *   * passwordfile
     *   * passwordenv
     *   * user interaction
     *
     * Returns password string if successful, Response if not.
     */
    static getPassword(password, options, logService) {
        return utils_awaiter(this, void 0, void 0, function* () {
            if (utils_Utils.isNullOrEmpty(password)) {
                if (options === null || options === void 0 ? void 0 : options.passwordFile) {
                    password = yield NodeUtils.readFirstLine(options.passwordFile);
                }
                else if (options === null || options === void 0 ? void 0 : options.passwordEnv) {
                    if (process.env[options.passwordEnv]) {
                        password = process.env[options.passwordEnv];
                    }
                    else if (logService) {
                        logService.warning(`Warning: Provided passwordenv ${options.passwordEnv} is not set`);
                    }
                }
            }
            if (utils_Utils.isNullOrEmpty(password)) {
                if (process.env.BW_NOINTERACTION !== "true") {
                    const answer = yield external_inquirer_namespaceObject.createPromptModule({
                        output: process.stderr,
                    })({
                        type: "password",
                        name: "password",
                        message: "Master password:",
                    });
                    password = answer.password;
                }
                else {
                    return bw_Response.badRequest("Master password is required. Try again in interactive mode or provide a password file or environment variable.");
                }
            }
            return password;
        });
    }
    static convertBooleanOption(optionValue) {
        return optionValue || optionValue === "" ? true : false;
    }
    static convertNumberOption(optionValue, defaultValue) {
        try {
            if (optionValue != null) {
                const numVal = parseInt(optionValue);
                return !Number.isNaN(numVal) ? numVal : defaultValue;
            }
            return defaultValue;
        }
        catch (_a) {
            return defaultValue;
        }
    }
    static convertStringOption(optionValue, defaultValue) {
        return optionValue != null ? String(optionValue) : defaultValue;
    }
}

;// ../../libs/common/src/vault/enums/cipher-reprompt-type.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var CipherRepromptType;
(function (CipherRepromptType) {
    CipherRepromptType[CipherRepromptType["None"] = 0] = "None";
    CipherRepromptType[CipherRepromptType["Password"] = 1] = "Password";
})(CipherRepromptType || (CipherRepromptType = {}));

;// ../../libs/common/src/vault/enums/cipher-type.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var CipherType;
(function (CipherType) {
    CipherType[CipherType["Login"] = 1] = "Login";
    CipherType[CipherType["SecureNote"] = 2] = "SecureNote";
    CipherType[CipherType["Card"] = 3] = "Card";
    CipherType[CipherType["Identity"] = 4] = "Identity";
    CipherType[CipherType["SshKey"] = 5] = "SshKey";
})(CipherType || (CipherType = {}));

;// ../../libs/common/src/platform/services/cryptography/initializer-key.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var InitializerKey;
(function (InitializerKey) {
    InitializerKey[InitializerKey["Cipher"] = 0] = "Cipher";
    InitializerKey[InitializerKey["CipherView"] = 1] = "CipherView";
})(InitializerKey || (InitializerKey = {}));

;// ../../libs/common/src/vault/models/api/cipher-permissions.api.ts

class CipherPermissionsApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        this.delete = false;
        this.restore = false;
        if (data == null) {
            return;
        }
        this.delete = this.getResponseProperty("Delete");
        this.restore = this.getResponseProperty("Restore");
    }
    static fromJSON(obj) {
        return Object.assign(new CipherPermissionsApi(), obj);
    }
    /**
     * Converts the SDK CipherPermissionsApi to a CipherPermissionsApi.
     */
    static fromSdkCipherPermissions(obj) {
        if (!obj) {
            return undefined;
        }
        const permissions = new CipherPermissionsApi();
        permissions.delete = obj.delete;
        permissions.restore = obj.restore;
        return permissions;
    }
}

;// ../../libs/common/src/vault/models/data/attachment.data.ts
class AttachmentData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.id = response.id;
        this.url = response.url;
        this.fileName = response.fileName;
        this.key = response.key;
        this.size = response.size;
        this.sizeName = response.sizeName;
    }
}

;// ../../libs/common/src/vault/models/data/card.data.ts
class CardData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.cardholderName = data.cardholderName;
        this.brand = data.brand;
        this.number = data.number;
        this.expMonth = data.expMonth;
        this.expYear = data.expYear;
        this.code = data.code;
    }
}

;// ../../libs/common/src/vault/models/data/field.data.ts
class FieldData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.type = response.type;
        this.name = response.name;
        this.value = response.value;
        this.linkedId = response.linkedId;
    }
}

;// ../../libs/common/src/vault/models/data/identity.data.ts
class IdentityData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.title = data.title;
        this.firstName = data.firstName;
        this.middleName = data.middleName;
        this.lastName = data.lastName;
        this.address1 = data.address1;
        this.address2 = data.address2;
        this.address3 = data.address3;
        this.city = data.city;
        this.state = data.state;
        this.postalCode = data.postalCode;
        this.country = data.country;
        this.company = data.company;
        this.email = data.email;
        this.phone = data.phone;
        this.ssn = data.ssn;
        this.username = data.username;
        this.passportNumber = data.passportNumber;
        this.licenseNumber = data.licenseNumber;
    }
}

;// ../../libs/common/src/vault/models/data/fido2-credential.data.ts
class Fido2CredentialData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.credentialId = data.credentialId;
        this.keyType = data.keyType;
        this.keyAlgorithm = data.keyAlgorithm;
        this.keyCurve = data.keyCurve;
        this.keyValue = data.keyValue;
        this.rpId = data.rpId;
        this.userHandle = data.userHandle;
        this.userName = data.userName;
        this.counter = data.counter;
        this.rpName = data.rpName;
        this.userDisplayName = data.userDisplayName;
        this.discoverable = data.discoverable;
        this.creationDate = data.creationDate;
    }
}

;// ../../libs/common/src/vault/models/data/login-uri.data.ts
class LoginUriData {
    constructor(data) {
        this.match = null;
        if (data == null) {
            return;
        }
        this.uri = data.uri;
        this.uriChecksum = data.uriChecksum;
        this.match = data.match;
    }
}

;// ../../libs/common/src/vault/models/data/login.data.ts


class LoginData {
    constructor(data) {
        var _a;
        if (data == null) {
            return;
        }
        this.username = data.username;
        this.password = data.password;
        this.passwordRevisionDate = data.passwordRevisionDate;
        this.totp = data.totp;
        this.autofillOnPageLoad = data.autofillOnPageLoad;
        if (data.uris) {
            this.uris = data.uris.map((u) => new LoginUriData(u));
        }
        if (data.fido2Credentials) {
            this.fido2Credentials = (_a = data.fido2Credentials) === null || _a === void 0 ? void 0 : _a.map((key) => new Fido2CredentialData(key));
        }
    }
}

;// ../../libs/common/src/vault/models/data/password-history.data.ts
class PasswordHistoryData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.password = response.password;
        this.lastUsedDate = response.lastUsedDate;
    }
}

;// ../../libs/common/src/vault/models/data/secure-note.data.ts
class SecureNoteData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.type = data.type;
    }
}

;// ../../libs/common/src/vault/models/data/ssh-key.data.ts
class SshKeyData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.privateKey = data.privateKey;
        this.publicKey = data.publicKey;
        this.keyFingerprint = data.keyFingerprint;
    }
}

;// ../../libs/common/src/vault/models/data/cipher.data.ts










class CipherData {
    constructor(response, collectionIds) {
        if (response == null) {
            return;
        }
        this.id = response.id;
        this.organizationId = response.organizationId;
        this.folderId = response.folderId;
        this.edit = response.edit;
        this.viewPassword = response.viewPassword;
        this.permissions = response.permissions;
        this.organizationUseTotp = response.organizationUseTotp;
        this.favorite = response.favorite;
        this.revisionDate = response.revisionDate;
        this.type = response.type;
        this.name = response.name;
        this.notes = response.notes;
        this.collectionIds = collectionIds != null ? collectionIds : response.collectionIds;
        this.creationDate = response.creationDate;
        this.deletedDate = response.deletedDate;
        this.reprompt = response.reprompt;
        this.key = response.key;
        switch (this.type) {
            case CipherType.Login:
                this.login = new LoginData(response.login);
                break;
            case CipherType.SecureNote:
                this.secureNote = new SecureNoteData(response.secureNote);
                break;
            case CipherType.Card:
                this.card = new CardData(response.card);
                break;
            case CipherType.Identity:
                this.identity = new IdentityData(response.identity);
                break;
            case CipherType.SshKey:
                this.sshKey = new SshKeyData(response.sshKey);
                break;
            default:
                break;
        }
        if (response.fields != null) {
            this.fields = response.fields.map((f) => new FieldData(f));
        }
        if (response.attachments != null) {
            this.attachments = response.attachments.map((a) => new AttachmentData(a));
        }
        if (response.passwordHistory != null) {
            this.passwordHistory = response.passwordHistory.map((ph) => new PasswordHistoryData(ph));
        }
    }
    static fromJSON(obj) {
        const result = Object.assign(new CipherData(), obj);
        result.permissions = CipherPermissionsApi.fromJSON(obj.permissions);
        return result;
    }
}

;// ../../libs/common/src/vault/enums/field-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var FieldType;
(function (FieldType) {
    FieldType[FieldType["Text"] = 0] = "Text";
    FieldType[FieldType["Hidden"] = 1] = "Hidden";
    FieldType[FieldType["Boolean"] = 2] = "Boolean";
    FieldType[FieldType["Linked"] = 3] = "Linked";
})(FieldType || (FieldType = {}));

;// ../../libs/common/src/vault/enums/linked-id-type.enum.ts
// LoginView
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var LoginLinkedId;
(function (LoginLinkedId) {
    LoginLinkedId[LoginLinkedId["Username"] = 100] = "Username";
    LoginLinkedId[LoginLinkedId["Password"] = 101] = "Password";
})(LoginLinkedId || (LoginLinkedId = {}));
// CardView
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var CardLinkedId;
(function (CardLinkedId) {
    CardLinkedId[CardLinkedId["CardholderName"] = 300] = "CardholderName";
    CardLinkedId[CardLinkedId["ExpMonth"] = 301] = "ExpMonth";
    CardLinkedId[CardLinkedId["ExpYear"] = 302] = "ExpYear";
    CardLinkedId[CardLinkedId["Code"] = 303] = "Code";
    CardLinkedId[CardLinkedId["Brand"] = 304] = "Brand";
    CardLinkedId[CardLinkedId["Number"] = 305] = "Number";
})(CardLinkedId || (CardLinkedId = {}));
// IdentityView
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var IdentityLinkedId;
(function (IdentityLinkedId) {
    IdentityLinkedId[IdentityLinkedId["Title"] = 400] = "Title";
    IdentityLinkedId[IdentityLinkedId["MiddleName"] = 401] = "MiddleName";
    IdentityLinkedId[IdentityLinkedId["Address1"] = 402] = "Address1";
    IdentityLinkedId[IdentityLinkedId["Address2"] = 403] = "Address2";
    IdentityLinkedId[IdentityLinkedId["Address3"] = 404] = "Address3";
    IdentityLinkedId[IdentityLinkedId["City"] = 405] = "City";
    IdentityLinkedId[IdentityLinkedId["State"] = 406] = "State";
    IdentityLinkedId[IdentityLinkedId["PostalCode"] = 407] = "PostalCode";
    IdentityLinkedId[IdentityLinkedId["Country"] = 408] = "Country";
    IdentityLinkedId[IdentityLinkedId["Company"] = 409] = "Company";
    IdentityLinkedId[IdentityLinkedId["Email"] = 410] = "Email";
    IdentityLinkedId[IdentityLinkedId["Phone"] = 411] = "Phone";
    IdentityLinkedId[IdentityLinkedId["Ssn"] = 412] = "Ssn";
    IdentityLinkedId[IdentityLinkedId["Username"] = 413] = "Username";
    IdentityLinkedId[IdentityLinkedId["PassportNumber"] = 414] = "PassportNumber";
    IdentityLinkedId[IdentityLinkedId["LicenseNumber"] = 415] = "LicenseNumber";
    IdentityLinkedId[IdentityLinkedId["FirstName"] = 416] = "FirstName";
    IdentityLinkedId[IdentityLinkedId["LastName"] = 417] = "LastName";
    IdentityLinkedId[IdentityLinkedId["FullName"] = 418] = "FullName";
})(IdentityLinkedId || (IdentityLinkedId = {}));

;// ../../libs/common/src/vault/enums/secure-note-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var SecureNoteType;
(function (SecureNoteType) {
    SecureNoteType[SecureNoteType["Generic"] = 0] = "Generic";
})(SecureNoteType || (SecureNoteType = {}));

;// ../../libs/common/src/vault/enums/index.ts






;// ../../libs/common/src/platform/models/domain/symmetric-crypto-key.ts


/**
 *  A symmetric crypto key represents a symmetric key usable for symmetric encryption and decryption operations.
 *  The specific algorithm used is private to the key, and should only be exposed to encrypt service implementations.
 *  This can be done via `inner()`.
 */
class SymmetricCryptoKey {
    /**
     * @param key The key in one of the permitted serialization formats
     */
    constructor(key) {
        if (key == null) {
            throw new Error("Must provide key");
        }
        if (key.byteLength === 32) {
            this.innerKey = {
                type: EncryptionType.AesCbc256_B64,
                encryptionKey: key,
            };
            this.keyB64 = this.toBase64();
        }
        else if (key.byteLength === 64) {
            this.innerKey = {
                type: EncryptionType.AesCbc256_HmacSha256_B64,
                encryptionKey: key.slice(0, 32),
                authenticationKey: key.slice(32),
            };
            this.keyB64 = this.toBase64();
        }
        else {
            throw new Error(`Unsupported encType/key length ${key.byteLength}`);
        }
    }
    toJSON() {
        // The whole object is constructed from the initial key, so just store the B64 key
        return { keyB64: this.keyB64 };
    }
    /**
     * It is preferred not to work with the raw key where possible.
     * Only use this method if absolutely necessary.
     *
     * @returns The inner key instance that can be directly used for encryption primitives
     */
    inner() {
        return this.innerKey;
    }
    /**
     * @returns The serialized key in base64 format
     */
    toBase64() {
        return utils_Utils.fromBufferToB64(this.toEncoded());
    }
    /**
     * Serializes the key to a format that can be written to state or shared
     * The currently permitted format is:
     * - AesCbc256_B64: 32 bytes (the raw key)
     * - AesCbc256_HmacSha256_B64: 64 bytes (32 bytes encryption key, 32 bytes authentication key, concatenated)
     *
     * @returns The serialized key that can be written to state or encrypted and then written to state / shared
     */
    toEncoded() {
        if (this.innerKey.type === EncryptionType.AesCbc256_B64) {
            return this.innerKey.encryptionKey;
        }
        else if (this.innerKey.type === EncryptionType.AesCbc256_HmacSha256_B64) {
            const encodedKey = new Uint8Array(64);
            encodedKey.set(this.innerKey.encryptionKey, 0);
            encodedKey.set(this.innerKey.authenticationKey, 32);
            return encodedKey;
        }
        else {
            throw new Error("Unsupported encryption type.");
        }
    }
    /**
     * @param s The serialized key in base64 format
     * @returns A SymmetricCryptoKey instance
     */
    static fromString(s) {
        if (s == null) {
            return null;
        }
        const arrayBuffer = utils_Utils.fromB64ToArray(s);
        return new SymmetricCryptoKey(arrayBuffer);
    }
    static fromJSON(obj) {
        return SymmetricCryptoKey.fromString(obj === null || obj === void 0 ? void 0 : obj.keyB64);
    }
}

;// ../../libs/common/src/vault/models/view/attachment.view.ts


class AttachmentView {
    constructor(a) {
        this.id = null;
        this.url = null;
        this.size = null;
        this.sizeName = null;
        this.fileName = null;
        this.key = null;
        if (!a) {
            return;
        }
        this.id = a.id;
        this.url = a.url;
        this.size = a.size;
        this.sizeName = a.sizeName;
    }
    get fileSize() {
        try {
            if (this.size != null) {
                return parseInt(this.size, null);
            }
        }
        catch (_a) {
            // Invalid file size.
        }
        return 0;
    }
    static fromJSON(obj) {
        const key = obj.key == null ? null : SymmetricCryptoKey.fromJSON(obj.key);
        return Object.assign(new AttachmentView(), obj, { key: key });
    }
    /**
     * Converts the AttachmentView to a SDK AttachmentView.
     */
    toSdkAttachmentView() {
        var _a;
        return {
            id: this.id,
            url: this.url,
            size: this.size,
            sizeName: this.sizeName,
            fileName: this.fileName,
            key: (_a = this.encryptedKey) === null || _a === void 0 ? void 0 : _a.toJSON(),
        };
    }
    /**
     * Converts the SDK AttachmentView to a AttachmentView.
     */
    static fromSdkAttachmentView(obj) {
        var _a, _b, _c, _d, _e;
        if (!obj) {
            return undefined;
        }
        const view = new AttachmentView();
        view.id = (_a = obj.id) !== null && _a !== void 0 ? _a : null;
        view.url = (_b = obj.url) !== null && _b !== void 0 ? _b : null;
        view.size = (_c = obj.size) !== null && _c !== void 0 ? _c : null;
        view.sizeName = (_d = obj.sizeName) !== null && _d !== void 0 ? _d : null;
        view.fileName = (_e = obj.fileName) !== null && _e !== void 0 ? _e : null;
        view.encryptedKey = new enc_string_EncString(obj.key);
        return view;
    }
}

;// ../../libs/common/src/autofill/constants/match-patterns.ts
const CardExpiryDateDelimiters = ["/", "-", ".", " "];
// `CardExpiryDateDelimiters` is not intended solely for regex consumption,
// so we need to format it here
const ExpiryDateDelimitersPattern = "\\" +
    CardExpiryDateDelimiters.join("\\")
        // replace space character with the regex whitespace character class
        .replace(" ", "s");
const MonthPattern = "(([1]{1}[0-2]{1})|(0?[1-9]{1}))";
// Because we're dealing with expiry dates, we assume the year will be in current or next century (as of 2024)
const match_patterns_ExpiryFullYearPattern = "2[0-1]{1}\\d{2}";
const match_patterns_DelimiterPatternExpression = new RegExp(`[${ExpiryDateDelimitersPattern}]`, "g");
const match_patterns_IrrelevantExpiryCharactersPatternExpression = new RegExp(
// "nor digits" to ensure numbers are removed from guidance pattern, which aren't covered by ^\w
`[^\\d${ExpiryDateDelimitersPattern}]`, "g");
const match_patterns_MonthPatternExpression = new RegExp(`^${MonthPattern}$`);
const match_patterns_ExpiryFullYearPatternExpression = new RegExp(`^${match_patterns_ExpiryFullYearPattern}$`);

;// ../../libs/common/src/autofill/constants/index.ts
const TYPE_CHECK = {
    FUNCTION: "function",
    NUMBER: "number",
    STRING: "string",
};
const EVENTS = {
    CHANGE: "change",
    INPUT: "input",
    KEYDOWN: "keydown",
    KEYPRESS: "keypress",
    KEYUP: "keyup",
    BLUR: "blur",
    CLICK: "click",
    FOCUS: "focus",
    FOCUSIN: "focusin",
    FOCUSOUT: "focusout",
    SCROLL: "scroll",
    RESIZE: "resize",
    DOMCONTENTLOADED: "DOMContentLoaded",
    LOAD: "load",
    MESSAGE: "message",
    VISIBILITYCHANGE: "visibilitychange",
    MOUSEENTER: "mouseenter",
    MOUSELEAVE: "mouseleave",
    MOUSEUP: "mouseup",
    MOUSEOUT: "mouseout",
    SUBMIT: "submit",
};
const ClearClipboardDelay = {
    Never: null,
    TenSeconds: 10,
    TwentySeconds: 20,
    ThirtySeconds: 30,
    OneMinute: 60,
    TwoMinutes: 120,
    FiveMinutes: 300,
};
/* Ids for context menu items and messaging events */
const AUTOFILL_CARD_ID = "autofill-card";
const AUTOFILL_ID = "autofill";
const SHOW_AUTOFILL_BUTTON = "show-autofill-button";
const AUTOFILL_IDENTITY_ID = "autofill-identity";
const COPY_IDENTIFIER_ID = "copy-identifier";
const COPY_PASSWORD_ID = "copy-password";
const COPY_USERNAME_ID = "copy-username";
const COPY_VERIFICATION_CODE_ID = "copy-totp";
const CREATE_CARD_ID = "create-card";
const CREATE_IDENTITY_ID = "create-identity";
const CREATE_LOGIN_ID = "create-login";
const GENERATE_PASSWORD_ID = "generate-password";
const NOOP_COMMAND_SUFFIX = "noop";
const ROOT_ID = "root";
const SEPARATOR_ID = "separator";
const UPDATE_PASSWORD = "update-password";
const NOTIFICATION_BAR_LIFESPAN_MS = 150000; // 150 seconds
const AUTOFILL_OVERLAY_HANDLE_REPOSITION = "autofill-overlay-handle-reposition-event";
const AUTOFILL_OVERLAY_HANDLE_SCROLL = "autofill-overlay-handle-scroll-event";
const UPDATE_PASSKEYS_HEADINGS_ON_SCROLL = "update-passkeys-headings-on-scroll";
const AUTOFILL_TRIGGER_FORM_FIELD_SUBMIT = "autofill-trigger-form-field-submit";
const AutofillOverlayVisibility = {
    Off: 0,
    OnButtonClick: 1,
    OnFieldFocus: 2,
};
const BrowserClientVendors = {
    Chrome: "Chrome",
    Opera: "Opera",
    Edge: "Edge",
    Vivaldi: "Vivaldi",
    Unknown: "Unknown",
};
const BrowserShortcutsUris = {
    Chrome: "chrome://extensions/shortcuts",
    Opera: "opera://extensions/shortcuts",
    Edge: "edge://extensions/shortcuts",
    Vivaldi: "vivaldi://extensions/shortcuts",
    Unknown: "https://bitwarden.com/help/keyboard-shortcuts",
};
const DisablePasswordManagerUris = {
    Chrome: "chrome://settings/autofill",
    Opera: "opera://settings/autofill",
    Edge: "edge://settings/passwords",
    Vivaldi: "vivaldi://settings/autofill",
    Unknown: "https://bitwarden.com/help/disable-browser-autofill/",
};
const ExtensionCommand = {
    AutofillCommand: "autofill_cmd",
    AutofillCard: "autofill_card",
    AutofillIdentity: "autofill_identity",
    AutofillLogin: "autofill_login",
    OpenAutofillOverlay: "open_autofill_overlay",
    GeneratePassword: "generate_password",
    OpenPopup: "open_popup",
    LockVault: "lock_vault",
    NoopCommand: "noop",
};
const CLEAR_NOTIFICATION_LOGIN_DATA_DURATION = (/* unused pure expression or super */ null && (60 * 1000)); // 1 minute
const MAX_DEEP_QUERY_RECURSION_DEPTH = 4;


;// ../../libs/common/src/autofill/utils.ts


/**
 * Takes a string or number value and returns a string value formatted as a valid 4-digit year
 *
 * @param {(string | number)} yearInput
 * @return {*}  {(Year | null)}
 */
function normalizeExpiryYearFormat(yearInput) {
    // The input[type="number"] is returning a number, convert it to a string
    // An empty field returns null, avoid casting `"null"` to a string
    const yearInputIsEmpty = yearInput == null || yearInput === "";
    let expirationYear = yearInputIsEmpty ? null : `${yearInput}`;
    // Exit early if year is already formatted correctly or empty
    if (yearInputIsEmpty || (expirationYear && /^[1-9]{1}\d{3}$/.test(expirationYear))) {
        return expirationYear;
    }
    expirationYear = (expirationYear || "")
        // For safety, because even input[type="number"] will allow decimals
        .replace(/[^\d]/g, "")
        // remove any leading zero padding (leave the last leading zero if it ends the string)
        .replace(/^[0]+(?=.)/, "");
    if (expirationYear === "") {
        expirationYear = null;
    }
    // given the context of payment card expiry, a year character length of 3, or over 4
    // is more likely to be a mistake than an intentional value for the far past or far future.
    if (expirationYear && expirationYear.length !== 4) {
        const paddedYear = ("00" + expirationYear).slice(-2);
        const currentCentury = `${new Date().getFullYear()}`.slice(0, 2);
        expirationYear = currentCentury + paddedYear;
    }
    return expirationYear;
}
/**
 * Takes a cipher card view and returns "true" if the month and year affirmativey indicate
 * the card is expired. Uncertain cases return "false".
 *
 * @param {CardView} cipherCard
 * @return {*}  {boolean}
 */
function isCardExpired(cipherCard) {
    if (cipherCard) {
        const { expMonth = null, expYear = null } = cipherCard;
        if (!expYear) {
            return false;
        }
        const now = new Date();
        const normalizedYear = normalizeExpiryYearFormat(expYear);
        const parsedYear = normalizedYear ? parseInt(normalizedYear, 10) : NaN;
        const expiryYearIsBeforeCurrentYear = parsedYear < now.getFullYear();
        const expiryYearIsAfterCurrentYear = parsedYear > now.getFullYear();
        // If the expiry year is before the current year, skip checking the month, since it must be expired
        if (normalizedYear && expiryYearIsBeforeCurrentYear) {
            return true;
        }
        // If the expiry year is after the current year, skip checking the month, since it cannot be expired
        if (normalizedYear && expiryYearIsAfterCurrentYear) {
            return false;
        }
        if (normalizedYear && expMonth) {
            const parsedMonthInteger = parseInt(expMonth, 10);
            const parsedMonthIsValid = parsedMonthInteger && !isNaN(parsedMonthInteger);
            // If the parsed month value is 0, we don't know when the expiry passes this year, so do not treat it as expired
            if (!parsedMonthIsValid) {
                return false;
            }
            // `Date` months are zero-indexed
            const parsedMonth = parsedMonthInteger - 1;
            // First day of the next month
            const cardExpiry = new Date(parsedYear, parsedMonth + 1, 1);
            return cardExpiry <= now;
        }
    }
    return false;
}
/**
 * Attempt to split a string into date segments on the basis of expected formats and delimiter symbols.
 *
 * @param {string} combinedExpiryValue
 * @return {*}  {string[]}
 */
function splitCombinedDateValues(combinedExpiryValue) {
    var _a;
    let sanitizedValue = combinedExpiryValue
        .replace(IrrelevantExpiryCharactersPatternExpression, "")
        .trim();
    // Do this after initial value replace to avoid identifying leading whitespace as delimiter
    const parsedDelimiter = ((_a = sanitizedValue.match(DelimiterPatternExpression)) === null || _a === void 0 ? void 0 : _a[0]) || null;
    let dateParts = [sanitizedValue];
    if (parsedDelimiter === null || parsedDelimiter === void 0 ? void 0 : parsedDelimiter.length) {
        // If the parsed delimiter is a whitespace character, assign 's' (character class) instead
        const delimiterPattern = /\s/.test(parsedDelimiter) ? "\\s" : "\\" + parsedDelimiter;
        sanitizedValue = sanitizedValue
            // Remove all other delimiter characters not identified as the delimiter
            .replace(new RegExp(`[^\\d${delimiterPattern}]`, "g"), "")
            // Also de-dupe the delimiter character
            .replace(new RegExp(`[${delimiterPattern}]{2,}`, "g"), parsedDelimiter);
        dateParts = sanitizedValue.split(parsedDelimiter);
    }
    return (dateParts
        // remove values that have no length
        .filter((splitValue) => splitValue === null || splitValue === void 0 ? void 0 : splitValue.length));
}
/**
 * Given an array of split card expiry date parts,
 * returns an array of those values ordered by year then month
 *
 * @param {string[]} splitDateInput
 * @return {*}  {([string | null, string | null])}
 */
function parseDelimitedYearMonthExpiry([firstPart, secondPart]) {
    // Conditionals here are structured to avoid unnecessary evaluations and are ordered
    // from more authoritative checks to checks yielding increasingly inferred conclusions
    // If a 4-digit value is found (when there are multiple parts), it can't be month
    if (ExpiryFullYearPatternExpression.test(firstPart)) {
        return [firstPart, secondPart];
    }
    // If a 4-digit value is found (when there are multiple parts), it can't be month
    if (ExpiryFullYearPatternExpression.test(secondPart)) {
        return [secondPart, firstPart];
    }
    // If it's a two digit value that doesn't match against month pattern, assume it's a year
    if (/\d{2}/.test(firstPart) && !MonthPatternExpression.test(firstPart)) {
        return [firstPart, secondPart];
    }
    // If it's a two digit value that doesn't match against month pattern, assume it's a year
    if (/\d{2}/.test(secondPart) && !MonthPatternExpression.test(secondPart)) {
        return [secondPart, firstPart];
    }
    // Values are too ambiguous (e.g. "12/09"). For the most part,
    // a month-looking value likely is, at the time of writing (year 2024).
    let parsedYear = firstPart;
    let parsedMonth = secondPart;
    if (MonthPatternExpression.test(firstPart)) {
        parsedYear = secondPart;
        parsedMonth = firstPart;
    }
    return [parsedYear, parsedMonth];
}
/**
 * Given a single string of integers, attempts to identify card expiry date portions within
 * and return values ordered by year then month
 *
 * @param {string} dateInput
 * @return {*}  {([string | null, string | null])}
 */
function parseNonDelimitedYearMonthExpiry(dateInput) {
    if (dateInput.length > 4) {
        // e.g.
        // "052024"
        // "202405"
        // "20245"
        // "52024"
        // If the value is over 5-characters long, it likely has a full year format in it
        const [parsedYear, parsedMonth] = dateInput
            .split(new RegExp(`(?=${ExpiryFullYearPattern})|(?<=${ExpiryFullYearPattern})`, "g"))
            .sort((current, next) => (current.length > next.length ? -1 : 1));
        return [parsedYear, parsedMonth];
    }
    if (dateInput.length === 4) {
        // e.g.
        // "0524"
        // "2405"
        // If the `sanitizedFirstPart` value is a length of 4, it must be split in half, since
        // neither a year or month will be represented with three characters
        const splitFirstPartFirstHalf = dateInput.slice(0, 2);
        const splitFirstPartSecondHalf = dateInput.slice(-2);
        let parsedYear = splitFirstPartSecondHalf;
        let parsedMonth = splitFirstPartFirstHalf;
        // If the first part doesn't match a month pattern, assume it's a year
        if (!MonthPatternExpression.test(splitFirstPartFirstHalf)) {
            parsedYear = splitFirstPartFirstHalf;
            parsedMonth = splitFirstPartSecondHalf;
        }
        return [parsedYear, parsedMonth];
    }
    // e.g.
    // "245"
    // "202"
    // "212"
    // "022"
    // "111"
    // A valid year representation here must be two characters so try to find it first.
    let parsedYear = null;
    let parsedMonth = null;
    // Split if there is a digit with a leading zero
    const splitFirstPartOnLeadingZero = dateInput.split(/(?<=0[1-9]{1})|(?=0[1-9]{1})/);
    // Assume a leading zero indicates a month in ambiguous cases (e.g. "202"), since we're
    // dealing with expiry dates and the next two-digit year with a leading zero will be 2100
    if (splitFirstPartOnLeadingZero.length > 1) {
        parsedYear = splitFirstPartOnLeadingZero[0];
        parsedMonth = splitFirstPartOnLeadingZero[1];
        if (splitFirstPartOnLeadingZero[0].startsWith("0")) {
            parsedMonth = splitFirstPartOnLeadingZero[0];
            parsedYear = splitFirstPartOnLeadingZero[1];
        }
    }
    else {
        // Here, a year has to be two-digits, and a month can't be more than one, so assume the first two digits that are greater than the current year is the year representation.
        parsedYear = dateInput.slice(0, 2);
        parsedMonth = dateInput.slice(-1);
        const currentYear = new Date().getFullYear();
        const normalizedYearFormat = normalizeExpiryYearFormat(parsedYear);
        const normalizedParsedYear = normalizedYearFormat && parseInt(normalizedYearFormat, 10);
        const normalizedExpiryYearFormat = normalizeExpiryYearFormat(dateInput.slice(-2));
        const normalizedParsedYearAlternative = normalizedExpiryYearFormat && parseInt(normalizedExpiryYearFormat, 10);
        if (normalizedParsedYear &&
            normalizedParsedYear < currentYear &&
            normalizedParsedYearAlternative &&
            normalizedParsedYearAlternative >= currentYear) {
            parsedYear = dateInput.slice(-2);
            parsedMonth = dateInput.slice(0, 1);
        }
    }
    return [parsedYear, parsedMonth];
}
/**
 * Attempt to parse year and month parts of a combined expiry date value.
 *
 * @param {string} combinedExpiryValue
 * @return {*}  {([string | null, string | null])}
 */
function parseYearMonthExpiry(combinedExpiryValue) {
    var _a, _b;
    let parsedYear = null;
    let parsedMonth = null;
    const dateParts = splitCombinedDateValues(combinedExpiryValue);
    if (dateParts.length < 1) {
        return [null, null];
    }
    const sanitizedFirstPart = ((_a = dateParts[0]) === null || _a === void 0 ? void 0 : _a.replace(IrrelevantExpiryCharactersPatternExpression, "")) || "";
    const sanitizedSecondPart = ((_b = dateParts[1]) === null || _b === void 0 ? void 0 : _b.replace(IrrelevantExpiryCharactersPatternExpression, "")) || "";
    // If there is only one date part, no delimiter was found in the passed value
    if (dateParts.length === 1) {
        const [parsedNonDelimitedYear, parsedNonDelimitedMonth] = parseNonDelimitedYearMonthExpiry(sanitizedFirstPart);
        parsedYear = parsedNonDelimitedYear;
        parsedMonth = parsedNonDelimitedMonth;
    }
    // There are multiple date parts
    else {
        const [parsedDelimitedYear, parsedDelimitedMonth] = parseDelimitedYearMonthExpiry([
            sanitizedFirstPart,
            sanitizedSecondPart,
        ]);
        parsedYear = parsedDelimitedYear;
        parsedMonth = parsedDelimitedMonth;
    }
    const normalizedParsedYear = parsedYear ? normalizeExpiryYearFormat(parsedYear) : null;
    const normalizedParsedMonth = parsedMonth === null || parsedMonth === void 0 ? void 0 : parsedMonth.replace(/^0+/, "").slice(0, 2);
    // Set "empty" values to null
    parsedYear = (normalizedParsedYear === null || normalizedParsedYear === void 0 ? void 0 : normalizedParsedYear.length) ? normalizedParsedYear : null;
    parsedMonth = (normalizedParsedMonth === null || normalizedParsedMonth === void 0 ? void 0 : normalizedParsedMonth.length) ? normalizedParsedMonth : null;
    return [parsedYear, parsedMonth];
}
/**
 * Takes a URL string and a NeverDomains object and determines if the passed URL's hostname is in `urlList`
 *
 * @param {string} url - representation of URL to check
 * @param {NeverDomains} urlList - object with hostname key names
 */
function isUrlInList(url = "", urlList = {}) {
    const urlListKeys = urlList && Object.keys(urlList);
    if (urlListKeys.length && (url === null || url === void 0 ? void 0 : url.length)) {
        let tabHostname;
        try {
            tabHostname = Utils.getHostname(url);
        }
        catch (_a) {
            // If the input was invalid, exit early and return false
            return false;
        }
        if (tabHostname) {
            return urlListKeys.some((blockedHostname) => tabHostname.endsWith(blockedHostname));
        }
    }
    return false;
}

;// ../../libs/common/src/vault/linked-field-option.decorator.ts
class LinkedMetadata {
    constructor(propertyKey, attributes) {
        this.propertyKey = propertyKey;
        this._i18nKey = attributes === null || attributes === void 0 ? void 0 : attributes.i18nKey;
        this.sortPosition = attributes.sortPosition;
    }
    get i18nKey() {
        var _a;
        return (_a = this._i18nKey) !== null && _a !== void 0 ? _a : this.propertyKey;
    }
}
/**
 * A decorator used to set metadata used by Linked custom fields. Apply it to a class property or getter to make it
 *    available as a Linked custom field option.
 * @param id - A unique value that is saved in the Field model. It is used to look up the decorated class property.
 * @param options - {@link LinkedMetadataAttributes}
 */
function linkedFieldOption(id, attributes) {
    return (prototype, propertyKey) => {
        if (prototype.linkedFieldOptions == null) {
            prototype.linkedFieldOptions = new Map();
        }
        prototype.linkedFieldOptions.set(id, new LinkedMetadata(propertyKey, attributes));
    };
}

;// ../../libs/common/src/vault/models/view/item.view.ts
class ItemView {
}

;// ../../libs/common/src/vault/models/view/card.view.ts
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




class CardView extends ItemView {
    constructor() {
        super(...arguments);
        this.cardholderName = null;
        this.expMonth = null;
        this.expYear = null;
        this.code = null;
        this._brand = null;
        this._number = null;
        this._subTitle = null;
    }
    get maskedCode() {
        return this.code != null ? "•".repeat(this.code.length) : null;
    }
    get maskedNumber() {
        return this.number != null ? "•".repeat(this.number.length) : null;
    }
    get brand() {
        return this._brand;
    }
    set brand(value) {
        this._brand = value;
        this._subTitle = null;
    }
    get number() {
        return this._number;
    }
    set number(value) {
        this._number = value;
        this._subTitle = null;
    }
    get subTitle() {
        if (this._subTitle == null) {
            this._subTitle = this.brand;
            if (this.number != null && this.number.length >= 4) {
                if (this._subTitle != null && this._subTitle !== "") {
                    this._subTitle += ", ";
                }
                else {
                    this._subTitle = "";
                }
                // Show last 5 on amex, last 4 for all others
                const count = this.number.length >= 5 && this.number.match(new RegExp("^3[47]")) != null ? 5 : 4;
                this._subTitle += "*" + this.number.substr(this.number.length - count);
            }
        }
        return this._subTitle;
    }
    get expiration() {
        const normalizedYear = normalizeExpiryYearFormat(this.expYear);
        if (!this.expMonth && !normalizedYear) {
            return null;
        }
        let exp = this.expMonth != null ? ("0" + this.expMonth).slice(-2) : "__";
        exp += " / " + (normalizedYear || "____");
        return exp;
    }
    static fromJSON(obj) {
        return Object.assign(new CardView(), obj);
    }
    // ref https://stackoverflow.com/a/5911300
    static getCardBrandByPatterns(cardNum) {
        if (cardNum == null || typeof cardNum !== "string" || cardNum.trim() === "") {
            return null;
        }
        // Visa
        let re = new RegExp("^4");
        if (cardNum.match(re) != null) {
            return "Visa";
        }
        // Mastercard
        // Updated for Mastercard 2017 BINs expansion
        if (/^(5[1-5][0-9]{14}|2(22[1-9][0-9]{12}|2[3-9][0-9]{13}|[3-6][0-9]{14}|7[0-1][0-9]{13}|720[0-9]{12}))$/.test(cardNum)) {
            return "Mastercard";
        }
        // AMEX
        re = new RegExp("^3[47]");
        if (cardNum.match(re) != null) {
            return "Amex";
        }
        // Discover
        re = new RegExp("^(6011|622(12[6-9]|1[3-9][0-9]|[2-8][0-9]{2}|9[0-1][0-9]|92[0-5]|64[4-9])|65)");
        if (cardNum.match(re) != null) {
            return "Discover";
        }
        // Diners
        re = new RegExp("^36");
        if (cardNum.match(re) != null) {
            return "Diners Club";
        }
        // Diners - Carte Blanche
        re = new RegExp("^30[0-5]");
        if (cardNum.match(re) != null) {
            return "Diners Club";
        }
        // JCB
        re = new RegExp("^35(2[89]|[3-8][0-9])");
        if (cardNum.match(re) != null) {
            return "JCB";
        }
        // Visa Electron
        re = new RegExp("^(4026|417500|4508|4844|491(3|7))");
        if (cardNum.match(re) != null) {
            return "Visa";
        }
        return null;
    }
    /**
     * Converts an SDK CardView to a CardView.
     */
    static fromSdkCardView(obj) {
        if (obj == null) {
            return undefined;
        }
        return Object.assign(new CardView(), obj);
    }
}
__decorate([
    linkedFieldOption(CardLinkedId.CardholderName, { sortPosition: 0 }),
    __metadata("design:type", String)
], CardView.prototype, "cardholderName", void 0);
__decorate([
    linkedFieldOption(CardLinkedId.ExpMonth, { sortPosition: 3, i18nKey: "expirationMonth" }),
    __metadata("design:type", String)
], CardView.prototype, "expMonth", void 0);
__decorate([
    linkedFieldOption(CardLinkedId.ExpYear, { sortPosition: 4, i18nKey: "expirationYear" }),
    __metadata("design:type", String)
], CardView.prototype, "expYear", void 0);
__decorate([
    linkedFieldOption(CardLinkedId.Code, { sortPosition: 5, i18nKey: "securityCode" }),
    __metadata("design:type", String)
], CardView.prototype, "code", void 0);
__decorate([
    linkedFieldOption(CardLinkedId.Brand, { sortPosition: 2 }),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], CardView.prototype, "brand", null);
__decorate([
    linkedFieldOption(CardLinkedId.Number, { sortPosition: 1 }),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], CardView.prototype, "number", null);

;// ../../libs/common/src/vault/models/view/field.view.ts
class FieldView {
    constructor(f) {
        this.name = null;
        this.value = null;
        this.type = null;
        this.newField = false; // Marks if the field is new and hasn't been saved
        this.showValue = false;
        this.showCount = false;
        this.linkedId = null;
        if (!f) {
            return;
        }
        this.type = f.type;
        this.linkedId = f.linkedId;
    }
    get maskedValue() {
        return this.value != null ? "••••••••" : null;
    }
    static fromJSON(obj) {
        return Object.assign(new FieldView(), obj);
    }
    /**
     * Converts the SDK FieldView to a FieldView.
     */
    static fromSdkFieldView(obj) {
        if (!obj) {
            return undefined;
        }
        const view = new FieldView();
        view.name = obj.name;
        view.value = obj.value;
        view.type = obj.type;
        view.linkedId = obj.linkedId;
        return view;
    }
}

;// ../../libs/common/src/vault/models/view/identity.view.ts
var identity_view_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var identity_view_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




class IdentityView extends ItemView {
    constructor() {
        super();
        this.title = null;
        this.middleName = null;
        this.address1 = null;
        this.address2 = null;
        this.address3 = null;
        this.city = null;
        this.state = null;
        this.postalCode = null;
        this.country = null;
        this.company = null;
        this.email = null;
        this.phone = null;
        this.ssn = null;
        this.username = null;
        this.passportNumber = null;
        this.licenseNumber = null;
        this._firstName = null;
        this._lastName = null;
        this._subTitle = null;
    }
    get firstName() {
        return this._firstName;
    }
    set firstName(value) {
        this._firstName = value;
        this._subTitle = null;
    }
    get lastName() {
        return this._lastName;
    }
    set lastName(value) {
        this._lastName = value;
        this._subTitle = null;
    }
    get subTitle() {
        if (this._subTitle == null && (this.firstName != null || this.lastName != null)) {
            this._subTitle = "";
            if (this.firstName != null) {
                this._subTitle = this.firstName;
            }
            if (this.lastName != null) {
                if (this._subTitle !== "") {
                    this._subTitle += " ";
                }
                this._subTitle += this.lastName;
            }
        }
        return this._subTitle;
    }
    get fullName() {
        if (this.title != null ||
            this.firstName != null ||
            this.middleName != null ||
            this.lastName != null) {
            let name = "";
            if (this.title != null) {
                name += this.title + " ";
            }
            if (this.firstName != null) {
                name += this.firstName + " ";
            }
            if (this.middleName != null) {
                name += this.middleName + " ";
            }
            if (this.lastName != null) {
                name += this.lastName;
            }
            return name.trim();
        }
        return null;
    }
    get fullAddress() {
        let address = this.address1;
        if (!utils_Utils.isNullOrWhitespace(this.address2)) {
            if (!utils_Utils.isNullOrWhitespace(address)) {
                address += ", ";
            }
            address += this.address2;
        }
        if (!utils_Utils.isNullOrWhitespace(this.address3)) {
            if (!utils_Utils.isNullOrWhitespace(address)) {
                address += ", ";
            }
            address += this.address3;
        }
        return address;
    }
    get fullAddressPart2() {
        if (this.city == null && this.state == null && this.postalCode == null) {
            return null;
        }
        const city = this.city || "-";
        const state = this.state;
        const postalCode = this.postalCode || "-";
        let addressPart2 = city;
        if (!utils_Utils.isNullOrWhitespace(state)) {
            addressPart2 += ", " + state;
        }
        addressPart2 += ", " + postalCode;
        return addressPart2;
    }
    get fullAddressForCopy() {
        let address = this.fullAddress;
        if (this.city != null || this.state != null || this.postalCode != null) {
            address += "\n" + this.fullAddressPart2;
        }
        if (this.country != null) {
            address += "\n" + this.country;
        }
        return address;
    }
    static fromJSON(obj) {
        return Object.assign(new IdentityView(), obj);
    }
    /**
     * Converts the SDK IdentityView to an IdentityView.
     */
    static fromSdkIdentityView(obj) {
        if (obj == null) {
            return undefined;
        }
        return Object.assign(new IdentityView(), obj);
    }
}
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Title, { sortPosition: 0 }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "title", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.MiddleName, { sortPosition: 2 }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "middleName", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Address1, { sortPosition: 12 }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "address1", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Address2, { sortPosition: 13 }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "address2", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Address3, { sortPosition: 14 }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "address3", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.City, { sortPosition: 15, i18nKey: "cityTown" }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "city", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.State, { sortPosition: 16, i18nKey: "stateProvince" }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "state", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.PostalCode, { sortPosition: 17, i18nKey: "zipPostalCode" }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "postalCode", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Country, { sortPosition: 18 }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "country", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Company, { sortPosition: 6 }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "company", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Email, { sortPosition: 10 }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "email", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Phone, { sortPosition: 11 }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "phone", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Ssn, { sortPosition: 7 }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "ssn", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Username, { sortPosition: 5 }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "username", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.PassportNumber, { sortPosition: 8 }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "passportNumber", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.LicenseNumber, { sortPosition: 9 }),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "licenseNumber", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.FirstName, { sortPosition: 1 }),
    identity_view_metadata("design:type", String),
    identity_view_metadata("design:paramtypes", [String])
], IdentityView.prototype, "firstName", null);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.LastName, { sortPosition: 4 }),
    identity_view_metadata("design:type", String),
    identity_view_metadata("design:paramtypes", [String])
], IdentityView.prototype, "lastName", null);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.FullName, { sortPosition: 3 }),
    identity_view_metadata("design:type", String),
    identity_view_metadata("design:paramtypes", [])
], IdentityView.prototype, "fullName", null);

;// ../../libs/common/src/vault/models/view/fido2-credential.view.ts

class Fido2CredentialView extends ItemView {
    constructor() {
        super(...arguments);
        this.creationDate = null;
    }
    get subTitle() {
        return this.userDisplayName;
    }
    static fromJSON(obj) {
        const creationDate = obj.creationDate != null ? new Date(obj.creationDate) : null;
        return Object.assign(new Fido2CredentialView(), obj, {
            creationDate,
        });
    }
    /**
     * Converts the SDK Fido2CredentialView to a Fido2CredentialView.
     */
    static fromSdkFido2CredentialView(obj) {
        var _a;
        if (!obj) {
            return undefined;
        }
        const view = new Fido2CredentialView();
        view.credentialId = obj.credentialId;
        view.keyType = obj.keyType;
        view.keyAlgorithm = obj.keyAlgorithm;
        view.keyCurve = obj.keyCurve;
        view.rpId = obj.rpId;
        view.userHandle = obj.userHandle;
        view.userName = obj.userName;
        view.counter = parseInt(obj.counter);
        view.rpName = obj.rpName;
        view.userDisplayName = obj.userDisplayName;
        view.discoverable = ((_a = obj.discoverable) === null || _a === void 0 ? void 0 : _a.toLowerCase()) === "true" ? true : false;
        view.creationDate = obj.creationDate ? new Date(obj.creationDate) : null;
        return view;
    }
}

;// ../../libs/common/src/models/domain/domain-service.ts
/*
  See full documentation at:
    https://bitwarden.com/help/uri-match-detection/#match-detection-options

  Domain: "the top-level domain and second-level domain of the URI match the detected resource",
  Host: "the hostname and (if specified) port of the URI matches the detected resource",
  StartsWith: "the detected resource starts with the URI, regardless of what follows it",
  Exact: "the URI matches the detected resource exactly",
  RegularExpression: "the detected resource matches a specified regular expression",
  Never: "never offer auto-fill for the item",
*/
const UriMatchStrategy = {
    Domain: 0,
    Host: 1,
    StartsWith: 2,
    Exact: 3,
    RegularExpression: 4,
    Never: 5,
};

;// ../../libs/common/src/platform/misc/safe-urls.ts

const CanLaunchWhitelist = [
    "https://",
    "http://",
    "ssh://",
    "ftp://",
    "sftp://",
    "irc://",
    "vnc://",
    // https://docs.microsoft.com/en-us/windows-server/remote/remote-desktop-services/clients/remote-desktop-uri
    "rdp://", // Legacy RDP URI scheme
    "ms-rd:", // Preferred RDP URI scheme
    "chrome://",
    "iosapp://",
    "androidapp://",
];
class SafeUrls {
    static canLaunch(uri) {
        if (utils_Utils.isNullOrWhitespace(uri)) {
            return false;
        }
        for (let i = 0; i < CanLaunchWhitelist.length; i++) {
            if (uri.indexOf(CanLaunchWhitelist[i]) === 0) {
                return true;
            }
        }
        return false;
    }
}

;// ../../libs/common/src/vault/models/view/login-uri.view.ts



class LoginUriView {
    constructor(u) {
        this.match = null;
        this._uri = null;
        this._domain = null;
        this._hostname = null;
        this._host = null;
        this._canLaunch = null;
        if (!u) {
            return;
        }
        this.match = u.match;
    }
    get uri() {
        return this._uri;
    }
    set uri(value) {
        this._uri = value;
        this._domain = null;
        this._canLaunch = null;
    }
    get domain() {
        if (this._domain == null && this.uri != null) {
            this._domain = utils_Utils.getDomain(this.uri);
            if (this._domain === "") {
                this._domain = null;
            }
        }
        return this._domain;
    }
    get hostname() {
        if (this.match === UriMatchStrategy.RegularExpression) {
            return null;
        }
        if (this._hostname == null && this.uri != null) {
            this._hostname = utils_Utils.getHostname(this.uri);
            if (this._hostname === "") {
                this._hostname = null;
            }
        }
        return this._hostname;
    }
    get host() {
        if (this.match === UriMatchStrategy.RegularExpression) {
            return null;
        }
        if (this._host == null && this.uri != null) {
            this._host = utils_Utils.getHost(this.uri);
            if (this._host === "") {
                this._host = null;
            }
        }
        return this._host;
    }
    get hostnameOrUri() {
        return this.hostname != null ? this.hostname : this.uri;
    }
    get hostOrUri() {
        return this.host != null ? this.host : this.uri;
    }
    get isWebsite() {
        return (this.uri != null &&
            (this.uri.indexOf("http://") === 0 ||
                this.uri.indexOf("https://") === 0 ||
                (this.uri.indexOf("://") < 0 && !utils_Utils.isNullOrWhitespace(utils_Utils.getDomain(this.uri)))));
    }
    get canLaunch() {
        if (this._canLaunch != null) {
            return this._canLaunch;
        }
        if (this.uri != null && this.match !== UriMatchStrategy.RegularExpression) {
            this._canLaunch = SafeUrls.canLaunch(this.launchUri);
        }
        else {
            this._canLaunch = false;
        }
        return this._canLaunch;
    }
    get launchUri() {
        return this.uri.indexOf("://") < 0 && !utils_Utils.isNullOrWhitespace(utils_Utils.getDomain(this.uri))
            ? "http://" + this.uri
            : this.uri;
    }
    static fromJSON(obj) {
        return Object.assign(new LoginUriView(), obj);
    }
    /**
     * Converts a LoginUriView object from the SDK to a LoginUriView object.
     */
    static fromSdkLoginUriView(obj) {
        if (obj == null) {
            return undefined;
        }
        const view = new LoginUriView();
        view.uri = obj.uri;
        view.match = obj.match;
        return view;
    }
    matchesUri(targetUri, equivalentDomains, defaultUriMatch = null) {
        var _a;
        if (!this.uri || !targetUri) {
            return false;
        }
        let matchType = (_a = this.match) !== null && _a !== void 0 ? _a : defaultUriMatch;
        matchType !== null && matchType !== void 0 ? matchType : (matchType = UriMatchStrategy.Domain);
        const targetDomain = utils_Utils.getDomain(targetUri);
        const matchDomains = equivalentDomains.add(targetDomain);
        switch (matchType) {
            case UriMatchStrategy.Domain:
                return this.matchesDomain(targetUri, matchDomains);
            case UriMatchStrategy.Host: {
                const urlHost = utils_Utils.getHost(targetUri);
                return urlHost != null && urlHost === utils_Utils.getHost(this.uri);
            }
            case UriMatchStrategy.Exact:
                return targetUri === this.uri;
            case UriMatchStrategy.StartsWith:
                return targetUri.startsWith(this.uri);
            case UriMatchStrategy.RegularExpression:
                try {
                    const regex = new RegExp(this.uri, "i");
                    return regex.test(targetUri);
                    // FIXME: Remove when updating file. Eslint update
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                }
                catch (e) {
                    // Invalid regex
                    return false;
                }
            case UriMatchStrategy.Never:
                return false;
            default:
                break;
        }
        return false;
    }
    matchesDomain(targetUri, matchDomains) {
        if (targetUri == null || this.domain == null || !matchDomains.has(this.domain)) {
            return false;
        }
        if (utils_Utils.DomainMatchBlacklist.has(this.domain)) {
            const domainUrlHost = utils_Utils.getHost(targetUri);
            return !utils_Utils.DomainMatchBlacklist.get(this.domain).has(domainUrlHost);
        }
        return true;
    }
}

;// ../../libs/common/src/vault/models/view/login.view.ts
var login_view_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var login_view_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};






class LoginView extends ItemView {
    constructor(l) {
        super();
        this.username = null;
        this.password = null;
        this.passwordRevisionDate = null;
        this.totp = null;
        this.uris = [];
        this.autofillOnPageLoad = null;
        this.fido2Credentials = null;
        if (!l) {
            return;
        }
        this.passwordRevisionDate = l.passwordRevisionDate;
        this.autofillOnPageLoad = l.autofillOnPageLoad;
    }
    get uri() {
        return this.hasUris ? this.uris[0].uri : null;
    }
    get maskedPassword() {
        return this.password != null ? "••••••••" : null;
    }
    get subTitle() {
        var _a;
        // if there's a passkey available, use that as a fallback
        if (utils_Utils.isNullOrEmpty(this.username) && ((_a = this.fido2Credentials) === null || _a === void 0 ? void 0 : _a.length) > 0) {
            return this.fido2Credentials[0].userName;
        }
        return this.username;
    }
    get canLaunch() {
        return this.hasUris && this.uris.some((u) => u.canLaunch);
    }
    get hasTotp() {
        return !utils_Utils.isNullOrWhitespace(this.totp);
    }
    get launchUri() {
        if (this.hasUris) {
            const uri = this.uris.find((u) => u.canLaunch);
            if (uri != null) {
                return uri.launchUri;
            }
        }
        return null;
    }
    get hasUris() {
        return this.uris != null && this.uris.length > 0;
    }
    get hasFido2Credentials() {
        return this.fido2Credentials != null && this.fido2Credentials.length > 0;
    }
    matchesUri(targetUri, equivalentDomains, defaultUriMatch = null) {
        if (this.uris == null) {
            return false;
        }
        return this.uris.some((uri) => uri.matchesUri(targetUri, equivalentDomains, defaultUriMatch));
    }
    static fromJSON(obj) {
        var _a;
        const passwordRevisionDate = obj.passwordRevisionDate == null ? null : new Date(obj.passwordRevisionDate);
        const uris = obj.uris.map((uri) => LoginUriView.fromJSON(uri));
        const fido2Credentials = (_a = obj.fido2Credentials) === null || _a === void 0 ? void 0 : _a.map((key) => Fido2CredentialView.fromJSON(key));
        return Object.assign(new LoginView(), obj, {
            passwordRevisionDate,
            uris,
            fido2Credentials,
        });
    }
    /**
     * Converts the SDK LoginView to a LoginView.
     *
     * Note: FIDO2 credentials remain encrypted at this stage.
     * Unlike other fields that are decrypted as part of the LoginView, the SDK maintains
     * the FIDO2 credentials in encrypted form. We can decrypt them later using a separate
     * call to client.vault().ciphers().decrypt_fido2_credentials().
     */
    static fromSdkLoginView(obj) {
        var _a;
        if (obj == null) {
            return undefined;
        }
        const passwordRevisionDate = obj.passwordRevisionDate == null ? null : new Date(obj.passwordRevisionDate);
        const uris = (_a = obj.uris) === null || _a === void 0 ? void 0 : _a.map((uri) => LoginUriView.fromSdkLoginUriView(uri));
        return Object.assign(new LoginView(), obj, {
            passwordRevisionDate,
            uris,
        });
    }
}
login_view_decorate([
    linkedFieldOption(LoginLinkedId.Username, { sortPosition: 0 }),
    login_view_metadata("design:type", String)
], LoginView.prototype, "username", void 0);
login_view_decorate([
    linkedFieldOption(LoginLinkedId.Password, { sortPosition: 1 }),
    login_view_metadata("design:type", String)
], LoginView.prototype, "password", void 0);

;// ../../libs/common/src/vault/models/view/password-history.view.ts
class PasswordHistoryView {
    constructor(ph) {
        this.password = null;
        this.lastUsedDate = null;
        if (!ph) {
            return;
        }
        this.lastUsedDate = ph.lastUsedDate;
    }
    static fromJSON(obj) {
        const lastUsedDate = obj.lastUsedDate == null ? null : new Date(obj.lastUsedDate);
        return Object.assign(new PasswordHistoryView(), obj, {
            lastUsedDate: lastUsedDate,
        });
    }
    /**
     * Converts the SDK PasswordHistoryView to a PasswordHistoryView.
     */
    static fromSdkPasswordHistoryView(obj) {
        if (!obj) {
            return undefined;
        }
        const view = new PasswordHistoryView();
        view.password = obj.password;
        view.lastUsedDate = obj.lastUsedDate == null ? null : new Date(obj.lastUsedDate);
        return view;
    }
}

;// ../../libs/common/src/vault/models/view/secure-note.view.ts

class SecureNoteView extends ItemView {
    constructor(n) {
        super();
        this.type = null;
        if (!n) {
            return;
        }
        this.type = n.type;
    }
    get subTitle() {
        return null;
    }
    static fromJSON(obj) {
        return Object.assign(new SecureNoteView(), obj);
    }
    /**
     * Converts the SDK SecureNoteView to a SecureNoteView.
     */
    static fromSdkSecureNoteView(obj) {
        if (!obj) {
            return undefined;
        }
        return Object.assign(new SecureNoteView(), obj);
    }
}

;// ../../libs/common/src/vault/models/view/ssh-key.view.ts

class SshKeyView extends ItemView {
    constructor(n) {
        super();
        this.privateKey = null;
        this.publicKey = null;
        this.keyFingerprint = null;
        if (!n) {
            return;
        }
    }
    get maskedPrivateKey() {
        if (!this.privateKey || this.privateKey.length === 0) {
            return "";
        }
        let lines = this.privateKey.split("\n").filter((l) => l.trim() !== "");
        lines = lines.map((l, i) => {
            if (i === 0 || i === lines.length - 1) {
                return l;
            }
            return this.maskLine(l);
        });
        return lines.join("\n");
    }
    maskLine(line) {
        return "•".repeat(32);
    }
    get subTitle() {
        return this.keyFingerprint;
    }
    static fromJSON(obj) {
        return Object.assign(new SshKeyView(), obj);
    }
    /**
     * Converts the SDK SshKeyView to a SshKeyView.
     */
    static fromSdkSshKeyView(obj) {
        if (!obj) {
            return undefined;
        }
        const keyFingerprint = obj.fingerprint;
        return Object.assign(new SshKeyView(), obj, {
            keyFingerprint,
        });
    }
}

;// ../../libs/common/src/vault/models/view/cipher.view.ts












class CipherView {
    constructor(c) {
        var _a;
        this.initializerKey = InitializerKey.CipherView;
        this.id = null;
        this.organizationId = null;
        this.folderId = null;
        this.name = null;
        this.notes = null;
        this.type = null;
        this.favorite = false;
        this.organizationUseTotp = false;
        this.permissions = new CipherPermissionsApi();
        this.edit = false;
        this.viewPassword = true;
        this.login = new LoginView();
        this.identity = new IdentityView();
        this.card = new CardView();
        this.secureNote = new SecureNoteView();
        this.sshKey = new SshKeyView();
        this.attachments = null;
        this.fields = null;
        this.passwordHistory = null;
        this.collectionIds = null;
        this.revisionDate = null;
        this.creationDate = null;
        this.deletedDate = null;
        this.reprompt = CipherRepromptType.None;
        /**
         * Flag to indicate if the cipher decryption failed.
         */
        this.decryptionFailure = false;
        if (!c) {
            return;
        }
        this.id = c.id;
        this.organizationId = c.organizationId;
        this.folderId = c.folderId;
        this.favorite = c.favorite;
        this.organizationUseTotp = c.organizationUseTotp;
        this.edit = c.edit;
        this.viewPassword = c.viewPassword;
        this.permissions = c.permissions;
        this.type = c.type;
        this.localData = c.localData;
        this.collectionIds = c.collectionIds;
        this.revisionDate = c.revisionDate;
        this.creationDate = c.creationDate;
        this.deletedDate = c.deletedDate;
        // Old locally stored ciphers might have reprompt == null. If so set it to None.
        this.reprompt = (_a = c.reprompt) !== null && _a !== void 0 ? _a : CipherRepromptType.None;
    }
    get item() {
        switch (this.type) {
            case CipherType.Login:
                return this.login;
            case CipherType.SecureNote:
                return this.secureNote;
            case CipherType.Card:
                return this.card;
            case CipherType.Identity:
                return this.identity;
            case CipherType.SshKey:
                return this.sshKey;
            default:
                break;
        }
        return null;
    }
    get subTitle() {
        var _a;
        return (_a = this.item) === null || _a === void 0 ? void 0 : _a.subTitle;
    }
    get hasPasswordHistory() {
        return this.passwordHistory && this.passwordHistory.length > 0;
    }
    get hasAttachments() {
        return this.attachments && this.attachments.length > 0;
    }
    get hasOldAttachments() {
        if (this.hasAttachments) {
            for (let i = 0; i < this.attachments.length; i++) {
                if (this.attachments[i].key == null && this.attachments[i].encryptedKey == null) {
                    return true;
                }
            }
        }
        return false;
    }
    get hasFields() {
        return this.fields && this.fields.length > 0;
    }
    get passwordRevisionDisplayDate() {
        if (this.type !== CipherType.Login || this.login == null) {
            return null;
        }
        else if (this.login.password == null || this.login.password === "") {
            return null;
        }
        return this.login.passwordRevisionDate;
    }
    get isDeleted() {
        return this.deletedDate != null;
    }
    get linkedFieldOptions() {
        var _a;
        return (_a = this.item) === null || _a === void 0 ? void 0 : _a.linkedFieldOptions;
    }
    get isUnassigned() {
        return (this.organizationId != null && (this.collectionIds == null || this.collectionIds.length === 0));
    }
    get canAssignToCollections() {
        if (this.organizationId == null) {
            return true;
        }
        return this.edit && this.viewPassword;
    }
    /**
     * Determines if the cipher can be launched in a new browser tab.
     */
    get canLaunch() {
        return this.type === CipherType.Login && this.login.canLaunch;
    }
    linkedFieldValue(id) {
        var _a;
        const linkedFieldOption = (_a = this.linkedFieldOptions) === null || _a === void 0 ? void 0 : _a.get(id);
        if (linkedFieldOption == null) {
            return null;
        }
        // FIXME: Remove when updating file. Eslint update
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        const item = this.item;
        return this.item[linkedFieldOption.propertyKey];
    }
    linkedFieldI18nKey(id) {
        var _a;
        return (_a = this.linkedFieldOptions.get(id)) === null || _a === void 0 ? void 0 : _a.i18nKey;
    }
    // This is used as a marker to indicate that the cipher view object still has its prototype
    toJSON() {
        return this;
    }
    static fromJSON(obj) {
        var _a, _b, _c;
        if (obj == null) {
            return null;
        }
        const view = new CipherView();
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        const deletedDate = obj.deletedDate == null ? null : new Date(obj.deletedDate);
        const attachments = (_a = obj.attachments) === null || _a === void 0 ? void 0 : _a.map((a) => AttachmentView.fromJSON(a));
        const fields = (_b = obj.fields) === null || _b === void 0 ? void 0 : _b.map((f) => FieldView.fromJSON(f));
        const passwordHistory = (_c = obj.passwordHistory) === null || _c === void 0 ? void 0 : _c.map((ph) => PasswordHistoryView.fromJSON(ph));
        Object.assign(view, obj, {
            revisionDate: revisionDate,
            deletedDate: deletedDate,
            attachments: attachments,
            fields: fields,
            passwordHistory: passwordHistory,
        });
        switch (obj.type) {
            case CipherType.Card:
                view.card = CardView.fromJSON(obj.card);
                break;
            case CipherType.Identity:
                view.identity = IdentityView.fromJSON(obj.identity);
                break;
            case CipherType.Login:
                view.login = LoginView.fromJSON(obj.login);
                break;
            case CipherType.SecureNote:
                view.secureNote = SecureNoteView.fromJSON(obj.secureNote);
                break;
            case CipherType.SshKey:
                view.sshKey = SshKeyView.fromJSON(obj.sshKey);
                break;
            default:
                break;
        }
        return view;
    }
    /**
     * Creates a CipherView from the SDK CipherView.
     */
    static fromSdkCipherView(obj) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
        if (obj == null) {
            return undefined;
        }
        const cipherView = new CipherView();
        cipherView.id = (_a = obj.id) !== null && _a !== void 0 ? _a : null;
        cipherView.organizationId = (_b = obj.organizationId) !== null && _b !== void 0 ? _b : null;
        cipherView.folderId = (_c = obj.folderId) !== null && _c !== void 0 ? _c : null;
        cipherView.name = obj.name;
        cipherView.notes = (_d = obj.notes) !== null && _d !== void 0 ? _d : null;
        cipherView.type = obj.type;
        cipherView.favorite = obj.favorite;
        cipherView.organizationUseTotp = obj.organizationUseTotp;
        cipherView.permissions = CipherPermissionsApi.fromSdkCipherPermissions(obj.permissions);
        cipherView.edit = obj.edit;
        cipherView.viewPassword = obj.viewPassword;
        cipherView.localData = obj.localData
            ? {
                lastUsedDate: obj.localData.lastUsedDate
                    ? new Date(obj.localData.lastUsedDate).getTime()
                    : undefined,
                lastLaunched: obj.localData.lastLaunched
                    ? new Date(obj.localData.lastLaunched).getTime()
                    : undefined,
            }
            : undefined;
        cipherView.attachments =
            (_f = (_e = obj.attachments) === null || _e === void 0 ? void 0 : _e.map((a) => AttachmentView.fromSdkAttachmentView(a))) !== null && _f !== void 0 ? _f : null;
        cipherView.fields = (_h = (_g = obj.fields) === null || _g === void 0 ? void 0 : _g.map((f) => FieldView.fromSdkFieldView(f))) !== null && _h !== void 0 ? _h : null;
        cipherView.passwordHistory =
            (_k = (_j = obj.passwordHistory) === null || _j === void 0 ? void 0 : _j.map((ph) => PasswordHistoryView.fromSdkPasswordHistoryView(ph))) !== null && _k !== void 0 ? _k : null;
        cipherView.collectionIds = (_l = obj.collectionIds) !== null && _l !== void 0 ? _l : null;
        cipherView.revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        cipherView.creationDate = obj.creationDate == null ? null : new Date(obj.creationDate);
        cipherView.deletedDate = obj.deletedDate == null ? null : new Date(obj.deletedDate);
        cipherView.reprompt = (_m = obj.reprompt) !== null && _m !== void 0 ? _m : CipherRepromptType.None;
        switch (obj.type) {
            case CipherType.Card:
                cipherView.card = CardView.fromSdkCardView(obj.card);
                break;
            case CipherType.Identity:
                cipherView.identity = IdentityView.fromSdkIdentityView(obj.identity);
                break;
            case CipherType.Login:
                cipherView.login = LoginView.fromSdkLoginView(obj.login);
                break;
            case CipherType.SecureNote:
                cipherView.secureNote = SecureNoteView.fromSdkSecureNoteView(obj.secureNote);
                break;
            case CipherType.SshKey:
                cipherView.sshKey = SshKeyView.fromSdkSshKeyView(obj.sshKey);
                break;
            default:
                break;
        }
        return cipherView;
    }
}

;// ../../libs/common/src/vault/models/domain/attachment.ts
var attachment_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class Attachment extends domain_base_Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.size = obj.size;
        this.buildDomainModel(this, obj, {
            id: null,
            url: null,
            sizeName: null,
            fileName: null,
            key: null,
        }, ["id", "url", "sizeName"]);
    }
    decrypt(orgId_1) {
        return attachment_awaiter(this, arguments, void 0, function* (orgId, context = "No Cipher Context", encKey) {
            const view = yield this.decryptObj(this, new AttachmentView(this), ["fileName"], orgId, encKey, "DomainType: Attachment; " + context);
            if (this.key != null) {
                view.key = yield this.decryptAttachmentKey(orgId, encKey);
            }
            return view;
        });
    }
    decryptAttachmentKey(orgId, encKey) {
        return attachment_awaiter(this, void 0, void 0, function* () {
            try {
                if (encKey == null) {
                    encKey = yield this.getKeyForDecryption(orgId);
                }
                const encryptService = utils_Utils.getContainerService().getEncryptService();
                const decValue = yield encryptService.unwrapSymmetricKey(this.key, encKey);
                return decValue;
                // FIXME: Remove when updating file. Eslint update
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
            }
            catch (e) {
                // TODO: error?
            }
        });
    }
    getKeyForDecryption(orgId) {
        return attachment_awaiter(this, void 0, void 0, function* () {
            const keyService = utils_Utils.getContainerService().getKeyService();
            return orgId != null
                ? yield keyService.getOrgKey(orgId)
                : yield keyService.getUserKeyWithLegacySupport();
        });
    }
    toAttachmentData() {
        const a = new AttachmentData();
        a.size = this.size;
        this.buildDataModel(this, a, {
            id: null,
            url: null,
            sizeName: null,
            fileName: null,
            key: null,
        }, ["id", "url", "sizeName"]);
        return a;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const key = enc_string_EncString.fromJSON(obj.key);
        const fileName = enc_string_EncString.fromJSON(obj.fileName);
        return Object.assign(new Attachment(), obj, {
            key,
            fileName,
        });
    }
    /**
     * Maps to SDK Attachment
     *
     * @returns {SdkAttachment} - The SDK Attachment object
     */
    toSdkAttachment() {
        var _a, _b;
        return {
            id: this.id,
            url: this.url,
            size: this.size,
            sizeName: this.sizeName,
            fileName: (_a = this.fileName) === null || _a === void 0 ? void 0 : _a.toJSON(),
            key: (_b = this.key) === null || _b === void 0 ? void 0 : _b.toJSON(),
        };
    }
}

;// ../../libs/common/src/vault/models/domain/card.ts
var card_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class Card extends domain_base_Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            cardholderName: null,
            brand: null,
            number: null,
            expMonth: null,
            expYear: null,
            code: null,
        }, []);
    }
    decrypt(orgId_1) {
        return card_awaiter(this, arguments, void 0, function* (orgId, context = "No Cipher Context", encKey) {
            return this.decryptObj(this, new CardView(), ["cardholderName", "brand", "number", "expMonth", "expYear", "code"], orgId, encKey, "DomainType: Card; " + context);
        });
    }
    toCardData() {
        const c = new CardData();
        this.buildDataModel(this, c, {
            cardholderName: null,
            brand: null,
            number: null,
            expMonth: null,
            expYear: null,
            code: null,
        });
        return c;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const cardholderName = enc_string_EncString.fromJSON(obj.cardholderName);
        const brand = enc_string_EncString.fromJSON(obj.brand);
        const number = enc_string_EncString.fromJSON(obj.number);
        const expMonth = enc_string_EncString.fromJSON(obj.expMonth);
        const expYear = enc_string_EncString.fromJSON(obj.expYear);
        const code = enc_string_EncString.fromJSON(obj.code);
        return Object.assign(new Card(), obj, {
            cardholderName,
            brand,
            number,
            expMonth,
            expYear,
            code,
        });
    }
    /**
     *  Maps Card to SDK format.
     *
     * @returns {SdkCard} The SDK card object.
     */
    toSdkCard() {
        var _a, _b, _c, _d, _e, _f;
        return {
            cardholderName: (_a = this.cardholderName) === null || _a === void 0 ? void 0 : _a.toJSON(),
            brand: (_b = this.brand) === null || _b === void 0 ? void 0 : _b.toJSON(),
            number: (_c = this.number) === null || _c === void 0 ? void 0 : _c.toJSON(),
            expMonth: (_d = this.expMonth) === null || _d === void 0 ? void 0 : _d.toJSON(),
            expYear: (_e = this.expYear) === null || _e === void 0 ? void 0 : _e.toJSON(),
            code: (_f = this.code) === null || _f === void 0 ? void 0 : _f.toJSON(),
        };
    }
}

;// ../../libs/common/src/vault/models/domain/field.ts




class Field extends domain_base_Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.type = obj.type;
        this.linkedId = obj.linkedId;
        this.buildDomainModel(this, obj, {
            name: null,
            value: null,
        }, []);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(this, new FieldView(this), ["name", "value"], orgId, encKey);
    }
    toFieldData() {
        const f = new FieldData();
        this.buildDataModel(this, f, {
            name: null,
            value: null,
            type: null,
            linkedId: null,
        }, ["type", "linkedId"]);
        return f;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const name = enc_string_EncString.fromJSON(obj.name);
        const value = enc_string_EncString.fromJSON(obj.value);
        return Object.assign(new Field(), obj, {
            name,
            value,
        });
    }
    /**
     * Maps Field to SDK format.
     *
     * @returns {SdkField} The SDK field object.
     */
    toSdkField() {
        var _a, _b;
        return {
            name: (_a = this.name) === null || _a === void 0 ? void 0 : _a.toJSON(),
            value: (_b = this.value) === null || _b === void 0 ? void 0 : _b.toJSON(),
            type: this.type,
            // Safe type cast: client and SDK LinkedIdType enums have identical values
            linkedId: this.linkedId,
        };
    }
}

;// ../../libs/common/src/vault/models/domain/identity.ts




class Identity extends domain_base_Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            title: null,
            firstName: null,
            middleName: null,
            lastName: null,
            address1: null,
            address2: null,
            address3: null,
            city: null,
            state: null,
            postalCode: null,
            country: null,
            company: null,
            email: null,
            phone: null,
            ssn: null,
            username: null,
            passportNumber: null,
            licenseNumber: null,
        }, []);
    }
    decrypt(orgId, context = "No Cipher Context", encKey) {
        return this.decryptObj(this, new IdentityView(), [
            "title",
            "firstName",
            "middleName",
            "lastName",
            "address1",
            "address2",
            "address3",
            "city",
            "state",
            "postalCode",
            "country",
            "company",
            "email",
            "phone",
            "ssn",
            "username",
            "passportNumber",
            "licenseNumber",
        ], orgId, encKey, "DomainType: Identity; " + context);
    }
    toIdentityData() {
        const i = new IdentityData();
        this.buildDataModel(this, i, {
            title: null,
            firstName: null,
            middleName: null,
            lastName: null,
            address1: null,
            address2: null,
            address3: null,
            city: null,
            state: null,
            postalCode: null,
            country: null,
            company: null,
            email: null,
            phone: null,
            ssn: null,
            username: null,
            passportNumber: null,
            licenseNumber: null,
        });
        return i;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const title = enc_string_EncString.fromJSON(obj.title);
        const firstName = enc_string_EncString.fromJSON(obj.firstName);
        const middleName = enc_string_EncString.fromJSON(obj.middleName);
        const lastName = enc_string_EncString.fromJSON(obj.lastName);
        const address1 = enc_string_EncString.fromJSON(obj.address1);
        const address2 = enc_string_EncString.fromJSON(obj.address2);
        const address3 = enc_string_EncString.fromJSON(obj.address3);
        const city = enc_string_EncString.fromJSON(obj.city);
        const state = enc_string_EncString.fromJSON(obj.state);
        const postalCode = enc_string_EncString.fromJSON(obj.postalCode);
        const country = enc_string_EncString.fromJSON(obj.country);
        const company = enc_string_EncString.fromJSON(obj.company);
        const email = enc_string_EncString.fromJSON(obj.email);
        const phone = enc_string_EncString.fromJSON(obj.phone);
        const ssn = enc_string_EncString.fromJSON(obj.ssn);
        const username = enc_string_EncString.fromJSON(obj.username);
        const passportNumber = enc_string_EncString.fromJSON(obj.passportNumber);
        const licenseNumber = enc_string_EncString.fromJSON(obj.licenseNumber);
        return Object.assign(new Identity(), obj, {
            title,
            firstName,
            middleName,
            lastName,
            address1,
            address2,
            address3,
            city,
            state,
            postalCode,
            country,
            company,
            email,
            phone,
            ssn,
            username,
            passportNumber,
            licenseNumber,
        });
    }
    /**
     * Maps Identity to SDK format.
     *
     * @returns {SdkIdentity} The SDK identity object.
     */
    toSdkIdentity() {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t;
        return {
            title: (_a = this.title) === null || _a === void 0 ? void 0 : _a.toJSON(),
            firstName: (_b = this.firstName) === null || _b === void 0 ? void 0 : _b.toJSON(),
            middleName: (_c = this.middleName) === null || _c === void 0 ? void 0 : _c.toJSON(),
            lastName: (_d = this.lastName) === null || _d === void 0 ? void 0 : _d.toJSON(),
            address1: (_e = this.address1) === null || _e === void 0 ? void 0 : _e.toJSON(),
            address2: (_f = this.address2) === null || _f === void 0 ? void 0 : _f.toJSON(),
            address3: (_g = this.address3) === null || _g === void 0 ? void 0 : _g.toJSON(),
            city: (_h = this.city) === null || _h === void 0 ? void 0 : _h.toJSON(),
            state: (_j = this.state) === null || _j === void 0 ? void 0 : _j.toJSON(),
            postalCode: (_k = this.postalCode) === null || _k === void 0 ? void 0 : _k.toJSON(),
            country: (_l = this.country) === null || _l === void 0 ? void 0 : _l.toJSON(),
            company: (_m = this.company) === null || _m === void 0 ? void 0 : _m.toJSON(),
            email: (_o = this.email) === null || _o === void 0 ? void 0 : _o.toJSON(),
            phone: (_p = this.phone) === null || _p === void 0 ? void 0 : _p.toJSON(),
            ssn: (_q = this.ssn) === null || _q === void 0 ? void 0 : _q.toJSON(),
            username: (_r = this.username) === null || _r === void 0 ? void 0 : _r.toJSON(),
            passportNumber: (_s = this.passportNumber) === null || _s === void 0 ? void 0 : _s.toJSON(),
            licenseNumber: (_t = this.licenseNumber) === null || _t === void 0 ? void 0 : _t.toJSON(),
        };
    }
}

;// ../../libs/common/src/vault/models/domain/fido2-credential.ts
var fido2_credential_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class Fido2Credential extends domain_base_Domain {
    constructor(obj) {
        super();
        this.credentialId = null;
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            credentialId: null,
            keyType: null,
            keyAlgorithm: null,
            keyCurve: null,
            keyValue: null,
            rpId: null,
            userHandle: null,
            userName: null,
            counter: null,
            rpName: null,
            userDisplayName: null,
            discoverable: null,
        }, []);
        this.creationDate = obj.creationDate != null ? new Date(obj.creationDate) : null;
    }
    decrypt(orgId, encKey) {
        return fido2_credential_awaiter(this, void 0, void 0, function* () {
            const view = yield this.decryptObj(this, new Fido2CredentialView(), [
                "credentialId",
                "keyType",
                "keyAlgorithm",
                "keyCurve",
                "keyValue",
                "rpId",
                "userHandle",
                "userName",
                "rpName",
                "userDisplayName",
            ], orgId, encKey);
            const { counter } = yield this.decryptObj(this, { counter: "" }, ["counter"], orgId, encKey);
            // Counter will end up as NaN if this fails
            view.counter = parseInt(counter);
            const { discoverable } = yield this.decryptObj(this, { discoverable: "" }, ["discoverable"], orgId, encKey);
            view.discoverable = discoverable === "true";
            view.creationDate = this.creationDate;
            return view;
        });
    }
    toFido2CredentialData() {
        const i = new Fido2CredentialData();
        i.creationDate = this.creationDate.toISOString();
        this.buildDataModel(this, i, {
            credentialId: null,
            keyType: null,
            keyAlgorithm: null,
            keyCurve: null,
            keyValue: null,
            rpId: null,
            userHandle: null,
            userName: null,
            counter: null,
            rpName: null,
            userDisplayName: null,
            discoverable: null,
        });
        return i;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const credentialId = enc_string_EncString.fromJSON(obj.credentialId);
        const keyType = enc_string_EncString.fromJSON(obj.keyType);
        const keyAlgorithm = enc_string_EncString.fromJSON(obj.keyAlgorithm);
        const keyCurve = enc_string_EncString.fromJSON(obj.keyCurve);
        const keyValue = enc_string_EncString.fromJSON(obj.keyValue);
        const rpId = enc_string_EncString.fromJSON(obj.rpId);
        const userHandle = enc_string_EncString.fromJSON(obj.userHandle);
        const userName = enc_string_EncString.fromJSON(obj.userName);
        const counter = enc_string_EncString.fromJSON(obj.counter);
        const rpName = enc_string_EncString.fromJSON(obj.rpName);
        const userDisplayName = enc_string_EncString.fromJSON(obj.userDisplayName);
        const discoverable = enc_string_EncString.fromJSON(obj.discoverable);
        const creationDate = obj.creationDate != null ? new Date(obj.creationDate) : null;
        return Object.assign(new Fido2Credential(), obj, {
            credentialId,
            keyType,
            keyAlgorithm,
            keyCurve,
            keyValue,
            rpId,
            userHandle,
            userName,
            counter,
            rpName,
            userDisplayName,
            discoverable,
            creationDate,
        });
    }
    /**
     *  Maps Fido2Credential to SDK format.
     *
     * @returns {SdkFido2Credential} The SDK Fido2Credential object.
     */
    toSdkFido2Credential() {
        var _a, _b, _c, _d, _e, _f;
        return {
            credentialId: (_a = this.credentialId) === null || _a === void 0 ? void 0 : _a.toJSON(),
            keyType: this.keyType.toJSON(),
            keyAlgorithm: this.keyAlgorithm.toJSON(),
            keyCurve: this.keyCurve.toJSON(),
            keyValue: this.keyValue.toJSON(),
            rpId: this.rpId.toJSON(),
            userHandle: (_b = this.userHandle) === null || _b === void 0 ? void 0 : _b.toJSON(),
            userName: (_c = this.userName) === null || _c === void 0 ? void 0 : _c.toJSON(),
            counter: this.counter.toJSON(),
            rpName: (_d = this.rpName) === null || _d === void 0 ? void 0 : _d.toJSON(),
            userDisplayName: (_e = this.userDisplayName) === null || _e === void 0 ? void 0 : _e.toJSON(),
            discoverable: (_f = this.discoverable) === null || _f === void 0 ? void 0 : _f.toJSON(),
            creationDate: this.creationDate.toISOString(),
        };
    }
}

;// ../../libs/common/src/vault/models/domain/login-uri.ts
var login_uri_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class LoginUri extends domain_base_Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.match = obj.match;
        this.buildDomainModel(this, obj, {
            uri: null,
            uriChecksum: null,
        }, []);
    }
    decrypt(orgId, context = "No Cipher Context", encKey) {
        return this.decryptObj(this, new LoginUriView(this), ["uri"], orgId, encKey, context);
    }
    validateChecksum(clearTextUri, orgId, encKey) {
        return login_uri_awaiter(this, void 0, void 0, function* () {
            if (this.uriChecksum == null) {
                return false;
            }
            const keyService = utils_Utils.getContainerService().getEncryptService();
            const localChecksum = yield keyService.hash(clearTextUri, "sha256");
            const remoteChecksum = yield this.uriChecksum.decrypt(orgId, encKey);
            return remoteChecksum === localChecksum;
        });
    }
    toLoginUriData() {
        const u = new LoginUriData();
        this.buildDataModel(this, u, {
            uri: null,
            uriChecksum: null,
            match: null,
        }, ["match"]);
        return u;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const uri = enc_string_EncString.fromJSON(obj.uri);
        const uriChecksum = enc_string_EncString.fromJSON(obj.uriChecksum);
        return Object.assign(new LoginUri(), obj, {
            uri,
            uriChecksum,
        });
    }
    /**
     *  Maps LoginUri to SDK format.
     *
     * @returns {SdkLoginUri} The SDK login uri object.
     */
    toSdkLoginUri() {
        return {
            uri: this.uri.toJSON(),
            uriChecksum: this.uriChecksum.toJSON(),
            match: this.match,
        };
    }
}

;// ../../libs/common/src/vault/models/domain/login.ts
var login_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






class Login extends domain_base_Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.passwordRevisionDate =
            obj.passwordRevisionDate != null ? new Date(obj.passwordRevisionDate) : null;
        this.autofillOnPageLoad = obj.autofillOnPageLoad;
        this.buildDomainModel(this, obj, {
            username: null,
            password: null,
            totp: null,
        }, []);
        if (obj.uris) {
            this.uris = [];
            obj.uris.forEach((u) => {
                this.uris.push(new LoginUri(u));
            });
        }
        if (obj.fido2Credentials) {
            this.fido2Credentials = obj.fido2Credentials.map((key) => new Fido2Credential(key));
        }
    }
    decrypt(orgId_1, bypassValidation_1) {
        return login_awaiter(this, arguments, void 0, function* (orgId, bypassValidation, context = "No Cipher Context", encKey) {
            const view = yield this.decryptObj(this, new LoginView(this), ["username", "password", "totp"], orgId, encKey, `DomainType: Login; ${context}`);
            if (this.uris != null) {
                view.uris = [];
                for (let i = 0; i < this.uris.length; i++) {
                    // If the uri is null, there is nothing to decrypt or validate
                    if (this.uris[i].uri == null) {
                        continue;
                    }
                    const uri = yield this.uris[i].decrypt(orgId, context, encKey);
                    // URIs are shared remotely after decryption
                    // we need to validate that the string hasn't been changed by a compromised server
                    // This validation is tied to the existence of cypher.key for backwards compatibility
                    // So we bypass the validation if there's no cipher.key or procceed with the validation and
                    // Skip the value if it's been tampered with.
                    if (bypassValidation || (yield this.uris[i].validateChecksum(uri.uri, orgId, encKey))) {
                        view.uris.push(uri);
                    }
                }
            }
            if (this.fido2Credentials != null) {
                view.fido2Credentials = yield Promise.all(this.fido2Credentials.map((key) => key.decrypt(orgId, encKey)));
            }
            return view;
        });
    }
    toLoginData() {
        const l = new LoginData();
        l.passwordRevisionDate =
            this.passwordRevisionDate != null ? this.passwordRevisionDate.toISOString() : null;
        l.autofillOnPageLoad = this.autofillOnPageLoad;
        this.buildDataModel(this, l, {
            username: null,
            password: null,
            totp: null,
        });
        if (this.uris != null && this.uris.length > 0) {
            l.uris = [];
            this.uris.forEach((u) => {
                l.uris.push(u.toLoginUriData());
            });
        }
        if (this.fido2Credentials != null && this.fido2Credentials.length > 0) {
            l.fido2Credentials = this.fido2Credentials.map((key) => key.toFido2CredentialData());
        }
        return l;
    }
    static fromJSON(obj) {
        var _a, _b, _c;
        if (obj == null) {
            return null;
        }
        const username = enc_string_EncString.fromJSON(obj.username);
        const password = enc_string_EncString.fromJSON(obj.password);
        const totp = enc_string_EncString.fromJSON(obj.totp);
        const passwordRevisionDate = obj.passwordRevisionDate == null ? null : new Date(obj.passwordRevisionDate);
        const uris = (_a = obj.uris) === null || _a === void 0 ? void 0 : _a.map((uri) => LoginUri.fromJSON(uri));
        const fido2Credentials = (_c = (_b = obj.fido2Credentials) === null || _b === void 0 ? void 0 : _b.map((key) => Fido2Credential.fromJSON(key))) !== null && _c !== void 0 ? _c : [];
        return Object.assign(new Login(), obj, {
            username,
            password,
            totp,
            passwordRevisionDate,
            uris,
            fido2Credentials,
        });
    }
    /**
     * Maps Login to SDK format.
     *
     * @returns {SdkLogin} The SDK login object.
     */
    toSdkLogin() {
        var _a, _b, _c, _d, _e, _f;
        return {
            uris: (_a = this.uris) === null || _a === void 0 ? void 0 : _a.map((u) => u.toSdkLoginUri()),
            username: (_b = this.username) === null || _b === void 0 ? void 0 : _b.toJSON(),
            password: (_c = this.password) === null || _c === void 0 ? void 0 : _c.toJSON(),
            passwordRevisionDate: (_d = this.passwordRevisionDate) === null || _d === void 0 ? void 0 : _d.toISOString(),
            totp: (_e = this.totp) === null || _e === void 0 ? void 0 : _e.toJSON(),
            autofillOnPageLoad: this.autofillOnPageLoad,
            fido2Credentials: (_f = this.fido2Credentials) === null || _f === void 0 ? void 0 : _f.map((f) => f.toSdkFido2Credential()),
        };
    }
}

;// ../../libs/common/src/vault/models/domain/password.ts




class Password extends domain_base_Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            password: null,
        });
        this.lastUsedDate = new Date(obj.lastUsedDate);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(this, new PasswordHistoryView(this), ["password"], orgId, encKey, "DomainType: PasswordHistory");
    }
    toPasswordHistoryData() {
        const ph = new PasswordHistoryData();
        ph.lastUsedDate = this.lastUsedDate.toISOString();
        this.buildDataModel(this, ph, {
            password: null,
        });
        return ph;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const password = enc_string_EncString.fromJSON(obj.password);
        const lastUsedDate = obj.lastUsedDate == null ? null : new Date(obj.lastUsedDate);
        return Object.assign(new Password(), obj, {
            password,
            lastUsedDate,
        });
    }
    /**
     * Maps Password to SDK format.
     *
     * @returns {PasswordHistory} The SDK password history object.
     */
    toSdkPasswordHistory() {
        return {
            password: this.password.toJSON(),
            lastUsedDate: this.lastUsedDate.toISOString(),
        };
    }
}

;// ../../libs/common/src/vault/models/domain/secure-note.ts
var secure_note_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class SecureNote extends domain_base_Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.type = obj.type;
    }
    decrypt(orgId_1) {
        return secure_note_awaiter(this, arguments, void 0, function* (orgId, context = "No Cipher Context", encKey) {
            return new SecureNoteView(this);
        });
    }
    toSecureNoteData() {
        const n = new SecureNoteData();
        n.type = this.type;
        return n;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new SecureNote(), obj);
    }
    /**
     * Maps Secure note to SDK format.
     *
     * @returns {SdkSecureNote} The SDK secure note object.
     */
    toSdkSecureNote() {
        return {
            type: this.type,
        };
    }
}

;// ../../libs/common/src/vault/models/domain/ssh-key.ts




class SshKey extends domain_base_Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            privateKey: null,
            publicKey: null,
            keyFingerprint: null,
        }, []);
    }
    decrypt(orgId, context = "No Cipher Context", encKey) {
        return this.decryptObj(this, new SshKeyView(), ["privateKey", "publicKey", "keyFingerprint"], orgId, encKey, "DomainType: SshKey; " + context);
    }
    toSshKeyData() {
        const c = new SshKeyData();
        this.buildDataModel(this, c, {
            privateKey: null,
            publicKey: null,
            keyFingerprint: null,
        });
        return c;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const privateKey = enc_string_EncString.fromJSON(obj.privateKey);
        const publicKey = enc_string_EncString.fromJSON(obj.publicKey);
        const keyFingerprint = enc_string_EncString.fromJSON(obj.keyFingerprint);
        return Object.assign(new SshKey(), obj, {
            privateKey,
            publicKey,
            keyFingerprint,
        });
    }
    /**
     * Maps SSH key to SDK format.
     *
     * @returns {SdkSshKey} The SDK SSH key object.
     */
    toSdkSshKey() {
        return {
            privateKey: this.privateKey.toJSON(),
            publicKey: this.publicKey.toJSON(),
            fingerprint: this.keyFingerprint.toJSON(),
        };
    }
}

;// ../../libs/common/src/vault/models/domain/cipher.ts
var cipher_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};















class Cipher extends domain_base_Domain {
    constructor(obj, localData = null) {
        super();
        this.initializerKey = InitializerKey.Cipher;
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            id: null,
            organizationId: null,
            folderId: null,
            name: null,
            notes: null,
            key: null,
        }, ["id", "organizationId", "folderId"]);
        this.type = obj.type;
        this.favorite = obj.favorite;
        this.organizationUseTotp = obj.organizationUseTotp;
        this.edit = obj.edit;
        if (obj.viewPassword != null) {
            this.viewPassword = obj.viewPassword;
        }
        else {
            this.viewPassword = true; // Default for already synced Ciphers without viewPassword
        }
        this.permissions = obj.permissions;
        this.revisionDate = obj.revisionDate != null ? new Date(obj.revisionDate) : null;
        this.collectionIds = obj.collectionIds;
        this.localData = localData;
        this.creationDate = obj.creationDate != null ? new Date(obj.creationDate) : null;
        this.deletedDate = obj.deletedDate != null ? new Date(obj.deletedDate) : null;
        this.reprompt = obj.reprompt;
        switch (this.type) {
            case CipherType.Login:
                this.login = new Login(obj.login);
                break;
            case CipherType.SecureNote:
                this.secureNote = new SecureNote(obj.secureNote);
                break;
            case CipherType.Card:
                this.card = new Card(obj.card);
                break;
            case CipherType.Identity:
                this.identity = new Identity(obj.identity);
                break;
            case CipherType.SshKey:
                this.sshKey = new SshKey(obj.sshKey);
                break;
            default:
                break;
        }
        if (obj.attachments != null) {
            this.attachments = obj.attachments.map((a) => new Attachment(a));
        }
        else {
            this.attachments = null;
        }
        if (obj.fields != null) {
            this.fields = obj.fields.map((f) => new Field(f));
        }
        else {
            this.fields = null;
        }
        if (obj.passwordHistory != null) {
            this.passwordHistory = obj.passwordHistory.map((ph) => new Password(ph));
        }
        else {
            this.passwordHistory = null;
        }
    }
    // We are passing the organizationId into the EncString.decrypt() method here, but because the encKey will always be
    // present and so the organizationId will not be used.
    // We will refactor the EncString.decrypt() in https://bitwarden.atlassian.net/browse/PM-3762 to remove the dependency on the organizationId.
    decrypt(encKey) {
        return cipher_awaiter(this, void 0, void 0, function* () {
            const model = new CipherView(this);
            let bypassValidation = true;
            if (this.key != null) {
                const encryptService = utils_Utils.getContainerService().getEncryptService();
                const cipherKey = yield encryptService.unwrapSymmetricKey(this.key, encKey);
                if (cipherKey == null) {
                    model.name = "[error: cannot decrypt]";
                    model.decryptionFailure = true;
                    return model;
                }
                encKey = cipherKey;
                bypassValidation = false;
            }
            yield this.decryptObj(this, model, ["name", "notes"], this.organizationId, encKey);
            switch (this.type) {
                case CipherType.Login:
                    model.login = yield this.login.decrypt(this.organizationId, bypassValidation, `Cipher Id: ${this.id}`, encKey);
                    break;
                case CipherType.SecureNote:
                    model.secureNote = yield this.secureNote.decrypt(this.organizationId, `Cipher Id: ${this.id}`, encKey);
                    break;
                case CipherType.Card:
                    model.card = yield this.card.decrypt(this.organizationId, `Cipher Id: ${this.id}`, encKey);
                    break;
                case CipherType.Identity:
                    model.identity = yield this.identity.decrypt(this.organizationId, `Cipher Id: ${this.id}`, encKey);
                    break;
                case CipherType.SshKey:
                    model.sshKey = yield this.sshKey.decrypt(this.organizationId, `Cipher Id: ${this.id}`, encKey);
                    break;
                default:
                    break;
            }
            if (this.attachments != null && this.attachments.length > 0) {
                const attachments = [];
                for (const attachment of this.attachments) {
                    attachments.push(yield attachment.decrypt(this.organizationId, `Cipher Id: ${this.id}`, encKey));
                }
                model.attachments = attachments;
            }
            if (this.fields != null && this.fields.length > 0) {
                const fields = [];
                for (const field of this.fields) {
                    fields.push(yield field.decrypt(this.organizationId, encKey));
                }
                model.fields = fields;
            }
            if (this.passwordHistory != null && this.passwordHistory.length > 0) {
                const passwordHistory = [];
                for (const ph of this.passwordHistory) {
                    passwordHistory.push(yield ph.decrypt(this.organizationId, encKey));
                }
                model.passwordHistory = passwordHistory;
            }
            return model;
        });
    }
    toCipherData() {
        var _a;
        const c = new CipherData();
        c.id = this.id;
        c.organizationId = this.organizationId;
        c.folderId = this.folderId;
        c.edit = this.edit;
        c.viewPassword = this.viewPassword;
        c.organizationUseTotp = this.organizationUseTotp;
        c.favorite = this.favorite;
        c.revisionDate = this.revisionDate != null ? this.revisionDate.toISOString() : null;
        c.type = this.type;
        c.collectionIds = this.collectionIds;
        c.creationDate = this.creationDate != null ? this.creationDate.toISOString() : null;
        c.deletedDate = this.deletedDate != null ? this.deletedDate.toISOString() : null;
        c.reprompt = this.reprompt;
        c.key = (_a = this.key) === null || _a === void 0 ? void 0 : _a.encryptedString;
        c.permissions = this.permissions;
        this.buildDataModel(this, c, {
            name: null,
            notes: null,
        });
        switch (c.type) {
            case CipherType.Login:
                c.login = this.login.toLoginData();
                break;
            case CipherType.SecureNote:
                c.secureNote = this.secureNote.toSecureNoteData();
                break;
            case CipherType.Card:
                c.card = this.card.toCardData();
                break;
            case CipherType.Identity:
                c.identity = this.identity.toIdentityData();
                break;
            case CipherType.SshKey:
                c.sshKey = this.sshKey.toSshKeyData();
                break;
            default:
                break;
        }
        if (this.fields != null) {
            c.fields = this.fields.map((f) => f.toFieldData());
        }
        if (this.attachments != null) {
            c.attachments = this.attachments.map((a) => a.toAttachmentData());
        }
        if (this.passwordHistory != null) {
            c.passwordHistory = this.passwordHistory.map((ph) => ph.toPasswordHistoryData());
        }
        return c;
    }
    static fromJSON(obj) {
        var _a, _b, _c;
        if (obj == null) {
            return null;
        }
        const domain = new Cipher();
        const name = enc_string_EncString.fromJSON(obj.name);
        const notes = enc_string_EncString.fromJSON(obj.notes);
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        const deletedDate = obj.deletedDate == null ? null : new Date(obj.deletedDate);
        const attachments = (_a = obj.attachments) === null || _a === void 0 ? void 0 : _a.map((a) => Attachment.fromJSON(a));
        const fields = (_b = obj.fields) === null || _b === void 0 ? void 0 : _b.map((f) => Field.fromJSON(f));
        const passwordHistory = (_c = obj.passwordHistory) === null || _c === void 0 ? void 0 : _c.map((ph) => Password.fromJSON(ph));
        const key = enc_string_EncString.fromJSON(obj.key);
        Object.assign(domain, obj, {
            name,
            notes,
            revisionDate,
            deletedDate,
            attachments,
            fields,
            passwordHistory,
            key,
        });
        switch (obj.type) {
            case CipherType.Card:
                domain.card = Card.fromJSON(obj.card);
                break;
            case CipherType.Identity:
                domain.identity = Identity.fromJSON(obj.identity);
                break;
            case CipherType.Login:
                domain.login = Login.fromJSON(obj.login);
                break;
            case CipherType.SecureNote:
                domain.secureNote = SecureNote.fromJSON(obj.secureNote);
                break;
            case CipherType.SshKey:
                domain.sshKey = SshKey.fromJSON(obj.sshKey);
                break;
            default:
                break;
        }
        return domain;
    }
    /**
     * Maps Cipher to SDK format.
     *
     * @returns {SdkCipher} The SDK cipher object.
     */
    toSdkCipher() {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        const sdkCipher = {
            id: this.id,
            organizationId: this.organizationId,
            folderId: this.folderId,
            collectionIds: this.collectionIds || [],
            key: (_a = this.key) === null || _a === void 0 ? void 0 : _a.toJSON(),
            name: this.name.toJSON(),
            notes: (_b = this.notes) === null || _b === void 0 ? void 0 : _b.toJSON(),
            type: this.type,
            favorite: this.favorite,
            organizationUseTotp: this.organizationUseTotp,
            edit: this.edit,
            permissions: this.permissions,
            viewPassword: this.viewPassword,
            localData: this.localData
                ? {
                    lastUsedDate: this.localData.lastUsedDate
                        ? new Date(this.localData.lastUsedDate).toISOString()
                        : undefined,
                    lastLaunched: this.localData.lastLaunched
                        ? new Date(this.localData.lastLaunched).toISOString()
                        : undefined,
                }
                : undefined,
            attachments: (_c = this.attachments) === null || _c === void 0 ? void 0 : _c.map((a) => a.toSdkAttachment()),
            fields: (_d = this.fields) === null || _d === void 0 ? void 0 : _d.map((f) => f.toSdkField()),
            passwordHistory: (_e = this.passwordHistory) === null || _e === void 0 ? void 0 : _e.map((ph) => ph.toSdkPasswordHistory()),
            revisionDate: (_f = this.revisionDate) === null || _f === void 0 ? void 0 : _f.toISOString(),
            creationDate: (_g = this.creationDate) === null || _g === void 0 ? void 0 : _g.toISOString(),
            deletedDate: (_h = this.deletedDate) === null || _h === void 0 ? void 0 : _h.toISOString(),
            reprompt: this.reprompt,
            // Initialize all cipher-type-specific properties as undefined
            login: undefined,
            identity: undefined,
            card: undefined,
            secureNote: undefined,
            sshKey: undefined,
        };
        switch (this.type) {
            case CipherType.Login:
                sdkCipher.login = this.login.toSdkLogin();
                break;
            case CipherType.SecureNote:
                sdkCipher.secureNote = this.secureNote.toSdkSecureNote();
                break;
            case CipherType.Card:
                sdkCipher.card = this.card.toSdkCard();
                break;
            case CipherType.Identity:
                sdkCipher.identity = this.identity.toSdkIdentity();
                break;
            case CipherType.SshKey:
                sdkCipher.sshKey = this.sshKey.toSdkSshKey();
                break;
            default:
                break;
        }
        return sdkCipher;
    }
}

;// ../../libs/common/src/models/export/utils.ts
function safeGetString(value) {
    if (value == null) {
        return null;
    }
    if (typeof value == "string") {
        return value;
    }
    return value === null || value === void 0 ? void 0 : value.encryptedString;
}

;// ../../libs/common/src/models/export/card.export.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore




class CardExport {
    static template() {
        const req = new CardExport();
        req.cardholderName = "John Doe";
        req.brand = "visa";
        req.number = "4242424242424242";
        req.expMonth = "04";
        req.expYear = "2023";
        req.code = "123";
        return req;
    }
    static toView(req, view = new CardView()) {
        view.cardholderName = req.cardholderName;
        view.brand = req.brand;
        view.number = req.number;
        view.expMonth = req.expMonth;
        view.expYear = req.expYear;
        view.code = req.code;
        return view;
    }
    static toDomain(req, domain = new Card()) {
        domain.cardholderName = req.cardholderName != null ? new enc_string_EncString(req.cardholderName) : null;
        domain.brand = req.brand != null ? new enc_string_EncString(req.brand) : null;
        domain.number = req.number != null ? new enc_string_EncString(req.number) : null;
        domain.expMonth = req.expMonth != null ? new enc_string_EncString(req.expMonth) : null;
        domain.expYear = req.expYear != null ? new enc_string_EncString(req.expYear) : null;
        domain.code = req.code != null ? new enc_string_EncString(req.code) : null;
        return domain;
    }
    constructor(o) {
        if (o == null) {
            return;
        }
        this.cardholderName = safeGetString(o.cardholderName);
        this.brand = safeGetString(o.brand);
        this.number = safeGetString(o.number);
        this.expMonth = safeGetString(o.expMonth);
        this.expYear = safeGetString(o.expYear);
        this.code = safeGetString(o.code);
    }
}

;// ../../libs/common/src/models/export/field.export.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore





class FieldExport {
    static template() {
        const req = new FieldExport();
        req.name = "Field name";
        req.value = "Some value";
        req.type = FieldType.Text;
        return req;
    }
    static toView(req, view = new FieldView()) {
        view.type = req.type;
        view.value = req.value;
        view.name = req.name;
        view.linkedId = req.linkedId;
        return view;
    }
    static toDomain(req, domain = new Field()) {
        domain.type = req.type;
        domain.value = req.value != null ? new enc_string_EncString(req.value) : null;
        domain.name = req.name != null ? new enc_string_EncString(req.name) : null;
        domain.linkedId = req.linkedId;
        return domain;
    }
    constructor(o) {
        if (o == null) {
            return;
        }
        this.name = safeGetString(o.name);
        this.value = safeGetString(o.value);
        this.type = o.type;
        this.linkedId = o.linkedId;
    }
}

;// ../../libs/common/src/models/export/identity.export.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore




class IdentityExport {
    static template() {
        const req = new IdentityExport();
        req.title = "Mr";
        req.firstName = "John";
        req.middleName = "William";
        req.lastName = "Doe";
        req.address1 = "123 Any St";
        req.address2 = "Apt #123";
        req.address3 = null;
        req.city = "New York";
        req.state = "NY";
        req.postalCode = "10001";
        req.country = "US";
        req.company = "Acme Inc.";
        req.email = "john@company.com";
        req.phone = "5555551234";
        req.ssn = "000-123-4567";
        req.username = "jdoe";
        req.passportNumber = "US-123456789";
        req.licenseNumber = "D123-12-123-12333";
        return req;
    }
    static toView(req, view = new IdentityView()) {
        view.title = req.title;
        view.firstName = req.firstName;
        view.middleName = req.middleName;
        view.lastName = req.lastName;
        view.address1 = req.address1;
        view.address2 = req.address2;
        view.address3 = req.address3;
        view.city = req.city;
        view.state = req.state;
        view.postalCode = req.postalCode;
        view.country = req.country;
        view.company = req.company;
        view.email = req.email;
        view.phone = req.phone;
        view.ssn = req.ssn;
        view.username = req.username;
        view.passportNumber = req.passportNumber;
        view.licenseNumber = req.licenseNumber;
        return view;
    }
    static toDomain(req, domain = new Identity()) {
        domain.title = req.title != null ? new enc_string_EncString(req.title) : null;
        domain.firstName = req.firstName != null ? new enc_string_EncString(req.firstName) : null;
        domain.middleName = req.middleName != null ? new enc_string_EncString(req.middleName) : null;
        domain.lastName = req.lastName != null ? new enc_string_EncString(req.lastName) : null;
        domain.address1 = req.address1 != null ? new enc_string_EncString(req.address1) : null;
        domain.address2 = req.address2 != null ? new enc_string_EncString(req.address2) : null;
        domain.address3 = req.address3 != null ? new enc_string_EncString(req.address3) : null;
        domain.city = req.city != null ? new enc_string_EncString(req.city) : null;
        domain.state = req.state != null ? new enc_string_EncString(req.state) : null;
        domain.postalCode = req.postalCode != null ? new enc_string_EncString(req.postalCode) : null;
        domain.country = req.country != null ? new enc_string_EncString(req.country) : null;
        domain.company = req.company != null ? new enc_string_EncString(req.company) : null;
        domain.email = req.email != null ? new enc_string_EncString(req.email) : null;
        domain.phone = req.phone != null ? new enc_string_EncString(req.phone) : null;
        domain.ssn = req.ssn != null ? new enc_string_EncString(req.ssn) : null;
        domain.username = req.username != null ? new enc_string_EncString(req.username) : null;
        domain.passportNumber = req.passportNumber != null ? new enc_string_EncString(req.passportNumber) : null;
        domain.licenseNumber = req.licenseNumber != null ? new enc_string_EncString(req.licenseNumber) : null;
        return domain;
    }
    constructor(o) {
        if (o == null) {
            return;
        }
        this.title = safeGetString(o.title);
        this.firstName = safeGetString(o.firstName);
        this.middleName = safeGetString(o.middleName);
        this.lastName = safeGetString(o.lastName);
        this.address1 = safeGetString(o.address1);
        this.address2 = safeGetString(o.address2);
        this.address3 = safeGetString(o.address3);
        this.city = safeGetString(o.city);
        this.state = safeGetString(o.state);
        this.postalCode = safeGetString(o.postalCode);
        this.country = safeGetString(o.country);
        this.company = safeGetString(o.company);
        this.email = safeGetString(o.email);
        this.phone = safeGetString(o.phone);
        this.ssn = safeGetString(o.ssn);
        this.username = safeGetString(o.username);
        this.passportNumber = safeGetString(o.passportNumber);
        this.licenseNumber = safeGetString(o.licenseNumber);
    }
}

;// ../../libs/common/src/models/export/fido2-credential.export.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore




/**
 * Represents format of Fido2 Credentials in JSON exports.
 */
class Fido2CredentialExport {
    /**
     * Generates a template for Fido2CredentialExport
     * @returns Instance of Fido2CredentialExport with predefined values.
     */
    static template() {
        const req = new Fido2CredentialExport();
        req.credentialId = "keyId";
        req.keyType = "keyType";
        req.keyAlgorithm = "keyAlgorithm";
        req.keyCurve = "keyCurve";
        req.keyValue = "keyValue";
        req.rpId = "rpId";
        req.userHandle = "userHandle";
        req.userName = "userName";
        req.counter = "counter";
        req.rpName = "rpName";
        req.userDisplayName = "userDisplayName";
        req.discoverable = "false";
        req.creationDate = null;
        return req;
    }
    /**
     * Converts a Fido2CredentialExport object to its view representation.
     * @param req - The Fido2CredentialExport object to be converted.
     * @param view - (Optional) The Fido2CredentialView object to popualte with Fido2CredentialExport data
     * @returns Fido2CredentialView - The populated view, or a new instance if none was provided.
     */
    static toView(req, view = new Fido2CredentialView()) {
        view.credentialId = req.credentialId;
        view.keyType = req.keyType;
        view.keyAlgorithm = req.keyAlgorithm;
        view.keyCurve = req.keyCurve;
        view.keyValue = req.keyValue;
        view.rpId = req.rpId;
        view.userHandle = req.userHandle;
        view.userName = req.userName;
        view.counter = parseInt(req.counter);
        view.rpName = req.rpName;
        view.userDisplayName = req.userDisplayName;
        view.discoverable = req.discoverable === "true";
        view.creationDate = new Date(req.creationDate);
        return view;
    }
    /**
     * Converts a Fido2CredentialExport object to its domain representation.
     * @param req - The Fido2CredentialExport object to be converted.
     * @param domain - (Optional) The Fido2Credential object to popualte with Fido2CredentialExport data
     * @returns Fido2Credential - The populated domain, or a new instance if none was provided.
     */
    static toDomain(req, domain = new Fido2Credential()) {
        domain.credentialId = req.credentialId != null ? new enc_string_EncString(req.credentialId) : null;
        domain.keyType = req.keyType != null ? new enc_string_EncString(req.keyType) : null;
        domain.keyAlgorithm = req.keyAlgorithm != null ? new enc_string_EncString(req.keyAlgorithm) : null;
        domain.keyCurve = req.keyCurve != null ? new enc_string_EncString(req.keyCurve) : null;
        domain.keyValue = req.keyValue != null ? new enc_string_EncString(req.keyValue) : null;
        domain.rpId = req.rpId != null ? new enc_string_EncString(req.rpId) : null;
        domain.userHandle = req.userHandle != null ? new enc_string_EncString(req.userHandle) : null;
        domain.userName = req.userName != null ? new enc_string_EncString(req.userName) : null;
        domain.counter = req.counter != null ? new enc_string_EncString(req.counter) : null;
        domain.rpName = req.rpName != null ? new enc_string_EncString(req.rpName) : null;
        domain.userDisplayName =
            req.userDisplayName != null ? new enc_string_EncString(req.userDisplayName) : null;
        domain.discoverable = req.discoverable != null ? new enc_string_EncString(req.discoverable) : null;
        domain.creationDate = req.creationDate;
        return domain;
    }
    /**
     * Constructs a new Fid2CredentialExport instance.
     *
     * @param o - The credential storing the data being exported. When not provided, an empty export is created instead.
     */
    constructor(o) {
        if (o == null) {
            return;
        }
        this.credentialId = safeGetString(o.credentialId);
        this.keyType = safeGetString(o.keyType);
        this.keyAlgorithm = safeGetString(o.keyAlgorithm);
        this.keyCurve = safeGetString(o.keyCurve);
        this.keyValue = safeGetString(o.keyValue);
        this.rpId = safeGetString(o.rpId);
        this.userHandle = safeGetString(o.userHandle);
        this.userName = safeGetString(o.userName);
        this.counter = safeGetString(String(o.counter));
        this.rpName = safeGetString(o.rpName);
        this.userDisplayName = safeGetString(o.userDisplayName);
        this.discoverable = safeGetString(String(o.discoverable));
        this.creationDate = o.creationDate;
    }
}

;// ../../libs/common/src/models/export/login-uri.export.ts




class LoginUriExport {
    static template() {
        const req = new LoginUriExport();
        req.uri = "https://google.com";
        req.match = null;
        return req;
    }
    static toView(req, view = new LoginUriView()) {
        view.uri = req.uri;
        view.match = req.match;
        return view;
    }
    static toDomain(req, domain = new LoginUri()) {
        domain.uri = req.uri != null ? new enc_string_EncString(req.uri) : null;
        domain.uriChecksum = req.uriChecksum != null ? new enc_string_EncString(req.uriChecksum) : null;
        domain.match = req.match;
        return domain;
    }
    constructor(o) {
        var _a;
        this.match = null;
        if (o == null) {
            return;
        }
        this.uri = safeGetString(o.uri);
        if ("uriChecksum" in o) {
            this.uriChecksum = (_a = o.uriChecksum) === null || _a === void 0 ? void 0 : _a.encryptedString;
        }
        this.match = o.match;
    }
}

;// ../../libs/common/src/models/export/login.export.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore






class LoginExport {
    static template() {
        const req = new LoginExport();
        req.uris = [];
        req.username = "jdoe";
        req.password = "myp@ssword123";
        req.totp = "JBSWY3DPEHPK3PXP";
        req.fido2Credentials = [Fido2CredentialExport.template()];
        return req;
    }
    static toView(req, view = new LoginView()) {
        if (req.uris != null) {
            view.uris = req.uris.map((u) => LoginUriExport.toView(u));
        }
        view.username = req.username;
        view.password = req.password;
        view.totp = req.totp;
        if (req.fido2Credentials != null) {
            view.fido2Credentials = req.fido2Credentials.map((key) => Fido2CredentialExport.toView(key));
        }
        return view;
    }
    static toDomain(req, domain = new Login()) {
        if (req.uris != null) {
            domain.uris = req.uris.map((u) => LoginUriExport.toDomain(u));
        }
        domain.username = req.username != null ? new enc_string_EncString(req.username) : null;
        domain.password = req.password != null ? new enc_string_EncString(req.password) : null;
        domain.totp = req.totp != null ? new enc_string_EncString(req.totp) : null;
        // Fido2credentials are currently not supported for exports.
        return domain;
    }
    constructor(o) {
        this.fido2Credentials = [];
        if (o == null) {
            return;
        }
        if (o.uris != null) {
            this.uris = o.uris.map((u) => new LoginUriExport(u));
        }
        if (o.fido2Credentials != null) {
            this.fido2Credentials = o.fido2Credentials.map((key) => new Fido2CredentialExport(key));
        }
        this.username = safeGetString(o.username);
        this.password = safeGetString(o.password);
        this.totp = safeGetString(o.totp);
    }
}

;// ../../libs/common/src/models/export/password-history.export.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore




class PasswordHistoryExport {
    static template() {
        const req = new PasswordHistoryExport();
        req.password = null;
        req.lastUsedDate = null;
        return req;
    }
    static toView(req, view = new PasswordHistoryView()) {
        view.password = req.password;
        view.lastUsedDate = req.lastUsedDate;
        return view;
    }
    static toDomain(req, domain = new Password()) {
        domain.password = req.password != null ? new enc_string_EncString(req.password) : null;
        domain.lastUsedDate = req.lastUsedDate;
        return domain;
    }
    constructor(o) {
        this.lastUsedDate = null;
        if (o == null) {
            return;
        }
        this.password = safeGetString(o.password);
        this.lastUsedDate = o.lastUsedDate;
    }
}

;// ../../libs/common/src/models/export/secure-note.export.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore



class SecureNoteExport {
    static template() {
        const req = new SecureNoteExport();
        req.type = SecureNoteType.Generic;
        return req;
    }
    static toView(req, view = new SecureNoteView()) {
        view.type = req.type;
        return view;
    }
    static toDomain(req, view = new SecureNote()) {
        view.type = req.type;
        return view;
    }
    constructor(o) {
        if (o == null) {
            return;
        }
        this.type = o.type;
    }
}

;// ../../libs/common/src/models/export/ssh-key.export.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore




class SshKeyExport {
    static template() {
        const req = new SshKeyExport();
        req.privateKey = "";
        req.publicKey = "";
        req.keyFingerprint = "";
        return req;
    }
    static toView(req, view = new SshKeyView()) {
        view.privateKey = req.privateKey;
        view.publicKey = req.publicKey;
        view.keyFingerprint = req.keyFingerprint;
        return view;
    }
    static toDomain(req, domain = new SshKey()) {
        domain.privateKey = new enc_string_EncString(req.privateKey);
        domain.publicKey = new enc_string_EncString(req.publicKey);
        domain.keyFingerprint = new enc_string_EncString(req.keyFingerprint);
        return domain;
    }
    constructor(o) {
        if (o == null) {
            return;
        }
        this.privateKey = safeGetString(o.privateKey);
        this.publicKey = safeGetString(o.publicKey);
        this.keyFingerprint = safeGetString(o.keyFingerprint);
    }
}

;// ../../libs/common/src/models/export/cipher.export.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore













class CipherExport {
    constructor() {
        this.passwordHistory = null;
        this.revisionDate = null;
        this.creationDate = null;
        this.deletedDate = null;
    }
    static template() {
        const req = new CipherExport();
        req.organizationId = null;
        req.collectionIds = null;
        req.folderId = null;
        req.type = CipherType.Login;
        req.name = "Item name";
        req.notes = "Some notes about this item.";
        req.favorite = false;
        req.fields = [];
        req.login = null;
        req.secureNote = null;
        req.card = null;
        req.identity = null;
        req.sshKey = null;
        req.reprompt = CipherRepromptType.None;
        req.passwordHistory = [];
        req.creationDate = null;
        req.revisionDate = null;
        req.deletedDate = null;
        return req;
    }
    static toView(req, view = new CipherView()) {
        var _a, _b, _c;
        view.type = req.type;
        view.folderId = req.folderId;
        if (view.organizationId == null) {
            view.organizationId = req.organizationId;
        }
        if (view.collectionIds || req.collectionIds) {
            const set = new Set(((_a = view.collectionIds) !== null && _a !== void 0 ? _a : []).concat((_b = req.collectionIds) !== null && _b !== void 0 ? _b : []));
            view.collectionIds = Array.from(set.values());
        }
        view.name = req.name;
        view.notes = req.notes;
        view.favorite = req.favorite;
        view.reprompt = (_c = req.reprompt) !== null && _c !== void 0 ? _c : CipherRepromptType.None;
        if (req.fields != null) {
            view.fields = req.fields.map((f) => FieldExport.toView(f));
        }
        switch (req.type) {
            case CipherType.Login:
                view.login = LoginExport.toView(req.login);
                break;
            case CipherType.SecureNote:
                view.secureNote = SecureNoteExport.toView(req.secureNote);
                break;
            case CipherType.Card:
                view.card = CardExport.toView(req.card);
                break;
            case CipherType.Identity:
                view.identity = IdentityExport.toView(req.identity);
                break;
            case CipherType.SshKey:
                view.sshKey = SshKeyExport.toView(req.sshKey);
                break;
        }
        if (req.passwordHistory != null) {
            view.passwordHistory = req.passwordHistory.map((ph) => PasswordHistoryExport.toView(ph));
        }
        view.creationDate = req.creationDate;
        view.revisionDate = req.revisionDate;
        view.deletedDate = req.deletedDate;
        return view;
    }
    static toDomain(req, domain = new Cipher()) {
        var _a;
        domain.type = req.type;
        domain.folderId = req.folderId;
        if (domain.organizationId == null) {
            domain.organizationId = req.organizationId;
        }
        domain.name = req.name != null ? new enc_string_EncString(req.name) : null;
        domain.notes = req.notes != null ? new enc_string_EncString(req.notes) : null;
        domain.favorite = req.favorite;
        domain.reprompt = (_a = req.reprompt) !== null && _a !== void 0 ? _a : CipherRepromptType.None;
        domain.key = req.key != null ? new enc_string_EncString(req.key) : null;
        if (req.fields != null) {
            domain.fields = req.fields.map((f) => FieldExport.toDomain(f));
        }
        switch (req.type) {
            case CipherType.Login:
                domain.login = LoginExport.toDomain(req.login);
                break;
            case CipherType.SecureNote:
                domain.secureNote = SecureNoteExport.toDomain(req.secureNote);
                break;
            case CipherType.Card:
                domain.card = CardExport.toDomain(req.card);
                break;
            case CipherType.Identity:
                domain.identity = IdentityExport.toDomain(req.identity);
                break;
            case CipherType.SshKey:
                domain.sshKey = SshKeyExport.toDomain(req.sshKey);
                break;
        }
        if (req.passwordHistory != null) {
            domain.passwordHistory = req.passwordHistory.map((ph) => PasswordHistoryExport.toDomain(ph));
        }
        domain.creationDate = req.creationDate;
        domain.revisionDate = req.revisionDate;
        domain.deletedDate = req.deletedDate;
        return domain;
    }
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        var _a;
        this.organizationId = o.organizationId;
        this.folderId = o.folderId;
        this.type = o.type;
        this.reprompt = o.reprompt;
        this.name = safeGetString(o.name);
        this.notes = safeGetString(o.notes);
        if ("key" in o) {
            this.key = (_a = o.key) === null || _a === void 0 ? void 0 : _a.encryptedString;
        }
        this.favorite = o.favorite;
        if (o.fields != null) {
            this.fields = o.fields.map((f) => new FieldExport(f));
        }
        switch (o.type) {
            case CipherType.Login:
                this.login = new LoginExport(o.login);
                break;
            case CipherType.SecureNote:
                this.secureNote = new SecureNoteExport(o.secureNote);
                break;
            case CipherType.Card:
                this.card = new CardExport(o.card);
                break;
            case CipherType.Identity:
                this.identity = new IdentityExport(o.identity);
                break;
            case CipherType.SshKey:
                this.sshKey = new SshKeyExport(o.sshKey);
                break;
        }
        if (o.passwordHistory != null) {
            this.passwordHistory = o.passwordHistory.map((ph) => new PasswordHistoryExport(ph));
        }
        this.creationDate = o.creationDate;
        this.revisionDate = o.revisionDate;
        this.deletedDate = o.deletedDate;
    }
}

;// ../../libs/common/src/models/export/cipher-with-ids.export.ts

class CipherWithIdExport extends CipherExport {
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        this.id = o.id;
        super.build(o);
        this.collectionIds = o.collectionIds;
    }
}

;// ./src/models/response/login.response.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

class LoginResponse extends LoginExport {
    constructor(o) {
        super(o);
        this.passwordRevisionDate = o.passwordRevisionDate != null ? o.passwordRevisionDate : null;
    }
}

;// ./src/vault/models/attachment.response.ts
class AttachmentResponse {
    constructor(o) {
        this.id = o.id;
        this.fileName = o.fileName;
        this.size = o.size;
        this.sizeName = o.sizeName;
        this.url = o.url;
    }
}

;// ./src/vault/models/password-history.response.ts
class PasswordHistoryResponse {
    constructor(o) {
        this.lastUsedDate = o.lastUsedDate;
        this.password = o.password;
    }
}

;// ./src/vault/models/cipher.response.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore





class CipherResponse extends CipherWithIdExport {
    constructor(o) {
        super();
        this.object = "item";
        this.build(o);
        if (o.attachments != null) {
            this.attachments = o.attachments.map((a) => new AttachmentResponse(a));
        }
        this.revisionDate = o.revisionDate;
        if (o.creationDate != null) {
            this.creationDate = o.creationDate;
        }
        this.deletedDate = o.deletedDate;
        if (o.passwordHistory != null) {
            this.passwordHistory = o.passwordHistory.map((h) => new PasswordHistoryResponse(h));
        }
        if (o.type === CipherType.Login && o.login != null) {
            this.login = new LoginResponse(o.login);
        }
    }
}

;// ./src/admin-console/commands/share.command.ts
var share_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore





class ShareCommand {
    constructor(cipherService, accountService) {
        this.cipherService = cipherService;
        this.accountService = accountService;
    }
    run(id, organizationId, requestJson) {
        return share_command_awaiter(this, void 0, void 0, function* () {
            if (process.env.BW_SERVE !== "true" && (requestJson == null || requestJson === "")) {
                requestJson = yield CliUtils.readStdin();
            }
            if (requestJson == null || requestJson === "") {
                return bw_Response.badRequest("`requestJson` was not provided.");
            }
            let req = [];
            if (typeof requestJson !== "string") {
                req = requestJson;
            }
            else {
                try {
                    const reqJson = Buffer.from(requestJson, "base64").toString();
                    req = JSON.parse(reqJson);
                    if (req == null || req.length === 0) {
                        return bw_Response.badRequest("You must provide at least one collection id for this item.");
                    }
                    // FIXME: Remove when updating file. Eslint update
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                }
                catch (e) {
                    return bw_Response.badRequest("Error parsing the encoded request data.");
                }
            }
            if (id != null) {
                id = id.toLowerCase();
            }
            if (organizationId != null) {
                organizationId = organizationId.toLowerCase();
            }
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
            const cipher = yield this.cipherService.get(id, activeUserId);
            if (cipher == null) {
                return bw_Response.notFound();
            }
            if (cipher.organizationId != null) {
                return bw_Response.badRequest("This item already belongs to an organization.");
            }
            const cipherView = yield this.cipherService.decrypt(cipher, activeUserId);
            try {
                yield this.cipherService.shareWithServer(cipherView, organizationId, req, activeUserId);
                const updatedCipher = yield this.cipherService.get(cipher.id, activeUserId);
                const decCipher = yield this.cipherService.decrypt(updatedCipher, activeUserId);
                const res = new CipherResponse(decCipher);
                return bw_Response.success(res);
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
}

;// ./src/auth/commands/lock.command.ts
var lock_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class LockCommand {
    constructor(vaultTimeoutService) {
        this.vaultTimeoutService = vaultTimeoutService;
    }
    run() {
        return lock_command_awaiter(this, void 0, void 0, function* () {
            yield this.vaultTimeoutService.lock();
            process.env.BW_SESSION = null;
            const res = new MessageResponse("Your vault is locked.", null);
            return bw_Response.success(res);
        });
    }
}

;// ../../libs/common/src/auth/enums/verification-type.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var VerificationType;
(function (VerificationType) {
    VerificationType[VerificationType["MasterPassword"] = 0] = "MasterPassword";
    VerificationType[VerificationType["OTP"] = 1] = "OTP";
    VerificationType[VerificationType["PIN"] = 2] = "PIN";
    VerificationType[VerificationType["Biometrics"] = 3] = "Biometrics";
})(VerificationType || (VerificationType = {}));

;// ../../libs/common/src/platform/abstractions/environment.service.ts
/**
 * A subset of available regions, additional regions can be loaded through configuration.
 */
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var Region;
(function (Region) {
    Region["US"] = "US";
    Region["EU"] = "EU";
    Region["SelfHosted"] = "Self-hosted";
})(Region || (Region = {}));
/**
 * The environment service. Provides access to set the current environment urls and region.
 */
class EnvironmentService {
}

;// ./src/key-management/convert-to-key-connector.command.ts
var convert_to_key_connector_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class ConvertToKeyConnectorCommand {
    constructor(userId, keyConnectorService, environmentService, organizationApiService, logout, i18nService) {
        this.userId = userId;
        this.keyConnectorService = keyConnectorService;
        this.environmentService = environmentService;
        this.organizationApiService = organizationApiService;
        this.logout = logout;
        this.i18nService = i18nService;
    }
    run() {
        return convert_to_key_connector_command_awaiter(this, void 0, void 0, function* () {
            // If no interaction available, alert user to use web vault
            const canInteract = process.env.BW_NOINTERACTION !== "true";
            if (!canInteract) {
                yield this.logout();
                return bw_Response.error(new MessageResponse(this.i18nService.t("organizationUsingKeyConnectorOptInLoggedOut"), null));
            }
            const organization = yield this.keyConnectorService.getManagingOrganization(this.userId);
            const answer = yield external_inquirer_namespaceObject.createPromptModule({ output: process.stderr })({
                type: "list",
                name: "convert",
                message: this.i18nService.t("removeMasterPasswordForOrganizationUserKeyConnector", organization.name, organization.keyConnectorUrl),
                choices: [
                    {
                        name: this.i18nService.t("removeMasterPasswordAndUnlock"),
                        value: "remove",
                    },
                    {
                        name: this.i18nService.t("leaveOrganizationAndUnlock"),
                        value: "leave",
                    },
                    {
                        name: this.i18nService.t("logOut"),
                        value: "exit",
                    },
                ],
            });
            if (answer.convert === "remove") {
                try {
                    yield this.keyConnectorService.migrateUser(organization.keyConnectorUrl, this.userId);
                }
                catch (e) {
                    yield this.logout();
                    throw e;
                }
                // Update environment URL - required for api key login
                const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
                const urls = env.getUrls();
                urls.keyConnector = organization.keyConnectorUrl;
                yield this.environmentService.setEnvironment(Region.SelfHosted, urls);
                return bw_Response.success();
            }
            else if (answer.convert === "leave") {
                yield this.organizationApiService.leave(organization.id);
                return bw_Response.success();
            }
            else {
                yield this.logout();
                return bw_Response.error(this.i18nService.t("youHaveBeenLoggedOut"));
            }
        });
    }
}

;// ./src/auth/commands/unlock.command.ts
var unlock_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore







class UnlockCommand {
    constructor(accountService, masterPasswordService, keyService, userVerificationService, cryptoFunctionService, logService, keyConnectorService, environmentService, organizationApiService, logout, i18nService) {
        this.accountService = accountService;
        this.masterPasswordService = masterPasswordService;
        this.keyService = keyService;
        this.userVerificationService = userVerificationService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.logService = logService;
        this.keyConnectorService = keyConnectorService;
        this.environmentService = environmentService;
        this.organizationApiService = organizationApiService;
        this.logout = logout;
        this.i18nService = i18nService;
    }
    run(password, cmdOptions) {
        return unlock_command_awaiter(this, void 0, void 0, function* () {
            const normalizedOptions = new unlock_command_Options(cmdOptions);
            const passwordResult = yield CliUtils.getPassword(password, normalizedOptions, this.logService);
            if (passwordResult instanceof bw_Response) {
                return passwordResult;
            }
            else {
                password = passwordResult;
            }
            yield this.setNewSessionKey();
            const [userId, email] = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe((0,external_rxjs_namespaceObject.map)((a) => [a === null || a === void 0 ? void 0 : a.id, a === null || a === void 0 ? void 0 : a.email])));
            const verification = {
                type: VerificationType.MasterPassword,
                secret: password,
            };
            let masterKey;
            try {
                const response = yield this.userVerificationService.verifyUserByMasterPassword(verification, userId, email);
                masterKey = response.masterKey;
            }
            catch (e) {
                // verification failure throws
                return bw_Response.error(e.message);
            }
            const userKey = yield this.masterPasswordService.decryptUserKeyWithMasterKey(masterKey, userId);
            yield this.keyService.setUserKey(userKey, userId);
            if (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.keyConnectorService.convertAccountRequired$)) {
                const convertToKeyConnectorCommand = new ConvertToKeyConnectorCommand(userId, this.keyConnectorService, this.environmentService, this.organizationApiService, this.logout, this.i18nService);
                const convertResponse = yield convertToKeyConnectorCommand.run();
                if (!convertResponse.success) {
                    return convertResponse;
                }
            }
            return this.successResponse();
        });
    }
    setNewSessionKey() {
        return unlock_command_awaiter(this, void 0, void 0, function* () {
            const key = yield this.cryptoFunctionService.randomBytes(64);
            process.env.BW_SESSION = utils_Utils.fromBufferToB64(key);
        });
    }
    successResponse() {
        return unlock_command_awaiter(this, void 0, void 0, function* () {
            const res = new MessageResponse("Your vault is now unlocked!", "\n" +
                "To unlock your vault, set your session key to the `BW_SESSION` environment variable. ex:\n" +
                '$ export BW_SESSION="' +
                process.env.BW_SESSION +
                '"\n' +
                '> $env:BW_SESSION="' +
                process.env.BW_SESSION +
                '"\n\n' +
                "You can also pass the session key to any command with the `--session` option. ex:\n" +
                "$ bw list items --session " +
                process.env.BW_SESSION);
            res.raw = process.env.BW_SESSION;
            return bw_Response.success(res);
        });
    }
}
class unlock_command_Options {
    constructor(passedOptions) {
        this.passwordEnv = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.passwordenv) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.passwordEnv);
        this.passwordFile = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.passwordfile) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.passwordFile);
    }
}

;// ../../libs/common/src/admin-console/models/request/selection-read-only.request.ts
class selection_read_only_request_SelectionReadOnlyRequest {
    constructor(id, readOnly, hidePasswords, manage) {
        this.id = id;
        this.readOnly = readOnly;
        this.hidePasswords = hidePasswords;
        this.manage = manage;
    }
}

;// ../../libs/common/src/models/export/collection.export.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore



class CollectionExport {
    static template() {
        const req = new CollectionExport();
        req.organizationId = "00000000-0000-0000-0000-000000000000";
        req.name = "Collection name";
        req.externalId = null;
        return req;
    }
    static toView(req, view = new CollectionView()) {
        view.name = req.name;
        view.externalId = req.externalId;
        if (view.organizationId == null) {
            view.organizationId = req.organizationId;
        }
        return view;
    }
    static toDomain(req, domain = new Collection()) {
        domain.name = req.name != null ? new enc_string_EncString(req.name) : null;
        domain.externalId = req.externalId;
        if (domain.organizationId == null) {
            domain.organizationId = req.organizationId;
        }
        return domain;
    }
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        this.organizationId = o.organizationId;
        this.name = safeGetString(o.name);
        this.externalId = o.externalId;
    }
}

;// ../../libs/common/src/vault/models/view/folder.view.ts
class FolderView {
    constructor(f) {
        this.id = null;
        this.name = null;
        this.revisionDate = null;
        if (!f) {
            return;
        }
        this.id = f.id;
        this.revisionDate = f.revisionDate;
    }
    static fromJSON(obj) {
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        return Object.assign(new FolderView(), obj, { revisionDate });
    }
}

;// ../../libs/common/src/vault/models/domain/folder.ts
var folder_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class Test extends (/* unused pure expression or super */ null && (Domain)) {
}
class Folder extends domain_base_Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            id: null,
            name: null,
        }, ["id"]);
        this.revisionDate = obj.revisionDate != null ? new Date(obj.revisionDate) : null;
    }
    decrypt() {
        return this.decryptObj(this, new FolderView(this), ["name"], null);
    }
    decryptWithKey(key, encryptService) {
        return folder_awaiter(this, void 0, void 0, function* () {
            const decrypted = yield this.decryptObjWithKey(["name"], key, encryptService, Folder);
            const view = new FolderView(decrypted);
            view.name = decrypted.name;
            return view;
        });
    }
    static fromJSON(obj) {
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        return Object.assign(new Folder(), obj, { name: enc_string_EncString.fromJSON(obj.name), revisionDate });
    }
}

;// ../../libs/common/src/models/export/folder.export.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore




class FolderExport {
    static template() {
        const req = new FolderExport();
        req.name = "Folder name";
        return req;
    }
    static toView(req, view = new FolderView()) {
        view.name = req.name;
        return view;
    }
    static toDomain(req, domain = new Folder()) {
        domain.name = req.name != null ? new enc_string_EncString(req.name) : null;
        return domain;
    }
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        this.name = safeGetString(o.name);
    }
}

;// ../../libs/common/src/models/export/collection-with-id.export.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore


class CollectionWithIdExport extends CollectionExport {
    static toView(req, view = new CollectionView()) {
        view.id = req.id;
        return super.toView(req, view);
    }
    static toDomain(req, domain = new Collection()) {
        domain.id = req.id;
        return super.toDomain(req, domain);
    }
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        this.id = o.id;
        super.build(o);
    }
}

;// ./src/admin-console/models/response/collection.response.ts

class collection_response_CollectionResponse extends CollectionWithIdExport {
    constructor(o) {
        super();
        this.object = "collection";
        this.build(o);
    }
}

;// ./src/admin-console/models/response/organization-collection.response.ts

class OrganizationCollectionResponse extends collection_response_CollectionResponse {
    constructor(o, groups, users) {
        super(o);
        this.object = "org-collection";
        this.groups = groups;
        this.users = users;
    }
}

;// ../../libs/common/src/models/export/folder-with-id.export.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore



class FolderWithIdExport extends FolderExport {
    static toView(req, view = new FolderView()) {
        view.id = req.id;
        return super.toView(req, view);
    }
    static toDomain(req, domain = new Folder()) {
        domain.id = req.id;
        return super.toDomain(req, domain);
    }
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        this.id = o.id;
        super.build(o);
    }
}

;// ../../libs/common/src/models/export/index.ts













;// ./src/vault/models/folder.response.ts

class FolderResponse extends FolderWithIdExport {
    constructor(o) {
        super();
        this.object = "folder";
        this.build(o);
    }
}

;// ./src/commands/edit.command.ts
var edit_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore














class EditCommand {
    constructor(cipherService, folderService, keyService, encryptService, apiService, folderApiService, accountService) {
        this.cipherService = cipherService;
        this.folderService = folderService;
        this.keyService = keyService;
        this.encryptService = encryptService;
        this.apiService = apiService;
        this.folderApiService = folderApiService;
        this.accountService = accountService;
    }
    run(object, id, requestJson, cmdOptions) {
        return edit_command_awaiter(this, void 0, void 0, function* () {
            if (process.env.BW_SERVE !== "true" && (requestJson == null || requestJson === "")) {
                requestJson = yield CliUtils.readStdin();
            }
            if (requestJson == null || requestJson === "") {
                return bw_Response.badRequest("`requestJson` was not provided.");
            }
            let req = null;
            if (typeof requestJson !== "string") {
                req = requestJson;
            }
            else {
                try {
                    const reqJson = Buffer.from(requestJson, "base64").toString();
                    req = JSON.parse(reqJson);
                    // FIXME: Remove when updating file. Eslint update
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                }
                catch (e) {
                    return bw_Response.badRequest("Error parsing the encoded request data.");
                }
            }
            if (id != null) {
                id = id.toLowerCase();
            }
            const normalizedOptions = new edit_command_Options(cmdOptions);
            switch (object.toLowerCase()) {
                case "item":
                    return yield this.editCipher(id, req);
                case "item-collections":
                    return yield this.editCipherCollections(id, req);
                case "folder":
                    return yield this.editFolder(id, req);
                case "org-collection":
                    return yield this.editOrganizationCollection(id, req, normalizedOptions);
                default:
                    return bw_Response.badRequest("Unknown object.");
            }
        });
    }
    editCipher(id, req) {
        return edit_command_awaiter(this, void 0, void 0, function* () {
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
            const cipher = yield this.cipherService.get(id, activeUserId);
            if (cipher == null) {
                return bw_Response.notFound();
            }
            let cipherView = yield this.cipherService.decrypt(cipher, activeUserId);
            if (cipherView.isDeleted) {
                return bw_Response.badRequest("You may not edit a deleted item. Use the restore command first.");
            }
            cipherView = CipherExport.toView(req, cipherView);
            const encCipher = yield this.cipherService.encrypt(cipherView, activeUserId);
            try {
                const updatedCipher = yield this.cipherService.updateWithServer(encCipher);
                const decCipher = yield this.cipherService.decrypt(updatedCipher, activeUserId);
                const res = new CipherResponse(decCipher);
                return bw_Response.success(res);
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
    editCipherCollections(id, req) {
        return edit_command_awaiter(this, void 0, void 0, function* () {
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
            const cipher = yield this.cipherService.get(id, activeUserId);
            if (cipher == null) {
                return bw_Response.notFound();
            }
            if (cipher.organizationId == null) {
                return bw_Response.badRequest("Item does not belong to an organization. Consider moving it first.");
            }
            if (!cipher.viewPassword) {
                return bw_Response.noEditPermission();
            }
            cipher.collectionIds = req;
            try {
                const updatedCipher = yield this.cipherService.saveCollectionsWithServer(cipher, activeUserId);
                const decCipher = yield this.cipherService.decrypt(updatedCipher, activeUserId);
                const res = new CipherResponse(decCipher);
                return bw_Response.success(res);
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
    editFolder(id, req) {
        return edit_command_awaiter(this, void 0, void 0, function* () {
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
            const folder = yield this.folderService.getFromState(id, activeUserId);
            if (folder == null) {
                return bw_Response.notFound();
            }
            let folderView = yield folder.decrypt();
            folderView = FolderExport.toView(req, folderView);
            const userKey = yield this.keyService.getUserKeyWithLegacySupport(activeUserId);
            const encFolder = yield this.folderService.encrypt(folderView, userKey);
            try {
                const folder = yield this.folderApiService.save(encFolder, activeUserId);
                const updatedFolder = new Folder(folder);
                const decFolder = yield updatedFolder.decrypt();
                const res = new FolderResponse(decFolder);
                return bw_Response.success(res);
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
    editOrganizationCollection(id, req, options) {
        return edit_command_awaiter(this, void 0, void 0, function* () {
            if (options.organizationId == null || options.organizationId === "") {
                return bw_Response.badRequest("`organizationid` option is required.");
            }
            if (!utils_Utils.isGuid(id)) {
                return bw_Response.badRequest("`" + id + "` is not a GUID.");
            }
            if (!utils_Utils.isGuid(options.organizationId)) {
                return bw_Response.badRequest("`" + options.organizationId + "` is not a GUID.");
            }
            if (options.organizationId !== req.organizationId) {
                return bw_Response.badRequest("`organizationid` option does not match request object.");
            }
            try {
                const orgKey = yield this.keyService.getOrgKey(req.organizationId);
                if (orgKey == null) {
                    throw new Error("No encryption key for this organization.");
                }
                const groups = req.groups == null
                    ? null
                    : req.groups.map((g) => new selection_read_only_request_SelectionReadOnlyRequest(g.id, g.readOnly, g.hidePasswords, g.manage));
                const users = req.users == null
                    ? null
                    : req.users.map((u) => new selection_read_only_request_SelectionReadOnlyRequest(u.id, u.readOnly, u.hidePasswords, u.manage));
                const request = new collection_request_CollectionRequest();
                request.name = (yield this.encryptService.encrypt(req.name, orgKey)).encryptedString;
                request.externalId = req.externalId;
                request.groups = groups;
                request.users = users;
                const response = yield this.apiService.putCollection(req.organizationId, id, request);
                const view = CollectionExport.toView(req);
                view.id = response.id;
                const res = new OrganizationCollectionResponse(view, groups, users);
                return bw_Response.success(res);
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
}
class edit_command_Options {
    constructor(passedOptions) {
        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);
    }
}

;// ../../libs/common/src/enums/client-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ClientType;
(function (ClientType) {
    ClientType["Web"] = "web";
    ClientType["Browser"] = "browser";
    ClientType["Desktop"] = "desktop";
    // Mobile = "mobile",
    ClientType["Cli"] = "cli";
    // DirectoryConnector = "connector",
})(ClientType || (ClientType = {}));

;// ../../libs/common/src/enums/device-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var DeviceType;
(function (DeviceType) {
    DeviceType[DeviceType["Android"] = 0] = "Android";
    DeviceType[DeviceType["iOS"] = 1] = "iOS";
    DeviceType[DeviceType["ChromeExtension"] = 2] = "ChromeExtension";
    DeviceType[DeviceType["FirefoxExtension"] = 3] = "FirefoxExtension";
    DeviceType[DeviceType["OperaExtension"] = 4] = "OperaExtension";
    DeviceType[DeviceType["EdgeExtension"] = 5] = "EdgeExtension";
    DeviceType[DeviceType["WindowsDesktop"] = 6] = "WindowsDesktop";
    DeviceType[DeviceType["MacOsDesktop"] = 7] = "MacOsDesktop";
    DeviceType[DeviceType["LinuxDesktop"] = 8] = "LinuxDesktop";
    DeviceType[DeviceType["ChromeBrowser"] = 9] = "ChromeBrowser";
    DeviceType[DeviceType["FirefoxBrowser"] = 10] = "FirefoxBrowser";
    DeviceType[DeviceType["OperaBrowser"] = 11] = "OperaBrowser";
    DeviceType[DeviceType["EdgeBrowser"] = 12] = "EdgeBrowser";
    DeviceType[DeviceType["IEBrowser"] = 13] = "IEBrowser";
    DeviceType[DeviceType["UnknownBrowser"] = 14] = "UnknownBrowser";
    DeviceType[DeviceType["AndroidAmazon"] = 15] = "AndroidAmazon";
    DeviceType[DeviceType["UWP"] = 16] = "UWP";
    DeviceType[DeviceType["SafariBrowser"] = 17] = "SafariBrowser";
    DeviceType[DeviceType["VivaldiBrowser"] = 18] = "VivaldiBrowser";
    DeviceType[DeviceType["VivaldiExtension"] = 19] = "VivaldiExtension";
    DeviceType[DeviceType["SafariExtension"] = 20] = "SafariExtension";
    DeviceType[DeviceType["SDK"] = 21] = "SDK";
    DeviceType[DeviceType["Server"] = 22] = "Server";
    DeviceType[DeviceType["WindowsCLI"] = 23] = "WindowsCLI";
    DeviceType[DeviceType["MacOsCLI"] = 24] = "MacOsCLI";
    DeviceType[DeviceType["LinuxCLI"] = 25] = "LinuxCLI";
})(DeviceType || (DeviceType = {}));
const DeviceTypeMetadata = {
    [DeviceType.Android]: { category: "mobile", platform: "Android" },
    [DeviceType.iOS]: { category: "mobile", platform: "iOS" },
    [DeviceType.AndroidAmazon]: { category: "mobile", platform: "Amazon" },
    [DeviceType.ChromeExtension]: { category: "extension", platform: "Chrome" },
    [DeviceType.FirefoxExtension]: { category: "extension", platform: "Firefox" },
    [DeviceType.OperaExtension]: { category: "extension", platform: "Opera" },
    [DeviceType.EdgeExtension]: { category: "extension", platform: "Edge" },
    [DeviceType.VivaldiExtension]: { category: "extension", platform: "Vivaldi" },
    [DeviceType.SafariExtension]: { category: "extension", platform: "Safari" },
    [DeviceType.ChromeBrowser]: { category: "webVault", platform: "Chrome" },
    [DeviceType.FirefoxBrowser]: { category: "webVault", platform: "Firefox" },
    [DeviceType.OperaBrowser]: { category: "webVault", platform: "Opera" },
    [DeviceType.EdgeBrowser]: { category: "webVault", platform: "Edge" },
    [DeviceType.IEBrowser]: { category: "webVault", platform: "IE" },
    [DeviceType.SafariBrowser]: { category: "webVault", platform: "Safari" },
    [DeviceType.VivaldiBrowser]: { category: "webVault", platform: "Vivaldi" },
    [DeviceType.UnknownBrowser]: { category: "webVault", platform: "Unknown" },
    [DeviceType.WindowsDesktop]: { category: "desktop", platform: "Windows" },
    [DeviceType.MacOsDesktop]: { category: "desktop", platform: "macOS" },
    [DeviceType.LinuxDesktop]: { category: "desktop", platform: "Linux" },
    [DeviceType.UWP]: { category: "desktop", platform: "Windows UWP" },
    [DeviceType.WindowsCLI]: { category: "cli", platform: "Windows" },
    [DeviceType.MacOsCLI]: { category: "cli", platform: "macOS" },
    [DeviceType.LinuxCLI]: { category: "cli", platform: "Linux" },
    [DeviceType.SDK]: { category: "sdk", platform: "" },
    [DeviceType.Server]: { category: "server", platform: "" },
};

;// ../../libs/common/src/enums/event-system-user.enum.ts
// Note: the enum key is used to describe the EventSystemUser in the UI. Be careful about changing it.
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var EventSystemUser;
(function (EventSystemUser) {
    EventSystemUser[EventSystemUser["SCIM"] = 1] = "SCIM";
    EventSystemUser[EventSystemUser["DomainVerification"] = 2] = "DomainVerification";
    EventSystemUser[EventSystemUser["PublicApi"] = 3] = "PublicApi";
})(EventSystemUser || (EventSystemUser = {}));

;// ../../libs/common/src/enums/event-type.enum.ts
// Increment by 100 for each new set of events
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var EventType;
(function (EventType) {
    EventType[EventType["User_LoggedIn"] = 1000] = "User_LoggedIn";
    EventType[EventType["User_ChangedPassword"] = 1001] = "User_ChangedPassword";
    EventType[EventType["User_Updated2fa"] = 1002] = "User_Updated2fa";
    EventType[EventType["User_Disabled2fa"] = 1003] = "User_Disabled2fa";
    EventType[EventType["User_Recovered2fa"] = 1004] = "User_Recovered2fa";
    EventType[EventType["User_FailedLogIn"] = 1005] = "User_FailedLogIn";
    EventType[EventType["User_FailedLogIn2fa"] = 1006] = "User_FailedLogIn2fa";
    EventType[EventType["User_ClientExportedVault"] = 1007] = "User_ClientExportedVault";
    EventType[EventType["User_UpdatedTempPassword"] = 1008] = "User_UpdatedTempPassword";
    EventType[EventType["User_MigratedKeyToKeyConnector"] = 1009] = "User_MigratedKeyToKeyConnector";
    EventType[EventType["User_RequestedDeviceApproval"] = 1010] = "User_RequestedDeviceApproval";
    EventType[EventType["User_TdeOffboardingPasswordSet"] = 1011] = "User_TdeOffboardingPasswordSet";
    EventType[EventType["Cipher_Created"] = 1100] = "Cipher_Created";
    EventType[EventType["Cipher_Updated"] = 1101] = "Cipher_Updated";
    EventType[EventType["Cipher_Deleted"] = 1102] = "Cipher_Deleted";
    EventType[EventType["Cipher_AttachmentCreated"] = 1103] = "Cipher_AttachmentCreated";
    EventType[EventType["Cipher_AttachmentDeleted"] = 1104] = "Cipher_AttachmentDeleted";
    EventType[EventType["Cipher_Shared"] = 1105] = "Cipher_Shared";
    EventType[EventType["Cipher_UpdatedCollections"] = 1106] = "Cipher_UpdatedCollections";
    EventType[EventType["Cipher_ClientViewed"] = 1107] = "Cipher_ClientViewed";
    EventType[EventType["Cipher_ClientToggledPasswordVisible"] = 1108] = "Cipher_ClientToggledPasswordVisible";
    EventType[EventType["Cipher_ClientToggledHiddenFieldVisible"] = 1109] = "Cipher_ClientToggledHiddenFieldVisible";
    EventType[EventType["Cipher_ClientToggledCardCodeVisible"] = 1110] = "Cipher_ClientToggledCardCodeVisible";
    EventType[EventType["Cipher_ClientCopiedPassword"] = 1111] = "Cipher_ClientCopiedPassword";
    EventType[EventType["Cipher_ClientCopiedHiddenField"] = 1112] = "Cipher_ClientCopiedHiddenField";
    EventType[EventType["Cipher_ClientCopiedCardCode"] = 1113] = "Cipher_ClientCopiedCardCode";
    EventType[EventType["Cipher_ClientAutofilled"] = 1114] = "Cipher_ClientAutofilled";
    EventType[EventType["Cipher_SoftDeleted"] = 1115] = "Cipher_SoftDeleted";
    EventType[EventType["Cipher_Restored"] = 1116] = "Cipher_Restored";
    EventType[EventType["Cipher_ClientToggledCardNumberVisible"] = 1117] = "Cipher_ClientToggledCardNumberVisible";
    EventType[EventType["Cipher_ClientToggledTOTPSeedVisible"] = 1118] = "Cipher_ClientToggledTOTPSeedVisible";
    EventType[EventType["Collection_Created"] = 1300] = "Collection_Created";
    EventType[EventType["Collection_Updated"] = 1301] = "Collection_Updated";
    EventType[EventType["Collection_Deleted"] = 1302] = "Collection_Deleted";
    EventType[EventType["Group_Created"] = 1400] = "Group_Created";
    EventType[EventType["Group_Updated"] = 1401] = "Group_Updated";
    EventType[EventType["Group_Deleted"] = 1402] = "Group_Deleted";
    EventType[EventType["OrganizationUser_Invited"] = 1500] = "OrganizationUser_Invited";
    EventType[EventType["OrganizationUser_Confirmed"] = 1501] = "OrganizationUser_Confirmed";
    EventType[EventType["OrganizationUser_Updated"] = 1502] = "OrganizationUser_Updated";
    EventType[EventType["OrganizationUser_Removed"] = 1503] = "OrganizationUser_Removed";
    EventType[EventType["OrganizationUser_UpdatedGroups"] = 1504] = "OrganizationUser_UpdatedGroups";
    EventType[EventType["OrganizationUser_UnlinkedSso"] = 1505] = "OrganizationUser_UnlinkedSso";
    EventType[EventType["OrganizationUser_ResetPassword_Enroll"] = 1506] = "OrganizationUser_ResetPassword_Enroll";
    EventType[EventType["OrganizationUser_ResetPassword_Withdraw"] = 1507] = "OrganizationUser_ResetPassword_Withdraw";
    EventType[EventType["OrganizationUser_AdminResetPassword"] = 1508] = "OrganizationUser_AdminResetPassword";
    EventType[EventType["OrganizationUser_ResetSsoLink"] = 1509] = "OrganizationUser_ResetSsoLink";
    EventType[EventType["OrganizationUser_FirstSsoLogin"] = 1510] = "OrganizationUser_FirstSsoLogin";
    EventType[EventType["OrganizationUser_Revoked"] = 1511] = "OrganizationUser_Revoked";
    EventType[EventType["OrganizationUser_Restored"] = 1512] = "OrganizationUser_Restored";
    EventType[EventType["OrganizationUser_ApprovedAuthRequest"] = 1513] = "OrganizationUser_ApprovedAuthRequest";
    EventType[EventType["OrganizationUser_RejectedAuthRequest"] = 1514] = "OrganizationUser_RejectedAuthRequest";
    EventType[EventType["OrganizationUser_Deleted"] = 1515] = "OrganizationUser_Deleted";
    EventType[EventType["OrganizationUser_Left"] = 1516] = "OrganizationUser_Left";
    EventType[EventType["Organization_Updated"] = 1600] = "Organization_Updated";
    EventType[EventType["Organization_PurgedVault"] = 1601] = "Organization_PurgedVault";
    EventType[EventType["Organization_ClientExportedVault"] = 1602] = "Organization_ClientExportedVault";
    EventType[EventType["Organization_VaultAccessed"] = 1603] = "Organization_VaultAccessed";
    EventType[EventType["Organization_EnabledSso"] = 1604] = "Organization_EnabledSso";
    EventType[EventType["Organization_DisabledSso"] = 1605] = "Organization_DisabledSso";
    EventType[EventType["Organization_EnabledKeyConnector"] = 1606] = "Organization_EnabledKeyConnector";
    EventType[EventType["Organization_DisabledKeyConnector"] = 1607] = "Organization_DisabledKeyConnector";
    EventType[EventType["Organization_SponsorshipsSynced"] = 1608] = "Organization_SponsorshipsSynced";
    EventType[EventType["Organization_CollectionManagementUpdated"] = 1609] = "Organization_CollectionManagementUpdated";
    EventType[EventType["Policy_Updated"] = 1700] = "Policy_Updated";
    EventType[EventType["ProviderUser_Invited"] = 1800] = "ProviderUser_Invited";
    EventType[EventType["ProviderUser_Confirmed"] = 1801] = "ProviderUser_Confirmed";
    EventType[EventType["ProviderUser_Updated"] = 1802] = "ProviderUser_Updated";
    EventType[EventType["ProviderUser_Removed"] = 1803] = "ProviderUser_Removed";
    EventType[EventType["ProviderOrganization_Created"] = 1900] = "ProviderOrganization_Created";
    EventType[EventType["ProviderOrganization_Added"] = 1901] = "ProviderOrganization_Added";
    EventType[EventType["ProviderOrganization_Removed"] = 1902] = "ProviderOrganization_Removed";
    EventType[EventType["ProviderOrganization_VaultAccessed"] = 1903] = "ProviderOrganization_VaultAccessed";
    EventType[EventType["OrganizationDomain_Added"] = 2000] = "OrganizationDomain_Added";
    EventType[EventType["OrganizationDomain_Removed"] = 2001] = "OrganizationDomain_Removed";
    EventType[EventType["OrganizationDomain_Verified"] = 2002] = "OrganizationDomain_Verified";
    EventType[EventType["OrganizationDomain_NotVerified"] = 2003] = "OrganizationDomain_NotVerified";
    EventType[EventType["Secret_Retrieved"] = 2100] = "Secret_Retrieved";
})(EventType || (EventType = {}));

;// ../../libs/common/src/enums/http-status-code.enum.ts
/**
 * Hypertext Transfer Protocol (HTTP) response status codes.
 *
 * @see {@link https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}
 * src: https://gist.github.com/RWOverdijk/6cef816cfdf5722228e01cc05fd4b094
 */
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var HttpStatusCode;
(function (HttpStatusCode) {
    /**
     * The server has received the request headers and the client should proceed to send the request body
     * (in the case of a request for which a body needs to be sent; for example, a POST request).
     * Sending a large request body to a server after a request has been rejected for inappropriate headers would be inefficient.
     * To have a server check the request's headers, a client must send Expect: 100-continue as a header in its initial request
     * and receive a 100 Continue status code in response before sending the body. The response 417 Expectation Failed indicates the request should not be continued.
     */
    HttpStatusCode[HttpStatusCode["Continue"] = 100] = "Continue";
    /**
     * The requester has asked the server to switch protocols and the server has agreed to do so.
     */
    HttpStatusCode[HttpStatusCode["SwitchingProtocols"] = 101] = "SwitchingProtocols";
    /**
     * A WebDAV request may contain many sub-requests involving file operations, requiring a long time to complete the request.
     * This code indicates that the server has received and is processing the request, but no response is available yet.
     * This prevents the client from timing out and assuming the request was lost.
     */
    HttpStatusCode[HttpStatusCode["Processing"] = 102] = "Processing";
    // **********************************************************************************************************
    // 200s - SUCCESS
    // **********************************************************************************************************
    /**
     * Standard response for successful HTTP requests.
     * The actual response will depend on the request method used.
     * In a GET request, the response will contain an entity corresponding to the requested resource.
     * In a POST request, the response will contain an entity describing or containing the result of the action.
     */
    HttpStatusCode[HttpStatusCode["Ok"] = 200] = "Ok";
    /**
     * The request has been fulfilled, resulting in the creation of a new resource.
     */
    HttpStatusCode[HttpStatusCode["Created"] = 201] = "Created";
    /**
     * The request has been accepted for processing, but the processing has not been completed.
     * The request might or might not be eventually acted upon, and may be disallowed when processing occurs.
     */
    HttpStatusCode[HttpStatusCode["Accepted"] = 202] = "Accepted";
    /**
     * SINCE HTTP/1.1
     * The server is a transforming proxy that received a 200 OK from its origin,
     * but is returning a modified version of the origin's response.
     */
    HttpStatusCode[HttpStatusCode["NonAuthoritativeInformation"] = 203] = "NonAuthoritativeInformation";
    /**
     * The server successfully processed the request and is not returning any content.
     */
    HttpStatusCode[HttpStatusCode["NoContent"] = 204] = "NoContent";
    /**
     * The server successfully processed the request, but is not returning any content.
     * Unlike a 204 response, this response requires that the requester reset the document view.
     */
    HttpStatusCode[HttpStatusCode["ResetContent"] = 205] = "ResetContent";
    /**
     * The server is delivering only part of the resource (byte serving) due to a range header sent by the client.
     * The range header is used by HTTP clients to enable resuming of interrupted downloads,
     * or split a download into multiple simultaneous streams.
     */
    HttpStatusCode[HttpStatusCode["PartialContent"] = 206] = "PartialContent";
    /**
     * The message body that follows is an XML message and can contain a number of separate response codes,
     * depending on how many sub-requests were made.
     */
    HttpStatusCode[HttpStatusCode["MultiStatus"] = 207] = "MultiStatus";
    /**
     * The members of a DAV binding have already been enumerated in a preceding part of the (multistatus) response,
     * and are not being included again.
     */
    HttpStatusCode[HttpStatusCode["AlreadyReported"] = 208] = "AlreadyReported";
    /**
     * The server has fulfilled a request for the resource,
     * and the response is a representation of the result of one or more instance-manipulations applied to the current instance.
     */
    HttpStatusCode[HttpStatusCode["ImUsed"] = 226] = "ImUsed";
    // **********************************************************************************************************
    // 300s - Redirections
    // **********************************************************************************************************
    /**
     * Indicates multiple options for the resource from which the client may choose (via agent-driven content negotiation).
     * For example, this code could be used to present multiple video format options,
     * to list files with different filename extensions, or to suggest word-sense disambiguation.
     */
    HttpStatusCode[HttpStatusCode["MultipleChoices"] = 300] = "MultipleChoices";
    /**
     * This and all future requests should be directed to the given URI.
     */
    HttpStatusCode[HttpStatusCode["MovedPermanently"] = 301] = "MovedPermanently";
    /**
     * This is an example of industry practice contradicting the standard.
     * The HTTP/1.0 specification (RFC 1945) required the client to perform a temporary redirect
     * (the original describing phrase was "Moved Temporarily"), but popular browsers implemented 302
     * with the functionality of a 303 See Other. Therefore, HTTP/1.1 added status codes 303 and 307
     * to distinguish between the two behaviours. However, some Web applications and frameworks
     * use the 302 status code as if it were the 303.
     */
    HttpStatusCode[HttpStatusCode["Found"] = 302] = "Found";
    /**
     * SINCE HTTP/1.1
     * The response to the request can be found under another URI using a GET method.
     * When received in response to a POST (or PUT/DELETE), the client should presume that
     * the server has received the data and should issue a redirect with a separate GET message.
     */
    HttpStatusCode[HttpStatusCode["SeeOther"] = 303] = "SeeOther";
    /**
     * Indicates that the resource has not been modified since the version specified by the request headers If-Modified-Since or If-None-Match.
     * In such case, there is no need to retransmit the resource since the client still has a previously-downloaded copy.
     */
    HttpStatusCode[HttpStatusCode["NotModified"] = 304] = "NotModified";
    /**
     * SINCE HTTP/1.1
     * The requested resource is available only through a proxy, the address for which is provided in the response.
     * Many HTTP clients (such as Mozilla and Internet Explorer) do not correctly handle responses with this status code, primarily for security reasons.
     */
    HttpStatusCode[HttpStatusCode["UseProxy"] = 305] = "UseProxy";
    /**
     * No longer used. Originally meant "Subsequent requests should use the specified proxy."
     */
    HttpStatusCode[HttpStatusCode["SwitchProxy"] = 306] = "SwitchProxy";
    /**
     * SINCE HTTP/1.1
     * In this case, the request should be repeated with another URI; however, future requests should still use the original URI.
     * In contrast to how 302 was historically implemented, the request method is not allowed to be changed when reissuing the original request.
     * For example, a POST request should be repeated using another POST request.
     */
    HttpStatusCode[HttpStatusCode["TemporaryRedirect"] = 307] = "TemporaryRedirect";
    /**
     * The request and all future requests should be repeated using another URI.
     * 307 and 308 parallel the behaviors of 302 and 301, but do not allow the HTTP method to change.
     * So, for example, submitting a form to a permanently redirected resource may continue smoothly.
     */
    HttpStatusCode[HttpStatusCode["PermanentRedirect"] = 308] = "PermanentRedirect";
    // **********************************************************************************************************
    // 400s - Client / User messed up
    // **********************************************************************************************************
    /**
     * The server cannot or will not process the request due to an apparent client error
     * (e.g., malformed request syntax, too large size, invalid request message framing, or deceptive request routing).
     */
    HttpStatusCode[HttpStatusCode["BadRequest"] = 400] = "BadRequest";
    /**
     * Similar to 403 Forbidden, but specifically for use when authentication is required and has failed or has not yet
     * been provided. The response must include a WWW-Authenticate header field containing a challenge applicable to the
     * requested resource. See Basic access authentication and Digest access authentication. 401 semantically means
     * "unauthenticated",i.e. the user does not have the necessary credentials.
     */
    HttpStatusCode[HttpStatusCode["Unauthorized"] = 401] = "Unauthorized";
    /**
     * Reserved for future use. The original intention was that this code might be used as part of some form of digital
     * cash or micro payment scheme, but that has not happened, and this code is not usually used.
     * Google Developers API uses this status if a particular developer has exceeded the daily limit on requests.
     */
    HttpStatusCode[HttpStatusCode["PaymentRequired"] = 402] = "PaymentRequired";
    /**
     * The request was valid, but the server is refusing action.
     * The user might not have the necessary permissions for a resource.
     */
    HttpStatusCode[HttpStatusCode["Forbidden"] = 403] = "Forbidden";
    /**
     * The requested resource could not be found but may be available in the future.
     * Subsequent requests by the client are permissible.
     */
    HttpStatusCode[HttpStatusCode["NotFound"] = 404] = "NotFound";
    /**
     * A request method is not supported for the requested resource;
     * for example, a GET request on a form that requires data to be presented via POST, or a PUT request on a read-only resource.
     */
    HttpStatusCode[HttpStatusCode["MethodNotAllowed"] = 405] = "MethodNotAllowed";
    /**
     * The requested resource is capable of generating only content not acceptable according to the Accept headers sent in the request.
     */
    HttpStatusCode[HttpStatusCode["NotAcceptable"] = 406] = "NotAcceptable";
    /**
     * The client must first authenticate itself with the proxy.
     */
    HttpStatusCode[HttpStatusCode["ProxyAuthenticationRequired"] = 407] = "ProxyAuthenticationRequired";
    /**
     * The server timed out waiting for the request.
     * According to HTTP specifications:
     * "The client did not produce a request within the time that the server was prepared to wait. The client MAY repeat the request without modifications at any later time."
     */
    HttpStatusCode[HttpStatusCode["RequestTimeout"] = 408] = "RequestTimeout";
    /**
     * Indicates that the request could not be processed because of conflict in the request,
     * such as an edit conflict between multiple simultaneous updates.
     */
    HttpStatusCode[HttpStatusCode["Conflict"] = 409] = "Conflict";
    /**
     * Indicates that the resource requested is no longer available and will not be available again.
     * This should be used when a resource has been intentionally removed and the resource should be purged.
     * Upon receiving a 410 status code, the client should not request the resource in the future.
     * Clients such as search engines should remove the resource from their indices.
     * Most use cases do not require clients and search engines to purge the resource, and a "404 Not Found" may be used instead.
     */
    HttpStatusCode[HttpStatusCode["Gone"] = 410] = "Gone";
    /**
     * The request did not specify the length of its content, which is required by the requested resource.
     */
    HttpStatusCode[HttpStatusCode["LengthRequired"] = 411] = "LengthRequired";
    /**
     * The server does not meet one of the preconditions that the requester put on the request.
     */
    HttpStatusCode[HttpStatusCode["PreconditionFailed"] = 412] = "PreconditionFailed";
    /**
     * The request is larger than the server is willing or able to process. Previously called "Request Entity Too Large".
     */
    HttpStatusCode[HttpStatusCode["PayloadTooLarge"] = 413] = "PayloadTooLarge";
    /**
     * The URI provided was too long for the server to process. Often the result of too much data being encoded as a query-string of a GET request,
     * in which case it should be converted to a POST request.
     * Called "Request-URI Too Long" previously.
     */
    HttpStatusCode[HttpStatusCode["UriTooLong"] = 414] = "UriTooLong";
    /**
     * The request entity has a media type which the server or resource does not support.
     * For example, the client uploads an image as image/svg+xml, but the server requires that images use a different format.
     */
    HttpStatusCode[HttpStatusCode["UnsupportedMediaType"] = 415] = "UnsupportedMediaType";
    /**
     * The client has asked for a portion of the file (byte serving), but the server cannot supply that portion.
     * For example, if the client asked for a part of the file that lies beyond the end of the file.
     * Called "Requested Range Not Satisfiable" previously.
     */
    HttpStatusCode[HttpStatusCode["RangeNotSatisfiable"] = 416] = "RangeNotSatisfiable";
    /**
     * The server cannot meet the requirements of the Expect request-header field.
     */
    HttpStatusCode[HttpStatusCode["ExpectationFailed"] = 417] = "ExpectationFailed";
    /**
     * This code was defined in 1998 as one of the traditional IETF April Fools' jokes, in RFC 2324, Hyper Text Coffee Pot Control Protocol,
     * and is not expected to be implemented by actual HTTP servers. The RFC specifies this code should be returned by
     * teapots requested to brew coffee. This HTTP status is used as an Easter egg in some websites, including Google.com.
     */
    HttpStatusCode[HttpStatusCode["IAmATeapot"] = 418] = "IAmATeapot";
    /**
     * The request was directed at a server that is not able to produce a response (for example because a connection reuse).
     */
    HttpStatusCode[HttpStatusCode["MisdirectedRequest"] = 421] = "MisdirectedRequest";
    /**
     * The request was well-formed but was unable to be followed due to semantic errors.
     */
    HttpStatusCode[HttpStatusCode["UnprocessableEntity"] = 422] = "UnprocessableEntity";
    /**
     * The resource that is being accessed is locked.
     */
    HttpStatusCode[HttpStatusCode["Locked"] = 423] = "Locked";
    /**
     * The request failed due to failure of a previous request (e.g., a PROPPATCH).
     */
    HttpStatusCode[HttpStatusCode["FailedDependency"] = 424] = "FailedDependency";
    /**
     * The client should switch to a different protocol such as TLS/1.0, given in the Upgrade header field.
     */
    HttpStatusCode[HttpStatusCode["UpgradeRequired"] = 426] = "UpgradeRequired";
    /**
     * The origin server requires the request to be conditional.
     * Intended to prevent "the 'lost update' problem, where a client
     * GETs a resource's state, modifies it, and PUTs it back to the server,
     * when meanwhile a third party has modified the state on the server, leading to a conflict."
     */
    HttpStatusCode[HttpStatusCode["PreconditionRequired"] = 428] = "PreconditionRequired";
    /**
     * The user has sent too many requests in a given amount of time. Intended for use with rate-limiting schemes.
     */
    HttpStatusCode[HttpStatusCode["TooManyRequests"] = 429] = "TooManyRequests";
    /**
     * The server is unwilling to process the request because either an individual header field,
     * or all the header fields collectively, are too large.
     */
    HttpStatusCode[HttpStatusCode["RequestHeaderFieldsTooLarge"] = 431] = "RequestHeaderFieldsTooLarge";
    /**
     * A server operator has received a legal demand to deny access to a resource or to a set of resources
     * that includes the requested resource. The code 451 was chosen as a reference to the novel Fahrenheit 451.
     */
    HttpStatusCode[HttpStatusCode["UnavailableForLegalReasons"] = 451] = "UnavailableForLegalReasons";
    // **********************************************************************************************************
    // 500s - Server messed up
    // **********************************************************************************************************
    /**
     * A generic error message, given when an unexpected condition was encountered and no more specific message is suitable.
     */
    HttpStatusCode[HttpStatusCode["InternalServerError"] = 500] = "InternalServerError";
    /**
     * The server either does not recognize the request method, or it lacks the ability to fulfill the request.
     * Usually this implies future availability (e.g., a new feature of a web-service API).
     */
    HttpStatusCode[HttpStatusCode["NotImplemented"] = 501] = "NotImplemented";
    /**
     * The server was acting as a gateway or proxy and received an invalid response from the upstream server.
     */
    HttpStatusCode[HttpStatusCode["BadGateway"] = 502] = "BadGateway";
    /**
     * The server is currently unavailable (because it is overloaded or down for maintenance).
     * Generally, this is a temporary state.
     */
    HttpStatusCode[HttpStatusCode["ServiceUnavailable"] = 503] = "ServiceUnavailable";
    /**
     * The server was acting as a gateway or proxy and did not receive a timely response from the upstream server.
     */
    HttpStatusCode[HttpStatusCode["GatewayTimeout"] = 504] = "GatewayTimeout";
    /**
     * The server does not support the HTTP protocol version used in the request
     */
    HttpStatusCode[HttpStatusCode["HttpVersionNotSupported"] = 505] = "HttpVersionNotSupported";
    /**
     * Transparent content negotiation for the request results in a circular reference.
     */
    HttpStatusCode[HttpStatusCode["VariantAlsoNegotiates"] = 506] = "VariantAlsoNegotiates";
    /**
     * The server is unable to store the representation needed to complete the request.
     */
    HttpStatusCode[HttpStatusCode["InsufficientStorage"] = 507] = "InsufficientStorage";
    /**
     * The server detected an infinite loop while processing the request.
     */
    HttpStatusCode[HttpStatusCode["LoopDetected"] = 508] = "LoopDetected";
    /**
     * Further extensions to the request are required for the server to fulfill it.
     */
    HttpStatusCode[HttpStatusCode["NotExtended"] = 510] = "NotExtended";
    /**
     * The client needs to authenticate to gain network access.
     * Intended for use by intercepting proxies used to control access to the network (e.g., "captive portals" used
     * to require agreement to Terms of Service before granting full Internet access via a Wi-Fi hotspot).
     */
    HttpStatusCode[HttpStatusCode["NetworkAuthenticationRequired"] = 511] = "NetworkAuthenticationRequired";
})(HttpStatusCode || (HttpStatusCode = {}));

;// ../../libs/common/src/enums/integration-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var IntegrationType;
(function (IntegrationType) {
    IntegrationType["Integration"] = "integration";
    IntegrationType["SDK"] = "sdk";
    IntegrationType["SSO"] = "sso";
    IntegrationType["SCIM"] = "scim";
    IntegrationType["BWDC"] = "bwdc";
    IntegrationType["EVENT"] = "event";
    IntegrationType["DEVICE"] = "device";
})(IntegrationType || (IntegrationType = {}));

;// ../../libs/common/src/enums/native-messaging-version.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var NativeMessagingVersion;
(function (NativeMessagingVersion) {
    NativeMessagingVersion[NativeMessagingVersion["One"] = 1] = "One";
    NativeMessagingVersion[NativeMessagingVersion["Latest"] = 1] = "Latest";
})(NativeMessagingVersion || (NativeMessagingVersion = {}));

;// ../../libs/common/src/enums/notification-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var NotificationType;
(function (NotificationType) {
    NotificationType[NotificationType["SyncCipherUpdate"] = 0] = "SyncCipherUpdate";
    NotificationType[NotificationType["SyncCipherCreate"] = 1] = "SyncCipherCreate";
    NotificationType[NotificationType["SyncLoginDelete"] = 2] = "SyncLoginDelete";
    NotificationType[NotificationType["SyncFolderDelete"] = 3] = "SyncFolderDelete";
    NotificationType[NotificationType["SyncCiphers"] = 4] = "SyncCiphers";
    NotificationType[NotificationType["SyncVault"] = 5] = "SyncVault";
    NotificationType[NotificationType["SyncOrgKeys"] = 6] = "SyncOrgKeys";
    NotificationType[NotificationType["SyncFolderCreate"] = 7] = "SyncFolderCreate";
    NotificationType[NotificationType["SyncFolderUpdate"] = 8] = "SyncFolderUpdate";
    NotificationType[NotificationType["SyncCipherDelete"] = 9] = "SyncCipherDelete";
    NotificationType[NotificationType["SyncSettings"] = 10] = "SyncSettings";
    NotificationType[NotificationType["LogOut"] = 11] = "LogOut";
    NotificationType[NotificationType["SyncSendCreate"] = 12] = "SyncSendCreate";
    NotificationType[NotificationType["SyncSendUpdate"] = 13] = "SyncSendUpdate";
    NotificationType[NotificationType["SyncSendDelete"] = 14] = "SyncSendDelete";
    NotificationType[NotificationType["AuthRequest"] = 15] = "AuthRequest";
    NotificationType[NotificationType["AuthRequestResponse"] = 16] = "AuthRequestResponse";
    NotificationType[NotificationType["SyncOrganizations"] = 17] = "SyncOrganizations";
    NotificationType[NotificationType["SyncOrganizationStatusChanged"] = 18] = "SyncOrganizationStatusChanged";
    NotificationType[NotificationType["SyncOrganizationCollectionSettingChanged"] = 19] = "SyncOrganizationCollectionSettingChanged";
    NotificationType[NotificationType["Notification"] = 20] = "Notification";
    NotificationType[NotificationType["NotificationStatus"] = 21] = "NotificationStatus";
    NotificationType[NotificationType["PendingSecurityTasks"] = 22] = "PendingSecurityTasks";
})(NotificationType || (NotificationType = {}));

;// ../../libs/common/src/enums/index.ts









;// ../../libs/common/src/tools/send/enums/send-type.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var SendType;
(function (SendType) {
    SendType[SendType["Text"] = 0] = "Text";
    SendType[SendType["File"] = 1] = "File";
})(SendType || (SendType = {}));

;// ./src/admin-console/models/selection-read-only.ts
class SelectionReadOnly {
    static template() {
        return new SelectionReadOnly("00000000-0000-0000-0000-000000000000", false, false, false);
    }
    constructor(id, readOnly, hidePasswords, manage) {
        this.id = id;
        this.readOnly = readOnly;
        this.hidePasswords = hidePasswords || false;
        this.manage = manage;
    }
}

;// ./src/admin-console/models/request/organization-collection.request.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore


class OrganizationCollectionRequest extends CollectionExport {
    static template() {
        const req = new OrganizationCollectionRequest();
        req.organizationId = "00000000-0000-0000-0000-000000000000";
        req.name = "Collection name";
        req.externalId = null;
        req.groups = [SelectionReadOnly.template(), SelectionReadOnly.template()];
        req.users = [SelectionReadOnly.template(), SelectionReadOnly.template()];
        return req;
    }
}

;// ./src/admin-console/models/response/organization.response.ts
class OrganizationResponse {
    constructor(o) {
        this.object = "organization";
        this.id = o.id;
        this.name = o.name;
        this.status = o.status;
        this.type = o.type;
        this.enabled = o.enabled;
    }
}

;// ./src/models/response/string.response.ts
class StringResponse {
    constructor(data) {
        this.object = "string";
        this.data = data;
    }
}

;// ./src/models/response/template.response.ts
class TemplateResponse {
    constructor(template) {
        this.object = "template";
        this.template = template;
    }
}

;// ../../libs/common/src/tools/send/models/view/send-file.view.ts
class SendFileView {
    constructor(f) {
        this.id = null;
        this.size = null;
        this.sizeName = null;
        this.fileName = null;
        if (!f) {
            return;
        }
        this.id = f.id;
        this.size = f.size;
        this.sizeName = f.sizeName;
    }
    get fileSize() {
        try {
            if (this.size != null) {
                return parseInt(this.size, null);
            }
        }
        catch (_a) {
            // Invalid file size.
        }
        return 0;
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new SendFileView(), json);
    }
}

;// ../../libs/common/src/tools/send/models/view/send-text.view.ts
class SendTextView {
    constructor(t) {
        this.text = null;
        if (!t) {
            return;
        }
        this.hidden = t.hidden;
    }
    get maskedText() {
        return this.text != null ? "••••••••" : null;
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new SendTextView(), json);
    }
}

;// ../../libs/common/src/tools/send/models/view/send.view.ts




class SendView {
    constructor(s) {
        this.id = null;
        this.accessId = null;
        this.name = null;
        this.notes = null;
        this.type = null;
        this.text = new SendTextView();
        this.file = new SendFileView();
        this.maxAccessCount = null;
        this.accessCount = 0;
        this.revisionDate = null;
        this.deletionDate = null;
        this.expirationDate = null;
        this.password = null;
        this.disabled = false;
        this.hideEmail = false;
        if (!s) {
            return;
        }
        this.id = s.id;
        this.accessId = s.accessId;
        this.type = s.type;
        this.maxAccessCount = s.maxAccessCount;
        this.accessCount = s.accessCount;
        this.revisionDate = s.revisionDate;
        this.deletionDate = s.deletionDate;
        this.expirationDate = s.expirationDate;
        this.disabled = s.disabled;
        this.password = s.password;
        this.hideEmail = s.hideEmail;
    }
    get urlB64Key() {
        return utils_Utils.fromBufferToUrlB64(this.key);
    }
    get maxAccessCountReached() {
        if (this.maxAccessCount == null) {
            return false;
        }
        return this.accessCount >= this.maxAccessCount;
    }
    get expired() {
        if (this.expirationDate == null) {
            return false;
        }
        return this.expirationDate <= new Date();
    }
    get pendingDelete() {
        return this.deletionDate <= new Date();
    }
    toJSON() {
        return utils_Utils.merge(Object.assign({}, this), {
            key: utils_Utils.fromBufferToB64(this.key),
        });
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new SendView(), json, {
            key: utils_Utils.fromB64ToArray(json.key),
            cryptoKey: SymmetricCryptoKey.fromJSON(json.cryptoKey),
            text: SendTextView.fromJSON(json.text),
            file: SendFileView.fromJSON(json.file),
            revisionDate: json.revisionDate == null ? null : new Date(json.revisionDate),
            deletionDate: json.deletionDate == null ? null : new Date(json.deletionDate),
            expirationDate: json.expirationDate == null ? null : new Date(json.expirationDate),
        });
    }
}

;// ./src/tools/send/models/send-file.response.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

class SendFileResponse {
    static template(fileName = "file attachment location") {
        const req = new SendFileResponse();
        req.fileName = fileName;
        return req;
    }
    static toView(file, view = new SendFileView()) {
        if (file == null) {
            return null;
        }
        view.id = file.id;
        view.size = file.size;
        view.sizeName = file.sizeName;
        view.fileName = file.fileName;
        return view;
    }
    constructor(o) {
        if (o == null) {
            return;
        }
        this.id = o.id;
        this.size = o.size;
        this.sizeName = o.sizeName;
        this.fileName = o.fileName;
    }
}

;// ./src/tools/send/models/send-text.response.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

class SendTextResponse {
    static template(text = "Text contained in the send.", hidden = false) {
        const req = new SendTextResponse();
        req.text = text;
        req.hidden = hidden;
        return req;
    }
    static toView(text, view = new SendTextView()) {
        if (text == null) {
            return null;
        }
        view.text = text.text;
        view.hidden = text.hidden;
        return view;
    }
    constructor(o) {
        if (o == null) {
            return;
        }
        this.text = o.text;
        this.hidden = o.hidden;
    }
}

;// ./src/tools/send/models/send.response.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore





const dateProperties = [
    utils_Utils.nameOf("deletionDate"),
    utils_Utils.nameOf("expirationDate"),
];
class SendResponse {
    static template(sendType, deleteInDays = 7) {
        const req = new SendResponse();
        req.name = "Send name";
        req.notes = "Some notes about this send.";
        req.type = sendType === SendType.File ? SendType.File : SendType.Text;
        req.text = sendType === SendType.Text ? SendTextResponse.template() : null;
        req.file = sendType === SendType.File ? SendFileResponse.template() : null;
        req.maxAccessCount = null;
        req.deletionDate = this.getStandardDeletionDate(deleteInDays);
        req.expirationDate = null;
        req.password = null;
        req.disabled = false;
        req.hideEmail = false;
        return req;
    }
    static toView(send, view = new SendView()) {
        if (send == null) {
            return null;
        }
        view.id = send.id;
        view.accessId = send.accessId;
        view.name = send.name;
        view.notes = send.notes;
        view.key = send.key == null ? null : utils_Utils.fromB64ToArray(send.key);
        view.type = send.type;
        view.file = SendFileResponse.toView(send.file);
        view.text = SendTextResponse.toView(send.text);
        view.maxAccessCount = send.maxAccessCount;
        view.accessCount = send.accessCount;
        view.revisionDate = send.revisionDate;
        view.deletionDate = send.deletionDate;
        view.expirationDate = send.expirationDate;
        view.password = send.password;
        view.disabled = send.disabled;
        view.hideEmail = send.hideEmail;
        return view;
    }
    static fromJson(json) {
        return JSON.parse(json, (key, value) => {
            if (dateProperties.includes(key)) {
                return value == null ? null : new Date(value);
            }
            return value;
        });
    }
    static getStandardDeletionDate(days) {
        const d = new Date();
        d.setTime(d.getTime() + days * 86400000); // ms per day
        return d;
    }
    constructor(o, webVaultUrl) {
        this.object = "send";
        if (o == null) {
            return;
        }
        this.id = o.id;
        this.accessId = o.accessId;
        let sendLinkBaseUrl = webVaultUrl;
        if (sendLinkBaseUrl == null) {
            sendLinkBaseUrl = "https://send.bitwarden.com/#";
        }
        else {
            sendLinkBaseUrl += "/#/send/";
        }
        this.accessUrl = sendLinkBaseUrl + this.accessId + "/" + o.urlB64Key;
        this.name = o.name;
        this.notes = o.notes;
        this.key = utils_Utils.fromBufferToB64(o.key);
        this.type = o.type;
        this.maxAccessCount = o.maxAccessCount;
        this.accessCount = o.accessCount;
        this.revisionDate = o.revisionDate;
        this.deletionDate = o.deletionDate;
        this.expirationDate = o.expirationDate;
        this.passwordSet = o.password != null;
        this.disabled = o.disabled;
        this.hideEmail = o.hideEmail;
        if (o.type === SendType.Text && o.text != null) {
            this.text = new SendTextResponse(o.text);
        }
        if (o.type === SendType.File && o.file != null) {
            this.file = new SendFileResponse(o.file);
        }
    }
}

;// ../../libs/common/src/platform/models/domain/enc-array-buffer.ts
var enc_array_buffer_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore


const ENC_TYPE_LENGTH = 1;
const IV_LENGTH = 16;
const MAC_LENGTH = 32;
const MIN_DATA_LENGTH = 1;
class EncArrayBuffer {
    constructor(buffer) {
        this.buffer = buffer;
        this.encryptionType = null;
        this.dataBytes = null;
        this.ivBytes = null;
        this.macBytes = null;
        const encBytes = buffer;
        const encType = encBytes[0];
        switch (encType) {
            case EncryptionType.AesCbc256_HmacSha256_B64: {
                const minimumLength = ENC_TYPE_LENGTH + IV_LENGTH + MAC_LENGTH + MIN_DATA_LENGTH;
                if (encBytes.length < minimumLength) {
                    this.throwDecryptionError();
                }
                this.ivBytes = encBytes.slice(ENC_TYPE_LENGTH, ENC_TYPE_LENGTH + IV_LENGTH);
                this.macBytes = encBytes.slice(ENC_TYPE_LENGTH + IV_LENGTH, ENC_TYPE_LENGTH + IV_LENGTH + MAC_LENGTH);
                this.dataBytes = encBytes.slice(ENC_TYPE_LENGTH + IV_LENGTH + MAC_LENGTH);
                break;
            }
            case EncryptionType.AesCbc256_B64: {
                const minimumLength = ENC_TYPE_LENGTH + IV_LENGTH + MIN_DATA_LENGTH;
                if (encBytes.length < minimumLength) {
                    this.throwDecryptionError();
                }
                this.ivBytes = encBytes.slice(ENC_TYPE_LENGTH, ENC_TYPE_LENGTH + IV_LENGTH);
                this.dataBytes = encBytes.slice(ENC_TYPE_LENGTH + IV_LENGTH);
                break;
            }
            default:
                this.throwDecryptionError();
        }
        this.encryptionType = encType;
    }
    throwDecryptionError() {
        throw new Error("Error parsing encrypted ArrayBuffer: data is corrupted or has an invalid format.");
    }
    static fromParts(encryptionType, iv, data, mac) {
        if (encryptionType == null || iv == null || data == null) {
            throw new Error("encryptionType, iv, and data must be provided");
        }
        switch (encryptionType) {
            case EncryptionType.AesCbc256_B64:
            case EncryptionType.AesCbc256_HmacSha256_B64:
                EncArrayBuffer.validateIvLength(iv);
                EncArrayBuffer.validateMacLength(encryptionType, mac);
                break;
            default:
                throw new Error(`Unknown EncryptionType ${encryptionType} for EncArrayBuffer.fromParts`);
        }
        let macLen = 0;
        if (mac != null) {
            macLen = mac.length;
        }
        const bytes = new Uint8Array(1 + iv.byteLength + macLen + data.byteLength);
        bytes.set([encryptionType], 0);
        bytes.set(iv, 1);
        if (mac != null) {
            bytes.set(mac, 1 + iv.byteLength);
        }
        bytes.set(data, 1 + iv.byteLength + macLen);
        return new EncArrayBuffer(bytes);
    }
    static fromResponse(response) {
        return enc_array_buffer_awaiter(this, void 0, void 0, function* () {
            const buffer = yield response.arrayBuffer();
            if (buffer == null) {
                throw new Error("Cannot create EncArrayBuffer from Response - Response is empty");
            }
            return new EncArrayBuffer(new Uint8Array(buffer));
        });
    }
    static fromB64(b64) {
        const buffer = utils_Utils.fromB64ToArray(b64);
        return new EncArrayBuffer(buffer);
    }
    static validateIvLength(iv) {
        if (iv == null || iv.length !== IV_LENGTH) {
            throw new Error("Invalid IV length");
        }
    }
    static validateMacLength(encType, mac) {
        switch (encType) {
            case EncryptionType.AesCbc256_B64:
                if (mac != null) {
                    throw new Error("mac must not be provided for AesCbc256_B64");
                }
                break;
            case EncryptionType.AesCbc256_HmacSha256_B64:
                if (mac == null || mac.length !== MAC_LENGTH) {
                    throw new Error("Invalid MAC length");
                }
                break;
            default:
                throw new Error("Invalid encryption type and mac combination");
        }
    }
}

;// ./src/models/response/file.response.ts
class FileResponse {
    constructor(data, fileName) {
        this.object = "file";
        this.data = data;
        this.fileName = fileName;
    }
}

;// ./src/commands/download.command.ts
var download_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




/**
 * Used to download and save attachments
 */
class DownloadCommand {
    /**
     * @param encryptService - Needed for decryption of the retrieved attachment
     * @param apiService - Needed to override the existing nativeFetch which is available as of Node 18, to support proxies
     */
    constructor(encryptService, apiService) {
        this.encryptService = encryptService;
        this.apiService = apiService;
    }
    /**
     * Fetches an attachment via the url, decrypts it's content and saves it to a file
     * @param url - url used to retrieve the attachment
     * @param key - SymmetricCryptoKey to decrypt the file contents
     * @param fileName - filename used when written to disk
     * @param output - If output is empty or `--raw` was passed to the initial command the content is output onto stdout
     * @returns Promise<FileResponse>
     */
    saveAttachmentToFile(url, key, fileName, output) {
        return download_command_awaiter(this, void 0, void 0, function* () {
            const response = yield this.apiService.nativeFetch(new Request(url, { headers: { cache: "no-cache" } }));
            if (response.status !== 200) {
                return bw_Response.error("A " + response.status + " error occurred while downloading the attachment.");
            }
            try {
                const encBuf = yield EncArrayBuffer.fromResponse(response);
                const decBuf = yield this.encryptService.decryptToBytes(encBuf, key);
                if (process.env.BW_SERVE === "true") {
                    const res = new FileResponse(Buffer.from(decBuf), fileName);
                    return bw_Response.success(res);
                }
                else {
                    return yield CliUtils.saveResultToFile(Buffer.from(decBuf), output, fileName);
                }
            }
            catch (e) {
                if (typeof e === "string") {
                    return bw_Response.error(e);
                }
                else {
                    return bw_Response.error("An error occurred while saving the attachment.");
                }
            }
        });
    }
}

;// ./src/commands/get.command.ts
var get_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore































class GetCommand extends DownloadCommand {
    constructor(cipherService, folderService, collectionService, totpService, auditService, keyService, encryptService, searchService, apiService, organizationService, eventCollectionService, accountProfileService, accountService) {
        super(encryptService, apiService);
        this.cipherService = cipherService;
        this.folderService = folderService;
        this.collectionService = collectionService;
        this.totpService = totpService;
        this.auditService = auditService;
        this.keyService = keyService;
        this.searchService = searchService;
        this.apiService = apiService;
        this.organizationService = organizationService;
        this.eventCollectionService = eventCollectionService;
        this.accountProfileService = accountProfileService;
        this.accountService = accountService;
    }
    run(object, id, cmdOptions) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            if (id != null) {
                id = id.toLowerCase();
            }
            const normalizedOptions = new get_command_Options(cmdOptions);
            switch (object.toLowerCase()) {
                case "item":
                    return yield this.getCipher(id);
                case "username":
                    return yield this.getUsername(id);
                case "password":
                    return yield this.getPassword(id);
                case "uri":
                    return yield this.getUri(id);
                case "totp":
                    return yield this.getTotp(id);
                case "notes":
                    return yield this.getNotes(id);
                case "exposed":
                    return yield this.getExposed(id);
                case "attachment":
                    return yield this.getAttachment(id, normalizedOptions);
                case "folder":
                    return yield this.getFolder(id);
                case "collection":
                    return yield this.getCollection(id);
                case "org-collection":
                    return yield this.getOrganizationCollection(id, normalizedOptions);
                case "organization":
                    return yield this.getOrganization(id);
                case "template":
                    return yield this.getTemplate(id);
                case "fingerprint":
                    return yield this.getFingerprint(id);
                default:
                    return bw_Response.badRequest("Unknown object.");
            }
        });
    }
    getCipherView(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            let decCipher = null;
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
            if (utils_Utils.isGuid(id)) {
                const cipher = yield this.cipherService.get(id, activeUserId);
                if (cipher != null) {
                    decCipher = yield this.cipherService.decrypt(cipher, activeUserId);
                }
            }
            else if (id.trim() !== "") {
                let ciphers = yield this.cipherService.getAllDecrypted(activeUserId);
                ciphers = this.searchService.searchCiphersBasic(ciphers, id);
                if (ciphers.length > 1) {
                    return ciphers;
                }
                if (ciphers.length > 0) {
                    decCipher = ciphers[0];
                }
            }
            return decCipher;
        });
    }
    getCipher(id, filter) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            let decCipher = yield this.getCipherView(id);
            if (decCipher == null) {
                return bw_Response.notFound();
            }
            if (Array.isArray(decCipher)) {
                if (filter != null) {
                    decCipher = decCipher.filter(filter);
                    if (decCipher.length === 1) {
                        decCipher = decCipher[0];
                    }
                }
                if (Array.isArray(decCipher)) {
                    return bw_Response.multipleResults(decCipher.map((c) => c.id));
                }
            }
            yield this.eventCollectionService.collect(EventType.Cipher_ClientViewed, decCipher.id, true, decCipher.organizationId);
            const res = new CipherResponse(decCipher);
            return bw_Response.success(res);
        });
    }
    getUsername(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            const cipherResponse = yield this.getCipher(id, (c) => c.type === CipherType.Login && !utils_Utils.isNullOrWhitespace(c.login.username));
            if (!cipherResponse.success) {
                return cipherResponse;
            }
            const cipher = cipherResponse.data;
            if (cipher.type !== CipherType.Login) {
                return bw_Response.badRequest("Not a login.");
            }
            if (utils_Utils.isNullOrWhitespace(cipher.login.username)) {
                return bw_Response.error("No username available for this login.");
            }
            const res = new StringResponse(cipher.login.username);
            return bw_Response.success(res);
        });
    }
    getPassword(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            const cipherResponse = yield this.getCipher(id, (c) => c.type === CipherType.Login && !utils_Utils.isNullOrWhitespace(c.login.password));
            if (!cipherResponse.success) {
                return cipherResponse;
            }
            const cipher = cipherResponse.data;
            if (cipher.type !== CipherType.Login) {
                return bw_Response.badRequest("Not a login.");
            }
            if (utils_Utils.isNullOrWhitespace(cipher.login.password)) {
                return bw_Response.error("No password available for this login.");
            }
            const res = new StringResponse(cipher.login.password);
            return bw_Response.success(res);
        });
    }
    getUri(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            const cipherResponse = yield this.getCipher(id, (c) => c.type === CipherType.Login &&
                c.login.uris != null &&
                c.login.uris.length > 0 &&
                c.login.uris[0].uri !== "");
            if (!cipherResponse.success) {
                return cipherResponse;
            }
            const cipher = cipherResponse.data;
            if (cipher.type !== CipherType.Login) {
                return bw_Response.badRequest("Not a login.");
            }
            if (cipher.login.uris == null ||
                cipher.login.uris.length === 0 ||
                cipher.login.uris[0].uri === "") {
                return bw_Response.error("No uri available for this login.");
            }
            const res = new StringResponse(cipher.login.uris[0].uri);
            return bw_Response.success(res);
        });
    }
    getTotp(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            const cipherResponse = yield this.getCipher(id, (c) => c.type === CipherType.Login && !utils_Utils.isNullOrWhitespace(c.login.totp));
            if (!cipherResponse.success) {
                return cipherResponse;
            }
            const cipher = cipherResponse.data;
            if (cipher.type !== CipherType.Login) {
                return bw_Response.badRequest("Not a login.");
            }
            if (utils_Utils.isNullOrWhitespace(cipher.login.totp)) {
                return bw_Response.error("No TOTP available for this login.");
            }
            const totpResponse = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.totpService.getCode$(cipher.login.totp));
            if (!totpResponse.code) {
                return bw_Response.error("Couldn't generate TOTP code.");
            }
            const account = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$);
            const canAccessPremium = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountProfileService.hasPremiumFromAnySource$(account.id));
            if (!canAccessPremium) {
                const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
                const originalCipher = yield this.cipherService.get(cipher.id, activeUserId);
                if (originalCipher == null ||
                    originalCipher.organizationId == null ||
                    !originalCipher.organizationUseTotp) {
                    return bw_Response.error("Premium status is required to use this feature.");
                }
            }
            const res = new StringResponse(totpResponse.code);
            return bw_Response.success(res);
        });
    }
    getNotes(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            const cipherResponse = yield this.getCipher(id, (c) => !utils_Utils.isNullOrWhitespace(c.notes));
            if (!cipherResponse.success) {
                return cipherResponse;
            }
            const cipher = cipherResponse.data;
            if (utils_Utils.isNullOrWhitespace(cipher.notes)) {
                return bw_Response.error("No notes available for this item.");
            }
            const res = new StringResponse(cipher.notes);
            return bw_Response.success(res);
        });
    }
    getExposed(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            const passwordResponse = yield this.getPassword(id);
            if (!passwordResponse.success) {
                return passwordResponse;
            }
            const exposedNumber = yield this.auditService.passwordLeaked(passwordResponse.data.data);
            const res = new StringResponse(exposedNumber.toString());
            return bw_Response.success(res);
        });
    }
    getAttachment(id, options) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            if (options.itemId == null || options.itemId === "") {
                return bw_Response.badRequest("--itemid <itemid> required.");
            }
            const itemId = options.itemId.toLowerCase();
            const cipherResponse = yield this.getCipher(itemId);
            if (!cipherResponse.success) {
                return cipherResponse;
            }
            const cipher = yield this.getCipherView(itemId);
            if (cipher == null ||
                Array.isArray(cipher) ||
                cipher.attachments == null ||
                cipher.attachments.length === 0) {
                return bw_Response.error("No attachments available for this item.");
            }
            let attachments = cipher.attachments.filter((a) => a.id.toLowerCase() === id ||
                (a.fileName != null && a.fileName.toLowerCase().indexOf(id) > -1));
            if (attachments.length === 0) {
                return bw_Response.error("Attachment `" + id + "` was not found.");
            }
            const exactMatches = attachments.filter((a) => a.fileName.toLowerCase() === id);
            if (exactMatches.length === 1) {
                attachments = exactMatches;
            }
            if (attachments.length > 1) {
                return bw_Response.multipleResults(attachments.map((a) => a.id));
            }
            const account = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$);
            const canAccessPremium = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountProfileService.hasPremiumFromAnySource$(account.id));
            if (!canAccessPremium) {
                const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
                const originalCipher = yield this.cipherService.get(cipher.id, activeUserId);
                if (originalCipher == null || originalCipher.organizationId == null) {
                    return bw_Response.error("Premium status is required to use this feature.");
                }
            }
            let url;
            try {
                const attachmentDownloadResponse = yield this.apiService.getAttachmentData(cipher.id, attachments[0].id);
                url = attachmentDownloadResponse.url;
            }
            catch (e) {
                if (e instanceof ErrorResponse && e.statusCode === 404) {
                    url = attachments[0].url;
                }
                else if (e instanceof ErrorResponse) {
                    throw new Error(e.getSingleMessage());
                }
                else {
                    throw e;
                }
            }
            const key = attachments[0].key != null
                ? attachments[0].key
                : yield this.keyService.getOrgKey(cipher.organizationId);
            return yield this.saveAttachmentToFile(url, key, attachments[0].fileName, options.output);
        });
    }
    getFolder(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            let decFolder = null;
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
            if (utils_Utils.isGuid(id)) {
                const folder = yield this.folderService.getFromState(id, activeUserId);
                if (folder != null) {
                    decFolder = yield folder.decrypt();
                }
            }
            else if (id.trim() !== "") {
                let folders = yield this.folderService.getAllDecryptedFromState(activeUserId);
                folders = CliUtils.searchFolders(folders, id);
                if (folders.length > 1) {
                    return bw_Response.multipleResults(folders.map((f) => f.id));
                }
                if (folders.length > 0) {
                    decFolder = folders[0];
                }
            }
            if (decFolder == null) {
                return bw_Response.notFound();
            }
            const res = new FolderResponse(decFolder);
            return bw_Response.success(res);
        });
    }
    getCollection(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            let decCollection = null;
            if (utils_Utils.isGuid(id)) {
                const collection = yield this.collectionService.get(id);
                if (collection != null) {
                    const orgKeys = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.keyService.activeUserOrgKeys$);
                    decCollection = yield collection.decrypt(orgKeys[collection.organizationId]);
                }
            }
            else if (id.trim() !== "") {
                let collections = yield this.collectionService.getAllDecrypted();
                collections = CliUtils.searchCollections(collections, id);
                if (collections.length > 1) {
                    return bw_Response.multipleResults(collections.map((c) => c.id));
                }
                if (collections.length > 0) {
                    decCollection = collections[0];
                }
            }
            if (decCollection == null) {
                return bw_Response.notFound();
            }
            const res = new collection_response_CollectionResponse(decCollection);
            return bw_Response.success(res);
        });
    }
    getOrganizationCollection(id, options) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            if (options.organizationId == null || options.organizationId === "") {
                return bw_Response.badRequest("`organizationid` option is required.");
            }
            if (!utils_Utils.isGuid(id)) {
                return bw_Response.badRequest("`" + id + "` is not a GUID.");
            }
            if (!utils_Utils.isGuid(options.organizationId)) {
                return bw_Response.badRequest("`" + options.organizationId + "` is not a GUID.");
            }
            try {
                const orgKey = yield this.keyService.getOrgKey(options.organizationId);
                if (orgKey == null) {
                    throw new Error("No encryption key for this organization.");
                }
                const response = yield this.apiService.getCollectionAccessDetails(options.organizationId, id);
                const decCollection = new CollectionView(response);
                decCollection.name = yield this.encryptService.decryptToUtf8(new enc_string_EncString(response.name), orgKey, `orgkey-${options.organizationId}`);
                const groups = response.groups == null
                    ? null
                    : response.groups.map((g) => new SelectionReadOnly(g.id, g.readOnly, g.hidePasswords, g.manage));
                const users = response.users == null
                    ? null
                    : response.users.map((g) => new SelectionReadOnly(g.id, g.readOnly, g.hidePasswords, g.manage));
                const res = new OrganizationCollectionResponse(decCollection, groups, users);
                return bw_Response.success(res);
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
    getOrganization(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            let org = null;
            const userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(getUserId(this.accountService.activeAccount$));
            if (!userId) {
                return bw_Response.badRequest("No user found.");
            }
            if (utils_Utils.isGuid(id)) {
                org = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizationService
                    .organizations$(userId)
                    .pipe((0,external_rxjs_namespaceObject.map)((organizations) => organizations.find((o) => o.id === id))));
            }
            else if (id.trim() !== "") {
                let orgs = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizationService.organizations$(userId));
                orgs = CliUtils.searchOrganizations(orgs, id);
                if (orgs.length > 1) {
                    return bw_Response.multipleResults(orgs.map((c) => c.id));
                }
                if (orgs.length > 0) {
                    org = orgs[0];
                }
            }
            if (org == null) {
                return bw_Response.notFound();
            }
            const res = new OrganizationResponse(org);
            return bw_Response.success(res);
        });
    }
    getTemplate(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            let template = null;
            switch (id.toLowerCase()) {
                case "item":
                    template = CipherExport.template();
                    break;
                case "item.field":
                    template = FieldExport.template();
                    break;
                case "item.login":
                    template = LoginExport.template();
                    break;
                case "item.login.uri":
                    template = LoginUriExport.template();
                    break;
                case "item.card":
                    template = CardExport.template();
                    break;
                case "item.identity":
                    template = IdentityExport.template();
                    break;
                case "item.securenote":
                    template = SecureNoteExport.template();
                    break;
                case "folder":
                    template = FolderExport.template();
                    break;
                case "collection":
                    template = CollectionExport.template();
                    break;
                case "item-collections":
                    template = ["collection-id1", "collection-id2"];
                    break;
                case "org-collection":
                    template = OrganizationCollectionRequest.template();
                    break;
                case "send.text":
                    template = SendResponse.template(SendType.Text);
                    break;
                case "send.file":
                    template = SendResponse.template(SendType.File);
                    break;
                default:
                    return bw_Response.badRequest("Unknown template object.");
            }
            const res = new TemplateResponse(template);
            return bw_Response.success(res);
        });
    }
    getFingerprint(id) {
        return get_command_awaiter(this, void 0, void 0, function* () {
            let fingerprint = null;
            if (id === "me") {
                const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
                const publicKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.keyService.userPublicKey$(activeUserId));
                fingerprint = yield this.keyService.getFingerprint(activeUserId, publicKey);
            }
            else if (utils_Utils.isGuid(id)) {
                try {
                    const response = yield this.apiService.getUserPublicKey(id);
                    const pubKey = utils_Utils.fromB64ToArray(response.publicKey);
                    fingerprint = yield this.keyService.getFingerprint(id, pubKey);
                }
                catch (_a) {
                    // empty - handled by the null check below
                }
            }
            if (fingerprint == null) {
                return bw_Response.notFound();
            }
            const res = new StringResponse(fingerprint.join("-"));
            return bw_Response.success(res);
        });
    }
}
class get_command_Options {
    constructor(passedOptions) {
        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);
        this.itemId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemId);
        this.output = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.output;
    }
}

;// ./src/admin-console/models/response/organization-user.response.ts
class organization_user_response_OrganizationUserResponse {
    constructor() {
        this.object = "org-member";
    }
}

;// ./src/models/response/list.response.ts
class list_response_ListResponse {
    constructor(data) {
        this.object = "list";
        this.data = data;
    }
}

;// ./src/commands/list.command.ts
var list_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













class ListCommand {
    constructor(cipherService, folderService, collectionService, organizationService, searchService, organizationUserApiService, apiService, eventCollectionService, accountService) {
        this.cipherService = cipherService;
        this.folderService = folderService;
        this.collectionService = collectionService;
        this.organizationService = organizationService;
        this.searchService = searchService;
        this.organizationUserApiService = organizationUserApiService;
        this.apiService = apiService;
        this.eventCollectionService = eventCollectionService;
        this.accountService = accountService;
    }
    run(object, cmdOptions) {
        return list_command_awaiter(this, void 0, void 0, function* () {
            const normalizedOptions = new list_command_Options(cmdOptions);
            switch (object.toLowerCase()) {
                case "items":
                    return yield this.listCiphers(normalizedOptions);
                case "folders":
                    return yield this.listFolders(normalizedOptions);
                case "collections":
                    return yield this.listCollections(normalizedOptions);
                case "org-collections":
                    return yield this.listOrganizationCollections(normalizedOptions);
                case "org-members":
                    return yield this.listOrganizationMembers(normalizedOptions);
                case "organizations":
                    return yield this.listOrganizations(normalizedOptions);
                default:
                    return bw_Response.badRequest("Unknown object.");
            }
        });
    }
    listCiphers(options) {
        return list_command_awaiter(this, void 0, void 0, function* () {
            let ciphers;
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
            options.trash = options.trash || false;
            if (options.url != null && options.url.trim() !== "") {
                ciphers = yield this.cipherService.getAllDecryptedForUrl(options.url, activeUserId);
            }
            else {
                ciphers = yield this.cipherService.getAllDecrypted(activeUserId);
            }
            if (options.folderId != null ||
                options.collectionId != null ||
                options.organizationId != null) {
                ciphers = ciphers.filter((c) => {
                    if (options.trash !== c.isDeleted) {
                        return false;
                    }
                    if (options.folderId != null) {
                        if (options.folderId === "notnull" && c.folderId != null) {
                            return true;
                        }
                        const folderId = options.folderId === "null" ? null : options.folderId;
                        if (folderId === c.folderId) {
                            return true;
                        }
                    }
                    if (options.organizationId != null) {
                        if (options.organizationId === "notnull" && c.organizationId != null) {
                            return true;
                        }
                        const organizationId = options.organizationId === "null" ? null : options.organizationId;
                        if (organizationId === c.organizationId) {
                            return true;
                        }
                    }
                    if (options.collectionId != null) {
                        if (options.collectionId === "notnull" &&
                            c.collectionIds != null &&
                            c.collectionIds.length > 0) {
                            return true;
                        }
                        const collectionId = options.collectionId === "null" ? null : options.collectionId;
                        if (collectionId == null && (c.collectionIds == null || c.collectionIds.length === 0)) {
                            return true;
                        }
                        if (collectionId != null &&
                            c.collectionIds != null &&
                            c.collectionIds.indexOf(collectionId) > -1) {
                            return true;
                        }
                    }
                    return false;
                });
            }
            else if (options.search == null || options.search.trim() === "") {
                ciphers = ciphers.filter((c) => options.trash === c.isDeleted);
            }
            if (options.search != null && options.search.trim() !== "") {
                ciphers = this.searchService.searchCiphersBasic(ciphers, options.search, options.trash);
            }
            yield this.eventCollectionService.collectMany(EventType.Cipher_ClientViewed, ciphers, true);
            const res = new list_response_ListResponse(ciphers.map((o) => new CipherResponse(o)));
            return bw_Response.success(res);
        });
    }
    listFolders(options) {
        return list_command_awaiter(this, void 0, void 0, function* () {
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
            let folders = yield this.folderService.getAllDecryptedFromState(activeUserId);
            if (options.search != null && options.search.trim() !== "") {
                folders = CliUtils.searchFolders(folders, options.search);
            }
            const res = new list_response_ListResponse(folders.map((o) => new FolderResponse(o)));
            return bw_Response.success(res);
        });
    }
    listCollections(options) {
        return list_command_awaiter(this, void 0, void 0, function* () {
            let collections = yield this.collectionService.getAllDecrypted();
            if (options.organizationId != null) {
                collections = collections.filter((c) => {
                    if (options.organizationId === c.organizationId) {
                        return true;
                    }
                    return false;
                });
            }
            if (options.search != null && options.search.trim() !== "") {
                collections = CliUtils.searchCollections(collections, options.search);
            }
            const res = new list_response_ListResponse(collections.map((o) => new collection_response_CollectionResponse(o)));
            return bw_Response.success(res);
        });
    }
    listOrganizationCollections(options) {
        return list_command_awaiter(this, void 0, void 0, function* () {
            if (options.organizationId == null || options.organizationId === "") {
                return bw_Response.badRequest("`organizationid` option is required.");
            }
            if (!utils_Utils.isGuid(options.organizationId)) {
                return bw_Response.badRequest("`" + options.organizationId + "` is not a GUID.");
            }
            const userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(getUserId(this.accountService.activeAccount$));
            if (!userId) {
                return bw_Response.badRequest("No user found.");
            }
            const organization = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizationService
                .organizations$(userId)
                .pipe((0,external_rxjs_namespaceObject.map)((organizatons) => organizatons.find((o) => o.id == options.organizationId))));
            if (organization == null) {
                return bw_Response.error("Organization not found.");
            }
            try {
                let response;
                if (organization.canViewAllCollections) {
                    response = yield this.apiService.getCollections(options.organizationId);
                }
                else {
                    response = yield this.apiService.getUserCollections();
                }
                const collections = response.data
                    .filter((c) => c.organizationId === options.organizationId)
                    .map((r) => new Collection(new collection_data_CollectionData(r)));
                let decCollections = yield this.collectionService.decryptMany(collections);
                if (options.search != null && options.search.trim() !== "") {
                    decCollections = CliUtils.searchCollections(decCollections, options.search);
                }
                const res = new list_response_ListResponse(decCollections.map((o) => new collection_response_CollectionResponse(o)));
                return bw_Response.success(res);
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
    listOrganizationMembers(options) {
        return list_command_awaiter(this, void 0, void 0, function* () {
            if (options.organizationId == null || options.organizationId === "") {
                return bw_Response.badRequest("`organizationid` option is required.");
            }
            if (!utils_Utils.isGuid(options.organizationId)) {
                return bw_Response.badRequest("`" + options.organizationId + "` is not a GUID.");
            }
            const userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(getUserId(this.accountService.activeAccount$));
            if (!userId) {
                return bw_Response.badRequest("No user found.");
            }
            const organization = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizationService
                .organizations$(userId)
                .pipe((0,external_rxjs_namespaceObject.map)((organizatons) => organizatons.find((o) => o.id == options.organizationId))));
            if (organization == null) {
                return bw_Response.error("Organization not found.");
            }
            try {
                const response = yield this.organizationUserApiService.getAllUsers(options.organizationId);
                const res = new list_response_ListResponse(response.data.map((r) => {
                    const u = new organization_user_response_OrganizationUserResponse();
                    u.email = r.email;
                    u.name = r.name;
                    u.id = r.id;
                    u.status = r.status;
                    u.type = r.type;
                    u.twoFactorEnabled = r.twoFactorEnabled;
                    return u;
                }));
                return bw_Response.success(res);
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
    listOrganizations(options) {
        return list_command_awaiter(this, void 0, void 0, function* () {
            const userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(getUserId(this.accountService.activeAccount$));
            if (!userId) {
                return bw_Response.badRequest("No user found.");
            }
            let organizations = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizationService.memberOrganizations$(userId));
            if (options.search != null && options.search.trim() !== "") {
                organizations = CliUtils.searchOrganizations(organizations, options.search);
            }
            const res = new list_response_ListResponse(organizations.map((o) => new OrganizationResponse(o)));
            return bw_Response.success(res);
        });
    }
}
class list_command_Options {
    constructor(passedOptions) {
        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);
        this.collectionId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.collectionid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.collectionId);
        this.folderId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.folderid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.folderId);
        this.search = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.search;
        this.url = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.url;
        this.trash = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.trash);
    }
}

;// ../../libs/common/src/enums/feature-flag.enum.ts
/**
 * Feature flags.
 *
 * Flags MUST be short lived and SHALL be removed once enabled.
 *
 * Flags should be grouped by team to have visibility of ownership and cleanup.
 */
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var feature_flag_enum_FeatureFlag;
(function (FeatureFlag) {
    /* Admin Console Team */
    FeatureFlag["VerifiedSsoDomainEndpoint"] = "pm-12337-refactor-sso-details-endpoint";
    FeatureFlag["LimitItemDeletion"] = "pm-15493-restrict-item-deletion-to-can-manage-permission";
    FeatureFlag["SsoExternalIdVisibility"] = "pm-18630-sso-external-id-visibility";
    FeatureFlag["AccountDeprovisioningBanner"] = "pm-17120-account-deprovisioning-admin-console-banner";
    FeatureFlag["SeparateCustomRolePermissions"] = "pm-19917-separate-custom-role-permissions";
    /* Auth */
    FeatureFlag["PM16117_ChangeExistingPasswordRefactor"] = "pm-16117-change-existing-password-refactor";
    FeatureFlag["PM9115_TwoFactorExtensionDataPersistence"] = "pm-9115-two-factor-extension-data-persistence";
    /* Autofill */
    FeatureFlag["BlockBrowserInjectionsByDomain"] = "block-browser-injections-by-domain";
    FeatureFlag["DelayFido2PageScriptInitWithinMv2"] = "delay-fido2-page-script-init-within-mv2";
    FeatureFlag["EnableNewCardCombinedExpiryAutofill"] = "enable-new-card-combined-expiry-autofill";
    FeatureFlag["GenerateIdentityFillScriptRefactor"] = "generate-identity-fill-script-refactor";
    FeatureFlag["IdpAutoSubmitLogin"] = "idp-auto-submit-login";
    FeatureFlag["NotificationRefresh"] = "notification-refresh";
    FeatureFlag["UseTreeWalkerApiForPageDetailsCollection"] = "use-tree-walker-api-for-page-details-collection";
    FeatureFlag["MacOsNativeCredentialSync"] = "macos-native-credential-sync";
    /* Billing */
    FeatureFlag["TrialPaymentOptional"] = "PM-8163-trial-payment";
    FeatureFlag["PM12276_BreadcrumbEventLogs"] = "pm-12276-breadcrumbing-for-business-features";
    FeatureFlag["PM18794_ProviderPaymentMethod"] = "pm-18794-provider-payment-method";
    FeatureFlag["PM17772_AdminInitiatedSponsorships"] = "pm-17772-admin-initiated-sponsorships";
    FeatureFlag["PM19956_RequireProviderPaymentMethodDuringSetup"] = "pm-19956-require-provider-payment-method-during-setup";
    FeatureFlag["UseOrganizationWarningsService"] = "use-organization-warnings-service";
    /* Data Insights and Reporting */
    FeatureFlag["CriticalApps"] = "pm-14466-risk-insights-critical-application";
    FeatureFlag["EnableRiskInsightsNotifications"] = "enable-risk-insights-notifications";
    /* Key Management */
    FeatureFlag["PrivateKeyRegeneration"] = "pm-12241-private-key-regeneration";
    FeatureFlag["UserKeyRotationV2"] = "userkey-rotation-v2";
    FeatureFlag["PM4154_BulkEncryptionService"] = "PM-4154-bulk-encryption-service";
    FeatureFlag["UseSDKForDecryption"] = "use-sdk-for-decryption";
    FeatureFlag["PM17987_BlockType0"] = "pm-17987-block-type-0";
    /* Tools */
    FeatureFlag["ItemShare"] = "item-share";
    FeatureFlag["DesktopSendUIRefresh"] = "desktop-send-ui-refresh";
    /* Vault */
    FeatureFlag["PM8851_BrowserOnboardingNudge"] = "pm-8851-browser-onboarding-nudge";
    FeatureFlag["PM9111ExtensionPersistAddEditForm"] = "pm-9111-extension-persist-add-edit-form";
    FeatureFlag["SecurityTasks"] = "security-tasks";
    FeatureFlag["PM19941MigrateCipherDomainToSdk"] = "pm-19941-migrate-cipher-domain-to-sdk";
    FeatureFlag["CipherKeyEncryption"] = "cipher-key-encryption";
    FeatureFlag["PM18520_UpdateDesktopCipherForm"] = "pm-18520-desktop-cipher-forms";
    FeatureFlag["EndUserNotifications"] = "pm-10609-end-user-notifications";
    /* Platform */
    FeatureFlag["IpcChannelFramework"] = "ipc-channel-framework";
})(feature_flag_enum_FeatureFlag || (feature_flag_enum_FeatureFlag = {}));
// Helper to ensure the value is treated as a boolean.
const FALSE = false;
/**
 * Default value for feature flags.
 *
 * DO NOT enable previously disabled flags, REMOVE them instead.
 * We support true as a value as we prefer flags to "enable" not "disable".
 *
 * Flags should be grouped by team to have visibility of ownership and cleanup.
 */
const DefaultFeatureFlagValue = {
    /* Admin Console Team */
    [feature_flag_enum_FeatureFlag.VerifiedSsoDomainEndpoint]: FALSE,
    [feature_flag_enum_FeatureFlag.LimitItemDeletion]: FALSE,
    [feature_flag_enum_FeatureFlag.SsoExternalIdVisibility]: FALSE,
    [feature_flag_enum_FeatureFlag.AccountDeprovisioningBanner]: FALSE,
    [feature_flag_enum_FeatureFlag.SeparateCustomRolePermissions]: FALSE,
    /* Autofill */
    [feature_flag_enum_FeatureFlag.BlockBrowserInjectionsByDomain]: FALSE,
    [feature_flag_enum_FeatureFlag.DelayFido2PageScriptInitWithinMv2]: FALSE,
    [feature_flag_enum_FeatureFlag.EnableNewCardCombinedExpiryAutofill]: FALSE,
    [feature_flag_enum_FeatureFlag.GenerateIdentityFillScriptRefactor]: FALSE,
    [feature_flag_enum_FeatureFlag.IdpAutoSubmitLogin]: FALSE,
    [feature_flag_enum_FeatureFlag.NotificationRefresh]: FALSE,
    [feature_flag_enum_FeatureFlag.UseTreeWalkerApiForPageDetailsCollection]: FALSE,
    [feature_flag_enum_FeatureFlag.MacOsNativeCredentialSync]: FALSE,
    /* Data Insights and Reporting */
    [feature_flag_enum_FeatureFlag.CriticalApps]: FALSE,
    [feature_flag_enum_FeatureFlag.EnableRiskInsightsNotifications]: FALSE,
    /* Tools */
    [feature_flag_enum_FeatureFlag.ItemShare]: FALSE,
    [feature_flag_enum_FeatureFlag.DesktopSendUIRefresh]: FALSE,
    /* Vault */
    [feature_flag_enum_FeatureFlag.PM8851_BrowserOnboardingNudge]: FALSE,
    [feature_flag_enum_FeatureFlag.PM9111ExtensionPersistAddEditForm]: FALSE,
    [feature_flag_enum_FeatureFlag.SecurityTasks]: FALSE,
    [feature_flag_enum_FeatureFlag.CipherKeyEncryption]: FALSE,
    [feature_flag_enum_FeatureFlag.PM18520_UpdateDesktopCipherForm]: FALSE,
    [feature_flag_enum_FeatureFlag.EndUserNotifications]: FALSE,
    [feature_flag_enum_FeatureFlag.PM19941MigrateCipherDomainToSdk]: FALSE,
    /* Auth */
    [feature_flag_enum_FeatureFlag.PM16117_ChangeExistingPasswordRefactor]: FALSE,
    [feature_flag_enum_FeatureFlag.PM9115_TwoFactorExtensionDataPersistence]: FALSE,
    /* Billing */
    [feature_flag_enum_FeatureFlag.TrialPaymentOptional]: FALSE,
    [feature_flag_enum_FeatureFlag.PM12276_BreadcrumbEventLogs]: FALSE,
    [feature_flag_enum_FeatureFlag.PM18794_ProviderPaymentMethod]: FALSE,
    [feature_flag_enum_FeatureFlag.PM17772_AdminInitiatedSponsorships]: FALSE,
    [feature_flag_enum_FeatureFlag.PM19956_RequireProviderPaymentMethodDuringSetup]: FALSE,
    [feature_flag_enum_FeatureFlag.UseOrganizationWarningsService]: FALSE,
    /* Key Management */
    [feature_flag_enum_FeatureFlag.PrivateKeyRegeneration]: FALSE,
    [feature_flag_enum_FeatureFlag.UserKeyRotationV2]: FALSE,
    [feature_flag_enum_FeatureFlag.PM4154_BulkEncryptionService]: FALSE,
    [feature_flag_enum_FeatureFlag.UseSDKForDecryption]: FALSE,
    [feature_flag_enum_FeatureFlag.PM17987_BlockType0]: FALSE,
    /* Platform */
    [feature_flag_enum_FeatureFlag.IpcChannelFramework]: FALSE,
};
function getFeatureFlagValue(serverConfig, flag) {
    if ((serverConfig === null || serverConfig === void 0 ? void 0 : serverConfig.featureStates) == null || serverConfig.featureStates[flag] == null) {
        return DefaultFeatureFlagValue[flag];
    }
    return serverConfig.featureStates[flag];
}

;// ./src/commands/restore.command.ts
var restore_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class RestoreCommand {
    constructor(cipherService, accountService, configService, cipherAuthorizationService) {
        this.cipherService = cipherService;
        this.accountService = accountService;
        this.configService = configService;
        this.cipherAuthorizationService = cipherAuthorizationService;
    }
    run(object, id) {
        return restore_command_awaiter(this, void 0, void 0, function* () {
            if (id != null) {
                id = id.toLowerCase();
            }
            switch (object.toLowerCase()) {
                case "item":
                    return yield this.restoreCipher(id);
                default:
                    return bw_Response.badRequest("Unknown object.");
            }
        });
    }
    restoreCipher(id) {
        return restore_command_awaiter(this, void 0, void 0, function* () {
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
            const cipher = yield this.cipherService.get(id, activeUserId);
            if (cipher == null) {
                return bw_Response.notFound();
            }
            if (cipher.deletedDate == null) {
                return bw_Response.badRequest("Cipher is not in trash.");
            }
            const canRestore = yield (0,external_rxjs_namespaceObject.firstValueFrom)((0,external_rxjs_namespaceObject.combineLatest)([
                this.configService.getFeatureFlag$(feature_flag_enum_FeatureFlag.LimitItemDeletion),
                this.cipherAuthorizationService.canRestoreCipher$(cipher),
            ]).pipe((0,external_rxjs_namespaceObject.map)(([enabled, canRestore]) => {
                if (enabled && !canRestore) {
                    return false;
                }
                return true;
            })));
            if (!canRestore) {
                return bw_Response.error("You do not have permission to restore this item");
            }
            try {
                yield this.cipherService.restoreWithServer(id, activeUserId);
                return bw_Response.success();
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
}

;// ../../libs/common/src/auth/enums/authentication-status.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var authentication_status_AuthenticationStatus;
(function (AuthenticationStatus) {
    AuthenticationStatus[AuthenticationStatus["LoggedOut"] = 0] = "LoggedOut";
    AuthenticationStatus[AuthenticationStatus["Locked"] = 1] = "Locked";
    AuthenticationStatus[AuthenticationStatus["Unlocked"] = 2] = "Unlocked";
})(authentication_status_AuthenticationStatus || (authentication_status_AuthenticationStatus = {}));

;// ./src/commands/status.command.ts
var status_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore




class StatusCommand {
    constructor(envService, syncService, accountService, authService) {
        this.envService = envService;
        this.syncService = syncService;
        this.accountService = accountService;
        this.authService = authService;
    }
    run() {
        return status_command_awaiter(this, void 0, void 0, function* () {
            try {
                const baseUrl = yield this.baseUrl();
                const status = yield this.status();
                const lastSync = yield this.syncService.getLastSync();
                const [userId, email] = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe((0,external_rxjs_namespaceObject.map)((a) => [a === null || a === void 0 ? void 0 : a.id, a === null || a === void 0 ? void 0 : a.email])));
                return bw_Response.success(new TemplateResponse({
                    serverUrl: baseUrl,
                    lastSync: lastSync,
                    userEmail: email,
                    userId: userId,
                    status: status,
                }));
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
    baseUrl() {
        return status_command_awaiter(this, void 0, void 0, function* () {
            const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.envService.environment$);
            return env.getUrls().base;
        });
    }
    status() {
        return status_command_awaiter(this, void 0, void 0, function* () {
            const authStatus = yield this.authService.getAuthStatus();
            if (authStatus === authentication_status_AuthenticationStatus.Unlocked) {
                return "unlocked";
            }
            else if (authStatus === authentication_status_AuthenticationStatus.Locked) {
                return "locked";
            }
            else {
                return "unauthenticated";
            }
        });
    }
}

;// ../../libs/common/src/admin-console/enums/organization-api-key-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var OrganizationApiKeyType;
(function (OrganizationApiKeyType) {
    OrganizationApiKeyType[OrganizationApiKeyType["Default"] = 0] = "Default";
    OrganizationApiKeyType[OrganizationApiKeyType["BillingSync"] = 1] = "BillingSync";
    OrganizationApiKeyType[OrganizationApiKeyType["Scim"] = 2] = "Scim";
})(OrganizationApiKeyType || (OrganizationApiKeyType = {}));

;// ../../libs/common/src/admin-console/enums/organization-connection-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var OrganizationConnectionType;
(function (OrganizationConnectionType) {
    OrganizationConnectionType[OrganizationConnectionType["CloudBillingSync"] = 1] = "CloudBillingSync";
    OrganizationConnectionType[OrganizationConnectionType["Scim"] = 2] = "Scim";
})(OrganizationConnectionType || (OrganizationConnectionType = {}));

;// ../../libs/common/src/admin-console/enums/organization-user-status-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var OrganizationUserStatusType;
(function (OrganizationUserStatusType) {
    OrganizationUserStatusType[OrganizationUserStatusType["Invited"] = 0] = "Invited";
    OrganizationUserStatusType[OrganizationUserStatusType["Accepted"] = 1] = "Accepted";
    OrganizationUserStatusType[OrganizationUserStatusType["Confirmed"] = 2] = "Confirmed";
    OrganizationUserStatusType[OrganizationUserStatusType["Revoked"] = -1] = "Revoked";
})(OrganizationUserStatusType || (OrganizationUserStatusType = {}));

;// ../../libs/common/src/admin-console/enums/organization-user-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var OrganizationUserType;
(function (OrganizationUserType) {
    OrganizationUserType[OrganizationUserType["Owner"] = 0] = "Owner";
    OrganizationUserType[OrganizationUserType["Admin"] = 1] = "Admin";
    OrganizationUserType[OrganizationUserType["User"] = 2] = "User";
    // Manager = 3 has been intentionally permanently deleted
    OrganizationUserType[OrganizationUserType["Custom"] = 4] = "Custom";
})(OrganizationUserType || (OrganizationUserType = {}));

;// ../../libs/common/src/admin-console/enums/policy-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var policy_type_enum_PolicyType;
(function (PolicyType) {
    PolicyType[PolicyType["TwoFactorAuthentication"] = 0] = "TwoFactorAuthentication";
    PolicyType[PolicyType["MasterPassword"] = 1] = "MasterPassword";
    PolicyType[PolicyType["PasswordGenerator"] = 2] = "PasswordGenerator";
    PolicyType[PolicyType["SingleOrg"] = 3] = "SingleOrg";
    PolicyType[PolicyType["RequireSso"] = 4] = "RequireSso";
    PolicyType[PolicyType["PersonalOwnership"] = 5] = "PersonalOwnership";
    PolicyType[PolicyType["DisableSend"] = 6] = "DisableSend";
    PolicyType[PolicyType["SendOptions"] = 7] = "SendOptions";
    PolicyType[PolicyType["ResetPassword"] = 8] = "ResetPassword";
    PolicyType[PolicyType["MaximumVaultTimeout"] = 9] = "MaximumVaultTimeout";
    PolicyType[PolicyType["DisablePersonalVaultExport"] = 10] = "DisablePersonalVaultExport";
    PolicyType[PolicyType["ActivateAutofill"] = 11] = "ActivateAutofill";
    PolicyType[PolicyType["AutomaticAppLogIn"] = 12] = "AutomaticAppLogIn";
    PolicyType[PolicyType["FreeFamiliesSponsorshipPolicy"] = 13] = "FreeFamiliesSponsorshipPolicy";
    PolicyType[PolicyType["RemoveUnlockWithPin"] = 14] = "RemoveUnlockWithPin";
})(policy_type_enum_PolicyType || (policy_type_enum_PolicyType = {}));

;// ../../libs/common/src/admin-console/enums/provider-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ProviderType;
(function (ProviderType) {
    ProviderType[ProviderType["Msp"] = 0] = "Msp";
    ProviderType[ProviderType["Reseller"] = 1] = "Reseller";
    ProviderType[ProviderType["BusinessUnit"] = 2] = "BusinessUnit";
})(ProviderType || (ProviderType = {}));

;// ../../libs/common/src/admin-console/enums/provider-user-status-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ProviderUserStatusType;
(function (ProviderUserStatusType) {
    ProviderUserStatusType[ProviderUserStatusType["Invited"] = 0] = "Invited";
    ProviderUserStatusType[ProviderUserStatusType["Accepted"] = 1] = "Accepted";
    ProviderUserStatusType[ProviderUserStatusType["Confirmed"] = 2] = "Confirmed";
    ProviderUserStatusType[ProviderUserStatusType["Revoked"] = -1] = "Revoked";
})(ProviderUserStatusType || (ProviderUserStatusType = {}));

;// ../../libs/common/src/admin-console/enums/provider-user-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ProviderUserType;
(function (ProviderUserType) {
    ProviderUserType[ProviderUserType["ProviderAdmin"] = 0] = "ProviderAdmin";
    ProviderUserType[ProviderUserType["ServiceUser"] = 1] = "ServiceUser";
})(ProviderUserType || (ProviderUserType = {}));

;// ../../libs/common/src/admin-console/enums/scim-provider-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ScimProviderType;
(function (ScimProviderType) {
    ScimProviderType[ScimProviderType["Default"] = 0] = "Default";
    ScimProviderType[ScimProviderType["AzureAd"] = 1] = "AzureAd";
    ScimProviderType[ScimProviderType["Okta"] = 2] = "Okta";
    ScimProviderType[ScimProviderType["OneLogin"] = 3] = "OneLogin";
    ScimProviderType[ScimProviderType["JumpCloud"] = 4] = "JumpCloud";
    ScimProviderType[ScimProviderType["GoogleWorkspace"] = 5] = "GoogleWorkspace";
    ScimProviderType[ScimProviderType["Rippling"] = 6] = "Rippling";
})(ScimProviderType || (ScimProviderType = {}));

;// ../../libs/common/src/admin-console/enums/provider-status-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ProviderStatusType;
(function (ProviderStatusType) {
    ProviderStatusType[ProviderStatusType["Pending"] = 0] = "Pending";
    ProviderStatusType[ProviderStatusType["Created"] = 1] = "Created";
    ProviderStatusType[ProviderStatusType["Billable"] = 2] = "Billable";
})(ProviderStatusType || (ProviderStatusType = {}));

;// ../../libs/common/src/admin-console/enums/index.ts











;// ../../libs/common/src/tools/public-classifier.ts
class PublicClassifier {
    constructor(keys) {
        this.keys = keys;
    }
    classify(value) {
        const pickMe = JSON.parse(JSON.stringify(value));
        const picked = {};
        for (const key of this.keys) {
            picked[key] = pickMe[key];
        }
        const disclosed = picked;
        return { disclosed, secret: "" };
    }
    declassify(disclosed, _secret) {
        const result = {};
        for (const key of this.keys) {
            result[key] = disclosed[key];
        }
        return result;
    }
}

;// ../../libs/common/src/tools/state/identity-state-constraint.ts

// The constraints type shares the properties of the state,
// but never has any members
const EMPTY_CONSTRAINTS = new Proxy(Object.freeze({}), {
    get() {
        return {};
    },
});
/** A constraint that does nothing. */
class identity_state_constraint_IdentityConstraint {
    /** Instantiate the identity constraint */
    constructor() {
        this.constraints = EMPTY_CONSTRAINTS;
    }
    calibrate() {
        return this;
    }
    adjust(state) {
        return state;
    }
    fix(state) {
        return state;
    }
}
/** Emits a constraint that does not alter the input state. */
function unconstrained$() {
    const identity = new identity_state_constraint_IdentityConstraint();
    const constraints$ = new external_rxjs_namespaceObject.BehaviorSubject(identity);
    return constraints$;
}

;// ../../libs/tools/generator/core/src/engine/key-service-randomizer.ts
var key_service_randomizer_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
/** A randomizer backed by a KeyService. */
class key_service_randomizer_KeyServiceRandomizer {
    /** instantiates the type.
     * @param keyService generates random numbers
     */
    constructor(keyService) {
        this.keyService = keyService;
    }
    pick(list) {
        return key_service_randomizer_awaiter(this, void 0, void 0, function* () {
            var _a;
            const length = (_a = list === null || list === void 0 ? void 0 : list.length) !== null && _a !== void 0 ? _a : 0;
            if (length <= 0) {
                throw new Error("list must have at least one entry.");
            }
            const index = yield this.uniform(0, list.length - 1);
            return list[index];
        });
    }
    pickWord(list, options) {
        return key_service_randomizer_awaiter(this, void 0, void 0, function* () {
            var _a, _b;
            let word = yield this.pick(list);
            if ((_a = options === null || options === void 0 ? void 0 : options.titleCase) !== null && _a !== void 0 ? _a : false) {
                word = word.charAt(0).toUpperCase() + word.slice(1);
            }
            if ((_b = options === null || options === void 0 ? void 0 : options.number) !== null && _b !== void 0 ? _b : false) {
                const num = yield this.keyService.randomNumber(1, 9);
                word = word + num.toString();
            }
            return word;
        });
    }
    // ref: https://stackoverflow.com/a/12646864/1090359
    shuffle(items, options) {
        return key_service_randomizer_awaiter(this, void 0, void 0, function* () {
            var _a, _b;
            const length = (_a = items === null || items === void 0 ? void 0 : items.length) !== null && _a !== void 0 ? _a : 0;
            if (length <= 0) {
                throw new Error("items must have at least one entry.");
            }
            const shuffled = ((_b = options === null || options === void 0 ? void 0 : options.copy) !== null && _b !== void 0 ? _b : true) ? [...items] : items;
            for (let i = shuffled.length - 1; i > 0; i--) {
                const j = yield this.uniform(0, i);
                [shuffled[i], shuffled[j]] = [shuffled[j], shuffled[i]];
            }
            return shuffled;
        });
    }
    chars(length) {
        return key_service_randomizer_awaiter(this, void 0, void 0, function* () {
            let str = "";
            const charSet = "abcdefghijklmnopqrstuvwxyz1234567890";
            for (let i = 0; i < length; i++) {
                const randomCharIndex = yield this.uniform(0, charSet.length - 1);
                str += charSet.charAt(randomCharIndex);
            }
            return str;
        });
    }
    uniform(min, max) {
        return key_service_randomizer_awaiter(this, void 0, void 0, function* () {
            return this.keyService.randomNumber(min, max);
        });
    }
}

;// ../../libs/common/src/tools/integration/integration-context.ts

/** Utilities for processing integration settings */
class IntegrationContext {
    /** Instantiates an integration context
     *  @param metadata - defines integration capabilities
     *  @param i18n - localizes error messages
     */
    constructor(metadata, settings, i18n) {
        this.metadata = metadata;
        this.settings = settings;
        this.i18n = i18n;
    }
    /** Lookup the integration's baseUrl
     *  @returns the baseUrl for the API's integration point.
     *   - By default this is defined by the metadata
     *   - When a service allows self-hosting, this can be supplied by `settings`.
     *  @throws a localized error message when a base URL is neither defined by the metadata or
     *   supplied by an argument.
     */
    baseUrl() {
        var _a, _b;
        // normalize baseUrl
        const setting = (_a = (this.settings && "baseUrl" in this.settings
            ? this.settings.baseUrl
            : undefined)) !== null && _a !== void 0 ? _a : "";
        let result = "";
        // look up definition
        if (this.metadata.selfHost === "always") {
            result = setting;
        }
        else if (this.metadata.selfHost === "never" || setting.length <= 0) {
            result = (_b = this.metadata.baseUrl) !== null && _b !== void 0 ? _b : "";
        }
        else {
            result = setting;
        }
        // postconditions
        if (result === "") {
            const error = this.i18n.t("forwarderNoUrl", this.metadata.name);
            throw error;
        }
        return result;
    }
    /** look up a service API's authentication token
     *  @param options.base64 when `true`, base64 encodes the result. Defaults to `false`.
     *  @param options.suffix a string to append to the token. Defaults to empty.
     *  @returns the user's authentication token
     *  @throws a localized error message when the token is invalid.
     *  @remarks the string is thrown for backwards compatibility
     */
    authenticationToken(options = null) {
        var _a, _b;
        // normalize `token` then assert it has a value
        let token = "token" in this.settings ? ((_a = this.settings.token) !== null && _a !== void 0 ? _a : "") : "";
        if (token === "") {
            const error = this.i18n.t("forwaderInvalidToken", this.metadata.name);
            throw error;
        }
        // if a suffix exists, it needs to be included before encoding
        token += (_b = options === null || options === void 0 ? void 0 : options.suffix) !== null && _b !== void 0 ? _b : "";
        if (options === null || options === void 0 ? void 0 : options.base64) {
            token = utils_Utils.fromUtf8ToB64(token);
        }
        return token;
    }
    /** look up the website the integration is working with.
     *  @param request supplies information about the state of the extension site
     *  @param options optional parameters
     *  @param options.extractHostname when `true`, tries to extract the hostname from the website URL, returns full URL otherwise
     *  @param options.maxLength limits the length of the return value
     *  @returns The website or an empty string if a website isn't available
     *  @remarks `website` is usually supplied when generating a credential from the vault
     */
    website(request, options) {
        var _a, _b;
        let url = (_a = request.website) !== null && _a !== void 0 ? _a : "";
        if (options === null || options === void 0 ? void 0 : options.extractHostname) {
            url = (_b = utils_Utils.getHost(url)) !== null && _b !== void 0 ? _b : url;
        }
        return url.slice(0, options === null || options === void 0 ? void 0 : options.maxLength);
    }
    /** look up localized text indicating Bitwarden requested the forwarding address.
     *  @param request supplies information about the state of the extension site
     *  @param options optional parameters
     *  @param options.extractHostname when `true`, extracts the hostname from the website URL
     *  @param options.maxLength limits the length of the return value
     *  @returns localized text describing a generated forwarding address
     */
    generatedBy(request, options) {
        var _a;
        const website = this.website(request, { extractHostname: (_a = options === null || options === void 0 ? void 0 : options.extractHostname) !== null && _a !== void 0 ? _a : false });
        const descriptionId = website === "" ? "forwarderGeneratedBy" : "forwarderGeneratedByWithWebsite";
        const description = this.i18n.t(descriptionId, website);
        return description.slice(0, options === null || options === void 0 ? void 0 : options.maxLength);
    }
}

;// ../../libs/tools/generator/core/src/engine/forwarder-context.ts

/**
 * Surfaces contextual information to forwarder integrations.
 */
class forwarder_context_ForwarderContext extends IntegrationContext {
    /** Instantiates the context.
     * @param configuration of the forwarder this context assists
     * @param settings loaded from the forwarder's state
     * @param i18n localizes error handling
     */
    constructor(configuration, settings, i18n) {
        super(configuration, settings, i18n);
        this.configuration = configuration;
    }
    /** look up the domain part of an email address from the forwarder's settings.
     *  @returns a domain part of an email address
     *  @throws a localized error message when the domain isn't found.
     *  @remarks the string is thrown for backwards compatibility
     */
    emailDomain() {
        var _a;
        const domain = "domain" in this.settings ? ((_a = this.settings.domain) !== null && _a !== void 0 ? _a : "") : "";
        if (domain === "") {
            const error = this.i18n.t("forwarderNoDomain", this.configuration.name);
            throw error;
        }
        return domain;
    }
    /** look up a prefix applied to the email address from the forwarder's settings.
     *  @returns the prefix
     *  @throws a localized error message when the prefix isn't found.
     *  @remarks the string is thrown for backwards compatibility
     */
    emailPrefix() {
        var _a;
        const prefix = "prefix" in this.settings ? ((_a = this.settings.prefix) !== null && _a !== void 0 ? _a : "") : "";
        if (prefix === "") {
            const error = this.i18n.t("forwarderNoPrefix", this.configuration.name);
            throw error;
        }
        return prefix;
    }
    /** look up a localized error message indicating an account id is required
     *  but wasn't found.
     *  @remarks this returns a string instead of throwing it so that the
     *    user can decide upon control flow.
     */
    missingAccountIdCause() {
        return this.i18n.t("forwarderNoAccountId", this.configuration.name);
    }
}

;// ../../libs/common/src/platform/misc/wordlist.ts
// EFF's Long Wordlist from https://www.eff.org/dice
const EFFLongWordList = [
    "abacus",
    "abdomen",
    "abdominal",
    "abide",
    "abiding",
    "ability",
    "ablaze",
    "able",
    "abnormal",
    "abrasion",
    "abrasive",
    "abreast",
    "abridge",
    "abroad",
    "abruptly",
    "absence",
    "absentee",
    "absently",
    "absinthe",
    "absolute",
    "absolve",
    "abstain",
    "abstract",
    "absurd",
    "accent",
    "acclaim",
    "acclimate",
    "accompany",
    "account",
    "accuracy",
    "accurate",
    "accustom",
    "acetone",
    "achiness",
    "aching",
    "acid",
    "acorn",
    "acquaint",
    "acquire",
    "acre",
    "acrobat",
    "acronym",
    "acting",
    "action",
    "activate",
    "activator",
    "active",
    "activism",
    "activist",
    "activity",
    "actress",
    "acts",
    "acutely",
    "acuteness",
    "aeration",
    "aerobics",
    "aerosol",
    "aerospace",
    "afar",
    "affair",
    "affected",
    "affecting",
    "affection",
    "affidavit",
    "affiliate",
    "affirm",
    "affix",
    "afflicted",
    "affluent",
    "afford",
    "affront",
    "aflame",
    "afloat",
    "aflutter",
    "afoot",
    "afraid",
    "afterglow",
    "afterlife",
    "aftermath",
    "aftermost",
    "afternoon",
    "aged",
    "ageless",
    "agency",
    "agenda",
    "agent",
    "aggregate",
    "aghast",
    "agile",
    "agility",
    "aging",
    "agnostic",
    "agonize",
    "agonizing",
    "agony",
    "agreeable",
    "agreeably",
    "agreed",
    "agreeing",
    "agreement",
    "aground",
    "ahead",
    "ahoy",
    "aide",
    "aids",
    "aim",
    "ajar",
    "alabaster",
    "alarm",
    "albatross",
    "album",
    "alfalfa",
    "algebra",
    "algorithm",
    "alias",
    "alibi",
    "alienable",
    "alienate",
    "aliens",
    "alike",
    "alive",
    "alkaline",
    "alkalize",
    "almanac",
    "almighty",
    "almost",
    "aloe",
    "aloft",
    "aloha",
    "alone",
    "alongside",
    "aloof",
    "alphabet",
    "alright",
    "although",
    "altitude",
    "alto",
    "aluminum",
    "alumni",
    "always",
    "amaretto",
    "amaze",
    "amazingly",
    "amber",
    "ambiance",
    "ambiguity",
    "ambiguous",
    "ambition",
    "ambitious",
    "ambulance",
    "ambush",
    "amendable",
    "amendment",
    "amends",
    "amenity",
    "amiable",
    "amicably",
    "amid",
    "amigo",
    "amino",
    "amiss",
    "ammonia",
    "ammonium",
    "amnesty",
    "amniotic",
    "among",
    "amount",
    "amperage",
    "ample",
    "amplifier",
    "amplify",
    "amply",
    "amuck",
    "amulet",
    "amusable",
    "amused",
    "amusement",
    "amuser",
    "amusing",
    "anaconda",
    "anaerobic",
    "anagram",
    "anatomist",
    "anatomy",
    "anchor",
    "anchovy",
    "ancient",
    "android",
    "anemia",
    "anemic",
    "aneurism",
    "anew",
    "angelfish",
    "angelic",
    "anger",
    "angled",
    "angler",
    "angles",
    "angling",
    "angrily",
    "angriness",
    "anguished",
    "angular",
    "animal",
    "animate",
    "animating",
    "animation",
    "animator",
    "anime",
    "animosity",
    "ankle",
    "annex",
    "annotate",
    "announcer",
    "annoying",
    "annually",
    "annuity",
    "anointer",
    "another",
    "answering",
    "antacid",
    "antarctic",
    "anteater",
    "antelope",
    "antennae",
    "anthem",
    "anthill",
    "anthology",
    "antibody",
    "antics",
    "antidote",
    "antihero",
    "antiquely",
    "antiques",
    "antiquity",
    "antirust",
    "antitoxic",
    "antitrust",
    "antiviral",
    "antivirus",
    "antler",
    "antonym",
    "antsy",
    "anvil",
    "anybody",
    "anyhow",
    "anymore",
    "anyone",
    "anyplace",
    "anything",
    "anytime",
    "anyway",
    "anywhere",
    "aorta",
    "apache",
    "apostle",
    "appealing",
    "appear",
    "appease",
    "appeasing",
    "appendage",
    "appendix",
    "appetite",
    "appetizer",
    "applaud",
    "applause",
    "apple",
    "appliance",
    "applicant",
    "applied",
    "apply",
    "appointee",
    "appraisal",
    "appraiser",
    "apprehend",
    "approach",
    "approval",
    "approve",
    "apricot",
    "april",
    "apron",
    "aptitude",
    "aptly",
    "aqua",
    "aqueduct",
    "arbitrary",
    "arbitrate",
    "ardently",
    "area",
    "arena",
    "arguable",
    "arguably",
    "argue",
    "arise",
    "armadillo",
    "armband",
    "armchair",
    "armed",
    "armful",
    "armhole",
    "arming",
    "armless",
    "armoire",
    "armored",
    "armory",
    "armrest",
    "army",
    "aroma",
    "arose",
    "around",
    "arousal",
    "arrange",
    "array",
    "arrest",
    "arrival",
    "arrive",
    "arrogance",
    "arrogant",
    "arson",
    "art",
    "ascend",
    "ascension",
    "ascent",
    "ascertain",
    "ashamed",
    "ashen",
    "ashes",
    "ashy",
    "aside",
    "askew",
    "asleep",
    "asparagus",
    "aspect",
    "aspirate",
    "aspire",
    "aspirin",
    "astonish",
    "astound",
    "astride",
    "astrology",
    "astronaut",
    "astronomy",
    "astute",
    "atlantic",
    "atlas",
    "atom",
    "atonable",
    "atop",
    "atrium",
    "atrocious",
    "atrophy",
    "attach",
    "attain",
    "attempt",
    "attendant",
    "attendee",
    "attention",
    "attentive",
    "attest",
    "attic",
    "attire",
    "attitude",
    "attractor",
    "attribute",
    "atypical",
    "auction",
    "audacious",
    "audacity",
    "audible",
    "audibly",
    "audience",
    "audio",
    "audition",
    "augmented",
    "august",
    "authentic",
    "author",
    "autism",
    "autistic",
    "autograph",
    "automaker",
    "automated",
    "automatic",
    "autopilot",
    "available",
    "avalanche",
    "avatar",
    "avenge",
    "avenging",
    "avenue",
    "average",
    "aversion",
    "avert",
    "aviation",
    "aviator",
    "avid",
    "avoid",
    "await",
    "awaken",
    "award",
    "aware",
    "awhile",
    "awkward",
    "awning",
    "awoke",
    "awry",
    "axis",
    "babble",
    "babbling",
    "babied",
    "baboon",
    "backache",
    "backboard",
    "backboned",
    "backdrop",
    "backed",
    "backer",
    "backfield",
    "backfire",
    "backhand",
    "backing",
    "backlands",
    "backlash",
    "backless",
    "backlight",
    "backlit",
    "backlog",
    "backpack",
    "backpedal",
    "backrest",
    "backroom",
    "backshift",
    "backside",
    "backslid",
    "backspace",
    "backspin",
    "backstab",
    "backstage",
    "backtalk",
    "backtrack",
    "backup",
    "backward",
    "backwash",
    "backwater",
    "backyard",
    "bacon",
    "bacteria",
    "bacterium",
    "badass",
    "badge",
    "badland",
    "badly",
    "badness",
    "baffle",
    "baffling",
    "bagel",
    "bagful",
    "baggage",
    "bagged",
    "baggie",
    "bagginess",
    "bagging",
    "baggy",
    "bagpipe",
    "baguette",
    "baked",
    "bakery",
    "bakeshop",
    "baking",
    "balance",
    "balancing",
    "balcony",
    "balmy",
    "balsamic",
    "bamboo",
    "banana",
    "banish",
    "banister",
    "banjo",
    "bankable",
    "bankbook",
    "banked",
    "banker",
    "banking",
    "banknote",
    "bankroll",
    "banner",
    "bannister",
    "banshee",
    "banter",
    "barbecue",
    "barbed",
    "barbell",
    "barber",
    "barcode",
    "barge",
    "bargraph",
    "barista",
    "baritone",
    "barley",
    "barmaid",
    "barman",
    "barn",
    "barometer",
    "barrack",
    "barracuda",
    "barrel",
    "barrette",
    "barricade",
    "barrier",
    "barstool",
    "bartender",
    "barterer",
    "bash",
    "basically",
    "basics",
    "basil",
    "basin",
    "basis",
    "basket",
    "batboy",
    "batch",
    "bath",
    "baton",
    "bats",
    "battalion",
    "battered",
    "battering",
    "battery",
    "batting",
    "battle",
    "bauble",
    "bazooka",
    "blabber",
    "bladder",
    "blade",
    "blah",
    "blame",
    "blaming",
    "blanching",
    "blandness",
    "blank",
    "blaspheme",
    "blasphemy",
    "blast",
    "blatancy",
    "blatantly",
    "blazer",
    "blazing",
    "bleach",
    "bleak",
    "bleep",
    "blemish",
    "blend",
    "bless",
    "blighted",
    "blimp",
    "bling",
    "blinked",
    "blinker",
    "blinking",
    "blinks",
    "blip",
    "blissful",
    "blitz",
    "blizzard",
    "bloated",
    "bloating",
    "blob",
    "blog",
    "bloomers",
    "blooming",
    "blooper",
    "blot",
    "blouse",
    "blubber",
    "bluff",
    "bluish",
    "blunderer",
    "blunt",
    "blurb",
    "blurred",
    "blurry",
    "blurt",
    "blush",
    "blustery",
    "boaster",
    "boastful",
    "boasting",
    "boat",
    "bobbed",
    "bobbing",
    "bobble",
    "bobcat",
    "bobsled",
    "bobtail",
    "bodacious",
    "body",
    "bogged",
    "boggle",
    "bogus",
    "boil",
    "bok",
    "bolster",
    "bolt",
    "bonanza",
    "bonded",
    "bonding",
    "bondless",
    "boned",
    "bonehead",
    "boneless",
    "bonelike",
    "boney",
    "bonfire",
    "bonnet",
    "bonsai",
    "bonus",
    "bony",
    "boogeyman",
    "boogieman",
    "book",
    "boondocks",
    "booted",
    "booth",
    "bootie",
    "booting",
    "bootlace",
    "bootleg",
    "boots",
    "boozy",
    "borax",
    "boring",
    "borough",
    "borrower",
    "borrowing",
    "boss",
    "botanical",
    "botanist",
    "botany",
    "botch",
    "both",
    "bottle",
    "bottling",
    "bottom",
    "bounce",
    "bouncing",
    "bouncy",
    "bounding",
    "boundless",
    "bountiful",
    "bovine",
    "boxcar",
    "boxer",
    "boxing",
    "boxlike",
    "boxy",
    "breach",
    "breath",
    "breeches",
    "breeching",
    "breeder",
    "breeding",
    "breeze",
    "breezy",
    "brethren",
    "brewery",
    "brewing",
    "briar",
    "bribe",
    "brick",
    "bride",
    "bridged",
    "brigade",
    "bright",
    "brilliant",
    "brim",
    "bring",
    "brink",
    "brisket",
    "briskly",
    "briskness",
    "bristle",
    "brittle",
    "broadband",
    "broadcast",
    "broaden",
    "broadly",
    "broadness",
    "broadside",
    "broadways",
    "broiler",
    "broiling",
    "broken",
    "broker",
    "bronchial",
    "bronco",
    "bronze",
    "bronzing",
    "brook",
    "broom",
    "brought",
    "browbeat",
    "brownnose",
    "browse",
    "browsing",
    "bruising",
    "brunch",
    "brunette",
    "brunt",
    "brush",
    "brussels",
    "brute",
    "brutishly",
    "bubble",
    "bubbling",
    "bubbly",
    "buccaneer",
    "bucked",
    "bucket",
    "buckle",
    "buckshot",
    "buckskin",
    "bucktooth",
    "buckwheat",
    "buddhism",
    "buddhist",
    "budding",
    "buddy",
    "budget",
    "buffalo",
    "buffed",
    "buffer",
    "buffing",
    "buffoon",
    "buggy",
    "bulb",
    "bulge",
    "bulginess",
    "bulgur",
    "bulk",
    "bulldog",
    "bulldozer",
    "bullfight",
    "bullfrog",
    "bullhorn",
    "bullion",
    "bullish",
    "bullpen",
    "bullring",
    "bullseye",
    "bullwhip",
    "bully",
    "bunch",
    "bundle",
    "bungee",
    "bunion",
    "bunkbed",
    "bunkhouse",
    "bunkmate",
    "bunny",
    "bunt",
    "busboy",
    "bush",
    "busily",
    "busload",
    "bust",
    "busybody",
    "buzz",
    "cabana",
    "cabbage",
    "cabbie",
    "cabdriver",
    "cable",
    "caboose",
    "cache",
    "cackle",
    "cacti",
    "cactus",
    "caddie",
    "caddy",
    "cadet",
    "cadillac",
    "cadmium",
    "cage",
    "cahoots",
    "cake",
    "calamari",
    "calamity",
    "calcium",
    "calculate",
    "calculus",
    "caliber",
    "calibrate",
    "calm",
    "caloric",
    "calorie",
    "calzone",
    "camcorder",
    "cameo",
    "camera",
    "camisole",
    "camper",
    "campfire",
    "camping",
    "campsite",
    "campus",
    "canal",
    "canary",
    "cancel",
    "candied",
    "candle",
    "candy",
    "cane",
    "canine",
    "canister",
    "cannabis",
    "canned",
    "canning",
    "cannon",
    "cannot",
    "canola",
    "canon",
    "canopener",
    "canopy",
    "canteen",
    "canyon",
    "capable",
    "capably",
    "capacity",
    "cape",
    "capillary",
    "capital",
    "capitol",
    "capped",
    "capricorn",
    "capsize",
    "capsule",
    "caption",
    "captivate",
    "captive",
    "captivity",
    "capture",
    "caramel",
    "carat",
    "caravan",
    "carbon",
    "cardboard",
    "carded",
    "cardiac",
    "cardigan",
    "cardinal",
    "cardstock",
    "carefully",
    "caregiver",
    "careless",
    "caress",
    "caretaker",
    "cargo",
    "caring",
    "carless",
    "carload",
    "carmaker",
    "carnage",
    "carnation",
    "carnival",
    "carnivore",
    "carol",
    "carpenter",
    "carpentry",
    "carpool",
    "carport",
    "carried",
    "carrot",
    "carrousel",
    "carry",
    "cartel",
    "cartload",
    "carton",
    "cartoon",
    "cartridge",
    "cartwheel",
    "carve",
    "carving",
    "carwash",
    "cascade",
    "case",
    "cash",
    "casing",
    "casino",
    "casket",
    "cassette",
    "casually",
    "casualty",
    "catacomb",
    "catalog",
    "catalyst",
    "catalyze",
    "catapult",
    "cataract",
    "catatonic",
    "catcall",
    "catchable",
    "catcher",
    "catching",
    "catchy",
    "caterer",
    "catering",
    "catfight",
    "catfish",
    "cathedral",
    "cathouse",
    "catlike",
    "catnap",
    "catnip",
    "catsup",
    "cattail",
    "cattishly",
    "cattle",
    "catty",
    "catwalk",
    "caucasian",
    "caucus",
    "causal",
    "causation",
    "cause",
    "causing",
    "cauterize",
    "caution",
    "cautious",
    "cavalier",
    "cavalry",
    "caviar",
    "cavity",
    "cedar",
    "celery",
    "celestial",
    "celibacy",
    "celibate",
    "celtic",
    "cement",
    "census",
    "ceramics",
    "ceremony",
    "certainly",
    "certainty",
    "certified",
    "certify",
    "cesarean",
    "cesspool",
    "chafe",
    "chaffing",
    "chain",
    "chair",
    "chalice",
    "challenge",
    "chamber",
    "chamomile",
    "champion",
    "chance",
    "change",
    "channel",
    "chant",
    "chaos",
    "chaperone",
    "chaplain",
    "chapped",
    "chaps",
    "chapter",
    "character",
    "charbroil",
    "charcoal",
    "charger",
    "charging",
    "chariot",
    "charity",
    "charm",
    "charred",
    "charter",
    "charting",
    "chase",
    "chasing",
    "chaste",
    "chastise",
    "chastity",
    "chatroom",
    "chatter",
    "chatting",
    "chatty",
    "cheating",
    "cheddar",
    "cheek",
    "cheer",
    "cheese",
    "cheesy",
    "chef",
    "chemicals",
    "chemist",
    "chemo",
    "cherisher",
    "cherub",
    "chess",
    "chest",
    "chevron",
    "chevy",
    "chewable",
    "chewer",
    "chewing",
    "chewy",
    "chief",
    "chihuahua",
    "childcare",
    "childhood",
    "childish",
    "childless",
    "childlike",
    "chili",
    "chill",
    "chimp",
    "chip",
    "chirping",
    "chirpy",
    "chitchat",
    "chivalry",
    "chive",
    "chloride",
    "chlorine",
    "choice",
    "chokehold",
    "choking",
    "chomp",
    "chooser",
    "choosing",
    "choosy",
    "chop",
    "chosen",
    "chowder",
    "chowtime",
    "chrome",
    "chubby",
    "chuck",
    "chug",
    "chummy",
    "chump",
    "chunk",
    "churn",
    "chute",
    "cider",
    "cilantro",
    "cinch",
    "cinema",
    "cinnamon",
    "circle",
    "circling",
    "circular",
    "circulate",
    "circus",
    "citable",
    "citadel",
    "citation",
    "citizen",
    "citric",
    "citrus",
    "city",
    "civic",
    "civil",
    "clad",
    "claim",
    "clambake",
    "clammy",
    "clamor",
    "clamp",
    "clamshell",
    "clang",
    "clanking",
    "clapped",
    "clapper",
    "clapping",
    "clarify",
    "clarinet",
    "clarity",
    "clash",
    "clasp",
    "class",
    "clatter",
    "clause",
    "clavicle",
    "claw",
    "clay",
    "clean",
    "clear",
    "cleat",
    "cleaver",
    "cleft",
    "clench",
    "clergyman",
    "clerical",
    "clerk",
    "clever",
    "clicker",
    "client",
    "climate",
    "climatic",
    "cling",
    "clinic",
    "clinking",
    "clip",
    "clique",
    "cloak",
    "clobber",
    "clock",
    "clone",
    "cloning",
    "closable",
    "closure",
    "clothes",
    "clothing",
    "cloud",
    "clover",
    "clubbed",
    "clubbing",
    "clubhouse",
    "clump",
    "clumsily",
    "clumsy",
    "clunky",
    "clustered",
    "clutch",
    "clutter",
    "coach",
    "coagulant",
    "coastal",
    "coaster",
    "coasting",
    "coastland",
    "coastline",
    "coat",
    "coauthor",
    "cobalt",
    "cobbler",
    "cobweb",
    "cocoa",
    "coconut",
    "cod",
    "coeditor",
    "coerce",
    "coexist",
    "coffee",
    "cofounder",
    "cognition",
    "cognitive",
    "cogwheel",
    "coherence",
    "coherent",
    "cohesive",
    "coil",
    "coke",
    "cola",
    "cold",
    "coleslaw",
    "coliseum",
    "collage",
    "collapse",
    "collar",
    "collected",
    "collector",
    "collide",
    "collie",
    "collision",
    "colonial",
    "colonist",
    "colonize",
    "colony",
    "colossal",
    "colt",
    "coma",
    "come",
    "comfort",
    "comfy",
    "comic",
    "coming",
    "comma",
    "commence",
    "commend",
    "comment",
    "commerce",
    "commode",
    "commodity",
    "commodore",
    "common",
    "commotion",
    "commute",
    "commuting",
    "compacted",
    "compacter",
    "compactly",
    "compactor",
    "companion",
    "company",
    "compare",
    "compel",
    "compile",
    "comply",
    "component",
    "composed",
    "composer",
    "composite",
    "compost",
    "composure",
    "compound",
    "compress",
    "comprised",
    "computer",
    "computing",
    "comrade",
    "concave",
    "conceal",
    "conceded",
    "concept",
    "concerned",
    "concert",
    "conch",
    "concierge",
    "concise",
    "conclude",
    "concrete",
    "concur",
    "condense",
    "condiment",
    "condition",
    "condone",
    "conducive",
    "conductor",
    "conduit",
    "cone",
    "confess",
    "confetti",
    "confidant",
    "confident",
    "confider",
    "confiding",
    "configure",
    "confined",
    "confining",
    "confirm",
    "conflict",
    "conform",
    "confound",
    "confront",
    "confused",
    "confusing",
    "confusion",
    "congenial",
    "congested",
    "congrats",
    "congress",
    "conical",
    "conjoined",
    "conjure",
    "conjuror",
    "connected",
    "connector",
    "consensus",
    "consent",
    "console",
    "consoling",
    "consonant",
    "constable",
    "constant",
    "constrain",
    "constrict",
    "construct",
    "consult",
    "consumer",
    "consuming",
    "contact",
    "container",
    "contempt",
    "contend",
    "contented",
    "contently",
    "contents",
    "contest",
    "context",
    "contort",
    "contour",
    "contrite",
    "control",
    "contusion",
    "convene",
    "convent",
    "copartner",
    "cope",
    "copied",
    "copier",
    "copilot",
    "coping",
    "copious",
    "copper",
    "copy",
    "coral",
    "cork",
    "cornball",
    "cornbread",
    "corncob",
    "cornea",
    "corned",
    "corner",
    "cornfield",
    "cornflake",
    "cornhusk",
    "cornmeal",
    "cornstalk",
    "corny",
    "coronary",
    "coroner",
    "corporal",
    "corporate",
    "corral",
    "correct",
    "corridor",
    "corrode",
    "corroding",
    "corrosive",
    "corsage",
    "corset",
    "cortex",
    "cosigner",
    "cosmetics",
    "cosmic",
    "cosmos",
    "cosponsor",
    "cost",
    "cottage",
    "cotton",
    "couch",
    "cough",
    "could",
    "countable",
    "countdown",
    "counting",
    "countless",
    "country",
    "county",
    "courier",
    "covenant",
    "cover",
    "coveted",
    "coveting",
    "coyness",
    "cozily",
    "coziness",
    "cozy",
    "crabbing",
    "crabgrass",
    "crablike",
    "crabmeat",
    "cradle",
    "cradling",
    "crafter",
    "craftily",
    "craftsman",
    "craftwork",
    "crafty",
    "cramp",
    "cranberry",
    "crane",
    "cranial",
    "cranium",
    "crank",
    "crate",
    "crave",
    "craving",
    "crawfish",
    "crawlers",
    "crawling",
    "crayfish",
    "crayon",
    "crazed",
    "crazily",
    "craziness",
    "crazy",
    "creamed",
    "creamer",
    "creamlike",
    "crease",
    "creasing",
    "creatable",
    "create",
    "creation",
    "creative",
    "creature",
    "credible",
    "credibly",
    "credit",
    "creed",
    "creme",
    "creole",
    "crepe",
    "crept",
    "crescent",
    "crested",
    "cresting",
    "crestless",
    "crevice",
    "crewless",
    "crewman",
    "crewmate",
    "crib",
    "cricket",
    "cried",
    "crier",
    "crimp",
    "crimson",
    "cringe",
    "cringing",
    "crinkle",
    "crinkly",
    "crisped",
    "crisping",
    "crisply",
    "crispness",
    "crispy",
    "criteria",
    "critter",
    "croak",
    "crock",
    "crook",
    "croon",
    "crop",
    "cross",
    "crouch",
    "crouton",
    "crowbar",
    "crowd",
    "crown",
    "crucial",
    "crudely",
    "crudeness",
    "cruelly",
    "cruelness",
    "cruelty",
    "crumb",
    "crummiest",
    "crummy",
    "crumpet",
    "crumpled",
    "cruncher",
    "crunching",
    "crunchy",
    "crusader",
    "crushable",
    "crushed",
    "crusher",
    "crushing",
    "crust",
    "crux",
    "crying",
    "cryptic",
    "crystal",
    "cubbyhole",
    "cube",
    "cubical",
    "cubicle",
    "cucumber",
    "cuddle",
    "cuddly",
    "cufflink",
    "culinary",
    "culminate",
    "culpable",
    "culprit",
    "cultivate",
    "cultural",
    "culture",
    "cupbearer",
    "cupcake",
    "cupid",
    "cupped",
    "cupping",
    "curable",
    "curator",
    "curdle",
    "cure",
    "curfew",
    "curing",
    "curled",
    "curler",
    "curliness",
    "curling",
    "curly",
    "curry",
    "curse",
    "cursive",
    "cursor",
    "curtain",
    "curtly",
    "curtsy",
    "curvature",
    "curve",
    "curvy",
    "cushy",
    "cusp",
    "cussed",
    "custard",
    "custodian",
    "custody",
    "customary",
    "customer",
    "customize",
    "customs",
    "cut",
    "cycle",
    "cyclic",
    "cycling",
    "cyclist",
    "cylinder",
    "cymbal",
    "cytoplasm",
    "cytoplast",
    "dab",
    "dad",
    "daffodil",
    "dagger",
    "daily",
    "daintily",
    "dainty",
    "dairy",
    "daisy",
    "dallying",
    "dance",
    "dancing",
    "dandelion",
    "dander",
    "dandruff",
    "dandy",
    "danger",
    "dangle",
    "dangling",
    "daredevil",
    "dares",
    "daringly",
    "darkened",
    "darkening",
    "darkish",
    "darkness",
    "darkroom",
    "darling",
    "darn",
    "dart",
    "darwinism",
    "dash",
    "dastardly",
    "data",
    "datebook",
    "dating",
    "daughter",
    "daunting",
    "dawdler",
    "dawn",
    "daybed",
    "daybreak",
    "daycare",
    "daydream",
    "daylight",
    "daylong",
    "dayroom",
    "daytime",
    "dazzler",
    "dazzling",
    "deacon",
    "deafening",
    "deafness",
    "dealer",
    "dealing",
    "dealmaker",
    "dealt",
    "dean",
    "debatable",
    "debate",
    "debating",
    "debit",
    "debrief",
    "debtless",
    "debtor",
    "debug",
    "debunk",
    "decade",
    "decaf",
    "decal",
    "decathlon",
    "decay",
    "deceased",
    "deceit",
    "deceiver",
    "deceiving",
    "december",
    "decency",
    "decent",
    "deception",
    "deceptive",
    "decibel",
    "decidable",
    "decimal",
    "decimeter",
    "decipher",
    "deck",
    "declared",
    "decline",
    "decode",
    "decompose",
    "decorated",
    "decorator",
    "decoy",
    "decrease",
    "decree",
    "dedicate",
    "dedicator",
    "deduce",
    "deduct",
    "deed",
    "deem",
    "deepen",
    "deeply",
    "deepness",
    "deface",
    "defacing",
    "defame",
    "default",
    "defeat",
    "defection",
    "defective",
    "defendant",
    "defender",
    "defense",
    "defensive",
    "deferral",
    "deferred",
    "defiance",
    "defiant",
    "defile",
    "defiling",
    "define",
    "definite",
    "deflate",
    "deflation",
    "deflator",
    "deflected",
    "deflector",
    "defog",
    "deforest",
    "defraud",
    "defrost",
    "deftly",
    "defuse",
    "defy",
    "degraded",
    "degrading",
    "degrease",
    "degree",
    "dehydrate",
    "deity",
    "dejected",
    "delay",
    "delegate",
    "delegator",
    "delete",
    "deletion",
    "delicacy",
    "delicate",
    "delicious",
    "delighted",
    "delirious",
    "delirium",
    "deliverer",
    "delivery",
    "delouse",
    "delta",
    "deluge",
    "delusion",
    "deluxe",
    "demanding",
    "demeaning",
    "demeanor",
    "demise",
    "democracy",
    "democrat",
    "demote",
    "demotion",
    "demystify",
    "denatured",
    "deniable",
    "denial",
    "denim",
    "denote",
    "dense",
    "density",
    "dental",
    "dentist",
    "denture",
    "deny",
    "deodorant",
    "deodorize",
    "departed",
    "departure",
    "depict",
    "deplete",
    "depletion",
    "deplored",
    "deploy",
    "deport",
    "depose",
    "depraved",
    "depravity",
    "deprecate",
    "depress",
    "deprive",
    "depth",
    "deputize",
    "deputy",
    "derail",
    "deranged",
    "derby",
    "derived",
    "desecrate",
    "deserve",
    "deserving",
    "designate",
    "designed",
    "designer",
    "designing",
    "deskbound",
    "desktop",
    "deskwork",
    "desolate",
    "despair",
    "despise",
    "despite",
    "destiny",
    "destitute",
    "destruct",
    "detached",
    "detail",
    "detection",
    "detective",
    "detector",
    "detention",
    "detergent",
    "detest",
    "detonate",
    "detonator",
    "detoxify",
    "detract",
    "deuce",
    "devalue",
    "deviancy",
    "deviant",
    "deviate",
    "deviation",
    "deviator",
    "device",
    "devious",
    "devotedly",
    "devotee",
    "devotion",
    "devourer",
    "devouring",
    "devoutly",
    "dexterity",
    "dexterous",
    "diabetes",
    "diabetic",
    "diabolic",
    "diagnoses",
    "diagnosis",
    "diagram",
    "dial",
    "diameter",
    "diaper",
    "diaphragm",
    "diary",
    "dice",
    "dicing",
    "dictate",
    "dictation",
    "dictator",
    "difficult",
    "diffused",
    "diffuser",
    "diffusion",
    "diffusive",
    "dig",
    "dilation",
    "diligence",
    "diligent",
    "dill",
    "dilute",
    "dime",
    "diminish",
    "dimly",
    "dimmed",
    "dimmer",
    "dimness",
    "dimple",
    "diner",
    "dingbat",
    "dinghy",
    "dinginess",
    "dingo",
    "dingy",
    "dining",
    "dinner",
    "diocese",
    "dioxide",
    "diploma",
    "dipped",
    "dipper",
    "dipping",
    "directed",
    "direction",
    "directive",
    "directly",
    "directory",
    "direness",
    "dirtiness",
    "disabled",
    "disagree",
    "disallow",
    "disarm",
    "disarray",
    "disaster",
    "disband",
    "disbelief",
    "disburse",
    "discard",
    "discern",
    "discharge",
    "disclose",
    "discolor",
    "discount",
    "discourse",
    "discover",
    "discuss",
    "disdain",
    "disengage",
    "disfigure",
    "disgrace",
    "dish",
    "disinfect",
    "disjoin",
    "disk",
    "dislike",
    "disliking",
    "dislocate",
    "dislodge",
    "disloyal",
    "dismantle",
    "dismay",
    "dismiss",
    "dismount",
    "disobey",
    "disorder",
    "disown",
    "disparate",
    "disparity",
    "dispatch",
    "dispense",
    "dispersal",
    "dispersed",
    "disperser",
    "displace",
    "display",
    "displease",
    "disposal",
    "dispose",
    "disprove",
    "dispute",
    "disregard",
    "disrupt",
    "dissuade",
    "distance",
    "distant",
    "distaste",
    "distill",
    "distinct",
    "distort",
    "distract",
    "distress",
    "district",
    "distrust",
    "ditch",
    "ditto",
    "ditzy",
    "dividable",
    "divided",
    "dividend",
    "dividers",
    "dividing",
    "divinely",
    "diving",
    "divinity",
    "divisible",
    "divisibly",
    "division",
    "divisive",
    "divorcee",
    "dizziness",
    "dizzy",
    "doable",
    "docile",
    "dock",
    "doctrine",
    "document",
    "dodge",
    "dodgy",
    "doily",
    "doing",
    "dole",
    "dollar",
    "dollhouse",
    "dollop",
    "dolly",
    "dolphin",
    "domain",
    "domelike",
    "domestic",
    "dominion",
    "dominoes",
    "donated",
    "donation",
    "donator",
    "donor",
    "donut",
    "doodle",
    "doorbell",
    "doorframe",
    "doorknob",
    "doorman",
    "doormat",
    "doornail",
    "doorpost",
    "doorstep",
    "doorstop",
    "doorway",
    "doozy",
    "dork",
    "dormitory",
    "dorsal",
    "dosage",
    "dose",
    "dotted",
    "doubling",
    "douche",
    "dove",
    "down",
    "dowry",
    "doze",
    "drab",
    "dragging",
    "dragonfly",
    "dragonish",
    "dragster",
    "drainable",
    "drainage",
    "drained",
    "drainer",
    "drainpipe",
    "dramatic",
    "dramatize",
    "drank",
    "drapery",
    "drastic",
    "draw",
    "dreaded",
    "dreadful",
    "dreadlock",
    "dreamboat",
    "dreamily",
    "dreamland",
    "dreamless",
    "dreamlike",
    "dreamt",
    "dreamy",
    "drearily",
    "dreary",
    "drench",
    "dress",
    "drew",
    "dribble",
    "dried",
    "drier",
    "drift",
    "driller",
    "drilling",
    "drinkable",
    "drinking",
    "dripping",
    "drippy",
    "drivable",
    "driven",
    "driver",
    "driveway",
    "driving",
    "drizzle",
    "drizzly",
    "drone",
    "drool",
    "droop",
    "drop-down",
    "dropbox",
    "dropkick",
    "droplet",
    "dropout",
    "dropper",
    "drove",
    "drown",
    "drowsily",
    "drudge",
    "drum",
    "dry",
    "dubbed",
    "dubiously",
    "duchess",
    "duckbill",
    "ducking",
    "duckling",
    "ducktail",
    "ducky",
    "duct",
    "dude",
    "duffel",
    "dugout",
    "duh",
    "duke",
    "duller",
    "dullness",
    "duly",
    "dumping",
    "dumpling",
    "dumpster",
    "duo",
    "dupe",
    "duplex",
    "duplicate",
    "duplicity",
    "durable",
    "durably",
    "duration",
    "duress",
    "during",
    "dusk",
    "dust",
    "dutiful",
    "duty",
    "duvet",
    "dwarf",
    "dweeb",
    "dwelled",
    "dweller",
    "dwelling",
    "dwindle",
    "dwindling",
    "dynamic",
    "dynamite",
    "dynasty",
    "dyslexia",
    "dyslexic",
    "each",
    "eagle",
    "earache",
    "eardrum",
    "earflap",
    "earful",
    "earlobe",
    "early",
    "earmark",
    "earmuff",
    "earphone",
    "earpiece",
    "earplugs",
    "earring",
    "earshot",
    "earthen",
    "earthlike",
    "earthling",
    "earthly",
    "earthworm",
    "earthy",
    "earwig",
    "easeful",
    "easel",
    "easiest",
    "easily",
    "easiness",
    "easing",
    "eastbound",
    "eastcoast",
    "easter",
    "eastward",
    "eatable",
    "eaten",
    "eatery",
    "eating",
    "eats",
    "ebay",
    "ebony",
    "ebook",
    "ecard",
    "eccentric",
    "echo",
    "eclair",
    "eclipse",
    "ecologist",
    "ecology",
    "economic",
    "economist",
    "economy",
    "ecosphere",
    "ecosystem",
    "edge",
    "edginess",
    "edging",
    "edgy",
    "edition",
    "editor",
    "educated",
    "education",
    "educator",
    "eel",
    "effective",
    "effects",
    "efficient",
    "effort",
    "eggbeater",
    "egging",
    "eggnog",
    "eggplant",
    "eggshell",
    "egomaniac",
    "egotism",
    "egotistic",
    "either",
    "eject",
    "elaborate",
    "elastic",
    "elated",
    "elbow",
    "eldercare",
    "elderly",
    "eldest",
    "electable",
    "election",
    "elective",
    "elephant",
    "elevate",
    "elevating",
    "elevation",
    "elevator",
    "eleven",
    "elf",
    "eligible",
    "eligibly",
    "eliminate",
    "elite",
    "elitism",
    "elixir",
    "elk",
    "ellipse",
    "elliptic",
    "elm",
    "elongated",
    "elope",
    "eloquence",
    "eloquent",
    "elsewhere",
    "elude",
    "elusive",
    "elves",
    "email",
    "embargo",
    "embark",
    "embassy",
    "embattled",
    "embellish",
    "ember",
    "embezzle",
    "emblaze",
    "emblem",
    "embody",
    "embolism",
    "emboss",
    "embroider",
    "emcee",
    "emerald",
    "emergency",
    "emission",
    "emit",
    "emote",
    "emoticon",
    "emotion",
    "empathic",
    "empathy",
    "emperor",
    "emphases",
    "emphasis",
    "emphasize",
    "emphatic",
    "empirical",
    "employed",
    "employee",
    "employer",
    "emporium",
    "empower",
    "emptier",
    "emptiness",
    "empty",
    "emu",
    "enable",
    "enactment",
    "enamel",
    "enchanted",
    "enchilada",
    "encircle",
    "enclose",
    "enclosure",
    "encode",
    "encore",
    "encounter",
    "encourage",
    "encroach",
    "encrust",
    "encrypt",
    "endanger",
    "endeared",
    "endearing",
    "ended",
    "ending",
    "endless",
    "endnote",
    "endocrine",
    "endorphin",
    "endorse",
    "endowment",
    "endpoint",
    "endurable",
    "endurance",
    "enduring",
    "energetic",
    "energize",
    "energy",
    "enforced",
    "enforcer",
    "engaged",
    "engaging",
    "engine",
    "engorge",
    "engraved",
    "engraver",
    "engraving",
    "engross",
    "engulf",
    "enhance",
    "enigmatic",
    "enjoyable",
    "enjoyably",
    "enjoyer",
    "enjoying",
    "enjoyment",
    "enlarged",
    "enlarging",
    "enlighten",
    "enlisted",
    "enquirer",
    "enrage",
    "enrich",
    "enroll",
    "enslave",
    "ensnare",
    "ensure",
    "entail",
    "entangled",
    "entering",
    "entertain",
    "enticing",
    "entire",
    "entitle",
    "entity",
    "entomb",
    "entourage",
    "entrap",
    "entree",
    "entrench",
    "entrust",
    "entryway",
    "entwine",
    "enunciate",
    "envelope",
    "enviable",
    "enviably",
    "envious",
    "envision",
    "envoy",
    "envy",
    "enzyme",
    "epic",
    "epidemic",
    "epidermal",
    "epidermis",
    "epidural",
    "epilepsy",
    "epileptic",
    "epilogue",
    "epiphany",
    "episode",
    "equal",
    "equate",
    "equation",
    "equator",
    "equinox",
    "equipment",
    "equity",
    "equivocal",
    "eradicate",
    "erasable",
    "erased",
    "eraser",
    "erasure",
    "ergonomic",
    "errand",
    "errant",
    "erratic",
    "error",
    "erupt",
    "escalate",
    "escalator",
    "escapable",
    "escapade",
    "escapist",
    "escargot",
    "eskimo",
    "esophagus",
    "espionage",
    "espresso",
    "esquire",
    "essay",
    "essence",
    "essential",
    "establish",
    "estate",
    "esteemed",
    "estimate",
    "estimator",
    "estranged",
    "estrogen",
    "etching",
    "eternal",
    "eternity",
    "ethanol",
    "ether",
    "ethically",
    "ethics",
    "euphemism",
    "evacuate",
    "evacuee",
    "evade",
    "evaluate",
    "evaluator",
    "evaporate",
    "evasion",
    "evasive",
    "even",
    "everglade",
    "evergreen",
    "everybody",
    "everyday",
    "everyone",
    "evict",
    "evidence",
    "evident",
    "evil",
    "evoke",
    "evolution",
    "evolve",
    "exact",
    "exalted",
    "example",
    "excavate",
    "excavator",
    "exceeding",
    "exception",
    "excess",
    "exchange",
    "excitable",
    "exciting",
    "exclaim",
    "exclude",
    "excluding",
    "exclusion",
    "exclusive",
    "excretion",
    "excretory",
    "excursion",
    "excusable",
    "excusably",
    "excuse",
    "exemplary",
    "exemplify",
    "exemption",
    "exerciser",
    "exert",
    "exes",
    "exfoliate",
    "exhale",
    "exhaust",
    "exhume",
    "exile",
    "existing",
    "exit",
    "exodus",
    "exonerate",
    "exorcism",
    "exorcist",
    "expand",
    "expanse",
    "expansion",
    "expansive",
    "expectant",
    "expedited",
    "expediter",
    "expel",
    "expend",
    "expenses",
    "expensive",
    "expert",
    "expire",
    "expiring",
    "explain",
    "expletive",
    "explicit",
    "explode",
    "exploit",
    "explore",
    "exploring",
    "exponent",
    "exporter",
    "exposable",
    "expose",
    "exposure",
    "express",
    "expulsion",
    "exquisite",
    "extended",
    "extending",
    "extent",
    "extenuate",
    "exterior",
    "external",
    "extinct",
    "extortion",
    "extradite",
    "extras",
    "extrovert",
    "extrude",
    "extruding",
    "exuberant",
    "fable",
    "fabric",
    "fabulous",
    "facebook",
    "facecloth",
    "facedown",
    "faceless",
    "facelift",
    "faceplate",
    "faceted",
    "facial",
    "facility",
    "facing",
    "facsimile",
    "faction",
    "factoid",
    "factor",
    "factsheet",
    "factual",
    "faculty",
    "fade",
    "fading",
    "failing",
    "falcon",
    "fall",
    "false",
    "falsify",
    "fame",
    "familiar",
    "family",
    "famine",
    "famished",
    "fanatic",
    "fancied",
    "fanciness",
    "fancy",
    "fanfare",
    "fang",
    "fanning",
    "fantasize",
    "fantastic",
    "fantasy",
    "fascism",
    "fastball",
    "faster",
    "fasting",
    "fastness",
    "faucet",
    "favorable",
    "favorably",
    "favored",
    "favoring",
    "favorite",
    "fax",
    "feast",
    "federal",
    "fedora",
    "feeble",
    "feed",
    "feel",
    "feisty",
    "feline",
    "felt-tip",
    "feminine",
    "feminism",
    "feminist",
    "feminize",
    "femur",
    "fence",
    "fencing",
    "fender",
    "ferment",
    "fernlike",
    "ferocious",
    "ferocity",
    "ferret",
    "ferris",
    "ferry",
    "fervor",
    "fester",
    "festival",
    "festive",
    "festivity",
    "fetal",
    "fetch",
    "fever",
    "fiber",
    "fiction",
    "fiddle",
    "fiddling",
    "fidelity",
    "fidgeting",
    "fidgety",
    "fifteen",
    "fifth",
    "fiftieth",
    "fifty",
    "figment",
    "figure",
    "figurine",
    "filing",
    "filled",
    "filler",
    "filling",
    "film",
    "filter",
    "filth",
    "filtrate",
    "finale",
    "finalist",
    "finalize",
    "finally",
    "finance",
    "financial",
    "finch",
    "fineness",
    "finer",
    "finicky",
    "finished",
    "finisher",
    "finishing",
    "finite",
    "finless",
    "finlike",
    "fiscally",
    "fit",
    "five",
    "flaccid",
    "flagman",
    "flagpole",
    "flagship",
    "flagstick",
    "flagstone",
    "flail",
    "flakily",
    "flaky",
    "flame",
    "flammable",
    "flanked",
    "flanking",
    "flannels",
    "flap",
    "flaring",
    "flashback",
    "flashbulb",
    "flashcard",
    "flashily",
    "flashing",
    "flashy",
    "flask",
    "flatbed",
    "flatfoot",
    "flatly",
    "flatness",
    "flatten",
    "flattered",
    "flatterer",
    "flattery",
    "flattop",
    "flatware",
    "flatworm",
    "flavored",
    "flavorful",
    "flavoring",
    "flaxseed",
    "fled",
    "fleshed",
    "fleshy",
    "flick",
    "flier",
    "flight",
    "flinch",
    "fling",
    "flint",
    "flip",
    "flirt",
    "float",
    "flock",
    "flogging",
    "flop",
    "floral",
    "florist",
    "floss",
    "flounder",
    "flyable",
    "flyaway",
    "flyer",
    "flying",
    "flyover",
    "flypaper",
    "foam",
    "foe",
    "fog",
    "foil",
    "folic",
    "folk",
    "follicle",
    "follow",
    "fondling",
    "fondly",
    "fondness",
    "fondue",
    "font",
    "food",
    "fool",
    "footage",
    "football",
    "footbath",
    "footboard",
    "footer",
    "footgear",
    "foothill",
    "foothold",
    "footing",
    "footless",
    "footman",
    "footnote",
    "footpad",
    "footpath",
    "footprint",
    "footrest",
    "footsie",
    "footsore",
    "footwear",
    "footwork",
    "fossil",
    "foster",
    "founder",
    "founding",
    "fountain",
    "fox",
    "foyer",
    "fraction",
    "fracture",
    "fragile",
    "fragility",
    "fragment",
    "fragrance",
    "fragrant",
    "frail",
    "frame",
    "framing",
    "frantic",
    "fraternal",
    "frayed",
    "fraying",
    "frays",
    "freckled",
    "freckles",
    "freebase",
    "freebee",
    "freebie",
    "freedom",
    "freefall",
    "freehand",
    "freeing",
    "freeload",
    "freely",
    "freemason",
    "freeness",
    "freestyle",
    "freeware",
    "freeway",
    "freewill",
    "freezable",
    "freezing",
    "freight",
    "french",
    "frenzied",
    "frenzy",
    "frequency",
    "frequent",
    "fresh",
    "fretful",
    "fretted",
    "friction",
    "friday",
    "fridge",
    "fried",
    "friend",
    "frighten",
    "frightful",
    "frigidity",
    "frigidly",
    "frill",
    "fringe",
    "frisbee",
    "frisk",
    "fritter",
    "frivolous",
    "frolic",
    "from",
    "front",
    "frostbite",
    "frosted",
    "frostily",
    "frosting",
    "frostlike",
    "frosty",
    "froth",
    "frown",
    "frozen",
    "fructose",
    "frugality",
    "frugally",
    "fruit",
    "frustrate",
    "frying",
    "gab",
    "gaffe",
    "gag",
    "gainfully",
    "gaining",
    "gains",
    "gala",
    "gallantly",
    "galleria",
    "gallery",
    "galley",
    "gallon",
    "gallows",
    "gallstone",
    "galore",
    "galvanize",
    "gambling",
    "game",
    "gaming",
    "gamma",
    "gander",
    "gangly",
    "gangrene",
    "gangway",
    "gap",
    "garage",
    "garbage",
    "garden",
    "gargle",
    "garland",
    "garlic",
    "garment",
    "garnet",
    "garnish",
    "garter",
    "gas",
    "gatherer",
    "gathering",
    "gating",
    "gauging",
    "gauntlet",
    "gauze",
    "gave",
    "gawk",
    "gazing",
    "gear",
    "gecko",
    "geek",
    "geiger",
    "gem",
    "gender",
    "generic",
    "generous",
    "genetics",
    "genre",
    "gentile",
    "gentleman",
    "gently",
    "gents",
    "geography",
    "geologic",
    "geologist",
    "geology",
    "geometric",
    "geometry",
    "geranium",
    "gerbil",
    "geriatric",
    "germicide",
    "germinate",
    "germless",
    "germproof",
    "gestate",
    "gestation",
    "gesture",
    "getaway",
    "getting",
    "getup",
    "giant",
    "gibberish",
    "giblet",
    "giddily",
    "giddiness",
    "giddy",
    "gift",
    "gigabyte",
    "gigahertz",
    "gigantic",
    "giggle",
    "giggling",
    "giggly",
    "gigolo",
    "gilled",
    "gills",
    "gimmick",
    "girdle",
    "giveaway",
    "given",
    "giver",
    "giving",
    "gizmo",
    "gizzard",
    "glacial",
    "glacier",
    "glade",
    "gladiator",
    "gladly",
    "glamorous",
    "glamour",
    "glance",
    "glancing",
    "glandular",
    "glare",
    "glaring",
    "glass",
    "glaucoma",
    "glazing",
    "gleaming",
    "gleeful",
    "glider",
    "gliding",
    "glimmer",
    "glimpse",
    "glisten",
    "glitch",
    "glitter",
    "glitzy",
    "gloater",
    "gloating",
    "gloomily",
    "gloomy",
    "glorified",
    "glorifier",
    "glorify",
    "glorious",
    "glory",
    "gloss",
    "glove",
    "glowing",
    "glowworm",
    "glucose",
    "glue",
    "gluten",
    "glutinous",
    "glutton",
    "gnarly",
    "gnat",
    "goal",
    "goatskin",
    "goes",
    "goggles",
    "going",
    "goldfish",
    "goldmine",
    "goldsmith",
    "golf",
    "goliath",
    "gonad",
    "gondola",
    "gone",
    "gong",
    "good",
    "gooey",
    "goofball",
    "goofiness",
    "goofy",
    "google",
    "goon",
    "gopher",
    "gore",
    "gorged",
    "gorgeous",
    "gory",
    "gosling",
    "gossip",
    "gothic",
    "gotten",
    "gout",
    "gown",
    "grab",
    "graceful",
    "graceless",
    "gracious",
    "gradation",
    "graded",
    "grader",
    "gradient",
    "grading",
    "gradually",
    "graduate",
    "graffiti",
    "grafted",
    "grafting",
    "grain",
    "granddad",
    "grandkid",
    "grandly",
    "grandma",
    "grandpa",
    "grandson",
    "granite",
    "granny",
    "granola",
    "grant",
    "granular",
    "grape",
    "graph",
    "grapple",
    "grappling",
    "grasp",
    "grass",
    "gratified",
    "gratify",
    "grating",
    "gratitude",
    "gratuity",
    "gravel",
    "graveness",
    "graves",
    "graveyard",
    "gravitate",
    "gravity",
    "gravy",
    "gray",
    "grazing",
    "greasily",
    "greedily",
    "greedless",
    "greedy",
    "green",
    "greeter",
    "greeting",
    "grew",
    "greyhound",
    "grid",
    "grief",
    "grievance",
    "grieving",
    "grievous",
    "grill",
    "grimace",
    "grimacing",
    "grime",
    "griminess",
    "grimy",
    "grinch",
    "grinning",
    "grip",
    "gristle",
    "grit",
    "groggily",
    "groggy",
    "groin",
    "groom",
    "groove",
    "grooving",
    "groovy",
    "grope",
    "ground",
    "grouped",
    "grout",
    "grove",
    "grower",
    "growing",
    "growl",
    "grub",
    "grudge",
    "grudging",
    "grueling",
    "gruffly",
    "grumble",
    "grumbling",
    "grumbly",
    "grumpily",
    "grunge",
    "grunt",
    "guacamole",
    "guidable",
    "guidance",
    "guide",
    "guiding",
    "guileless",
    "guise",
    "gulf",
    "gullible",
    "gully",
    "gulp",
    "gumball",
    "gumdrop",
    "gumminess",
    "gumming",
    "gummy",
    "gurgle",
    "gurgling",
    "guru",
    "gush",
    "gusto",
    "gusty",
    "gutless",
    "guts",
    "gutter",
    "guy",
    "guzzler",
    "gyration",
    "habitable",
    "habitant",
    "habitat",
    "habitual",
    "hacked",
    "hacker",
    "hacking",
    "hacksaw",
    "had",
    "haggler",
    "haiku",
    "half",
    "halogen",
    "halt",
    "halved",
    "halves",
    "hamburger",
    "hamlet",
    "hammock",
    "hamper",
    "hamster",
    "hamstring",
    "handbag",
    "handball",
    "handbook",
    "handbrake",
    "handcart",
    "handclap",
    "handclasp",
    "handcraft",
    "handcuff",
    "handed",
    "handful",
    "handgrip",
    "handgun",
    "handheld",
    "handiness",
    "handiwork",
    "handlebar",
    "handled",
    "handler",
    "handling",
    "handmade",
    "handoff",
    "handpick",
    "handprint",
    "handrail",
    "handsaw",
    "handset",
    "handsfree",
    "handshake",
    "handstand",
    "handwash",
    "handwork",
    "handwoven",
    "handwrite",
    "handyman",
    "hangnail",
    "hangout",
    "hangover",
    "hangup",
    "hankering",
    "hankie",
    "hanky",
    "haphazard",
    "happening",
    "happier",
    "happiest",
    "happily",
    "happiness",
    "happy",
    "harbor",
    "hardcopy",
    "hardcore",
    "hardcover",
    "harddisk",
    "hardened",
    "hardener",
    "hardening",
    "hardhat",
    "hardhead",
    "hardiness",
    "hardly",
    "hardness",
    "hardship",
    "hardware",
    "hardwired",
    "hardwood",
    "hardy",
    "harmful",
    "harmless",
    "harmonica",
    "harmonics",
    "harmonize",
    "harmony",
    "harness",
    "harpist",
    "harsh",
    "harvest",
    "hash",
    "hassle",
    "haste",
    "hastily",
    "hastiness",
    "hasty",
    "hatbox",
    "hatchback",
    "hatchery",
    "hatchet",
    "hatching",
    "hatchling",
    "hate",
    "hatless",
    "hatred",
    "haunt",
    "haven",
    "hazard",
    "hazelnut",
    "hazily",
    "haziness",
    "hazing",
    "hazy",
    "headache",
    "headband",
    "headboard",
    "headcount",
    "headdress",
    "headed",
    "header",
    "headfirst",
    "headgear",
    "heading",
    "headlamp",
    "headless",
    "headlock",
    "headphone",
    "headpiece",
    "headrest",
    "headroom",
    "headscarf",
    "headset",
    "headsman",
    "headstand",
    "headstone",
    "headway",
    "headwear",
    "heap",
    "heat",
    "heave",
    "heavily",
    "heaviness",
    "heaving",
    "hedge",
    "hedging",
    "heftiness",
    "hefty",
    "helium",
    "helmet",
    "helper",
    "helpful",
    "helping",
    "helpless",
    "helpline",
    "hemlock",
    "hemstitch",
    "hence",
    "henchman",
    "henna",
    "herald",
    "herbal",
    "herbicide",
    "herbs",
    "heritage",
    "hermit",
    "heroics",
    "heroism",
    "herring",
    "herself",
    "hertz",
    "hesitancy",
    "hesitant",
    "hesitate",
    "hexagon",
    "hexagram",
    "hubcap",
    "huddle",
    "huddling",
    "huff",
    "hug",
    "hula",
    "hulk",
    "hull",
    "human",
    "humble",
    "humbling",
    "humbly",
    "humid",
    "humiliate",
    "humility",
    "humming",
    "hummus",
    "humongous",
    "humorist",
    "humorless",
    "humorous",
    "humpback",
    "humped",
    "humvee",
    "hunchback",
    "hundredth",
    "hunger",
    "hungrily",
    "hungry",
    "hunk",
    "hunter",
    "hunting",
    "huntress",
    "huntsman",
    "hurdle",
    "hurled",
    "hurler",
    "hurling",
    "hurray",
    "hurricane",
    "hurried",
    "hurry",
    "hurt",
    "husband",
    "hush",
    "husked",
    "huskiness",
    "hut",
    "hybrid",
    "hydrant",
    "hydrated",
    "hydration",
    "hydrogen",
    "hydroxide",
    "hyperlink",
    "hypertext",
    "hyphen",
    "hypnoses",
    "hypnosis",
    "hypnotic",
    "hypnotism",
    "hypnotist",
    "hypnotize",
    "hypocrisy",
    "hypocrite",
    "ibuprofen",
    "ice",
    "iciness",
    "icing",
    "icky",
    "icon",
    "icy",
    "idealism",
    "idealist",
    "idealize",
    "ideally",
    "idealness",
    "identical",
    "identify",
    "identity",
    "ideology",
    "idiocy",
    "idiom",
    "idly",
    "igloo",
    "ignition",
    "ignore",
    "iguana",
    "illicitly",
    "illusion",
    "illusive",
    "image",
    "imaginary",
    "imagines",
    "imaging",
    "imbecile",
    "imitate",
    "imitation",
    "immature",
    "immerse",
    "immersion",
    "imminent",
    "immobile",
    "immodest",
    "immorally",
    "immortal",
    "immovable",
    "immovably",
    "immunity",
    "immunize",
    "impaired",
    "impale",
    "impart",
    "impatient",
    "impeach",
    "impeding",
    "impending",
    "imperfect",
    "imperial",
    "impish",
    "implant",
    "implement",
    "implicate",
    "implicit",
    "implode",
    "implosion",
    "implosive",
    "imply",
    "impolite",
    "important",
    "importer",
    "impose",
    "imposing",
    "impotence",
    "impotency",
    "impotent",
    "impound",
    "imprecise",
    "imprint",
    "imprison",
    "impromptu",
    "improper",
    "improve",
    "improving",
    "improvise",
    "imprudent",
    "impulse",
    "impulsive",
    "impure",
    "impurity",
    "iodine",
    "iodize",
    "ion",
    "ipad",
    "iphone",
    "ipod",
    "irate",
    "irk",
    "iron",
    "irregular",
    "irrigate",
    "irritable",
    "irritably",
    "irritant",
    "irritate",
    "islamic",
    "islamist",
    "isolated",
    "isolating",
    "isolation",
    "isotope",
    "issue",
    "issuing",
    "italicize",
    "italics",
    "item",
    "itinerary",
    "itunes",
    "ivory",
    "ivy",
    "jab",
    "jackal",
    "jacket",
    "jackknife",
    "jackpot",
    "jailbird",
    "jailbreak",
    "jailer",
    "jailhouse",
    "jalapeno",
    "jam",
    "janitor",
    "january",
    "jargon",
    "jarring",
    "jasmine",
    "jaundice",
    "jaunt",
    "java",
    "jawed",
    "jawless",
    "jawline",
    "jaws",
    "jaybird",
    "jaywalker",
    "jazz",
    "jeep",
    "jeeringly",
    "jellied",
    "jelly",
    "jersey",
    "jester",
    "jet",
    "jiffy",
    "jigsaw",
    "jimmy",
    "jingle",
    "jingling",
    "jinx",
    "jitters",
    "jittery",
    "job",
    "jockey",
    "jockstrap",
    "jogger",
    "jogging",
    "john",
    "joining",
    "jokester",
    "jokingly",
    "jolliness",
    "jolly",
    "jolt",
    "jot",
    "jovial",
    "joyfully",
    "joylessly",
    "joyous",
    "joyride",
    "joystick",
    "jubilance",
    "jubilant",
    "judge",
    "judgingly",
    "judicial",
    "judiciary",
    "judo",
    "juggle",
    "juggling",
    "jugular",
    "juice",
    "juiciness",
    "juicy",
    "jujitsu",
    "jukebox",
    "july",
    "jumble",
    "jumbo",
    "jump",
    "junction",
    "juncture",
    "june",
    "junior",
    "juniper",
    "junkie",
    "junkman",
    "junkyard",
    "jurist",
    "juror",
    "jury",
    "justice",
    "justifier",
    "justify",
    "justly",
    "justness",
    "juvenile",
    "kabob",
    "kangaroo",
    "karaoke",
    "karate",
    "karma",
    "kebab",
    "keenly",
    "keenness",
    "keep",
    "keg",
    "kelp",
    "kennel",
    "kept",
    "kerchief",
    "kerosene",
    "kettle",
    "kick",
    "kiln",
    "kilobyte",
    "kilogram",
    "kilometer",
    "kilowatt",
    "kilt",
    "kimono",
    "kindle",
    "kindling",
    "kindly",
    "kindness",
    "kindred",
    "kinetic",
    "kinfolk",
    "king",
    "kinship",
    "kinsman",
    "kinswoman",
    "kissable",
    "kisser",
    "kissing",
    "kitchen",
    "kite",
    "kitten",
    "kitty",
    "kiwi",
    "kleenex",
    "knapsack",
    "knee",
    "knelt",
    "knickers",
    "knoll",
    "koala",
    "kooky",
    "kosher",
    "krypton",
    "kudos",
    "kung",
    "labored",
    "laborer",
    "laboring",
    "laborious",
    "labrador",
    "ladder",
    "ladies",
    "ladle",
    "ladybug",
    "ladylike",
    "lagged",
    "lagging",
    "lagoon",
    "lair",
    "lake",
    "lance",
    "landed",
    "landfall",
    "landfill",
    "landing",
    "landlady",
    "landless",
    "landline",
    "landlord",
    "landmark",
    "landmass",
    "landmine",
    "landowner",
    "landscape",
    "landside",
    "landslide",
    "language",
    "lankiness",
    "lanky",
    "lantern",
    "lapdog",
    "lapel",
    "lapped",
    "lapping",
    "laptop",
    "lard",
    "large",
    "lark",
    "lash",
    "lasso",
    "last",
    "latch",
    "late",
    "lather",
    "latitude",
    "latrine",
    "latter",
    "latticed",
    "launch",
    "launder",
    "laundry",
    "laurel",
    "lavender",
    "lavish",
    "laxative",
    "lazily",
    "laziness",
    "lazy",
    "lecturer",
    "left",
    "legacy",
    "legal",
    "legend",
    "legged",
    "leggings",
    "legible",
    "legibly",
    "legislate",
    "lego",
    "legroom",
    "legume",
    "legwarmer",
    "legwork",
    "lemon",
    "lend",
    "length",
    "lens",
    "lent",
    "leotard",
    "lesser",
    "letdown",
    "lethargic",
    "lethargy",
    "letter",
    "lettuce",
    "level",
    "leverage",
    "levers",
    "levitate",
    "levitator",
    "liability",
    "liable",
    "liberty",
    "librarian",
    "library",
    "licking",
    "licorice",
    "lid",
    "life",
    "lifter",
    "lifting",
    "liftoff",
    "ligament",
    "likely",
    "likeness",
    "likewise",
    "liking",
    "lilac",
    "lilly",
    "lily",
    "limb",
    "limeade",
    "limelight",
    "limes",
    "limit",
    "limping",
    "limpness",
    "line",
    "lingo",
    "linguini",
    "linguist",
    "lining",
    "linked",
    "linoleum",
    "linseed",
    "lint",
    "lion",
    "lip",
    "liquefy",
    "liqueur",
    "liquid",
    "lisp",
    "list",
    "litigate",
    "litigator",
    "litmus",
    "litter",
    "little",
    "livable",
    "lived",
    "lively",
    "liver",
    "livestock",
    "lividly",
    "living",
    "lizard",
    "lubricant",
    "lubricate",
    "lucid",
    "luckily",
    "luckiness",
    "luckless",
    "lucrative",
    "ludicrous",
    "lugged",
    "lukewarm",
    "lullaby",
    "lumber",
    "luminance",
    "luminous",
    "lumpiness",
    "lumping",
    "lumpish",
    "lunacy",
    "lunar",
    "lunchbox",
    "luncheon",
    "lunchroom",
    "lunchtime",
    "lung",
    "lurch",
    "lure",
    "luridness",
    "lurk",
    "lushly",
    "lushness",
    "luster",
    "lustfully",
    "lustily",
    "lustiness",
    "lustrous",
    "lusty",
    "luxurious",
    "luxury",
    "lying",
    "lyrically",
    "lyricism",
    "lyricist",
    "lyrics",
    "macarena",
    "macaroni",
    "macaw",
    "mace",
    "machine",
    "machinist",
    "magazine",
    "magenta",
    "maggot",
    "magical",
    "magician",
    "magma",
    "magnesium",
    "magnetic",
    "magnetism",
    "magnetize",
    "magnifier",
    "magnify",
    "magnitude",
    "magnolia",
    "mahogany",
    "maimed",
    "majestic",
    "majesty",
    "majorette",
    "majority",
    "makeover",
    "maker",
    "makeshift",
    "making",
    "malformed",
    "malt",
    "mama",
    "mammal",
    "mammary",
    "mammogram",
    "manager",
    "managing",
    "manatee",
    "mandarin",
    "mandate",
    "mandatory",
    "mandolin",
    "manger",
    "mangle",
    "mango",
    "mangy",
    "manhandle",
    "manhole",
    "manhood",
    "manhunt",
    "manicotti",
    "manicure",
    "manifesto",
    "manila",
    "mankind",
    "manlike",
    "manliness",
    "manly",
    "manmade",
    "manned",
    "mannish",
    "manor",
    "manpower",
    "mantis",
    "mantra",
    "manual",
    "many",
    "map",
    "marathon",
    "marauding",
    "marbled",
    "marbles",
    "marbling",
    "march",
    "mardi",
    "margarine",
    "margarita",
    "margin",
    "marigold",
    "marina",
    "marine",
    "marital",
    "maritime",
    "marlin",
    "marmalade",
    "maroon",
    "married",
    "marrow",
    "marry",
    "marshland",
    "marshy",
    "marsupial",
    "marvelous",
    "marxism",
    "mascot",
    "masculine",
    "mashed",
    "mashing",
    "massager",
    "masses",
    "massive",
    "mastiff",
    "matador",
    "matchbook",
    "matchbox",
    "matcher",
    "matching",
    "matchless",
    "material",
    "maternal",
    "maternity",
    "math",
    "mating",
    "matriarch",
    "matrimony",
    "matrix",
    "matron",
    "matted",
    "matter",
    "maturely",
    "maturing",
    "maturity",
    "mauve",
    "maverick",
    "maximize",
    "maximum",
    "maybe",
    "mayday",
    "mayflower",
    "moaner",
    "moaning",
    "mobile",
    "mobility",
    "mobilize",
    "mobster",
    "mocha",
    "mocker",
    "mockup",
    "modified",
    "modify",
    "modular",
    "modulator",
    "module",
    "moisten",
    "moistness",
    "moisture",
    "molar",
    "molasses",
    "mold",
    "molecular",
    "molecule",
    "molehill",
    "mollusk",
    "mom",
    "monastery",
    "monday",
    "monetary",
    "monetize",
    "moneybags",
    "moneyless",
    "moneywise",
    "mongoose",
    "mongrel",
    "monitor",
    "monkhood",
    "monogamy",
    "monogram",
    "monologue",
    "monopoly",
    "monorail",
    "monotone",
    "monotype",
    "monoxide",
    "monsieur",
    "monsoon",
    "monstrous",
    "monthly",
    "monument",
    "moocher",
    "moodiness",
    "moody",
    "mooing",
    "moonbeam",
    "mooned",
    "moonlight",
    "moonlike",
    "moonlit",
    "moonrise",
    "moonscape",
    "moonshine",
    "moonstone",
    "moonwalk",
    "mop",
    "morale",
    "morality",
    "morally",
    "morbidity",
    "morbidly",
    "morphine",
    "morphing",
    "morse",
    "mortality",
    "mortally",
    "mortician",
    "mortified",
    "mortify",
    "mortuary",
    "mosaic",
    "mossy",
    "most",
    "mothball",
    "mothproof",
    "motion",
    "motivate",
    "motivator",
    "motive",
    "motocross",
    "motor",
    "motto",
    "mountable",
    "mountain",
    "mounted",
    "mounting",
    "mourner",
    "mournful",
    "mouse",
    "mousiness",
    "moustache",
    "mousy",
    "mouth",
    "movable",
    "move",
    "movie",
    "moving",
    "mower",
    "mowing",
    "much",
    "muck",
    "mud",
    "mug",
    "mulberry",
    "mulch",
    "mule",
    "mulled",
    "mullets",
    "multiple",
    "multiply",
    "multitask",
    "multitude",
    "mumble",
    "mumbling",
    "mumbo",
    "mummified",
    "mummify",
    "mummy",
    "mumps",
    "munchkin",
    "mundane",
    "municipal",
    "muppet",
    "mural",
    "murkiness",
    "murky",
    "murmuring",
    "muscular",
    "museum",
    "mushily",
    "mushiness",
    "mushroom",
    "mushy",
    "music",
    "musket",
    "muskiness",
    "musky",
    "mustang",
    "mustard",
    "muster",
    "mustiness",
    "musty",
    "mutable",
    "mutate",
    "mutation",
    "mute",
    "mutilated",
    "mutilator",
    "mutiny",
    "mutt",
    "mutual",
    "muzzle",
    "myself",
    "myspace",
    "mystified",
    "mystify",
    "myth",
    "nacho",
    "nag",
    "nail",
    "name",
    "naming",
    "nanny",
    "nanometer",
    "nape",
    "napkin",
    "napped",
    "napping",
    "nappy",
    "narrow",
    "nastily",
    "nastiness",
    "national",
    "native",
    "nativity",
    "natural",
    "nature",
    "naturist",
    "nautical",
    "navigate",
    "navigator",
    "navy",
    "nearby",
    "nearest",
    "nearly",
    "nearness",
    "neatly",
    "neatness",
    "nebula",
    "nebulizer",
    "nectar",
    "negate",
    "negation",
    "negative",
    "neglector",
    "negligee",
    "negligent",
    "negotiate",
    "nemeses",
    "nemesis",
    "neon",
    "nephew",
    "nerd",
    "nervous",
    "nervy",
    "nest",
    "net",
    "neurology",
    "neuron",
    "neurosis",
    "neurotic",
    "neuter",
    "neutron",
    "never",
    "next",
    "nibble",
    "nickname",
    "nicotine",
    "niece",
    "nifty",
    "nimble",
    "nimbly",
    "nineteen",
    "ninetieth",
    "ninja",
    "nintendo",
    "ninth",
    "nuclear",
    "nuclei",
    "nucleus",
    "nugget",
    "nullify",
    "number",
    "numbing",
    "numbly",
    "numbness",
    "numeral",
    "numerate",
    "numerator",
    "numeric",
    "numerous",
    "nuptials",
    "nursery",
    "nursing",
    "nurture",
    "nutcase",
    "nutlike",
    "nutmeg",
    "nutrient",
    "nutshell",
    "nuttiness",
    "nutty",
    "nuzzle",
    "nylon",
    "oaf",
    "oak",
    "oasis",
    "oat",
    "obedience",
    "obedient",
    "obituary",
    "object",
    "obligate",
    "obliged",
    "oblivion",
    "oblivious",
    "oblong",
    "obnoxious",
    "oboe",
    "obscure",
    "obscurity",
    "observant",
    "observer",
    "observing",
    "obsessed",
    "obsession",
    "obsessive",
    "obsolete",
    "obstacle",
    "obstinate",
    "obstruct",
    "obtain",
    "obtrusive",
    "obtuse",
    "obvious",
    "occultist",
    "occupancy",
    "occupant",
    "occupier",
    "occupy",
    "ocean",
    "ocelot",
    "octagon",
    "octane",
    "october",
    "octopus",
    "ogle",
    "oil",
    "oink",
    "ointment",
    "okay",
    "old",
    "olive",
    "olympics",
    "omega",
    "omen",
    "ominous",
    "omission",
    "omit",
    "omnivore",
    "onboard",
    "oncoming",
    "ongoing",
    "onion",
    "online",
    "onlooker",
    "only",
    "onscreen",
    "onset",
    "onshore",
    "onslaught",
    "onstage",
    "onto",
    "onward",
    "onyx",
    "oops",
    "ooze",
    "oozy",
    "opacity",
    "opal",
    "open",
    "operable",
    "operate",
    "operating",
    "operation",
    "operative",
    "operator",
    "opium",
    "opossum",
    "opponent",
    "oppose",
    "opposing",
    "opposite",
    "oppressed",
    "oppressor",
    "opt",
    "opulently",
    "osmosis",
    "other",
    "otter",
    "ouch",
    "ought",
    "ounce",
    "outage",
    "outback",
    "outbid",
    "outboard",
    "outbound",
    "outbreak",
    "outburst",
    "outcast",
    "outclass",
    "outcome",
    "outdated",
    "outdoors",
    "outer",
    "outfield",
    "outfit",
    "outflank",
    "outgoing",
    "outgrow",
    "outhouse",
    "outing",
    "outlast",
    "outlet",
    "outline",
    "outlook",
    "outlying",
    "outmatch",
    "outmost",
    "outnumber",
    "outplayed",
    "outpost",
    "outpour",
    "output",
    "outrage",
    "outrank",
    "outreach",
    "outright",
    "outscore",
    "outsell",
    "outshine",
    "outshoot",
    "outsider",
    "outskirts",
    "outsmart",
    "outsource",
    "outspoken",
    "outtakes",
    "outthink",
    "outward",
    "outweigh",
    "outwit",
    "oval",
    "ovary",
    "oven",
    "overact",
    "overall",
    "overarch",
    "overbid",
    "overbill",
    "overbite",
    "overblown",
    "overboard",
    "overbook",
    "overbuilt",
    "overcast",
    "overcoat",
    "overcome",
    "overcook",
    "overcrowd",
    "overdraft",
    "overdrawn",
    "overdress",
    "overdrive",
    "overdue",
    "overeager",
    "overeater",
    "overexert",
    "overfed",
    "overfeed",
    "overfill",
    "overflow",
    "overfull",
    "overgrown",
    "overhand",
    "overhang",
    "overhaul",
    "overhead",
    "overhear",
    "overheat",
    "overhung",
    "overjoyed",
    "overkill",
    "overlabor",
    "overlaid",
    "overlap",
    "overlay",
    "overload",
    "overlook",
    "overlord",
    "overlying",
    "overnight",
    "overpass",
    "overpay",
    "overplant",
    "overplay",
    "overpower",
    "overprice",
    "overrate",
    "overreach",
    "overreact",
    "override",
    "overripe",
    "overrule",
    "overrun",
    "overshoot",
    "overshot",
    "oversight",
    "oversized",
    "oversleep",
    "oversold",
    "overspend",
    "overstate",
    "overstay",
    "overstep",
    "overstock",
    "overstuff",
    "oversweet",
    "overtake",
    "overthrow",
    "overtime",
    "overtly",
    "overtone",
    "overture",
    "overturn",
    "overuse",
    "overvalue",
    "overview",
    "overwrite",
    "owl",
    "oxford",
    "oxidant",
    "oxidation",
    "oxidize",
    "oxidizing",
    "oxygen",
    "oxymoron",
    "oyster",
    "ozone",
    "paced",
    "pacemaker",
    "pacific",
    "pacifier",
    "pacifism",
    "pacifist",
    "pacify",
    "padded",
    "padding",
    "paddle",
    "paddling",
    "padlock",
    "pagan",
    "pager",
    "paging",
    "pajamas",
    "palace",
    "palatable",
    "palm",
    "palpable",
    "palpitate",
    "paltry",
    "pampered",
    "pamperer",
    "pampers",
    "pamphlet",
    "panama",
    "pancake",
    "pancreas",
    "panda",
    "pandemic",
    "pang",
    "panhandle",
    "panic",
    "panning",
    "panorama",
    "panoramic",
    "panther",
    "pantomime",
    "pantry",
    "pants",
    "pantyhose",
    "paparazzi",
    "papaya",
    "paper",
    "paprika",
    "papyrus",
    "parabola",
    "parachute",
    "parade",
    "paradox",
    "paragraph",
    "parakeet",
    "paralegal",
    "paralyses",
    "paralysis",
    "paralyze",
    "paramedic",
    "parameter",
    "paramount",
    "parasail",
    "parasite",
    "parasitic",
    "parcel",
    "parched",
    "parchment",
    "pardon",
    "parish",
    "parka",
    "parking",
    "parkway",
    "parlor",
    "parmesan",
    "parole",
    "parrot",
    "parsley",
    "parsnip",
    "partake",
    "parted",
    "parting",
    "partition",
    "partly",
    "partner",
    "partridge",
    "party",
    "passable",
    "passably",
    "passage",
    "passcode",
    "passenger",
    "passerby",
    "passing",
    "passion",
    "passive",
    "passivism",
    "passover",
    "passport",
    "password",
    "pasta",
    "pasted",
    "pastel",
    "pastime",
    "pastor",
    "pastrami",
    "pasture",
    "pasty",
    "patchwork",
    "patchy",
    "paternal",
    "paternity",
    "path",
    "patience",
    "patient",
    "patio",
    "patriarch",
    "patriot",
    "patrol",
    "patronage",
    "patronize",
    "pauper",
    "pavement",
    "paver",
    "pavestone",
    "pavilion",
    "paving",
    "pawing",
    "payable",
    "payback",
    "paycheck",
    "payday",
    "payee",
    "payer",
    "paying",
    "payment",
    "payphone",
    "payroll",
    "pebble",
    "pebbly",
    "pecan",
    "pectin",
    "peculiar",
    "peddling",
    "pediatric",
    "pedicure",
    "pedigree",
    "pedometer",
    "pegboard",
    "pelican",
    "pellet",
    "pelt",
    "pelvis",
    "penalize",
    "penalty",
    "pencil",
    "pendant",
    "pending",
    "penholder",
    "penknife",
    "pennant",
    "penniless",
    "penny",
    "penpal",
    "pension",
    "pentagon",
    "pentagram",
    "pep",
    "perceive",
    "percent",
    "perch",
    "percolate",
    "perennial",
    "perfected",
    "perfectly",
    "perfume",
    "periscope",
    "perish",
    "perjurer",
    "perjury",
    "perkiness",
    "perky",
    "perm",
    "peroxide",
    "perpetual",
    "perplexed",
    "persecute",
    "persevere",
    "persuaded",
    "persuader",
    "pesky",
    "peso",
    "pessimism",
    "pessimist",
    "pester",
    "pesticide",
    "petal",
    "petite",
    "petition",
    "petri",
    "petroleum",
    "petted",
    "petticoat",
    "pettiness",
    "petty",
    "petunia",
    "phantom",
    "phobia",
    "phoenix",
    "phonebook",
    "phoney",
    "phonics",
    "phoniness",
    "phony",
    "phosphate",
    "photo",
    "phrase",
    "phrasing",
    "placard",
    "placate",
    "placidly",
    "plank",
    "planner",
    "plant",
    "plasma",
    "plaster",
    "plastic",
    "plated",
    "platform",
    "plating",
    "platinum",
    "platonic",
    "platter",
    "platypus",
    "plausible",
    "plausibly",
    "playable",
    "playback",
    "player",
    "playful",
    "playgroup",
    "playhouse",
    "playing",
    "playlist",
    "playmaker",
    "playmate",
    "playoff",
    "playpen",
    "playroom",
    "playset",
    "plaything",
    "playtime",
    "plaza",
    "pleading",
    "pleat",
    "pledge",
    "plentiful",
    "plenty",
    "plethora",
    "plexiglas",
    "pliable",
    "plod",
    "plop",
    "plot",
    "plow",
    "ploy",
    "pluck",
    "plug",
    "plunder",
    "plunging",
    "plural",
    "plus",
    "plutonium",
    "plywood",
    "poach",
    "pod",
    "poem",
    "poet",
    "pogo",
    "pointed",
    "pointer",
    "pointing",
    "pointless",
    "pointy",
    "poise",
    "poison",
    "poker",
    "poking",
    "polar",
    "police",
    "policy",
    "polio",
    "polish",
    "politely",
    "polka",
    "polo",
    "polyester",
    "polygon",
    "polygraph",
    "polymer",
    "poncho",
    "pond",
    "pony",
    "popcorn",
    "pope",
    "poplar",
    "popper",
    "poppy",
    "popsicle",
    "populace",
    "popular",
    "populate",
    "porcupine",
    "pork",
    "porous",
    "porridge",
    "portable",
    "portal",
    "portfolio",
    "porthole",
    "portion",
    "portly",
    "portside",
    "poser",
    "posh",
    "posing",
    "possible",
    "possibly",
    "possum",
    "postage",
    "postal",
    "postbox",
    "postcard",
    "posted",
    "poster",
    "posting",
    "postnasal",
    "posture",
    "postwar",
    "pouch",
    "pounce",
    "pouncing",
    "pound",
    "pouring",
    "pout",
    "powdered",
    "powdering",
    "powdery",
    "power",
    "powwow",
    "pox",
    "praising",
    "prance",
    "prancing",
    "pranker",
    "prankish",
    "prankster",
    "prayer",
    "praying",
    "preacher",
    "preaching",
    "preachy",
    "preamble",
    "precinct",
    "precise",
    "precision",
    "precook",
    "precut",
    "predator",
    "predefine",
    "predict",
    "preface",
    "prefix",
    "preflight",
    "preformed",
    "pregame",
    "pregnancy",
    "pregnant",
    "preheated",
    "prelaunch",
    "prelaw",
    "prelude",
    "premiere",
    "premises",
    "premium",
    "prenatal",
    "preoccupy",
    "preorder",
    "prepaid",
    "prepay",
    "preplan",
    "preppy",
    "preschool",
    "prescribe",
    "preseason",
    "preset",
    "preshow",
    "president",
    "presoak",
    "press",
    "presume",
    "presuming",
    "preteen",
    "pretended",
    "pretender",
    "pretense",
    "pretext",
    "pretty",
    "pretzel",
    "prevail",
    "prevalent",
    "prevent",
    "preview",
    "previous",
    "prewar",
    "prewashed",
    "prideful",
    "pried",
    "primal",
    "primarily",
    "primary",
    "primate",
    "primer",
    "primp",
    "princess",
    "print",
    "prior",
    "prism",
    "prison",
    "prissy",
    "pristine",
    "privacy",
    "private",
    "privatize",
    "prize",
    "proactive",
    "probable",
    "probably",
    "probation",
    "probe",
    "probing",
    "probiotic",
    "problem",
    "procedure",
    "process",
    "proclaim",
    "procreate",
    "procurer",
    "prodigal",
    "prodigy",
    "produce",
    "product",
    "profane",
    "profanity",
    "professed",
    "professor",
    "profile",
    "profound",
    "profusely",
    "progeny",
    "prognosis",
    "program",
    "progress",
    "projector",
    "prologue",
    "prolonged",
    "promenade",
    "prominent",
    "promoter",
    "promotion",
    "prompter",
    "promptly",
    "prone",
    "prong",
    "pronounce",
    "pronto",
    "proofing",
    "proofread",
    "proofs",
    "propeller",
    "properly",
    "property",
    "proponent",
    "proposal",
    "propose",
    "props",
    "prorate",
    "protector",
    "protegee",
    "proton",
    "prototype",
    "protozoan",
    "protract",
    "protrude",
    "proud",
    "provable",
    "proved",
    "proven",
    "provided",
    "provider",
    "providing",
    "province",
    "proving",
    "provoke",
    "provoking",
    "provolone",
    "prowess",
    "prowler",
    "prowling",
    "proximity",
    "proxy",
    "prozac",
    "prude",
    "prudishly",
    "prune",
    "pruning",
    "pry",
    "psychic",
    "public",
    "publisher",
    "pucker",
    "pueblo",
    "pug",
    "pull",
    "pulmonary",
    "pulp",
    "pulsate",
    "pulse",
    "pulverize",
    "puma",
    "pumice",
    "pummel",
    "punch",
    "punctual",
    "punctuate",
    "punctured",
    "pungent",
    "punisher",
    "punk",
    "pupil",
    "puppet",
    "puppy",
    "purchase",
    "pureblood",
    "purebred",
    "purely",
    "pureness",
    "purgatory",
    "purge",
    "purging",
    "purifier",
    "purify",
    "purist",
    "puritan",
    "purity",
    "purple",
    "purplish",
    "purposely",
    "purr",
    "purse",
    "pursuable",
    "pursuant",
    "pursuit",
    "purveyor",
    "pushcart",
    "pushchair",
    "pusher",
    "pushiness",
    "pushing",
    "pushover",
    "pushpin",
    "pushup",
    "pushy",
    "putdown",
    "putt",
    "puzzle",
    "puzzling",
    "pyramid",
    "pyromania",
    "python",
    "quack",
    "quadrant",
    "quail",
    "quaintly",
    "quake",
    "quaking",
    "qualified",
    "qualifier",
    "qualify",
    "quality",
    "qualm",
    "quantum",
    "quarrel",
    "quarry",
    "quartered",
    "quarterly",
    "quarters",
    "quartet",
    "quench",
    "query",
    "quicken",
    "quickly",
    "quickness",
    "quicksand",
    "quickstep",
    "quiet",
    "quill",
    "quilt",
    "quintet",
    "quintuple",
    "quirk",
    "quit",
    "quiver",
    "quizzical",
    "quotable",
    "quotation",
    "quote",
    "rabid",
    "race",
    "racing",
    "racism",
    "rack",
    "racoon",
    "radar",
    "radial",
    "radiance",
    "radiantly",
    "radiated",
    "radiation",
    "radiator",
    "radio",
    "radish",
    "raffle",
    "raft",
    "rage",
    "ragged",
    "raging",
    "ragweed",
    "raider",
    "railcar",
    "railing",
    "railroad",
    "railway",
    "raisin",
    "rake",
    "raking",
    "rally",
    "ramble",
    "rambling",
    "ramp",
    "ramrod",
    "ranch",
    "rancidity",
    "random",
    "ranged",
    "ranger",
    "ranging",
    "ranked",
    "ranking",
    "ransack",
    "ranting",
    "rants",
    "rare",
    "rarity",
    "rascal",
    "rash",
    "rasping",
    "ravage",
    "raven",
    "ravine",
    "raving",
    "ravioli",
    "ravishing",
    "reabsorb",
    "reach",
    "reacquire",
    "reaction",
    "reactive",
    "reactor",
    "reaffirm",
    "ream",
    "reanalyze",
    "reappear",
    "reapply",
    "reappoint",
    "reapprove",
    "rearrange",
    "rearview",
    "reason",
    "reassign",
    "reassure",
    "reattach",
    "reawake",
    "rebalance",
    "rebate",
    "rebel",
    "rebirth",
    "reboot",
    "reborn",
    "rebound",
    "rebuff",
    "rebuild",
    "rebuilt",
    "reburial",
    "rebuttal",
    "recall",
    "recant",
    "recapture",
    "recast",
    "recede",
    "recent",
    "recess",
    "recharger",
    "recipient",
    "recital",
    "recite",
    "reckless",
    "reclaim",
    "recliner",
    "reclining",
    "recluse",
    "reclusive",
    "recognize",
    "recoil",
    "recollect",
    "recolor",
    "reconcile",
    "reconfirm",
    "reconvene",
    "recopy",
    "record",
    "recount",
    "recoup",
    "recovery",
    "recreate",
    "rectal",
    "rectangle",
    "rectified",
    "rectify",
    "recycled",
    "recycler",
    "recycling",
    "reemerge",
    "reenact",
    "reenter",
    "reentry",
    "reexamine",
    "referable",
    "referee",
    "reference",
    "refill",
    "refinance",
    "refined",
    "refinery",
    "refining",
    "refinish",
    "reflected",
    "reflector",
    "reflex",
    "reflux",
    "refocus",
    "refold",
    "reforest",
    "reformat",
    "reformed",
    "reformer",
    "reformist",
    "refract",
    "refrain",
    "refreeze",
    "refresh",
    "refried",
    "refueling",
    "refund",
    "refurbish",
    "refurnish",
    "refusal",
    "refuse",
    "refusing",
    "refutable",
    "refute",
    "regain",
    "regalia",
    "regally",
    "reggae",
    "regime",
    "region",
    "register",
    "registrar",
    "registry",
    "regress",
    "regretful",
    "regroup",
    "regular",
    "regulate",
    "regulator",
    "rehab",
    "reheat",
    "rehire",
    "rehydrate",
    "reimburse",
    "reissue",
    "reiterate",
    "rejoice",
    "rejoicing",
    "rejoin",
    "rekindle",
    "relapse",
    "relapsing",
    "relatable",
    "related",
    "relation",
    "relative",
    "relax",
    "relay",
    "relearn",
    "release",
    "relenting",
    "reliable",
    "reliably",
    "reliance",
    "reliant",
    "relic",
    "relieve",
    "relieving",
    "relight",
    "relish",
    "relive",
    "reload",
    "relocate",
    "relock",
    "reluctant",
    "rely",
    "remake",
    "remark",
    "remarry",
    "rematch",
    "remedial",
    "remedy",
    "remember",
    "reminder",
    "remindful",
    "remission",
    "remix",
    "remnant",
    "remodeler",
    "remold",
    "remorse",
    "remote",
    "removable",
    "removal",
    "removed",
    "remover",
    "removing",
    "rename",
    "renderer",
    "rendering",
    "rendition",
    "renegade",
    "renewable",
    "renewably",
    "renewal",
    "renewed",
    "renounce",
    "renovate",
    "renovator",
    "rentable",
    "rental",
    "rented",
    "renter",
    "reoccupy",
    "reoccur",
    "reopen",
    "reorder",
    "repackage",
    "repacking",
    "repaint",
    "repair",
    "repave",
    "repaying",
    "repayment",
    "repeal",
    "repeated",
    "repeater",
    "repent",
    "rephrase",
    "replace",
    "replay",
    "replica",
    "reply",
    "reporter",
    "repose",
    "repossess",
    "repost",
    "repressed",
    "reprimand",
    "reprint",
    "reprise",
    "reproach",
    "reprocess",
    "reproduce",
    "reprogram",
    "reps",
    "reptile",
    "reptilian",
    "repugnant",
    "repulsion",
    "repulsive",
    "repurpose",
    "reputable",
    "reputably",
    "request",
    "require",
    "requisite",
    "reroute",
    "rerun",
    "resale",
    "resample",
    "rescuer",
    "reseal",
    "research",
    "reselect",
    "reseller",
    "resemble",
    "resend",
    "resent",
    "reset",
    "reshape",
    "reshoot",
    "reshuffle",
    "residence",
    "residency",
    "resident",
    "residual",
    "residue",
    "resigned",
    "resilient",
    "resistant",
    "resisting",
    "resize",
    "resolute",
    "resolved",
    "resonant",
    "resonate",
    "resort",
    "resource",
    "respect",
    "resubmit",
    "result",
    "resume",
    "resupply",
    "resurface",
    "resurrect",
    "retail",
    "retainer",
    "retaining",
    "retake",
    "retaliate",
    "retention",
    "rethink",
    "retinal",
    "retired",
    "retiree",
    "retiring",
    "retold",
    "retool",
    "retorted",
    "retouch",
    "retrace",
    "retract",
    "retrain",
    "retread",
    "retreat",
    "retrial",
    "retrieval",
    "retriever",
    "retry",
    "return",
    "retying",
    "retype",
    "reunion",
    "reunite",
    "reusable",
    "reuse",
    "reveal",
    "reveler",
    "revenge",
    "revenue",
    "reverb",
    "revered",
    "reverence",
    "reverend",
    "reversal",
    "reverse",
    "reversing",
    "reversion",
    "revert",
    "revisable",
    "revise",
    "revision",
    "revisit",
    "revivable",
    "revival",
    "reviver",
    "reviving",
    "revocable",
    "revoke",
    "revolt",
    "revolver",
    "revolving",
    "reward",
    "rewash",
    "rewind",
    "rewire",
    "reword",
    "rework",
    "rewrap",
    "rewrite",
    "rhyme",
    "ribbon",
    "ribcage",
    "rice",
    "riches",
    "richly",
    "richness",
    "rickety",
    "ricotta",
    "riddance",
    "ridden",
    "ride",
    "riding",
    "rifling",
    "rift",
    "rigging",
    "rigid",
    "rigor",
    "rimless",
    "rimmed",
    "rind",
    "rink",
    "rinse",
    "rinsing",
    "riot",
    "ripcord",
    "ripeness",
    "ripening",
    "ripping",
    "ripple",
    "rippling",
    "riptide",
    "rise",
    "rising",
    "risk",
    "risotto",
    "ritalin",
    "ritzy",
    "rival",
    "riverbank",
    "riverbed",
    "riverboat",
    "riverside",
    "riveter",
    "riveting",
    "roamer",
    "roaming",
    "roast",
    "robbing",
    "robe",
    "robin",
    "robotics",
    "robust",
    "rockband",
    "rocker",
    "rocket",
    "rockfish",
    "rockiness",
    "rocking",
    "rocklike",
    "rockslide",
    "rockstar",
    "rocky",
    "rogue",
    "roman",
    "romp",
    "rope",
    "roping",
    "roster",
    "rosy",
    "rotten",
    "rotting",
    "rotunda",
    "roulette",
    "rounding",
    "roundish",
    "roundness",
    "roundup",
    "roundworm",
    "routine",
    "routing",
    "rover",
    "roving",
    "royal",
    "rubbed",
    "rubber",
    "rubbing",
    "rubble",
    "rubdown",
    "ruby",
    "ruckus",
    "rudder",
    "rug",
    "ruined",
    "rule",
    "rumble",
    "rumbling",
    "rummage",
    "rumor",
    "runaround",
    "rundown",
    "runner",
    "running",
    "runny",
    "runt",
    "runway",
    "rupture",
    "rural",
    "ruse",
    "rush",
    "rust",
    "rut",
    "sabbath",
    "sabotage",
    "sacrament",
    "sacred",
    "sacrifice",
    "sadden",
    "saddlebag",
    "saddled",
    "saddling",
    "sadly",
    "sadness",
    "safari",
    "safeguard",
    "safehouse",
    "safely",
    "safeness",
    "saffron",
    "saga",
    "sage",
    "sagging",
    "saggy",
    "said",
    "saint",
    "sake",
    "salad",
    "salami",
    "salaried",
    "salary",
    "saline",
    "salon",
    "saloon",
    "salsa",
    "salt",
    "salutary",
    "salute",
    "salvage",
    "salvaging",
    "salvation",
    "same",
    "sample",
    "sampling",
    "sanction",
    "sanctity",
    "sanctuary",
    "sandal",
    "sandbag",
    "sandbank",
    "sandbar",
    "sandblast",
    "sandbox",
    "sanded",
    "sandfish",
    "sanding",
    "sandlot",
    "sandpaper",
    "sandpit",
    "sandstone",
    "sandstorm",
    "sandworm",
    "sandy",
    "sanitary",
    "sanitizer",
    "sank",
    "santa",
    "sapling",
    "sappiness",
    "sappy",
    "sarcasm",
    "sarcastic",
    "sardine",
    "sash",
    "sasquatch",
    "sassy",
    "satchel",
    "satiable",
    "satin",
    "satirical",
    "satisfied",
    "satisfy",
    "saturate",
    "saturday",
    "sauciness",
    "saucy",
    "sauna",
    "savage",
    "savanna",
    "saved",
    "savings",
    "savior",
    "savor",
    "saxophone",
    "say",
    "scabbed",
    "scabby",
    "scalded",
    "scalding",
    "scale",
    "scaling",
    "scallion",
    "scallop",
    "scalping",
    "scam",
    "scandal",
    "scanner",
    "scanning",
    "scant",
    "scapegoat",
    "scarce",
    "scarcity",
    "scarecrow",
    "scared",
    "scarf",
    "scarily",
    "scariness",
    "scarring",
    "scary",
    "scavenger",
    "scenic",
    "schedule",
    "schematic",
    "scheme",
    "scheming",
    "schilling",
    "schnapps",
    "scholar",
    "science",
    "scientist",
    "scion",
    "scoff",
    "scolding",
    "scone",
    "scoop",
    "scooter",
    "scope",
    "scorch",
    "scorebook",
    "scorecard",
    "scored",
    "scoreless",
    "scorer",
    "scoring",
    "scorn",
    "scorpion",
    "scotch",
    "scoundrel",
    "scoured",
    "scouring",
    "scouting",
    "scouts",
    "scowling",
    "scrabble",
    "scraggly",
    "scrambled",
    "scrambler",
    "scrap",
    "scratch",
    "scrawny",
    "screen",
    "scribble",
    "scribe",
    "scribing",
    "scrimmage",
    "script",
    "scroll",
    "scrooge",
    "scrounger",
    "scrubbed",
    "scrubber",
    "scruffy",
    "scrunch",
    "scrutiny",
    "scuba",
    "scuff",
    "sculptor",
    "sculpture",
    "scurvy",
    "scuttle",
    "secluded",
    "secluding",
    "seclusion",
    "second",
    "secrecy",
    "secret",
    "sectional",
    "sector",
    "secular",
    "securely",
    "security",
    "sedan",
    "sedate",
    "sedation",
    "sedative",
    "sediment",
    "seduce",
    "seducing",
    "segment",
    "seismic",
    "seizing",
    "seldom",
    "selected",
    "selection",
    "selective",
    "selector",
    "self",
    "seltzer",
    "semantic",
    "semester",
    "semicolon",
    "semifinal",
    "seminar",
    "semisoft",
    "semisweet",
    "senate",
    "senator",
    "send",
    "senior",
    "senorita",
    "sensation",
    "sensitive",
    "sensitize",
    "sensually",
    "sensuous",
    "sepia",
    "september",
    "septic",
    "septum",
    "sequel",
    "sequence",
    "sequester",
    "series",
    "sermon",
    "serotonin",
    "serpent",
    "serrated",
    "serve",
    "service",
    "serving",
    "sesame",
    "sessions",
    "setback",
    "setting",
    "settle",
    "settling",
    "setup",
    "sevenfold",
    "seventeen",
    "seventh",
    "seventy",
    "severity",
    "shabby",
    "shack",
    "shaded",
    "shadily",
    "shadiness",
    "shading",
    "shadow",
    "shady",
    "shaft",
    "shakable",
    "shakily",
    "shakiness",
    "shaking",
    "shaky",
    "shale",
    "shallot",
    "shallow",
    "shame",
    "shampoo",
    "shamrock",
    "shank",
    "shanty",
    "shape",
    "shaping",
    "share",
    "sharpener",
    "sharper",
    "sharpie",
    "sharply",
    "sharpness",
    "shawl",
    "sheath",
    "shed",
    "sheep",
    "sheet",
    "shelf",
    "shell",
    "shelter",
    "shelve",
    "shelving",
    "sherry",
    "shield",
    "shifter",
    "shifting",
    "shiftless",
    "shifty",
    "shimmer",
    "shimmy",
    "shindig",
    "shine",
    "shingle",
    "shininess",
    "shining",
    "shiny",
    "ship",
    "shirt",
    "shivering",
    "shock",
    "shone",
    "shoplift",
    "shopper",
    "shopping",
    "shoptalk",
    "shore",
    "shortage",
    "shortcake",
    "shortcut",
    "shorten",
    "shorter",
    "shorthand",
    "shortlist",
    "shortly",
    "shortness",
    "shorts",
    "shortwave",
    "shorty",
    "shout",
    "shove",
    "showbiz",
    "showcase",
    "showdown",
    "shower",
    "showgirl",
    "showing",
    "showman",
    "shown",
    "showoff",
    "showpiece",
    "showplace",
    "showroom",
    "showy",
    "shrank",
    "shrapnel",
    "shredder",
    "shredding",
    "shrewdly",
    "shriek",
    "shrill",
    "shrimp",
    "shrine",
    "shrink",
    "shrivel",
    "shrouded",
    "shrubbery",
    "shrubs",
    "shrug",
    "shrunk",
    "shucking",
    "shudder",
    "shuffle",
    "shuffling",
    "shun",
    "shush",
    "shut",
    "shy",
    "siamese",
    "siberian",
    "sibling",
    "siding",
    "sierra",
    "siesta",
    "sift",
    "sighing",
    "silenced",
    "silencer",
    "silent",
    "silica",
    "silicon",
    "silk",
    "silliness",
    "silly",
    "silo",
    "silt",
    "silver",
    "similarly",
    "simile",
    "simmering",
    "simple",
    "simplify",
    "simply",
    "sincere",
    "sincerity",
    "singer",
    "singing",
    "single",
    "singular",
    "sinister",
    "sinless",
    "sinner",
    "sinuous",
    "sip",
    "siren",
    "sister",
    "sitcom",
    "sitter",
    "sitting",
    "situated",
    "situation",
    "sixfold",
    "sixteen",
    "sixth",
    "sixties",
    "sixtieth",
    "sixtyfold",
    "sizable",
    "sizably",
    "size",
    "sizing",
    "sizzle",
    "sizzling",
    "skater",
    "skating",
    "skedaddle",
    "skeletal",
    "skeleton",
    "skeptic",
    "sketch",
    "skewed",
    "skewer",
    "skid",
    "skied",
    "skier",
    "skies",
    "skiing",
    "skilled",
    "skillet",
    "skillful",
    "skimmed",
    "skimmer",
    "skimming",
    "skimpily",
    "skincare",
    "skinhead",
    "skinless",
    "skinning",
    "skinny",
    "skintight",
    "skipper",
    "skipping",
    "skirmish",
    "skirt",
    "skittle",
    "skydiver",
    "skylight",
    "skyline",
    "skype",
    "skyrocket",
    "skyward",
    "slab",
    "slacked",
    "slacker",
    "slacking",
    "slackness",
    "slacks",
    "slain",
    "slam",
    "slander",
    "slang",
    "slapping",
    "slapstick",
    "slashed",
    "slashing",
    "slate",
    "slather",
    "slaw",
    "sled",
    "sleek",
    "sleep",
    "sleet",
    "sleeve",
    "slept",
    "sliceable",
    "sliced",
    "slicer",
    "slicing",
    "slick",
    "slider",
    "slideshow",
    "sliding",
    "slighted",
    "slighting",
    "slightly",
    "slimness",
    "slimy",
    "slinging",
    "slingshot",
    "slinky",
    "slip",
    "slit",
    "sliver",
    "slobbery",
    "slogan",
    "sloped",
    "sloping",
    "sloppily",
    "sloppy",
    "slot",
    "slouching",
    "slouchy",
    "sludge",
    "slug",
    "slum",
    "slurp",
    "slush",
    "sly",
    "small",
    "smartly",
    "smartness",
    "smasher",
    "smashing",
    "smashup",
    "smell",
    "smelting",
    "smile",
    "smilingly",
    "smirk",
    "smite",
    "smith",
    "smitten",
    "smock",
    "smog",
    "smoked",
    "smokeless",
    "smokiness",
    "smoking",
    "smoky",
    "smolder",
    "smooth",
    "smother",
    "smudge",
    "smudgy",
    "smuggler",
    "smuggling",
    "smugly",
    "smugness",
    "snack",
    "snagged",
    "snaking",
    "snap",
    "snare",
    "snarl",
    "snazzy",
    "sneak",
    "sneer",
    "sneeze",
    "sneezing",
    "snide",
    "sniff",
    "snippet",
    "snipping",
    "snitch",
    "snooper",
    "snooze",
    "snore",
    "snoring",
    "snorkel",
    "snort",
    "snout",
    "snowbird",
    "snowboard",
    "snowbound",
    "snowcap",
    "snowdrift",
    "snowdrop",
    "snowfall",
    "snowfield",
    "snowflake",
    "snowiness",
    "snowless",
    "snowman",
    "snowplow",
    "snowshoe",
    "snowstorm",
    "snowsuit",
    "snowy",
    "snub",
    "snuff",
    "snuggle",
    "snugly",
    "snugness",
    "speak",
    "spearfish",
    "spearhead",
    "spearman",
    "spearmint",
    "species",
    "specimen",
    "specked",
    "speckled",
    "specks",
    "spectacle",
    "spectator",
    "spectrum",
    "speculate",
    "speech",
    "speed",
    "spellbind",
    "speller",
    "spelling",
    "spendable",
    "spender",
    "spending",
    "spent",
    "spew",
    "sphere",
    "spherical",
    "sphinx",
    "spider",
    "spied",
    "spiffy",
    "spill",
    "spilt",
    "spinach",
    "spinal",
    "spindle",
    "spinner",
    "spinning",
    "spinout",
    "spinster",
    "spiny",
    "spiral",
    "spirited",
    "spiritism",
    "spirits",
    "spiritual",
    "splashed",
    "splashing",
    "splashy",
    "splatter",
    "spleen",
    "splendid",
    "splendor",
    "splice",
    "splicing",
    "splinter",
    "splotchy",
    "splurge",
    "spoilage",
    "spoiled",
    "spoiler",
    "spoiling",
    "spoils",
    "spoken",
    "spokesman",
    "sponge",
    "spongy",
    "sponsor",
    "spoof",
    "spookily",
    "spooky",
    "spool",
    "spoon",
    "spore",
    "sporting",
    "sports",
    "sporty",
    "spotless",
    "spotlight",
    "spotted",
    "spotter",
    "spotting",
    "spotty",
    "spousal",
    "spouse",
    "spout",
    "sprain",
    "sprang",
    "sprawl",
    "spray",
    "spree",
    "sprig",
    "spring",
    "sprinkled",
    "sprinkler",
    "sprint",
    "sprite",
    "sprout",
    "spruce",
    "sprung",
    "spry",
    "spud",
    "spur",
    "sputter",
    "spyglass",
    "squabble",
    "squad",
    "squall",
    "squander",
    "squash",
    "squatted",
    "squatter",
    "squatting",
    "squeak",
    "squealer",
    "squealing",
    "squeamish",
    "squeegee",
    "squeeze",
    "squeezing",
    "squid",
    "squiggle",
    "squiggly",
    "squint",
    "squire",
    "squirt",
    "squishier",
    "squishy",
    "stability",
    "stabilize",
    "stable",
    "stack",
    "stadium",
    "staff",
    "stage",
    "staging",
    "stagnant",
    "stagnate",
    "stainable",
    "stained",
    "staining",
    "stainless",
    "stalemate",
    "staleness",
    "stalling",
    "stallion",
    "stamina",
    "stammer",
    "stamp",
    "stand",
    "stank",
    "staple",
    "stapling",
    "starboard",
    "starch",
    "stardom",
    "stardust",
    "starfish",
    "stargazer",
    "staring",
    "stark",
    "starless",
    "starlet",
    "starlight",
    "starlit",
    "starring",
    "starry",
    "starship",
    "starter",
    "starting",
    "startle",
    "startling",
    "startup",
    "starved",
    "starving",
    "stash",
    "state",
    "static",
    "statistic",
    "statue",
    "stature",
    "status",
    "statute",
    "statutory",
    "staunch",
    "stays",
    "steadfast",
    "steadier",
    "steadily",
    "steadying",
    "steam",
    "steed",
    "steep",
    "steerable",
    "steering",
    "steersman",
    "stegosaur",
    "stellar",
    "stem",
    "stench",
    "stencil",
    "step",
    "stereo",
    "sterile",
    "sterility",
    "sterilize",
    "sterling",
    "sternness",
    "sternum",
    "stew",
    "stick",
    "stiffen",
    "stiffly",
    "stiffness",
    "stifle",
    "stifling",
    "stillness",
    "stilt",
    "stimulant",
    "stimulate",
    "stimuli",
    "stimulus",
    "stinger",
    "stingily",
    "stinging",
    "stingray",
    "stingy",
    "stinking",
    "stinky",
    "stipend",
    "stipulate",
    "stir",
    "stitch",
    "stock",
    "stoic",
    "stoke",
    "stole",
    "stomp",
    "stonewall",
    "stoneware",
    "stonework",
    "stoning",
    "stony",
    "stood",
    "stooge",
    "stool",
    "stoop",
    "stoplight",
    "stoppable",
    "stoppage",
    "stopped",
    "stopper",
    "stopping",
    "stopwatch",
    "storable",
    "storage",
    "storeroom",
    "storewide",
    "storm",
    "stout",
    "stove",
    "stowaway",
    "stowing",
    "straddle",
    "straggler",
    "strained",
    "strainer",
    "straining",
    "strangely",
    "stranger",
    "strangle",
    "strategic",
    "strategy",
    "stratus",
    "straw",
    "stray",
    "streak",
    "stream",
    "street",
    "strength",
    "strenuous",
    "strep",
    "stress",
    "stretch",
    "strewn",
    "stricken",
    "strict",
    "stride",
    "strife",
    "strike",
    "striking",
    "strive",
    "striving",
    "strobe",
    "strode",
    "stroller",
    "strongbox",
    "strongly",
    "strongman",
    "struck",
    "structure",
    "strudel",
    "struggle",
    "strum",
    "strung",
    "strut",
    "stubbed",
    "stubble",
    "stubbly",
    "stubborn",
    "stucco",
    "stuck",
    "student",
    "studied",
    "studio",
    "study",
    "stuffed",
    "stuffing",
    "stuffy",
    "stumble",
    "stumbling",
    "stump",
    "stung",
    "stunned",
    "stunner",
    "stunning",
    "stunt",
    "stupor",
    "sturdily",
    "sturdy",
    "styling",
    "stylishly",
    "stylist",
    "stylized",
    "stylus",
    "suave",
    "subarctic",
    "subatomic",
    "subdivide",
    "subdued",
    "subduing",
    "subfloor",
    "subgroup",
    "subheader",
    "subject",
    "sublease",
    "sublet",
    "sublevel",
    "sublime",
    "submarine",
    "submerge",
    "submersed",
    "submitter",
    "subpanel",
    "subpar",
    "subplot",
    "subprime",
    "subscribe",
    "subscript",
    "subsector",
    "subside",
    "subsiding",
    "subsidize",
    "subsidy",
    "subsoil",
    "subsonic",
    "substance",
    "subsystem",
    "subtext",
    "subtitle",
    "subtly",
    "subtotal",
    "subtract",
    "subtype",
    "suburb",
    "subway",
    "subwoofer",
    "subzero",
    "succulent",
    "such",
    "suction",
    "sudden",
    "sudoku",
    "suds",
    "sufferer",
    "suffering",
    "suffice",
    "suffix",
    "suffocate",
    "suffrage",
    "sugar",
    "suggest",
    "suing",
    "suitable",
    "suitably",
    "suitcase",
    "suitor",
    "sulfate",
    "sulfide",
    "sulfite",
    "sulfur",
    "sulk",
    "sullen",
    "sulphate",
    "sulphuric",
    "sultry",
    "superbowl",
    "superglue",
    "superhero",
    "superior",
    "superjet",
    "superman",
    "supermom",
    "supernova",
    "supervise",
    "supper",
    "supplier",
    "supply",
    "support",
    "supremacy",
    "supreme",
    "surcharge",
    "surely",
    "sureness",
    "surface",
    "surfacing",
    "surfboard",
    "surfer",
    "surgery",
    "surgical",
    "surging",
    "surname",
    "surpass",
    "surplus",
    "surprise",
    "surreal",
    "surrender",
    "surrogate",
    "surround",
    "survey",
    "survival",
    "survive",
    "surviving",
    "survivor",
    "sushi",
    "suspect",
    "suspend",
    "suspense",
    "sustained",
    "sustainer",
    "swab",
    "swaddling",
    "swagger",
    "swampland",
    "swan",
    "swapping",
    "swarm",
    "sway",
    "swear",
    "sweat",
    "sweep",
    "swell",
    "swept",
    "swerve",
    "swifter",
    "swiftly",
    "swiftness",
    "swimmable",
    "swimmer",
    "swimming",
    "swimsuit",
    "swimwear",
    "swinger",
    "swinging",
    "swipe",
    "swirl",
    "switch",
    "swivel",
    "swizzle",
    "swooned",
    "swoop",
    "swoosh",
    "swore",
    "sworn",
    "swung",
    "sycamore",
    "sympathy",
    "symphonic",
    "symphony",
    "symptom",
    "synapse",
    "syndrome",
    "synergy",
    "synopses",
    "synopsis",
    "synthesis",
    "synthetic",
    "syrup",
    "system",
    "t-shirt",
    "tabasco",
    "tabby",
    "tableful",
    "tables",
    "tablet",
    "tableware",
    "tabloid",
    "tackiness",
    "tacking",
    "tackle",
    "tackling",
    "tacky",
    "taco",
    "tactful",
    "tactical",
    "tactics",
    "tactile",
    "tactless",
    "tadpole",
    "taekwondo",
    "tag",
    "tainted",
    "take",
    "taking",
    "talcum",
    "talisman",
    "tall",
    "talon",
    "tamale",
    "tameness",
    "tamer",
    "tamper",
    "tank",
    "tanned",
    "tannery",
    "tanning",
    "tantrum",
    "tapeless",
    "tapered",
    "tapering",
    "tapestry",
    "tapioca",
    "tapping",
    "taps",
    "tarantula",
    "target",
    "tarmac",
    "tarnish",
    "tarot",
    "tartar",
    "tartly",
    "tartness",
    "task",
    "tassel",
    "taste",
    "tastiness",
    "tasting",
    "tasty",
    "tattered",
    "tattle",
    "tattling",
    "tattoo",
    "taunt",
    "tavern",
    "thank",
    "that",
    "thaw",
    "theater",
    "theatrics",
    "thee",
    "theft",
    "theme",
    "theology",
    "theorize",
    "thermal",
    "thermos",
    "thesaurus",
    "these",
    "thesis",
    "thespian",
    "thicken",
    "thicket",
    "thickness",
    "thieving",
    "thievish",
    "thigh",
    "thimble",
    "thing",
    "think",
    "thinly",
    "thinner",
    "thinness",
    "thinning",
    "thirstily",
    "thirsting",
    "thirsty",
    "thirteen",
    "thirty",
    "thong",
    "thorn",
    "those",
    "thousand",
    "thrash",
    "thread",
    "threaten",
    "threefold",
    "thrift",
    "thrill",
    "thrive",
    "thriving",
    "throat",
    "throbbing",
    "throng",
    "throttle",
    "throwaway",
    "throwback",
    "thrower",
    "throwing",
    "thud",
    "thumb",
    "thumping",
    "thursday",
    "thus",
    "thwarting",
    "thyself",
    "tiara",
    "tibia",
    "tidal",
    "tidbit",
    "tidiness",
    "tidings",
    "tidy",
    "tiger",
    "tighten",
    "tightly",
    "tightness",
    "tightrope",
    "tightwad",
    "tigress",
    "tile",
    "tiling",
    "till",
    "tilt",
    "timid",
    "timing",
    "timothy",
    "tinderbox",
    "tinfoil",
    "tingle",
    "tingling",
    "tingly",
    "tinker",
    "tinkling",
    "tinsel",
    "tinsmith",
    "tint",
    "tinwork",
    "tiny",
    "tipoff",
    "tipped",
    "tipper",
    "tipping",
    "tiptoeing",
    "tiptop",
    "tiring",
    "tissue",
    "trace",
    "tracing",
    "track",
    "traction",
    "tractor",
    "trade",
    "trading",
    "tradition",
    "traffic",
    "tragedy",
    "trailing",
    "trailside",
    "train",
    "traitor",
    "trance",
    "tranquil",
    "transfer",
    "transform",
    "translate",
    "transpire",
    "transport",
    "transpose",
    "trapdoor",
    "trapeze",
    "trapezoid",
    "trapped",
    "trapper",
    "trapping",
    "traps",
    "trash",
    "travel",
    "traverse",
    "travesty",
    "tray",
    "treachery",
    "treading",
    "treadmill",
    "treason",
    "treat",
    "treble",
    "tree",
    "trekker",
    "tremble",
    "trembling",
    "tremor",
    "trench",
    "trend",
    "trespass",
    "triage",
    "trial",
    "triangle",
    "tribesman",
    "tribunal",
    "tribune",
    "tributary",
    "tribute",
    "triceps",
    "trickery",
    "trickily",
    "tricking",
    "trickle",
    "trickster",
    "tricky",
    "tricolor",
    "tricycle",
    "trident",
    "tried",
    "trifle",
    "trifocals",
    "trillion",
    "trilogy",
    "trimester",
    "trimmer",
    "trimming",
    "trimness",
    "trinity",
    "trio",
    "tripod",
    "tripping",
    "triumph",
    "trivial",
    "trodden",
    "trolling",
    "trombone",
    "trophy",
    "tropical",
    "tropics",
    "trouble",
    "troubling",
    "trough",
    "trousers",
    "trout",
    "trowel",
    "truce",
    "truck",
    "truffle",
    "trump",
    "trunks",
    "trustable",
    "trustee",
    "trustful",
    "trusting",
    "trustless",
    "truth",
    "try",
    "tubby",
    "tubeless",
    "tubular",
    "tucking",
    "tuesday",
    "tug",
    "tuition",
    "tulip",
    "tumble",
    "tumbling",
    "tummy",
    "turban",
    "turbine",
    "turbofan",
    "turbojet",
    "turbulent",
    "turf",
    "turkey",
    "turmoil",
    "turret",
    "turtle",
    "tusk",
    "tutor",
    "tutu",
    "tux",
    "tweak",
    "tweed",
    "tweet",
    "tweezers",
    "twelve",
    "twentieth",
    "twenty",
    "twerp",
    "twice",
    "twiddle",
    "twiddling",
    "twig",
    "twilight",
    "twine",
    "twins",
    "twirl",
    "twistable",
    "twisted",
    "twister",
    "twisting",
    "twisty",
    "twitch",
    "twitter",
    "tycoon",
    "tying",
    "tyke",
    "udder",
    "ultimate",
    "ultimatum",
    "ultra",
    "umbilical",
    "umbrella",
    "umpire",
    "unabashed",
    "unable",
    "unadorned",
    "unadvised",
    "unafraid",
    "unaired",
    "unaligned",
    "unaltered",
    "unarmored",
    "unashamed",
    "unaudited",
    "unawake",
    "unaware",
    "unbaked",
    "unbalance",
    "unbeaten",
    "unbend",
    "unbent",
    "unbiased",
    "unbitten",
    "unblended",
    "unblessed",
    "unblock",
    "unbolted",
    "unbounded",
    "unboxed",
    "unbraided",
    "unbridle",
    "unbroken",
    "unbuckled",
    "unbundle",
    "unburned",
    "unbutton",
    "uncanny",
    "uncapped",
    "uncaring",
    "uncertain",
    "unchain",
    "unchanged",
    "uncharted",
    "uncheck",
    "uncivil",
    "unclad",
    "unclaimed",
    "unclamped",
    "unclasp",
    "uncle",
    "unclip",
    "uncloak",
    "unclog",
    "unclothed",
    "uncoated",
    "uncoiled",
    "uncolored",
    "uncombed",
    "uncommon",
    "uncooked",
    "uncork",
    "uncorrupt",
    "uncounted",
    "uncouple",
    "uncouth",
    "uncover",
    "uncross",
    "uncrown",
    "uncrushed",
    "uncured",
    "uncurious",
    "uncurled",
    "uncut",
    "undamaged",
    "undated",
    "undaunted",
    "undead",
    "undecided",
    "undefined",
    "underage",
    "underarm",
    "undercoat",
    "undercook",
    "undercut",
    "underdog",
    "underdone",
    "underfed",
    "underfeed",
    "underfoot",
    "undergo",
    "undergrad",
    "underhand",
    "underline",
    "underling",
    "undermine",
    "undermost",
    "underpaid",
    "underpass",
    "underpay",
    "underrate",
    "undertake",
    "undertone",
    "undertook",
    "undertow",
    "underuse",
    "underwear",
    "underwent",
    "underwire",
    "undesired",
    "undiluted",
    "undivided",
    "undocked",
    "undoing",
    "undone",
    "undrafted",
    "undress",
    "undrilled",
    "undusted",
    "undying",
    "unearned",
    "unearth",
    "unease",
    "uneasily",
    "uneasy",
    "uneatable",
    "uneaten",
    "unedited",
    "unelected",
    "unending",
    "unengaged",
    "unenvied",
    "unequal",
    "unethical",
    "uneven",
    "unexpired",
    "unexposed",
    "unfailing",
    "unfair",
    "unfasten",
    "unfazed",
    "unfeeling",
    "unfiled",
    "unfilled",
    "unfitted",
    "unfitting",
    "unfixable",
    "unfixed",
    "unflawed",
    "unfocused",
    "unfold",
    "unfounded",
    "unframed",
    "unfreeze",
    "unfrosted",
    "unfrozen",
    "unfunded",
    "unglazed",
    "ungloved",
    "unglue",
    "ungodly",
    "ungraded",
    "ungreased",
    "unguarded",
    "unguided",
    "unhappily",
    "unhappy",
    "unharmed",
    "unhealthy",
    "unheard",
    "unhearing",
    "unheated",
    "unhelpful",
    "unhidden",
    "unhinge",
    "unhitched",
    "unholy",
    "unhook",
    "unicorn",
    "unicycle",
    "unified",
    "unifier",
    "uniformed",
    "uniformly",
    "unify",
    "unimpeded",
    "uninjured",
    "uninstall",
    "uninsured",
    "uninvited",
    "union",
    "uniquely",
    "unisexual",
    "unison",
    "unissued",
    "unit",
    "universal",
    "universe",
    "unjustly",
    "unkempt",
    "unkind",
    "unknotted",
    "unknowing",
    "unknown",
    "unlaced",
    "unlatch",
    "unlawful",
    "unleaded",
    "unlearned",
    "unleash",
    "unless",
    "unleveled",
    "unlighted",
    "unlikable",
    "unlimited",
    "unlined",
    "unlinked",
    "unlisted",
    "unlit",
    "unlivable",
    "unloaded",
    "unloader",
    "unlocked",
    "unlocking",
    "unlovable",
    "unloved",
    "unlovely",
    "unloving",
    "unluckily",
    "unlucky",
    "unmade",
    "unmanaged",
    "unmanned",
    "unmapped",
    "unmarked",
    "unmasked",
    "unmasking",
    "unmatched",
    "unmindful",
    "unmixable",
    "unmixed",
    "unmolded",
    "unmoral",
    "unmovable",
    "unmoved",
    "unmoving",
    "unnamable",
    "unnamed",
    "unnatural",
    "unneeded",
    "unnerve",
    "unnerving",
    "unnoticed",
    "unopened",
    "unopposed",
    "unpack",
    "unpadded",
    "unpaid",
    "unpainted",
    "unpaired",
    "unpaved",
    "unpeeled",
    "unpicked",
    "unpiloted",
    "unpinned",
    "unplanned",
    "unplanted",
    "unpleased",
    "unpledged",
    "unplowed",
    "unplug",
    "unpopular",
    "unproven",
    "unquote",
    "unranked",
    "unrated",
    "unraveled",
    "unreached",
    "unread",
    "unreal",
    "unreeling",
    "unrefined",
    "unrelated",
    "unrented",
    "unrest",
    "unretired",
    "unrevised",
    "unrigged",
    "unripe",
    "unrivaled",
    "unroasted",
    "unrobed",
    "unroll",
    "unruffled",
    "unruly",
    "unrushed",
    "unsaddle",
    "unsafe",
    "unsaid",
    "unsalted",
    "unsaved",
    "unsavory",
    "unscathed",
    "unscented",
    "unscrew",
    "unsealed",
    "unseated",
    "unsecured",
    "unseeing",
    "unseemly",
    "unseen",
    "unselect",
    "unselfish",
    "unsent",
    "unsettled",
    "unshackle",
    "unshaken",
    "unshaved",
    "unshaven",
    "unsheathe",
    "unshipped",
    "unsightly",
    "unsigned",
    "unskilled",
    "unsliced",
    "unsmooth",
    "unsnap",
    "unsocial",
    "unsoiled",
    "unsold",
    "unsolved",
    "unsorted",
    "unspoiled",
    "unspoken",
    "unstable",
    "unstaffed",
    "unstamped",
    "unsteady",
    "unsterile",
    "unstirred",
    "unstitch",
    "unstopped",
    "unstuck",
    "unstuffed",
    "unstylish",
    "unsubtle",
    "unsubtly",
    "unsuited",
    "unsure",
    "unsworn",
    "untagged",
    "untainted",
    "untaken",
    "untamed",
    "untangled",
    "untapped",
    "untaxed",
    "unthawed",
    "unthread",
    "untidy",
    "untie",
    "until",
    "untimed",
    "untimely",
    "untitled",
    "untoasted",
    "untold",
    "untouched",
    "untracked",
    "untrained",
    "untreated",
    "untried",
    "untrimmed",
    "untrue",
    "untruth",
    "unturned",
    "untwist",
    "untying",
    "unusable",
    "unused",
    "unusual",
    "unvalued",
    "unvaried",
    "unvarying",
    "unveiled",
    "unveiling",
    "unvented",
    "unviable",
    "unvisited",
    "unvocal",
    "unwanted",
    "unwarlike",
    "unwary",
    "unwashed",
    "unwatched",
    "unweave",
    "unwed",
    "unwelcome",
    "unwell",
    "unwieldy",
    "unwilling",
    "unwind",
    "unwired",
    "unwitting",
    "unwomanly",
    "unworldly",
    "unworn",
    "unworried",
    "unworthy",
    "unwound",
    "unwoven",
    "unwrapped",
    "unwritten",
    "unzip",
    "upbeat",
    "upchuck",
    "upcoming",
    "upcountry",
    "update",
    "upfront",
    "upgrade",
    "upheaval",
    "upheld",
    "uphill",
    "uphold",
    "uplifted",
    "uplifting",
    "upload",
    "upon",
    "upper",
    "upright",
    "uprising",
    "upriver",
    "uproar",
    "uproot",
    "upscale",
    "upside",
    "upstage",
    "upstairs",
    "upstart",
    "upstate",
    "upstream",
    "upstroke",
    "upswing",
    "uptake",
    "uptight",
    "uptown",
    "upturned",
    "upward",
    "upwind",
    "uranium",
    "urban",
    "urchin",
    "urethane",
    "urgency",
    "urgent",
    "urging",
    "urologist",
    "urology",
    "usable",
    "usage",
    "useable",
    "used",
    "uselessly",
    "user",
    "usher",
    "usual",
    "utensil",
    "utility",
    "utilize",
    "utmost",
    "utopia",
    "utter",
    "vacancy",
    "vacant",
    "vacate",
    "vacation",
    "vagabond",
    "vagrancy",
    "vagrantly",
    "vaguely",
    "vagueness",
    "valiant",
    "valid",
    "valium",
    "valley",
    "valuables",
    "value",
    "vanilla",
    "vanish",
    "vanity",
    "vanquish",
    "vantage",
    "vaporizer",
    "variable",
    "variably",
    "varied",
    "variety",
    "various",
    "varmint",
    "varnish",
    "varsity",
    "varying",
    "vascular",
    "vaseline",
    "vastly",
    "vastness",
    "veal",
    "vegan",
    "veggie",
    "vehicular",
    "velcro",
    "velocity",
    "velvet",
    "vendetta",
    "vending",
    "vendor",
    "veneering",
    "vengeful",
    "venomous",
    "ventricle",
    "venture",
    "venue",
    "venus",
    "verbalize",
    "verbally",
    "verbose",
    "verdict",
    "verify",
    "verse",
    "version",
    "versus",
    "vertebrae",
    "vertical",
    "vertigo",
    "very",
    "vessel",
    "vest",
    "veteran",
    "veto",
    "vexingly",
    "viability",
    "viable",
    "vibes",
    "vice",
    "vicinity",
    "victory",
    "video",
    "viewable",
    "viewer",
    "viewing",
    "viewless",
    "viewpoint",
    "vigorous",
    "village",
    "villain",
    "vindicate",
    "vineyard",
    "vintage",
    "violate",
    "violation",
    "violator",
    "violet",
    "violin",
    "viper",
    "viral",
    "virtual",
    "virtuous",
    "virus",
    "visa",
    "viscosity",
    "viscous",
    "viselike",
    "visible",
    "visibly",
    "vision",
    "visiting",
    "visitor",
    "visor",
    "vista",
    "vitality",
    "vitalize",
    "vitally",
    "vitamins",
    "vivacious",
    "vividly",
    "vividness",
    "vixen",
    "vocalist",
    "vocalize",
    "vocally",
    "vocation",
    "voice",
    "voicing",
    "void",
    "volatile",
    "volley",
    "voltage",
    "volumes",
    "voter",
    "voting",
    "voucher",
    "vowed",
    "vowel",
    "voyage",
    "wackiness",
    "wad",
    "wafer",
    "waffle",
    "waged",
    "wager",
    "wages",
    "waggle",
    "wagon",
    "wake",
    "waking",
    "walk",
    "walmart",
    "walnut",
    "walrus",
    "waltz",
    "wand",
    "wannabe",
    "wanted",
    "wanting",
    "wasabi",
    "washable",
    "washbasin",
    "washboard",
    "washbowl",
    "washcloth",
    "washday",
    "washed",
    "washer",
    "washhouse",
    "washing",
    "washout",
    "washroom",
    "washstand",
    "washtub",
    "wasp",
    "wasting",
    "watch",
    "water",
    "waviness",
    "waving",
    "wavy",
    "whacking",
    "whacky",
    "wham",
    "wharf",
    "wheat",
    "whenever",
    "whiff",
    "whimsical",
    "whinny",
    "whiny",
    "whisking",
    "whoever",
    "whole",
    "whomever",
    "whoopee",
    "whooping",
    "whoops",
    "why",
    "wick",
    "widely",
    "widen",
    "widget",
    "widow",
    "width",
    "wieldable",
    "wielder",
    "wife",
    "wifi",
    "wikipedia",
    "wildcard",
    "wildcat",
    "wilder",
    "wildfire",
    "wildfowl",
    "wildland",
    "wildlife",
    "wildly",
    "wildness",
    "willed",
    "willfully",
    "willing",
    "willow",
    "willpower",
    "wilt",
    "wimp",
    "wince",
    "wincing",
    "wind",
    "wing",
    "winking",
    "winner",
    "winnings",
    "winter",
    "wipe",
    "wired",
    "wireless",
    "wiring",
    "wiry",
    "wisdom",
    "wise",
    "wish",
    "wisplike",
    "wispy",
    "wistful",
    "wizard",
    "wobble",
    "wobbling",
    "wobbly",
    "wok",
    "wolf",
    "wolverine",
    "womanhood",
    "womankind",
    "womanless",
    "womanlike",
    "womanly",
    "womb",
    "woof",
    "wooing",
    "wool",
    "woozy",
    "word",
    "work",
    "worried",
    "worrier",
    "worrisome",
    "worry",
    "worsening",
    "worshiper",
    "worst",
    "wound",
    "woven",
    "wow",
    "wrangle",
    "wrath",
    "wreath",
    "wreckage",
    "wrecker",
    "wrecking",
    "wrench",
    "wriggle",
    "wriggly",
    "wrinkle",
    "wrinkly",
    "wrist",
    "writing",
    "written",
    "wrongdoer",
    "wronged",
    "wrongful",
    "wrongly",
    "wrongness",
    "wrought",
    "xbox",
    "xerox",
    "yahoo",
    "yam",
    "yanking",
    "yapping",
    "yard",
    "yarn",
    "yeah",
    "yearbook",
    "yearling",
    "yearly",
    "yearning",
    "yeast",
    "yelling",
    "yelp",
    "yen",
    "yesterday",
    "yiddish",
    "yield",
    "yin",
    "yippee",
    "yo-yo",
    "yodel",
    "yoga",
    "yogurt",
    "yonder",
    "yoyo",
    "yummy",
    "zap",
    "zealous",
    "zebra",
    "zen",
    "zeppelin",
    "zero",
    "zestfully",
    "zesty",
    "zigzagged",
    "zipfile",
    "zipping",
    "zippy",
    "zips",
    "zit",
    "zodiac",
    "zombie",
    "zone",
    "zoning",
    "zookeeper",
    "zoologist",
    "zoology",
    "zoom",
];

;// ../../libs/tools/generator/core/src/types/generated-credential.ts
/** A credential generation result */
class generated_credential_GeneratedCredential {
    /**
     * Instantiates a generated credential
     * @param credential The value of the generated credential (e.g. a password)
     * @param category The kind of credential
     * @param generationDate The date that the credential was generated.
     *   Numeric values should are interpreted using {@link Date.valueOf}
     *   semantics.
     * @param source traces the origin of the request that generated this credential.
     * @param website traces the website associated with the generated credential.
     */
    constructor(credential, category, generationDate, source, website) {
        this.credential = credential;
        this.category = category;
        this.source = source;
        this.website = website;
        if (typeof generationDate === "number") {
            this.generationDate = new Date(generationDate);
        }
        else {
            this.generationDate = generationDate;
        }
    }
    /** Constructs a credential from its `toJSON` representation */
    static fromJSON(jsonValue) {
        return new generated_credential_GeneratedCredential(jsonValue.credential, jsonValue.category, jsonValue.generationDate);
    }
    /** Serializes a credential to a JSON-compatible object */
    toJSON() {
        // omits the source and website because they were introduced to solve
        // UI bugs and it's not yet known whether there's a desire to support
        // them in the generator history view.
        return {
            credential: this.credential,
            category: this.category,
            generationDate: this.generationDate.valueOf(),
        };
    }
}

;// ../../libs/tools/generator/core/src/data/generator-types.ts
/** Types of passwords that may be generated by the credential generator */
const generator_types_PasswordAlgorithms = Object.freeze(["password", "passphrase"]);
/** Types of usernames that may be generated by the credential generator */
const generator_types_UsernameAlgorithms = Object.freeze(["username"]);
/** Types of email addresses that may be generated by the credential generator */
const generator_types_EmailAlgorithms = Object.freeze(["catchall", "subaddress"]);
/** All types of credentials that may be generated by the credential generator */
const CredentialAlgorithms = Object.freeze([
    ...generator_types_PasswordAlgorithms,
    ...generator_types_UsernameAlgorithms,
    ...generator_types_EmailAlgorithms,
]);

;// ../../libs/tools/generator/core/src/types/generator-type.ts

/** Returns true when the input algorithm is a forwarder integration. */
function generator_type_isForwarderIntegration(algorithm) {
    return algorithm && typeof algorithm === "object" && "forwarder" in algorithm;
}
function isSameAlgorithm(lhs, rhs) {
    if (lhs === rhs) {
        return true;
    }
    else if (generator_type_isForwarderIntegration(lhs) && generator_type_isForwarderIntegration(rhs)) {
        return lhs.forwarder === rhs.forwarder;
    }
    else {
        return false;
    }
}
/** Compound credential types supported by the credential generator. */
const generator_type_CredentialCategories = Object.freeze({
    /** Lists algorithms in the "password" credential category */
    password: generator_types_PasswordAlgorithms,
    /** Lists algorithms in the "username" credential category */
    username: generator_types_UsernameAlgorithms,
    /** Lists algorithms in the "email" credential category */
    email: generator_types_EmailAlgorithms,
});
/** Returns true when the input algorithm is a password algorithm. */
function isPasswordAlgorithm(algorithm) {
    return PasswordAlgorithms.includes(algorithm);
}
/** Returns true when the input algorithm is a username algorithm. */
function isUsernameAlgorithm(algorithm) {
    return UsernameAlgorithms.includes(algorithm);
}
/** Returns true when the input algorithm is an email algorithm. */
function isEmailAlgorithm(algorithm) {
    return EmailAlgorithms.includes(algorithm) || generator_type_isForwarderIntegration(algorithm);
}

;// ../../libs/tools/generator/core/src/types/index.ts




















;// ../../libs/tools/generator/core/src/engine/data.ts
function toCharacterSet(characters) {
    const set = characters.split("");
    return Object.freeze(set);
}
const SpecialCharacters = toCharacterSet("!@#$%^&*");
/** Sets of Ascii characters used for password generation */
const Ascii = Object.freeze({
    /** The full set of characters available to the generator */
    Full: Object.freeze({
        Uppercase: toCharacterSet("ABCDEFGHIJKLMNOPQRSTUVWXYZ"),
        Lowercase: toCharacterSet("abcdefghijklmnopqrstuvwxyz"),
        Digit: toCharacterSet("0123456789"),
        Special: SpecialCharacters,
    }),
    /** All characters available to the generator that are not ambiguous. */
    Unmistakable: Object.freeze({
        Uppercase: toCharacterSet("ABCDEFGHJKLMNPQRSTUVWXYZ"),
        Lowercase: toCharacterSet("abcdefghijkmnopqrstuvwxyz"),
        Digit: toCharacterSet("23456789"),
        Special: SpecialCharacters,
    }),
});
/** Splits an email into a username, subaddress, and domain named group.
 * Subaddress is optional.
 */
const SUBADDRESS_PARSER = new RegExp("(?<username>[^@+]+)(?<subaddress>\\+.+)?(?<domain>@.+)");

;// ../../libs/tools/generator/core/src/engine/email-randomizer.ts
var email_randomizer_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore



/** Generation algorithms that produce randomized email addresses */
class EmailRandomizer {
    /** Instantiates the email randomizer
     *  @param random data source for random data
     */
    constructor(random) {
        this.random = random;
    }
    /** Appends a random set of characters as a subaddress
     *  @param email the email address used to generate a subaddress. If this address
     *    already contains a subaddress, the subaddress is extended.
     *  @param options.length the number of characters to append to the subaddress. Defaults to 8. If
     *    the length is <= 0, the function returns the input address.
     *  @returns a promise that resolves with the generated email address. If the provided address
     *    lacks a username (the part before the "@") or domain (the part after the "@"), the function
     *    returns the input address.
     */
    randomAsciiSubaddress(email, options) {
        return email_randomizer_awaiter(this, void 0, void 0, function* () {
            var _a, _b;
            let result = email !== null && email !== void 0 ? email : "";
            const subaddressLength = (_a = options === null || options === void 0 ? void 0 : options.length) !== null && _a !== void 0 ? _a : 8;
            if (subaddressLength < 1) {
                return result;
            }
            const parsed = SUBADDRESS_PARSER.exec(result);
            if (!parsed) {
                return result;
            }
            let subaddress = (_b = parsed.groups.subaddress) !== null && _b !== void 0 ? _b : "+";
            subaddress += yield this.random.chars(subaddressLength);
            result = `${parsed.groups.username}${subaddress}${parsed.groups.domain}`;
            return result;
        });
    }
    /** Creates a catchall address composed of random characters
     *  @param domain the domain part of the generated email address.
     *  @param options.length the number of characters to include in the catchall
     *    address. Defaults to 8.
     *  @returns a promise that resolves with the generated email address. If the domain
     *    is empty, resolves to null instead.
     */
    randomAsciiCatchall(domain, options) {
        return email_randomizer_awaiter(this, void 0, void 0, function* () {
            var _a;
            const emailDomain = (domain === null || domain === void 0 ? void 0 : domain.startsWith("@")) ? domain.substring(1, Infinity) : (domain !== null && domain !== void 0 ? domain : "");
            if (emailDomain.length < 1) {
                return null;
            }
            const length = (_a = options === null || options === void 0 ? void 0 : options.length) !== null && _a !== void 0 ? _a : 8;
            if (length < 1) {
                return null;
            }
            const catchall = yield this.random.chars(length);
            const result = `${catchall}@${domain}`;
            return result;
        });
    }
    /** Creates a catchall address composed of random words
     *  @param domain the domain part of the generated email address.
     *  @param options.numberOfWords the number of words to include in the catchall
     *    address. Defaults to 1.
     *  @param options.words selects words from the provided wordlist. Defaults to
     *    the EFF "5-dice" list.
     *  @returns a promise that resolves with the generated email address.
     */
    randomWordsCatchall(domain, options) {
        return email_randomizer_awaiter(this, void 0, void 0, function* () {
            var _a, _b;
            const emailDomain = (domain === null || domain === void 0 ? void 0 : domain.startsWith("@")) ? domain.substring(1, Infinity) : (domain !== null && domain !== void 0 ? domain : "");
            if (emailDomain.length < 1) {
                return null;
            }
            const numberOfWords = (_a = options === null || options === void 0 ? void 0 : options.numberOfWords) !== null && _a !== void 0 ? _a : 1;
            if (numberOfWords < 1) {
                return null;
            }
            const wordList = (_b = options === null || options === void 0 ? void 0 : options.words) !== null && _b !== void 0 ? _b : EFFLongWordList;
            const words = [];
            for (let i = 0; i < numberOfWords; i++) {
                // camelCase the words for legibility
                words[i] = yield this.random.pickWord(wordList, { titleCase: i !== 0 });
            }
            const result = `${words.join("")}@${domain}`;
            return result;
        });
    }
    generate(request, settings) {
        return email_randomizer_awaiter(this, void 0, void 0, function* () {
            if (isCatchallGenerationOptions(settings)) {
                const email = yield this.randomAsciiCatchall(settings.catchallDomain);
                return new generated_credential_GeneratedCredential(email, "catchall", Date.now(), request.source, request.website);
            }
            else if (isSubaddressGenerationOptions(settings)) {
                const email = yield this.randomAsciiSubaddress(settings.subaddressEmail);
                return new generated_credential_GeneratedCredential(email, "subaddress", Date.now(), request.source, request.website);
            }
            throw new Error("Invalid settings received by generator.");
        });
    }
}
function isCatchallGenerationOptions(settings) {
    return "catchallDomain" in (settings !== null && settings !== void 0 ? settings : {});
}
function isSubaddressGenerationOptions(settings) {
    return "subaddressEmail" in (settings !== null && settings !== void 0 ? settings : {});
}

;// ../../libs/tools/generator/core/src/engine/email-calculator.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

/** Generation algorithms that produce deterministic email addresses */
class EmailCalculator {
    /**
     * Appends appendText to the subaddress of an email address.
     * @param appendText  The calculation fails if this is shorter than 1 character
     *   long, undefined, or null.
     * @param email the email address to alter.
     * @returns `email` with `appendText` added to its subaddress (the part
     *   following the "+"). If there is no subaddress, a subaddress is created.
     *   If the email address fails to parse, it is returned unaltered.
     */
    appendToSubaddress(appendText, email) {
        var _a;
        let result = (email !== null && email !== void 0 ? email : "").trim();
        const suffix = (appendText !== null && appendText !== void 0 ? appendText : "").trim();
        if (suffix.length < 1) {
            return result;
        }
        const parsed = SUBADDRESS_PARSER.exec(result);
        if (!parsed) {
            return result;
        }
        const subaddress = ((_a = parsed.groups.subaddress) !== null && _a !== void 0 ? _a : "+") + suffix;
        result = `${parsed.groups.username}${subaddress}${parsed.groups.domain}`;
        return result;
    }
    /**
     * Derives an email address from a username and domain name.
     * @param username the username part of the email address. The calculation fails if this is
     *   shorter than 1 character long, undefined, or null.
     * @param domain the domain part of the email address. The calculation fails if this is empty,
     *   undefined, or null.
     * @returns an email address or `null` if the calculation fails.
     */
    concatenate(username, domain) {
        const emailDomain = (domain === null || domain === void 0 ? void 0 : domain.startsWith("@")) ? domain.substring(1, Infinity) : (domain !== null && domain !== void 0 ? domain : "");
        if (emailDomain.length < 1) {
            return null;
        }
        const emailWebsite = username !== null && username !== void 0 ? username : "";
        if (emailWebsite.length < 1) {
            return null;
        }
        const result = `${emailWebsite}@${emailDomain}`;
        return result;
    }
}

;// ../../libs/tools/generator/core/src/util.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore


/** construct a method that outputs a copy of `defaultValue` as an observable. */
function observe$PerUserId(create) {
    const _subjects = new Map();
    return (key) => {
        let value = _subjects.get(key);
        if (value === undefined) {
            const initialValue = create();
            value = new external_rxjs_namespaceObject.BehaviorSubject(Object.assign({}, initialValue));
            _subjects.set(key, value);
        }
        return value.asObservable();
    };
}
/** construct a method that caches user-specific states by userid. */
function sharedByUserId(create) {
    const _subjects = new Map();
    return (key) => {
        let value = _subjects.get(key);
        if (value === undefined) {
            value = create(key);
            _subjects.set(key, value);
        }
        return value;
    };
}
/** construct a method that loads a user-specific state from the provider. */
function sharedStateByUserId(key, provider) {
    return (id) => provider.getUser(id, key);
}
/** returns the sum of items in the list. */
const sum = (...items) => (items !== null && items !== void 0 ? items : []).reduce((sum, current) => sum + (current !== null && current !== void 0 ? current : 0), 0);
/* converts password generation option sets, which are defined by
 * an "enabled" and "quantity" parameter, to the password engine's
 * parameters, which represent disabled options as `undefined`
 * properties.
 */
function optionsToRandomAsciiRequest(options) {
    var _a, _b;
    // helper for processing common option sets
    function process(
    // values read from the options
    enabled, quantity, 
    // value used if an option is missing
    defaultEnabled, defaultQuantity) {
        const isEnabled = enabled !== null && enabled !== void 0 ? enabled : defaultEnabled;
        const actualQuantity = quantity !== null && quantity !== void 0 ? quantity : defaultQuantity;
        const result = isEnabled ? actualQuantity : undefined;
        return result;
    }
    const request = {
        uppercase: process(options.uppercase, options.minUppercase, DefaultPasswordGenerationOptions.uppercase, DefaultPasswordGenerationOptions.minUppercase),
        lowercase: process(options.lowercase, options.minLowercase, DefaultPasswordGenerationOptions.lowercase, DefaultPasswordGenerationOptions.minLowercase),
        digits: process(options.number, options.minNumber, DefaultPasswordGenerationOptions.number, DefaultPasswordGenerationOptions.minNumber),
        special: process(options.special, options.minSpecial, DefaultPasswordGenerationOptions.special, DefaultPasswordGenerationOptions.minSpecial),
        ambiguous: (_a = options.ambiguous) !== null && _a !== void 0 ? _a : DefaultPasswordGenerationOptions.ambiguous,
        all: 0,
    };
    // engine represents character sets as "include only"; you assert how many all
    // characters there can be rather than a total length. This conversion has
    // the character classes win, so that the result is always consistent with policy
    // minimums.
    const required = sum(request.uppercase, request.lowercase, request.digits, request.special);
    const remaining = ((_b = options.length) !== null && _b !== void 0 ? _b : 0) - required;
    request.all = Math.max(remaining, 0);
    return request;
}
/* converts passphrase generation option sets to the eff word list request
 */
function optionsToEffWordListRequest(options) {
    var _a, _b, _c, _d;
    const requestWords = (_a = options.numWords) !== null && _a !== void 0 ? _a : DefaultPassphraseGenerationOptions.numWords;
    const request = {
        numberOfWords: Math.max(requestWords, DefaultPassphraseBoundaries.numWords.min),
        capitalize: (_b = options.capitalize) !== null && _b !== void 0 ? _b : DefaultPassphraseGenerationOptions.capitalize,
        number: (_c = options.includeNumber) !== null && _c !== void 0 ? _c : DefaultPassphraseGenerationOptions.includeNumber,
        separator: (_d = options.wordSeparator) !== null && _d !== void 0 ? _d : DefaultPassphraseGenerationOptions.wordSeparator,
    };
    return request;
}

;// ../../libs/tools/generator/core/src/engine/password-randomizer.ts
var password_randomizer_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore




/** Generation algorithms that produce randomized secrets */
class PasswordRandomizer {
    /** Instantiates the password randomizer
     *  @param randomizer data source for random data
     */
    constructor(randomizer) {
        this.randomizer = randomizer;
    }
    /** create a password from ASCII codepoints
     *  @param request refines the generated password
     *  @returns a promise that completes with the generated password
     */
    randomAscii(request) {
        return password_randomizer_awaiter(this, void 0, void 0, function* () {
            // randomize character sets
            const sets = toAsciiSets(request);
            const shuffled = yield this.randomizer.shuffle(sets);
            // generate password
            const generating = shuffled.flatMap((set) => this.randomizer.pick(set));
            const generated = yield Promise.all(generating);
            const result = generated.join("");
            return result;
        });
    }
    /** create a passphrase from the EFF's "5 dice" word list
     *  @param request refines the generated passphrase
     * @returns a promise that completes with the generated passphrase
     */
    randomEffLongWords(request) {
        return password_randomizer_awaiter(this, void 0, void 0, function* () {
            // select which word gets the number, if any
            let luckyNumber = -1;
            if (request.number) {
                luckyNumber = yield this.randomizer.uniform(0, request.numberOfWords - 1);
            }
            // generate the passphrase
            const wordList = new Array(request.numberOfWords);
            for (let i = 0; i < request.numberOfWords; i++) {
                const word = yield this.randomizer.pickWord(EFFLongWordList, {
                    titleCase: request.capitalize,
                    number: i === luckyNumber,
                });
                wordList[i] = word;
            }
            return wordList.join(request.separator);
        });
    }
    generate(request, settings) {
        return password_randomizer_awaiter(this, void 0, void 0, function* () {
            if (isPasswordGenerationOptions(settings)) {
                const req = optionsToRandomAsciiRequest(settings);
                const password = yield this.randomAscii(req);
                return new generated_credential_GeneratedCredential(password, "password", Date.now(), request.source, request.website);
            }
            else if (isPassphraseGenerationOptions(settings)) {
                const req = optionsToEffWordListRequest(settings);
                const passphrase = yield this.randomEffLongWords(req);
                return new generated_credential_GeneratedCredential(passphrase, "passphrase", Date.now(), request.source, request.website);
            }
            throw new Error("Invalid settings received by generator.");
        });
    }
}
function isPasswordGenerationOptions(settings) {
    return "length" in (settings !== null && settings !== void 0 ? settings : {});
}
function isPassphraseGenerationOptions(settings) {
    return "numWords" in (settings !== null && settings !== void 0 ? settings : {});
}
// given a generator request, convert each of its `number | undefined` properties
// to an array of character sets, one for each property. The transformation is
// deterministic.
function toAsciiSets(request) {
    // allocate an array and initialize each cell with a fixed value
    function allocate(size, value) {
        const data = new Array(size > 0 ? size : 0);
        data.fill(value, 0, size);
        return data;
    }
    const allSet = [];
    const active = request.ambiguous ? Ascii.Full : Ascii.Unmistakable;
    const parts = [];
    if (request.uppercase !== undefined) {
        parts.push(...allocate(request.uppercase, active.Uppercase));
        allSet.push(...active.Uppercase);
    }
    if (request.lowercase !== undefined) {
        parts.push(...allocate(request.lowercase, active.Lowercase));
        allSet.push(...active.Lowercase);
    }
    if (request.digits !== undefined) {
        parts.push(...allocate(request.digits, active.Digit));
        allSet.push(...active.Digit);
    }
    if (request.special !== undefined) {
        parts.push(...allocate(request.special, active.Special));
        allSet.push(...active.Special);
    }
    parts.push(...allocate(request.all, allSet));
    return parts;
}

;// ../../libs/tools/generator/core/src/engine/username-randomizer.ts
var username_randomizer_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


/** The number of digits used when generating an Eff username with a number. */
const NUMBER_OF_DIGITS = 4;
/** Generation algorithms that produce randomized usernames */
class UsernameRandomizer {
    /** Instantiates the username randomizer
     *  @param random data source for random data
     */
    constructor(random) {
        this.random = random;
    }
    /** Creates a username composed of random words
     *  @param request parameters to which the generated username conforms
     *  @returns a promise that resolves with the generated username.
     */
    randomWords(request) {
        return username_randomizer_awaiter(this, void 0, void 0, function* () {
            var _a, _b, _c;
            const numberOfWords = (_a = request === null || request === void 0 ? void 0 : request.numberOfWords) !== null && _a !== void 0 ? _a : 1;
            if (numberOfWords < 1) {
                return "";
            }
            const digits = Math.max((_b = request === null || request === void 0 ? void 0 : request.digits) !== null && _b !== void 0 ? _b : 0, 0);
            let selectCase = (_) => false;
            if ((request === null || request === void 0 ? void 0 : request.casing) === "camelCase") {
                selectCase = (i) => i !== 0;
            }
            else if ((request === null || request === void 0 ? void 0 : request.casing) === "TitleCase") {
                selectCase = (_) => true;
            }
            const wordList = (_c = request === null || request === void 0 ? void 0 : request.words) !== null && _c !== void 0 ? _c : EFFLongWordList;
            const parts = [];
            for (let i = 0; i < numberOfWords; i++) {
                const word = yield this.random.pickWord(wordList, { titleCase: selectCase(i) });
                parts.push(word);
            }
            for (let i = 0; i < digits; i++) {
                const digit = yield this.random.uniform(0, 9);
                parts.push(digit.toString());
            }
            const result = parts.join("");
            return result;
        });
    }
    generate(request, settings) {
        return username_randomizer_awaiter(this, void 0, void 0, function* () {
            if (isEffUsernameGenerationOptions(settings)) {
                const username = yield this.randomWords({
                    digits: settings.wordIncludeNumber ? NUMBER_OF_DIGITS : 0,
                    casing: settings.wordCapitalize ? "TitleCase" : "lowercase",
                });
                return new generated_credential_GeneratedCredential(username, "username", Date.now(), request.source, request.website);
            }
            throw new Error("Invalid settings received by generator.");
        });
    }
}
function isEffUsernameGenerationOptions(settings) {
    return "wordIncludeNumber" in (settings !== null && settings !== void 0 ? settings : {});
}

;// ../../libs/tools/generator/core/src/engine/index.ts








;// ../../libs/tools/generator/core/src/engine/forwarder.ts
var forwarder_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



/** Generation algorithms that query an email forwarding service to
 *  create anonymized email addresses.
 */
class forwarder_Forwarder {
    /** Instantiates the email forwarder engine
     *  @param configuration The forwarder to query
     *  @param client requests data from the forwarding service
     *  @param i18nService localizes messages sent to the forwarding service
     *   and user-addressable errors
     */
    constructor(configuration, client, i18nService) {
        this.configuration = configuration;
        this.client = client;
        this.i18nService = i18nService;
    }
    generate(request, settings) {
        return forwarder_awaiter(this, void 0, void 0, function* () {
            const requestOptions = { website: request.website };
            const getAccount = yield this.getAccountId(this.configuration, settings);
            if (getAccount) {
                requestOptions.accountId = yield this.client.fetchJson(getAccount, requestOptions);
            }
            const create = this.createForwardingAddress(this.configuration, settings);
            const result = yield this.client.fetchJson(create, requestOptions);
            const id = { forwarder: this.configuration.id };
            return new GeneratedCredential(result, id, Date.now());
        });
    }
    createContext(configuration, settings) {
        return new ForwarderContext(configuration, settings, this.i18nService);
    }
    createForwardingAddress(configuration, settings) {
        const context = this.createContext(configuration, settings);
        const rpc = new CreateForwardingAddressRpc(configuration, context);
        return rpc;
    }
    getAccountId(configuration, settings) {
        if (!configuration.forwarder.getAccountId) {
            return null;
        }
        const context = this.createContext(configuration, settings);
        const rpc = new GetAccountIdRpc(configuration, context);
        return rpc;
    }
}

;// ../../libs/tools/generator/core/src/policies/default-policy-evaluator.ts
/** A policy evaluator that does not apply any policy */
class default_policy_evaluator_DefaultPolicyEvaluator {
    /** {@link PolicyEvaluator.policy} */
    get policy() {
        return {};
    }
    /** {@link PolicyEvaluator.policyInEffect} */
    get policyInEffect() {
        return false;
    }
    /** {@link PolicyEvaluator.applyPolicy} */
    applyPolicy(options) {
        return options;
    }
    /** {@link PolicyEvaluator.sanitize} */
    sanitize(options) {
        return options;
    }
}

;// ../../libs/tools/generator/core/src/policies/constraints.ts

const Zero = { min: 0, max: 0 };
const AtLeastOne = { min: 1 };
const RequiresTrue = { requiredValue: true };
/** Ensures the minimum and maximum bounds of a constraint are at least as large as the
 *  combined minimum bounds of `dependencies`.
 *  @param current the constraint extended by the combinator.
 *  @param dependencies the constraints summed to determine the bounds of `current`.
 *  @returns a copy of `current` with the new bounds applied.
 *
 */
function atLeastSum(current, dependencies) {
    var _a;
    // length must be at least as long as the required character set
    const minConsistentLength = sum(...dependencies.map((c) => c === null || c === void 0 ? void 0 : c.min));
    const minLength = Math.max((_a = current === null || current === void 0 ? void 0 : current.min) !== null && _a !== void 0 ? _a : 0, minConsistentLength);
    const length = atLeast(minLength, current);
    return length;
}
/** Extends a constraint with a readonly field.
 *  @param readonly Adds a readonly field when this is `true`.
 *  @param constraint the constraint extended by the combinator.
 *  @returns a copy of `constraint` with the readonly constraint applied as-needed.
 */
function maybeReadonly(readonly, constraint) {
    if (!readonly) {
        return constraint;
    }
    const result = Object.assign({}, constraint !== null && constraint !== void 0 ? constraint : {});
    result.readonly = true;
    return result;
}
/** Conditionally enables a constraint.
 *  @param enabled the condition to evaluate
 *  @param constraint the condition to conditionally enable
 *  @returns `constraint` when `enabled` is true. Otherwise returns `undefined.
 */
function maybe(enabled, constraint) {
    return enabled ? constraint : undefined;
}
// copies `constraint`; ensures both bounds >= value
/** Ensures the boundaries of a constraint are at least equal to the minimum.
 *  @param minimum the lower bound of the constraint. When this is `undefined` or `null`,
 *   the method returns `constraint`.
 *  @param constraint the constraint to evaluate. When this is `undefined` or `null`,
 *   the method creates a new constraint.
 *  @returns a copy of `constraint`. When `minimum` has a value, the returned constraint
 *   always includes a minimum bound. When `constraint` has a maximum defined, both
 *   its minimum and maximum are checked against `minimum`.
 */
function atLeast(minimum, constraint) {
    var _a;
    if (minimum === undefined || minimum === null) {
        return constraint;
    }
    const atLeast = Object.assign({}, (constraint !== null && constraint !== void 0 ? constraint : {}));
    atLeast.min = Math.max((_a = atLeast.min) !== null && _a !== void 0 ? _a : -Infinity, minimum);
    if ("max" in atLeast) {
        atLeast.max = Math.max(atLeast.max, minimum);
    }
    return atLeast;
}
/** Ensures a value falls within the minimum and maximum boundaries of a constraint.
 *  @param value the value to check. Nullish values are coerced to 0.
 *  @param constraint the constraint to evaluate against.
 *  @returns If the value is below the minimum constraint, the minimum bound is
 *   returned. If the value is above the maximum constraint, the maximum bound is
 *   returned. Otherwise, the value is returned.
 */
function fitToBounds(value, constraint) {
    if (!constraint) {
        return value;
    }
    const { min, max } = constraint;
    const withUpperBound = Math.min(value !== null && value !== void 0 ? value : 0, max !== null && max !== void 0 ? max : Infinity);
    const withLowerBound = Math.max(withUpperBound, min !== null && min !== void 0 ? min : -Infinity);
    return withLowerBound;
}
/** Fits the length of a string within the minimum and maximum length boundaries
 *  of a constraint.
 *  @param value the value to check. Nullish values are coerced to the empty string.
 *  @param constraint the constraint to evaluate against.
 *  @param options.fillString a string to fill values from. Defaults to a space.
 *   When fillString contains multiple characters, each is filled in order. The
 *   fill string repeats when it gets to the end of the string and there are
 *   more characters to fill.
 *  @returns If the value is below the required length, returns a copy padded
 *   by the fillString. If the value is above the required length, returns a copy
 *   padded to the maximum length.
 * */
function fitLength(value, constraint, options) {
    if (!constraint) {
        return value;
    }
    const { minLength, maxLength } = constraint;
    const { fillString } = options !== null && options !== void 0 ? options : { fillString: " " };
    const trimmed = (value !== null && value !== void 0 ? value : "").slice(0, maxLength !== null && maxLength !== void 0 ? maxLength : Infinity);
    const result = trimmed.padEnd(minLength !== null && minLength !== void 0 ? minLength : trimmed.length, fillString);
    return result;
}
/** Enforces a readonly field has a required value.
 *  @param value the value to check.
 *  @param constraint the constraint to evaluate against.
 *  @returns If the constraint's readonly field is `true`, returns the
 *   constraint's required value or `undefined` if none is specified.
 *   Otherwise returns the value.
 *  @remarks This method can be used to ensure a conditionally-calculated
 *   field becomes undefined. Simply specify `readonly` without a `requiredValue`
 *   then use `??` to perform the calculation.
 */
function enforceConstant(value, constraint) {
    if (constraint === null || constraint === void 0 ? void 0 : constraint.readonly) {
        return constraint.requiredValue;
    }
    else {
        return value;
    }
}
/** Conditionally create a readonly true value.
 *  @param enabled When true, create the value.
 *  @returns When enabled is true, a readonly constraint with a constant value
 *  of `true`. Otherwise returns `undefined`.
 */
function readonlyTrueWhen(enabled) {
    const readonlyValue = maybeReadonly(enabled, RequiresTrue);
    const maybeReadonlyValue = maybe(enabled, readonlyValue);
    return maybeReadonlyValue;
}


;// ../../libs/tools/generator/core/src/policies/password-policy-constraints.ts


class PasswordPolicyConstraints {
    /** Creates a password policy constraints
     *  @param constraints Constraints derived from the policy and application-defined defaults
     */
    constructor(constraints) {
        this.constraints = constraints;
    }
    adjust(state) {
        // constrain values
        const result = Object.assign(Object.assign({}, (state !== null && state !== void 0 ? state : DefaultPasswordGenerationOptions)), { length: fitToBounds(state.length, this.constraints.length), lowercase: enforceConstant(state.lowercase, this.constraints.lowercase), uppercase: enforceConstant(state.uppercase, this.constraints.uppercase), number: enforceConstant(state.number, this.constraints.number), special: enforceConstant(state.special, this.constraints.special), minLowercase: fitToBounds(state.minLowercase, this.constraints.minLowercase), minUppercase: fitToBounds(state.minUppercase, this.constraints.minUppercase), minNumber: fitToBounds(state.minNumber, this.constraints.minNumber), minSpecial: fitToBounds(state.minSpecial, this.constraints.minSpecial) });
        // ensure include flags are consistent with the constrained values
        result.lowercase || (result.lowercase = state.minLowercase > 0);
        result.uppercase || (result.uppercase = state.minUppercase > 0);
        result.number || (result.number = state.minNumber > 0);
        result.special || (result.special = state.minSpecial > 0);
        // when all flags are disabled, enable a few
        const anyEnabled = [result.lowercase, result.uppercase, result.number, result.special].some((flag) => flag);
        if (!anyEnabled) {
            result.lowercase = true;
            result.uppercase = true;
        }
        return result;
    }
    fix(state) {
        return state;
    }
}

;// ../../libs/tools/generator/core/src/policies/dynamic-password-policy-constraints.ts


/** Creates state constraints by blending policy and password settings. */
class DynamicPasswordPolicyConstraints {
    /** Instantiates the object.
     *  @param policy the password policy to enforce. This cannot be
     *  `null` or `undefined`.
     */
    constructor(policy, defaults) {
        this.defaults = defaults;
        const minLowercase = maybe(policy.useLowercase, AtLeastOne);
        const minUppercase = maybe(policy.useUppercase, AtLeastOne);
        const minNumber = atLeast(policy.numberCount || (policy.useNumbers && AtLeastOne.min), defaults.minNumber);
        const minSpecial = atLeast(policy.specialCount || (policy.useSpecial && AtLeastOne.min), defaults.minSpecial);
        const baseLength = atLeast(policy.minLength, defaults.length);
        const subLengths = [minLowercase, minUppercase, minNumber, minSpecial];
        const length = atLeastSum(baseLength, subLengths);
        this.constraints = Object.freeze({
            policyInEffect: policyInEffect(policy, defaults),
            lowercase: readonlyTrueWhen(policy.useLowercase),
            uppercase: readonlyTrueWhen(policy.useUppercase),
            number: readonlyTrueWhen(policy.useNumbers),
            special: readonlyTrueWhen(policy.useSpecial),
            length,
            minLowercase,
            minUppercase,
            minNumber,
            minSpecial,
        });
    }
    calibrate(state) {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        // decide which constraints are active
        const lowercase = state.lowercase || ((_a = this.constraints.lowercase) === null || _a === void 0 ? void 0 : _a.requiredValue) || false;
        const uppercase = state.uppercase || ((_b = this.constraints.uppercase) === null || _b === void 0 ? void 0 : _b.requiredValue) || false;
        const number = state.number || ((_c = this.constraints.number) === null || _c === void 0 ? void 0 : _c.requiredValue) || false;
        const special = state.special || ((_d = this.constraints.special) === null || _d === void 0 ? void 0 : _d.requiredValue) || false;
        // minimum constraints cannot `atLeast(state...) because doing so would force
        // the constrained value to only increase
        const constraints = Object.assign(Object.assign({}, this.constraints), { minLowercase: maybe(lowercase, (_e = this.constraints.minLowercase) !== null && _e !== void 0 ? _e : AtLeastOne), minUppercase: maybe(uppercase, (_f = this.constraints.minUppercase) !== null && _f !== void 0 ? _f : AtLeastOne), minNumber: (_g = maybe(number, this.constraints.minNumber)) !== null && _g !== void 0 ? _g : Zero, minSpecial: (_h = maybe(special, this.constraints.minSpecial)) !== null && _h !== void 0 ? _h : Zero });
        // lower bound of length must always at least fit its sub-lengths
        constraints.length = atLeastSum(this.constraints.length, [
            atLeast(state.minNumber, constraints.minNumber),
            atLeast(state.minSpecial, constraints.minSpecial),
            atLeast(state.minLowercase, constraints.minLowercase),
            atLeast(state.minUppercase, constraints.minUppercase),
        ]);
        const stateConstraints = new PasswordPolicyConstraints(constraints);
        return stateConstraints;
    }
}
function policyInEffect(policy, defaults) {
    const policies = [
        policy.useUppercase,
        policy.useLowercase,
        policy.useNumbers,
        policy.useSpecial,
        policy.minLength > defaults.length.min,
        policy.numberCount > defaults.minNumber.min,
        policy.specialCount > defaults.minSpecial.min,
    ];
    return policies.includes(true);
}

;// ../../libs/tools/generator/core/src/policies/passphrase-generator-options-evaluator.ts

/** Enforces policy for passphrase generation options.
 */
class PassphraseGeneratorOptionsEvaluator {
    /** Instantiates the evaluator.
     * @param policy The policy applied by the evaluator. When this conflicts with
     *               the defaults, the policy takes precedence.
     */
    constructor(policy) {
        function createBoundary(value, defaultBoundary) {
            const boundary = {
                min: Math.max(defaultBoundary.min, value),
                max: Math.max(defaultBoundary.max, value),
            };
            return boundary;
        }
        this.policy = structuredClone(policy);
        this.numWords = createBoundary(policy.minNumberWords, DefaultPassphraseBoundaries.numWords);
    }
    /** {@link PolicyEvaluator.policyInEffect} */
    get policyInEffect() {
        const policies = [
            this.policy.capitalize,
            this.policy.includeNumber,
            this.policy.minNumberWords > DefaultPassphraseBoundaries.numWords.min,
        ];
        return policies.includes(true);
    }
    /** Apply policy to the input options.
     *  @param options The options to build from. These options are not altered.
     *  @returns A new password generation request with policy applied.
     */
    applyPolicy(options) {
        function fitToBounds(value, boundaries) {
            const { min, max } = boundaries;
            const withUpperBound = Math.min(value !== null && value !== void 0 ? value : boundaries.min, max);
            const withLowerBound = Math.max(withUpperBound, min);
            return withLowerBound;
        }
        // apply policy overrides
        const capitalize = this.policy.capitalize || options.capitalize || false;
        const includeNumber = this.policy.includeNumber || options.includeNumber || false;
        // apply boundaries
        const numWords = fitToBounds(options.numWords, this.numWords);
        return Object.assign(Object.assign({}, options), { numWords,
            capitalize,
            includeNumber });
    }
    /** Ensures internal options consistency.
     *  @param options The options to cascade. These options are not altered.
     *  @returns A passphrase generation request with cascade applied.
     */
    sanitize(options) {
        var _a, _b;
        // ensure words are separated by a single character or the empty string
        const wordSeparator = options.wordSeparator === ""
            ? ""
            : ((_b = (_a = options.wordSeparator) === null || _a === void 0 ? void 0 : _a[0]) !== null && _b !== void 0 ? _b : DefaultPassphraseGenerationOptions.wordSeparator);
        return Object.assign(Object.assign({}, options), { wordSeparator });
    }
}

;// ../../libs/tools/generator/core/src/policies/passphrase-policy-constraints.ts


class PassphrasePolicyConstraints {
    /** Creates a passphrase policy constraints
     *  @param policy the password policy to enforce. This cannot be
     *  `null` or `undefined`.
     */
    constructor(policy, defaults) {
        this.policy = policy;
        this.defaults = defaults;
        this.constraints = {
            policyInEffect: passphrase_policy_constraints_policyInEffect(policy, defaults),
            wordSeparator: { minLength: 0, maxLength: 1 },
            capitalize: readonlyTrueWhen(policy.capitalize),
            includeNumber: readonlyTrueWhen(policy.includeNumber),
            numWords: atLeast(policy.minNumberWords, defaults.numWords),
        };
    }
    adjust(state) {
        const result = {
            wordSeparator: fitLength(state.wordSeparator, this.constraints.wordSeparator, {
                fillString: DefaultPassphraseGenerationOptions.wordSeparator,
            }),
            capitalize: enforceConstant(state.capitalize, this.constraints.capitalize),
            includeNumber: enforceConstant(state.includeNumber, this.constraints.includeNumber),
            numWords: fitToBounds(state.numWords, this.constraints.numWords),
        };
        return result;
    }
    fix(state) {
        return state;
    }
}
function passphrase_policy_constraints_policyInEffect(policy, defaults) {
    const policies = [
        policy.capitalize,
        policy.includeNumber,
        policy.minNumberWords > defaults.numWords.min,
    ];
    return policies.includes(true);
}

;// ../../libs/tools/generator/core/src/policies/password-generator-options-evaluator.ts

/** Enforces policy for password generation.
 */
class PasswordGeneratorOptionsEvaluator {
    // Constraints<PasswordGenerationOptions> compatibility
    get minNumber() {
        return this.minDigits;
    }
    get minSpecial() {
        return this.minSpecialCharacters;
    }
    /** Instantiates the evaluator.
     * @param policy The policy applied by the evaluator. When this conflicts with
     *               the defaults, the policy takes precedence.
     */
    constructor(policy) {
        function createBoundary(value, defaultBoundary) {
            const boundary = {
                min: Math.max(defaultBoundary.min, value),
                max: Math.max(defaultBoundary.max, value),
            };
            return boundary;
        }
        this.policy = structuredClone(policy);
        this.minDigits = createBoundary(policy.numberCount, DefaultPasswordBoundaries.minDigits);
        this.minSpecialCharacters = createBoundary(policy.specialCount, DefaultPasswordBoundaries.minSpecialCharacters);
        // the overall length should be at least as long as the sum of the minimums
        const minConsistentLength = this.minDigits.min + this.minSpecialCharacters.min;
        const minPolicyLength = policy.minLength > 0 ? policy.minLength : DefaultPasswordBoundaries.length.min;
        const minLength = Math.max(minPolicyLength, minConsistentLength, DefaultPasswordBoundaries.length.min);
        this.length = {
            min: minLength,
            max: Math.max(DefaultPasswordBoundaries.length.max, minLength),
        };
    }
    /** {@link PolicyEvaluator.policyInEffect} */
    get policyInEffect() {
        const policies = [
            this.policy.useUppercase,
            this.policy.useLowercase,
            this.policy.useNumbers,
            this.policy.useSpecial,
            this.policy.minLength > DefaultPasswordBoundaries.length.min,
            this.policy.numberCount > DefaultPasswordBoundaries.minDigits.min,
            this.policy.specialCount > DefaultPasswordBoundaries.minSpecialCharacters.min,
        ];
        return policies.includes(true);
    }
    /** {@link PolicyEvaluator.applyPolicy} */
    applyPolicy(options) {
        function fitToBounds(value, boundaries) {
            const { min, max } = boundaries;
            const withUpperBound = Math.min(value || 0, max);
            const withLowerBound = Math.max(withUpperBound, min);
            return withLowerBound;
        }
        // apply policy overrides
        const uppercase = this.policy.useUppercase || options.uppercase || false;
        const lowercase = this.policy.useLowercase || options.lowercase || false;
        // these overrides can cascade numeric fields to boolean fields
        const number = this.policy.useNumbers || options.number || options.minNumber > 0;
        const special = this.policy.useSpecial || options.special || options.minSpecial > 0;
        // apply boundaries; the boundaries can cascade boolean fields to numeric fields
        const length = fitToBounds(options.length, this.length);
        const minNumber = fitToBounds(options.minNumber, this.minDigits);
        const minSpecial = fitToBounds(options.minSpecial, this.minSpecialCharacters);
        return Object.assign(Object.assign({}, options), { length,
            uppercase,
            lowercase,
            number,
            minNumber,
            special,
            minSpecial });
    }
    /** {@link PolicyEvaluator.sanitize} */
    sanitize(options) {
        var _a;
        function cascade(enabled, value) {
            const enabledResult = enabled !== null && enabled !== void 0 ? enabled : value > 0;
            const valueResult = enabledResult ? value || 1 : 0;
            return [enabledResult, valueResult];
        }
        const [lowercase, minLowercase] = cascade(options.lowercase, options.minLowercase);
        const [uppercase, minUppercase] = cascade(options.uppercase, options.minUppercase);
        const [number, minNumber] = cascade(options.number, options.minNumber);
        const [special, minSpecial] = cascade(options.special, options.minSpecial);
        // minimums can only increase the length
        const minConsistentLength = minLowercase + minUppercase + minNumber + minSpecial;
        const minLength = Math.max(minConsistentLength, this.length.min);
        const length = Math.max((_a = options.length) !== null && _a !== void 0 ? _a : minLength, minLength);
        return Object.assign(Object.assign({}, options), { length,
            minLength,
            lowercase,
            minLowercase,
            uppercase,
            minUppercase,
            number,
            minNumber,
            special,
            minSpecial });
    }
}

;// ../../libs/tools/generator/core/src/policies/passphrase-least-privilege.ts

/** Reduces a policy into an accumulator by accepting the most restrictive
 *  values from each policy.
 *  @param acc the accumulator
 *  @param policy the policy to reduce
 *  @returns the most restrictive values between the policy and accumulator.
 */
function passphraseLeastPrivilege(acc, policy) {
    var _a;
    if (policy.type !== policy_type_enum_PolicyType.PasswordGenerator) {
        return acc;
    }
    return {
        minNumberWords: Math.max(acc.minNumberWords, (_a = policy.data.minNumberWords) !== null && _a !== void 0 ? _a : acc.minNumberWords),
        capitalize: policy.data.capitalize || acc.capitalize,
        includeNumber: policy.data.includeNumber || acc.includeNumber,
    };
}

;// ../../libs/tools/generator/core/src/policies/password-least-privilege.ts

/** Reduces a policy into an accumulator by accepting the most restrictive
 *  values from each policy.
 *  @param acc the accumulator
 *  @param policy the policy to reduce
 *  @returns the most restrictive values between the policy and accumulator.
 */
function passwordLeastPrivilege(acc, policy) {
    var _a, _b, _c;
    if (policy.type !== policy_type_enum_PolicyType.PasswordGenerator || !policy.enabled) {
        return acc;
    }
    return {
        minLength: Math.max(acc.minLength, (_a = policy.data.minLength) !== null && _a !== void 0 ? _a : acc.minLength),
        useUppercase: policy.data.useUpper || acc.useUppercase,
        useLowercase: policy.data.useLower || acc.useLowercase,
        useNumbers: policy.data.useNumbers || acc.useNumbers,
        numberCount: Math.max(acc.numberCount, (_b = policy.data.minNumbers) !== null && _b !== void 0 ? _b : acc.numberCount),
        useSpecial: policy.data.useSpecial || acc.useSpecial,
        specialCount: Math.max(acc.specialCount, (_c = policy.data.minSpecial) !== null && _c !== void 0 ? _c : acc.specialCount),
    };
}

;// ../../libs/tools/generator/core/src/policies/index.ts








;// ../../libs/tools/generator/core/src/policies/catchall-constraints.ts
/** Parses the domain part of an email address
 */
const DOMAIN_PARSER = new RegExp("[^@]+@(?<domain>.+)");
/** A constraint that sets the catchall domain using a fixed email address */
class CatchallConstraints {
    /** Creates a catchall constraints
     * @param email - the email address containing the domain.
     */
    constructor(email) {
        var _a;
        this.constraints = {};
        if (!email) {
            this.domain = "";
            return;
        }
        const parsed = DOMAIN_PARSER.exec(email);
        if (parsed && ((_a = parsed.groups) === null || _a === void 0 ? void 0 : _a.domain)) {
            this.domain = parsed.groups.domain;
        }
    }
    adjust(state) {
        var _a;
        const currentDomain = ((_a = state.catchallDomain) !== null && _a !== void 0 ? _a : "").trim();
        if (currentDomain !== "") {
            return state;
        }
        const options = Object.assign({}, state);
        options.catchallDomain = this.domain;
        return options;
    }
    fix(state) {
        return state;
    }
}

;// ../../libs/tools/generator/core/src/policies/subaddress-constraints.ts
/** A constraint that sets the subaddress email using a fixed email address */
class SubaddressConstraints {
    /** Creates a catchall constraints
     * @param email - the email address containing the domain.
     */
    constructor(email) {
        this.email = email;
        this.constraints = {};
        if (!email) {
            this.email = "";
        }
    }
    adjust(state) {
        var _a;
        const currentDomain = ((_a = state.subaddressEmail) !== null && _a !== void 0 ? _a : "").trim();
        if (currentDomain !== "") {
            return state;
        }
        const options = Object.assign({}, state);
        options.subaddressEmail = this.email;
        return options;
    }
    fix(state) {
        return state;
    }
}

;// ../../libs/tools/generator/core/src/data/default-catchall-options.ts
/** The default options for catchall address generation. */
const DefaultCatchallOptions = Object.freeze({
    catchallType: "random",
    catchallDomain: "",
    website: null,
});

;// ../../libs/tools/generator/core/src/data/default-eff-username-options.ts
/** The default options for EFF long word generation. */
const DefaultEffUsernameOptions = Object.freeze({
    wordCapitalize: false,
    wordIncludeNumber: false,
    website: null,
});

;// ../../libs/tools/generator/core/src/data/default-passphrase-boundaries.ts
function initializeBoundaries() {
    const numWords = Object.freeze({
        min: 3,
        max: 20,
    });
    return Object.freeze({
        numWords,
    });
}
/** Immutable default boundaries for passphrase generation.
 * These are used when the policy does not override a value.
 */
const DefaultPassphraseBoundaries = initializeBoundaries();

;// ../../libs/tools/generator/core/src/data/default-passphrase-generation-options.ts
/** The default options for passphrase generation. */
const DefaultPassphraseGenerationOptions = Object.freeze({
    numWords: 6,
    wordSeparator: "-",
    capitalize: false,
    includeNumber: false,
});

;// ../../libs/tools/generator/core/src/data/default-password-boundaries.ts
function default_password_boundaries_initializeBoundaries() {
    const length = Object.freeze({
        min: 5,
        max: 128,
    });
    const minDigits = Object.freeze({
        min: 0,
        max: 9,
    });
    const minSpecialCharacters = Object.freeze({
        min: 0,
        max: 9,
    });
    return Object.freeze({
        length,
        minDigits,
        minSpecialCharacters,
    });
}
/** Immutable default boundaries for password generation.
 * These are used when the policy does not override a value.
 */
const DefaultPasswordBoundaries = default_password_boundaries_initializeBoundaries();

;// ../../libs/tools/generator/core/src/data/default-password-generation-options.ts

/** The default options for password generation. */
const DefaultPasswordGenerationOptions = Object.freeze({
    length: 14,
    minLength: DefaultPasswordBoundaries.length.min,
    ambiguous: true,
    uppercase: true,
    minUppercase: 1,
    lowercase: true,
    minLowercase: 1,
    number: true,
    minNumber: 1,
    special: false,
    minSpecial: 0,
});

;// ../../libs/tools/generator/core/src/data/default-subaddress-generator-options.ts
/** The default options for email subaddress generation. */
const DefaultSubaddressOptions = Object.freeze({
    subaddressType: "random",
    subaddressEmail: "",
    website: null,
});

;// ../../libs/tools/generator/core/src/data/generators.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore
















const PASSPHRASE = Object.freeze({
    id: "passphrase",
    category: "password",
    nameKey: "passphrase",
    generateKey: "generatePassphrase",
    onGeneratedMessageKey: "passphraseGenerated",
    credentialTypeKey: "passphrase",
    copyKey: "copyPassphrase",
    useGeneratedValueKey: "useThisPassword",
    onlyOnRequest: false,
    request: [],
    engine: {
        create(dependencies) {
            return new PasswordRandomizer(dependencies.randomizer);
        },
    },
    settings: {
        initial: DefaultPassphraseGenerationOptions,
        constraints: {
            numWords: {
                min: DefaultPassphraseBoundaries.numWords.min,
                max: DefaultPassphraseBoundaries.numWords.max,
                recommendation: DefaultPassphraseGenerationOptions.numWords,
            },
            wordSeparator: { maxLength: 1 },
        },
        account: {
            key: "passphraseGeneratorSettings",
            target: "object",
            format: "plain",
            classifier: new PublicClassifier([
                "numWords",
                "wordSeparator",
                "capitalize",
                "includeNumber",
            ]),
            state: GENERATOR_DISK,
            initial: DefaultPassphraseGenerationOptions,
            options: {
                deserializer: (value) => value,
                clearOn: ["logout"],
            },
        },
    },
    policy: {
        type: policy_type_enum_PolicyType.PasswordGenerator,
        disabledValue: Object.freeze({
            minNumberWords: 0,
            capitalize: false,
            includeNumber: false,
        }),
        combine: passphraseLeastPrivilege,
        createEvaluator: (policy) => new PassphraseGeneratorOptionsEvaluator(policy),
        toConstraints: (policy) => new PassphrasePolicyConstraints(policy, PASSPHRASE.settings.constraints),
    },
});
const PASSWORD = Object.freeze({
    id: "password",
    category: "password",
    nameKey: "password",
    generateKey: "generatePassword",
    onGeneratedMessageKey: "passwordGenerated",
    credentialTypeKey: "password",
    copyKey: "copyPassword",
    useGeneratedValueKey: "useThisPassword",
    onlyOnRequest: false,
    request: [],
    engine: {
        create(dependencies) {
            return new PasswordRandomizer(dependencies.randomizer);
        },
    },
    settings: {
        initial: DefaultPasswordGenerationOptions,
        constraints: {
            length: {
                min: DefaultPasswordBoundaries.length.min,
                max: DefaultPasswordBoundaries.length.max,
                recommendation: DefaultPasswordGenerationOptions.length,
            },
            minNumber: {
                min: DefaultPasswordBoundaries.minDigits.min,
                max: DefaultPasswordBoundaries.minDigits.max,
            },
            minSpecial: {
                min: DefaultPasswordBoundaries.minSpecialCharacters.min,
                max: DefaultPasswordBoundaries.minSpecialCharacters.max,
            },
        },
        account: {
            key: "passwordGeneratorSettings",
            target: "object",
            format: "plain",
            classifier: new PublicClassifier([
                "length",
                "ambiguous",
                "uppercase",
                "minUppercase",
                "lowercase",
                "minLowercase",
                "number",
                "minNumber",
                "special",
                "minSpecial",
            ]),
            state: GENERATOR_DISK,
            initial: DefaultPasswordGenerationOptions,
            options: {
                deserializer: (value) => value,
                clearOn: ["logout"],
            },
        },
    },
    policy: {
        type: policy_type_enum_PolicyType.PasswordGenerator,
        disabledValue: Object.freeze({
            minLength: 0,
            useUppercase: false,
            useLowercase: false,
            useNumbers: false,
            numberCount: 0,
            useSpecial: false,
            specialCount: 0,
        }),
        combine: passwordLeastPrivilege,
        createEvaluator: (policy) => new PasswordGeneratorOptionsEvaluator(policy),
        toConstraints: (policy) => new DynamicPasswordPolicyConstraints(policy, PASSWORD.settings.constraints),
    },
});
const USERNAME = Object.freeze({
    id: "username",
    category: "username",
    nameKey: "randomWord",
    generateKey: "generateUsername",
    onGeneratedMessageKey: "usernameGenerated",
    credentialTypeKey: "username",
    copyKey: "copyUsername",
    useGeneratedValueKey: "useThisUsername",
    onlyOnRequest: false,
    request: [],
    engine: {
        create(dependencies) {
            return new UsernameRandomizer(dependencies.randomizer);
        },
    },
    settings: {
        initial: DefaultEffUsernameOptions,
        constraints: {},
        account: {
            key: "effUsernameGeneratorSettings",
            target: "object",
            format: "plain",
            classifier: new PublicClassifier([
                "wordCapitalize",
                "wordIncludeNumber",
            ]),
            state: GENERATOR_DISK,
            initial: DefaultEffUsernameOptions,
            options: {
                deserializer: (value) => value,
                clearOn: ["logout"],
            },
        },
    },
    policy: {
        type: policy_type_enum_PolicyType.PasswordGenerator,
        disabledValue: {},
        combine(_acc, _policy) {
            return {};
        },
        createEvaluator(_policy) {
            return new default_policy_evaluator_DefaultPolicyEvaluator();
        },
        toConstraints(_policy) {
            return new identity_state_constraint_IdentityConstraint();
        },
    },
});
const CATCHALL = Object.freeze({
    id: "catchall",
    category: "email",
    nameKey: "catchallEmail",
    descriptionKey: "catchallEmailDesc",
    generateKey: "generateEmail",
    onGeneratedMessageKey: "emailGenerated",
    credentialTypeKey: "email",
    copyKey: "copyEmail",
    useGeneratedValueKey: "useThisEmail",
    onlyOnRequest: false,
    request: [],
    engine: {
        create(dependencies) {
            return new EmailRandomizer(dependencies.randomizer);
        },
    },
    settings: {
        initial: DefaultCatchallOptions,
        constraints: { catchallDomain: { minLength: 1 } },
        account: {
            key: "catchallGeneratorSettings",
            target: "object",
            format: "plain",
            classifier: new PublicClassifier([
                "catchallType",
                "catchallDomain",
            ]),
            state: GENERATOR_DISK,
            initial: {
                catchallType: "random",
                catchallDomain: "",
            },
            options: {
                deserializer: (value) => value,
                clearOn: ["logout"],
            },
        },
    },
    policy: {
        type: policy_type_enum_PolicyType.PasswordGenerator,
        disabledValue: {},
        combine(_acc, _policy) {
            return {};
        },
        createEvaluator(_policy) {
            return new default_policy_evaluator_DefaultPolicyEvaluator();
        },
        toConstraints(_policy, email) {
            return new CatchallConstraints(email);
        },
    },
});
const SUBADDRESS = Object.freeze({
    id: "subaddress",
    category: "email",
    nameKey: "plusAddressedEmail",
    descriptionKey: "plusAddressedEmailDesc",
    generateKey: "generateEmail",
    onGeneratedMessageKey: "emailGenerated",
    credentialTypeKey: "email",
    copyKey: "copyEmail",
    useGeneratedValueKey: "useThisEmail",
    onlyOnRequest: false,
    request: [],
    engine: {
        create(dependencies) {
            return new EmailRandomizer(dependencies.randomizer);
        },
    },
    settings: {
        initial: DefaultSubaddressOptions,
        constraints: {},
        account: {
            key: "subaddressGeneratorSettings",
            target: "object",
            format: "plain",
            classifier: new PublicClassifier([
                "subaddressType",
                "subaddressEmail",
            ]),
            state: GENERATOR_DISK,
            initial: {
                subaddressType: "random",
                subaddressEmail: "",
            },
            options: {
                deserializer: (value) => value,
                clearOn: ["logout"],
            },
        },
    },
    policy: {
        type: policy_type_enum_PolicyType.PasswordGenerator,
        disabledValue: {},
        combine(_acc, _policy) {
            return {};
        },
        createEvaluator(_policy) {
            return new default_policy_evaluator_DefaultPolicyEvaluator();
        },
        toConstraints(_policy, email) {
            return new SubaddressConstraints(email);
        },
    },
});
function generators_toCredentialGeneratorConfiguration(configuration) {
    const forwarder = Object.freeze({
        id: { forwarder: configuration.id },
        category: "email",
        nameKey: configuration.name,
        descriptionKey: "forwardedEmailDesc",
        generateKey: "generateEmail",
        onGeneratedMessageKey: "emailGenerated",
        credentialTypeKey: "email",
        copyKey: "copyEmail",
        useGeneratedValueKey: "useThisEmail",
        onlyOnRequest: true,
        request: configuration.forwarder.request,
        engine: {
            create(dependencies) {
                // FIXME: figure out why `configuration` fails to typecheck
                const config = configuration;
                return new Forwarder(config, dependencies.client, dependencies.i18nService);
            },
        },
        settings: {
            initial: configuration.forwarder.defaultSettings,
            constraints: configuration.forwarder.settingsConstraints,
            account: configuration.forwarder.local.settings,
        },
        policy: {
            type: PolicyType.PasswordGenerator,
            disabledValue: {},
            combine(_acc, _policy) {
                return {};
            },
            createEvaluator(_policy) {
                return new DefaultPolicyEvaluator();
            },
            toConstraints(_policy) {
                return new IdentityConstraint();
            },
        },
    });
    return forwarder;
}
/** Generator configurations */
const generators_Generators = Object.freeze({
    /** Passphrase generator configuration */
    passphrase: PASSPHRASE,
    /** Password generator configuration */
    password: PASSWORD,
    /** Username generator configuration */
    username: USERNAME,
    /** Catchall email generator configuration */
    catchall: CATCHALL,
    /** Email subaddress generator configuration */
    subaddress: SUBADDRESS,
});

;// ../../libs/tools/generator/core/src/data/default-addy-io-options.ts
const DefaultAddyIoOptions = Object.freeze({
    website: null,
    baseUrl: "https://app.addy.io",
    token: "",
    domain: "",
});

;// ../../libs/tools/generator/core/src/data/default-duck-duck-go-options.ts
const DefaultDuckDuckGoOptions = Object.freeze({
    website: null,
    token: "",
});

;// ../../libs/tools/generator/core/src/data/default-fastmail-options.ts
const DefaultFastmailOptions = Object.freeze({
    website: "",
    domain: "",
    prefix: "",
    token: "",
});

;// ../../libs/tools/generator/core/src/data/default-forward-email-options.ts
const DefaultForwardEmailOptions = Object.freeze({
    website: null,
    token: "",
    domain: "",
});

;// ../../libs/tools/generator/core/src/data/default-firefox-relay-options.ts
const DefaultFirefoxRelayOptions = Object.freeze({
    website: null,
    token: "",
});

;// ../../libs/tools/generator/core/src/data/default-credential-preferences.ts

const DefaultCredentialPreferences = Object.freeze({
    email: Object.freeze({
        algorithm: generator_types_EmailAlgorithms[0],
        updated: new Date(0),
    }),
    password: Object.freeze({
        algorithm: generator_types_PasswordAlgorithms[0],
        updated: new Date(0),
    }),
    username: Object.freeze({
        algorithm: generator_types_UsernameAlgorithms[0],
        updated: new Date(0),
    }),
});

;// ../../libs/tools/generator/core/src/data/default-simple-login-options.ts
const DefaultSimpleLoginOptions = Object.freeze({
    website: null,
    baseUrl: "https://app.simplelogin.io",
    token: "",
});

;// ../../libs/tools/generator/core/src/data/forwarders.ts
/** Metadata about an email forwarding service.
 *  @remarks This is used to populate the forwarder selection list
 *  and to identify forwarding services in error messages.
 */
const forwarders_Forwarders = Object.freeze({
    /** For https://addy.io/ */
    AddyIo: Object.freeze({
        id: "anonaddy",
        name: "Addy.io",
        validForSelfHosted: true,
    }),
    /** For https://duckduckgo.com/email/ */
    DuckDuckGo: Object.freeze({
        id: "duckduckgo",
        name: "DuckDuckGo",
        validForSelfHosted: false,
    }),
    /** For https://www.fastmail.com. */
    Fastmail: Object.freeze({
        id: "fastmail",
        name: "Fastmail",
        validForSelfHosted: true,
    }),
    /** For https://relay.firefox.com/ */
    FirefoxRelay: Object.freeze({
        id: "firefoxrelay",
        name: "Firefox Relay",
        validForSelfHosted: false,
    }),
    /** For https://forwardemail.net/ */
    ForwardEmail: Object.freeze({
        id: "forwardemail",
        name: "Forward Email",
        validForSelfHosted: true,
    }),
    /** For https://simplelogin.io/ */
    SimpleLogin: Object.freeze({
        id: "simplelogin",
        name: "SimpleLogin",
        validForSelfHosted: true,
    }),
});

;// ../../libs/common/src/tools/private-classifier.ts
class PrivateClassifier {
    constructor(keys = undefined) {
        this.keys = keys;
    }
    classify(value) {
        var _a;
        const pickMe = JSON.parse(JSON.stringify(value));
        const keys = (_a = this.keys) !== null && _a !== void 0 ? _a : Object.keys(pickMe);
        const picked = {};
        for (const key of keys) {
            picked[key] = pickMe[key];
        }
        const secret = picked;
        return { disclosed: {}, secret };
    }
    declassify(_disclosed, secret) {
        var _a;
        const result = {};
        const keys = (_a = this.keys) !== null && _a !== void 0 ? _a : Object.keys(secret);
        for (const key of keys) {
            result[key] = secret[key];
        }
        return result;
    }
}

;// ../../libs/common/src/tools/state/buffered-key-definition.ts

/** Storage and mapping settings for data stored by a `BufferedState`.
 */
class BufferedKeyDefinition {
    /**
     * Defines a buffered state
     * @param stateDefinition The domain of the buffer
     * @param key Domain key that identifies the buffered value. This key must
     *    not be reused in any capacity.
     * @param options Configures the operation of the buffered state.
     */
    constructor(stateDefinition, key, options) {
        this.stateDefinition = stateDefinition;
        this.key = key;
        this.options = options;
    }
    /** Converts the buffered key definition to a state provider
     *  key definition
     */
    toKeyDefinition() {
        const bufferedKey = new UserKeyDefinition(this.stateDefinition, this.key, this.options);
        return bufferedKey;
    }
    /** Checks whether the dependency triggers an overwrite. */
    shouldOverwrite(dependency) {
        var _a;
        const shouldOverwrite = (_a = this.options) === null || _a === void 0 ? void 0 : _a.shouldOverwrite;
        if (shouldOverwrite) {
            return shouldOverwrite(dependency);
        }
        return dependency ? true : false;
    }
    /** Converts the input data format to its output format.
     *  @returns the converted value.
     */
    map(input, dependency) {
        var _a;
        const map = (_a = this.options) === null || _a === void 0 ? void 0 : _a.map;
        if (map) {
            return map(input, dependency);
        }
        return Promise.resolve(input);
    }
    /** Checks whether the input type can be converted to the output type.
     *  @returns `true` if the definition is defined and valid, otherwise `false`.
     */
    isValid(input, dependency) {
        var _a;
        if (input === null) {
            return Promise.resolve(false);
        }
        const isValid = (_a = this.options) === null || _a === void 0 ? void 0 : _a.isValid;
        if (isValid) {
            return isValid(input, dependency);
        }
        return Promise.resolve(input ? true : false);
    }
}

;// ../../libs/tools/generator/core/src/integration/addy-io.ts




// default values
const defaultSettings = Object.freeze({
    token: "",
    domain: "",
    baseUrl: "",
});
// supported RPC calls
const createForwardingEmail = Object.freeze({
    url(_request, context) {
        return context.baseUrl() + "/api/v1/aliases";
    },
    body(request, context) {
        return {
            domain: context.emailDomain(),
            description: context.generatedBy(request, { extractHostname: true, maxLength: 200 }),
        };
    },
    hasJsonPayload(response) {
        return response.status === 200 || response.status === 201;
    },
    processJson(json) {
        var _a;
        return [(_a = json === null || json === void 0 ? void 0 : json.data) === null || _a === void 0 ? void 0 : _a.email];
    },
});
// forwarder configuration
const forwarder = Object.freeze({
    defaultSettings,
    createForwardingEmail,
    request: ["token", "baseUrl", "domain"],
    settingsConstraints: {
        token: { required: true },
        domain: { required: true },
        baseUrl: {},
    },
    local: {
        settings: {
            // FIXME: integration should issue keys at runtime
            // based on integrationId & extension metadata
            // e.g. key: "forwarder.AddyIo.local.settings",
            key: "addyIoForwarder",
            target: "object",
            format: "secret-state",
            frame: 512,
            classifier: new PrivateClassifier(),
            state: GENERATOR_DISK,
            initial: defaultSettings,
            options: {
                deserializer: (value) => value,
                clearOn: ["logout"],
            },
        },
        import: {
            key: "forwarder.AddyIo.local.import",
            target: "object",
            format: "plain",
            classifier: new PublicClassifier(["token", "baseUrl", "domain"]),
            state: GENERATOR_MEMORY,
            options: {
                deserializer: (value) => value,
                clearOn: ["logout", "lock"],
            },
        },
    },
    settings: new UserKeyDefinition(GENERATOR_DISK, "addyIoForwarder", {
        deserializer: (value) => value,
        clearOn: [],
    }),
    importBuffer: new BufferedKeyDefinition(GENERATOR_DISK, "addyIoBuffer", {
        deserializer: (value) => value,
        clearOn: ["logout"],
    }),
});
const AddyIo = Object.freeze({
    // integration
    id: "anonaddy",
    name: "Addy.io",
    extends: ["forwarder"],
    // hosting
    selfHost: "maybe",
    baseUrl: "https://app.addy.io",
    authenticate(_request, context) {
        return { Authorization: "Bearer " + context.authenticationToken() };
    },
    // extensions
    forwarder,
});

;// ../../libs/tools/generator/core/src/integration/duck-duck-go.ts




// default values
const duck_duck_go_defaultSettings = Object.freeze({
    token: "",
});
// supported RPC calls
const duck_duck_go_createForwardingEmail = Object.freeze({
    url(_request, context) {
        return context.baseUrl() + "/email/addresses";
    },
    body(_request, _context) {
        return undefined;
    },
    hasJsonPayload(response) {
        return response.status === 200 || response.status === 201;
    },
    processJson(json) {
        return [`${json.address}@duck.com`];
    },
});
// forwarder configuration
const duck_duck_go_forwarder = Object.freeze({
    defaultSettings: duck_duck_go_defaultSettings,
    createForwardingEmail: duck_duck_go_createForwardingEmail,
    request: ["token"],
    settingsConstraints: {
        token: { required: true },
    },
    local: {
        settings: {
            // FIXME: integration should issue keys at runtime
            // based on integrationId & extension metadata
            // e.g. key: "forwarder.DuckDuckGo.local.settings",
            key: "duckDuckGoForwarder",
            target: "object",
            format: "secret-state",
            frame: 512,
            classifier: new PrivateClassifier(),
            state: GENERATOR_DISK,
            initial: duck_duck_go_defaultSettings,
            options: {
                deserializer: (value) => value,
                clearOn: ["logout"],
            },
        },
        import: {
            key: "forwarder.DuckDuckGo.local.import",
            target: "object",
            format: "plain",
            classifier: new PublicClassifier(["token"]),
            state: GENERATOR_MEMORY,
            options: {
                deserializer: (value) => value,
                clearOn: ["logout", "lock"],
            },
        },
    },
    settings: new UserKeyDefinition(GENERATOR_DISK, "duckDuckGoForwarder", {
        deserializer: (value) => value,
        clearOn: [],
    }),
    importBuffer: new BufferedKeyDefinition(GENERATOR_DISK, "duckDuckGoBuffer", {
        deserializer: (value) => value,
        clearOn: ["logout"],
    }),
});
// integration-wide configuration
const DuckDuckGo = Object.freeze({
    id: "duckduckgo",
    name: "DuckDuckGo",
    baseUrl: "https://quack.duckduckgo.com/api",
    selfHost: "never",
    extends: ["forwarder"],
    authenticate(_request, context) {
        return { Authorization: "Bearer " + context.authenticationToken() };
    },
    forwarder: duck_duck_go_forwarder,
});

;// ../../libs/tools/generator/core/src/integration/fastmail.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore




// default values
const fastmail_defaultSettings = Object.freeze({
    domain: "",
    prefix: "",
    token: "",
});
// supported RPC calls
const getAccountId = Object.freeze({
    url(_request, context) {
        // cannot use "/.well-known/jmap" because integration RPCs
        // never follow redirects
        return context.baseUrl() + "/jmap/session";
    },
    hasJsonPayload(response) {
        return response.status === 200;
    },
    processJson(json, context) {
        var _a, _b;
        const result = (_b = (_a = json.primaryAccounts) === null || _a === void 0 ? void 0 : _a["https://www.fastmail.com/dev/maskedemail"]) !== null && _b !== void 0 ? _b : undefined;
        return [result, result ? undefined : context.missingAccountIdCause()];
    },
});
const fastmail_createForwardingEmail = Object.freeze({
    url(_request, context) {
        return context.baseUrl() + "/jmap/api/";
    },
    body(request, context) {
        const body = {
            using: ["https://www.fastmail.com/dev/maskedemail", "urn:ietf:params:jmap:core"],
            methodCalls: [
                [
                    "MaskedEmail/set",
                    {
                        accountId: request.accountId,
                        create: {
                            "new-masked-email": {
                                state: "enabled",
                                description: "",
                                forDomain: context.website(request),
                                emailPrefix: "",
                            },
                        },
                    },
                    "0",
                ],
            ],
        };
        return body;
    },
    hasJsonPayload(response) {
        return response.status === 200;
    },
    processJson(json) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
        if (json.methodResponses != null &&
            json.methodResponses.length > 0 &&
            json.methodResponses[0].length > 0) {
            if (json.methodResponses[0][0] === "MaskedEmail/set") {
                if (((_b = (_a = json.methodResponses[0][1]) === null || _a === void 0 ? void 0 : _a.created) === null || _b === void 0 ? void 0 : _b["new-masked-email"]) != null) {
                    const email = (_e = (_d = (_c = json.methodResponses[0][1]) === null || _c === void 0 ? void 0 : _c.created) === null || _d === void 0 ? void 0 : _d["new-masked-email"]) === null || _e === void 0 ? void 0 : _e.email;
                    return [email];
                }
                if (((_g = (_f = json.methodResponses[0][1]) === null || _f === void 0 ? void 0 : _f.notCreated) === null || _g === void 0 ? void 0 : _g["new-masked-email"]) != null) {
                    const errorDescription = (_k = (_j = (_h = json.methodResponses[0][1]) === null || _h === void 0 ? void 0 : _h.notCreated) === null || _j === void 0 ? void 0 : _j["new-masked-email"]) === null || _k === void 0 ? void 0 : _k.description;
                    return [undefined, errorDescription];
                }
            }
            else if (json.methodResponses[0][0] === "error") {
                const errorDescription = (_l = json.methodResponses[0][1]) === null || _l === void 0 ? void 0 : _l.description;
                return [undefined, errorDescription];
            }
        }
    },
});
// forwarder configuration
const fastmail_forwarder = Object.freeze({
    defaultSettings: fastmail_defaultSettings,
    createForwardingEmail: fastmail_createForwardingEmail,
    getAccountId,
    request: ["token"],
    settingsConstraints: {
        token: { required: true },
        domain: { required: true },
        prefix: {},
    },
    local: {
        settings: {
            // FIXME: integration should issue keys at runtime
            // based on integrationId & extension metadata
            // e.g. key: "forwarder.Fastmail.local.settings"
            key: "fastmailForwarder",
            target: "object",
            format: "secret-state",
            frame: 512,
            classifier: new PrivateClassifier(),
            state: GENERATOR_DISK,
            initial: fastmail_defaultSettings,
            options: {
                deserializer: (value) => value,
                clearOn: ["logout"],
            },
        },
        import: {
            key: "forwarder.Fastmail.local.import",
            target: "object",
            format: "plain",
            classifier: new PublicClassifier(["token"]),
            state: GENERATOR_MEMORY,
            options: {
                deserializer: (value) => value,
                clearOn: ["logout", "lock"],
            },
        },
    },
    settings: new UserKeyDefinition(GENERATOR_DISK, "fastmailForwarder", {
        deserializer: (value) => value,
        clearOn: [],
    }),
    importBuffer: new BufferedKeyDefinition(GENERATOR_DISK, "fastmailBuffer", {
        deserializer: (value) => value,
        clearOn: ["logout"],
    }),
});
// integration-wide configuration
const Fastmail = Object.freeze({
    id: "fastmail",
    name: "Fastmail",
    baseUrl: "https://api.fastmail.com",
    selfHost: "maybe",
    extends: ["forwarder"],
    authenticate(_request, context) {
        return { Authorization: "Bearer " + context.authenticationToken() };
    },
    forwarder: fastmail_forwarder,
});

;// ../../libs/tools/generator/core/src/integration/firefox-relay.ts




// default values
const firefox_relay_defaultSettings = Object.freeze({
    token: "",
});
// supported RPC calls
const firefox_relay_createForwardingEmail = Object.freeze({
    url(_request, context) {
        return context.baseUrl() + "/v1/relayaddresses/";
    },
    body(request, context) {
        return {
            enabled: true,
            generated_for: context.website(request, { maxLength: 255 }),
            description: context.generatedBy(request, { extractHostname: true, maxLength: 64 }),
        };
    },
    hasJsonPayload(response) {
        return response.status === 200 || response.status === 201;
    },
    processJson(json) {
        return [json.full_address];
    },
});
// forwarder configuration
const firefox_relay_forwarder = Object.freeze({
    defaultSettings: firefox_relay_defaultSettings,
    createForwardingEmail: firefox_relay_createForwardingEmail,
    request: ["token"],
    settingsConstraints: {
        token: { required: true },
    },
    local: {
        settings: {
            // FIXME: integration should issue keys at runtime
            // based on integrationId & extension metadata
            // e.g. key: "forwarder.Firefox.local.settings",
            key: "firefoxRelayForwarder",
            target: "object",
            format: "secret-state",
            frame: 512,
            classifier: new PrivateClassifier(),
            state: GENERATOR_DISK,
            initial: firefox_relay_defaultSettings,
            options: {
                deserializer: (value) => value,
                clearOn: ["logout"],
            },
        },
        import: {
            key: "forwarder.Firefox.local.import",
            target: "object",
            format: "plain",
            classifier: new PublicClassifier(["token"]),
            state: GENERATOR_MEMORY,
            options: {
                deserializer: (value) => value,
                clearOn: ["logout", "lock"],
            },
        },
    },
    settings: new UserKeyDefinition(GENERATOR_DISK, "firefoxRelayForwarder", {
        deserializer: (value) => value,
        clearOn: [],
    }),
    importBuffer: new BufferedKeyDefinition(GENERATOR_DISK, "firefoxRelayBuffer", {
        deserializer: (value) => value,
        clearOn: ["logout"],
    }),
});
// integration-wide configuration
const FirefoxRelay = Object.freeze({
    id: "firefoxrelay",
    name: "Firefox Relay",
    baseUrl: "https://relay.firefox.com/api",
    selfHost: "never",
    extends: ["forwarder"],
    authenticate(_request, context) {
        return { Authorization: "Token " + context.authenticationToken() };
    },
    forwarder: firefox_relay_forwarder,
});

;// ../../libs/tools/generator/core/src/integration/forward-email.ts




// default values
const forward_email_defaultSettings = Object.freeze({
    token: "",
    domain: "",
});
// supported RPC calls
const forward_email_createForwardingEmail = Object.freeze({
    url(_request, context) {
        const domain = context.emailDomain();
        return context.baseUrl() + `/v1/domains/${domain}/aliases`;
    },
    body(request, context) {
        return {
            labels: context.website(request),
            description: context.generatedBy(request),
        };
    },
    hasJsonPayload(response) {
        return response.status === 200 || response.status === 201;
    },
    processJson(json, context) {
        var _a;
        const { name, domain } = json;
        const domainPart = (_a = domain === null || domain === void 0 ? void 0 : domain.name) !== null && _a !== void 0 ? _a : context.emailDomain();
        return [`${name}@${domainPart}`];
    },
});
// forwarder configuration
const forward_email_forwarder = Object.freeze({
    defaultSettings: forward_email_defaultSettings,
    request: ["token", "domain"],
    settingsConstraints: {
        token: { required: true },
        domain: { required: true },
    },
    local: {
        settings: {
            // FIXME: integration should issue keys at runtime
            // based on integrationId & extension metadata
            // e.g. key: "forwarder.ForwardEmail.local.settings",
            key: "forwardEmailForwarder",
            target: "object",
            format: "secret-state",
            frame: 512,
            classifier: new PrivateClassifier(),
            state: GENERATOR_DISK,
            initial: forward_email_defaultSettings,
            options: {
                deserializer: (value) => value,
                clearOn: ["logout"],
            },
        },
        import: {
            key: "forwarder.ForwardEmail.local.import",
            target: "object",
            format: "plain",
            classifier: new PublicClassifier(["token", "domain"]),
            state: GENERATOR_MEMORY,
            options: {
                deserializer: (value) => value,
                clearOn: ["logout", "lock"],
            },
        },
    },
    settings: new UserKeyDefinition(GENERATOR_DISK, "forwardEmailForwarder", {
        deserializer: (value) => value,
        clearOn: [],
    }),
    importBuffer: new BufferedKeyDefinition(GENERATOR_DISK, "forwardEmailBuffer", {
        deserializer: (value) => value,
        clearOn: ["logout"],
    }),
    createForwardingEmail: forward_email_createForwardingEmail,
});
const ForwardEmail = Object.freeze({
    // integration metadata
    id: "forwardemail",
    name: "Forward Email",
    extends: ["forwarder"],
    // service provider
    selfHost: "never",
    baseUrl: "https://api.forwardemail.net",
    authenticate(_request, context) {
        return { Authorization: "Basic " + context.authenticationToken({ base64: true, suffix: ":" }) };
    },
    // specialized configurations
    forwarder: forward_email_forwarder,
});

;// ../../libs/tools/generator/core/src/integration/simple-login.ts




// default values
const simple_login_defaultSettings = Object.freeze({
    token: "",
    domain: "",
    baseUrl: "",
});
// supported RPC calls
const simple_login_createForwardingEmail = Object.freeze({
    url(request, context) {
        const endpoint = context.baseUrl() + "/api/alias/random/new";
        const hostname = context.website(request);
        const url = hostname !== "" ? `${endpoint}?hostname=${hostname}` : endpoint;
        return url;
    },
    body(request, context) {
        return { note: context.generatedBy(request) };
    },
    hasJsonPayload(response) {
        return response.status === 200 || response.status === 201;
    },
    processJson(json) {
        return [json === null || json === void 0 ? void 0 : json.alias];
    },
});
// forwarder configuration
const simple_login_forwarder = Object.freeze({
    defaultSettings: simple_login_defaultSettings,
    createForwardingEmail: simple_login_createForwardingEmail,
    request: ["token", "baseUrl"],
    settingsConstraints: {
        token: { required: true },
    },
    local: {
        settings: {
            // FIXME: integration should issue keys at runtime
            // based on integrationId & extension metadata
            // e.g. key: "forwarder.SimpleLogin.local.settings",
            key: "simpleLoginForwarder",
            target: "object",
            format: "secret-state",
            frame: 512,
            classifier: new PrivateClassifier(),
            state: GENERATOR_DISK,
            initial: simple_login_defaultSettings,
            options: {
                deserializer: (value) => value,
                clearOn: ["logout"],
            },
        },
        import: {
            key: "forwarder.SimpleLogin.local.import",
            target: "object",
            format: "plain",
            classifier: new PublicClassifier(["token", "baseUrl"]),
            state: GENERATOR_MEMORY,
            options: {
                deserializer: (value) => value,
                clearOn: ["logout", "lock"],
            },
        },
    },
    settings: new UserKeyDefinition(GENERATOR_DISK, "simpleLoginForwarder", {
        deserializer: (value) => value,
        clearOn: [],
    }),
    importBuffer: new BufferedKeyDefinition(GENERATOR_DISK, "simpleLoginBuffer", {
        deserializer: (value) => value,
        clearOn: ["logout"],
    }),
});
// integration-wide configuration
const SimpleLogin = Object.freeze({
    id: "simplelogin",
    name: "SimpleLogin",
    selfHost: "maybe",
    extends: ["forwarder"],
    baseUrl: "https://app.simplelogin.io",
    authenticate(_request, context) {
        return { Authentication: context.authenticationToken() };
    },
    forwarder: simple_login_forwarder,
});

;// ../../libs/tools/generator/core/src/data/integrations.ts






/** Fixed list of integrations available to the application
 *  @example
 *
 *  // Use `toCredentialGeneratorConfiguration(id :ForwarderIntegration)`
 *  // to convert an integration to a generator configuration
 *  const generator = toCredentialGeneratorConfiguration(Integrations.AddyIo);
 */
const integrations_Integrations = Object.freeze({
    AddyIo: AddyIo,
    DuckDuckGo: DuckDuckGo,
    Fastmail: Fastmail,
    FirefoxRelay: FirefoxRelay,
    ForwardEmail: ForwardEmail,
    SimpleLogin: SimpleLogin,
});
const integrations = new Map(Object.values(integrations_Integrations).map((i) => [i.id, i]));
function integrations_getForwarderConfiguration(id) {
    // these casts are for compatibility; `IntegrationId` is the old form of `VendorId`
    const maybeForwarder = integrations.get(id);
    if (maybeForwarder && "forwarder" in maybeForwarder) {
        return maybeForwarder;
    }
    else {
        return null;
    }
}

;// ../../libs/tools/generator/core/src/data/policies.ts

/** Policy configurations
 *  @deprecated use Generator.*.policy instead
 */
const Policies = Object.freeze({
    Passphrase: generators_Generators.passphrase.policy,
    Password: generators_Generators.password.policy,
});

;// ../../libs/tools/generator/core/src/data/username-digits.ts
const UsernameDigits = Object.freeze({
    enabled: 4,
    disabled: 0,
});

;// ../../libs/tools/generator/core/src/data/index.ts





















;// ../../libs/tools/generator/core/src/factories.ts
// contains logic that constructs generator services dynamically given
// a generator id.

function createRandomizer(keyService) {
    return new KeyServiceRandomizer(keyService);
}

;// ../../libs/tools/generator/core/src/services/default-generator.service.ts
var default_generator_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

/** {@link GeneratorServiceAbstraction} */
class DefaultGeneratorService {
    /** Instantiates the generator service
     * @param strategy tailors the service to a specific generator type
     *            (e.g. password, passphrase)
     * @param policy provides the policy to enforce
     */
    constructor(strategy, policy) {
        this.strategy = strategy;
        this.policy = policy;
        this._evaluators$ = new Map();
    }
    /** {@link GeneratorService.options$} */
    options$(userId) {
        return this.strategy.durableState(userId).state$;
    }
    /** {@link GeneratorService.defaults$} */
    defaults$(userId) {
        return this.strategy.defaults$(userId);
    }
    /** {@link GeneratorService.saveOptions} */
    saveOptions(userId, options) {
        return default_generator_service_awaiter(this, void 0, void 0, function* () {
            yield this.strategy.durableState(userId).update(() => options);
        });
    }
    /** {@link GeneratorService.evaluator$} */
    evaluator$(userId) {
        let evaluator$ = this._evaluators$.get(userId);
        if (!evaluator$) {
            evaluator$ = this.createEvaluator(userId);
            this._evaluators$.set(userId, evaluator$);
        }
        return evaluator$;
    }
    createEvaluator(userId) {
        const evaluator$ = this.policy.policiesByType$(this.strategy.policy, userId).pipe(
        // create the evaluator from the policies
        this.strategy.toEvaluator());
        return evaluator$;
    }
    /** {@link GeneratorService.enforcePolicy} */
    enforcePolicy(userId, options) {
        return default_generator_service_awaiter(this, void 0, void 0, function* () {
            const policy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.evaluator$(userId));
            const evaluated = policy.applyPolicy(options);
            const sanitized = policy.sanitize(evaluated);
            return sanitized;
        });
    }
    /** {@link GeneratorService.generate} */
    generate(options) {
        return default_generator_service_awaiter(this, void 0, void 0, function* () {
            return yield this.strategy.generate(options);
        });
    }
}

;// ../../libs/common/src/tools/integration/rpc/rest-client.ts
var rest_client_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
/** Makes remote procedure calls using a RESTful interface. */
class rest_client_RestClient {
    constructor(api, i18n) {
        this.api = api;
        this.i18n = i18n;
    }
    /** uses the fetch API to request a JSON payload. */
    // FIXME: once legacy password generator is removed, replace forwarder-specific error
    //   messages with RPC-generalized ones.
    fetchJson(rpc, params) {
        return rest_client_awaiter(this, void 0, void 0, function* () {
            // run the request
            const request = rpc.toRequest(params);
            const response = yield this.api.nativeFetch(request);
            let result = undefined;
            let errorKey = undefined;
            let errorMessage = undefined;
            const commonError = yield this.detectCommonErrors(response);
            if (commonError) {
                [errorKey, errorMessage] = commonError;
            }
            else if (rpc.hasJsonPayload(response)) {
                [result, errorMessage] = rpc.processJson(yield response.json());
            }
            if (result) {
                return result;
            }
            // handle failures
            errorKey !== null && errorKey !== void 0 ? errorKey : (errorKey = errorMessage ? "forwarderError" : "forwarderUnknownError");
            const error = this.i18n.t(errorKey, rpc.requestor.name, errorMessage);
            throw error;
        });
    }
    detectCommonErrors(response) {
        return rest_client_awaiter(this, void 0, void 0, function* () {
            if (response.status === 401) {
                const message = yield this.tryGetErrorMessage(response);
                const key = message ? "forwaderInvalidTokenWithMessage" : "forwaderInvalidToken";
                return [key, message];
            }
            else if (response.status === 403) {
                const message = yield this.tryGetErrorMessage(response);
                const key = message ? "forwaderInvalidOperationWithMessage" : "forwaderInvalidOperation";
                return [key, message];
            }
            else if (response.status >= 400) {
                const message = yield this.tryGetErrorMessage(response);
                const key = message ? "forwarderError" : "forwarderUnknownError";
                return [key, message];
            }
        });
    }
    tryGetErrorMessage(response) {
        return rest_client_awaiter(this, void 0, void 0, function* () {
            var _a, _b, _c;
            const body = (_a = (yield response.text())) !== null && _a !== void 0 ? _a : "";
            // nullish continues processing; false returns undefined
            // FIXME: inspect content-type header to determine extraction process
            const error = (_c = (_b = this.tryFindErrorAsJson(body)) !== null && _b !== void 0 ? _b : this.tryFindErrorAsText(body)) !== null && _c !== void 0 ? _c : response.statusText;
            return error || undefined;
        });
    }
    tryFindErrorAsJson(body) {
        var _a, _b, _c, _d, _e;
        // tryParse JSON object or string
        const parsable = body.startsWith("{") || body.startsWith(`'`) || body.startsWith(`"`);
        if (!parsable) {
            // fail-and-continue because it's not JSON
            return undefined;
        }
        let parsed = undefined;
        try {
            parsed = JSON.parse(body);
        }
        catch (_f) {
            // fail-and-exit in case `body` is malformed JSON
            return false;
        }
        // could be a string
        if (parsed && typeof parsed === "string") {
            return parsed;
        }
        // could be { error?: T, message?: U }
        const error = (_b = (_a = parsed.error) === null || _a === void 0 ? void 0 : _a.toString()) !== null && _b !== void 0 ? _b : null;
        const message = (_d = (_c = parsed.message) === null || _c === void 0 ? void 0 : _c.toString()) !== null && _d !== void 0 ? _d : null;
        // `false` signals no message found
        const result = error && message ? `${error}: ${message}` : ((_e = error !== null && error !== void 0 ? error : message) !== null && _e !== void 0 ? _e : false);
        return result;
    }
    tryFindErrorAsText(body) {
        if (!body.length || body.includes("<")) {
            return undefined;
        }
        return body;
    }
}

;// ../../libs/common/src/tools/integration/rpc/index.ts







;// ../../libs/common/src/tools/rx.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

/** Returns its input. */
function identity(value) {
    return value;
}
/** Combines its arguments into a plain old javascript object. */
function expectedAndActualValue(expectedValue, actualValue) {
    return {
        expectedValue,
        actualValue,
    };
}
/**
 * An observable operator that throws an error when the stream's
 *   value changes. Uses strict (`===`) comparison checks.
 * @param extract a function that identifies the member to compare;
 *   defaults to the identity function
 * @param error a function that packages the expected and failed
 *   values into an error.
 * @returns a stream of values that emits when the input emits,
 *   completes when the input completes, and errors when either the
 *   input errors or the comparison fails.
 */
function errorOnChange(extract = identity, error = expectedAndActualValue) {
    return pipe(startWith(null), pairwise(), map(([expected, actual], i) => {
        // always let the first value through
        if (i === 0) {
            return actual;
        }
        const expectedValue = extract(expected);
        const actualValue = extract(actual);
        // fail the stream if the state desyncs from its initial value
        if (expectedValue === actualValue) {
            return actual;
        }
        else {
            throw error(expectedValue, actualValue);
        }
    }));
}
/**
 * An observable operator that reduces an emitted collection to a single object,
 * returning a default if all items are ignored.
 * @param reduce The reduce function to apply to the filtered collection. The
 *  first argument is the accumulator, and the second is the current item. The
 *  return value is the new accumulator.
 * @param defaultValue The default value to return if the collection is empty. The
 *   default value is also the initial value of the accumulator.
 */
function rx_reduceCollection(reduce, defaultValue) {
    return (0,external_rxjs_namespaceObject.map)((values) => {
        const reduced = (values !== null && values !== void 0 ? values : []).reduce(reduce, structuredClone(defaultValue));
        return reduced;
    });
}
/**
 * An observable operator that emits distinct values by checking that all
 *   values in the previous entry match the next entry. This method emits
 *   when a key is added and does not when a key is removed.
 * @remarks This method checks objects. It does not check items in arrays.
 */
function rx_distinctIfShallowMatch() {
    return (0,external_rxjs_namespaceObject.distinctUntilChanged)((previous, current) => {
        let isDistinct = true;
        for (const key in current) {
            isDistinct && (isDistinct = previous[key] === current[key]);
        }
        return isDistinct;
    });
}
/** Create an observable that, once subscribed, emits `true` then completes when
 *   any input completes. If an input is already complete when the subscription
 *   occurs, it emits immediately.
 *  @param watch$ the observable(s) to watch for completion; if an array is passed,
 *   null and undefined members are ignored. If `watch$` is empty, `anyComplete`
 *   will never complete.
 *  @returns An observable that emits `true` when any of its inputs
 *   complete. The observable forwards the first error from its input.
 *  @remarks This method is particularly useful in combination with `takeUntil` and
 *   streams that are not guaranteed to complete on their own.
 */
function rx_anyComplete(watch$) {
    if (Array.isArray(watch$)) {
        const completes$ = watch$
            .filter((w$) => !!w$)
            .map((w$) => w$.pipe((0,external_rxjs_namespaceObject.ignoreElements)(), (0,external_rxjs_namespaceObject.endWith)(true)));
        const completed$ = (0,external_rxjs_namespaceObject.race)(completes$);
        return completed$;
    }
    else {
        return watch$.pipe((0,external_rxjs_namespaceObject.ignoreElements)(), (0,external_rxjs_namespaceObject.endWith)(true));
    }
}
/**
 * Create an observable that delays the input stream until all watches have
 *  emitted a value. The watched values are not included in the source stream.
 *  The last emission from the source is output when all the watches have
 *  emitted at least once.
 * @param watch$ the observable(s) to watch for readiness. If `watch$` is empty,
 *  `ready` will never emit.
 * @returns An observable that emits when the source stream emits. The observable
 *   errors if one of its watches completes before emitting. It also errors if one
 *   of its watches errors.
 */
function ready(watch$) {
    const watching$ = Array.isArray(watch$) ? watch$ : [watch$];
    return (0,external_rxjs_namespaceObject.pipe)((0,external_rxjs_namespaceObject.connect)((source$) => {
        // this subscription is safe because `source$` connects only after there
        // is an external subscriber.
        const source = new external_rxjs_namespaceObject.ReplaySubject(1);
        source$.subscribe(source);
        // `concat` is subscribed immediately after it's returned, at which point
        // `zip` blocks until all items in `watching$` are ready. If that occurs
        // after `source$` is hot, then the replay subject sends the last-captured
        // emission through immediately. Otherwise, `ready` waits for the next
        // emission
        return (0,external_rxjs_namespaceObject.concat)((0,external_rxjs_namespaceObject.zip)(watching$).pipe((0,external_rxjs_namespaceObject.first)(), (0,external_rxjs_namespaceObject.ignoreElements)()), source).pipe((0,external_rxjs_namespaceObject.takeUntil)(rx_anyComplete(source)));
    }));
}
function rx_withLatestReady(watch$) {
    return (0,external_rxjs_namespaceObject.connect)((source$) => {
        // these subscriptions are safe because `source$` connects only after there
        // is an external subscriber.
        const source = new external_rxjs_namespaceObject.ReplaySubject(1);
        source$.subscribe(source);
        const watch = new external_rxjs_namespaceObject.ReplaySubject(1);
        watch$.subscribe(watch);
        // `concat` is subscribed immediately after it's returned, at which point
        // `zip` blocks until all items in `watching$` are ready. If that occurs
        // after `source$` is hot, then the replay subject sends the last-captured
        // emission through immediately. Otherwise, `ready` waits for the next
        // emission
        return (0,external_rxjs_namespaceObject.concat)((0,external_rxjs_namespaceObject.zip)(watch).pipe((0,external_rxjs_namespaceObject.first)(), (0,external_rxjs_namespaceObject.ignoreElements)()), source).pipe((0,external_rxjs_namespaceObject.withLatestFrom)(watch), (0,external_rxjs_namespaceObject.takeUntil)(rx_anyComplete(source)));
    });
}
/**
 * Create an observable that emits the latest value of the source stream
 *  when `watch$` emits. If `watch$` emits before the stream emits, then
 *  an emission occurs as soon as a value becomes ready.
 * @param watch$ the observable that triggers emissions
 * @returns An observable that emits when `watch$` emits. The observable
 *  errors if its source stream errors. It also errors if `on` errors. It
 *  completes if its watch completes.
 *
 * @remarks This works like `audit`, but it repeats emissions when
 *  watch$ fires.
 */
function on(watch$) {
    return pipe(connect((source$) => {
        const source = new ReplaySubject(1);
        source$.subscribe(source);
        return watch$
            .pipe(ready(source), concatMap(() => source.pipe(first())))
            .pipe(takeUntil(rx_anyComplete(source)));
    }));
}
/** Create an observable that emits the first value from the source and
 *  throws if the observable emits another value.
 *  @param options.name names the pin to make discovering failing observables easier
 *  @param options.distinct compares two emissions with each other to determine whether
 *   the second emission is a duplicate. When this is specified, duplicates are ignored.
 *   When this isn't specified, any emission after the first causes the pin to throw
 *   an error.
 */
function pin(options) {
    return (0,external_rxjs_namespaceObject.pipe)((options === null || options === void 0 ? void 0 : options.distinct) ? (0,external_rxjs_namespaceObject.distinctUntilChanged)(options.distinct) : (i) => i, (0,external_rxjs_namespaceObject.map)((value, index) => {
        var _a, _b;
        if (index > 0) {
            throw new Error(`${(_b = (_a = options === null || options === void 0 ? void 0 : options.name) === null || _a === void 0 ? void 0 : _a.call(options)) !== null && _b !== void 0 ? _b : "unknown"} observable should only emit one value.`);
        }
        else {
            return value;
        }
    }));
}

;// ../../libs/common/src/tools/state/classified-format.ts
function isClassifiedFormat(value) {
    return (!!value &&
        "id" in value &&
        "secret" in value &&
        "disclosed" in value &&
        typeof value.secret === "string" &&
        typeof value.disclosed === "object");
}

;// ../../libs/common/src/tools/state/object-key.ts

/** Performs a type inference that identifies object keys. */
function isObjectKey(key) {
    return key.target === "object" && "format" in key && "classifier" in key;
}
/** Converts an object key to a plaform-compatible `UserKeyDefinition`. */
function toUserKeyDefinition(key) {
    if (key.format === "plain") {
        const plain = new UserKeyDefinition(key.state, key.key, key.options);
        return plain;
    }
    else if (key.format === "classified") {
        const classified = new UserKeyDefinition(key.state, key.key, {
            cleanupDelayMs: key.options.cleanupDelayMs,
            deserializer: (jsonValue) => jsonValue,
            clearOn: key.options.clearOn,
        });
        return classified;
    }
    else if (key.format === "secret-state") {
        const classified = new UserKeyDefinition(key.state, key.key, {
            cleanupDelayMs: key.options.cleanupDelayMs,
            deserializer: (jsonValue) => jsonValue,
            clearOn: key.options.clearOn,
        });
        return classified;
    }
    else {
        throw new Error(`unknown format: ${key.format}`);
    }
}

;// ../../libs/common/src/tools/state/state-constraints-dependency.ts
/** Returns `true` if the input constraint is a `DynamicStateConstraints<T>`.
 *  Otherwise, returns false.
 *  @param constraints the constraint to evaluate.
 * */
function isDynamic(constraints) {
    return constraints && "calibrate" in constraints;
}

;// ../../libs/common/src/tools/state/user-state-subject.ts
var user_state_subject_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore







// FIXME: The subject should always repeat the value when it's own `next` method is called.
//
// Chrome StateService only calls `next` when the underlying values changes. When enforcing,
// say, a minimum constraint, any value beneath the minimum becomes the minimum. This prevents
// invalid data received in sequence from calling `next` because the state provider doesn't
// emit.
//
// The hack is pretty simple. Insert arbitrary data into the saved data to ensure
// that it *always* changes.
//
// Any real fix will be fairly complex because it needs to recognize *fast* when it
// is waiting. Alternatively, the kludge could become a format properly fed by random noise.
//
// NOTE: this only matters for plaintext objects; encrypted fields change with every
//   update b/c their IVs change.
const ALWAYS_UPDATE_KLUDGE = "$^$ALWAYS_UPDATE_KLUDGE_PROPERTY$^$";
/** Default frame size for data packing */
const DEFAULT_FRAME_SIZE = 32;
/**
 * Adapt a state provider to an rxjs subject.
 *
 * This subject buffers the last value it received in memory. The buffer is erased
 * if the subject receives a complete or error event. It does not persist the buffer.
 *
 * Warning! The user state subject has a synchronous interface, but subscriptions are
 * always asynchronous.
 *
 * @template State the state stored by the subject
 * @template Dependencies use-specific dependencies provided by the user.
 */
class user_state_subject_UserStateSubject extends external_rxjs_namespaceObject.Observable {
    /**
     * Instantiates the user state subject bound to a persistent backing store
     * @param key identifies the persistent backing store
     * @param getState creates a persistent backing store using a key
     * @param context tailor the subject's behavior for a particular
     *   purpose.
     * @param dependencies.when$ blocks updates to the state subject until
     *   this becomes true. When this occurs, only the last-received update
     *   is applied. The blocked update is kept in memory. It does not persist
     *   to disk.
     * @param dependencies.account$ writes block until the account$
     *   is available.
     */
    constructor(key, providers, context) {
        var _a, _b, _c;
        super();
        this.key = key;
        this.providers = providers;
        this.context = context;
        // using subjects to ensure the right semantics are followed;
        // if greater efficiency becomes desirable, consider implementing
        // `SubjectLike` directly
        this.input = new external_rxjs_namespaceObject.ReplaySubject(1);
        this.output = new external_rxjs_namespaceObject.ReplaySubject(1);
        this.counter = 0;
        if (isObjectKey(this.key)) {
            // classification and encryption only supported with `ObjectKey`
            this.objectKey = this.key;
            this.stateKey = toUserKeyDefinition(this.key);
        }
        else {
            // raw state access granted with `UserKeyDefinition`
            this.objectKey = null;
            this.stateKey = this.key;
        }
        this.log = this.providers.log({
            contextId: this.contextId,
            type: "UserStateSubject",
            storage: {
                state: this.stateKey.stateDefinition.name,
                key: this.stateKey.key,
            },
        });
        // normalize dependencies
        const when$ = ((_a = this.context.when$) !== null && _a !== void 0 ? _a : new external_rxjs_namespaceObject.BehaviorSubject(true)).pipe((0,external_rxjs_namespaceObject.distinctUntilChanged)());
        const account$ = context.account$.pipe(pin({
            name: () => `${this.contextId} { account$ }`,
            distinct(prev, current) {
                return prev.id === current.id;
            },
        }), (0,external_rxjs_namespaceObject.shareReplay)({ refCount: true, bufferSize: 1 }));
        const encryptor$ = this.encryptor(account$);
        const constraints$ = ((_b = this.context.constraints$) !== null && _b !== void 0 ? _b : unconstrained$()).pipe((0,external_rxjs_namespaceObject.catchError)((e) => {
            this.log.error(e, "constraints$ dependency failed; using last-known constraints");
            return external_rxjs_namespaceObject.EMPTY;
        }), (0,external_rxjs_namespaceObject.shareReplay)({ refCount: true, bufferSize: 1 }));
        const dependencies$ = ((_c = this.context.dependencies$) !== null && _c !== void 0 ? _c : new external_rxjs_namespaceObject.BehaviorSubject(null)).pipe((0,external_rxjs_namespaceObject.shareReplay)({ refCount: true, bufferSize: 1 }));
        // load state once the account becomes available
        const userState$ = account$.pipe((0,external_rxjs_namespaceObject.tap)((account) => this.log.debug({ accountId: account.id }, "loading user state")), (0,external_rxjs_namespaceObject.map)((account) => this.providers.state.getUser(account.id, this.stateKey)), (0,external_rxjs_namespaceObject.shareReplay)({ refCount: true, bufferSize: 1 }));
        // wire output before input so that output normalizes the current state
        // before any `next` value is processed
        this.outputSubscription = userState$
            .pipe((0,external_rxjs_namespaceObject.switchMap)((userState) => userState.state$), this.declassify(encryptor$), this.adjust((0,external_rxjs_namespaceObject.combineLatestWith)(constraints$)), (0,external_rxjs_namespaceObject.takeUntil)(rx_anyComplete(account$)))
            .subscribe(this.output);
        const last$ = new external_rxjs_namespaceObject.ReplaySubject(1);
        this.output
            .pipe((0,external_rxjs_namespaceObject.last)(), (0,external_rxjs_namespaceObject.map)((o) => o.state))
            .subscribe(last$);
        // the update stream simulates the stateProvider's "shouldUpdate"
        // functionality & applies policy
        const updates$ = (0,external_rxjs_namespaceObject.concat)(this.input.pipe(this.when(when$), this.adjust(rx_withLatestReady(constraints$)), this.prepareUpdate(this, dependencies$)), 
        // when the output subscription completes, its last-emitted value
        // loops around to the input for finalization
        last$.pipe(this.fix(constraints$), this.prepareUpdate(last$, dependencies$)));
        // classification/encryption bound to the input subscription's lifetime
        // to ensure that `fix` has access to the encryptor key
        //
        // FIXME: this should probably timeout when a lock occurs
        this.inputSubscription = updates$
            .pipe(this.classify(encryptor$), (0,external_rxjs_namespaceObject.withLatestFrom)(userState$), (0,external_rxjs_namespaceObject.takeUntil)(rx_anyComplete([when$, this.input, encryptor$])))
            .subscribe({
            next: ([input, state]) => this.onNext(input, state),
            error: (e) => this.onError(e),
            complete: () => this.onComplete(),
        });
    }
    get contextId() {
        return `UserStateSubject(${this.stateKey.stateDefinition.name}, ${this.stateKey.key})`;
    }
    encryptor(account$) {
        var _a, _b;
        const singleUserId$ = account$.pipe((0,external_rxjs_namespaceObject.map)((account) => account.id));
        const frameSize = (_b = (_a = this.objectKey) === null || _a === void 0 ? void 0 : _a.frame) !== null && _b !== void 0 ? _b : DEFAULT_FRAME_SIZE;
        const encryptor$ = this.providers.encryptor.userEncryptor$(frameSize, { singleUserId$ }).pipe((0,external_rxjs_namespaceObject.tap)(() => this.log.debug("encryptor constructed")), (0,external_rxjs_namespaceObject.map)(({ encryptor }) => encryptor), (0,external_rxjs_namespaceObject.shareReplay)({ refCount: true, bufferSize: 1 }));
        return encryptor$;
    }
    when(when$) {
        return (0,external_rxjs_namespaceObject.pipe)((0,external_rxjs_namespaceObject.combineLatestWith)(when$.pipe((0,external_rxjs_namespaceObject.distinctUntilChanged)())), (0,external_rxjs_namespaceObject.tap)(([_, when]) => this.log.debug({ when }, "when status")), (0,external_rxjs_namespaceObject.filter)(([_, when]) => !!when), (0,external_rxjs_namespaceObject.map)(([input]) => input));
    }
    prepareUpdate(init$, dependencies$) {
        return (input$) => (0,external_rxjs_namespaceObject.concat)(
        // `init$` becomes the accumulator for `scan`
        init$.pipe((0,external_rxjs_namespaceObject.first)(), (0,external_rxjs_namespaceObject.map)((init) => [init, null])), input$.pipe((0,external_rxjs_namespaceObject.map)((constrained) => constrained.state), (0,external_rxjs_namespaceObject.withLatestFrom)(dependencies$))).pipe(
        // scan only emits values that can cause updates
        (0,external_rxjs_namespaceObject.scan)(([prev], [pending, dependencies]) => {
            var _a, _b, _c, _d, _e, _f;
            const shouldUpdate = (_c = (_b = (_a = this.context).shouldUpdate) === null || _b === void 0 ? void 0 : _b.call(_a, prev, pending, dependencies)) !== null && _c !== void 0 ? _c : true;
            if (shouldUpdate) {
                // actual update
                const next = (_f = (_e = (_d = this.context).nextValue) === null || _e === void 0 ? void 0 : _e.call(_d, prev, pending, dependencies)) !== null && _f !== void 0 ? _f : pending;
                return [next, dependencies];
            }
            else {
                // false update
                this.log.debug("shouldUpdate prevented write");
                return [prev, null];
            }
        }), 
        // the first emission primes `scan`s aggregator
        (0,external_rxjs_namespaceObject.skip)(1), (0,external_rxjs_namespaceObject.map)(([state]) => state), 
        // clean up false updates
        (0,external_rxjs_namespaceObject.distinctUntilChanged)());
    }
    adjust(withConstraints) {
        return (0,external_rxjs_namespaceObject.pipe)(
        // how constraints are blended with incoming emissions varies:
        // * `output` needs to emit when constraints update
        // * `input` needs to wait until a message flows through the pipe
        withConstraints, (0,external_rxjs_namespaceObject.map)(([loadedState, constraints]) => {
            var _a;
            if (!loadedState && !((_a = this.objectKey) === null || _a === void 0 ? void 0 : _a.initial)) {
                this.log.debug("no value; bypassing adjustment");
                return {
                    constraints: {},
                    state: null,
                };
            }
            this.log.debug("adjusting");
            const unconstrained = loadedState !== null && loadedState !== void 0 ? loadedState : structuredClone(this.objectKey.initial);
            const calibration = isDynamic(constraints)
                ? constraints.calibrate(unconstrained)
                : constraints;
            const adjusted = calibration.adjust(unconstrained);
            this.log.debug("adjusted");
            return {
                constraints: calibration.constraints,
                state: adjusted,
            };
        }));
    }
    fix(constraints$) {
        return (0,external_rxjs_namespaceObject.pipe)((0,external_rxjs_namespaceObject.combineLatestWith)(constraints$), (0,external_rxjs_namespaceObject.map)(([loadedState, constraints]) => {
            this.log.debug("fixing");
            const calibration = isDynamic(constraints)
                ? constraints.calibrate(loadedState)
                : constraints;
            const fixed = calibration.fix(loadedState);
            this.log.debug("fixed");
            return {
                constraints: calibration.constraints,
                state: fixed,
            };
        }));
    }
    declassify(encryptor$) {
        // short-circuit if they key lacks encryption support
        if (!this.objectKey || this.objectKey.format === "plain") {
            this.log.debug("key uses plain format; bypassing declassification");
            return (input$) => input$;
        }
        // all other keys support encryption; enable encryptor support
        return (0,external_rxjs_namespaceObject.pipe)(this.mapToClassifiedFormat(), (0,external_rxjs_namespaceObject.combineLatestWith)(encryptor$), (0,external_rxjs_namespaceObject.concatMap)((_a) => user_state_subject_awaiter(this, [_a], void 0, function* ([input, encryptor]) {
            // pass through null values
            if (input === null || input === undefined) {
                this.log.debug("no value; bypassing declassification");
                return null;
            }
            this.log.debug("declassifying");
            // decrypt classified data
            const { secret, disclosed } = input;
            const encrypted = enc_string_EncString.fromJSON(secret);
            const decryptedSecret = yield encryptor.decrypt(encrypted);
            // assemble into proper state
            const declassified = this.objectKey.classifier.declassify(disclosed, decryptedSecret);
            const state = this.objectKey.options.deserializer(declassified);
            this.log.debug("declassified");
            return state;
        })));
    }
    mapToClassifiedFormat() {
        // FIXME: warn when data is dropped in the console and/or report an error
        //   through the observable; consider redirecting dropped data to a recovery
        //   location
        // user-state subject's default format is object-aware
        if (this.objectKey && this.objectKey.format === "classified") {
            return (0,external_rxjs_namespaceObject.map)((input) => {
                if (!isClassifiedFormat(input)) {
                    this.log.warn("classified data must be in classified format; dropping");
                    return null;
                }
                return input;
            });
        }
        // secret state's format wraps objects in an array
        if (this.objectKey && this.objectKey.format === "secret-state") {
            return (0,external_rxjs_namespaceObject.map)((input) => {
                if (!Array.isArray(input)) {
                    this.log.warn("secret-state requires array formatting; dropping");
                    return null;
                }
                const [unwrapped] = input;
                if (!isClassifiedFormat(unwrapped)) {
                    this.log.warn("unwrapped secret-state must be in classified format; dropping");
                    return null;
                }
                return unwrapped;
            });
        }
        this.log.panic({ format: this.objectKey.format }, "unsupported serialization format");
    }
    classify(encryptor$) {
        // short-circuit if they key lacks encryption support; `encryptor` is
        // readied to preserve `dependencies.singleUserId$` emission contract
        if (!this.objectKey || this.objectKey.format === "plain") {
            this.log.debug("key uses plain format; bypassing classification");
            return (0,external_rxjs_namespaceObject.pipe)(ready(encryptor$), (0,external_rxjs_namespaceObject.map)((input) => input));
        }
        // all other keys support encryption; enable encryptor support
        return (0,external_rxjs_namespaceObject.pipe)(rx_withLatestReady(encryptor$), (0,external_rxjs_namespaceObject.concatMap)((_a) => user_state_subject_awaiter(this, [_a], void 0, function* ([input, encryptor]) {
            // fail fast if there's no value
            if (input === null || input === undefined) {
                this.log.debug("no value; bypassing classification");
                return null;
            }
            this.log.debug("classifying");
            // split data by classification level
            const serialized = JSON.parse(JSON.stringify(input));
            const classified = this.objectKey.classifier.classify(serialized);
            // protect data
            const encrypted = yield encryptor.encrypt(classified.secret);
            const secret = JSON.parse(JSON.stringify(encrypted));
            // wrap result in classified format envelope for storage
            const envelope = {
                id: null,
                secret,
                disclosed: classified.disclosed,
            };
            this.log.debug("classified");
            // deliberate type erasure; the type is restored during `declassify`
            return envelope;
        })), this.mapToStorageFormat());
    }
    mapToStorageFormat() {
        // user-state subject's default format is object-aware
        if (this.objectKey && this.objectKey.format === "classified") {
            return (0,external_rxjs_namespaceObject.map)((input) => input);
        }
        // secret state's format wraps objects in an array
        if (this.objectKey && this.objectKey.format === "secret-state") {
            return (0,external_rxjs_namespaceObject.map)((input) => [input]);
        }
        this.log.panic({ format: this.objectKey.format }, "unsupported serialization format");
    }
    next(value) {
        var _a;
        (_a = this.input) === null || _a === void 0 ? void 0 : _a.next(value);
    }
    error(err) {
        var _a;
        (_a = this.input) === null || _a === void 0 ? void 0 : _a.error(err);
    }
    complete() {
        var _a;
        (_a = this.input) === null || _a === void 0 ? void 0 : _a.complete();
    }
    /** Subscribe to the subject's event stream
     * @param observer listening for events
     * @returns the subscription
     */
    subscribe(observer) {
        return this.output.pipe((0,external_rxjs_namespaceObject.map)((wc) => wc.state)).subscribe(observer);
    }
    /** A stream containing settings and their last-applied constraints. */
    get withConstraints$() {
        return this.output.asObservable();
    }
    onNext(value, state) {
        state
            .update(() => {
            this.log.debug("updating");
            if (typeof value === "object") {
                // related: ALWAYS_UPDATE_KLUDGE FIXME
                const counter = this.counter++;
                if (counter > Number.MAX_SAFE_INTEGER) {
                    this.counter = 0;
                }
                const kludge = Object.assign({}, value);
                kludge[ALWAYS_UPDATE_KLUDGE] = counter;
            }
            this.log.debug("updated");
            return value;
        })
            .catch((e) => {
            this.log.error(e, "updating failed");
            this.onError(e);
        });
    }
    onError(value) {
        if (!this.isDisposed) {
            this.log.debug(value, "forwarding error to subscribers");
            this.output.error(value);
        }
        this.dispose();
    }
    onComplete() {
        if (!this.isDisposed) {
            this.output.complete();
        }
        this.dispose();
    }
    get isDisposed() {
        return this.input === null;
    }
    dispose() {
        var _a, _b;
        if (!this.isDisposed) {
            this.log.debug("disposing");
            // clean up internal subscriptions
            (_a = this.inputSubscription) === null || _a === void 0 ? void 0 : _a.unsubscribe();
            (_b = this.outputSubscription) === null || _b === void 0 ? void 0 : _b.unsubscribe();
            this.inputSubscription = null;
            this.outputSubscription = null;
            // drop input to ensure its value is removed from memory
            this.input = null;
            this.log.debug("disposed");
        }
    }
}

;// ../../libs/tools/generator/core/src/policies/available-algorithms-policy.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore


/** Reduces policies to a set of available algorithms
 *  @param policies the policies to reduce
 *  @returns the resulting `AlgorithmAvailabilityPolicy`
 */
function available_algorithms_policy_availableAlgorithms(policies) {
    const overridePassword = policies
        .filter((policy) => policy.type === PolicyType.PasswordGenerator && policy.enabled)
        .reduce((type, policy) => { var _a; return (type === "password" ? type : ((_a = policy.data.overridePasswordType) !== null && _a !== void 0 ? _a : type)); }, null);
    const policy = [...EmailAlgorithms, ...UsernameAlgorithms];
    if (overridePassword) {
        policy.push(overridePassword);
    }
    else {
        policy.push(...PasswordAlgorithms);
    }
    return policy;
}
/** Reduces policies to a set of available algorithms
 *  @param policies the policies to reduce
 *  @returns the resulting `AlgorithmAvailabilityPolicy`
 */
function availableAlgorithms_vNext(policies) {
    const overridePassword = policies
        .filter((policy) => policy.type === PolicyType.PasswordGenerator && policy.enabled)
        .reduce((type, policy) => { var _a; return (type === "password" ? type : ((_a = policy.data.overridePasswordType) !== null && _a !== void 0 ? _a : type)); }, null);
    const policy = [...EmailAlgorithms, ...UsernameAlgorithms];
    if (overridePassword) {
        policy.push(overridePassword);
    }
    else {
        policy.push(...PasswordAlgorithms);
    }
    return policy;
}

;// ../../libs/tools/generator/core/src/rx.ts



/** Maps an administrative console policy to a policy evaluator using the provided configuration.
 *  @param configuration the configuration that constructs the evaluator.
 */
function mapPolicyToEvaluator(configuration) {
    return (0,external_rxjs_namespaceObject.pipe)(rx_reduceCollection(configuration.combine, configuration.disabledValue), rx_distinctIfShallowMatch(), (0,external_rxjs_namespaceObject.map)(configuration.createEvaluator));
}
/** Maps an administrative console policy to constraints using the provided configuration.
 *  @param configuration the configuration that constructs the constraints.
 */
function rx_mapPolicyToConstraints(configuration, email) {
    return pipe(reduceCollection(configuration.combine, configuration.disabledValue), distinctIfShallowMatch(), map((policy) => configuration.toConstraints(policy, email)));
}
/** Constructs a method that maps a policy to the default (no-op) policy. */
function newDefaultEvaluator() {
    return () => {
        return (0,external_rxjs_namespaceObject.pipe)((0,external_rxjs_namespaceObject.map)((_) => new default_policy_evaluator_DefaultPolicyEvaluator()));
    };
}

;// ../../libs/tools/generator/core/src/services/credential-preferences.ts


/** plaintext password generation options */
const credential_preferences_PREFERENCES = new UserKeyDefinition(GENERATOR_DISK, "credentialPreferences", {
    deserializer: (value) => {
        var _a, _b;
        const result = (_a = value) !== null && _a !== void 0 ? _a : {};
        for (const key in DefaultCredentialPreferences) {
            // bind `key` to `category` to transmute the type
            const category = key;
            const preference = (_b = result[category]) !== null && _b !== void 0 ? _b : Object.assign({}, DefaultCredentialPreferences[category]);
            if (typeof preference.updated === "string") {
                preference.updated = new Date(preference.updated);
            }
            result[category] = preference;
        }
        return result;
    },
    clearOn: ["logout"],
});

;// ../../libs/tools/generator/core/src/services/credential-generator.service.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore










class CredentialGeneratorService {
    constructor(randomizer, policyService, apiService, i18nService, providers) {
        this.randomizer = randomizer;
        this.policyService = policyService;
        this.apiService = apiService;
        this.i18nService = i18nService;
        this.providers = providers;
    }
    getDependencyProvider() {
        return {
            client: new RestClient(this.apiService, this.i18nService),
            i18nService: this.i18nService,
            randomizer: this.randomizer,
        };
    }
    // FIXME: the rxjs methods of this service can be a lot more resilient if
    // `Subjects` are introduced where sharing occurs
    /** Generates a stream of credentials
     * @param configuration determines which generator's settings are loaded
     * @param dependencies.on$ Required. A new credential is emitted when this emits.
     */
    generate$(configuration, dependencies) {
        const engine = configuration.engine.create(this.getDependencyProvider());
        const settings$ = this.settings$(configuration, dependencies);
        // generation proper
        const generate$ = dependencies.on$.pipe(withLatestReady(settings$), concatMap(([request, settings]) => engine.generate(request, settings)), takeUntil(anyComplete([settings$])));
        return generate$;
    }
    algorithms$(category, dependencies) {
        // any cast required here because TypeScript fails to bind `category`
        // to the union-typed overload of `algorithms`.
        const algorithms = this.algorithms(category);
        // apply policy
        const algorithms$ = dependencies.account$.pipe(distinctUntilChanged(), switchMap((account) => {
            const policies$ = this.policyService
                .policiesByType$(PolicyType.PasswordGenerator, account.id)
                .pipe(map((p) => new Set(availableAlgorithms(p))), 
            // complete policy emissions otherwise `switchMap` holds `algorithms$` open indefinitely
            takeUntil(anyComplete(dependencies.account$)));
            return policies$;
        }), map((available) => {
            const filtered = algorithms.filter((c) => isForwarderIntegration(c.id) || available.has(c.id));
            return filtered;
        }));
        return algorithms$;
    }
    algorithms(category) {
        const categories = Array.isArray(category) ? category : [category];
        const algorithms = categories
            .flatMap((c) => CredentialCategories[c])
            .map((id) => this.algorithm(id))
            .filter((info) => info !== null);
        const forwarders = Object.keys(Integrations)
            .map((key) => {
            const forwarder = { forwarder: Integrations[key].id };
            return this.algorithm(forwarder);
        })
            .filter((forwarder) => categories.includes(forwarder.category));
        return algorithms.concat(forwarders);
    }
    /** Look up the metadata for a specific generator algorithm
     *  @param id identifies the algorithm
     *  @returns the requested metadata, or `null` if the metadata wasn't found.
     */
    algorithm(id) {
        let generator = null;
        let integration = null;
        if (isForwarderIntegration(id)) {
            const forwarderConfig = getForwarderConfiguration(id.forwarder);
            integration = forwarderConfig;
            if (forwarderConfig) {
                generator = toCredentialGeneratorConfiguration(forwarderConfig);
            }
        }
        else {
            generator = Generators[id];
        }
        if (!generator) {
            throw new Error(`Invalid credential algorithm: ${JSON.stringify(id)}`);
        }
        const info = {
            id: generator.id,
            category: generator.category,
            name: integration ? integration.name : this.i18nService.t(generator.nameKey),
            generate: this.i18nService.t(generator.generateKey),
            onGeneratedMessage: this.i18nService.t(generator.onGeneratedMessageKey),
            credentialType: this.i18nService.t(generator.credentialTypeKey),
            copy: this.i18nService.t(generator.copyKey),
            useGeneratedValue: this.i18nService.t(generator.useGeneratedValueKey),
            onlyOnRequest: generator.onlyOnRequest,
            request: generator.request,
        };
        if (generator.descriptionKey) {
            info.description = this.i18nService.t(generator.descriptionKey);
        }
        return info;
    }
    /** Get the settings for the provided configuration
     * @param configuration determines which generator's settings are loaded
     * @param dependencies.account$ identifies the account to which the settings are bound.
     * @returns an observable that emits settings
     * @remarks the observable enforces policies on the settings
     */
    settings$(configuration, dependencies) {
        const constraints$ = this.policy$(configuration, dependencies);
        const settings = new UserStateSubject(configuration.settings.account, this.providers, {
            constraints$,
            account$: dependencies.account$,
        });
        const settings$ = settings.pipe(map((settings) => settings !== null && settings !== void 0 ? settings : structuredClone(configuration.settings.initial)));
        return settings$;
    }
    /** Get a subject bound to credential generator preferences.
     *  @param dependencies.account$ identifies the account to which the preferences are bound
     *  @returns a subject bound to the user's preferences
     *  @remarks Preferences determine which algorithms are used when generating a
     *   credential from a credential category (e.g. `PassX` or `Username`). Preferences
     *   should not be used to hold navigation history. Use @bitwarden/generator-navigation
     *   instead.
     */
    preferences(dependencies) {
        // FIXME: enforce policy
        const subject = new UserStateSubject(PREFERENCES, this.providers, dependencies);
        return subject;
    }
    /** Get a subject bound to a specific user's settings
     * @param configuration determines which generator's settings are loaded
     * @param dependencies.account$ identifies the account to which the settings are bound
     * @returns a subject bound to the requested user's generator settings
     * @remarks the subject enforces policy for the settings
     */
    settings(configuration, dependencies) {
        const constraints$ = this.policy$(configuration, dependencies);
        const subject = new UserStateSubject(configuration.settings.account, this.providers, {
            constraints$,
            account$: dependencies.account$,
        });
        return subject;
    }
    /** Get the policy constraints for the provided configuration
     *  @param dependencies.account$ determines which user's policy is loaded
     *  @returns an observable that emits the policy once `dependencies.account$`
     *   and the policy become available.
     */
    policy$(configuration, dependencies) {
        const constraints$ = dependencies.account$.pipe(map((account) => {
            if (account.emailVerified) {
                return { userId: account.id, email: account.email };
            }
            return { userId: account.id, email: null };
        }), switchMap(({ userId, email }) => {
            // complete policy emissions otherwise `switchMap` holds `policies$` open indefinitely
            const policies$ = this.policyService
                .policiesByType$(configuration.policy.type, userId)
                .pipe(mapPolicyToConstraints(configuration.policy, email), takeUntil(anyComplete(dependencies.account$)));
            return policies$;
        }));
        return constraints$;
    }
}

;// ../../libs/tools/generator/core/src/services/index.ts



;// ../../libs/tools/generator/core/src/integration/index.ts







;// ../../libs/common/src/tools/cryptography/user-encryptor.abstraction.ts
/** An encryption strategy that protects a type's secrets with
 *  user-specific keys. This strategy is bound to a specific user.
 */
class UserEncryptor {
}

;// ../../libs/common/src/tools/cryptography/user-key-encryptor.ts
var user_key_encryptor_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

/** A classification strategy that protects a type's secrets by encrypting them
 *  with a `UserKey`
 */
class UserKeyEncryptor extends UserEncryptor {
    /** Instantiates the encryptor
     *  @param userId identifies the user bound to the encryptor.
     *  @param encryptService protects properties of `Secret`.
     *  @param keyService looks up the user key when protecting data.
     *  @param dataPacker packs and unpacks data classified as secrets.
     */
    constructor(userId, encryptService, key, dataPacker) {
        super();
        this.userId = userId;
        this.encryptService = encryptService;
        this.key = key;
        this.dataPacker = dataPacker;
        this.assertHasValue("userId", userId);
        this.assertHasValue("key", key);
        this.assertHasValue("dataPacker", dataPacker);
        this.assertHasValue("encryptService", encryptService);
    }
    encrypt(secret) {
        return user_key_encryptor_awaiter(this, void 0, void 0, function* () {
            this.assertHasValue("secret", secret);
            let packed = this.dataPacker.pack(secret);
            const encrypted = yield this.encryptService.encryptString(packed, this.key);
            packed = null;
            return encrypted;
        });
    }
    decrypt(secret) {
        return user_key_encryptor_awaiter(this, void 0, void 0, function* () {
            this.assertHasValue("secret", secret);
            let decrypted = yield this.encryptService.decryptString(secret, this.key);
            const unpacked = this.dataPacker.unpack(decrypted);
            decrypted = null;
            return unpacked;
        });
    }
    assertHasValue(name, value) {
        if (value === undefined || value === null) {
            throw new Error(`${name} cannot be null or undefined`);
        }
    }
}

;// ../../libs/common/src/tools/state/buffered-state.ts
var buffered_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

/** Stateful storage that overwrites one state with a buffered state.
 *  When a overwrite occurs, the input state is automatically deleted.
 *  @remarks The buffered state can only overwrite non-nullish values. If the
 *   buffer key contains `null` or `undefined`, it will do nothing.
 */
class BufferedState {
    /**
     * Instantiate a buffered state
     * @param provider constructs the buffer.
     * @param key defines the buffer location.
     * @param output updates when a overwrite occurs
     * @param dependency$ provides data the buffer depends upon to evaluate and
     *   transform its data. If this is omitted, then `true` is injected as
     *   a dependency, which with a default output will trigger a overwrite immediately.
     *
     * @remarks `dependency$` enables overwrite control during dynamic circumstances,
     *   such as when a overwrite should occur only if a user key is available.
     */
    constructor(provider, key, output, dependency$ = null) {
        this.key = key;
        this.output = output;
        this.bufferedState = provider.getUser(output.userId, key.toKeyDefinition());
        // overwrite the output value
        const hasValue$ = (0,external_rxjs_namespaceObject.concat)((0,external_rxjs_namespaceObject.of)(null), this.bufferedState.state$).pipe((0,external_rxjs_namespaceObject.map)((buffer) => (buffer !== null && buffer !== void 0 ? buffer : null) !== null));
        const overwriteDependency$ = (dependency$ !== null && dependency$ !== void 0 ? dependency$ : (0,external_rxjs_namespaceObject.of)(true)).pipe((0,external_rxjs_namespaceObject.map)((dependency) => [key.shouldOverwrite(dependency), dependency]));
        const overwrite$ = (0,external_rxjs_namespaceObject.combineLatest)([hasValue$, overwriteDependency$]).pipe((0,external_rxjs_namespaceObject.concatMap)((_a) => buffered_state_awaiter(this, [_a], void 0, function* ([hasValue, [shouldOverwrite, dependency]]) {
            if (hasValue && shouldOverwrite) {
                yield this.overwriteOutput(dependency);
            }
            return [false, null];
        })));
        // drive overwrites only when there's a subscription;
        // the output state determines when emissions occur
        const output$ = this.output.state$.pipe((0,external_rxjs_namespaceObject.map)((output) => [true, output]));
        this.state$ = (0,external_rxjs_namespaceObject.merge)(overwrite$, output$).pipe((0,external_rxjs_namespaceObject.filter)(([emit]) => emit), (0,external_rxjs_namespaceObject.map)(([, output]) => output));
        this.combinedState$ = this.state$.pipe((0,external_rxjs_namespaceObject.map)((state) => [this.output.userId, state]));
        this.bufferedState$ = this.bufferedState.state$;
    }
    overwriteOutput(dependency) {
        return buffered_state_awaiter(this, void 0, void 0, function* () {
            // take the latest value from the buffer
            let buffered;
            yield this.bufferedState.update((state) => {
                buffered = state !== null && state !== void 0 ? state : null;
                return null;
            });
            // update the output state
            const isValid = yield this.key.isValid(buffered, dependency);
            if (isValid) {
                const output = yield this.key.map(buffered, dependency);
                yield this.output.update(() => output);
            }
        });
    }
    /** {@link SingleUserState.userId} */
    get userId() {
        return this.output.userId;
    }
    /** Buffers a value state. The buffered state overwrites the output
     *  state when a subscription occurs.
     *  @param value the state to roll over. Setting this to `null` or `undefined`
     *  has no effect.
     */
    buffer(value) {
        return buffered_state_awaiter(this, void 0, void 0, function* () {
            const normalized = value !== null && value !== void 0 ? value : null;
            if (normalized !== null) {
                yield this.bufferedState.update(() => normalized);
            }
        });
    }
    /** Updates the output state.
     *  @param configureState a callback that returns an updated output
     *   state. The callback receives the state's present value as its
     *   first argument and the dependencies listed in `options.combinedLatestWith`
     *   as its second argument.
     *  @param options configures how the update is applied. See {@link StateUpdateOptions}.
     */
    update(configureState, options = null) {
        return this.output.update(configureState, options);
    }
}

;// ../../libs/common/src/tools/state/data-packer.abstraction.ts
/** A packing strategy that packs data into a string.
 */
class DataPacker {
}

;// ../../libs/common/src/tools/state/padded-data-packer.ts


const DATA_PACKING = Object.freeze({
    /** The character to use for padding. */
    padding: "0",
    /** The character dividing packed data. */
    divider: "|",
    /** A regular expression for detecting invalid padding. When the character
     *  changes, this should be updated to include the new padding pattern.
     */
    hasInvalidPadding: /[^0]/,
});
/** A packing strategy that conceals the length of secret data by padding it
 *  to a multiple of the frame size.
 *  @example
 *  // packed === "24|e2Zvbzp0cnVlfQ==|0000"
 *  const packer = new SecretPacker(24);
 *  const packed = packer.pack({ foo: true });
 */
class PaddedDataPacker extends DataPacker {
    /** Instantiates the padded data packer
     *  @param frameSize The size of the dataframe used to pad encrypted values.
     */
    constructor(frameSize) {
        super();
        this.frameSize = frameSize;
    }
    /**
     * Packs value into a string format that conceals the length by obscuring it
     * with the frameSize.
     * @see {@link DataPackerAbstraction.unpack}
     */
    pack(value) {
        // encode the value
        const json = JSON.stringify(value);
        const b64 = utils_Utils.fromUtf8ToB64(json);
        // calculate packing metadata
        const frameSize = JSON.stringify(this.frameSize);
        const separatorLength = 2 * DATA_PACKING.divider.length; // there are 2 separators
        const payloadLength = b64.length + frameSize.length + separatorLength;
        const paddingLength = this.frameSize - (payloadLength % this.frameSize);
        // pack the data, thereby concealing its length
        const padding = DATA_PACKING.padding.repeat(paddingLength);
        const packed = `${frameSize}|${b64}|${padding}`;
        return packed;
    }
    /** {@link DataPackerAbstraction.unpack} */
    unpack(secret) {
        // frame size is stored before the JSON payload in base 10
        const frameEndIndex = secret.indexOf(DATA_PACKING.divider);
        if (frameEndIndex < 1) {
            throw new Error("missing frame size");
        }
        const frameSize = parseInt(secret.slice(0, frameEndIndex), 10);
        const dataStartIndex = frameEndIndex + 1;
        // The decrypted string should be a multiple of the frame length
        if (secret.length % frameSize > 0) {
            throw new Error("invalid length");
        }
        // encoded data terminates with the divider, followed by the padding character
        const dataEndIndex = secret.lastIndexOf(DATA_PACKING.divider);
        if (dataEndIndex == frameEndIndex) {
            throw new Error("missing json object");
        }
        const paddingStartIndex = dataEndIndex + 1;
        // If the padding contains invalid padding characters then the padding could be used
        // as a side channel for arbitrary data.
        if (secret.slice(paddingStartIndex).match(DATA_PACKING.hasInvalidPadding)) {
            throw new Error("invalid padding");
        }
        // remove frame size and padding
        const b64 = secret.slice(dataStartIndex, dataEndIndex);
        // unpack the stored data
        const json = utils_Utils.fromB64ToUtf8(b64);
        const unpacked = JSON.parse(json);
        return unpacked;
    }
}

;// ../../libs/common/src/tools/state/secret-key-definition.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

/** Encryption and storage settings for data stored by a `SecretState`.
 */
class SecretKeyDefinition {
    constructor(stateDefinition, key, classifier, options, 
    // type erasure is necessary here because typescript doesn't support
    // higher kinded types that generalize over collections. The invariants
    // needed to make this typesafe are maintained by the static factories.
    deconstruct, reconstruct) {
        this.stateDefinition = stateDefinition;
        this.key = key;
        this.classifier = classifier;
        this.options = options;
        this.deconstruct = deconstruct;
        this.reconstruct = reconstruct;
    }
    /** Converts the secret key to the `KeyDefinition` used for secret storage. */
    toEncryptedStateKey() {
        const secretKey = new UserKeyDefinition(this.stateDefinition, this.key, {
            cleanupDelayMs: this.options.cleanupDelayMs,
            deserializer: (jsonValue) => jsonValue,
            // Clear encrypted state on logout
            clearOn: this.options.clearOn,
        });
        return secretKey;
    }
    /**
     * Define a secret state for a single value
     * @param stateDefinition The domain of the secret's durable state.
     * @param key Domain key that identifies the stored value. This key must not be reused
     *    in any capacity.
     * @param classifier Partitions the value into encrypted, discarded, and public data.
     * @param options Configures the operation of the secret state.
     */
    static value(stateDefinition, key, classifier, options) {
        return new SecretKeyDefinition(stateDefinition, key, classifier, options, (value) => [[null, value]], ([[, inner]]) => inner);
    }
    /**
     * Define a secret state for an array of values. Each item is encrypted separately.
     * @param stateDefinition The domain of the secret's durable state.
     * @param key Domain key that identifies the stored items. This key must not be reused
     *    in any capacity.
     * @param classifier Partitions each item into encrypted, discarded, and public data.
     * @param options Configures the operation of the secret state.
     */
    static array(stateDefinition, key, classifier, options) {
        return new SecretKeyDefinition(stateDefinition, key, classifier, options, (value) => value.map((v, id) => [id, v]), (values) => values.map(([, v]) => v));
    }
    /**
     * Define a secret state for a record. Each property is encrypted separately.
     * @param stateDefinition The domain of the secret's durable state.
     * @param key Domain key that identifies the stored properties. This key must not be reused
     *    in any capacity.
     * @param classifier Partitions each property into encrypted, discarded, and public data.
     * @param options Configures the operation of the secret state.
     */
    static record(stateDefinition, key, classifier, options) {
        return new SecretKeyDefinition(stateDefinition, key, classifier, options, (value) => Object.entries(value), (values) => Object.fromEntries(values));
    }
}

;// ../../libs/common/src/tools/state/secret-state.ts
var secret_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore


const ONE_MINUTE = 1000 * 60;
/** Stores account-specific secrets protected by a UserKeyEncryptor.
 *
 *  @remarks This state store changes the structure of `Plaintext` during
 *  storage, and requires user keys to operate. It is incompatible with sync,
 *  which expects the disk storage format to be identical to the sync format.
 *
 *  DO NOT USE THIS for synchronized data.
 */
class SecretState {
    // The constructor is private to avoid creating a circular dependency when
    // wiring the derived and secret states together.
    constructor(key, $encryptor, userId, provider) {
        this.key = key;
        this.$encryptor = $encryptor;
        // construct the backing store
        this.encryptedState = provider.getUser(userId, key.toEncryptedStateKey());
        // cache plaintext
        this.combinedState$ = (0,external_rxjs_namespaceObject.combineLatest)([this.encryptedState.combinedState$, this.$encryptor]).pipe((0,external_rxjs_namespaceObject.concatMap)((_a) => secret_state_awaiter(this, [_a], void 0, function* ([[userId, state], encryptor]) { return [userId, yield this.declassifyAll(encryptor, state)]; })), (0,external_rxjs_namespaceObject.share)({
            connector: () => {
                return new external_rxjs_namespaceObject.ReplaySubject(1);
            },
            resetOnRefCountZero: () => { var _a; return (0,external_rxjs_namespaceObject.timer)((_a = key.options.cleanupDelayMs) !== null && _a !== void 0 ? _a : ONE_MINUTE); },
        }));
        this.state$ = this.combinedState$.pipe((0,external_rxjs_namespaceObject.map)(([, state]) => state));
    }
    /** {@link SingleUserState.userId} */
    get userId() {
        return this.encryptedState.userId;
    }
    /** Creates a secret state bound to an account encryptor. The account must be unlocked
     *  when this method is called.
     *  @param userId: the user to which the secret state is bound.
     *  @param key Converts between a declassified secret and its formal type.
     *  @param provider constructs state objects.
     *  @param encryptor protects `Secret` data.
     *  @throws when `key.stateDefinition` is backed by memory storage.
     *  @remarks Secrets are written to a secret store as a named tuple. Data classification is
     *    determined by the encryptor's classifier. Secret-classification data is jsonified,
     *    encrypted, and stored in a `secret` property. Disclosed-classification data is stored
     *    in a `disclosed` property. Omitted-classification data is not stored.
     */
    static from(userId, key, provider, encryptor$) {
        const secretState = new SecretState(key, encryptor$, userId, provider);
        return secretState;
    }
    declassifyItem(encryptor_1, _a) {
        return secret_state_awaiter(this, arguments, void 0, function* (encryptor, { id, secret, disclosed }) {
            const encrypted = enc_string_EncString.fromJSON(secret);
            const decrypted = yield encryptor.decrypt(encrypted);
            const declassified = this.key.classifier.declassify(disclosed, decrypted);
            const result = [id, this.key.options.deserializer(declassified)];
            return result;
        });
    }
    declassifyAll(encryptor, data) {
        return secret_state_awaiter(this, void 0, void 0, function* () {
            // fail fast if there's no value
            if (data === null || data === undefined) {
                return null;
            }
            // decrypt each item
            const decryptTasks = data.map((item) => secret_state_awaiter(this, void 0, void 0, function* () { return this.declassifyItem(encryptor, item); }));
            // reconstruct expected type
            const results = yield Promise.all(decryptTasks);
            const result = this.key.reconstruct(results);
            return result;
        });
    }
    classifyItem(encryptor_1, _a) {
        return secret_state_awaiter(this, arguments, void 0, function* (encryptor, [id, item]) {
            const classified = this.key.classifier.classify(item);
            const encrypted = yield encryptor.encrypt(classified.secret);
            // the deserializer in the plaintextState's `derive` configuration always runs, but
            // `encryptedState` is not guaranteed to serialize the data, so it's necessary to
            // round-trip `encrypted` proactively.
            const serialized = {
                id,
                secret: JSON.parse(JSON.stringify(encrypted)),
                disclosed: classified.disclosed,
            };
            return serialized;
        });
    }
    classifyAll(encryptor, data) {
        return secret_state_awaiter(this, void 0, void 0, function* () {
            // fail fast if there's no value
            if (data === null || data === undefined) {
                return null;
            }
            // convert the object to a list format so that all encrypt and decrypt
            // operations are self-similar
            const desconstructed = this.key.deconstruct(data);
            // encrypt each value individually
            const classifyTasks = desconstructed.map((item) => secret_state_awaiter(this, void 0, void 0, function* () { return this.classifyItem(encryptor, item); }));
            const classified = yield Promise.all(classifyTasks);
            return classified;
        });
    }
    /** Updates the secret stored by this state.
     *  @param configureState a callback that returns an updated decrypted
     *   secret state. The callback receives the state's present value as its
     *   first argument and the dependencies listed in `options.combinedLatestWith`
     *   as its second argument.
     *  @param options configures how the update is applied. See {@link StateUpdateOptions}.
     *  @returns a promise that resolves with the updated value read from the state.
     *   The round-trip encrypts, decrypts, and deserializes the data, producing a new
     *   object.
     *  @remarks `configureState` must return a JSON-serializable object.
     *   If there are properties of your class which are not JSON-serializable,
     *   they can be lost when the secret state updates its backing store.
     */
    update(configureState_1) {
        return secret_state_awaiter(this, arguments, void 0, function* (configureState, options = null) {
            var _a, _b, _c;
            const combineLatestWith = (0,external_rxjs_namespaceObject.combineLatest)([
                (_a = options === null || options === void 0 ? void 0 : options.combineLatestWith) !== null && _a !== void 0 ? _a : (0,external_rxjs_namespaceObject.of)(null),
                this.$encryptor,
            ]);
            // read the backing store
            let latestClassified;
            let latestCombined;
            let latestEncryptor;
            yield this.encryptedState.update((c) => c, {
                shouldUpdate: (latest, combined) => {
                    latestClassified = latest;
                    [latestCombined, latestEncryptor] = combined;
                    return false;
                },
                combineLatestWith,
            });
            // exit early if there's no update to apply
            const latestDeclassified = yield this.declassifyAll(latestEncryptor, latestClassified);
            const shouldUpdate = (_c = (_b = options === null || options === void 0 ? void 0 : options.shouldUpdate) === null || _b === void 0 ? void 0 : _b.call(options, latestDeclassified, latestCombined)) !== null && _c !== void 0 ? _c : true;
            if (!shouldUpdate) {
                return latestDeclassified;
            }
            // apply the update
            const updatedDeclassified = configureState(latestDeclassified, latestCombined);
            const updatedClassified = yield this.classifyAll(latestEncryptor, updatedDeclassified);
            yield this.encryptedState.update(() => updatedClassified);
            return updatedDeclassified;
        });
    }
}

;// ../../libs/tools/generator/core/src/abstractions/generator-strategy.abstraction.ts
/** Tailors the generator service to generate a specific kind of credentials */
class GeneratorStrategy {
}

;// ../../libs/tools/generator/core/src/engine/rpc/create-forwarding-address.ts
class create_forwarding_address_CreateForwardingAddressRpc {
    constructor(requestor, context) {
        this.requestor = requestor;
        this.context = context;
    }
    get createForwardingEmail() {
        return this.requestor.forwarder.createForwardingEmail;
    }
    toRequest(req) {
        const url = this.createForwardingEmail.url(req, this.context);
        const token = this.requestor.authenticate(req, this.context);
        const body = this.body(req);
        const request = new Request(url, {
            redirect: "manual",
            cache: "no-store",
            method: "POST",
            headers: new Headers(Object.assign(Object.assign({}, token), { "Content-Type": "application/json", Accept: "application/json" })),
            body,
        });
        return request;
    }
    body(req) {
        const toBody = this.createForwardingEmail.body;
        if (!toBody) {
            return undefined;
        }
        const body = toBody(req, this.context);
        if (!body) {
            return undefined;
        }
        return JSON.stringify(body);
    }
    hasJsonPayload(response) {
        return this.createForwardingEmail.hasJsonPayload(response, this.context);
    }
    processJson(json) {
        return this.createForwardingEmail.processJson(json, this.context);
    }
}

;// ../../libs/tools/generator/core/src/engine/rpc/get-account-id.ts
class get_account_id_GetAccountIdRpc {
    constructor(requestor, context) {
        this.requestor = requestor;
        this.context = context;
    }
    hasJsonPayload(response) {
        return this.requestor.forwarder.getAccountId.hasJsonPayload(response, this.context);
    }
    processJson(json) {
        return this.requestor.forwarder.getAccountId.processJson(json, this.context);
    }
    toRequest(req) {
        const url = this.requestor.forwarder.getAccountId.url(req, this.context);
        const token = this.requestor.authenticate(req, this.context);
        const request = new Request(url, {
            redirect: "manual",
            cache: "no-store",
            method: "GET",
            headers: new Headers(Object.assign(Object.assign({}, token), { "Content-Type": "application/json", Accept: "application/json" })),
        });
        return request;
    }
}

;// ../../libs/tools/generator/core/src/strategies/options-classifier.ts
/** Classifies an object by excluding IntegrationRequest parameters.
 */
class OptionsClassifier {
    /** Partitions `secret` into its disclosed properties and secret properties.
     *  @param value The object to partition
     *  @returns an object that classifies secrets.
     *    The `disclosed` member is new and contains disclosed properties.
     *    The `secret` member is a copy of the secret parameter, including its
     *    prototype, with all disclosed and excluded properties deleted.
     */
    classify(value) {
        const secret = JSON.parse(JSON.stringify(value));
        delete secret.website;
        const disclosed = {};
        return { disclosed, secret };
    }
    /** Merges the properties of `secret` and `disclosed`. When `secret` and
     *  `disclosed` contain the same property, the `secret` property overrides
     *  the `disclosed` property.
     *  @param disclosed an object whose disclosed properties are merged into
     *    the output. Unknown properties are ignored.
     *  @param secret an objects whose properties are merged into the output.
     *    Excluded properties are ignored. Unknown properties are retained.
     *  @returns a new object containing the merged data.
     *
     *  @remarks Declassified data is always jsonified--the purpose of classifying it is
     *   to Jsonify it,
     *   which causes type conversions.
     */
    declassify(_disclosed, secret) {
        const result = Object.assign(Object.assign({}, secret), { website: null });
        return result;
    }
}

;// ../../libs/tools/generator/core/src/strategies/forwarder-generator-strategy.ts
var forwarder_generator_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore














const OPTIONS_FRAME_SIZE = 512;
/** An email forwarding service configurable through an API. */
class ForwarderGeneratorStrategy extends GeneratorStrategy {
    /** Initializes the generator strategy
     *  @param encryptService protects sensitive forwarder options
     *  @param keyService looks up the user key when protecting data.
     *  @param stateProvider creates the durable state for options storage
     */
    constructor(configuration, client, i18nService, encryptService, keyService, stateProvider) {
        super();
        this.configuration = configuration;
        this.client = client;
        this.i18nService = i18nService;
        this.encryptService = encryptService;
        this.keyService = keyService;
        this.stateProvider = stateProvider;
        // configuration
        this.policy = policy_type_enum_PolicyType.PasswordGenerator;
        this.defaults$ = observe$PerUserId(() => this.configuration.forwarder.defaultSettings);
        this.toEvaluator = newDefaultEvaluator();
        this.durableState = sharedByUserId((userId) => this.getUserSecrets(userId));
        this.generate = (options) => forwarder_generator_strategy_awaiter(this, void 0, void 0, function* () {
            const requestOptions = { website: options.website };
            const getAccount = yield this.getAccountId(this.configuration, options);
            if (getAccount) {
                requestOptions.accountId = yield this.client.fetchJson(getAccount, requestOptions);
            }
            const create = this.createForwardingAddress(this.configuration, options);
            const result = yield this.client.fetchJson(create, requestOptions);
            return result;
        });
    }
    get key() {
        return this.configuration.forwarder.settings;
    }
    get rolloverKey() {
        return this.configuration.forwarder.importBuffer;
    }
    // per-user encrypted state
    getUserSecrets(userId) {
        // construct the encryptor
        const packer = new PaddedDataPacker(OPTIONS_FRAME_SIZE);
        const encryptor$ = this.keyService.userKey$(userId).pipe((0,external_rxjs_namespaceObject.map)((key) => (key ? new UserKeyEncryptor(userId, this.encryptService, key, packer) : null)), (0,external_rxjs_namespaceObject.filter)((encryptor) => !!encryptor));
        // always exclude request properties
        const classifier = new OptionsClassifier();
        // Derive the secret key definition
        const key = SecretKeyDefinition.value(this.key.stateDefinition, this.key.key, classifier, {
            deserializer: (d) => this.key.deserializer(d),
            cleanupDelayMs: this.key.cleanupDelayMs,
            clearOn: this.key.clearOn,
        });
        // the type parameter is explicit because type inference fails for `Omit<Options, "website">`
        const secretState = SecretState.from(userId, key, this.stateProvider, encryptor$);
        // rollover should occur once the user key is available for decryption
        const canDecrypt$ = this.keyService.userKey$(userId).pipe((0,external_rxjs_namespaceObject.map)((key) => key !== null));
        const rolloverState = new BufferedState(this.stateProvider, this.rolloverKey, secretState, canDecrypt$);
        // cast through unknown required because there's no way to prove to
        // the compiler that `OptionsClassifier` runs within the buffer wrapping
        // the secret state.
        return rolloverState;
    }
    createContext(configuration, settings) {
        return new forwarder_context_ForwarderContext(configuration, settings, this.i18nService);
    }
    createForwardingAddress(configuration, settings) {
        const context = this.createContext(configuration, settings);
        const rpc = new create_forwarding_address_CreateForwardingAddressRpc(configuration, context);
        return rpc;
    }
    getAccountId(configuration, settings) {
        if (!configuration.forwarder.getAccountId) {
            return null;
        }
        const context = this.createContext(configuration, settings);
        const rpc = new get_account_id_GetAccountIdRpc(configuration, context);
        return rpc;
    }
}

;// ../../libs/tools/generator/core/src/strategies/storage.ts

/** plaintext password generation options */
const PASSWORD_SETTINGS = new UserKeyDefinition(GENERATOR_DISK, "passwordGeneratorSettings", {
    deserializer: (value) => value,
    clearOn: [],
});
/** plaintext passphrase generation options */
const PASSPHRASE_SETTINGS = new UserKeyDefinition(GENERATOR_DISK, "passphraseGeneratorSettings", {
    deserializer: (value) => value,
    clearOn: [],
});
/** plaintext username generation options */
const EFF_USERNAME_SETTINGS = new UserKeyDefinition(GENERATOR_DISK, "effUsernameGeneratorSettings", {
    deserializer: (value) => value,
    clearOn: [],
});
/** plaintext configuration for a domain catch-all address. */
const CATCHALL_SETTINGS = new UserKeyDefinition(GENERATOR_DISK, "catchallGeneratorSettings", {
    deserializer: (value) => value,
    clearOn: [],
});
/** plaintext configuration for an email subaddress. */
const SUBADDRESS_SETTINGS = new UserKeyDefinition(GENERATOR_DISK, "subaddressGeneratorSettings", {
    deserializer: (value) => value,
    clearOn: [],
});

;// ../../libs/tools/generator/core/src/strategies/passphrase-generator-strategy.ts
var passphrase_generator_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore





/** Generates passphrases composed of random words */
class PassphraseGeneratorStrategy {
    /** instantiates the password generator strategy.
     *  @param legacy generates the passphrase
     *  @param stateProvider provides durable state
     */
    constructor(randomizer, stateProvider) {
        this.randomizer = randomizer;
        this.stateProvider = stateProvider;
        // configuration
        this.durableState = sharedStateByUserId(PASSPHRASE_SETTINGS, this.stateProvider);
        this.defaults$ = observe$PerUserId(() => DefaultPassphraseGenerationOptions);
        this.policy = policy_type_enum_PolicyType.PasswordGenerator;
    }
    toEvaluator() {
        return mapPolicyToEvaluator(Policies.Passphrase);
    }
    // algorithm
    generate(options) {
        return passphrase_generator_strategy_awaiter(this, void 0, void 0, function* () {
            const request = optionsToEffWordListRequest(options);
            return this.randomizer.randomEffLongWords(request);
        });
    }
}

;// ../../libs/tools/generator/core/src/strategies/password-generator-strategy.ts
var password_generator_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





/** Generates passwords composed of random characters */
class PasswordGeneratorStrategy {
    /** instantiates the password generator strategy.
     *  @param legacy generates the password
     */
    constructor(randomizer, stateProvider) {
        this.randomizer = randomizer;
        this.stateProvider = stateProvider;
        // configuration
        this.durableState = sharedStateByUserId(PASSWORD_SETTINGS, this.stateProvider);
        this.defaults$ = observe$PerUserId(() => DefaultPasswordGenerationOptions);
        this.policy = policy_type_enum_PolicyType.PasswordGenerator;
    }
    toEvaluator() {
        return mapPolicyToEvaluator(Policies.Password);
    }
    // algorithm
    generate(options) {
        return password_generator_strategy_awaiter(this, void 0, void 0, function* () {
            const request = optionsToRandomAsciiRequest(options);
            const result = yield this.randomizer.randomAscii(request);
            return result;
        });
    }
}

;// ../../libs/tools/generator/core/src/strategies/catchall-generator-strategy.ts
var catchall_generator_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore





/** Strategy for creating usernames using a catchall email address */
class CatchallGeneratorStrategy {
    /** Instantiates the generation strategy
     *  @param usernameService generates a catchall address for a domain
     */
    constructor(emailCalculator, emailRandomizer, stateProvider, defaultOptions = DefaultCatchallOptions) {
        this.emailCalculator = emailCalculator;
        this.emailRandomizer = emailRandomizer;
        this.stateProvider = stateProvider;
        this.defaultOptions = defaultOptions;
        // configuration
        this.durableState = sharedStateByUserId(CATCHALL_SETTINGS, this.stateProvider);
        this.defaults$ = observe$PerUserId(() => this.defaultOptions);
        this.toEvaluator = newDefaultEvaluator();
        this.policy = policy_type_enum_PolicyType.PasswordGenerator;
    }
    // algorithm
    generate(options) {
        return catchall_generator_strategy_awaiter(this, void 0, void 0, function* () {
            if (options.catchallType == null) {
                options.catchallType = "random";
            }
            if (options.catchallType === "website-name") {
                return yield this.emailCalculator.concatenate(options.website, options.catchallDomain);
            }
            return this.emailRandomizer.randomAsciiCatchall(options.catchallDomain);
        });
    }
}

;// ../../libs/tools/generator/core/src/strategies/subaddress-generator-strategy.ts
var subaddress_generator_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore





/** Strategy for creating an email subaddress
 *  @remarks The subaddress is the part following the `+`.
 *  For example, if the email address is `jd+xyz@domain.io`,
 *  the subaddress is `xyz`.
 */
class SubaddressGeneratorStrategy {
    /** Instantiates the generation strategy
     *  @param usernameService generates an email subaddress from an email address
     */
    constructor(emailCalculator, emailRandomizer, stateProvider, defaultOptions = DefaultSubaddressOptions) {
        this.emailCalculator = emailCalculator;
        this.emailRandomizer = emailRandomizer;
        this.stateProvider = stateProvider;
        this.defaultOptions = defaultOptions;
        // configuration
        this.durableState = sharedStateByUserId(SUBADDRESS_SETTINGS, this.stateProvider);
        this.defaults$ = observe$PerUserId(() => this.defaultOptions);
        this.toEvaluator = newDefaultEvaluator();
        this.policy = policy_type_enum_PolicyType.PasswordGenerator;
    }
    // algorithm
    generate(options) {
        return subaddress_generator_strategy_awaiter(this, void 0, void 0, function* () {
            if (options.subaddressType == null) {
                options.subaddressType = "random";
            }
            if (options.subaddressType === "website-name") {
                return this.emailCalculator.appendToSubaddress(options.website, options.subaddressEmail);
            }
            return this.emailRandomizer.randomAsciiSubaddress(options.subaddressEmail);
        });
    }
}

;// ../../libs/tools/generator/core/src/strategies/eff-username-generator-strategy.ts
var eff_username_generator_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





/** Strategy for creating usernames from the EFF wordlist */
class EffUsernameGeneratorStrategy {
    /** Instantiates the generation strategy
     *  @param usernameService generates a username from EFF word list
     */
    constructor(randomizer, stateProvider, defaultOptions = DefaultEffUsernameOptions) {
        this.randomizer = randomizer;
        this.stateProvider = stateProvider;
        this.defaultOptions = defaultOptions;
        // configuration
        this.durableState = sharedStateByUserId(EFF_USERNAME_SETTINGS, this.stateProvider);
        this.defaults$ = observe$PerUserId(() => this.defaultOptions);
        this.toEvaluator = newDefaultEvaluator();
        this.policy = policy_type_enum_PolicyType.PasswordGenerator;
    }
    // algorithm
    generate(options) {
        return eff_username_generator_strategy_awaiter(this, void 0, void 0, function* () {
            var _a, _b;
            const casing = ((_a = options.wordCapitalize) !== null && _a !== void 0 ? _a : DefaultEffUsernameOptions.wordCapitalize)
                ? "TitleCase"
                : "lowercase";
            const digits = ((_b = options.wordIncludeNumber) !== null && _b !== void 0 ? _b : DefaultEffUsernameOptions.wordIncludeNumber)
                ? UsernameDigits.enabled
                : UsernameDigits.disabled;
            const word = yield this.randomizer.randomWords({ numberOfWords: 1, casing, digits });
            return word;
        });
    }
}

;// ../../libs/tools/generator/core/src/strategies/index.ts







;// ../../libs/tools/generator/core/src/index.ts
// The root module interface has API stability guarantees





// These internal interfacess are exposed for use by other generator modules
// They are unstable and may change arbitrarily







;// ./src/tools/generate.command.ts
var generate_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class GenerateCommand {
    constructor(passwordGenerationService, stateService) {
        this.passwordGenerationService = passwordGenerationService;
        this.stateService = stateService;
    }
    run(cmdOptions) {
        return generate_command_awaiter(this, void 0, void 0, function* () {
            const normalizedOptions = new generate_command_Options(cmdOptions);
            const options = {
                uppercase: normalizedOptions.uppercase,
                lowercase: normalizedOptions.lowercase,
                number: normalizedOptions.number,
                special: normalizedOptions.special,
                length: normalizedOptions.length,
                type: normalizedOptions.type,
                wordSeparator: normalizedOptions.separator,
                numWords: normalizedOptions.words,
                capitalize: normalizedOptions.capitalize,
                includeNumber: normalizedOptions.includeNumber,
                minNumber: normalizedOptions.minNumber,
                minSpecial: normalizedOptions.minSpecial,
                ambiguous: !normalizedOptions.ambiguous,
            };
            const enforcedOptions = (yield this.stateService.getIsAuthenticated())
                ? (yield this.passwordGenerationService.enforcePasswordGeneratorPoliciesOnOptions(options))[0]
                : options;
            const password = yield this.passwordGenerationService.generatePassword(enforcedOptions);
            const res = new StringResponse(password);
            return bw_Response.success(res);
        });
    }
}
class generate_command_Options {
    constructor(passedOptions) {
        this.uppercase = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.uppercase);
        this.lowercase = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.lowercase);
        this.number = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.number);
        this.special = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.special);
        this.capitalize = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.capitalize);
        this.includeNumber = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.includeNumber);
        this.ambiguous = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.ambiguous);
        this.length = CliUtils.convertNumberOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.length, DefaultPasswordGenerationOptions.length);
        this.type = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.passphrase) ? "passphrase" : "password";
        this.separator = CliUtils.convertStringOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.separator, DefaultPassphraseGenerationOptions.wordSeparator);
        this.words = CliUtils.convertNumberOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.words, DefaultPassphraseGenerationOptions.numWords);
        this.minNumber = CliUtils.convertNumberOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.minNumber, DefaultPasswordGenerationOptions.minNumber);
        this.minSpecial = CliUtils.convertNumberOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.minSpecial, DefaultPasswordGenerationOptions.minSpecial);
        if (!this.uppercase && !this.lowercase && !this.special && !this.number) {
            this.lowercase = true;
            this.uppercase = true;
            this.number = true;
        }
        if (this.length < 5) {
            this.length = 5;
        }
        if (this.words < 3) {
            this.words = 3;
        }
        if (this.separator === "space") {
            this.separator = " ";
        }
        else if (this.separator === "empty") {
            this.separator = "";
        }
        else if (this.separator != null && this.separator.length > 1) {
            this.separator = this.separator[0];
        }
    }
}

;// ./src/tools/send/commands/create.command.ts
var create_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore









class SendCreateCommand {
    constructor(sendService, environmentService, sendApiService, accountProfileService, accountService) {
        this.sendService = sendService;
        this.environmentService = environmentService;
        this.sendApiService = sendApiService;
        this.accountProfileService = accountProfileService;
        this.accountService = accountService;
    }
    run(requestJson, cmdOptions) {
        return create_command_awaiter(this, void 0, void 0, function* () {
            let req = null;
            if (process.env.BW_SERVE !== "true" && (requestJson == null || requestJson === "")) {
                requestJson = yield CliUtils.readStdin();
            }
            if (requestJson == null || requestJson === "") {
                return bw_Response.badRequest("`requestJson` was not provided.");
            }
            if (typeof requestJson !== "string") {
                req = requestJson;
                req.deletionDate = req.deletionDate == null ? null : new Date(req.deletionDate);
                req.expirationDate = req.expirationDate == null ? null : new Date(req.expirationDate);
            }
            else {
                try {
                    const reqJson = Buffer.from(requestJson, "base64").toString();
                    req = SendResponse.fromJson(reqJson);
                    if (req == null) {
                        throw new Error("Null request");
                    }
                    // FIXME: Remove when updating file. Eslint update
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                }
                catch (e) {
                    return bw_Response.badRequest("Error parsing the encoded request data.");
                }
            }
            if (req.deletionDate == null ||
                isNaN(new Date(req.deletionDate).getTime()) ||
                new Date(req.deletionDate) <= new Date()) {
                return bw_Response.badRequest("Must specify a valid deletion date after the current time");
            }
            if (req.expirationDate != null && isNaN(new Date(req.expirationDate).getTime())) {
                return bw_Response.badRequest("Unable to parse expirationDate: " + req.expirationDate);
            }
            const normalizedOptions = new create_command_Options(cmdOptions);
            return this.createSend(req, normalizedOptions);
        });
    }
    createSend(req, options) {
        return create_command_awaiter(this, void 0, void 0, function* () {
            var _a, _b, _c, _d, _e, _f, _g, _h;
            const filePath = (_b = (_a = req.file) === null || _a === void 0 ? void 0 : _a.fileName) !== null && _b !== void 0 ? _b : options.file;
            const text = (_d = (_c = req.text) === null || _c === void 0 ? void 0 : _c.text) !== null && _d !== void 0 ? _d : options.text;
            const hidden = (_f = (_e = req.text) === null || _e === void 0 ? void 0 : _e.hidden) !== null && _f !== void 0 ? _f : options.hidden;
            const password = (_g = req.password) !== null && _g !== void 0 ? _g : options.password;
            const maxAccessCount = (_h = req.maxAccessCount) !== null && _h !== void 0 ? _h : options.maxAccessCount;
            req.key = null;
            req.maxAccessCount = maxAccessCount;
            const hasPremium$ = this.accountService.activeAccount$.pipe((0,external_rxjs_namespaceObject.switchMap)(({ id }) => this.accountProfileService.hasPremiumFromAnySource$(id)));
            switch (req.type) {
                case SendType.File:
                    if (process.env.BW_SERVE === "true") {
                        return bw_Response.error("Creating a file-based Send is unsupported through the `serve` command at this time.");
                    }
                    if (!(yield (0,external_rxjs_namespaceObject.firstValueFrom)(hasPremium$))) {
                        return bw_Response.error("Premium status is required to use this feature.");
                    }
                    if (filePath == null) {
                        return bw_Response.badRequest("Must specify a file to Send either with the --file option or in the request JSON.");
                    }
                    req.file.fileName = external_path_namespaceObject.basename(filePath);
                    break;
                case SendType.Text:
                    if (text == null) {
                        return bw_Response.badRequest("Must specify text content to Send either with the --text option or in the request JSON.");
                    }
                    req.text = new SendTextResponse();
                    req.text.text = text;
                    req.text.hidden = hidden;
                    break;
                default:
                    return bw_Response.badRequest("Unknown Send type " + SendType[req.type] + ". Valid types are: file, text");
            }
            try {
                let fileBuffer = null;
                if (req.type === SendType.File) {
                    fileBuffer = NodeUtils.bufferToArrayBuffer(external_fs_namespaceObject.readFileSync(filePath));
                }
                const sendView = SendResponse.toView(req);
                const [encSend, fileData] = yield this.sendService.encrypt(sendView, fileBuffer, password);
                // Add dates from template
                encSend.deletionDate = sendView.deletionDate;
                encSend.expirationDate = sendView.expirationDate;
                yield this.sendApiService.save([encSend, fileData]);
                const newSend = yield this.sendService.getFromState(encSend.id);
                const decSend = yield newSend.decrypt();
                const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
                const res = new SendResponse(decSend, env.getWebVaultUrl());
                return bw_Response.success(res);
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
}
class create_command_Options {
    constructor(passedOptions) {
        this.file = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.file;
        this.text = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.text;
        this.password = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.password;
        this.hidden = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.hidden);
        this.maxAccessCount =
            (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.maxAccessCount) != null ? parseInt(passedOptions.maxAccessCount, null) : null;
    }
}

;// ./src/tools/send/commands/delete.command.ts
var delete_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class SendDeleteCommand {
    constructor(sendService, sendApiService) {
        this.sendService = sendService;
        this.sendApiService = sendApiService;
    }
    run(id) {
        return delete_command_awaiter(this, void 0, void 0, function* () {
            const send = yield this.sendService.getFromState(id);
            if (send == null) {
                return bw_Response.notFound();
            }
            try {
                yield this.sendApiService.delete(id);
                return bw_Response.success();
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
}

;// ./src/tools/send/commands/edit.command.ts
var commands_edit_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore





class SendEditCommand {
    constructor(sendService, getCommand, sendApiService, accountProfileService, accountService) {
        this.sendService = sendService;
        this.getCommand = getCommand;
        this.sendApiService = sendApiService;
        this.accountProfileService = accountProfileService;
        this.accountService = accountService;
    }
    run(requestJson, cmdOptions) {
        return commands_edit_command_awaiter(this, void 0, void 0, function* () {
            if (process.env.BW_SERVE !== "true" && (requestJson == null || requestJson === "")) {
                requestJson = yield CliUtils.readStdin();
            }
            if (requestJson == null || requestJson === "") {
                return bw_Response.badRequest("`requestJson` was not provided.");
            }
            let req = null;
            if (typeof requestJson !== "string") {
                req = requestJson;
                req.deletionDate = req.deletionDate == null ? null : new Date(req.deletionDate);
                req.expirationDate = req.expirationDate == null ? null : new Date(req.expirationDate);
            }
            else {
                try {
                    const reqJson = Buffer.from(requestJson, "base64").toString();
                    req = SendResponse.fromJson(reqJson);
                    // FIXME: Remove when updating file. Eslint update
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                }
                catch (e) {
                    return bw_Response.badRequest("Error parsing the encoded request data.");
                }
            }
            const normalizedOptions = new commands_edit_command_Options(cmdOptions);
            req.id = normalizedOptions.itemId || req.id;
            if (req.id != null) {
                req.id = req.id.toLowerCase();
            }
            const send = yield this.sendService.getFromState(req.id);
            if (send == null) {
                return bw_Response.notFound();
            }
            if (send.type !== req.type) {
                return bw_Response.badRequest("Cannot change a Send's type");
            }
            const account = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$);
            const canAccessPremium = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountProfileService.hasPremiumFromAnySource$(account.id));
            if (send.type === SendType.File && !canAccessPremium) {
                return bw_Response.error("Premium status is required to use this feature.");
            }
            let sendView = yield send.decrypt();
            sendView = SendResponse.toView(req, sendView);
            if (typeof req.password !== "string" || req.password === "") {
                req.password = null;
            }
            try {
                const [encSend, encFileData] = yield this.sendService.encrypt(sendView, null, req.password);
                // Add dates from template
                encSend.deletionDate = sendView.deletionDate;
                encSend.expirationDate = sendView.expirationDate;
                yield this.sendApiService.save([encSend, encFileData]);
            }
            catch (e) {
                return bw_Response.error(e);
            }
            return yield this.getCommand.run(send.id, {});
        });
    }
}
class commands_edit_command_Options {
    constructor(passedOptions) {
        this.itemId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemId) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemid);
    }
}

;// ./src/tools/send/commands/get.command.ts
var commands_get_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class SendGetCommand extends DownloadCommand {
    constructor(sendService, environmentService, searchService, encryptService, apiService) {
        super(encryptService, apiService);
        this.sendService = sendService;
        this.environmentService = environmentService;
        this.searchService = searchService;
    }
    run(id, options) {
        return commands_get_command_awaiter(this, void 0, void 0, function* () {
            const serveCommand = process.env.BW_SERVE === "true";
            if (serveCommand && !utils_Utils.isGuid(id)) {
                return bw_Response.badRequest("`" + id + "` is not a GUID.");
            }
            let sends = yield this.getSendView(id);
            if (sends == null) {
                return bw_Response.notFound();
            }
            const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
            const webVaultUrl = env.getWebVaultUrl();
            let filter = (s) => true;
            let selector = (s) => commands_get_command_awaiter(this, void 0, void 0, function* () { return bw_Response.success(new SendResponse(s, webVaultUrl)); });
            if (!serveCommand && (options === null || options === void 0 ? void 0 : options.text) != null) {
                filter = (s) => {
                    return filter(s) && s.text != null;
                };
                selector = (s) => commands_get_command_awaiter(this, void 0, void 0, function* () {
                    // Write to stdout and response success so we get the text string only to stdout
                    process.stdout.write(s.text.text);
                    return bw_Response.success();
                });
            }
            if (Array.isArray(sends)) {
                if (filter != null) {
                    sends = sends.filter(filter);
                }
                if (sends.length > 1) {
                    return bw_Response.multipleResults(sends.map((s) => s.id));
                }
                if (sends.length > 0) {
                    return selector(sends[0]);
                }
                else {
                    return bw_Response.notFound();
                }
            }
            return selector(sends);
        });
    }
    getSendView(id) {
        return commands_get_command_awaiter(this, void 0, void 0, function* () {
            if (utils_Utils.isGuid(id)) {
                const send = yield this.sendService.getFromState(id);
                if (send != null) {
                    return yield send.decrypt();
                }
            }
            else if (id.trim() !== "") {
                let sends = yield this.sendService.getAllDecryptedFromState();
                sends = this.searchService.searchSends(sends, id);
                if (sends.length > 1) {
                    return sends;
                }
                else if (sends.length > 0) {
                    return sends[0];
                }
            }
        });
    }
}

;// ./src/tools/send/commands/list.command.ts
var commands_list_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class SendListCommand {
    constructor(sendService, environmentService, searchService) {
        this.sendService = sendService;
        this.environmentService = environmentService;
        this.searchService = searchService;
    }
    run(cmdOptions) {
        return commands_list_command_awaiter(this, void 0, void 0, function* () {
            let sends = yield this.sendService.getAllDecryptedFromState();
            const normalizedOptions = new commands_list_command_Options(cmdOptions);
            if (normalizedOptions.search != null && normalizedOptions.search.trim() !== "") {
                sends = this.searchService.searchSends(sends, normalizedOptions.search);
            }
            const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
            const webVaultUrl = env.getWebVaultUrl();
            const res = new list_response_ListResponse(sends.map((s) => new SendResponse(s, webVaultUrl)));
            return bw_Response.success(res);
        });
    }
}
class commands_list_command_Options {
    constructor(passedOptions) {
        this.search = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.search;
    }
}

;// ../../libs/common/src/tools/send/models/view/send-access.view.ts


class SendAccessView {
    constructor(s) {
        this.id = null;
        this.name = null;
        this.type = null;
        this.text = new SendTextView();
        this.file = new SendFileView();
        this.expirationDate = null;
        this.creatorIdentifier = null;
        if (!s) {
            return;
        }
        this.id = s.id;
        this.type = s.type;
        this.expirationDate = s.expirationDate;
        this.creatorIdentifier = s.creatorIdentifier;
    }
}

;// ../../libs/common/src/tools/send/models/domain/send-file.ts
var send_file_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class SendFile extends domain_base_Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.size = obj.size;
        this.buildDomainModel(this, obj, {
            id: null,
            sizeName: null,
            fileName: null,
        }, ["id", "sizeName"]);
    }
    decrypt(key) {
        return send_file_awaiter(this, void 0, void 0, function* () {
            return yield this.decryptObj(this, new SendFileView(this), ["fileName"], null, key);
        });
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new SendFile(), obj, {
            fileName: enc_string_EncString.fromJSON(obj.fileName),
        });
    }
}

;// ../../libs/common/src/tools/send/models/domain/send-text.ts



class SendText extends domain_base_Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.hidden = obj.hidden;
        this.buildDomainModel(this, obj, {
            text: null,
        }, []);
    }
    decrypt(key) {
        return this.decryptObj(this, new SendTextView(this), ["text"], null, key);
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new SendText(), obj, {
            text: enc_string_EncString.fromJSON(obj.text),
        });
    }
}

;// ../../libs/common/src/tools/send/models/domain/send-access.ts
var send_access_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore





class SendAccess extends domain_base_Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            id: null,
            name: null,
            expirationDate: null,
            creatorIdentifier: null,
        }, ["id", "expirationDate", "creatorIdentifier"]);
        this.type = obj.type;
        switch (this.type) {
            case SendType.Text:
                this.text = new SendText(obj.text);
                break;
            case SendType.File:
                this.file = new SendFile(obj.file);
                break;
            default:
                break;
        }
    }
    decrypt(key) {
        return send_access_awaiter(this, void 0, void 0, function* () {
            const model = new SendAccessView(this);
            yield this.decryptObj(this, model, ["name"], null, key);
            switch (this.type) {
                case SendType.File:
                    model.file = yield this.file.decrypt(key);
                    break;
                case SendType.Text:
                    model.text = yield this.text.decrypt(key);
                    break;
                default:
                    break;
            }
            return model;
        });
    }
}

;// ../../libs/common/src/tools/send/models/request/send-access.request.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore
class SendAccessRequest {
}

;// ./src/tools/send/models/send-access.response.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore



class SendAccessResponse {
    static template() {
        const req = new SendAccessResponse();
        req.name = "Send name";
        req.type = SendType.Text;
        req.text = null;
        req.file = null;
        return req;
    }
    constructor(o) {
        this.object = "send-access";
        if (o == null) {
            return;
        }
        this.id = o.id;
        this.name = o.name;
        this.type = o.type;
        if (o.type === SendType.Text && o.text != null) {
            this.text = new SendTextResponse(o.text);
        }
        if (o.type === SendType.File && o.file != null) {
            this.file = new SendFileResponse(o.file);
        }
    }
}

;// ./src/tools/send/commands/receive.command.ts
var receive_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};











class SendReceiveCommand extends DownloadCommand {
    constructor(keyService, encryptService, cryptoFunctionService, platformUtilsService, environmentService, sendApiService, apiService) {
        super(encryptService, apiService);
        this.keyService = keyService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.platformUtilsService = platformUtilsService;
        this.environmentService = environmentService;
        this.sendApiService = sendApiService;
    }
    run(url, options) {
        return receive_command_awaiter(this, void 0, void 0, function* () {
            var _a, _b;
            this.canInteract = process.env.BW_NOINTERACTION !== "true";
            let urlObject;
            try {
                urlObject = new URL(url);
                // FIXME: Remove when updating file. Eslint update
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
            }
            catch (e) {
                return bw_Response.badRequest("Failed to parse the provided Send url");
            }
            const apiUrl = yield this.getApiUrl(urlObject);
            const [id, key] = this.getIdAndKey(urlObject);
            if (utils_Utils.isNullOrWhitespace(id) || utils_Utils.isNullOrWhitespace(key)) {
                return bw_Response.badRequest("Failed to parse url, the url provided is not a valid Send url");
            }
            const keyArray = utils_Utils.fromUrlB64ToArray(key);
            this.sendAccessRequest = new SendAccessRequest();
            let password = options.password;
            if (password == null || password === "") {
                if (options.passwordfile) {
                    password = yield NodeUtils.readFirstLine(options.passwordfile);
                }
                else if (options.passwordenv && process.env[options.passwordenv]) {
                    password = process.env[options.passwordenv];
                }
            }
            if (password != null && password !== "") {
                this.sendAccessRequest.password = yield this.getUnlockedPassword(password, keyArray);
            }
            const response = yield this.sendRequest(apiUrl, id, keyArray);
            if (response instanceof bw_Response) {
                // Error scenario
                return response;
            }
            if (options.obj != null) {
                return bw_Response.success(new SendAccessResponse(response));
            }
            switch (response.type) {
                case SendType.Text:
                    // Write to stdout and response success so we get the text string only to stdout
                    process.stdout.write((_a = response === null || response === void 0 ? void 0 : response.text) === null || _a === void 0 ? void 0 : _a.text);
                    return bw_Response.success();
                case SendType.File: {
                    const downloadData = yield this.sendApiService.getSendFileDownloadData(response, this.sendAccessRequest, apiUrl);
                    return yield this.saveAttachmentToFile(downloadData.url, this.decKey, (_b = response === null || response === void 0 ? void 0 : response.file) === null || _b === void 0 ? void 0 : _b.fileName, options.output);
                }
                default:
                    return bw_Response.success(new SendAccessResponse(response));
            }
        });
    }
    getIdAndKey(url) {
        const result = url.hash.slice(1).split("/").slice(-2);
        return [result[0], result[1]];
    }
    getApiUrl(url) {
        return receive_command_awaiter(this, void 0, void 0, function* () {
            const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
            const urls = env.getUrls();
            if (url.origin === "https://send.bitwarden.com") {
                return "https://api.bitwarden.com";
            }
            else if (url.origin === urls.api) {
                return url.origin;
            }
            else if (this.platformUtilsService.isDev() && url.origin === urls.webVault) {
                return urls.api;
            }
            else {
                return url.origin + "/api";
            }
        });
    }
    getUnlockedPassword(password, keyArray) {
        return receive_command_awaiter(this, void 0, void 0, function* () {
            const passwordHash = yield this.cryptoFunctionService.pbkdf2(password, keyArray, "sha256", 100000);
            return utils_Utils.fromBufferToB64(passwordHash);
        });
    }
    sendRequest(url, id, key) {
        return receive_command_awaiter(this, void 0, void 0, function* () {
            try {
                const sendResponse = yield this.sendApiService.postSendAccess(id, this.sendAccessRequest, url);
                const sendAccess = new SendAccess(sendResponse);
                this.decKey = yield this.keyService.makeSendKey(key);
                return yield sendAccess.decrypt(this.decKey);
            }
            catch (e) {
                if (e instanceof ErrorResponse) {
                    if (e.statusCode === 401) {
                        if (this.canInteract) {
                            const answer = yield external_inquirer_namespaceObject.createPromptModule({
                                output: process.stderr,
                            })({
                                type: "password",
                                name: "password",
                                message: "Send password:",
                            });
                            // reattempt with new password
                            this.sendAccessRequest.password = yield this.getUnlockedPassword(answer.password, key);
                            return yield this.sendRequest(url, id, key);
                        }
                        return bw_Response.badRequest("Incorrect or missing password");
                    }
                    else if (e.statusCode === 405) {
                        return bw_Response.badRequest("Bad Request");
                    }
                    else if (e.statusCode === 404) {
                        return bw_Response.notFound();
                    }
                }
                return bw_Response.error(e);
            }
        });
    }
}

;// ./src/tools/send/commands/remove-password.command.ts
var remove_password_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore



class SendRemovePasswordCommand {
    constructor(sendService, sendApiService, environmentService) {
        this.sendService = sendService;
        this.sendApiService = sendApiService;
        this.environmentService = environmentService;
    }
    run(id) {
        return remove_password_command_awaiter(this, void 0, void 0, function* () {
            try {
                yield this.sendApiService.removePassword(id);
                const updatedSend = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.sendService.get$(id));
                const decSend = yield updatedSend.decrypt();
                const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
                const webVaultUrl = env.getWebVaultUrl();
                const res = new SendResponse(decSend, webVaultUrl);
                return bw_Response.success(res);
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
}

;// ./src/tools/send/commands/index.ts








;// ./src/tools/send/index.ts


;// ./src/vault/create.command.ts
var vault_create_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore















class CreateCommand {
    constructor(cipherService, folderService, keyService, encryptService, apiService, folderApiService, accountProfileService, organizationService, accountService) {
        this.cipherService = cipherService;
        this.folderService = folderService;
        this.keyService = keyService;
        this.encryptService = encryptService;
        this.apiService = apiService;
        this.folderApiService = folderApiService;
        this.accountProfileService = accountProfileService;
        this.organizationService = organizationService;
        this.accountService = accountService;
    }
    run(object_1, requestJson_1, cmdOptions_1) {
        return vault_create_command_awaiter(this, arguments, void 0, function* (object, requestJson, cmdOptions, additionalData = null) {
            let req = null;
            if (object !== "attachment") {
                if (process.env.BW_SERVE !== "true" && (requestJson == null || requestJson === "")) {
                    requestJson = yield CliUtils.readStdin();
                }
                if (requestJson == null || requestJson === "") {
                    return bw_Response.badRequest("`requestJson` was not provided.");
                }
                if (typeof requestJson !== "string") {
                    req = requestJson;
                }
                else {
                    try {
                        const reqJson = Buffer.from(requestJson, "base64").toString();
                        req = JSON.parse(reqJson);
                        // FIXME: Remove when updating file. Eslint update
                        // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    }
                    catch (e) {
                        return bw_Response.badRequest("Error parsing the encoded request data.");
                    }
                }
            }
            const normalizedOptions = new vault_create_command_Options(cmdOptions);
            switch (object.toLowerCase()) {
                case "item":
                    return yield this.createCipher(req);
                case "attachment":
                    return yield this.createAttachment(normalizedOptions, additionalData);
                case "folder":
                    return yield this.createFolder(req);
                case "org-collection":
                    return yield this.createOrganizationCollection(req, normalizedOptions);
                default:
                    return bw_Response.badRequest("Unknown object.");
            }
        });
    }
    createCipher(req) {
        return vault_create_command_awaiter(this, void 0, void 0, function* () {
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
            const cipher = yield this.cipherService.encrypt(CipherExport.toView(req), activeUserId);
            try {
                const newCipher = yield this.cipherService.createWithServer(cipher);
                const decCipher = yield this.cipherService.decrypt(newCipher, activeUserId);
                const res = new CipherResponse(decCipher);
                return bw_Response.success(res);
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
    createAttachment(options, additionalData) {
        return vault_create_command_awaiter(this, void 0, void 0, function* () {
            if (options.itemId == null || options.itemId === "") {
                return bw_Response.badRequest("`itemid` option is required.");
            }
            let fileBuf = null;
            let fileName = null;
            if (process.env.BW_SERVE === "true") {
                fileBuf = additionalData.fileBuffer;
                fileName = additionalData.fileName;
            }
            else {
                if (options.file == null || options.file === "") {
                    return bw_Response.badRequest("`file` option is required.");
                }
                const filePath = external_path_namespaceObject.resolve(options.file);
                if (!external_fs_namespaceObject.existsSync(options.file)) {
                    return bw_Response.badRequest("Cannot find file at " + filePath);
                }
                fileBuf = external_fs_namespaceObject.readFileSync(filePath);
                fileName = external_path_namespaceObject.basename(filePath);
            }
            if (fileBuf == null) {
                return bw_Response.badRequest("File not provided.");
            }
            if (fileName == null || fileName.trim() === "") {
                return bw_Response.badRequest("File name not provided.");
            }
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
            const itemId = options.itemId.toLowerCase();
            const cipher = yield this.cipherService.get(itemId, activeUserId);
            if (cipher == null) {
                return bw_Response.notFound();
            }
            const canAccessPremium = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountProfileService.hasPremiumFromAnySource$(activeUserId));
            if (cipher.organizationId == null && !canAccessPremium) {
                return bw_Response.error("Premium status is required to use this feature.");
            }
            const userKey = yield this.keyService.getUserKey();
            if (userKey == null) {
                return bw_Response.error("You must update your encryption key before you can use this feature. " +
                    "See https://help.bitwarden.com/article/update-encryption-key/");
            }
            try {
                const updatedCipher = yield this.cipherService.saveAttachmentRawWithServer(cipher, fileName, new Uint8Array(fileBuf).buffer, activeUserId);
                const decCipher = yield this.cipherService.decrypt(updatedCipher, activeUserId);
                return bw_Response.success(new CipherResponse(decCipher));
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
    createFolder(req) {
        return vault_create_command_awaiter(this, void 0, void 0, function* () {
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
            const userKey = yield this.keyService.getUserKeyWithLegacySupport(activeUserId);
            const folder = yield this.folderService.encrypt(FolderExport.toView(req), userKey);
            try {
                yield this.folderApiService.save(folder, activeUserId);
                const newFolder = yield this.folderService.get(folder.id, activeUserId);
                const decFolder = yield newFolder.decrypt();
                const res = new FolderResponse(decFolder);
                return bw_Response.success(res);
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
    createOrganizationCollection(req, options) {
        return vault_create_command_awaiter(this, void 0, void 0, function* () {
            if (options.organizationId == null || options.organizationId === "") {
                return bw_Response.badRequest("`organizationid` option is required.");
            }
            if (!utils_Utils.isGuid(options.organizationId)) {
                return bw_Response.badRequest("`" + options.organizationId + "` is not a GUID.");
            }
            if (options.organizationId !== req.organizationId) {
                return bw_Response.badRequest("`organizationid` option does not match request object.");
            }
            try {
                const orgKey = yield this.keyService.getOrgKey(req.organizationId);
                if (orgKey == null) {
                    throw new Error("No encryption key for this organization.");
                }
                const userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe((0,external_rxjs_namespaceObject.map)((a) => a === null || a === void 0 ? void 0 : a.id)));
                if (!userId) {
                    return bw_Response.badRequest("No user found.");
                }
                const organization = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizationService
                    .organizations$(userId)
                    .pipe((0,external_rxjs_namespaceObject.map)((organizations) => organizations.find((o) => o.id === req.organizationId))));
                const currentOrgUserId = organization.organizationUserId;
                const groups = req.groups == null
                    ? null
                    : req.groups.map((g) => new selection_read_only_request_SelectionReadOnlyRequest(g.id, g.readOnly, g.hidePasswords, g.manage));
                const users = req.users == null
                    ? [new selection_read_only_request_SelectionReadOnlyRequest(currentOrgUserId, false, false, true)]
                    : req.users.map((u) => new selection_read_only_request_SelectionReadOnlyRequest(u.id, u.readOnly, u.hidePasswords, u.manage));
                const request = new collection_request_CollectionRequest();
                request.name = (yield this.encryptService.encryptString(req.name, orgKey)).encryptedString;
                request.externalId = req.externalId;
                request.groups = groups;
                request.users = users;
                const response = yield this.apiService.postCollection(req.organizationId, request);
                const view = CollectionExport.toView(req);
                view.id = response.id;
                const res = new OrganizationCollectionResponse(view, groups, users);
                return bw_Response.success(res);
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
}
class vault_create_command_Options {
    constructor(passedOptions) {
        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);
        this.itemId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemId);
        this.file = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.file;
    }
}

;// ./src/vault/delete.command.ts
var vault_delete_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class DeleteCommand {
    constructor(cipherService, folderService, apiService, folderApiService, accountProfileService, cipherAuthorizationService, accountService) {
        this.cipherService = cipherService;
        this.folderService = folderService;
        this.apiService = apiService;
        this.folderApiService = folderApiService;
        this.accountProfileService = accountProfileService;
        this.cipherAuthorizationService = cipherAuthorizationService;
        this.accountService = accountService;
    }
    run(object, id, cmdOptions) {
        return vault_delete_command_awaiter(this, void 0, void 0, function* () {
            if (id != null) {
                id = id.toLowerCase();
            }
            const normalizedOptions = new delete_command_Options(cmdOptions);
            switch (object.toLowerCase()) {
                case "item":
                    return yield this.deleteCipher(id, normalizedOptions);
                case "attachment":
                    return yield this.deleteAttachment(id, normalizedOptions);
                case "folder":
                    return yield this.deleteFolder(id);
                case "org-collection":
                    return yield this.deleteOrganizationCollection(id, normalizedOptions);
                default:
                    return bw_Response.badRequest("Unknown object.");
            }
        });
    }
    deleteCipher(id, options) {
        return vault_delete_command_awaiter(this, void 0, void 0, function* () {
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
            const cipher = yield this.cipherService.get(id, activeUserId);
            if (cipher == null) {
                return bw_Response.notFound();
            }
            const canDeleteCipher = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.cipherAuthorizationService.canDeleteCipher$(cipher));
            if (!canDeleteCipher) {
                return bw_Response.error("You do not have permission to delete this item.");
            }
            try {
                if (options.permanent) {
                    yield this.cipherService.deleteWithServer(id, activeUserId);
                }
                else {
                    yield this.cipherService.softDeleteWithServer(id, activeUserId);
                }
                return bw_Response.success();
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
    deleteAttachment(id, options) {
        return vault_delete_command_awaiter(this, void 0, void 0, function* () {
            if (options.itemId == null || options.itemId === "") {
                return bw_Response.badRequest("`itemid` option is required.");
            }
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
            const itemId = options.itemId.toLowerCase();
            const cipher = yield this.cipherService.get(itemId, activeUserId);
            if (cipher == null) {
                return bw_Response.notFound();
            }
            if (cipher.attachments == null || cipher.attachments.length === 0) {
                return bw_Response.error("No attachments available for this item.");
            }
            const attachments = cipher.attachments.filter((a) => a.id.toLowerCase() === id);
            if (attachments.length === 0) {
                return bw_Response.error("Attachment `" + id + "` was not found.");
            }
            const canAccessPremium = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountProfileService.hasPremiumFromAnySource$(activeUserId));
            if (cipher.organizationId == null && !canAccessPremium) {
                return bw_Response.error("Premium status is required to use this feature.");
            }
            try {
                yield this.cipherService.deleteAttachmentWithServer(cipher.id, attachments[0].id, activeUserId, false);
                return bw_Response.success();
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
    deleteFolder(id) {
        return vault_delete_command_awaiter(this, void 0, void 0, function* () {
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe(getUserId));
            const folder = yield this.folderService.getFromState(id, activeUserId);
            if (folder == null) {
                return bw_Response.notFound();
            }
            try {
                yield this.folderApiService.delete(id, activeUserId);
                return bw_Response.success();
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
    deleteOrganizationCollection(id, options) {
        return vault_delete_command_awaiter(this, void 0, void 0, function* () {
            if (options.organizationId == null || options.organizationId === "") {
                return bw_Response.badRequest("`organizationid` options is required.");
            }
            if (!utils_Utils.isGuid(id)) {
                return bw_Response.badRequest("`" + id + "` is not a GUID.");
            }
            if (!utils_Utils.isGuid(options.organizationId)) {
                return bw_Response.badRequest("`" + options.organizationId + "` is not a GUID.");
            }
            try {
                yield this.apiService.deleteCollection(options.organizationId, id);
                return bw_Response.success();
            }
            catch (e) {
                return bw_Response.error(e);
            }
        });
    }
}
class delete_command_Options {
    constructor(passedOptions) {
        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);
        this.itemId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemId);
        this.permanent = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.permanent);
    }
}

;// ./src/vault/sync.command.ts
var sync_command_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class SyncCommand {
    constructor(syncService) {
        this.syncService = syncService;
    }
    run(cmdOptions) {
        return sync_command_awaiter(this, void 0, void 0, function* () {
            const normalizedOptions = new sync_command_Options(cmdOptions);
            if (normalizedOptions.last) {
                return yield this.getLastSync();
            }
            try {
                yield this.syncService.fullSync(normalizedOptions.force, true);
                const res = new MessageResponse("Syncing complete.", null);
                return bw_Response.success(res);
            }
            catch (e) {
                const response = bw_Response.error(e);
                response.message = "Syncing failed: " + response.message;
                return response;
            }
        });
    }
    getLastSync() {
        return sync_command_awaiter(this, void 0, void 0, function* () {
            const lastSyncDate = yield this.syncService.getLastSync();
            const res = new StringResponse(lastSyncDate == null ? null : lastSyncDate.toISOString());
            return bw_Response.success(res);
        });
    }
}
class sync_command_Options {
    constructor(passedOptions) {
        this.last = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.last);
        this.force = CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.force);
    }
}

;// ./src/oss-serve-configurator.ts
var oss_serve_configurator_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

















class OssServeConfigurator {
    constructor(serviceContainer) {
        this.serviceContainer = serviceContainer;
        this.getCommand = new GetCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.collectionService, this.serviceContainer.totpService, this.serviceContainer.auditService, this.serviceContainer.keyService, this.serviceContainer.encryptService, this.serviceContainer.searchService, this.serviceContainer.apiService, this.serviceContainer.organizationService, this.serviceContainer.eventCollectionService, this.serviceContainer.billingAccountProfileStateService, this.serviceContainer.accountService);
        this.listCommand = new ListCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.collectionService, this.serviceContainer.organizationService, this.serviceContainer.searchService, this.serviceContainer.organizationUserApiService, this.serviceContainer.apiService, this.serviceContainer.eventCollectionService, this.serviceContainer.accountService);
        this.createCommand = new CreateCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.keyService, this.serviceContainer.encryptService, this.serviceContainer.apiService, this.serviceContainer.folderApiService, this.serviceContainer.billingAccountProfileStateService, this.serviceContainer.organizationService, this.serviceContainer.accountService);
        this.editCommand = new EditCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.keyService, this.serviceContainer.encryptService, this.serviceContainer.apiService, this.serviceContainer.folderApiService, this.serviceContainer.accountService);
        this.generateCommand = new GenerateCommand(this.serviceContainer.passwordGenerationService, this.serviceContainer.stateService);
        this.syncCommand = new SyncCommand(this.serviceContainer.syncService);
        this.statusCommand = new StatusCommand(this.serviceContainer.environmentService, this.serviceContainer.syncService, this.serviceContainer.accountService, this.serviceContainer.authService);
        this.deleteCommand = new DeleteCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.apiService, this.serviceContainer.folderApiService, this.serviceContainer.billingAccountProfileStateService, this.serviceContainer.cipherAuthorizationService, this.serviceContainer.accountService);
        this.confirmCommand = new ConfirmCommand(this.serviceContainer.apiService, this.serviceContainer.keyService, this.serviceContainer.encryptService, this.serviceContainer.organizationUserApiService);
        this.restoreCommand = new RestoreCommand(this.serviceContainer.cipherService, this.serviceContainer.accountService, this.serviceContainer.configService, this.serviceContainer.cipherAuthorizationService);
        this.shareCommand = new ShareCommand(this.serviceContainer.cipherService, this.serviceContainer.accountService);
        this.lockCommand = new LockCommand(this.serviceContainer.vaultTimeoutService);
        this.unlockCommand = new UnlockCommand(this.serviceContainer.accountService, this.serviceContainer.masterPasswordService, this.serviceContainer.keyService, this.serviceContainer.userVerificationService, this.serviceContainer.cryptoFunctionService, this.serviceContainer.logService, this.serviceContainer.keyConnectorService, this.serviceContainer.environmentService, this.serviceContainer.organizationApiService, () => oss_serve_configurator_awaiter(this, void 0, void 0, function* () { return yield this.serviceContainer.logout(); }), this.serviceContainer.i18nService);
        this.sendCreateCommand = new SendCreateCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.sendApiService, this.serviceContainer.billingAccountProfileStateService, this.serviceContainer.accountService);
        this.sendDeleteCommand = new SendDeleteCommand(this.serviceContainer.sendService, this.serviceContainer.sendApiService);
        this.sendGetCommand = new SendGetCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.searchService, this.serviceContainer.encryptService, this.serviceContainer.apiService);
        this.sendEditCommand = new SendEditCommand(this.serviceContainer.sendService, this.sendGetCommand, this.serviceContainer.sendApiService, this.serviceContainer.billingAccountProfileStateService, this.serviceContainer.accountService);
        this.sendListCommand = new SendListCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.searchService);
        this.sendRemovePasswordCommand = new SendRemovePasswordCommand(this.serviceContainer.sendService, this.serviceContainer.sendApiService, this.serviceContainer.environmentService);
    }
    configureRouter(router) {
        router.get("/generate", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            const response = yield this.generateCommand.run(ctx.request.query);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.get("/status", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            const response = yield this.statusCommand.run();
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.get("/list/object/:object", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            let response = null;
            if (ctx.params.object === "send") {
                response = yield this.sendListCommand.run(ctx.request.query);
            }
            else {
                response = yield this.listCommand.run(ctx.params.object, ctx.request.query);
            }
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.get("/send/list", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield this.sendListCommand.run(ctx.request.query);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/sync", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            const response = yield this.syncCommand.run(ctx.request.query);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/lock", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            const response = yield this.lockCommand.run();
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/unlock", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            // Do not allow guessing password location through serve command
            delete ctx.request.query.passwordFile;
            delete ctx.request.query.passwordEnv;
            const response = yield this.unlockCommand.run(ctx.request.body.password == null ? null : ctx.request.body.password, ctx.request.query);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/confirm/:object/:id", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield this.confirmCommand.run(ctx.params.object, ctx.params.id, ctx.request.query);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/restore/:object/:id", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield this.restoreCommand.run(ctx.params.object, ctx.params.id);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/move/:id/:organizationId", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield this.shareCommand.run(ctx.params.id, ctx.params.organizationId, ctx.request.body);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/attachment", multer_namespaceObject().single("file"), (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield this.createCommand.run("attachment", ctx.request.body, ctx.request.query, {
                fileBuffer: ctx.request.file.buffer,
                fileName: ctx.request.file.originalname,
            });
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/send/:id/remove-password", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            const response = yield this.sendRemovePasswordCommand.run(ctx.params.id);
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.post("/object/:object", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            let response = null;
            if (ctx.params.object === "send") {
                response = yield this.sendCreateCommand.run(ctx.request.body, ctx.request.query);
            }
            else {
                response = yield this.createCommand.run(ctx.params.object, ctx.request.body, ctx.request.query);
            }
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.put("/object/:object/:id", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            let response = null;
            if (ctx.params.object === "send") {
                ctx.request.body.id = ctx.params.id;
                response = yield this.sendEditCommand.run(ctx.request.body, ctx.request.query);
            }
            else {
                response = yield this.editCommand.run(ctx.params.object, ctx.params.id, ctx.request.body, ctx.request.query);
            }
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.get("/object/:object/:id", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            let response = null;
            if (ctx.params.object === "send") {
                response = yield this.sendGetCommand.run(ctx.params.id, null);
            }
            else {
                response = yield this.getCommand.run(ctx.params.object, ctx.params.id, ctx.request.query);
            }
            this.processResponse(ctx.response, response);
            yield next();
        }));
        router.delete("/object/:object/:id", (ctx, next) => oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            if (yield this.errorIfLocked(ctx.response)) {
                yield next();
                return;
            }
            let response = null;
            if (ctx.params.object === "send") {
                response = yield this.sendDeleteCommand.run(ctx.params.id);
            }
            else {
                response = yield this.deleteCommand.run(ctx.params.object, ctx.params.id, ctx.request.query);
            }
            this.processResponse(ctx.response, response);
            yield next();
        }));
    }
    processResponse(res, commandResponse) {
        if (!commandResponse.success) {
            res.status = 400;
        }
        if (commandResponse.data instanceof FileResponse) {
            res.body = commandResponse.data.data;
            res.attachment(commandResponse.data.fileName);
            res.set("Content-Type", "application/octet-stream");
            res.set("Content-Length", commandResponse.data.data.length.toString());
        }
        else {
            res.body = commandResponse;
        }
    }
    errorIfLocked(res) {
        return oss_serve_configurator_awaiter(this, void 0, void 0, function* () {
            const authed = yield this.serviceContainer.stateService.getIsAuthenticated();
            if (!authed) {
                this.processResponse(res, bw_Response.error("You are not logged in."));
                return true;
            }
            if (yield this.serviceContainer.keyService.hasUserKey()) {
                return false;
            }
            this.processResponse(res, bw_Response.error("Vault is locked."));
            return true;
        });
    }
}

;// external "chalk"
const external_chalk_namespaceObject = require("chalk");
;// external "http"
const external_http_namespaceObject = require("http");
;// ../../libs/auth/src/common/models/domain/rotateable-key-set.ts
/**
 * A set of keys where a `UserKey` is protected by an encrypted public/private key-pair.
 * The `UserKey` is used to encrypt/decrypt data, while the public/private key-pair is
 * used to rotate the `UserKey`.
 *
 * The `PrivateKey` is protected by an `ExternalKey`, such as a `DeviceKey`, or `PrfKey`,
 * and the `PublicKey` is protected by the `UserKey`. This setup allows:
 *
 *   - Access to `UserKey` by knowing the `ExternalKey`
 *   - Rotation to a `NewUserKey` by knowing the current `UserKey`,
 *     without needing access to the `ExternalKey`
 */
class RotateableKeySet {
    constructor(
    /** PublicKey encrypted UserKey */
    encryptedUserKey, 
    /** UserKey encrypted PublicKey */
    encryptedPublicKey, 
    /** ExternalKey encrypted PrivateKey */
    encryptedPrivateKey) {
        this.encryptedUserKey = encryptedUserKey;
        this.encryptedPublicKey = encryptedPublicKey;
        this.encryptedPrivateKey = encryptedPrivateKey;
    }
}

;// ../../libs/common/src/auth/enums/authentication-type.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var AuthenticationType;
(function (AuthenticationType) {
    AuthenticationType[AuthenticationType["Password"] = 0] = "Password";
    AuthenticationType[AuthenticationType["Sso"] = 1] = "Sso";
    AuthenticationType[AuthenticationType["UserApiKey"] = 2] = "UserApiKey";
    AuthenticationType[AuthenticationType["AuthRequest"] = 3] = "AuthRequest";
    AuthenticationType[AuthenticationType["WebAuthn"] = 4] = "WebAuthn";
})(AuthenticationType || (AuthenticationType = {}));

;// ../../libs/common/src/auth/models/request/identity-token/token-two-factor.request.ts
class TokenTwoFactorRequest {
    constructor(provider = null, token = null, remember = false) {
        this.provider = provider;
        this.token = token;
        this.remember = remember;
    }
}

;// ../../libs/common/src/auth/services/webauthn-login/request/webauthn-login-response.request.ts

class WebAuthnLoginResponseRequest {
    constructor(credential) {
        this.id = credential.id;
        this.rawId = utils_Utils.fromBufferToUrlB64(credential.rawId);
        this.type = credential.type;
        // WARNING: do not add PRF information here by mapping
        // credential.getClientExtensionResults() into the extensions property,
        // as it will be sent to the server (leaking credentials).
        this.extensions = {}; // Extensions are handled client-side
    }
}

;// ../../libs/common/src/auth/services/webauthn-login/request/webauthn-login-assertion-response.request.ts


class WebAuthnLoginAssertionResponseRequest extends WebAuthnLoginResponseRequest {
    constructor(credential) {
        super(credential);
        if (!(credential.response instanceof AuthenticatorAssertionResponse)) {
            throw new Error("Invalid authenticator response");
        }
        this.response = {
            authenticatorData: utils_Utils.fromBufferToUrlB64(credential.response.authenticatorData),
            signature: utils_Utils.fromBufferToUrlB64(credential.response.signature),
            clientDataJSON: utils_Utils.fromBufferToUrlB64(credential.response.clientDataJSON),
            userHandle: utils_Utils.fromBufferToUrlB64(credential.response.userHandle),
        };
    }
    static fromJSON(json) {
        return Object.assign(Object.create(WebAuthnLoginAssertionResponseRequest.prototype), json);
    }
}

;// ../../libs/auth/src/common/models/domain/login-credentials.ts




class PasswordLoginCredentials {
    constructor(email, masterPassword, twoFactor) {
        this.email = email;
        this.masterPassword = masterPassword;
        this.twoFactor = twoFactor;
        this.type = AuthenticationType.Password;
    }
}
class SsoLoginCredentials {
    constructor(code, codeVerifier, redirectUrl, orgId, 
    /**
     * Optional email address for SSO login.
     * Used for looking up 2FA token on clients that support remembering 2FA token.
     */
    email, twoFactor) {
        this.code = code;
        this.codeVerifier = codeVerifier;
        this.redirectUrl = redirectUrl;
        this.orgId = orgId;
        this.email = email;
        this.twoFactor = twoFactor;
        this.type = AuthenticationType.Sso;
    }
}
class UserApiLoginCredentials {
    constructor(clientId, clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.type = AuthenticationType.UserApiKey;
    }
}
class AuthRequestLoginCredentials {
    constructor(email, accessCode, authRequestId, decryptedUserKey, decryptedMasterKey, decryptedMasterKeyHash, twoFactor) {
        this.email = email;
        this.accessCode = accessCode;
        this.authRequestId = authRequestId;
        this.decryptedUserKey = decryptedUserKey;
        this.decryptedMasterKey = decryptedMasterKey;
        this.decryptedMasterKeyHash = decryptedMasterKeyHash;
        this.twoFactor = twoFactor;
        this.type = AuthenticationType.AuthRequest;
    }
    static fromJSON(json) {
        return Object.assign(new AuthRequestLoginCredentials(json.email, json.accessCode, json.authRequestId, null, null, json.decryptedMasterKeyHash, json.twoFactor
            ? new TokenTwoFactorRequest(json.twoFactor.provider, json.twoFactor.token, json.twoFactor.remember)
            : json.twoFactor), {
            decryptedUserKey: SymmetricCryptoKey.fromJSON(json.decryptedUserKey),
            decryptedMasterKey: SymmetricCryptoKey.fromJSON(json.decryptedMasterKey),
        });
    }
}
class WebAuthnLoginCredentials {
    constructor(token, deviceResponse, prfKey) {
        this.token = token;
        this.deviceResponse = deviceResponse;
        this.prfKey = prfKey;
        this.type = AuthenticationType.WebAuthn;
    }
    static fromJSON(json) {
        return new WebAuthnLoginCredentials(json.token, Object.assign(Object.create(WebAuthnLoginAssertionResponseRequest.prototype), json.deviceResponse), SymmetricCryptoKey.fromJSON(json.prfKey));
    }
}

;// ../../libs/auth/src/common/models/domain/user-decryption-options.ts
/**
 * Key Connector decryption options. Intended to be sent to the client for use after authentication.
 * @see {@link UserDecryptionOptions}
 */
class KeyConnectorUserDecryptionOption {
    /**
     * Initializes a new instance of the KeyConnectorUserDecryptionOption from a response object.
     * @param response The key connector user decryption option response object.
     * @returns A new instance of the KeyConnectorUserDecryptionOption or undefined if `response` is nullish.
     */
    static fromResponse(response) {
        var _a;
        if (response == null) {
            return undefined;
        }
        const options = new KeyConnectorUserDecryptionOption();
        options.keyConnectorUrl = (_a = response === null || response === void 0 ? void 0 : response.keyConnectorUrl) !== null && _a !== void 0 ? _a : null;
        return options;
    }
    /**
     * Initializes a new instance of a KeyConnectorUserDecryptionOption from a JSON object.
     * @param obj JSON object to deserialize.
     * @returns A new instance of the KeyConnectorUserDecryptionOption or undefined if `obj` is nullish.
     */
    static fromJSON(obj) {
        if (obj == null) {
            return undefined;
        }
        return Object.assign(new KeyConnectorUserDecryptionOption(), obj);
    }
}
/**
 * Trusted device decryption options. Intended to be sent to the client for use after authentication.
 * @see {@link UserDecryptionOptions}
 */
class TrustedDeviceUserDecryptionOption {
    /**
     * Initializes a new instance of the TrustedDeviceUserDecryptionOption from a response object.
     * @param response The trusted device user decryption option response object.
     * @returns A new instance of the TrustedDeviceUserDecryptionOption or undefined if `response` is nullish.
     */
    static fromResponse(response) {
        var _a, _b, _c, _d;
        if (response == null) {
            return undefined;
        }
        const options = new TrustedDeviceUserDecryptionOption();
        options.hasAdminApproval = (_a = response === null || response === void 0 ? void 0 : response.hasAdminApproval) !== null && _a !== void 0 ? _a : false;
        options.hasLoginApprovingDevice = (_b = response === null || response === void 0 ? void 0 : response.hasLoginApprovingDevice) !== null && _b !== void 0 ? _b : false;
        options.hasManageResetPasswordPermission = (_c = response === null || response === void 0 ? void 0 : response.hasManageResetPasswordPermission) !== null && _c !== void 0 ? _c : false;
        options.isTdeOffboarding = (_d = response === null || response === void 0 ? void 0 : response.isTdeOffboarding) !== null && _d !== void 0 ? _d : false;
        return options;
    }
    /**
     * Initializes a new instance of the TrustedDeviceUserDecryptionOption from a JSON object.
     * @param obj JSON object to deserialize.
     * @returns A new instance of the TrustedDeviceUserDecryptionOption or undefined if `obj` is nullish.
     */
    static fromJSON(obj) {
        if (obj == null) {
            return undefined;
        }
        return Object.assign(new TrustedDeviceUserDecryptionOption(), obj);
    }
}
/**
 * Represents the decryption options the user has configured on the server. This is intended to be sent
 * to the client on authentication, and can be used to determine how to decrypt the user's vault.
 */
class UserDecryptionOptions {
    /**
     * Initializes a new instance of the UserDecryptionOptions from a response object.
     * @param response user decryption options response object
     * @returns A new instance of the UserDecryptionOptions.
     * @throws If the response is nullish, this method will throw an error. User decryption options
     * are required for client initialization.
     */
    // TODO: Change response type to `UserDecryptionOptionsResponse` after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
    static fromResponse(response) {
        if (response == null) {
            throw new Error("User Decryption Options are required for client initialization.");
        }
        const decryptionOptions = new UserDecryptionOptions();
        if (response.userDecryptionOptions) {
            // If the response has userDecryptionOptions, this means it's on a post-TDE server version and can interrogate
            // the new decryption options.
            const responseOptions = response.userDecryptionOptions;
            decryptionOptions.hasMasterPassword = responseOptions.hasMasterPassword;
            decryptionOptions.trustedDeviceOption = TrustedDeviceUserDecryptionOption.fromResponse(responseOptions.trustedDeviceOption);
            decryptionOptions.keyConnectorOption = KeyConnectorUserDecryptionOption.fromResponse(responseOptions.keyConnectorOption);
        }
        else {
            // If the response does not have userDecryptionOptions, this means it's on a pre-TDE server version and so
            // we must base our decryption options on the presence of the keyConnectorUrl.
            // Note that the presence of keyConnectorUrl implies that the user does not have a master password, as in pre-TDE
            // server versions, a master password short-circuited the addition of the keyConnectorUrl to the response.
            // TODO: remove this check after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
            const usingKeyConnector = response.keyConnectorUrl != null;
            decryptionOptions.hasMasterPassword = !usingKeyConnector;
            if (usingKeyConnector) {
                decryptionOptions.keyConnectorOption = new KeyConnectorUserDecryptionOption();
                decryptionOptions.keyConnectorOption.keyConnectorUrl = response.keyConnectorUrl;
            }
        }
        return decryptionOptions;
    }
    /**
     * Initializes a new instance of the UserDecryptionOptions from a JSON object.
     * @param obj JSON object to deserialize.
     * @returns A new instance of the UserDecryptionOptions. Will initialize even if the JSON object is nullish.
     */
    static fromJSON(obj) {
        const decryptionOptions = Object.assign(new UserDecryptionOptions(), obj);
        decryptionOptions.trustedDeviceOption = TrustedDeviceUserDecryptionOption.fromJSON(obj === null || obj === void 0 ? void 0 : obj.trustedDeviceOption);
        decryptionOptions.keyConnectorOption = KeyConnectorUserDecryptionOption.fromJSON(obj === null || obj === void 0 ? void 0 : obj.keyConnectorOption);
        return decryptionOptions;
    }
}

;// ../../libs/auth/src/common/models/domain/index.ts




;// ../../libs/auth/src/common/models/spec/fake-user-decryption-options.ts

// To discourage creating new user decryption options, we don't expose a constructor.
// These helpers are for testing purposes only.
/** Testing helper for creating new instances of `UserDecryptionOptions` */
class FakeUserDecryptionOptions extends UserDecryptionOptions {
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/** Testing helper for creating new instances of `KeyConnectorUserDecryptionOption` */
class FakeKeyConnectorUserDecryptionOption extends KeyConnectorUserDecryptionOption {
    constructor(keyConnectorUrl) {
        super();
        this.keyConnectorUrl = keyConnectorUrl;
    }
}
/** Testing helper for creating new instances of `TrustedDeviceUserDecryptionOption` */
class FakeTrustedDeviceUserDecryptionOption extends TrustedDeviceUserDecryptionOption {
    constructor(hasAdminApproval, hasLoginApprovingDevice, hasManageResetPasswordPermission, isTdeOffboarding) {
        super();
        this.hasAdminApproval = hasAdminApproval;
        this.hasLoginApprovingDevice = hasLoginApprovingDevice;
        this.hasManageResetPasswordPermission = hasManageResetPasswordPermission;
        this.isTdeOffboarding = isTdeOffboarding;
    }
}

;// ../../libs/auth/src/common/models/spec/index.ts


;// ../../libs/auth/src/common/models/index.ts



;// ../../libs/auth/src/common/services/pin/pin.service.implementation.ts
var pin_service_implementation_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore



/**
 * The persistent (stored on disk) version of the UserKey, encrypted by the PinKey.
 *
 * @remarks Persists through a client reset. Used when `requireMasterPasswordOnClientRestart` is disabled.
 * @see SetPinComponent.setPinForm.requireMasterPasswordOnClientRestart
 */
const PIN_KEY_ENCRYPTED_USER_KEY_PERSISTENT = new UserKeyDefinition(PIN_DISK, "pinKeyEncryptedUserKeyPersistent", {
    deserializer: (jsonValue) => jsonValue,
    clearOn: ["logout"],
});
/**
 * The ephemeral (stored in memory) version of the UserKey, encrypted by the PinKey.
 *
 * @remarks Does NOT persist through a client reset. Used when `requireMasterPasswordOnClientRestart` is enabled.
 * @see SetPinComponent.setPinForm.requireMasterPasswordOnClientRestart
 */
const PIN_KEY_ENCRYPTED_USER_KEY_EPHEMERAL = new UserKeyDefinition(PIN_MEMORY, "pinKeyEncryptedUserKeyEphemeral", {
    deserializer: (jsonValue) => jsonValue,
    clearOn: ["logout"],
});
/**
 * The PIN, encrypted by the UserKey.
 */
const USER_KEY_ENCRYPTED_PIN = new UserKeyDefinition(PIN_DISK, "userKeyEncryptedPin", {
    deserializer: (jsonValue) => jsonValue,
    clearOn: ["logout"],
});
class PinService {
    constructor(accountService, cryptoFunctionService, encryptService, kdfConfigService, keyGenerationService, logService, stateProvider) {
        this.accountService = accountService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.encryptService = encryptService;
        this.kdfConfigService = kdfConfigService;
        this.keyGenerationService = keyGenerationService;
        this.logService = logService;
        this.stateProvider = stateProvider;
    }
    getPinKeyEncryptedUserKeyPersistent(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot get pinKeyEncryptedUserKeyPersistent.");
            return enc_string_EncString.fromJSON(yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUserState$(PIN_KEY_ENCRYPTED_USER_KEY_PERSISTENT, userId)));
        });
    }
    /**
     * Sets the persistent (stored on disk) version of the UserKey, encrypted by the PinKey.
     */
    setPinKeyEncryptedUserKeyPersistent(pinKeyEncryptedUserKey, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot set pinKeyEncryptedUserKeyPersistent.");
            if (pinKeyEncryptedUserKey == null) {
                throw new Error("No pinKeyEncryptedUserKey provided. Cannot set pinKeyEncryptedUserKeyPersistent.");
            }
            yield this.stateProvider.setUserState(PIN_KEY_ENCRYPTED_USER_KEY_PERSISTENT, pinKeyEncryptedUserKey === null || pinKeyEncryptedUserKey === void 0 ? void 0 : pinKeyEncryptedUserKey.encryptedString, userId);
        });
    }
    clearPinKeyEncryptedUserKeyPersistent(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot clear pinKeyEncryptedUserKeyPersistent.");
            yield this.stateProvider.setUserState(PIN_KEY_ENCRYPTED_USER_KEY_PERSISTENT, null, userId);
        });
    }
    getPinKeyEncryptedUserKeyEphemeral(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot get pinKeyEncryptedUserKeyEphemeral.");
            return enc_string_EncString.fromJSON(yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUserState$(PIN_KEY_ENCRYPTED_USER_KEY_EPHEMERAL, userId)));
        });
    }
    /**
     * Sets the ephemeral (stored in memory) version of the UserKey, encrypted by the PinKey.
     */
    setPinKeyEncryptedUserKeyEphemeral(pinKeyEncryptedUserKey, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot set pinKeyEncryptedUserKeyEphemeral.");
            if (pinKeyEncryptedUserKey == null) {
                throw new Error("No pinKeyEncryptedUserKey provided. Cannot set pinKeyEncryptedUserKeyEphemeral.");
            }
            yield this.stateProvider.setUserState(PIN_KEY_ENCRYPTED_USER_KEY_EPHEMERAL, pinKeyEncryptedUserKey === null || pinKeyEncryptedUserKey === void 0 ? void 0 : pinKeyEncryptedUserKey.encryptedString, userId);
        });
    }
    clearPinKeyEncryptedUserKeyEphemeral(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot clear pinKeyEncryptedUserKeyEphemeral.");
            yield this.stateProvider.setUserState(PIN_KEY_ENCRYPTED_USER_KEY_EPHEMERAL, null, userId);
        });
    }
    createPinKeyEncryptedUserKey(pin, userKey, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot create pinKeyEncryptedUserKey.");
            if (!userKey) {
                throw new Error("No UserKey provided. Cannot create pinKeyEncryptedUserKey.");
            }
            const email = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.accounts$.pipe((0,external_rxjs_namespaceObject.map)((accounts) => accounts[userId].email)));
            const kdfConfig = yield this.kdfConfigService.getKdfConfig(userId);
            const pinKey = yield this.makePinKey(pin, email, kdfConfig);
            return yield this.encryptService.wrapSymmetricKey(userKey, pinKey);
        });
    }
    storePinKeyEncryptedUserKey(pinKeyEncryptedUserKey, storeAsEphemeral, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot store pinKeyEncryptedUserKey.");
            if (storeAsEphemeral) {
                yield this.setPinKeyEncryptedUserKeyEphemeral(pinKeyEncryptedUserKey, userId);
            }
            else {
                yield this.setPinKeyEncryptedUserKeyPersistent(pinKeyEncryptedUserKey, userId);
            }
        });
    }
    getUserKeyEncryptedPin(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot get userKeyEncryptedPin.");
            return enc_string_EncString.fromJSON(yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUserState$(USER_KEY_ENCRYPTED_PIN, userId)));
        });
    }
    setUserKeyEncryptedPin(userKeyEncryptedPin, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot set userKeyEncryptedPin.");
            yield this.stateProvider.setUserState(USER_KEY_ENCRYPTED_PIN, userKeyEncryptedPin === null || userKeyEncryptedPin === void 0 ? void 0 : userKeyEncryptedPin.encryptedString, userId);
        });
    }
    clearUserKeyEncryptedPin(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot clear userKeyEncryptedPin.");
            yield this.stateProvider.setUserState(USER_KEY_ENCRYPTED_PIN, null, userId);
        });
    }
    createUserKeyEncryptedPin(pin, userKey) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (!userKey) {
                throw new Error("No UserKey provided. Cannot create userKeyEncryptedPin.");
            }
            return yield this.encryptService.encryptString(pin, userKey);
        });
    }
    makePinKey(pin, salt, kdfConfig) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            const start = Date.now();
            const pinKey = yield this.keyGenerationService.deriveKeyFromPassword(pin, salt, kdfConfig);
            this.logService.info(`[Pin Service] deriving pin key took ${Date.now() - start}ms`);
            return (yield this.keyGenerationService.stretchKey(pinKey));
        });
    }
    getPinLockType(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot get PinLockType.");
            const aUserKeyEncryptedPinIsSet = !!(yield this.getUserKeyEncryptedPin(userId));
            const aPinKeyEncryptedUserKeyPersistentIsSet = !!(yield this.getPinKeyEncryptedUserKeyPersistent(userId));
            if (aPinKeyEncryptedUserKeyPersistentIsSet) {
                return "PERSISTENT";
            }
            else if (aUserKeyEncryptedPinIsSet && !aPinKeyEncryptedUserKeyPersistentIsSet) {
                return "EPHEMERAL";
            }
            else {
                return "DISABLED";
            }
        });
    }
    isPinSet(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot determine if PIN is set.");
            return (yield this.getPinLockType(userId)) !== "DISABLED";
        });
    }
    isPinDecryptionAvailable(userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot determine if decryption of user key via PIN is available.");
            const pinLockType = yield this.getPinLockType(userId);
            switch (pinLockType) {
                case "DISABLED":
                    return false;
                case "PERSISTENT":
                    // The above getPinLockType call ensures that we have either a PinKeyEncryptedUserKey  set.
                    return true;
                case "EPHEMERAL": {
                    // The above getPinLockType call ensures that we have a UserKeyEncryptedPin set.
                    // However, we must additively check to ensure that we have a set PinKeyEncryptedUserKeyEphemeral b/c otherwise
                    // we cannot take a PIN, derive a PIN key, and decrypt the ephemeral UserKey.
                    const pinKeyEncryptedUserKeyEphemeral = yield this.getPinKeyEncryptedUserKeyEphemeral(userId);
                    return Boolean(pinKeyEncryptedUserKeyEphemeral);
                }
                default: {
                    // Compile-time check for exhaustive switch
                    const _exhaustiveCheck = pinLockType;
                    throw new Error(`Unexpected pinLockType: ${_exhaustiveCheck}`);
                }
            }
        });
    }
    decryptUserKeyWithPin(pin, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot decrypt user key with PIN.");
            try {
                const pinLockType = yield this.getPinLockType(userId);
                const pinKeyEncryptedUserKey = yield this.getPinKeyEncryptedKeys(pinLockType, userId);
                const email = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.accounts$.pipe((0,external_rxjs_namespaceObject.map)((accounts) => accounts[userId].email)));
                const kdfConfig = yield this.kdfConfigService.getKdfConfig(userId);
                const userKey = yield this.decryptUserKey(userId, pin, email, kdfConfig, pinKeyEncryptedUserKey);
                if (!userKey) {
                    this.logService.warning(`User key null after pin key decryption.`);
                    return null;
                }
                if (!(yield this.validatePin(userKey, pin, userId))) {
                    this.logService.warning(`Pin key decryption successful but pin validation failed.`);
                    return null;
                }
                return userKey;
            }
            catch (error) {
                this.logService.error(`Error decrypting user key with pin: ${error}`);
                return null;
            }
        });
    }
    /**
     * Decrypts the UserKey with the provided PIN.
     */
    decryptUserKey(userId, pin, salt, kdfConfig, pinKeyEncryptedUserKey) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot decrypt user key.");
            pinKeyEncryptedUserKey || (pinKeyEncryptedUserKey = yield this.getPinKeyEncryptedUserKeyPersistent(userId));
            pinKeyEncryptedUserKey || (pinKeyEncryptedUserKey = yield this.getPinKeyEncryptedUserKeyEphemeral(userId));
            if (!pinKeyEncryptedUserKey) {
                throw new Error("No pinKeyEncryptedUserKey found.");
            }
            const pinKey = yield this.makePinKey(pin, salt, kdfConfig);
            const userKey = yield this.encryptService.unwrapSymmetricKey(pinKeyEncryptedUserKey, pinKey);
            return userKey;
        });
    }
    /**
     * Gets the user's `pinKeyEncryptedUserKey` (persistent or ephemeral)
     * (if one exists) based on the user's PinLockType.
     *
     * @throws If PinLockType is 'DISABLED' or if userId is not provided
     */
    getPinKeyEncryptedKeys(pinLockType, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot get PinKey encrypted keys.");
            switch (pinLockType) {
                case "PERSISTENT": {
                    return yield this.getPinKeyEncryptedUserKeyPersistent(userId);
                }
                case "EPHEMERAL": {
                    return yield this.getPinKeyEncryptedUserKeyEphemeral(userId);
                }
                case "DISABLED":
                    throw new Error("Pin is disabled");
                default: {
                    // Compile-time check for exhaustive switch
                    const _exhaustiveCheck = pinLockType;
                    return _exhaustiveCheck;
                }
            }
        });
    }
    validatePin(userKey, pin, userId) {
        return pin_service_implementation_awaiter(this, void 0, void 0, function* () {
            this.validateUserId(userId, "Cannot validate PIN.");
            const userKeyEncryptedPin = yield this.getUserKeyEncryptedPin(userId);
            const decryptedPin = yield this.encryptService.decryptString(userKeyEncryptedPin, userKey);
            const isPinValid = this.cryptoFunctionService.compareFast(decryptedPin, pin);
            return isPinValid;
        });
    }
    /**
     * Throws a custom error message if user ID is not provided.
     */
    validateUserId(userId, errorMessage = "") {
        if (!userId) {
            throw new Error(`User ID is required. ${errorMessage}`);
        }
    }
}

;// ../../libs/auth/src/common/services/login-email/login-email.service.ts
var login_email_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


// FIXME: remove `src` and fix import
// eslint-disable-next-line no-restricted-imports

const LOGIN_EMAIL = new KeyDefinition(LOGIN_EMAIL_MEMORY, "loginEmail", {
    deserializer: (value) => value,
});
const STORED_EMAIL = new KeyDefinition(LOGIN_EMAIL_DISK, "storedEmail", {
    deserializer: (value) => value,
});
class LoginEmailService {
    constructor(accountService, authService, stateProvider) {
        this.accountService = accountService;
        this.authService = authService;
        this.stateProvider = stateProvider;
        this.loginEmailState = this.stateProvider.getGlobal(LOGIN_EMAIL);
        this.storedEmailState = this.stateProvider.getGlobal(STORED_EMAIL);
        // In order to determine if an account is being added, we check if any account is not logged out
        this.addingAccount$ = this.authService.authStatuses$.pipe(switchMap((statuses) => login_email_service_awaiter(this, void 0, void 0, function* () {
            // We don't want to consider the active account since it may have just changed auth status to logged in
            // which would make this observable think an account is being added
            const activeUser = yield firstValueFrom(this.accountService.activeAccount$);
            if (activeUser) {
                delete statuses[activeUser.id];
            }
            return Object.values(statuses).some((status) => status !== AuthenticationStatus.LoggedOut);
        })));
        this.loginEmail$ = this.loginEmailState.state$;
        this.rememberedEmail$ = this.storedEmailState.state$.pipe(switchMap((storedEmail) => login_email_service_awaiter(this, void 0, void 0, function* () {
            // When adding an account, we don't show the stored email
            if (yield firstValueFrom(this.addingAccount$)) {
                return null;
            }
            return storedEmail;
        })));
    }
    /** Sets the login email in memory.
     * The login email is the email that is being used in the current login process.
     */
    setLoginEmail(email) {
        return login_email_service_awaiter(this, void 0, void 0, function* () {
            yield this.loginEmailState.update((_) => email);
        });
    }
    /**
     * Clears the in-progress login email from state.
     * Note: Only clear on successful login or you are sure they are not needed.
     * The extension client uses these values to maintain the email between login and 2fa components so
     * we do not want to clear them too early.
     */
    clearLoginEmail() {
        return login_email_service_awaiter(this, void 0, void 0, function* () {
            yield this.loginEmailState.update((_) => null);
        });
    }
    setRememberedEmailChoice(email, remember) {
        return login_email_service_awaiter(this, void 0, void 0, function* () {
            if (remember) {
                yield this.storedEmailState.update((_) => email);
            }
            else {
                yield this.storedEmailState.update((_) => null);
            }
        });
    }
    clearRememberedEmail() {
        return login_email_service_awaiter(this, void 0, void 0, function* () {
            yield this.storedEmailState.update((_) => null);
        });
    }
}

;// ../../libs/common/src/models/request/prelogin.request.ts
class PreloginRequest {
    constructor(email) {
        this.email = email;
    }
}

;// ../../libs/common/src/platform/scheduling/task-scheduler.service.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

/**
 * Creates a RXJS scheduler based on a {@link TaskSchedulerService}.
 *
 * @description This API defers to `TaskSchedulerService` to schedule a task to be ran
 * in the future but the task that is ran is NOT the remainder of your RXJS pipeline. The
 * task you want ran must instead be registered in a location reachable on a service worker
 * startup (on browser). An example of an acceptible location is the constructor of a service
 * you know is created in `MainBackground`. Uses of this API in other clients _can_ have the
 * `registerTaskHandler` call in more places, but in order to have it work across clients
 * it is recommended to register it according to the rules of browser.
 *
 * @link https://rxjs.dev/guide/scheduler#using-schedulers
 *
 * @example
 * ```ts
 * class MyService {
 *   constructor(messageListener: MessageListener, taskScheduler: TaskSchedulerService) {
 *    // VERY IMPORTANT!
 *    this.taskSchedulerService.registerTaskHandler(SchedulerTaskNames.myTaskName, async () => {
 *      await this.runEvent();
 *    });
 *
 *     messageListener.messages$(MY_MESSAGE).pipe(
 *        debounceTime(
 *          10 * 1000,
 *          toScheduler(taskScheduler, ShedulerTaskNames.myTaskName),
 *        ),
 *        switchMap(() => this.runEvent()),
 *     )
 *   }
 * }
 * ```
 *
 * @param taskScheduler The task scheduler service to use to shedule RXJS work.
 * @param taskName The name of the task that the handler should be registered and scheduled based on.
 * @returns A SchedulerLike object that can be passed in to RXJS operators like `delay` and `timeout`.
 */
function toScheduler(taskScheduler, taskName) {
    return new TaskSchedulerSheduler(taskScheduler, taskName);
}
class TaskSchedulerSheduler {
    constructor(taskSchedulerService, taskName) {
        this.taskSchedulerService = taskSchedulerService;
        this.taskName = taskName;
    }
    schedule(work, delay, state) {
        return this.taskSchedulerService.setTimeout(this.taskName, delay !== null && delay !== void 0 ? delay : 0);
    }
    now() {
        return asyncScheduler.now();
    }
}
class TaskSchedulerService {
}

;// ../../libs/common/src/platform/scheduling/default-task-scheduler.service.ts
var default_task_scheduler_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class DefaultTaskSchedulerService extends TaskSchedulerService {
    constructor(logService) {
        super();
        this.logService = logService;
        this.taskHandlers = new Map();
    }
    /**
     * Sets a timeout and returns the timeout id.
     *
     * @param taskName - The name of the task. Unused in the base implementation.
     * @param delayInMs - The delay in milliseconds.
     */
    setTimeout(taskName, delayInMs) {
        this.validateRegisteredTask(taskName);
        const timeoutHandle = globalThis.setTimeout(() => this.triggerTask(taskName), delayInMs);
        return new external_rxjs_namespaceObject.Subscription(() => globalThis.clearTimeout(timeoutHandle));
    }
    /**
     * Sets an interval and returns the interval id.
     *
     * @param taskName - The name of the task. Unused in the base implementation.
     * @param intervalInMs - The interval in milliseconds.
     * @param _initialDelayInMs - The initial delay in milliseconds. Unused in the base implementation.
     */
    setInterval(taskName, intervalInMs, _initialDelayInMs) {
        this.validateRegisteredTask(taskName);
        const intervalHandle = globalThis.setInterval(() => this.triggerTask(taskName), intervalInMs);
        return new external_rxjs_namespaceObject.Subscription(() => globalThis.clearInterval(intervalHandle));
    }
    /**
     * Registers a task handler.
     *
     * @param taskName - The name of the task.
     * @param handler - The task handler.
     */
    registerTaskHandler(taskName, handler) {
        const existingHandler = this.taskHandlers.get(taskName);
        if (existingHandler) {
            this.logService.warning(`Task handler for ${taskName} already exists. Overwriting.`);
            this.unregisterTaskHandler(taskName);
        }
        this.taskHandlers.set(taskName, handler);
    }
    /**
     * Unregisters a task handler.
     *
     * @param taskName - The name of the task.
     */
    unregisterTaskHandler(taskName) {
        this.taskHandlers.delete(taskName);
    }
    /**
     * Triggers a task.
     *
     * @param taskName - The name of the task.
     * @param _periodInMinutes - The period in minutes. Unused in the base implementation.
     */
    triggerTask(taskName, _periodInMinutes) {
        return default_task_scheduler_service_awaiter(this, void 0, void 0, function* () {
            const handler = this.taskHandlers.get(taskName);
            if (handler) {
                handler();
            }
        });
    }
    /**
     * Validates that a task handler is registered.
     *
     * @param taskName - The name of the task.
     */
    validateRegisteredTask(taskName) {
        if (!this.taskHandlers.has(taskName)) {
            throw new Error(`Task handler for ${taskName} not registered. Unable to schedule task.`);
        }
    }
}

;// ../../libs/common/src/platform/scheduling/scheduled-task-name.enum.ts
const ScheduledTaskNames = {
    generatePasswordClearClipboardTimeout: "generatePasswordClearClipboardTimeout",
    systemClearClipboardTimeout: "systemClearClipboardTimeout",
    loginStrategySessionTimeout: "loginStrategySessionTimeout",
    notificationsReconnectTimeout: "notificationsReconnectTimeout",
    fido2ClientAbortTimeout: "fido2ClientAbortTimeout",
    scheduleNextSyncInterval: "scheduleNextSyncInterval",
    eventUploadsInterval: "eventUploadsInterval",
    vaultTimeoutCheckInterval: "vaultTimeoutCheckInterval",
    clearPopupViewCache: "clearPopupViewCache",
};

;// ../../libs/common/src/platform/scheduling/index.ts




;// ../../libs/key-management/src/biometrics/biometric.state.ts

/**
 * Indicates whether the user elected to store a biometric key to unlock their vault.
 */
const BIOMETRIC_UNLOCK_ENABLED = new UserKeyDefinition(BIOMETRIC_SETTINGS_DISK, "biometricUnlockEnabled", {
    deserializer: (obj) => obj,
    clearOn: [],
});
/**
 * Boolean indicating the user has elected to require a password to use their biometric key upon starting the application.
 *
 * A true setting controls whether {@link ENCRYPTED_CLIENT_KEY_HALF} is set.
 */
const REQUIRE_PASSWORD_ON_START = new UserKeyDefinition(BIOMETRIC_SETTINGS_DISK, "requirePasswordOnStart", {
    deserializer: (value) => value,
    clearOn: [],
});
/**
 * If the user has elected to require a password on first unlock of an application instance, this key will store the
 * encrypted client key half used to unlock the vault.
 *
 * For operating systems without application-level key storage, this key half is concatenated with a signature
 * provided by the OS and used to encrypt the biometric key prior to storage.
 */
const ENCRYPTED_CLIENT_KEY_HALF = new UserKeyDefinition(BIOMETRIC_SETTINGS_DISK, "clientKeyHalf", {
    deserializer: (obj) => obj,
    clearOn: ["logout"],
});
/**
 * Indicates the user has been warned about the security implications of using biometrics and, depending on the OS,
 * recommended to require a password on first unlock of an application instance.
 */
const DISMISSED_REQUIRE_PASSWORD_ON_START_CALLOUT = new UserKeyDefinition(BIOMETRIC_SETTINGS_DISK, "dismissedBiometricRequirePasswordOnStartCallout", {
    deserializer: (obj) => obj,
    clearOn: [],
});
/**
 * Stores whether the user has elected to cancel the biometric prompt. This is stored on disk due to process-reload
 * wiping memory state. We don't want to prompt the user again if they've elected to cancel.
 */
const PROMPT_CANCELLED = KeyDefinition.record(BIOMETRIC_SETTINGS_DISK, "promptCancelled", {
    deserializer: (obj) => obj,
});
/**
 * Stores whether the user has elected to automatically prompt for biometric unlock on application start.
 */
const PROMPT_AUTOMATICALLY = new UserKeyDefinition(BIOMETRIC_SETTINGS_DISK, "promptAutomatically", {
    deserializer: (obj) => obj,
    clearOn: [],
});
/**
 * Stores whether or not IPC handshake has been validated this session.
 */
const FINGERPRINT_VALIDATED = new KeyDefinition(BIOMETRIC_SETTINGS_DISK, "fingerprintValidated", {
    deserializer: (obj) => obj,
});
/**
 * Last process reload time
 */
const LAST_PROCESS_RELOAD = new KeyDefinition(BIOMETRIC_SETTINGS_DISK, "lastProcessReload", {
    deserializer: (obj) => new Date(obj),
});

;// ../../libs/key-management/src/biometrics/biometric-state.service.ts
var biometric_state_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class BiometricStateService {
}
class DefaultBiometricStateService {
    constructor(stateProvider) {
        this.stateProvider = stateProvider;
        this.biometricUnlockEnabledState = this.stateProvider.getActive(BIOMETRIC_UNLOCK_ENABLED);
        this.biometricUnlockEnabled$ = this.biometricUnlockEnabledState.state$.pipe((0,external_rxjs_namespaceObject.map)(Boolean));
        this.requirePasswordOnStartState = this.stateProvider.getActive(REQUIRE_PASSWORD_ON_START);
        this.requirePasswordOnStart$ = this.requirePasswordOnStartState.state$.pipe((0,external_rxjs_namespaceObject.map)((value) => !!value));
        this.encryptedClientKeyHalfState = this.stateProvider.getActive(ENCRYPTED_CLIENT_KEY_HALF);
        this.encryptedClientKeyHalf$ = this.encryptedClientKeyHalfState.state$.pipe((0,external_rxjs_namespaceObject.map)(encryptedClientKeyHalfToEncString));
        this.dismissedRequirePasswordOnStartCalloutState = this.stateProvider.getActive(DISMISSED_REQUIRE_PASSWORD_ON_START_CALLOUT);
        this.dismissedRequirePasswordOnStartCallout$ =
            this.dismissedRequirePasswordOnStartCalloutState.state$.pipe((0,external_rxjs_namespaceObject.map)(Boolean));
        this.promptCancelledState = this.stateProvider.getGlobal(PROMPT_CANCELLED);
        this.promptCancelled$ = (0,external_rxjs_namespaceObject.combineLatest)([
            this.stateProvider.activeUserId$,
            this.promptCancelledState.state$,
        ]).pipe((0,external_rxjs_namespaceObject.map)(([userId, record]) => {
            var _a;
            return userId != null ? ((_a = record === null || record === void 0 ? void 0 : record[userId]) !== null && _a !== void 0 ? _a : false) : false;
        }));
        this.promptAutomaticallyState = this.stateProvider.getActive(PROMPT_AUTOMATICALLY);
        this.promptAutomatically$ = this.promptAutomaticallyState.state$.pipe((0,external_rxjs_namespaceObject.map)(Boolean));
        this.fingerprintValidatedState = this.stateProvider.getGlobal(FINGERPRINT_VALIDATED);
        this.fingerprintValidated$ = this.fingerprintValidatedState.state$.pipe((0,external_rxjs_namespaceObject.map)(Boolean));
        this.lastProcessReloadState = this.stateProvider.getGlobal(LAST_PROCESS_RELOAD);
        this.lastProcessReload$ = this.lastProcessReloadState.state$;
    }
    setBiometricUnlockEnabled(enabled) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.biometricUnlockEnabledState.update(() => enabled);
        });
    }
    getBiometricUnlockEnabled(userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUser(userId, BIOMETRIC_UNLOCK_ENABLED).state$.pipe((0,external_rxjs_namespaceObject.map)(Boolean)));
        });
    }
    setRequirePasswordOnStart(value) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            let currentActiveId = undefined;
            yield this.requirePasswordOnStartState.update((_, [userId]) => {
                currentActiveId = userId;
                return value;
            }, {
                combineLatestWith: this.requirePasswordOnStartState.combinedState$,
            });
            if (!value && currentActiveId) {
                yield this.removeEncryptedClientKeyHalf(currentActiveId);
            }
        });
    }
    setEncryptedClientKeyHalf(encryptedKeyHalf, userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            var _a;
            const value = (_a = encryptedKeyHalf === null || encryptedKeyHalf === void 0 ? void 0 : encryptedKeyHalf.encryptedString) !== null && _a !== void 0 ? _a : null;
            if (userId) {
                yield this.stateProvider.getUser(userId, ENCRYPTED_CLIENT_KEY_HALF).update(() => value);
            }
            else {
                yield this.encryptedClientKeyHalfState.update(() => value);
            }
        });
    }
    removeEncryptedClientKeyHalf(userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateProvider.getUser(userId, ENCRYPTED_CLIENT_KEY_HALF).update(() => null);
        });
    }
    getRequirePasswordOnStart(userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            return !!(yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUser(userId, REQUIRE_PASSWORD_ON_START).state$));
        });
    }
    getEncryptedClientKeyHalf(userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider
                .getUser(userId, ENCRYPTED_CLIENT_KEY_HALF)
                .state$.pipe((0,external_rxjs_namespaceObject.map)(encryptedClientKeyHalfToEncStri