/* tracker-statement.c generated by valac 0.56.3, the Vala compiler
 * generated from tracker-statement.vala, do not modify */

/*
 * Copyright (C) 2018, Red Hat Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/**
 * tracker_sparql_statement_execute_finish:
 * @self: a #TrackerSparqlStatement
 * @_res_: The #GAsyncResult from the callback used to return the #TrackerSparqlCursor
 * @error: The error which occurred or %NULL
 *
 * Finishes the asynchronous operation started through
 * tracker_sparql_statement_execute_async().
 *
 * Returns: (transfer full): A #TrackerSparqlCursor
 */

#include "libtracker-sparql/tracker-generated-no-checks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib-object.h>

enum  {
	TRACKER_SPARQL_STATEMENT_0_PROPERTY,
	TRACKER_SPARQL_STATEMENT_SPARQL_PROPERTY,
	TRACKER_SPARQL_STATEMENT_CONNECTION_PROPERTY,
	TRACKER_SPARQL_STATEMENT_NUM_PROPERTIES
};
static GParamSpec* tracker_sparql_statement_properties[TRACKER_SPARQL_STATEMENT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _TrackerSparqlStatementPrivate {
	gchar* _sparql;
	TrackerSparqlConnection* _connection;
};

static gint TrackerSparqlStatement_private_offset;
static gpointer tracker_sparql_statement_parent_class = NULL;

static void tracker_sparql_statement_real_bind_int (TrackerSparqlStatement* self,
                                             const gchar* name,
                                             gint64 value);
static void tracker_sparql_statement_real_bind_boolean (TrackerSparqlStatement* self,
                                                 const gchar* name,
                                                 gboolean value);
static void tracker_sparql_statement_real_bind_string (TrackerSparqlStatement* self,
                                                const gchar* name,
                                                const gchar* value);
static void tracker_sparql_statement_real_bind_double (TrackerSparqlStatement* self,
                                                const gchar* name,
                                                gdouble value);
static TrackerSparqlCursor* tracker_sparql_statement_real_execute (TrackerSparqlStatement* self,
                                                            GCancellable* cancellable,
                                                            GError** error);
static void tracker_sparql_statement_finalize (GObject * obj);
static GType tracker_sparql_statement_get_type_once (void);
static void _vala_tracker_sparql_statement_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_tracker_sparql_statement_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
tracker_sparql_statement_get_instance_private (TrackerSparqlStatement* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerSparqlStatement_private_offset);
}

/**
 * tracker_sparql_statement_bind_int:
 * @self: a #TrackerSparqlStatement
 * @name: variable name
 * @value: value
 *
 * Binds the integer @value to variable @name.
 */
static void
tracker_sparql_statement_real_bind_int (TrackerSparqlStatement* self,
                                        const gchar* name,
                                        gint64 value)
{
#line 56 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_statement_bind_int'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 56 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	return;
#line 111 "tracker-statement.c"
}

void
tracker_sparql_statement_bind_int (TrackerSparqlStatement* self,
                                   const gchar* name,
                                   gint64 value)
{
	TrackerSparqlStatementClass* _klass_;
#line 56 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_return_if_fail (self != NULL);
#line 56 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	_klass_ = TRACKER_SPARQL_STATEMENT_GET_CLASS (self);
#line 56 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	if (_klass_->bind_int) {
#line 56 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		_klass_->bind_int (self, name, value);
#line 128 "tracker-statement.c"
	}
}

/**
 * tracker_sparql_statement_bind_boolean:
 * @self: a #TrackerSparqlStatement
 * @name: variable name
 * @value: value
 *
 * Binds the boolean @value to variable @name.
 */
static void
tracker_sparql_statement_real_bind_boolean (TrackerSparqlStatement* self,
                                            const gchar* name,
                                            gboolean value)
{
#line 66 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_statement_bind_boolean'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 66 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	return;
#line 149 "tracker-statement.c"
}

void
tracker_sparql_statement_bind_boolean (TrackerSparqlStatement* self,
                                       const gchar* name,
                                       gboolean value)
{
	TrackerSparqlStatementClass* _klass_;
#line 66 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_return_if_fail (self != NULL);
#line 66 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	_klass_ = TRACKER_SPARQL_STATEMENT_GET_CLASS (self);
#line 66 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	if (_klass_->bind_boolean) {
#line 66 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		_klass_->bind_boolean (self, name, value);
#line 166 "tracker-statement.c"
	}
}

/**
 * tracker_sparql_statement_bind_string:
 * @self: a #TrackerSparqlStatement
 * @name: variable name
 * @value: value
 *
 * Binds the string @value to variable @name.
 */
static void
tracker_sparql_statement_real_bind_string (TrackerSparqlStatement* self,
                                           const gchar* name,
                                           const gchar* value)
{
#line 76 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_statement_bind_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 76 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	return;
#line 187 "tracker-statement.c"
}

void
tracker_sparql_statement_bind_string (TrackerSparqlStatement* self,
                                      const gchar* name,
                                      const gchar* value)
{
	TrackerSparqlStatementClass* _klass_;
#line 76 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_return_if_fail (self != NULL);
#line 76 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	_klass_ = TRACKER_SPARQL_STATEMENT_GET_CLASS (self);
#line 76 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	if (_klass_->bind_string) {
#line 76 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		_klass_->bind_string (self, name, value);
#line 204 "tracker-statement.c"
	}
}

/**
 * tracker_sparql_statement_bind_double:
 * @self: a #TrackerSparqlStatement
 * @name: variable name
 * @value: value
 *
 * Binds the double @value to variable @name.
 */
static void
tracker_sparql_statement_real_bind_double (TrackerSparqlStatement* self,
                                           const gchar* name,
                                           gdouble value)
{
#line 86 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_statement_bind_double'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 86 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	return;
#line 225 "tracker-statement.c"
}

void
tracker_sparql_statement_bind_double (TrackerSparqlStatement* self,
                                      const gchar* name,
                                      gdouble value)
{
	TrackerSparqlStatementClass* _klass_;
#line 86 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_return_if_fail (self != NULL);
#line 86 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	_klass_ = TRACKER_SPARQL_STATEMENT_GET_CLASS (self);
#line 86 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	if (_klass_->bind_double) {
#line 86 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		_klass_->bind_double (self, name, value);
#line 242 "tracker-statement.c"
	}
}

/**
 * tracker_sparql_statement_execute:
 * @self: a #TrackerSparqlStatement
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Executes the SPARQL query with the currently bound values.
 *
 * Returns: (transfer full): A #TrackerSparqlCursor
 */
static TrackerSparqlCursor*
tracker_sparql_statement_real_execute (TrackerSparqlStatement* self,
                                       GCancellable* cancellable,
                                       GError** error)
{
#line 98 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_statement_execute'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 98 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	return NULL;
#line 265 "tracker-statement.c"
}

TrackerSparqlCursor*
tracker_sparql_statement_execute (TrackerSparqlStatement* self,
                                  GCancellable* cancellable,
                                  GError** error)
{
	TrackerSparqlStatementClass* _klass_;
#line 98 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 98 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	_klass_ = TRACKER_SPARQL_STATEMENT_GET_CLASS (self);
#line 98 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	if (_klass_->execute) {
#line 98 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		return _klass_->execute (self, cancellable, error);
#line 282 "tracker-statement.c"
	}
#line 98 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	return NULL;
#line 286 "tracker-statement.c"
}

void
tracker_sparql_statement_execute_async (TrackerSparqlStatement* self,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	TrackerSparqlStatementClass* _klass_;
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	_klass_ = TRACKER_SPARQL_STATEMENT_GET_CLASS (self);
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	if (_klass_->execute_async) {
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		_klass_->execute_async (self, cancellable, _callback_, _user_data_);
#line 302 "tracker-statement.c"
	}
}

TrackerSparqlCursor*
tracker_sparql_statement_execute_finish (TrackerSparqlStatement* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	TrackerSparqlStatementClass* _klass_;
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	_klass_ = TRACKER_SPARQL_STATEMENT_GET_CLASS (self);
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	if (_klass_->execute_finish) {
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		return _klass_->execute_finish (self, _res_, error);
#line 318 "tracker-statement.c"
	}
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	return NULL;
#line 322 "tracker-statement.c"
}

TrackerSparqlStatement*
tracker_sparql_statement_construct (GType object_type)
{
	TrackerSparqlStatement * self = NULL;
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	self = (TrackerSparqlStatement*) g_object_new (object_type, NULL);
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	return self;
#line 333 "tracker-statement.c"
}

const gchar*
tracker_sparql_statement_get_sparql (TrackerSparqlStatement* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 45 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	_tmp0_ = self->priv->_sparql;
#line 45 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	result = _tmp0_;
#line 45 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	return result;
#line 349 "tracker-statement.c"
}

void
tracker_sparql_statement_set_sparql (TrackerSparqlStatement* self,
                                     const gchar* value)
{
	gchar* old_value;
#line 45 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_return_if_fail (self != NULL);
#line 45 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	old_value = tracker_sparql_statement_get_sparql (self);
#line 45 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 363 "tracker-statement.c"
		gchar* _tmp0_;
#line 45 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		_tmp0_ = g_strdup (value);
#line 45 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		_g_free0 (self->priv->_sparql);
#line 45 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		self->priv->_sparql = _tmp0_;
#line 45 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		g_object_notify_by_pspec ((GObject *) self, tracker_sparql_statement_properties[TRACKER_SPARQL_STATEMENT_SPARQL_PROPERTY]);
#line 373 "tracker-statement.c"
	}
}

TrackerSparqlConnection*
tracker_sparql_statement_get_connection (TrackerSparqlStatement* self)
{
	TrackerSparqlConnection* result;
	TrackerSparqlConnection* _tmp0_;
#line 46 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 46 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	_tmp0_ = self->priv->_connection;
#line 46 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	result = _tmp0_;
#line 46 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	return result;
#line 390 "tracker-statement.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 46 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	return self ? g_object_ref (self) : NULL;
#line 398 "tracker-statement.c"
}

void
tracker_sparql_statement_set_connection (TrackerSparqlStatement* self,
                                         TrackerSparqlConnection* value)
{
	TrackerSparqlConnection* old_value;
#line 46 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_return_if_fail (self != NULL);
#line 46 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	old_value = tracker_sparql_statement_get_connection (self);
#line 46 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	if (old_value != value) {
#line 412 "tracker-statement.c"
		TrackerSparqlConnection* _tmp0_;
#line 46 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 46 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		_g_object_unref0 (self->priv->_connection);
#line 46 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		self->priv->_connection = _tmp0_;
#line 46 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		g_object_notify_by_pspec ((GObject *) self, tracker_sparql_statement_properties[TRACKER_SPARQL_STATEMENT_CONNECTION_PROPERTY]);
#line 422 "tracker-statement.c"
	}
}

static void
tracker_sparql_statement_class_init (TrackerSparqlStatementClass * klass,
                                     gpointer klass_data)
{
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	tracker_sparql_statement_parent_class = g_type_class_peek_parent (klass);
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_type_class_adjust_private_offset (klass, &TrackerSparqlStatement_private_offset);
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	((TrackerSparqlStatementClass *) klass)->bind_int = (void (*) (TrackerSparqlStatement*, const gchar*, gint64)) tracker_sparql_statement_real_bind_int;
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	((TrackerSparqlStatementClass *) klass)->bind_boolean = (void (*) (TrackerSparqlStatement*, const gchar*, gboolean)) tracker_sparql_statement_real_bind_boolean;
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	((TrackerSparqlStatementClass *) klass)->bind_string = (void (*) (TrackerSparqlStatement*, const gchar*, const gchar*)) tracker_sparql_statement_real_bind_string;
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	((TrackerSparqlStatementClass *) klass)->bind_double = (void (*) (TrackerSparqlStatement*, const gchar*, gdouble)) tracker_sparql_statement_real_bind_double;
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	((TrackerSparqlStatementClass *) klass)->execute = (TrackerSparqlCursor* (*) (TrackerSparqlStatement*, GCancellable*, GError**)) tracker_sparql_statement_real_execute;
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_statement_get_property;
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_statement_set_property;
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_statement_finalize;
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_STATEMENT_SPARQL_PROPERTY, tracker_sparql_statement_properties[TRACKER_SPARQL_STATEMENT_SPARQL_PROPERTY] = g_param_spec_string ("sparql", "sparql", "sparql", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_STATEMENT_CONNECTION_PROPERTY, tracker_sparql_statement_properties[TRACKER_SPARQL_STATEMENT_CONNECTION_PROPERTY] = g_param_spec_object ("connection", "connection", "connection", TRACKER_SPARQL_TYPE_CONNECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 454 "tracker-statement.c"
}

static void
tracker_sparql_statement_instance_init (TrackerSparqlStatement * self,
                                        gpointer klass)
{
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	self->priv = tracker_sparql_statement_get_instance_private (self);
#line 463 "tracker-statement.c"
}

static void
tracker_sparql_statement_finalize (GObject * obj)
{
	TrackerSparqlStatement * self;
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_STATEMENT, TrackerSparqlStatement);
#line 45 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	_g_free0 (self->priv->_sparql);
#line 46 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	_g_object_unref0 (self->priv->_connection);
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	G_OBJECT_CLASS (tracker_sparql_statement_parent_class)->finalize (obj);
#line 478 "tracker-statement.c"
}

/**
 * SECTION: tracker-sparql-statement
 * @short_description: Prepared statements
 * @title: TrackerSparqlStatement
 * @stability: Stable
 * @include: tracker-sparql.h
 *
 * The <structname>TrackerSparqlStatement</structname> object represents
 * a SPARQL query. This query may contain parameterized variables
 * (expressed as ~var in the syntax), which may be mapped to arbitrary
 * values prior to execution. This statement may be reused for future
 * queries with different values.
 *
 * The argument bindings may be changed through tracker_sparql_statement_bind_int(),
 * tracker_sparql_statement_bind_boolean(), tracker_sparql_statement_bind_double()
 * and tracker_sparql_statement_bind_string(). Those functions receive
 * a @name argument corresponding for the variable name in the SPARQL query
 * (eg. "var" for ~var) and a @value to map the variable to.
 *
 * Once all arguments have a value, the query may be executed through
 * tracker_sparql_statement_execute() or tracker_sparql_statement_execute_async().
 *
 * This object was added in Tracker 2.2.
 */
static GType
tracker_sparql_statement_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlStatement), 0, (GInstanceInitFunc) tracker_sparql_statement_instance_init, NULL };
	GType tracker_sparql_statement_type_id;
	tracker_sparql_statement_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlStatement", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	TrackerSparqlStatement_private_offset = g_type_add_instance_private (tracker_sparql_statement_type_id, sizeof (TrackerSparqlStatementPrivate));
	return tracker_sparql_statement_type_id;
}

GType
tracker_sparql_statement_get_type (void)
{
	static volatile gsize tracker_sparql_statement_type_id__once = 0;
	if (g_once_init_enter (&tracker_sparql_statement_type_id__once)) {
		GType tracker_sparql_statement_type_id;
		tracker_sparql_statement_type_id = tracker_sparql_statement_get_type_once ();
		g_once_init_leave (&tracker_sparql_statement_type_id__once, tracker_sparql_statement_type_id);
	}
	return tracker_sparql_statement_type_id__once;
}

static void
_vala_tracker_sparql_statement_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	TrackerSparqlStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_STATEMENT, TrackerSparqlStatement);
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	switch (property_id) {
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		case TRACKER_SPARQL_STATEMENT_SPARQL_PROPERTY:
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		g_value_set_string (value, tracker_sparql_statement_get_sparql (self));
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		break;
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		case TRACKER_SPARQL_STATEMENT_CONNECTION_PROPERTY:
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		g_value_set_object (value, tracker_sparql_statement_get_connection (self));
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		break;
#line 549 "tracker-statement.c"
		default:
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		break;
#line 555 "tracker-statement.c"
	}
}

static void
_vala_tracker_sparql_statement_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	TrackerSparqlStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_STATEMENT, TrackerSparqlStatement);
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
	switch (property_id) {
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		case TRACKER_SPARQL_STATEMENT_SPARQL_PROPERTY:
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		tracker_sparql_statement_set_sparql (self, g_value_get_string (value));
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		break;
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		case TRACKER_SPARQL_STATEMENT_CONNECTION_PROPERTY:
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		tracker_sparql_statement_set_connection (self, g_value_get_object (value));
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		break;
#line 581 "tracker-statement.c"
		default:
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "../tracker/src/libtracker-sparql/tracker-statement.vala"
		break;
#line 587 "tracker-statement.c"
	}
}

