/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.renderer.OWLObjectRenderer;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntax;
import org.semanticweb.owlapi.manchestersyntax.renderer.ManchesterOWLSyntaxObjectRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.OntologyIRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.vocab.SWRLBuiltInsVocabulary;

public class OWLObjectRendererImpl
implements OWLObjectRenderer {
    private final OWLModelManager mngr;
    private WriterDelegate writerDelegate;
    private ManchesterOWLSyntaxObjectRenderer delegate;
    private OntologyIRIShortFormProvider ontURISFP;

    public OWLObjectRendererImpl(OWLModelManager mngr) {
        this.mngr = mngr;
        this.writerDelegate = new WriterDelegate();
        this.delegate = new PatchedManchesterOWLSyntaxObjectRenderer(this.writerDelegate, new ShortFormProvider(){

            @Nonnull
            public String getShortForm(@Nonnull OWLEntity owlEntity) {
                return OWLObjectRendererImpl.this.mngr.getRendering((OWLObject)owlEntity);
            }

            public void dispose() {
            }
        });
        this.ontURISFP = new OntologyIRIShortFormProvider();
    }

    @Override
    public String render(OWLObject object) {
        if (object instanceof OWLOntology) {
            return this.renderOntology((OWLOntology)object);
        }
        this.writerDelegate.reset();
        object.accept((OWLObjectVisitor)this.delegate);
        return this.writerDelegate.toString();
    }

    private String renderOntology(OWLOntology ontology) {
        if (ontology.isAnonymous()) {
            return ontology.getOntologyID().toString();
        }
        Optional iri = ontology.getOntologyID().getDefaultDocumentIRI();
        if (iri.isPresent()) {
            return this.ontURISFP.getShortForm((IRI)iri.get());
        }
        return "Anonymous Ontology";
    }

    private class WriterDelegate
    extends Writer {
        private StringWriter delegate;

        private WriterDelegate() {
        }

        private void reset() {
            this.delegate = new StringWriter();
        }

        public String toString() {
            return this.delegate.getBuffer().toString();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void write(@Nonnull char[] cbuf, int off, int len) throws IOException {
            this.delegate.write(cbuf, off, len);
        }
    }

    private class PatchedManchesterOWLSyntaxObjectRenderer
    extends ManchesterOWLSyntaxObjectRenderer {
        private boolean tabbingSave;
        private boolean wrapSave;

        public PatchedManchesterOWLSyntaxObjectRenderer(Writer writer, ShortFormProvider entityShortFormProvider) {
            super(writer, entityShortFormProvider);
            this.tabbingSave = true;
            this.wrapSave = true;
        }

        public void visit(@Nonnull IRI iri) {
            this.write(OWLObjectRendererImpl.this.mngr.getOWLEntityRenderer().render(iri));
        }

        public void visit(@Nonnull SWRLVariable node) {
            this.write("?");
            this.write(OWLObjectRendererImpl.this.mngr.getOWLEntityRenderer().render(node.getIRI()));
        }

        public void visit(@Nonnull SWRLBuiltInAtom node) {
            SWRLBuiltInsVocabulary vocabulary = SWRLBuiltInsVocabulary.getBuiltIn((IRI)node.getPredicate());
            if (vocabulary != null) {
                this.write(vocabulary.getShortForm());
            } else {
                this.write(OWLObjectRendererImpl.this.mngr.getOWLEntityRenderer().render(node.getPredicate()));
            }
            this.write("(");
            Iterator it = node.getArguments().iterator();
            while (it.hasNext()) {
                ((SWRLDArgument)it.next()).accept((OWLObjectVisitor)this);
                if (!it.hasNext()) continue;
                this.write(", ");
            }
            this.write(")");
        }

        private void setAxiomWriting() {
            this.tabbingSave = this.isUseTabbing();
            this.wrapSave = this.isUseWrapping();
            this.setUseWrapping(false);
            this.setUseTabbing(false);
        }

        private void restore() {
            this.setUseTabbing(this.wrapSave);
            this.setUseTabbing(this.tabbingSave);
        }

        public void visit(@Nonnull OWLSubObjectPropertyOfAxiom axiom) {
            this.writeSubPropertyOf(axiom.getSubProperty(), axiom.getSuperProperty());
        }

        public void visit(@Nonnull OWLSubAnnotationPropertyOfAxiom axiom) {
            this.writeSubPropertyOf((OWLPropertyExpression)axiom.getSubProperty(), (OWLPropertyExpression)axiom.getSuperProperty());
        }

        public void visit(@Nonnull OWLSubDataPropertyOfAxiom axiom) {
            this.writeSubPropertyOf(axiom.getSubProperty(), axiom.getSuperProperty());
        }

        private void writeSubPropertyOf(OWLPropertyExpression subProperty, OWLPropertyExpression superProperty) {
            this.setAxiomWriting();
            subProperty.accept((OWLObjectVisitor)this);
            this.write(ManchesterOWLSyntax.SUB_PROPERTY_OF);
            superProperty.accept((OWLObjectVisitor)this);
            this.restore();
        }
    }
}

