/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;
import org.openstreetmap.josm.gui.widgets.JosmComboBoxEditor;
import org.openstreetmap.josm.gui.widgets.JosmComboBoxModel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.spi.preferences.Config;

public class JosmComboBox<E>
extends JComboBox<E>
implements PopupMenuListener,
PropertyChangeListener {
    public static final String PROP_MAXIMUM_ROW_COUNT = "gui.combobox.maximum-row-count";
    private Integer configMaximumRowCount;
    private int preferredHeight = -1;
    private String hint;

    public JosmComboBox() {
        super(new JosmComboBoxModel());
        this.init();
    }

    public JosmComboBox(JosmComboBoxModel<E> aModel) {
        super(aModel);
        this.init();
    }

    public JosmComboBox(E[] items) {
        super(new JosmComboBoxModel());
        this.init();
        for (E elem : items) {
            ((JosmComboBoxModel)this.getModel()).addElement(elem);
        }
    }

    private void init() {
        this.configMaximumRowCount = Config.getPref().getInt(PROP_MAXIMUM_ROW_COUNT, 9999);
        this.setEditor(new JosmComboBoxEditor());
        this.addPopupMenuListener(this);
    }

    @Override
    public JosmComboBoxModel<E> getModel() {
        return (JosmComboBoxModel)this.dataModel;
    }

    @Override
    public void setEditor(ComboBoxEditor newEditor) {
        if (this.editor != null) {
            this.editor.getEditorComponent().removePropertyChangeListener(this);
        }
        super.setEditor(newEditor);
        if (this.editor != null) {
            this.editor.getEditorComponent().addPropertyChangeListener(this);
        }
    }

    public JosmTextField getEditorComponent() {
        return (JosmTextField)(this.editor == null ? null : this.editor.getEditorComponent());
    }

    public String getEditorItemAsString() {
        return this.editor != null && this.editor.getItem() != null ? this.editor.getItem().toString() : null;
    }

    public String getText() {
        JosmTextField tf = this.getEditorComponent();
        return tf == null ? null : tf.getText();
    }

    public void setText(String value) {
        JosmTextField tf = this.getEditorComponent();
        if (tf != null) {
            tf.setText(value);
        }
    }

    public E setSelectedItemText(String text) {
        Object item = ((JosmComboBoxModel)this.getModel()).find(text);
        this.setSelectedItem(item);
        if (text == null || !text.equals(this.getText())) {
            this.setText(text);
        }
        return item;
    }

    public String getHint() {
        return this.hint;
    }

    public String setHint(String newHint) {
        String old = this.hint;
        this.hint = newHint;
        JosmTextField tf = this.getEditorComponent();
        if (tf != null) {
            tf.setHint(newHint);
        }
        return old;
    }

    @Override
    public void setComponentOrientation(ComponentOrientation o) {
        if (o.isLeftToRight() != this.getComponentOrientation().isLeftToRight()) {
            super.setComponentOrientation(o);
            this.getEditorComponent().setComponentOrientation(o);
            this.revalidate();
        }
    }

    public boolean displayHint() {
        return !this.isEditable() && this.hint != null && !this.hint.isEmpty() && this.getText().isEmpty();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.preferredHeight != -1) {
            d.height = this.preferredHeight;
        }
        return d;
    }

    public int setPreferredHeight(int height) {
        int old = this.preferredHeight;
        this.preferredHeight = height;
        return old;
    }

    public JList getList() {
        Accessible popup = this.getUI().getAccessibleChild(this, 0);
        if (popup instanceof ComboPopup) {
            return ((ComboPopup)((Object)popup)).getList();
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        JosmTextField editor = this.getEditorComponent();
        if (this.displayHint() && editor != null) {
            if (editor.getSize().width == 0) {
                Dimension dimen = this.getSize();
                Insets insets = this.getInsets();
                editor.setSize(dimen.width - insets.left - insets.right, dimen.height - insets.top - insets.bottom);
            }
            editor.drawHint(g);
        }
    }

    public final void discardAllUndoableEdits() {
        this.getEditorComponent().discardAllUndoableEdits();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent ev) {
        Rectangle screenBounds;
        Rectangle bounds = new Rectangle(this.getLocationOnScreen(), this.getSize());
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (gc != null) {
            Insets screenInsets = toolkit.getScreenInsets(gc);
            screenBounds = gc.getBounds();
            screenBounds.x += screenInsets.left;
            screenBounds.y += screenInsets.top;
            screenBounds.width -= screenInsets.left + screenInsets.right;
            screenBounds.height -= screenInsets.top + screenInsets.bottom;
        } else {
            screenBounds = new Rectangle(new Point(), toolkit.getScreenSize());
        }
        int freeAbove = bounds.y - screenBounds.y;
        int freeBelow = screenBounds.y + screenBounds.height - (bounds.y + bounds.height);
        try {
            int i;
            JList jList = this.getList();
            Insets insets = jList.getInsets();
            int fudge = 4;
            int free = Math.max(freeAbove, freeBelow) - (insets.top + insets.bottom) - fudge;
            if (jList.getParent() instanceof JScrollPane) {
                JScrollPane scroller = (JScrollPane)jList.getParent();
                Border border = scroller.getViewportBorder();
                if (border != null) {
                    insets = border.getBorderInsets(null);
                    free -= insets.top + insets.bottom;
                }
                if ((border = scroller.getBorder()) != null) {
                    insets = border.getBorderInsets(null);
                    free -= insets.top + insets.bottom;
                }
            }
            int rowCount = Math.min(this.configMaximumRowCount, this.getItemCount());
            ListCellRenderer r = jList.getCellRenderer();
            int h = 0;
            for (i = 0; i < rowCount; ++i) {
                Component c = r.getListCellRendererComponent(jList, ((JosmComboBoxModel)this.getModel()).getElementAt(i), i, false, false);
                if ((h += c.getPreferredSize().height) >= free) break;
            }
            this.setMaximumRowCount(i);
        }
        catch (Exception ex) {
            this.setMaximumRowCount(8);
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("componentOrientation".equals(evt.getPropertyName())) {
            this.setComponentOrientation((ComponentOrientation)evt.getNewValue());
        }
    }
}

