/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.wav;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.jaudiotagger.audio.wav.WavOptions;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.wav.WavInfoTag;

public class WavTag
implements Tag {
    private boolean isExistingId3Tag = false;
    private boolean isExistingInfoTag = false;
    private WavInfoTag infoTag;
    private AbstractID3v2Tag id3Tag;
    private WavOptions wavOptions;

    public WavTag(WavOptions wavOptions) {
        this.wavOptions = wavOptions;
    }

    public boolean isExistingId3Tag() {
        return this.isExistingId3Tag;
    }

    public boolean isExistingInfoTag() {
        return this.isExistingInfoTag;
    }

    public WavInfoTag getInfoTag() {
        return this.infoTag;
    }

    public void setInfoTag(WavInfoTag infoTag) {
        this.infoTag = infoTag;
    }

    public boolean isInfoTag() {
        return this.infoTag != null;
    }

    public AbstractID3v2Tag getID3Tag() {
        return this.id3Tag;
    }

    public void setID3Tag(AbstractID3v2Tag t) {
        this.id3Tag = t;
    }

    public boolean isID3Tag() {
        return this.id3Tag != null;
    }

    @Override
    public String toString() {
        String output = "WAV " + super.toString();
        return output;
    }

    public Tag getActiveTag() {
        switch (this.wavOptions) {
            case READ_ID3_ONLY: {
                return this.id3Tag;
            }
            case READ_INFO_ONLY: {
                return this.infoTag;
            }
            case READ_ID3_UNLESS_ONLY_INFO: {
                if (this.isExistingId3Tag() || !this.isExistingInfoTag()) {
                    return this.id3Tag;
                }
                return this.infoTag;
            }
            case READ_INFO_UNLESS_ONLY_ID3: {
                if (this.isExistingInfoTag() || !this.isExistingId3Tag()) {
                    return this.infoTag;
                }
                return this.id3Tag;
            }
        }
        return this.id3Tag;
    }

    public boolean equals(Object obj) {
        return this.getActiveTag().equals(obj);
    }

    @Override
    public void addField(TagField field) throws FieldDataInvalidException {
        this.getActiveTag().addField(field);
    }

    @Override
    public List<TagField> getFields(String id) {
        return this.getActiveTag().getFields(id);
    }

    @Override
    public List<String> getAll(FieldKey genericKey) throws KeyNotFoundException {
        return this.getActiveTag().getAll(genericKey);
    }

    @Override
    public boolean hasCommonFields() {
        return this.getActiveTag().hasCommonFields();
    }

    @Override
    public boolean isEmpty() {
        return this.getActiveTag() == null || this.getActiveTag().isEmpty();
    }

    @Override
    public void setField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.setField(tagfield);
    }

    @Override
    public void addField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.addField(tagfield);
    }

    @Override
    public void setField(TagField field) throws FieldDataInvalidException {
        this.getActiveTag().setField(field);
    }

    @Override
    public TagField createField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        return this.getActiveTag().createField(genericKey, value);
    }

    @Override
    public String getFirst(String id) {
        return this.getActiveTag().getFirst(id);
    }

    @Override
    public String getValue(FieldKey id, int index) throws KeyNotFoundException {
        return this.getActiveTag().getValue(id, index);
    }

    @Override
    public String getFirst(FieldKey id) throws KeyNotFoundException {
        return this.getValue(id, 0);
    }

    @Override
    public TagField getFirstField(String id) {
        return this.getActiveTag().getFirstField(id);
    }

    @Override
    public TagField getFirstField(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return this.getActiveTag().getFirstField(genericKey);
    }

    @Override
    public void deleteField(FieldKey fieldKey) throws KeyNotFoundException {
        this.getActiveTag().deleteField(fieldKey);
    }

    @Override
    public void deleteField(String id) throws KeyNotFoundException {
        this.getActiveTag().deleteField(id);
    }

    @Override
    public Iterator<TagField> getFields() {
        return this.getActiveTag().getFields();
    }

    @Override
    public int getFieldCount() {
        return this.getActiveTag().getFieldCount();
    }

    @Override
    public int getFieldCountIncludingSubValues() {
        return this.getFieldCount();
    }

    @Override
    public boolean setEncoding(Charset enc) throws FieldDataInvalidException {
        return this.getActiveTag().setEncoding(enc);
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        return this.getActiveTag().createField(artwork);
    }

    @Override
    public List<TagField> getFields(FieldKey id) throws KeyNotFoundException {
        return this.getActiveTag().getFields(id);
    }

    @Override
    public Artwork getFirstArtwork() {
        return this.getActiveTag().getFirstArtwork();
    }

    @Override
    public void deleteArtworkField() throws KeyNotFoundException {
        this.getActiveTag().deleteArtworkField();
    }

    @Override
    public boolean hasField(FieldKey genericKey) {
        return this.getActiveTag().hasField(genericKey);
    }

    @Override
    public boolean hasField(String id) {
        return this.getActiveTag().hasField(id);
    }

    @Override
    public TagField createCompilationField(boolean value) throws KeyNotFoundException, FieldDataInvalidException {
        return this.createField(FieldKey.IS_COMPILATION, String.valueOf(value));
    }

    @Override
    public List<Artwork> getArtworkList() {
        return this.getActiveTag().getArtworkList();
    }

    @Override
    public void setField(Artwork artwork) throws FieldDataInvalidException {
        this.setField(this.createField(artwork));
    }

    @Override
    public void addField(Artwork artwork) throws FieldDataInvalidException {
        this.addField(this.createField(artwork));
    }

    public void setExistingId3Tag(boolean isExistingId3Tag) {
        this.isExistingId3Tag = isExistingId3Tag;
    }

    public void setExistingInfoTag(boolean isExistingInfoTag) {
        this.isExistingInfoTag = isExistingInfoTag;
    }

    public long getSizeOfID3TagOnly() {
        if (!this.isExistingId3Tag()) {
            return 0L;
        }
        return this.id3Tag.getEndLocationInFile() - this.id3Tag.getStartLocationInFile();
    }

    public long getSizeOfID3TagIncludingChunkHeader() {
        if (!this.isExistingId3Tag()) {
            return 0L;
        }
        return this.getSizeOfID3TagOnly() + 8L;
    }

    public long getStartLocationInFileOfId3Chunk() {
        if (!this.isExistingId3Tag()) {
            return 0L;
        }
        return this.id3Tag.getStartLocationInFile() - 8L;
    }

    public long getEndLocationInFileOfId3Chunk() {
        if (!this.isExistingId3Tag()) {
            return 0L;
        }
        return this.id3Tag.getEndLocationInFile();
    }
}

