/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionThrottle {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private volatile Long lastActionStartedAt;
    private volatile Long minMsBetweenActions;
    private final String name;
    private final NanoTimeSource nanoTimeSource;

    public ActionThrottle(String name, long minMsBetweenActions) {
        this.name = name;
        this.minMsBetweenActions = minMsBetweenActions;
        this.nanoTimeSource = new DefaultNanoTimeSource();
    }

    public ActionThrottle(String name, long minMsBetweenActions, NanoTimeSource nanoTimeSource) {
        this.name = name;
        this.minMsBetweenActions = minMsBetweenActions;
        this.nanoTimeSource = nanoTimeSource;
    }

    public void markAttemptingAction() {
        this.lastActionStartedAt = this.nanoTimeSource.getTime();
    }

    public void minimumWaitBetweenActions() {
        if (this.lastActionStartedAt == null) {
            return;
        }
        long diff = this.nanoTimeSource.getTime() - this.lastActionStartedAt;
        int diffMs = (int)TimeUnit.MILLISECONDS.convert(diff, TimeUnit.NANOSECONDS);
        long minNsBetweenActions = TimeUnit.NANOSECONDS.convert(this.minMsBetweenActions, TimeUnit.MILLISECONDS);
        log.info("The last {} attempt started {}ms ago.", (Object)this.name, (Object)diffMs);
        int sleep = 0;
        if (diffMs > 0 && diff < minNsBetweenActions) {
            sleep = (int)TimeUnit.MILLISECONDS.convert(minNsBetweenActions - diff, TimeUnit.NANOSECONDS);
        } else if (diffMs == 0) {
            sleep = this.minMsBetweenActions.intValue();
        }
        if (sleep > 0) {
            log.info("Throttling {} attempts - waiting for {}ms", (Object)this.name, (Object)sleep);
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class DefaultNanoTimeSource
    implements NanoTimeSource {
        private DefaultNanoTimeSource() {
        }

        @Override
        public long getTime() {
            return System.nanoTime();
        }
    }

    public static interface NanoTimeSource {
        public long getTime();
    }
}

