/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.hemfplus.record;

import java.io.IOException;
import org.apache.poi.hemf.hemfplus.record.HemfPlusRecord;
import org.apache.poi.hemf.hemfplus.record.HemfPlusRecordType;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;

@Internal
public class HemfPlusHeader
implements HemfPlusRecord {
    private int flags;
    private long version;
    private long emfPlusFlags;
    private long logicalDpiX;
    private long logicalDpiY;

    @Override
    public HemfPlusRecordType getRecordType() {
        return HemfPlusRecordType.header;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public void init(byte[] dataBytes, int recordId, int flags) throws IOException {
        this.flags = flags;
        int offset = 0;
        this.version = LittleEndian.getUInt((byte[])dataBytes, (int)offset);
        this.emfPlusFlags = LittleEndian.getUInt((byte[])dataBytes, (int)(offset += 4));
        this.logicalDpiX = LittleEndian.getUInt((byte[])dataBytes, (int)(offset += 4));
        this.logicalDpiY = LittleEndian.getUInt((byte[])dataBytes, (int)(offset += 4));
    }

    public long getVersion() {
        return this.version;
    }

    public long getEmfPlusFlags() {
        return this.emfPlusFlags;
    }

    public long getLogicalDpiX() {
        return this.logicalDpiX;
    }

    public long getLogicalDpiY() {
        return this.logicalDpiY;
    }

    public String toString() {
        return "HemfPlusHeader{flags=" + this.flags + ", version=" + this.version + ", emfPlusFlags=" + this.emfPlusFlags + ", logicalDpiX=" + this.logicalDpiX + ", logicalDpiY=" + this.logicalDpiY + '}';
    }
}

