/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.options;

import com.adobe.xmp.XMPException;
import java.util.HashMap;
import java.util.Map;

public abstract class Options {
    private int options = 0;
    private Map optionNames = null;

    public Options() {
    }

    public Options(int n) throws XMPException {
        this.assertOptionsValid(n);
        this.setOptions(n);
    }

    public void clear() {
        this.options = 0;
    }

    public boolean isExactly(int n) {
        return this.getOptions() == n;
    }

    public boolean containsAllOptions(int n) {
        return (this.getOptions() & n) == n;
    }

    public boolean containsOneOf(int n) {
        return (this.getOptions() & n) != 0;
    }

    protected boolean getOption(int n) {
        return (this.options & n) != 0;
    }

    public void setOption(int n, boolean bl) {
        this.options = bl ? this.options | n : this.options & ~n;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int n) throws XMPException {
        this.assertOptionsValid(n);
        this.options = n;
    }

    public boolean equals(Object object) {
        return this.getOptions() == ((Options)object).getOptions();
    }

    public int hashCode() {
        return this.getOptions();
    }

    public String getOptionsString() {
        if (this.options != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.options;
            while (n != 0) {
                int n2 = n & n - 1;
                int n3 = n ^ n2;
                String string = this.getOptionName(n3);
                stringBuffer.append(string);
                if (n2 != 0) {
                    stringBuffer.append(" | ");
                }
                n = n2;
            }
            return stringBuffer.toString();
        }
        return "<none>";
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.options);
    }

    protected abstract int getValidOptions();

    protected abstract String defineOptionName(int var1);

    protected void assertConsistency(int n) throws XMPException {
    }

    private void assertOptionsValid(int n) throws XMPException {
        int n2 = n & ~this.getValidOptions();
        if (n2 != 0) {
            throw new XMPException("The option bit(s) 0x" + Integer.toHexString(n2) + " are invalid!", 103);
        }
        this.assertConsistency(n);
    }

    private String getOptionName(int n) {
        Integer n2;
        Map map = this.procureOptionNames();
        String string = (String)map.get(n2 = new Integer(n));
        if (string == null) {
            string = this.defineOptionName(n);
            if (string != null) {
                map.put(n2, string);
            } else {
                string = "<option name not defined>";
            }
        }
        return string;
    }

    private Map procureOptionNames() {
        if (this.optionNames == null) {
            this.optionNames = new HashMap();
        }
        return this.optionNames;
    }
}

