/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.warc;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class WarcDateParser {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final ThreadLocal<WarcDateParser> DateParserTL = new ThreadLocal<WarcDateParser>(){

        @Override
        public WarcDateParser initialValue() {
            return new WarcDateParser();
        }
    };

    private WarcDateParser() {
        this.dateFormat.setLenient(false);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private Date parseDate(String dateStr) {
        Date date = null;
        try {
            if (dateStr != null && dateStr.length() == "yyyy-MM-dd'T'HH:mm:ss'Z'".length() - 4) {
                date = this.dateFormat.parse(dateStr.toUpperCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static Date getDate(String dateStr) {
        Date date = DateParserTL.get().parseDate(dateStr);
        boolean isValid = date == null ? false : date.getTime() > 0L;
        return isValid ? date : null;
    }

    public static DateFormat getDateFormat() {
        return WarcDateParser.DateParserTL.get().dateFormat;
    }
}

