/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.NameSpace;
import bsh.SimpleNode;

public class EvalError
extends Exception {
    private SimpleNode node;
    private String message;
    private final CallStack callstack;

    public EvalError(String string, SimpleNode simpleNode, CallStack callStack, Throwable throwable) {
        this(string, simpleNode, callStack);
        this.initCause(throwable);
    }

    public EvalError(String string, SimpleNode simpleNode, CallStack callStack) {
        this.message = string;
        this.node = simpleNode;
        this.callstack = callStack == null ? null : callStack.copy();
    }

    public String getMessage() {
        String string = this.node != null ? " : at Line: " + this.node.getLineNumber() + " : in file: " + this.node.getSourceFile() + " : " + this.node.getText() : ": <at unknown location>";
        if (this.callstack != null) {
            string = string + "\n" + this.getScriptStackTrace();
        }
        return this.getRawMessage() + string;
    }

    public void reThrow(String string) throws EvalError {
        this.prependMessage(string);
        throw this;
    }

    SimpleNode getNode() {
        return this.node;
    }

    void setNode(SimpleNode simpleNode) {
        this.node = simpleNode;
    }

    public String getErrorText() {
        if (this.node != null) {
            return this.node.getText();
        }
        return "<unknown error>";
    }

    public int getErrorLineNumber() {
        if (this.node != null) {
            return this.node.getLineNumber();
        }
        return -1;
    }

    public String getErrorSourceFile() {
        if (this.node != null) {
            return this.node.getSourceFile();
        }
        return "<unknown file>";
    }

    public String getScriptStackTrace() {
        if (this.callstack == null) {
            return "<Unknown>";
        }
        String string = "";
        CallStack callStack = this.callstack.copy();
        while (callStack.depth() > 0) {
            NameSpace nameSpace = callStack.pop();
            SimpleNode simpleNode = nameSpace.getNode();
            if (!nameSpace.isMethod) continue;
            string = string + "\nCalled from method: " + nameSpace.getName();
            if (simpleNode == null) continue;
            string = string + " : at Line: " + simpleNode.getLineNumber() + " : in file: " + simpleNode.getSourceFile() + " : " + simpleNode.getText();
        }
        return string;
    }

    public String getRawMessage() {
        return this.message;
    }

    private void prependMessage(String string) {
        if (string == null) {
            return;
        }
        this.message = this.message == null ? string : string + " : " + this.message;
    }
}

