/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.configure.Configurer;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.URLUtils;
import VASSAL.tools.filechooser.AudioFileFilter;
import VASSAL.tools.filechooser.FileChooser;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SoundConfigurer
extends Configurer {
    public static final String DEFAULT = "default";
    private String defaultResource;
    private String clipName;
    private JPanel controls;
    private JTextField textField;
    private AudioClipFactory clipFactory;
    private static final String NO_VALUE = "<disabled>";

    public SoundConfigurer(String string, String string2, String string3) {
        super(string, string2);
        this.defaultResource = string3;
        this.clipFactory = this.createAudioClipFactory();
        this.setValue(DEFAULT);
    }

    public Component getControls() {
        if (this.controls == null) {
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 0));
            this.controls.add(new JLabel(this.name));
            JButton jButton = new JButton("Play");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SoundConfigurer.this.play();
                }
            });
            this.controls.add(jButton);
            jButton = new JButton("Default");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SoundConfigurer.this.setValue(SoundConfigurer.DEFAULT);
                }
            });
            this.controls.add(jButton);
            jButton = new JButton("Select");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SoundConfigurer.this.chooseClip();
                }
            });
            this.controls.add(jButton);
            this.textField = new JTextField();
            this.textField.setMaximumSize(new Dimension(this.textField.getMaximumSize().width, this.textField.getPreferredSize().height));
            this.textField.setEditable(false);
            this.textField.setText(DEFAULT.equals(this.clipName) ? this.defaultResource : this.clipName);
            this.controls.add(this.textField);
        }
        return this.controls;
    }

    public String getValueString() {
        String string = NO_VALUE;
        if (this.clipName != null) {
            string = this.clipName;
        }
        return string;
    }

    public void setValue(String string) {
        if (this.clipFactory == null) {
            return;
        }
        URL uRL = null;
        if (DEFAULT.equals(string)) {
            uRL = this.getClass().getResource("/images/" + this.defaultResource);
            this.clipName = string;
        } else if (NO_VALUE.equals(string)) {
            this.clipName = string;
        } else if (string != null) {
            try {
                uRL = URLUtils.toURL(new File(string));
                this.clipName = string;
            }
            catch (MalformedURLException malformedURLException) {
                ReadErrorDialog.error((IOException)malformedURLException, string);
                this.clipName = null;
            }
        }
        if (this.textField != null) {
            this.textField.setText(DEFAULT.equals(this.clipName) ? this.defaultResource : this.clipName);
        }
        if (uRL != null) {
            try {
                this.setValue(this.clipFactory.getAudioClip(uRL));
            }
            catch (IOException iOException) {
                ReadErrorDialog.error(iOException, uRL.toString());
            }
        } else {
            if (this.textField != null) {
                this.textField.setText(null);
            }
            this.setValue((Object)null);
        }
    }

    protected AudioClipFactory createAudioClipFactory() {
        return new AudioClipFactory(){

            public AudioClip getAudioClip(URL uRL) {
                return Applet.newAudioClip(uRL);
            }
        };
    }

    public void play() {
        AudioClip audioClip = (AudioClip)this.getValue();
        if (audioClip != null) {
            audioClip.play();
        }
    }

    public void chooseClip() {
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        fileChooser.setFileFilter(new AudioFileFilter());
        if (fileChooser.showOpenDialog(this.getControls()) != 0) {
            this.setValue(NO_VALUE);
        } else {
            File file = fileChooser.getSelectedFile();
            this.setValue(file.getName());
        }
    }

    protected static interface AudioClipFactory {
        public AudioClip getAudioClip(URL var1) throws IOException;
    }
}

