/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.CgiServerStatus;
import VASSAL.chat.WelcomeMessageServer;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.node.BufferedSocketHandler;
import VASSAL.chat.node.NodeClient;
import VASSAL.chat.node.NodeServerInfo;
import VASSAL.chat.node.SocketHandler;
import VASSAL.chat.node.SocketWatcher;
import VASSAL.command.CommandEncoder;
import VASSAL.i18n.Resources;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;

public class SocketNodeClient
extends NodeClient
implements SocketWatcher {
    private SocketHandler sender;
    protected NodeServerInfo serverInfo;

    public SocketNodeClient(String string, String string2, CommandEncoder commandEncoder, NodeServerInfo nodeServerInfo, MessageBoard messageBoard, WelcomeMessageServer welcomeMessageServer) {
        super(string, string2, commandEncoder, messageBoard, welcomeMessageServer);
        this.serverInfo = nodeServerInfo;
        this.serverStatus = new CgiServerStatus();
    }

    public SocketNodeClient(String string, String string2, CommandEncoder commandEncoder, final String string3, final int n, MessageBoard messageBoard, WelcomeMessageServer welcomeMessageServer) {
        this(string, string2, commandEncoder, new NodeServerInfo(){

            public String getHostName() {
                return string3;
            }

            public int getPort() {
                return n;
            }
        }, messageBoard, welcomeMessageServer);
    }

    public void send(String string) {
        this.sender.writeLine(string);
    }

    protected void initializeConnection() throws UnknownHostException, IOException {
        Socket socket = new Socket(this.serverInfo.getHostName(), this.serverInfo.getPort());
        this.sender = new BufferedSocketHandler(socket, this);
        this.sender.start();
    }

    protected void closeConnection() {
        SocketHandler socketHandler = this.sender;
        this.sender = null;
        socketHandler.close();
    }

    public boolean isConnected() {
        return this.sender != null;
    }

    public void socketClosed(SocketHandler socketHandler) {
        if (this.sender != null) {
            this.propSupport.firePropertyChange("Status", null, Resources.getString("Server.lost_connection"));
            this.propSupport.firePropertyChange("Connected", null, Boolean.FALSE);
            this.sender = null;
        }
    }

    public void handleMessage(String string) {
        this.handleMessageFromServer(string);
    }

    public void updateConfig(Properties properties) {
    }
}

