/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.jabber;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.chat.LockableRoom;
import VASSAL.chat.Player;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.SimpleStatus;
import VASSAL.chat.jabber.JabberClient;
import VASSAL.chat.jabber.JabberPlayer;
import VASSAL.i18n.Resources;
import VASSAL.tools.PropertiesEncoder;
import VASSAL.tools.swing.Dialogs;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.RoomInfo;

public class JabberRoom
extends SimpleRoom
implements LockableRoom {
    public static final String CONFIG_NAME = "name";
    public static final String CONFIG_LOCKED = "locked";
    public static final String CONFIG_VASSAL_VERSION = "vasVer";
    public static final String CONFIG_MIN_VASSAL_VERSION = "minVasVer";
    public static final String CONFIG_MODULE_VERSION = "modVer";
    public static final String CONFIG_MIN_MODULE_VERSION = "minModVer";
    public static final String CONFIG_CRC_CHECK = "crcCheck";
    public static final String CONFIG_CRC = "crc";
    private static final String JABBER_MEMBERSONLY = "muc#roomconfig_membersonly";
    private static final String JABBER_ALLOW_INVITES = "muc#roomconfig_allowinvites";
    private static final String JABBER_CHANGE_SUBJECT = "muc#roomconfig_changesubject";
    private static final String JABBER_MODERATED = "muc#roomconfig_moderatedroom";
    private static final String JABBER_PASSWORD_PROTECTED = "muc#roomconfig_passwordprotectedroom";
    private static final String JABBER_PERSISTENT = "muc#roomconfig_persistentroom";
    private static final String JABBER_PUBLIC_ROOM = "muc#roomconfig_publicroom";
    private String jid;
    private RoomInfo info;
    private boolean ownedByMe;
    private JabberClient client;
    private ArrayList<String> owners = new ArrayList();
    private Properties config = new Properties();
    private static final String MINIMUM_OPTION = "min";
    private static final String ANY_OPTION = "any";
    private static final String THIS_OPTION = "this";
    private static final String MINIMUM_VERSION = Resources.getString("Chat.mimimum_version");
    private static final String ANY_VERSION = Resources.getString("Chat.any_version");
    private static final String THIS_VERSION = Resources.getString("Chat.this_version");

    private JabberRoom(String string, String string2, RoomInfo roomInfo, JabberClient jabberClient) {
        super(string);
        this.jid = string2;
        this.info = roomInfo;
        this.client = jabberClient;
        this.config.clear();
        this.config.put(CONFIG_NAME, string);
    }

    public String getJID() {
        return this.jid;
    }

    public boolean isLocked() {
        return this.info != null && this.info.isMembersOnly();
    }

    public void setInfo(RoomInfo roomInfo) {
        this.info = roomInfo;
    }

    public void toggleLock(MultiUserChat multiUserChat) {
        try {
            if (!this.isLocked()) {
                this.lock(multiUserChat);
            } else {
                this.unlock(multiUserChat);
            }
            this.info = MultiUserChat.getRoomInfo((XMPPConnection)this.client.getConnection(), (String)this.jid);
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
            return;
        }
    }

    protected void lock(MultiUserChat multiUserChat) throws XMPPException {
        Form form = multiUserChat.getConfigurationForm().createAnswerForm();
        form.setAnswer(JABBER_MEMBERSONLY, true);
        multiUserChat.sendConfigurationForm(form);
    }

    protected void unlock(MultiUserChat multiUserChat) throws XMPPException {
        Form form = multiUserChat.getConfigurationForm().createAnswerForm();
        form.setAnswer(JABBER_MEMBERSONLY, false);
        multiUserChat.sendConfigurationForm(form);
    }

    public MultiUserChat join(JabberClient jabberClient, JabberPlayer jabberPlayer) throws XMPPException {
        MultiUserChat multiUserChat;
        block3: {
            multiUserChat = new MultiUserChat(jabberClient.getConnection(), this.getJID());
            multiUserChat.join(StringUtils.parseName((String)jabberPlayer.getJid()));
            if (!multiUserChat.isJoined()) {
                return null;
            }
            try {
                Form form = multiUserChat.getConfigurationForm().createAnswerForm();
                form.setAnswer(JABBER_MEMBERSONLY, this.isStartLocked());
                form.setAnswer(JABBER_ALLOW_INVITES, false);
                form.setAnswer(JABBER_CHANGE_SUBJECT, false);
                form.setAnswer(JABBER_MODERATED, false);
                form.setAnswer(JABBER_PASSWORD_PROTECTED, false);
                form.setAnswer(JABBER_PERSISTENT, false);
                form.setAnswer(JABBER_PUBLIC_ROOM, true);
                multiUserChat.sendConfigurationForm(form);
                this.ownedByMe = true;
                this.owners.clear();
                this.addOwner(this.jid);
            }
            catch (XMPPException xMPPException) {
                if (xMPPException.getXMPPError() == null || xMPPException.getXMPPError().getCode() == 403) break block3;
                throw xMPPException;
            }
        }
        multiUserChat.addMessageListener((PacketListener)jabberClient);
        return multiUserChat;
    }

    public boolean equals(Object object) {
        if (object instanceof JabberRoom) {
            JabberRoom jabberRoom = (JabberRoom)object;
            return jabberRoom.jid.equals(this.jid);
        }
        return false;
    }

    public int hashCode() {
        return this.jid.hashCode();
    }

    public boolean isOwnedByMe() {
        return this.ownedByMe;
    }

    public boolean isOwner(String string) {
        return this.owners.contains(string);
    }

    public void addOwner(String string) {
        if (!this.owners.contains(string)) {
            this.owners.add(string);
        }
    }

    public void removeOwner(String string) {
        this.owners.remove(string);
    }

    public Player getOwningPlayer() {
        if (this.owners.size() == 0) {
            return null;
        }
        return this.getPlayer(this.owners.get(0));
    }

    public void setConfig(Properties properties) {
        this.config = properties;
        this.setName(this.config.getProperty(CONFIG_NAME));
    }

    public String encodeConfig() {
        String string = new PropertiesEncoder(this.config).getStringValue();
        return string == null ? "" : string;
    }

    public void decodeConfig(String string) {
        try {
            this.config = new PropertiesEncoder(string).getProperties();
            this.setName(this.config.getProperty(CONFIG_NAME));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean isStartLocked() {
        return "true".equals(this.config.getProperty(CONFIG_LOCKED));
    }

    public boolean isMatchCrc() {
        return "true".equals(this.config.getProperty(CONFIG_CRC_CHECK));
    }

    public String getCheckCrc() {
        return this.config.getProperty(CONFIG_CRC);
    }

    public String getVassalOption() {
        return this.config.getProperty(CONFIG_VASSAL_VERSION, ANY_OPTION);
    }

    public String getVassalVersion() {
        return this.config.getProperty(CONFIG_MIN_VASSAL_VERSION, Info.getVersion());
    }

    public String getModuleOption() {
        return this.config.getProperty(CONFIG_MODULE_VERSION, ANY_OPTION);
    }

    public String getModuleVersion() {
        return this.config.getProperty(CONFIG_MIN_MODULE_VERSION, GameModule.getGameModule().getGameVersion());
    }

    public void showConfig() {
        JabberRoomConfig jabberRoomConfig = new JabberRoomConfig(this.config, false);
        Dialogs.showDialog(null, Resources.getString("Chat.room_configuration"), jabberRoomConfig, -1, null, 2, null, null, null, null);
    }

    public String canJoin(JabberPlayer jabberPlayer) {
        String string;
        String string2;
        if (this.isOwnedByMe()) {
            return null;
        }
        String string3 = this.getVassalOption();
        if (!ANY_OPTION.equals(string3)) {
            string2 = Info.getVersion();
            string = this.getVassalVersion();
            if (MINIMUM_OPTION.equals(string3)) {
                if (Info.compareVersions(string2, string) < 1) {
                    return Resources.getString("Chat.bad_min_vassal", string2, string);
                }
            } else if (!string2.equals(string)) {
                return Resources.getString("Chat.bad_vassal", string2, string);
            }
        }
        if (!ANY_OPTION.equals(string3 = this.getModuleOption())) {
            string2 = GameModule.getGameModule().getGameVersion();
            string = this.getModuleVersion();
            if (MINIMUM_OPTION.equals(string3)) {
                if (Info.compareVersions(string2, string) < 1) {
                    return Resources.getString("Chat.bad_min_module", string2, string);
                }
            } else if (!string2.equals(string)) {
                return Resources.getString("Chat.bad_module", string2, string);
            }
        }
        if (this.isMatchCrc()) {
            string2 = ((SimpleStatus)jabberPlayer.getStatus()).getCrc();
            string = this.getCheckCrc();
            if (!string.equals(string2)) {
                return Resources.getString("Chat.bad_crc");
            }
        }
        return null;
    }

    public static Properties configureNewRoom() {
        JabberRoomConfig jabberRoomConfig = new JabberRoomConfig();
        Integer n = (int)((Integer)Dialogs.showDialog(null, Resources.getString("Chat.create_new_room"), jabberRoomConfig, -1, null, 2, null, null, null, null));
        if (n != null && n == 0) {
            return jabberRoomConfig.getProperties();
        }
        return null;
    }

    public static class JabberRoomConfig
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextField roomNameConfig;
        private JCheckBox startLockedConfig;
        private JCheckBox matchCrcConfig;
        private JTextField crcConfig;
        private JComboBox vassalVersionConfig;
        private JTextField minimumVassalVersionConfig;
        private JComboBox moduleVersionConfig;
        private JTextField minimumModuleVersionConfig;
        private String vassalVersion = Info.getVersion();
        private String moduleVersion = GameModule.getGameModule().getGameVersion();
        private boolean updateEnabled = true;

        static String versionToOption(String string) {
            if (MINIMUM_VERSION.equals(string)) {
                return JabberRoom.MINIMUM_OPTION;
            }
            if (THIS_VERSION.equals(string)) {
                return JabberRoom.THIS_OPTION;
            }
            return JabberRoom.ANY_OPTION;
        }

        static String optionToVersion(String string) {
            if (JabberRoom.MINIMUM_OPTION.equals(string)) {
                return MINIMUM_VERSION;
            }
            if (JabberRoom.THIS_OPTION.equals(string)) {
                return THIS_VERSION;
            }
            return ANY_VERSION;
        }

        public JabberRoomConfig() {
            this.setLayout(new MigLayout("insets dialog", "[align right][fill,grow]", ""));
            this.add(new JLabel(Resources.getString("Chat.new_room_name")));
            this.roomNameConfig = new JTextField();
            this.add((Component)this.roomNameConfig, "wrap");
            this.add(new JLabel(Resources.getString("Chat.start_locked")));
            this.startLockedConfig = new JCheckBox();
            this.add((Component)this.startLockedConfig, "wrap");
            this.add(new JLabel(Resources.getString("Chat.vassal_versions_allowed")));
            this.vassalVersionConfig = new JComboBox<String>(new String[]{ANY_VERSION, THIS_VERSION, MINIMUM_VERSION});
            this.vassalVersionConfig.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    JabberRoomConfig.this.updateVisibility();
                }
            });
            this.add(this.vassalVersionConfig);
            this.minimumVassalVersionConfig = new JTextField(12);
            this.minimumVassalVersionConfig.setText(this.vassalVersion);
            this.add((Component)this.minimumVassalVersionConfig, "wrap");
            this.add(new JLabel(Resources.getString("Chat.module_versions_allowed")));
            this.moduleVersionConfig = new JComboBox<String>(new String[]{ANY_VERSION, THIS_VERSION, MINIMUM_VERSION});
            this.moduleVersionConfig.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    JabberRoomConfig.this.updateVisibility();
                }
            });
            this.add(this.moduleVersionConfig);
            this.minimumModuleVersionConfig = new JTextField(12);
            this.minimumModuleVersionConfig.setText(this.moduleVersion);
            this.add((Component)this.minimumModuleVersionConfig, "wrap");
            this.add(new JLabel(Resources.getString("Chat.crc_match")));
            this.matchCrcConfig = new JCheckBox();
            this.matchCrcConfig.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JabberRoomConfig.this.updateVisibility();
                }
            });
            this.add(this.matchCrcConfig);
            this.crcConfig = new JTextField(12);
            this.crcConfig.setText(Long.toHexString(GameModule.getGameModule().getCrc()));
            this.crcConfig.setEditable(false);
            this.add((Component)this.crcConfig, "wrap");
            this.updateVisibility();
        }

        public JabberRoomConfig(Properties properties) {
            this();
            this.roomNameConfig.setText(properties.getProperty(JabberRoom.CONFIG_NAME));
            this.startLockedConfig.setSelected("true".equals(properties.getProperty(JabberRoom.CONFIG_LOCKED)));
            this.vassalVersionConfig.setSelectedItem(JabberRoomConfig.optionToVersion(properties.getProperty(JabberRoom.CONFIG_VASSAL_VERSION, ANY_VERSION)));
            this.minimumVassalVersionConfig.setText(properties.getProperty(JabberRoom.CONFIG_MIN_VASSAL_VERSION, ""));
            this.moduleVersionConfig.setSelectedItem(JabberRoomConfig.optionToVersion(properties.getProperty(JabberRoom.CONFIG_MODULE_VERSION, ANY_VERSION)));
            this.minimumModuleVersionConfig.setText(properties.getProperty(JabberRoom.CONFIG_MIN_MODULE_VERSION, ""));
            this.matchCrcConfig.setSelected("true".equals(properties.getProperty(JabberRoom.CONFIG_CRC_CHECK)));
            this.crcConfig.setText(properties.getProperty(JabberRoom.CONFIG_CRC));
        }

        public JabberRoomConfig(Properties properties, boolean bl) {
            this(properties);
            this.setEnabled(bl);
        }

        public boolean isUpdateEnabled() {
            return this.updateEnabled;
        }

        public void setEnabled(boolean bl) {
            this.updateEnabled = bl;
            this.updateVisibility();
        }

        private void updateVisibility() {
            this.minimumVassalVersionConfig.setVisible(!ANY_VERSION.equals(this.vassalVersionConfig.getSelectedItem()));
            this.minimumModuleVersionConfig.setVisible(!ANY_VERSION.equals(this.moduleVersionConfig.getSelectedItem()));
            this.crcConfig.setVisible(this.matchCrcConfig.isSelected());
            this.roomNameConfig.setEditable(this.isUpdateEnabled());
            this.startLockedConfig.setEnabled(this.isUpdateEnabled());
            this.vassalVersionConfig.setEnabled(this.isUpdateEnabled());
            this.minimumVassalVersionConfig.setEditable(this.isUpdateEnabled() && this.vassalVersionConfig.getSelectedItem().equals(MINIMUM_VERSION));
            this.moduleVersionConfig.setEnabled(this.isUpdateEnabled());
            this.minimumModuleVersionConfig.setEditable(this.isUpdateEnabled() && this.moduleVersionConfig.getSelectedItem().equals(MINIMUM_VERSION));
            this.matchCrcConfig.setEnabled(this.isUpdateEnabled());
        }

        public Properties getProperties() {
            Properties properties = new Properties();
            properties.put(JabberRoom.CONFIG_NAME, this.roomNameConfig.getText());
            properties.put(JabberRoom.CONFIG_LOCKED, Boolean.toString(this.startLockedConfig.isSelected()));
            String string = JabberRoomConfig.versionToOption((String)this.vassalVersionConfig.getSelectedItem());
            properties.put(JabberRoom.CONFIG_VASSAL_VERSION, string);
            if (!string.equals(JabberRoom.ANY_OPTION)) {
                properties.put(JabberRoom.CONFIG_MIN_VASSAL_VERSION, this.minimumVassalVersionConfig.getText());
            }
            String string2 = JabberRoomConfig.versionToOption((String)this.moduleVersionConfig.getSelectedItem());
            properties.put(JabberRoom.CONFIG_MODULE_VERSION, string2);
            if (!string2.equals(JabberRoom.ANY_OPTION)) {
                properties.put(JabberRoom.CONFIG_MIN_MODULE_VERSION, this.minimumModuleVersionConfig.getText());
            }
            properties.put(JabberRoom.CONFIG_CRC_CHECK, Boolean.toString(this.matchCrcConfig.isSelected()));
            if (this.matchCrcConfig.isSelected()) {
                properties.put(JabberRoom.CONFIG_CRC, this.crcConfig.getText());
            }
            return properties;
        }
    }

    public static class Manager {
        private Map<String, JabberRoom> jidToRoom = new HashMap<String, JabberRoom>();

        public JabberRoom getRoomByJID(JabberClient jabberClient, String string) {
            return this.getRoomByJID(jabberClient, string, "");
        }

        public synchronized JabberRoom getRoomByJID(JabberClient jabberClient, String string, String string2) {
            if (string == null) {
                return null;
            }
            JabberRoom jabberRoom = this.jidToRoom.get(string);
            if (jabberRoom == null) {
                String string3 = string2 == null ? "" : string2;
                RoomInfo roomInfo = null;
                try {
                    roomInfo = MultiUserChat.getRoomInfo((XMPPConnection)jabberClient.getConnection(), (String)string);
                }
                catch (XMPPException xMPPException) {
                    xMPPException.printStackTrace();
                }
                jabberRoom = new JabberRoom(string3, string, roomInfo, jabberClient);
                this.jidToRoom.put(string, jabberRoom);
            }
            return jabberRoom;
        }

        public synchronized JabberRoom getRoomByName(JabberClient jabberClient, String string) {
            String string2 = StringUtils.escapeNode((String)(jabberClient.getModule() + "-" + string)).toLowerCase() + "@" + jabberClient.getConferenceService();
            JabberRoom jabberRoom = this.jidToRoom.get(string2);
            if (jabberRoom == null) {
                jabberRoom = new JabberRoom(string, string2, null, jabberClient);
                this.jidToRoom.put(string2, jabberRoom);
            }
            return jabberRoom;
        }

        public void deleteRoom(String string) {
            this.jidToRoom.remove(string);
        }

        public synchronized void clear() {
            this.jidToRoom.clear();
        }
    }
}

