/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.Player;
import VASSAL.chat.PrivateChatManager;
import VASSAL.chat.PrivateChatter;
import VASSAL.command.Command;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PrivMsgCommand
extends Command {
    private PrivateChatManager mgr;
    private String msg;
    private Player p;

    public PrivMsgCommand(PrivateChatManager privateChatManager, Player player, String string) {
        this.mgr = privateChatManager;
        this.msg = string;
        this.p = player;
    }

    public void executeCommand() {
        PrivateChatter privateChatter = this.mgr.getChatterFor(this.p);
        if (privateChatter == null) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(privateChatter);
        if (!window.isVisible()) {
            window.setVisible(true);
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component == null || !SwingUtilities.isDescendingFrom(component, window)) {
                Toolkit.getDefaultToolkit().beep();
                int n = privateChatter.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    if (!(privateChatter.getComponent(i) instanceof JTextField)) continue;
                    privateChatter.getComponent(i).requestFocus();
                    break;
                }
            }
        } else {
            window.toFront();
        }
        privateChatter.show(this.msg);
    }

    public Command myUndoCommand() {
        return null;
    }

    public boolean isLoggable() {
        return false;
    }

    public Player getSender() {
        return this.p;
    }

    public String getMessage() {
        return this.msg;
    }
}

