/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.migrator;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.slf4j.migrator.internal.ProgressListener;
import org.slf4j.migrator.line.LineConverter;
import org.slf4j.migrator.line.RuleSet;

public class InplaceFileConverter {
    static final int BUFFER_LEN = 8192;
    final LineConverter lineConverter;
    final String lineTerminator;
    final ProgressListener pl;

    InplaceFileConverter(RuleSet ruleSet, ProgressListener progressListener) {
        this.lineConverter = new LineConverter(ruleSet);
        this.lineTerminator = System.getProperty("line.separator");
        this.pl = progressListener;
    }

    private byte[] readIntoByteArray(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        byte[] byArray = new byte[8192];
        while ((n = fileInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    void convert(File file) throws IOException {
        byte[] byArray = this.readIntoByteArray(file);
        byte[] byArray2 = this.convertIntoTempByteArray(byArray);
        if (this.lineConverter.atLeastOneMatchOccured()) {
            this.writeConvertedBytesIntoFile(file, byArray2);
            this.pl.onInplaceConversion(file);
        }
    }

    private void writeConvertedBytesIntoFile(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private byte[] convertIntoTempByteArray(byte[] byArray) throws IOException {
        String string;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = this.lineConverter.getReplacement(string);
            this.writeReplacement(byteArrayOutputStream, stringArray);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void writeReplacement(OutputStream outputStream, String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            outputStream.write(stringArray[i].getBytes());
            outputStream.write(this.lineTerminator.getBytes());
        }
    }
}

