/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.monitor;

import java.io.UnsupportedEncodingException;
import java.util.Date;

public final class StatusVariable {
    public static final int TYPE_INTEGER = 0;
    public static final int TYPE_FLOAT = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_BOOLEAN = 3;
    public static final int CM_CC = 0;
    public static final int CM_DER = 1;
    public static final int CM_GAUGE = 2;
    public static final int CM_SI = 3;
    static final String SYMBOLIC_NAME_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.";
    static final int MAX_ID_LENGTH = 32;
    private String id;
    private Date timeStamp;
    private int cm;
    private int type;
    private int intData;
    private float floatData;
    private String stringData;
    private boolean booleanData;

    public StatusVariable(String string, int n, int n2) {
        this.setCommon(string, n);
        this.type = 0;
        this.intData = n2;
    }

    public StatusVariable(String string, int n, float f) {
        this.setCommon(string, n);
        this.type = 1;
        this.floatData = f;
    }

    public StatusVariable(String string, int n, boolean bl) {
        this.setCommon(string, n);
        this.type = 3;
        this.booleanData = bl;
    }

    public StatusVariable(String string, int n, String string2) {
        this.setCommon(string, n);
        this.type = 2;
        this.stringData = string2;
    }

    public String getID() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String getString() throws IllegalStateException {
        if (this.type != 2) {
            throw new IllegalStateException("This StatusVariable does not contain a String value.");
        }
        return this.stringData;
    }

    public int getInteger() throws IllegalStateException {
        if (this.type != 0) {
            throw new IllegalStateException("This StatusVariable does not contain an integer value.");
        }
        return this.intData;
    }

    public float getFloat() throws IllegalStateException {
        if (this.type != 1) {
            throw new IllegalStateException("This StatusVariable does not contain a float value.");
        }
        return this.floatData;
    }

    public boolean getBoolean() throws IllegalStateException {
        if (this.type != 3) {
            throw new IllegalStateException("This StatusVariable does not contain a boolean value.");
        }
        return this.booleanData;
    }

    public int getCollectionMethod() {
        return this.cm;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StatusVariable)) {
            return false;
        }
        StatusVariable statusVariable = (StatusVariable)object;
        if (!this.equals(this.id, statusVariable.id) || this.cm != statusVariable.cm || this.type != statusVariable.type) {
            return false;
        }
        switch (this.type) {
            case 0: {
                return this.intData == statusVariable.intData;
            }
            case 1: {
                return this.floatData == statusVariable.floatData;
            }
            case 2: {
                return this.equals(this.stringData, statusVariable.stringData);
            }
            case 3: {
                return this.booleanData == statusVariable.booleanData;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = this.hashCode(this.id) ^ this.cm;
        switch (this.type) {
            case 0: {
                return n ^ this.intData;
            }
            case 1: {
                return n ^ this.hashCode(new Float(this.floatData));
            }
            case 3: {
                return n ^ this.hashCode(new Boolean(this.booleanData));
            }
            case 2: {
                return n ^ this.hashCode(this.stringData);
            }
        }
        return 0;
    }

    public String toString() {
        String string = null;
        switch (this.cm) {
            case 0: {
                string = "CC";
                break;
            }
            case 1: {
                string = "DER";
                break;
            }
            case 2: {
                string = "GAUGE";
                break;
            }
            case 3: {
                string = "SI";
            }
        }
        String string2 = "StatusVariable(" + this.id + ", " + string + ", " + this.timeStamp + ", ";
        switch (this.type) {
            case 0: {
                return string2 + "INTEGER, " + this.intData + ")";
            }
            case 1: {
                return string2 + "FLOAT, " + this.floatData + ")";
            }
            case 2: {
                return string2 + "STRING, " + this.stringData + ")";
            }
            case 3: {
                return string2 + "BOOLEAN, " + this.booleanData + ")";
            }
        }
        return null;
    }

    private void setCommon(String string, int n) throws IllegalArgumentException, NullPointerException {
        StatusVariable.checkId(string, "StatusVariable ID");
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Unknown data collection method constant '" + n + "'.");
        }
        this.id = string;
        this.cm = n;
        this.timeStamp = new Date();
    }

    private boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    private static void checkId(String string, String string2) throws IllegalArgumentException, NullPointerException {
        byte[] byArray;
        if (string == null) {
            throw new NullPointerException(string2 + " is null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException(string2 + " is empty.");
        }
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException.getMessage());
        }
        if (byArray.length > 32) {
            throw new IllegalArgumentException(string2 + " is too long " + "(over " + 32 + " bytes in UTF-8 encoding).");
        }
        if (string.equals(".") || string.equals("..")) {
            throw new IllegalArgumentException(string2 + " is invalid.");
        }
        if (!StatusVariable.containsValidChars(string)) {
            throw new IllegalArgumentException(string2 + " contains invalid characters.");
        }
    }

    private static boolean containsValidChars(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (SYMBOLIC_NAME_CHARACTERS.indexOf(cArray[i]) != -1) continue;
            return false;
        }
        return true;
    }
}

