/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.monitor;

import java.io.UnsupportedEncodingException;
import java.security.Permission;
import java.util.StringTokenizer;

public class MonitorPermission
extends Permission {
    private static final long serialVersionUID = -9084425194463274314L;
    public static final String READ = "read";
    public static final String RESET = "reset";
    public static final String PUBLISH = "publish";
    public static final String STARTJOB = "startjob";
    public static final String SWITCHEVENTS = "switchevents";
    private static final int READ_FLAG = 1;
    private static final int RESET_FLAG = 2;
    private static final int PUBLISH_FLAG = 4;
    private static final int STARTJOB_FLAG = 8;
    private static final int SWITCHEVENTS_FLAG = 16;
    private static final int ALL_FLAGS = 31;
    private String monId;
    private String varId;
    private boolean prefixMonId;
    private boolean prefixVarId;
    private int mask;
    private int minJobInterval;

    public MonitorPermission(String string, String string2) throws IllegalArgumentException {
        super(string);
        if (string == null) {
            throw new IllegalArgumentException("Invalid StatusVariable path 'null'.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Invalid actions string 'null'.");
        }
        int n = string.indexOf(47);
        int n2 = string.length();
        if (n == -1) {
            throw new IllegalArgumentException("Invalid StatusVariable path: should contain '/' separator.");
        }
        if (n == 0 || n == string.length() - 1) {
            throw new IllegalArgumentException("Invalid StatusVariable path: empty monitorable ID or StatusVariable name.");
        }
        this.prefixMonId = string.charAt(n - 1) == '*';
        this.prefixVarId = string.charAt(n2 - 1) == '*';
        this.monId = string.substring(0, this.prefixMonId ? n - 1 : n);
        this.varId = string.substring(n + 1, this.prefixVarId ? n2 - 1 : n2);
        this.checkId(this.monId, "Monitorable ID part of the target");
        this.checkId(this.varId, "Status Variable ID part of the target");
        this.minJobInterval = 0;
        if (string2.equals("*")) {
            this.mask = 31;
        } else {
            this.mask = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken().trim();
                if (string3.equalsIgnoreCase(READ)) {
                    this.addToMask(1, READ);
                    continue;
                }
                if (string3.equalsIgnoreCase(RESET)) {
                    this.addToMask(2, RESET);
                    continue;
                }
                if (string3.equalsIgnoreCase(PUBLISH)) {
                    this.addToMask(4, PUBLISH);
                    continue;
                }
                if (string3.equalsIgnoreCase(SWITCHEVENTS)) {
                    this.addToMask(16, SWITCHEVENTS);
                    continue;
                }
                if (string3.toLowerCase().startsWith(STARTJOB)) {
                    this.minJobInterval = 0;
                    int n3 = STARTJOB.length();
                    if (string3.length() != n3) {
                        if (string3.charAt(n3) != ':') {
                            throw new IllegalArgumentException("Invalid action '" + string3 + "'.");
                        }
                        try {
                            this.minJobInterval = Integer.parseInt(string3.substring(n3 + 1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("Invalid parameter in startjob action '" + string3 + "'.");
                        }
                    }
                    this.addToMask(8, STARTJOB);
                    continue;
                }
                throw new IllegalArgumentException("Invalid action '" + string3 + "'");
            }
        }
    }

    private void addToMask(int n, String string) {
        if ((this.mask & n) != 0) {
            throw new IllegalArgumentException("Invalid action string: " + string + " appears multiple times.");
        }
        this.mask |= n;
    }

    private void checkId(String string, String string2) throws IllegalArgumentException {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException.getMessage());
        }
        if (byArray.length > 32) {
            throw new IllegalArgumentException(string2 + " is too long (over " + 32 + " bytes in UTF-8 encoding).");
        }
        if (string.equals(".") || string.equals("..")) {
            throw new IllegalArgumentException(string2 + " is invalid.");
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.".indexOf(cArray[i]) != -1) continue;
            throw new IllegalArgumentException(string2 + " contains invalid characters.");
        }
    }

    @Override
    public int hashCode() {
        return new Integer(this.mask).hashCode() ^ new Integer(this.minJobInterval).hashCode() ^ this.monId.hashCode() ^ new Boolean(this.prefixMonId).hashCode() ^ this.varId.hashCode() ^ new Boolean(this.prefixVarId).hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MonitorPermission)) {
            return false;
        }
        MonitorPermission monitorPermission = (MonitorPermission)object;
        return this.mask == monitorPermission.mask && this.minJobInterval == monitorPermission.minJobInterval && this.monId.equals(monitorPermission.monId) && this.prefixMonId == monitorPermission.prefixMonId && this.varId.equals(monitorPermission.varId) && this.prefixVarId == monitorPermission.prefixVarId;
    }

    @Override
    public String getActions() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendAction(stringBuffer, 1, READ);
        this.appendAction(stringBuffer, 2, RESET);
        this.appendAction(stringBuffer, 4, PUBLISH);
        this.appendAction(stringBuffer, 8, STARTJOB);
        this.appendAction(stringBuffer, 16, SWITCHEVENTS);
        return stringBuffer.toString();
    }

    private void appendAction(StringBuffer stringBuffer, int n, String string) {
        if ((this.mask & n) != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
            if (n == 8 && this.minJobInterval != 0) {
                stringBuffer.append(':').append(this.minJobInterval);
            }
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof MonitorPermission)) {
            return false;
        }
        MonitorPermission monitorPermission = (MonitorPermission)permission;
        if ((this.mask & monitorPermission.mask) != monitorPermission.mask) {
            return false;
        }
        if ((monitorPermission.mask & 8) != 0 && this.minJobInterval > monitorPermission.minJobInterval) {
            return false;
        }
        return this.implies(this.monId, this.prefixMonId, monitorPermission.monId, monitorPermission.prefixMonId) && this.implies(this.varId, this.prefixVarId, monitorPermission.varId, monitorPermission.prefixVarId);
    }

    private boolean implies(String string, boolean bl, String string2, boolean bl2) {
        return bl ? string2.startsWith(string) : !bl2 && string.equals(string2);
    }
}

