/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.CapturesArgumensFromInvocation;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.reporting.Discrepancy;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;

public class NumberOfInvocationsChecker {
    private final Reporter reporter;
    private final InvocationsFinder finder;
    private final InvocationMarker invocationMarker = new InvocationMarker();

    public NumberOfInvocationsChecker() {
        this(new Reporter(), new InvocationsFinder());
    }

    NumberOfInvocationsChecker(Reporter reporter, InvocationsFinder invocationsFinder) {
        this.reporter = reporter;
        this.finder = invocationsFinder;
    }

    public void check(List<Invocation> list, InvocationMatcher invocationMatcher, int n) {
        List<Invocation> list2 = this.finder.findInvocations(list, invocationMatcher);
        int n2 = list2.size();
        if (n > n2) {
            Location location = this.finder.getLastLocation(list2);
            this.reporter.tooLittleActualInvocations(new Discrepancy(n, n2), invocationMatcher, location);
        } else if (n == 0 && n2 > 0) {
            Location location = list2.get(n).getLocation();
            this.reporter.neverWantedButInvoked(invocationMatcher, location);
        } else if (n < n2) {
            Location location = list2.get(n).getLocation();
            this.reporter.tooManyActualInvocations(n, n2, invocationMatcher, location);
        }
        this.invocationMarker.markVerified(list2, (CapturesArgumensFromInvocation)invocationMatcher);
    }
}

