/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.reporting.SmartPrinter;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.internal.verification.argumentmatching.ArgumentMatchingTool;
import org.mockito.invocation.Invocation;
import org.mockito.verification.VerificationMode;

public class MissingInvocationInOrderChecker {
    private final Reporter reporter;
    private final InvocationsFinder finder;

    public MissingInvocationInOrderChecker() {
        this(new InvocationsFinder(), new Reporter());
    }

    MissingInvocationInOrderChecker(InvocationsFinder invocationsFinder, Reporter reporter) {
        this.finder = invocationsFinder;
        this.reporter = reporter;
    }

    public void check(List<Invocation> list, InvocationMatcher invocationMatcher, VerificationMode verificationMode, InOrderContext inOrderContext) {
        List<Invocation> list2 = this.finder.findAllMatchingUnverifiedChunks(list, invocationMatcher, inOrderContext);
        if (!list2.isEmpty()) {
            return;
        }
        Invocation invocation = this.finder.findPreviousVerifiedInOrder(list, inOrderContext);
        if (invocation == null) {
            List<Invocation> list3 = this.finder.findInvocations(list, invocationMatcher);
            if (list3 == null || list3.isEmpty()) {
                Invocation invocation2 = this.finder.findSimilarInvocation(list, invocationMatcher);
                if (invocation2 != null) {
                    Integer[] integerArray = new ArgumentMatchingTool().getSuspiciouslyNotMatchingArgsIndexes(invocationMatcher.getMatchers(), invocation2.getArguments());
                    SmartPrinter smartPrinter = new SmartPrinter(invocationMatcher, invocation2, integerArray);
                    this.reporter.argumentsAreDifferent(smartPrinter.getWanted(), smartPrinter.getActual(), invocation2.getLocation());
                } else {
                    this.reporter.wantedButNotInvoked(invocationMatcher);
                }
            }
        } else {
            this.reporter.wantedButNotInvokedInOrder(invocationMatcher, invocation);
        }
    }
}

