/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.injection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.injection.MockInjectionStrategy;
import org.mockito.internal.configuration.injection.filter.FinalMockCandidateFilter;
import org.mockito.internal.configuration.injection.filter.MockCandidateFilter;
import org.mockito.internal.configuration.injection.filter.NameBasedCandidateFilter;
import org.mockito.internal.configuration.injection.filter.TypeBasedCandidateFilter;
import org.mockito.internal.util.collections.ListUtil;
import org.mockito.internal.util.collections.Sets;
import org.mockito.internal.util.reflection.FieldInitializationReport;
import org.mockito.internal.util.reflection.FieldInitializer;

public class PropertyAndSetterInjection
extends MockInjectionStrategy {
    private final MockCandidateFilter mockCandidateFilter = new TypeBasedCandidateFilter(new NameBasedCandidateFilter(new FinalMockCandidateFilter()));
    private final Comparator<Field> superTypesLast = new FieldTypeAndNameComparator();
    private final ListUtil.Filter<Field> notFinalOrStatic = new ListUtil.Filter<Field>(){

        @Override
        public boolean isOut(Field field) {
            return Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers());
        }
    };

    @Override
    public boolean processInjection(Field field, Object object, Set<Object> set) {
        FieldInitializationReport fieldInitializationReport = this.initializeInjectMocksField(field, object);
        boolean bl = false;
        Object object2 = fieldInitializationReport.fieldInstance();
        for (Class<?> clazz = fieldInitializationReport.fieldClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            bl |= this.injectMockCandidates(clazz, Sets.newMockSafeHashSet(set), object2);
        }
        return bl;
    }

    private FieldInitializationReport initializeInjectMocksField(Field field, Object object) {
        FieldInitializationReport fieldInitializationReport = null;
        try {
            fieldInitializationReport = new FieldInitializer(object, field).initialize();
        }
        catch (MockitoException mockitoException) {
            if (mockitoException.getCause() instanceof InvocationTargetException) {
                Throwable throwable = mockitoException.getCause().getCause();
                new Reporter().fieldInitialisationThrewException(field, throwable);
            }
            new Reporter().cannotInitializeForInjectMocksAnnotation(field.getName(), mockitoException);
        }
        return fieldInitializationReport;
    }

    private boolean injectMockCandidates(Class<?> clazz, Set<Object> set, Object object) {
        boolean bl = false;
        List<Field> list = this.orderedInstanceFieldsFrom(clazz);
        bl |= this.injectMockCandidatesOnFields(set, object, bl, list);
        bl |= this.injectMockCandidatesOnFields(set, object, bl, list);
        return bl;
    }

    private boolean injectMockCandidatesOnFields(Set<Object> set, Object object, boolean bl, List<Field> list) {
        Iterator<Field> iterator = list.iterator();
        while (iterator.hasNext()) {
            Field field = iterator.next();
            Object object2 = this.mockCandidateFilter.filterCandidate(set, field, object).thenInject();
            if (object2 == null) continue;
            bl |= true;
            set.remove(object2);
            iterator.remove();
        }
        return bl;
    }

    private List<Field> orderedInstanceFieldsFrom(Class<?> clazz) {
        List<Field> list = Arrays.asList(clazz.getDeclaredFields());
        list = ListUtil.filter(list, this.notFinalOrStatic);
        Collections.sort(list, this.superTypesLast);
        return list;
    }

    static class FieldTypeAndNameComparator
    implements Comparator<Field> {
        FieldTypeAndNameComparator() {
        }

        @Override
        public int compare(Field field, Field field2) {
            Class<?> clazz;
            Class<?> clazz2 = field.getType();
            if (clazz2 == (clazz = field2.getType())) {
                return field.getName().compareTo(field2.getName());
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return 1;
            }
            if (clazz.isAssignableFrom(clazz2)) {
                return -1;
            }
            return 0;
        }
    }
}

