/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections15.iterators.EmptyIterator;
import org.apache.commons.collections15.iterators.IteratorChain;
import org.apache.commons.collections15.list.UnmodifiableList;

public class CompositeCollection<E>
implements Collection<E> {
    protected CollectionMutator<E> mutator;
    protected Collection<E>[] all = new Collection[0];

    public CompositeCollection() {
    }

    public CompositeCollection(Collection<E> coll) {
        this();
        this.addComposited(coll);
    }

    public CompositeCollection(Collection<E> ... colls) {
        this();
        this.addComposited(colls);
    }

    @Override
    public int size() {
        int size = 0;
        for (int i = this.all.length - 1; i >= 0; --i) {
            size += this.all[i].size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        for (int i = this.all.length - 1; i >= 0; --i) {
            if (this.all[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object obj) {
        for (int i = this.all.length - 1; i >= 0; --i) {
            if (!this.all[i].contains(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.all.length == 0) {
            return EmptyIterator.INSTANCE;
        }
        IteratorChain<E> chain = new IteratorChain<E>();
        for (int i = 0; i < this.all.length; ++i) {
            chain.addIterator(this.all[i].iterator());
        }
        return chain;
    }

    @Override
    public E[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            result[i] = it.next();
            ++i;
        }
        return result;
    }

    @Override
    public <E> E[] toArray(E[] array) {
        int size = this.size();
        Object[] result = null;
        result = array.length >= size ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        int offset = 0;
        for (int i = 0; i < this.all.length; ++i) {
            Iterator<E> it = this.all[i].iterator();
            while (it.hasNext()) {
                result[offset++] = it.next();
            }
        }
        if (result.length > size) {
            result[size] = null;
        }
        return result;
    }

    @Override
    public boolean add(E obj) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("add() is not supported on CompositeCollection without a CollectionMutator strategy");
        }
        return this.mutator.add(this, this.all, obj);
    }

    @Override
    public boolean remove(Object obj) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("remove() is not supported on CompositeCollection without a CollectionMutator strategy");
        }
        return this.mutator.remove(this, this.all, obj);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("addAll() is not supported on CompositeCollection without a CollectionMutator strategy");
        }
        return this.mutator.addAll(this, this.all, coll);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        if (coll.size() == 0) {
            return false;
        }
        boolean changed = false;
        for (int i = this.all.length - 1; i >= 0; --i) {
            changed = this.all[i].removeAll(coll) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        boolean changed = false;
        for (int i = this.all.length - 1; i >= 0; --i) {
            changed = this.all[i].retainAll(coll) || changed;
        }
        return changed;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.all.length; ++i) {
            this.all[i].clear();
        }
    }

    public void setMutator(CollectionMutator<E> mutator) {
        this.mutator = mutator;
    }

    public void addComposited(Collection<? extends E> ... comps) {
        ArrayList<Collection<Collection<? extends E>>> list = new ArrayList<Collection<Collection<? extends E>>>(Arrays.asList(this.all));
        list.addAll(Arrays.asList(comps));
        this.all = list.toArray(new Collection[list.size()]);
    }

    public void addComposited(Collection<? extends E> c) {
        this.addComposited(new Collection[]{c});
    }

    public void addComposited(Collection<? extends E> c, Collection<? extends E> d) {
        this.addComposited(new Collection[]{c, d});
    }

    public void removeComposited(Collection<? extends E> coll) {
        ArrayList<Collection<E>> list = new ArrayList<Collection<E>>(this.all.length);
        list.addAll(Arrays.asList(this.all));
        list.remove(coll);
        this.all = list.toArray(new Collection[list.size()]);
    }

    public Collection<E> toCollection() {
        return new ArrayList(this);
    }

    public Collection<Collection<E>> getCollections() {
        return UnmodifiableList.decorate(Arrays.asList(this.all));
    }

    public static interface CollectionMutator<E> {
        public boolean add(CompositeCollection<? extends E> var1, Collection<? extends E>[] var2, Object var3);

        public boolean addAll(CompositeCollection<? extends E> var1, Collection<? extends E>[] var2, Collection<? extends E> var3);

        public boolean remove(CompositeCollection<? extends E> var1, Collection<? extends E>[] var2, Object var3);
    }
}

