/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.VMSXML;
import lcmc.gui.Browser;
import lcmc.gui.resources.StringInfo;
import lcmc.gui.resources.VMSHardwareInfo;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import org.w3c.dom.Node;

public abstract class VMSParallelSerialInfo
extends VMSHardwareInfo {
    private static final String[] PARAMETERS = new String[]{"type", "source_path", "source_mode", "target_port", "bind_source_host", "bind_source_service", "connect_source_host", "connect_source_service", "protocol_type"};
    private static final Map<String, List<String>> PARAMETERS_MAP = new HashMap<String, List<String>>();
    private static final Map<String, Widget.Type> FIELD_TYPES;
    private static final Map<String, String> SHORTNAME_MAP;
    private static final Set<String> IS_ENABLED_ONLY_IN_ADVANCED;
    private static final Set<String> IS_REQUIRED;
    private static final Map<String, String> DEFAULTS_MAP;
    private static final Map<String, String> PREFERRED_MAP;
    private static final Map<String, StringInfo[]> POSSIBLE_VALUES;
    private JComponent tablePanel = null;

    VMSParallelSerialInfo(String name, Browser browser, VMSVirtualDomainInfo vmsVirtualDomainInfo) {
        super(name, browser, vmsVirtualDomainInfo);
    }

    @Override
    protected final void addHardwareTable(JPanel mainPanel) {
        this.tablePanel = this.getTablePanel(this.getTableScreenName(), this.getTableName(), this.getNewBtn0(this.getVMSVirtualDomainInfo()));
        if (this.getResource().isNew()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VMSParallelSerialInfo.this.tablePanel.setVisible(false);
                }
            });
        }
        mainPanel.add(this.tablePanel);
    }

    @Override
    protected final String getParamLongDesc(String param) {
        return this.getParamShortDesc(param);
    }

    @Override
    protected final String getParamShortDesc(String param) {
        String name = SHORTNAME_MAP.get(param);
        if (name == null) {
            return param;
        }
        return name;
    }

    @Override
    protected final String getParamPreferred(String param) {
        return PREFERRED_MAP.get(param);
    }

    @Override
    protected final String getParamDefault(String param) {
        return DEFAULTS_MAP.get(param);
    }

    @Override
    public final String[] getParametersFromXML() {
        return (String[])PARAMETERS.clone();
    }

    @Override
    protected final Object[] getParamPossibleChoices(String param) {
        return POSSIBLE_VALUES.get(param);
    }

    @Override
    protected final String getSection(String param) {
        return "Display Options";
    }

    @Override
    protected final boolean isRequired(String param) {
        return IS_REQUIRED.contains(param);
    }

    @Override
    protected final boolean isInteger(String param) {
        return false;
    }

    @Override
    protected final boolean isLabel(String param) {
        return false;
    }

    @Override
    protected final boolean isTimeType(String param) {
        return false;
    }

    @Override
    protected final boolean isCheckBox(String param) {
        return false;
    }

    @Override
    protected final String getParamType(String param) {
        return "undef";
    }

    @Override
    protected final String getParamRegexp(String param) {
        return null;
    }

    @Override
    protected final Widget.Type getFieldType(String param) {
        return FIELD_TYPES.get(param);
    }

    @Override
    final void apply(boolean testOnly) {
        if (testOnly) {
            return;
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                VMSParallelSerialInfo.this.getApplyButton().setEnabled(false);
                VMSParallelSerialInfo.this.getRevertButton().setEnabled(false);
            }
        });
        this.getInfoPanel();
        this.waitForInfoPanel();
        Map<String, String> parameters = this.getHWParameters(this.getResource().isNew());
        for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml != null) {
                parameters.put("saved_type", this.getParamSaved("type"));
                String domainName = this.getVMSVirtualDomainInfo().getDomainName();
                Node domainNode = vmsxml.getDomainNode(domainName);
                this.modifyXML(vmsxml, domainNode, domainName, parameters);
                String virshOptions = this.getVMSVirtualDomainInfo().getVirshOptions();
                vmsxml.saveAndDefine(domainNode, domainName, virshOptions);
            }
            this.getResource().setNew(false);
        }
        this.getBrowser().reload(this.getNode(), false);
        this.getBrowser().periodicalVMSUpdate(this.getVMSVirtualDomainInfo().getDefinedOnHosts());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VMSParallelSerialInfo.this.tablePanel.setVisible(true);
            }
        });
        String[] params = this.getParametersFromXML();
        if (!testOnly) {
            this.storeComboBoxValues(params);
        }
        this.checkResourceFieldsChanged(null, params);
    }

    @Override
    protected Map<String, String> getHWParameters(boolean allParams) {
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                VMSParallelSerialInfo.this.getInfoPanel();
            }
        });
        List<String> params = PARAMETERS_MAP.get(this.getComboBoxValue("type"));
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (params == null) {
            return parameters;
        }
        String type = null;
        for (String param : params) {
            String value = this.getComboBoxValue(param);
            if ("type".equals(param)) {
                type = value;
            }
            if (!allParams && Tools.areEqual(this.getParamSaved(param), value)) continue;
            if (Tools.areEqual(this.getParamDefault(param), value)) {
                parameters.put(param, null);
                continue;
            }
            parameters.put(param, value);
        }
        return parameters;
    }

    @Override
    protected final boolean isAdvanced(String param) {
        return false;
    }

    @Override
    protected final String isEnabled(String param) {
        if ("target_port".equals(param)) {
            return "";
        }
        if (!this.getResource().isNew() && "type".equals(param)) {
            return "";
        }
        return null;
    }

    @Override
    protected final boolean isEnabledOnlyInAdvancedMode(String param) {
        return IS_ENABLED_ONLY_IN_ADVANCED.contains(param);
    }

    @Override
    protected final ConfigData.AccessType getAccessType(String param) {
        return ConfigData.AccessType.ADMIN;
    }

    @Override
    protected final boolean checkParam(String param, final String newValue) {
        if ("type".equals(param)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (String param : PARAMETERS) {
                        VMSParallelSerialInfo.this.getWidget(param, null).setVisible(((List)PARAMETERS_MAP.get(newValue)).contains(param));
                    }
                }
            });
        }
        return !this.isRequired(param) || newValue != null && !"".equals(newValue);
    }

    @Override
    protected final String isRemoveable() {
        return null;
    }

    @Override
    protected final Widget createWidget(String param, String prefix, int width) {
        if ("source_path".equals(param)) {
            String sourceFile = this.getParamSaved("source_path");
            String regexp = "[^/]$";
            MyButton fileChooserBtn = new MyButton("Browse...");
            final Widget paramWi = WidgetFactory.createInstance(Widget.Type.TEXTFIELD, sourceFile, Widget.NO_ITEMS, "[^/]$", width, Widget.NO_ABBRV, new AccessMode(this.getAccessType(param), false), fileChooserBtn);
            if (Tools.isWindows()) {
                paramWi.setTFButtonEnabled(false);
            }
            fileChooserBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            String type;
                            String oldDir = paramWi.getStringValue();
                            String directory = oldDir == null || "".equals(oldDir) ? ("dev".equals(type = VMSParallelSerialInfo.this.getComboBoxValue("type")) ? "/dev" : "/") : oldDir;
                            VMSParallelSerialInfo.this.startFileChooser(paramWi, directory, false);
                        }
                    });
                    t.start();
                }
            });
            this.widgetAdd(param, prefix, paramWi);
            return paramWi;
        }
        Widget paramWi = super.createWidget(param, prefix, width);
        if ("type".equals(param) || "source_mode".equals(param)) {
            paramWi.setAlwaysEditable(false);
        }
        return paramWi;
    }

    protected abstract MyButton getNewBtn0(VMSVirtualDomainInfo var1);

    @Override
    protected abstract void modifyXML(VMSXML var1, Node var2, String var3, Map<String, String> var4);

    protected abstract String getTableScreenName();

    protected abstract String getTableName();

    final String getTargetPort() {
        return this.getParamSaved("target_port");
    }

    @Override
    String[] getRealParametersFromXML() {
        List<String> params = PARAMETERS_MAP.get(this.getComboBoxValue("type"));
        if (params == null) {
            return (String[])PARAMETERS.clone();
        }
        return params.toArray(new String[params.size()]);
    }

    static {
        PARAMETERS_MAP.put("dev", Arrays.asList("type", "source_path", "target_port"));
        PARAMETERS_MAP.put("file", Arrays.asList("type", "source_path", "target_port"));
        PARAMETERS_MAP.put("null", Arrays.asList("type", "target_port"));
        PARAMETERS_MAP.put("pipe", Arrays.asList("type", "source_path", "target_port"));
        PARAMETERS_MAP.put("pty", Arrays.asList("type", "target_port"));
        PARAMETERS_MAP.put("stdio", Arrays.asList("type", "target_port"));
        PARAMETERS_MAP.put("tcp", Arrays.asList("type", "source_mode", "bind_source_host", "bind_source_service", "connect_source_host", "connect_source_service", "protocol_type", "target_port"));
        PARAMETERS_MAP.put("udp", Arrays.asList("type", "bind_source_host", "bind_source_service", "connect_source_host", "connect_source_service", "target_port"));
        PARAMETERS_MAP.put("unix", Arrays.asList("type", "source_mode", "source_path", "target_port"));
        PARAMETERS_MAP.put("vc", Arrays.asList("type", "target_port"));
        FIELD_TYPES = new HashMap<String, Widget.Type>();
        SHORTNAME_MAP = new HashMap<String, String>();
        SHORTNAME_MAP.put("type", "Type");
        SHORTNAME_MAP.put("source_path", "Source Path");
        SHORTNAME_MAP.put("source_mode", "Mode");
        SHORTNAME_MAP.put("bind_source_host", "Server");
        SHORTNAME_MAP.put("bind_source_service", "Server Port");
        SHORTNAME_MAP.put("connect_source_host", "Client");
        SHORTNAME_MAP.put("connect_source_service", "Client Port");
        SHORTNAME_MAP.put("protocol_type", "Protocol");
        SHORTNAME_MAP.put("target_port", "Target Port");
        FIELD_TYPES.put("protocol_type", Widget.Type.RADIOGROUP);
        IS_ENABLED_ONLY_IN_ADVANCED = new HashSet<String>();
        IS_REQUIRED = new HashSet<String>(Arrays.asList("type"));
        DEFAULTS_MAP = new HashMap<String, String>();
        PREFERRED_MAP = new HashMap<String, String>();
        POSSIBLE_VALUES = new HashMap<String, StringInfo[]>();
        POSSIBLE_VALUES.put("type", new StringInfo[]{new StringInfo("Physical Host Char Device (dev)", "dev", null), new StringInfo("Plain File", "file", null), new StringInfo("Null Device", "null", null), new StringInfo("Named Pipe", "pipe", null), new StringInfo("PTTY", "pty", null), new StringInfo("Standard Input/Output", "stdio", null), new StringInfo("TCP Console", "tcp", null), new StringInfo("UDP Console", "udp", null), new StringInfo("Unix Socket", "unix", null), new StringInfo("Virtual Console", "vc", null)});
        POSSIBLE_VALUES.put("source_mode", new StringInfo[]{new StringInfo("Server (bind)", "bind", null), new StringInfo("Client (connect)", "connect", null)});
        POSSIBLE_VALUES.put("protocol_type", new StringInfo[]{new StringInfo("telnet", "telnet", null), new StringInfo("raw", "raw", null)});
        DEFAULTS_MAP.put("target_port", "generate");
        PREFERRED_MAP.put("bind_source_host", "127.0.0.1");
        PREFERRED_MAP.put("bind_source_service", "4555");
        PREFERRED_MAP.put("connect_source_host", "127.0.0.1");
        PREFERRED_MAP.put("connect_source_service", "4556");
        PREFERRED_MAP.put("protocol_type", "telnet");
    }
}

