/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import lcmc.EditHostDialog;
import lcmc.data.AccessMode;
import lcmc.data.Cluster;
import lcmc.data.ClusterStatus;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.PtestData;
import lcmc.data.Subtext;
import lcmc.gui.Browser;
import lcmc.gui.CRMGraph;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.HostBrowser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.HostLogs;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.ServiceInfo;
import lcmc.utilities.ButtonCallback;
import lcmc.utilities.CRM;
import lcmc.utilities.Corosync;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.Heartbeat;
import lcmc.utilities.MyButton;
import lcmc.utilities.MyMenu;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Openais;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public final class HostInfo
extends Info {
    private final Host host;
    static final ImageIcon HOST_STANDBY_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.HostStandbyIcon"));
    static final ImageIcon HOST_STANDBY_OFF_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.HostStandbyOffIcon"));
    static final ImageIcon HOST_STOP_COMM_LAYER_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.HostStopCommLayerIcon"));
    static final ImageIcon HOST_START_COMM_LAYER_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.HostStartCommLayerIcon"));
    private static final Subtext OFFLINE_SUBTEXT = new Subtext("offline", null, Color.BLUE);
    private static final Subtext PENDING_SUBTEXT = new Subtext("pending", null, Color.BLUE);
    private static final Subtext FENCED_SUBTEXT = new Subtext("fencing...", null, Color.RED);
    private static final Subtext CORO_STOPPED_SUBTEXT = new Subtext("stopped", null, Color.RED);
    private static final Subtext PCMK_STOPPED_SUBTEXT = new Subtext("pcmk stopped", null, Color.RED);
    private static final Subtext UNKNOWN_SUBTEXT = new Subtext("wait...", null, Color.BLUE);
    private static final Subtext ONLINE_SUBTEXT = new Subtext("online", null, Color.BLUE);
    private static final Subtext STANDBY_SUBTEXT = new Subtext("STANDBY", null, Color.RED);
    private static final Subtext STOPPING_SUBTEXT = new Subtext("stopping...", null, Color.RED);
    private static final Subtext STARTING_SUBTEXT = new Subtext("starting...", null, Color.BLUE);
    static final String NO_PCMK_STATUS_STRING = "cluster status is not available";
    private volatile boolean crmInfo = false;
    private volatile boolean crmShowInProgress = true;

    public HostInfo(Host host, Browser browser) {
        super(host.getName(), browser);
        this.host = host;
    }

    @Override
    protected HostBrowser getBrowser() {
        return (HostBrowser)super.getBrowser();
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        Cluster cl = this.host.getCluster();
        if (cl != null) {
            return HostBrowser.HOST_IN_CLUSTER_ICON_RIGHT_SMALL;
        }
        return HostBrowser.HOST_ICON;
    }

    @Override
    public String getId() {
        return this.host.getName();
    }

    @Override
    public ImageIcon getCategoryIcon(boolean testOnly) {
        return HostBrowser.HOST_ICON;
    }

    @Override
    public String getToolTipForGraph(boolean testOnly) {
        return this.getBrowser().getHostToolTip(this.host);
    }

    @Override
    public JComponent getInfoPanel() {
        if (this.getBrowser().getClusterBrowser() == null) {
            return new JPanel();
        }
        Font f = new Font("Monospaced", 0, Tools.getConfigData().scaled(12));
        this.crmShowInProgress = true;
        final JTextArea ta = new JTextArea(Tools.getString("HostInfo.crmShellLoading"));
        ta.setEditable(false);
        ta.setFont(f);
        final MyButton crmConfigureCommitButton = new MyButton(Tools.getString("HostInfo.crmShellCommitButton"), Browser.APPLY_ICON);
        this.registerComponentEnableAccessMode(crmConfigureCommitButton, new AccessMode(ConfigData.AccessType.ADMIN, false));
        final MyButton hostInfoButton = new MyButton(Tools.getString("HostInfo.crmShellStatusButton"));
        hostInfoButton.miniButton();
        final MyButton crmConfigureShowButton = new MyButton(Tools.getString("HostInfo.crmShellShowButton"));
        crmConfigureShowButton.miniButton();
        crmConfigureCommitButton.setEnabled(false);
        final ExecCallback execCallback = new ExecCallback(){

            @Override
            public void done(String ans) {
                ta.setText(ans);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        crmConfigureShowButton.setEnabled(true);
                        hostInfoButton.setEnabled(true);
                        HostInfo.this.crmShowInProgress = false;
                    }
                });
            }

            @Override
            public void doneError(String ans, int exitCode) {
                ta.setText(ans);
                Tools.sshError(HostInfo.this.host, "", ans, "", exitCode);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        crmConfigureCommitButton.setEnabled(false);
                    }
                });
            }
        };
        hostInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostInfo.this.registerComponentEditAccessMode(ta, new AccessMode(ConfigData.AccessType.GOD, false));
                HostInfo.this.crmInfo = true;
                hostInfoButton.setEnabled(false);
                crmConfigureCommitButton.setEnabled(false);
                String command = "HostBrowser.getHostInfo";
                if (!HostInfo.this.host.isCsInit()) {
                    command = "HostBrowser.getHostInfoHeartbeat";
                }
                HostInfo.this.host.execCommand(command, execCallback, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
            }
        });
        this.host.registerEnableOnConnect(hostInfoButton);
        crmConfigureShowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostInfo.this.registerComponentEditAccessMode(ta, new AccessMode(ConfigData.AccessType.ADMIN, false));
                HostInfo.this.updateAdvancedPanels();
                HostInfo.this.crmShowInProgress = true;
                HostInfo.this.crmInfo = false;
                crmConfigureShowButton.setEnabled(false);
                crmConfigureCommitButton.setEnabled(false);
                HostInfo.this.host.execCommand("HostBrowser.getCrmConfigureShow", execCallback, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
            }
        });
        final CRMGraph crmg = this.getBrowser().getClusterBrowser().getCRMGraph();
        Document taDocument = ta.getDocument();
        taDocument.addDocumentListener(new DocumentListener(){

            private void update() {
                if (!HostInfo.this.crmShowInProgress && !HostInfo.this.crmInfo) {
                    crmConfigureCommitButton.setEnabled(true);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }
        });
        ButtonCallback buttonCallback = new ButtonCallback(){
            private volatile boolean mouseStillOver = false;

            @Override
            public boolean isEnabled() {
                return !Tools.versionBeforePacemaker(HostInfo.this.host);
            }

            @Override
            public void mouseOut() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = false;
                crmg.stopTestAnimation(crmConfigureCommitButton);
                crmConfigureCommitButton.setToolTipText(null);
            }

            @Override
            public void mouseOver() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = true;
                crmConfigureCommitButton.setToolTipText(ClusterBrowser.STARTING_PTEST_TOOLTIP);
                crmConfigureCommitButton.setToolTipBackground(Tools.getDefaultColor("ClusterBrowser.Test.Tooltip.Background"));
                Tools.sleep(250);
                if (!this.mouseStillOver) {
                    return;
                }
                this.mouseStillOver = false;
                CountDownLatch startTestLatch = new CountDownLatch(1);
                crmg.startTestAnimation(crmConfigureCommitButton, startTestLatch);
                Host dcHost = HostInfo.this.getBrowser().getClusterBrowser().getDCHost();
                HostInfo.this.getBrowser().getClusterBrowser().ptestLockAcquire();
                ClusterStatus clStatus = HostInfo.this.getBrowser().getClusterBrowser().getClusterStatus();
                clStatus.setPtestData(null);
                CRM.crmConfigureCommit(HostInfo.this.host, ta.getText(), true);
                PtestData ptestData = new PtestData(CRM.getPtest(dcHost));
                crmConfigureCommitButton.setToolTipText(ptestData.getToolTip());
                clStatus.setPtestData(ptestData);
                HostInfo.this.getBrowser().getClusterBrowser().ptestLockRelease();
                startTestLatch.countDown();
            }
        };
        this.addMouseOverListener(crmConfigureCommitButton, buttonCallback);
        crmConfigureCommitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                crmConfigureCommitButton.setEnabled(false);
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        HostInfo.this.getBrowser().getClusterBrowser().clStatusLock();
                        String ret = CRM.crmConfigureCommit(HostInfo.this.host, ta.getText(), false);
                        HostInfo.this.getBrowser().getClusterBrowser().clStatusUnlock();
                    }
                });
                thread.start();
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(HostBrowser.PANEL_BACKGROUND);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(HostBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, 50));
        buttonPanel.setPreferredSize(new Dimension(0, 50));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        mainPanel.add(buttonPanel);
        buttonPanel.add((Component)this.getActionsButton(), "East");
        JPanel p = new JPanel(new SpringLayout());
        p.setBackground(HostBrowser.BUTTON_PANEL_BACKGROUND);
        p.add(hostInfoButton);
        p.add(crmConfigureShowButton);
        p.add(crmConfigureCommitButton);
        p.add(new JLabel(""));
        SpringUtilities.makeCompactGrid(p, 1, 3, 1, 1, 1, 1);
        mainPanel.setMinimumSize(new Dimension(Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Width"), Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Height")));
        mainPanel.setPreferredSize(new Dimension(Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Width"), Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Height")));
        buttonPanel.add(p);
        mainPanel.add(new JLabel(Tools.getString("HostInfo.crmShellInfo")));
        mainPanel.add(new JScrollPane(ta));
        String command = "HostBrowser.getHostInfo";
        if (!this.host.isCsInit()) {
            command = "HostBrowser.getHostInfoHeartbeat";
        }
        this.host.execCommand(command, execCallback, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
        return mainPanel;
    }

    public Host getHost() {
        return this.host;
    }

    boolean equals(HostInfo otherHI) {
        if (otherHI == null) {
            return false;
        }
        return otherHI.toString().equals(this.host.getName());
    }

    @Override
    public String toString() {
        return this.host.getName();
    }

    @Override
    public String getName() {
        return this.host.getName();
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        boolean testOnly = false;
        MyMenuItem hostWizardItem = new MyMenuItem(Tools.getString("HostBrowser.HostWizard"), HostBrowser.HOST_ICON_LARGE, "", new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                EditHostDialog dialog = new EditHostDialog(HostInfo.this.host);
                dialog.showDialogs();
            }
        };
        items.add(hostWizardItem);
        Tools.getGUIData().registerAddHostButton(hostWizardItem);
        HostInfo thisClass = this;
        MyMenuItem standbyItem = new MyMenuItem(Tools.getString("HostBrowser.CRM.StandByOn"), HOST_STANDBY_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, Tools.getString("HostBrowser.CRM.StandByOff"), HOST_STANDBY_OFF_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return !HostInfo.this.isStandby(false);
            }

            @Override
            public String enablePredicate() {
                if (!HostInfo.this.getHost().isClStatus()) {
                    return HostInfo.NO_PCMK_STATUS_STRING;
                }
                return null;
            }

            @Override
            public void action() {
                Host dcHost = HostInfo.this.getBrowser().getClusterBrowser().getDCHost();
                if (HostInfo.this.isStandby(false)) {
                    CRM.standByOff(dcHost, HostInfo.this.host, false);
                } else {
                    CRM.standByOn(dcHost, HostInfo.this.host, false);
                }
            }
        };
        final ClusterBrowser cb = this.getBrowser().getClusterBrowser();
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.ClMenuItemCallback standbyItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, standbyItem, this.host){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host dcHost) {
                    if (HostInfo.this.isStandby(false)) {
                        CRM.standByOff(dcHost, HostInfo.this.host, true);
                    } else {
                        CRM.standByOn(dcHost, HostInfo.this.host, true);
                    }
                }
            };
            this.addMouseOverListener(standbyItem, standbyItemCallback);
        }
        items.add(standbyItem);
        MyMenuItem allMigrateFromItem = new MyMenuItem(Tools.getString("HostInfo.CRM.AllMigrateFrom"), HOST_STANDBY_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return true;
            }

            @Override
            public String enablePredicate() {
                if (!HostInfo.this.getHost().isClStatus()) {
                    return HostInfo.NO_PCMK_STATUS_STRING;
                }
                if (HostInfo.this.getBrowser().getClusterBrowser().getExistingServiceList(null).isEmpty()) {
                    return "there are no services to migrate";
                }
                return null;
            }

            @Override
            public void action() {
                for (ServiceInfo si : cb.getExistingServiceList(null)) {
                    List<String> runningOnNodes;
                    if (si.isConstraintPH() || si.getGroupInfo() != null || si.getCloneInfo() != null || (runningOnNodes = si.getRunningOnNodes(false)) == null || !runningOnNodes.contains(HostInfo.this.getHost().getName())) continue;
                    Host dcHost = HostInfo.this.getHost();
                    si.migrateFromResource(dcHost, HostInfo.this.getHost().getName(), false);
                }
            }
        };
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.ClMenuItemCallback allMigrateFromItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, allMigrateFromItem, this.host){
                {
                    ClusterBrowser clusterBrowser2 = x0;
                    clusterBrowser2.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host dcHost) {
                    for (ServiceInfo si : cb.getExistingServiceList(null)) {
                        List<String> runningOnNodes;
                        if (si.isConstraintPH() || si.getGroupInfo() != null || (runningOnNodes = si.getRunningOnNodes(false)) == null || !runningOnNodes.contains(HostInfo.this.host.getName())) continue;
                        si.migrateFromResource(dcHost, HostInfo.this.host.getName(), true);
                    }
                }
            };
            this.addMouseOverListener(allMigrateFromItem, allMigrateFromItemCallback);
        }
        items.add(allMigrateFromItem);
        MyMenuItem stopCorosyncItem = new MyMenuItem(Tools.getString("HostInfo.StopCorosync"), HOST_STOP_COMM_LAYER_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, Tools.getString("HostInfo.StopOpenais"), HOST_STOP_COMM_LAYER_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return HostInfo.this.getHost().isCsRunning() && !HostInfo.this.getHost().isAisRunning();
            }

            @Override
            public boolean visiblePredicate() {
                return HostInfo.this.getHost().isCsRunning() || HostInfo.this.getHost().isAisRunning();
            }

            @Override
            public void action() {
                if (Tools.confirmDialog(Tools.getString("HostInfo.confirmCorosyncStop.Title"), Tools.getString("HostInfo.confirmCorosyncStop.Desc"), Tools.getString("HostInfo.confirmCorosyncStop.Yes"), Tools.getString("HostInfo.confirmCorosyncStop.No"))) {
                    Host host = HostInfo.this.getHost();
                    host.setCommLayerStopping(true);
                    if (!host.isPcmkStartedByCorosync() && host.isPcmkInit() && host.isPcmkRunning()) {
                        Corosync.stopCorosyncWithPcmk(host);
                    } else {
                        Corosync.stopCorosync(host);
                    }
                    HostInfo.this.getBrowser().getClusterBrowser().updateHWInfo(host);
                }
            }
        };
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.ClMenuItemCallback stopCorosyncItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, stopCorosyncItem, this.host){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host dcHost) {
                    if (!HostInfo.this.isStandby(false)) {
                        CRM.standByOn(dcHost, HostInfo.this.host, true);
                    }
                }
            };
            this.addMouseOverListener(stopCorosyncItem, stopCorosyncItemCallback);
        }
        items.add(stopCorosyncItem);
        MyMenuItem stopHeartbeatItem = new MyMenuItem(Tools.getString("HostInfo.StopHeartbeat"), HOST_STOP_COMM_LAYER_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return HostInfo.this.getHost().isHeartbeatRunning();
            }

            @Override
            public void action() {
                if (Tools.confirmDialog(Tools.getString("HostInfo.confirmHeartbeatStop.Title"), Tools.getString("HostInfo.confirmHeartbeatStop.Desc"), Tools.getString("HostInfo.confirmHeartbeatStop.Yes"), Tools.getString("HostInfo.confirmHeartbeatStop.No"))) {
                    HostInfo.this.getHost().setCommLayerStopping(true);
                    Heartbeat.stopHeartbeat(HostInfo.this.getHost());
                    HostInfo.this.getBrowser().getClusterBrowser().updateHWInfo(HostInfo.this.host);
                }
            }
        };
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.ClMenuItemCallback stopHeartbeatItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, stopHeartbeatItem, this.host){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host dcHost) {
                    if (!HostInfo.this.isStandby(false)) {
                        CRM.standByOn(dcHost, HostInfo.this.host, true);
                    }
                }
            };
            this.addMouseOverListener(stopHeartbeatItem, stopHeartbeatItemCallback);
        }
        items.add(stopHeartbeatItem);
        MyMenuItem startCorosyncItem = new MyMenuItem(Tools.getString("HostInfo.StartCorosync"), HOST_START_COMM_LAYER_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                Host h = HostInfo.this.getHost();
                return h.isCorosync() && h.isCsInit() && h.isCsAisConf() && !h.isCsRunning() && !h.isAisRunning() && !h.isHeartbeatRunning() && !h.isHeartbeatRc();
            }

            @Override
            public String enablePredicate() {
                Host h = HostInfo.this.getHost();
                if (h.isAisRc() && !h.isCsRc()) {
                    return "Openais is in rc.d";
                }
                return null;
            }

            @Override
            public void action() {
                HostInfo.this.getHost().setCommLayerStarting(true);
                if (HostInfo.this.getHost().isPcmkRc()) {
                    Corosync.startCorosyncWithPcmk(HostInfo.this.getHost());
                } else {
                    Corosync.startCorosync(HostInfo.this.getHost());
                }
                HostInfo.this.getBrowser().getClusterBrowser().updateHWInfo(HostInfo.this.host);
            }
        };
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.ClMenuItemCallback startCorosyncItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, startCorosyncItem, this.host){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host host) {
                }
            };
            this.addMouseOverListener(startCorosyncItem, startCorosyncItemCallback);
        }
        items.add(startCorosyncItem);
        MyMenuItem startOpenaisItem = new MyMenuItem(Tools.getString("HostInfo.StartOpenais"), HOST_START_COMM_LAYER_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                Host h = HostInfo.this.getHost();
                return h.isAisInit() && h.isCsAisConf() && !h.isCsRunning() && !h.isAisRunning() && !h.isHeartbeatRunning() && !h.isHeartbeatRc();
            }

            @Override
            public String enablePredicate() {
                Host h = HostInfo.this.getHost();
                if (h.isCsRc() && !h.isAisRc()) {
                    return "Corosync is in rc.d";
                }
                return null;
            }

            @Override
            public void action() {
                HostInfo.this.getHost().setCommLayerStarting(true);
                Openais.startOpenais(HostInfo.this.getHost());
                HostInfo.this.getBrowser().getClusterBrowser().updateHWInfo(HostInfo.this.host);
            }
        };
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.ClMenuItemCallback startOpenaisItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, startOpenaisItem, this.host){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host host) {
                }
            };
            this.addMouseOverListener(startOpenaisItem, startOpenaisItemCallback);
        }
        items.add(startOpenaisItem);
        MyMenuItem startHeartbeatItem = new MyMenuItem(Tools.getString("HostInfo.StartHeartbeat"), HOST_START_COMM_LAYER_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                Host h = HostInfo.this.getHost();
                return h.isHeartbeatInit() && h.isHeartbeatConf() && !h.isCsRunning() && !h.isAisRunning() && !h.isHeartbeatRunning();
            }

            @Override
            public void action() {
                HostInfo.this.getHost().setCommLayerStarting(true);
                Heartbeat.startHeartbeat(HostInfo.this.getHost());
                HostInfo.this.getBrowser().getClusterBrowser().updateHWInfo(HostInfo.this.host);
            }
        };
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.ClMenuItemCallback startHeartbeatItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, startHeartbeatItem, this.host){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host host) {
                }
            };
            this.addMouseOverListener(startHeartbeatItem, startHeartbeatItemCallback);
        }
        items.add(startHeartbeatItem);
        MyMenuItem startPcmkItem = new MyMenuItem(Tools.getString("HostInfo.StartPacemaker"), HOST_START_COMM_LAYER_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                Host h = HostInfo.this.getHost();
                return !h.isPcmkStartedByCorosync() && !h.isPcmkRunning() && (h.isCsRunning() || h.isAisRunning()) && !h.isHeartbeatRunning();
            }

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                HostInfo.this.host.setPcmkStarting(true);
                Corosync.startPacemaker(HostInfo.this.host);
                HostInfo.this.getBrowser().getClusterBrowser().updateHWInfo(HostInfo.this.host);
            }
        };
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.ClMenuItemCallback startPcmkItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, startPcmkItem, this.host){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host host) {
                }
            };
            this.addMouseOverListener(startPcmkItem, startPcmkItemCallback);
        }
        items.add(startPcmkItem);
        MyMenuItem changeHostColorItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.ChangeHostColor"), null, "", new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                Color newColor = JColorChooser.showDialog(Tools.getGUIData().getMainFrame(), "Choose " + HostInfo.this.host.getName() + " color", HostInfo.this.host.getPmColors()[0]);
                if (newColor != null) {
                    HostInfo.this.host.setSavedColor(newColor);
                }
            }
        };
        items.add(changeHostColorItem);
        MyMenuItem viewLogsItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.ViewLogs"), LOGFILE_ICON, "", new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (!HostInfo.this.getHost().isConnected()) {
                    return "not connected to the host";
                }
                return null;
            }

            @Override
            public void action() {
                HostLogs l = new HostLogs(HostInfo.this.host);
                l.showDialog();
            }
        };
        items.add(viewLogsItem);
        MyMenu hostAdvancedSubmenu = new MyMenu(Tools.getString("HostBrowser.AdvancedSubmenu"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (!HostInfo.this.host.isConnected()) {
                    return "not connected to the host";
                }
                return null;
            }

            @Override
            public void update() {
                super.update();
                HostInfo.this.getBrowser().addAdvancedMenu(this);
            }
        };
        items.add(hostAdvancedSubmenu);
        MyMenuItem removeHostItem = new MyMenuItem(Tools.getString("HostBrowser.RemoveHost"), HostBrowser.HOST_REMOVE_ICON, Tools.getString("HostBrowser.RemoveHost"), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (HostInfo.this.getHost().getCluster() != null) {
                    return "it is a member of a cluster";
                }
                return null;
            }

            @Override
            public void action() {
                HostInfo.this.getHost().disconnect();
                Tools.getConfigData().removeHostFromHosts(HostInfo.this.getHost());
                Tools.getGUIData().allHostsUpdate();
            }
        };
        items.add(removeHostItem);
        return items;
    }

    @Override
    public JPanel getGraphicalView() {
        ClusterBrowser b = this.getBrowser().getClusterBrowser();
        if (b == null) {
            return null;
        }
        return b.getServicesInfo().getGraphicalView();
    }

    public int getUsed() {
        return -1;
    }

    public Subtext[] getSubtextsForGraph(boolean testOnly) {
        ArrayList<Subtext> texts = new ArrayList<Subtext>();
        if (this.getHost().isConnected()) {
            if (!this.getHost().isClStatus()) {
                texts.add(new Subtext("waiting for Pacemaker...", null, Color.BLACK));
            }
        } else {
            texts.add(new Subtext("connecting...", null, Color.BLACK));
        }
        return texts.toArray(new Subtext[texts.size()]);
    }

    public String getIconTextForGraph(boolean testOnly) {
        if (!this.getHost().isConnected()) {
            return Tools.getString("HostBrowser.Hb.NoInfoAvailable");
        }
        return null;
    }

    public boolean isStandby(boolean testOnly) {
        ClusterBrowser b = this.getBrowser().getClusterBrowser();
        if (b == null) {
            return false;
        }
        return b.isStandby(this.host, testOnly);
    }

    ClusterStatus getClusterStatus() {
        ClusterBrowser b = this.getBrowser().getClusterBrowser();
        if (b == null) {
            return null;
        }
        return b.getClusterStatus();
    }

    public Subtext getRightCornerTextForGraph(boolean testOnly) {
        if (this.getHost().isCommLayerStopping()) {
            return STOPPING_SUBTEXT;
        }
        if (this.getHost().isCommLayerStarting()) {
            return STARTING_SUBTEXT;
        }
        if (this.getHost().isPcmkStarting()) {
            return STARTING_SUBTEXT;
        }
        ClusterStatus cs = this.getClusterStatus();
        if (cs != null && cs.isFencedNode(this.host.getName())) {
            return FENCED_SUBTEXT;
        }
        if (this.getHost().isClStatus()) {
            if (this.isStandby(testOnly)) {
                return STANDBY_SUBTEXT;
            }
            return ONLINE_SUBTEXT;
        }
        if (this.getHost().isConnected()) {
            Boolean running = this.getHost().getCorosyncHeartbeatRunning();
            if (running == null) {
                return UNKNOWN_SUBTEXT;
            }
            if (!running.booleanValue()) {
                return CORO_STOPPED_SUBTEXT;
            }
            if (cs != null && cs.isPendingNode(this.host.getName())) {
                return PENDING_SUBTEXT;
            }
            if (!this.getHost().isPcmkRunning()) {
                return PCMK_STOPPED_SUBTEXT;
            }
            if (cs != null && "no".equals(cs.isOnlineNode(this.host.getName()))) {
                return OFFLINE_SUBTEXT;
            }
            return UNKNOWN_SUBTEXT;
        }
        return null;
    }

    @Override
    public void selectMyself() {
        super.selectMyself();
        this.getBrowser().nodeChanged(this.getNode());
    }
}

