/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.drbdConfig;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.drbdConfig.ProxyInst;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.gui.widget.Widget;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.MyButton;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

final class ProxyCheckInstallation
extends DialogHost {
    private static final long serialVersionUID = 1L;
    private WizardDialog nextDialogObject = null;
    private final JLabel proxyLabel = new JLabel(": " + Tools.getString("ProxyCheckInstallation.CheckingProxy"));
    private final MyButton proxyButton = new MyButton(Tools.getString("ProxyCheckInstallation.ProxyInstallButton"));
    private Widget proxyInstMethodWi;
    private static final ImageIcon CHECKING_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Host.CheckInstallation.CheckingIcon"));
    private static final ImageIcon NOT_INSTALLED_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Host.CheckInstallation.NotInstalledIcon"));
    private static final ImageIcon INSTALLED_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Host.CheckInstallation.InstalledIcon"));
    private static final ImageIcon UPGR_AVAIL_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Host.CheckInstallation.UpgrAvailIcon"));
    private static final String PROXY_PREFIX = "ProxyInst";
    private static final String PROXY_AUTO_OPTION = "proxyinst";
    private final JLabel proxyIcon = new JLabel(CHECKING_ICON);
    private boolean proxyOk = false;
    private final Host host;
    private final DrbdVolumeInfo drbdVolumeInfo;
    private final WizardDialog origDialog;

    ProxyCheckInstallation(WizardDialog previousDialog, Host host, DrbdVolumeInfo drbdVolumeInfo, WizardDialog origDialog) {
        super(previousDialog, host);
        this.host = host;
        this.drbdVolumeInfo = drbdVolumeInfo;
        this.origDialog = origDialog;
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[0]);
    }

    @Override
    protected void initDialogAfterVisible() {
        this.proxyOk = false;
        this.nextDialogObject = null;
        final ProxyCheckInstallation thisClass = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProxyCheckInstallation.this.proxyButton.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
                ProxyCheckInstallation.this.proxyButton.setEnabled(false);
                ProxyCheckInstallation.this.proxyInstMethodWi.setEnabled(false);
            }
        });
        this.proxyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyCheckInstallation.this.nextDialogObject = new ProxyInst(thisClass, ProxyCheckInstallation.this.getHost(), ProxyCheckInstallation.this.drbdVolumeInfo, ProxyCheckInstallation.this.origDialog);
                DialogHost.InstallMethods im = (DialogHost.InstallMethods)ProxyCheckInstallation.this.proxyInstMethodWi.getValue();
                ProxyCheckInstallation.this.getHost().setProxyInstallMethod(im.getIndex());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProxyCheckInstallation.this.buttonClass(ProxyCheckInstallation.this.nextButton()).pressButton();
                    }
                });
            }
        });
        this.getHost().execCommand("ProxyCheck.version", this.getProgressBar(), new ExecCallback(){

            @Override
            public void done(String ans) {
                ProxyCheckInstallation.this.checkProxy(ans);
            }

            @Override
            public void doneError(String ans, int exitCode) {
                ProxyCheckInstallation.this.checkProxy("");
            }
        }, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
    }

    void checkProxy(final String ans) {
        if ("".equals(ans) || "\n".equals(ans)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProxyCheckInstallation.this.proxyLabel.setText(": " + Tools.getString("ProxyCheckInstallation.ProxyNotInstalled"));
                    ProxyCheckInstallation.this.proxyIcon.setIcon(NOT_INSTALLED_ICON);
                    String toolTip = ProxyCheckInstallation.this.getInstToolTip(ProxyCheckInstallation.PROXY_PREFIX, "1");
                    ProxyCheckInstallation.this.proxyInstMethodWi.setToolTipText(toolTip);
                    ProxyCheckInstallation.this.proxyButton.setToolTipText(toolTip);
                    ProxyCheckInstallation.this.proxyButton.setEnabled(true);
                    ProxyCheckInstallation.this.proxyInstMethodWi.setEnabled(true);
                }
            });
            this.progressBarDone();
            this.printErrorAndRetry(Tools.getString("Dialog.Host.CheckInstallation.SomeFailed"));
        } else {
            this.proxyOk = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProxyCheckInstallation.this.proxyLabel.setText(": " + ans.trim());
                    ProxyCheckInstallation.this.proxyButton.setText(Tools.getString("ProxyCheckInstallation.ProxyCheckForUpgradeButton"));
                    ProxyCheckInstallation.this.proxyIcon.setIcon(INSTALLED_ICON);
                    ProxyCheckInstallation.this.buttonClass(ProxyCheckInstallation.this.finishButton()).setEnabled(true);
                    ProxyCheckInstallation.this.makeDefaultAndRequestFocus(ProxyCheckInstallation.this.buttonClass(ProxyCheckInstallation.this.finishButton()));
                }
            });
            this.progressBarDone();
            this.enableComponents();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProxyCheckInstallation.this.answerPaneSetText(Tools.getString("Dialog.Host.CheckInstallation.AllOk"));
                }
            });
        }
    }

    @Override
    public WizardDialog nextDialog() {
        return this.nextDialogObject;
    }

    @Override
    protected void finishDialog() {
        if (this.isPressedButton(this.finishButton()) || this.isPressedButton(this.nextButton())) {
            if (this.nextDialogObject == null) {
                this.host.getBrowser().getClusterBrowser().getDrbdGraph().getDrbdInfo().addProxyHostNode(this.getHost());
            }
            if (this.nextDialogObject == null && this.origDialog != null) {
                this.nextDialogObject = this.origDialog;
                this.setPressedButton(this.nextButton());
            }
            this.getHost().getCluster().addProxyHost(this.getHost());
            if (this.drbdVolumeInfo != null) {
                this.drbdVolumeInfo.getDrbdResourceInfo().resetDrbdResourcePanel();
            }
        }
    }

    @Override
    protected String getHostDialogTitle() {
        return Tools.getString("ProxyCheckInstallation.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("ProxyCheckInstallation.Description");
    }

    private JPanel getInstallationPane() {
        JPanel pane = new JPanel(new SpringLayout());
        this.proxyInstMethodWi = this.getInstallationMethods(PROXY_PREFIX, Tools.getConfigData().isStagingPacemaker(), null, PROXY_AUTO_OPTION, this.proxyButton);
        pane.add(new JLabel("Proxy"));
        pane.add(this.proxyLabel);
        pane.add(this.proxyIcon);
        pane.add(this.proxyInstMethodWi);
        pane.add(this.proxyButton);
        SpringUtilities.makeCompactGrid(pane, 1, 5, 1, 1, 1, 1);
        return pane;
    }

    @Override
    protected JComponent getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.getInstallationPane());
        pane.add(this.getProgressBarPane());
        pane.add(this.getAnswerPane(Tools.getString("ProxyCheckInstallation.CheckingProxy")));
        SpringUtilities.makeCompactGrid(pane, 3, 1, 0, 0, 0, 0);
        return pane;
    }

    @Override
    protected boolean skipButtonEnabled() {
        return true;
    }

    @Override
    protected final WizardDialog dialogAfterCancel() {
        return this.origDialog;
    }
}

