/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Resource {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private final Map<String, String> savedValue = new HashMap<String, String>();
    private final Map<String, Object[]> possibleChoicesMap = new HashMap<String, Object[]>();
    private final Map<String, String> defaultValueMap = new HashMap<String, String>();
    private final Map<String, String> preferredValueMap = new HashMap<String, String>();
    private boolean newResource = false;

    public Resource() {
    }

    public Resource(String name) {
        this.name = name;
    }

    public final void setValue(String param, String value) {
        this.savedValue.put(param, value);
    }

    public String getValue(String param) {
        return this.savedValue.get(param);
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    protected List<Object> getPossibleChoices(String param, Object[] values) {
        ArrayList<Object> possibleChoices = new ArrayList<Object>();
        if (values == null) {
            return possibleChoices;
        }
        for (int i = 0; i < values.length; ++i) {
            possibleChoices.add(values[i]);
        }
        return possibleChoices;
    }

    public final void setPossibleChoices(String param, Object[] possibleChoices) {
        this.possibleChoicesMap.remove(param);
        this.possibleChoicesMap.put(param, possibleChoices);
    }

    public Object[] getPossibleChoices(String param) {
        List<Object> possibleChoices = this.getPossibleChoices(param, this.possibleChoicesMap.get(param));
        return possibleChoices.toArray(new Object[possibleChoices.size()]);
    }

    public final void setDefaultValue(String param, String defaultValue) {
        this.defaultValueMap.put(param, defaultValue);
    }

    public final String getDefaultValue(String param) {
        return this.defaultValueMap.get(param);
    }

    final void setPreferredValue(String param, String preferredValue) {
        this.preferredValueMap.put(param, preferredValue);
    }

    public final String getPreferredValue(String param) {
        return this.preferredValueMap.get(param);
    }

    public final void setNew(boolean newResource) {
        this.newResource = newResource;
    }

    public final boolean isNew() {
        return this.newResource;
    }
}

