/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.function.Double27Function;
import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.function.DoubleProcedure;
import cern.colt.function.IntIntIntProcedure;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix2DProcedure;
import cern.colt.matrix.doublealgo.Formatter;
import cern.colt.matrix.doublealgo.Sorting;
import cern.colt.matrix.impl.AbstractMatrix3D;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Functions;

public abstract class DoubleMatrix3D
extends AbstractMatrix3D {
    protected DoubleMatrix3D() {
    }

    public double aggregate(DoubleDoubleFunction aggr, DoubleFunction f) {
        if (this.size() == 0) {
            return Double.NaN;
        }
        double a = f.apply(this.getQuick(this.slices - 1, this.rows - 1, this.columns - 1));
        int d = 1;
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns - d;
                while (--column >= 0) {
                    a = aggr.apply(a, f.apply(this.getQuick(slice, row, column)));
                }
                d = 0;
            }
        }
        return a;
    }

    public double aggregate(DoubleMatrix3D other, DoubleDoubleFunction aggr, DoubleDoubleFunction f) {
        this.checkShape(other);
        if (this.size() == 0) {
            return Double.NaN;
        }
        double a = f.apply(this.getQuick(this.slices - 1, this.rows - 1, this.columns - 1), other.getQuick(this.slices - 1, this.rows - 1, this.columns - 1));
        int d = 1;
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns - d;
                while (--column >= 0) {
                    a = aggr.apply(a, f.apply(this.getQuick(slice, row, column), other.getQuick(slice, row, column)));
                }
                d = 0;
            }
        }
        return a;
    }

    public DoubleMatrix3D assign(double[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        int slice = this.slices;
        while (--slice >= 0) {
            double[][] currentSlice = values[slice];
            if (currentSlice.length != this.rows) {
                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
            }
            int row = this.rows;
            while (--row >= 0) {
                double[] currentRow = currentSlice[row];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                }
                int column = this.columns;
                while (--column >= 0) {
                    this.setQuick(slice, row, column, currentRow[column]);
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(double value) {
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    this.setQuick(slice, row, column, value);
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(DoubleFunction function) {
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    this.setQuick(slice, row, column, function.apply(this.getQuick(slice, row, column)));
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(DoubleMatrix3D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.haveSharedCells(other)) {
            other = other.copy();
        }
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    this.setQuick(slice, row, column, other.getQuick(slice, row, column));
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(DoubleMatrix3D y, DoubleDoubleFunction function) {
        this.checkShape(y);
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    this.setQuick(slice, row, column, function.apply(this.getQuick(slice, row, column), y.getQuick(slice, row, column)));
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    if (this.getQuick(slice, row, column) == 0.0) continue;
                    ++cardinality;
                }
            }
        }
        return cardinality;
    }

    public DoubleMatrix3D copy() {
        return this.like().assign(this);
    }

    public boolean equals(double value) {
        return Property.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleMatrix3D)) {
            return false;
        }
        return Property.DEFAULT.equals(this, (DoubleMatrix3D)obj);
    }

    public double get(int slice, int row, int column) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        return this.getQuick(slice, row, column);
    }

    protected DoubleMatrix3D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int s = this.slices;
        int r = this.rows;
        int c = this.columns;
        for (int slice = 0; slice < s; ++slice) {
            for (int row = 0; row < r; ++row) {
                for (int column = 0; column < c; ++column) {
                    double value = this.getQuick(slice, row, column);
                    if (value == 0.0) continue;
                    sliceList.add(slice);
                    rowList.add(row);
                    columnList.add(column);
                    valueList.add(value);
                }
            }
        }
    }

    public abstract double getQuick(int var1, int var2, int var3);

    protected boolean haveSharedCells(DoubleMatrix3D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix3D other) {
        return false;
    }

    public DoubleMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract DoubleMatrix3D like(int var1, int var2, int var3);

    protected abstract DoubleMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    public void set(int slice, int row, int column, double value) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        this.setQuick(slice, row, column, value);
    }

    public abstract void setQuick(int var1, int var2, int var3, double var4);

    public double[][][] toArray() {
        double[][][] values = new double[this.slices][this.rows][this.columns];
        int slice = this.slices;
        while (--slice >= 0) {
            double[][] currentSlice = values[slice];
            int row = this.rows;
            while (--row >= 0) {
                double[] currentRow = currentSlice[row];
                int column = this.columns;
                while (--column >= 0) {
                    currentRow[column] = this.getQuick(slice, row, column);
                }
            }
        }
        return values;
    }

    public String toString() {
        return new Formatter().toString(this);
    }

    protected DoubleMatrix3D view() {
        return (DoubleMatrix3D)this.clone();
    }

    public DoubleMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        int sliceRows = this.slices;
        int sliceColumns = this.rows;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.rowZero + this._columnOffset(this._columnRank(column));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.rowStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public DoubleMatrix3D viewColumnFlip() {
        return (DoubleMatrix3D)this.view().vColumnFlip();
    }

    public DoubleMatrix3D viewDice(int axis0, int axis1, int axis2) {
        return (DoubleMatrix3D)this.view().vDice(axis0, axis1, axis2);
    }

    public DoubleMatrix3D viewPart(int slice, int row, int column, int depth, int height, int width) {
        return (DoubleMatrix3D)this.view().vPart(slice, row, column, depth, height, width);
    }

    public DoubleMatrix2D viewRow(int row) {
        this.checkRow(row);
        int sliceRows = this.slices;
        int sliceColumns = this.columns;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.columnZero + this._rowOffset(this._rowRank(row));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public DoubleMatrix3D viewRowFlip() {
        return (DoubleMatrix3D)this.view().vRowFlip();
    }

    public DoubleMatrix3D viewSelection(int[] sliceIndexes, int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (sliceIndexes == null) {
            sliceIndexes = new int[this.slices];
            i = this.slices;
            while (--i >= 0) {
                sliceIndexes[i] = i;
            }
        }
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkSliceIndexes(sliceIndexes);
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] sliceOffsets = new int[sliceIndexes.length];
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        int i2 = sliceIndexes.length;
        while (--i2 >= 0) {
            sliceOffsets[i2] = this._sliceOffset(this._sliceRank(sliceIndexes[i2]));
        }
        i2 = rowIndexes.length;
        while (--i2 >= 0) {
            rowOffsets[i2] = this._rowOffset(this._rowRank(rowIndexes[i2]));
        }
        i2 = columnIndexes.length;
        while (--i2 >= 0) {
            columnOffsets[i2] = this._columnOffset(this._columnRank(columnIndexes[i2]));
        }
        return this.viewSelectionLike(sliceOffsets, rowOffsets, columnOffsets);
    }

    public DoubleMatrix3D viewSelection(DoubleMatrix2DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < this.slices; ++i) {
            if (!condition.apply(this.viewSlice(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null, null);
    }

    protected abstract DoubleMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);

    public DoubleMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        int sliceRows = this.rows;
        int sliceColumns = this.columns;
        int sliceRowZero = this.rowZero;
        int sliceColumnZero = this.columnZero + this._sliceOffset(this._sliceRank(slice));
        int sliceRowStride = this.rowStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public DoubleMatrix3D viewSliceFlip() {
        return (DoubleMatrix3D)this.view().vSliceFlip();
    }

    public DoubleMatrix3D viewSorted(int row, int column) {
        return Sorting.mergeSort.sort(this, row, column);
    }

    public DoubleMatrix3D viewStrides(int sliceStride, int rowStride, int columnStride) {
        return (DoubleMatrix3D)this.view().vStrides(sliceStride, rowStride, columnStride);
    }

    private boolean xforEach(DoubleProcedure procedure) {
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    if (procedure.apply(this.getQuick(slice, row, column))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean xforEachCoordinate(IntIntIntProcedure procedure) {
        int column = this.columns;
        while (--column >= 0) {
            int slice = this.slices;
            while (--slice >= 0) {
                int row = this.rows;
                while (--row >= 0) {
                    if (procedure.apply(slice, row, column)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void zAssign27Neighbors(DoubleMatrix3D B, Double27Function function) {
        if (function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(B);
        if (this.rows < 3 || this.columns < 3 || this.slices < 3) {
            return;
        }
        int r = this.rows - 1;
        int c = this.columns - 1;
        for (int k = 1; k < this.slices - 1; ++k) {
            for (int i = 1; i < r; ++i) {
                double a000 = this.getQuick(k - 1, i - 1, 0);
                double a001 = this.getQuick(k - 1, i - 1, 1);
                double a010 = this.getQuick(k - 1, i, 0);
                double a011 = this.getQuick(k - 1, i, 1);
                double a020 = this.getQuick(k - 1, i + 1, 0);
                double a021 = this.getQuick(k - 1, i + 1, 1);
                double a100 = this.getQuick(k - 1, i - 1, 0);
                double a101 = this.getQuick(k, i - 1, 1);
                double a110 = this.getQuick(k, i, 0);
                double a111 = this.getQuick(k, i, 1);
                double a120 = this.getQuick(k, i + 1, 0);
                double a121 = this.getQuick(k, i + 1, 1);
                double a200 = this.getQuick(k + 1, i - 1, 0);
                double a201 = this.getQuick(k + 1, i - 1, 1);
                double a210 = this.getQuick(k + 1, i, 0);
                double a211 = this.getQuick(k + 1, i, 1);
                double a220 = this.getQuick(k + 1, i + 1, 0);
                double a221 = this.getQuick(k + 1, i + 1, 1);
                for (int j = 1; j < c; ++j) {
                    double a002 = this.getQuick(k - 1, i - 1, j + 1);
                    double a012 = this.getQuick(k - 1, i, j + 1);
                    double a022 = this.getQuick(k - 1, i + 1, j + 1);
                    double a102 = this.getQuick(k, i - 1, j + 1);
                    double a112 = this.getQuick(k, i, j + 1);
                    double a122 = this.getQuick(k, i + 1, j + 1);
                    double a202 = this.getQuick(k + 1, i - 1, j + 1);
                    double a212 = this.getQuick(k + 1, i, j + 1);
                    double a222 = this.getQuick(k + 1, i + 1, j + 1);
                    B.setQuick(k, i, j, function.apply(a000, a001, a002, a010, a011, a012, a020, a021, a022, a100, a101, a102, a110, a111, a112, a120, a121, a122, a200, a201, a202, a210, a211, a212, a220, a221, a222));
                    a000 = a001;
                    a001 = a002;
                    a010 = a011;
                    a011 = a012;
                    a020 = a021;
                    a021 = a022;
                    a100 = a101;
                    a101 = a102;
                    a110 = a111;
                    a111 = a112;
                    a120 = a121;
                    a121 = a122;
                    a200 = a201;
                    a201 = a202;
                    a210 = a211;
                    a211 = a212;
                    a220 = a221;
                    a221 = a222;
                }
            }
        }
    }

    public double zSum() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.aggregate(Functions.plus, Functions.identity);
    }
}

