/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.auth;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public final class ClientVersionInfo
implements LiveWritable {
    private static final int TYPE_VERSION_STRING = 3;
    private static final int TYPE_CLIENTID = 22;
    private static final int TYPE_MAJOR = 23;
    private static final int TYPE_MINOR = 24;
    private static final int TYPE_POINT = 25;
    private static final int TYPE_BUILD = 26;
    private static final int TYPE_DISTCODE = 20;
    private final String versionString;
    private final int clientid;
    private final int major;
    private final int minor;
    private final int point;
    private final int build;
    private final long distCode;

    public static ClientVersionInfo readClientVersionInfo(TlvChain chain) {
        DefensiveTools.checkNull(chain, "chain");
        String verString = chain.getString(3);
        int clientid = chain.getUShort(22);
        int major = chain.getUShort(23);
        int minor = chain.getUShort(24);
        int point = chain.getUShort(25);
        int build = chain.getUShort(26);
        long distCode = chain.getUInt(20);
        return new ClientVersionInfo(verString, clientid, major, minor, point, build, distCode);
    }

    public ClientVersionInfo(String versionString, int major, int minor, int point, int build, long distCode) {
        this(versionString, -1, major, minor, point, build, distCode);
    }

    public ClientVersionInfo(String versionString, int clientid, int major, int minor, int point, int build, long distCode) {
        DefensiveTools.checkRange(major, "major", -1);
        DefensiveTools.checkRange(clientid, "clientid", -1);
        DefensiveTools.checkRange(minor, "minor", -1);
        DefensiveTools.checkRange(point, "point", -1);
        DefensiveTools.checkRange(build, "build", -1);
        DefensiveTools.checkRange(distCode, "distCode", -1L);
        this.versionString = versionString;
        this.clientid = clientid;
        this.major = major;
        this.minor = minor;
        this.point = point;
        this.build = build;
        this.distCode = distCode;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public int getClientid() {
        return this.clientid;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPoint() {
        return this.point;
    }

    public int getBuild() {
        return this.build;
    }

    public long getDistCode() {
        return this.distCode;
    }

    public void write(OutputStream out) throws IOException {
        if (this.versionString != null) {
            Tlv.getStringInstance(3, this.versionString).write(out);
        }
        if (this.clientid != -1) {
            Tlv.getUShortInstance(22, this.clientid).write(out);
        }
        if (this.major != -1) {
            Tlv.getUShortInstance(23, this.major).write(out);
        }
        if (this.minor != -1) {
            Tlv.getUShortInstance(24, this.minor).write(out);
        }
        if (this.point != -1) {
            Tlv.getUShortInstance(25, this.point).write(out);
        }
        if (this.build != -1) {
            Tlv.getUShortInstance(26, this.build).write(out);
        }
        if (this.distCode != -1L) {
            Tlv.getUIntInstance(20, this.distCode).write(out);
        }
    }

    public String toString() {
        return "ClientVersionInfo: , versionString='" + this.versionString + "'" + ", clientid=" + this.clientid + ", major=" + this.major + ", minor=" + this.minor + ", point=" + this.point + ", build=" + this.build + ", distCode=" + this.distCode;
    }
}

