/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.security;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sip.header.AuthorizationHeader;
import net.java.sip.communicator.impl.protocol.sip.security.CredentialsCacheEntry;

class CredentialsCache {
    private Hashtable<String, CredentialsCacheEntry> authenticatedRealms = new Hashtable();
    private Hashtable<String, AuthorizationHeader> authenticatedCalls = new Hashtable();

    CredentialsCache() {
    }

    void cacheEntry(String realm, CredentialsCacheEntry cacheEntry) {
        this.authenticatedRealms.put(realm, cacheEntry);
    }

    CredentialsCacheEntry get(String realm) {
        return this.authenticatedRealms.get(realm);
    }

    List<String> getRealms(String branchID) {
        LinkedList<String> realms = new LinkedList<String>();
        for (Map.Entry<String, CredentialsCacheEntry> entry : this.authenticatedRealms.entrySet()) {
            if (!entry.getValue().containsBranchID(branchID)) continue;
            realms.add(entry.getKey());
        }
        return realms;
    }

    CredentialsCacheEntry remove(String realm) {
        return this.authenticatedRealms.remove(realm);
    }

    void clear() {
        this.authenticatedRealms.clear();
    }

    void cacheAuthorizationHeader(String callid, AuthorizationHeader authorization) {
        this.authenticatedCalls.put(callid, authorization);
    }

    AuthorizationHeader getCachedAuthorizationHeader(String callid) {
        return this.authenticatedCalls.get(callid);
    }
}

