/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util.concurrent;

import org.jitsi.util.concurrent.RecurringRunnable;

public abstract class PeriodicRunnable
implements RecurringRunnable {
    private long _lastProcessTime = System.currentTimeMillis();
    private final long _period;

    public PeriodicRunnable(long period) {
        if (period < 1L) {
            throw new IllegalArgumentException("period " + period);
        }
        this._period = period;
    }

    public final long getLastProcessTime() {
        return this._lastProcessTime;
    }

    public final long getPeriod() {
        return this._period;
    }

    @Override
    public long getTimeUntilNextRun() {
        long timeSinceLastProcess = Math.max(System.currentTimeMillis() - this._lastProcessTime, 0L);
        return Math.max(this.getPeriod() - timeSinceLastProcess, 0L);
    }

    @Override
    public void run() {
        this._lastProcessTime = System.currentTimeMillis();
    }
}

