/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.update;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommFrame;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.update.Resources;
import net.java.sip.communicator.plugin.update.UpdateActivator;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.httputil.HttpUtils;
import net.java.sip.communicator.service.update.UpdateService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.service.version.Version;
import org.jitsi.service.version.VersionService;
import org.jitsi.util.OSUtils;
import org.osgi.framework.BundleContext;

public class UpdateServiceImpl
implements UpdateService {
    private static String changesLink;
    private static JDialog checkForUpdatesDialog;
    private static String downloadLink;
    private static int inCheckForUpdates;
    private static String latestVersion;
    private static final Logger logger;
    private static final String PROP_UPDATE_LINK = "net.java.sip.communicator.UPDATE_LINK";

    private static Component createBrowser(String url) {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setContentType("text/html");
        editorPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(editorPane);
        try {
            Document document = editorPane.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).setAsynchronousLoadPriority(0);
            }
            editorPane.setPage(new URL(url));
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)("Failed to navigate the Web browser to: " + url), t);
        }
        return scrollPane;
    }

    private static FileOutputStream createTempFileOutputStream(URL url, String extension, boolean dryRun, File[] tempFile) throws IOException {
        String path = url.getPath();
        File tf = null;
        FileOutputStream tfos = null;
        if (path != null && path.length() != 0) {
            int nameLength;
            String name;
            int nameBeginIndex = path.lastIndexOf(47);
            if (nameBeginIndex > 0) {
                name = path.substring(nameBeginIndex + 1);
                if ((nameBeginIndex = name.lastIndexOf(92)) > 0) {
                    name = name.substring(nameBeginIndex + 1);
                }
            } else {
                name = path;
            }
            if ((nameLength = name.length()) != 0) {
                int baseNameEnd = name.lastIndexOf(46);
                if (extension == null) {
                    extension = ".exe";
                }
                if (baseNameEnd == -1) {
                    name = name + extension;
                } else if (baseNameEnd == 0) {
                    if (!extension.equalsIgnoreCase(name)) {
                        name = name + extension;
                    }
                } else {
                    name = name.substring(0, baseNameEnd) + extension;
                }
                try {
                    String tempDir = System.getProperty("java.io.tmpdir");
                    if (tempDir != null && tempDir.length() != 0) {
                        tf = new File(tempDir, name);
                        if (!dryRun) {
                            tfos = new FileOutputStream(tf);
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        if (tfos == null && !dryRun) {
            tf = File.createTempFile("setup", ".exe");
            tfos = new FileOutputStream(tf);
        }
        tempFile[0] = tf;
        return tfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File download(String url) throws IOException {
        File[] tempFile;
        block21: {
            tempFile = new File[1];
            FileOutputStream tempFileOutputStream = null;
            boolean deleteTempFile = true;
            tempFileOutputStream = UpdateServiceImpl.createTempFileOutputStream(new URL(url), null, false, tempFile);
            try {
                HttpUtils.HTTPResponseResult res = HttpUtils.openURLConnection((String)url);
                if (res == null) break block21;
                InputStream content = res.getContent();
                ProgressMonitorInputStream input = new ProgressMonitorInputStream(null, url, content);
                input.getProgressMonitor().setMaximum((int)res.getContentLength());
                try {
                    BufferedOutputStream output = new BufferedOutputStream(tempFileOutputStream);
                    try {
                        int read = -1;
                        byte[] buff = new byte[1024];
                        while ((read = input.read(buff)) != -1) {
                            output.write(buff, 0, read);
                        }
                    }
                    finally {
                        output.close();
                        tempFileOutputStream = null;
                    }
                    deleteTempFile = false;
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    if (tempFileOutputStream != null) {
                        tempFileOutputStream.close();
                    }
                }
                finally {
                    if (deleteTempFile && tempFile[0] != null) {
                        tempFile[0].delete();
                        tempFile[0] = null;
                    }
                }
            }
        }
        return tempFile[0];
    }

    private static synchronized void enterCheckForUpdates(JDialog checkForUpdatesDialog) {
        ++inCheckForUpdates;
        if (checkForUpdatesDialog != null) {
            UpdateServiceImpl.checkForUpdatesDialog = checkForUpdatesDialog;
        }
    }

    private static synchronized void exitCheckForUpdates(JDialog checkForUpdatesDialog) {
        if (inCheckForUpdates == 0) {
            throw new IllegalStateException("inCheckForUpdates");
        }
        --inCheckForUpdates;
        if (checkForUpdatesDialog != null && UpdateServiceImpl.checkForUpdatesDialog == checkForUpdatesDialog) {
            UpdateServiceImpl.checkForUpdatesDialog = null;
        }
    }

    private static Version getCurrentVersion() {
        return UpdateServiceImpl.getVersionService().getCurrentVersion();
    }

    private static VersionService getVersionService() {
        return (VersionService)ServiceUtils.getService((BundleContext)UpdateActivator.bundleContext, VersionService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isLatestVersion() {
        block19: {
            try {
                String updateLink = UpdateActivator.getConfiguration().getString(PROP_UPDATE_LINK);
                if (updateLink == null) {
                    updateLink = Resources.getUpdateConfigurationString("update_link");
                }
                if (updateLink == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Updates are disabled, faking latest version.");
                    }
                    break block19;
                }
                HttpUtils.HTTPResponseResult res = HttpUtils.openURLConnection((String)updateLink);
                if (res == null) break block19;
                Properties props = new Properties();
                try (InputStream in = null;){
                    in = res.getContent();
                    props.load(in);
                }
                latestVersion = props.getProperty("last_version");
                downloadLink = props.getProperty("download_link");
                if (downloadLink != null) {
                    if (OSUtils.IS_LINUX32) {
                        downloadLink = downloadLink.replace("amd64", "i386");
                    } else if (OSUtils.IS_LINUX64) {
                        downloadLink = downloadLink.replace("i386", "amd64");
                    } else if (OSUtils.IS_WINDOWS32) {
                        downloadLink = downloadLink.replace("x64", "x86");
                    } else if (OSUtils.IS_WINDOWS64) {
                        downloadLink = downloadLink.replace("x86", "x64");
                    }
                }
                changesLink = updateLink.substring(0, updateLink.lastIndexOf("/") + 1) + props.getProperty("changes_html");
                try {
                    VersionService versionService = UpdateServiceImpl.getVersionService();
                    Version latestVersionObj = versionService.parseVersionString(latestVersion);
                    if (latestVersionObj != null) {
                        return latestVersionObj.compareTo(UpdateServiceImpl.getCurrentVersion()) <= 0;
                    }
                    logger.error((Object)("Version obj not parsed(" + latestVersion + ")"));
                }
                catch (Throwable t) {
                    logger.error((Object)"Error parsing version string", t);
                }
                return latestVersion.compareTo(UpdateServiceImpl.getCurrentVersion().toString()) <= 0;
            }
            catch (Exception e) {
                logger.warn((Object)"Could not retrieve latest version or compare it to current version", (Throwable)e);
            }
        }
        return true;
    }

    private static void runInCheckForUpdatesThread(boolean notifyAboutNewestVersion) {
        if (UpdateServiceImpl.isLatestVersion()) {
            if (notifyAboutNewestVersion) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UIService ui = UpdateActivator.getUIService();
                        ResourceManagementService r = Resources.getResources();
                        ui.getPopupDialog().showMessagePopupDialog((Object)r.getI18NString("plugin.updatechecker.DIALOG_NOUPDATE"), r.getI18NString("plugin.updatechecker.DIALOG_NOUPDATE_TITLE"), 1);
                    }
                });
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (OSUtils.IS_WINDOWS) {
                        UpdateServiceImpl.showWindowsNewVersionAvailableDialog();
                    } else {
                        UpdateServiceImpl.showGenericNewVersionAvailableDialog();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showGenericNewVersionAvailableDialog() {
        final boolean[] exitCheckForUpdates = new boolean[]{false};
        SIPCommDialog dialog = new SIPCommDialog(){
            private static final long serialVersionUID = 0L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void close(boolean escaped) {
                boolean[] blArray = exitCheckForUpdates;
                synchronized (exitCheckForUpdates) {
                    if (exitCheckForUpdates[0]) {
                        UpdateServiceImpl.exitCheckForUpdates((JDialog)((Object)this));
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        ResourceManagementService resources = Resources.getResources();
        dialog.setTitle(resources.getI18NString("plugin.updatechecker.DIALOG_TITLE"));
        JEditorPane contentMessage = new JEditorPane();
        contentMessage.setContentType("text/html");
        contentMessage.setOpaque(false);
        contentMessage.setEditable(false);
        String dialogMsg = resources.getI18NString("plugin.updatechecker.DIALOG_MESSAGE", new String[]{resources.getSettingsString("service.gui.APPLICATION_NAME")});
        if (latestVersion != null) {
            dialogMsg = dialogMsg + resources.getI18NString("plugin.updatechecker.DIALOG_MESSAGE_2", new String[]{resources.getSettingsString("service.gui.APPLICATION_NAME"), latestVersion});
        }
        contentMessage.setText(dialogMsg);
        TransparentPanel contentPane = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.add((Component)contentMessage, "Center");
        TransparentPanel buttonPanel = new TransparentPanel((LayoutManager)new FlowLayout(1, 10, 10));
        final JButton closeButton = new JButton(resources.getI18NString("plugin.updatechecker.BUTTON_CLOSE"));
        closeButton.addActionListener(new ActionListener((JDialog)dialog, exitCheckForUpdates){
            final /* synthetic */ JDialog val$dialog;
            final /* synthetic */ boolean[] val$exitCheckForUpdates;
            {
                this.val$dialog = jDialog;
                this.val$exitCheckForUpdates = blArray;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$dialog.dispose();
                if (this.val$exitCheckForUpdates[0]) {
                    UpdateServiceImpl.exitCheckForUpdates(this.val$dialog);
                }
            }
        });
        if (downloadLink != null) {
            JButton downloadButton = new JButton(resources.getI18NString("plugin.updatechecker.BUTTON_DOWNLOAD"));
            downloadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdateActivator.getBrowserLauncher().openURL(downloadLink);
                    closeButton.doClick();
                }
            });
            buttonPanel.add(downloadButton);
        }
        buttonPanel.add(closeButton);
        contentPane.add((Component)buttonPanel, "South");
        dialog.setContentPane((Container)contentPane);
        dialog.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation(screenSize.width / 2 - dialog.getWidth() / 2, screenSize.height / 2 - dialog.getHeight() / 2);
        boolean[] blArray = exitCheckForUpdates;
        synchronized (exitCheckForUpdates) {
            UpdateServiceImpl.enterCheckForUpdates((JDialog)dialog);
            exitCheckForUpdates[0] = true;
            // ** MonitorExit[var9_9] (shouldn't be in output)
            try {
                dialog.setVisible(true);
            }
            finally {
                blArray = exitCheckForUpdates;
                synchronized (exitCheckForUpdates) {
                    if (exitCheckForUpdates[0] && dialog.isModal()) {
                        UpdateServiceImpl.exitCheckForUpdates((JDialog)dialog);
                    }
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showWindowsNewVersionAvailableDialog() {
        final boolean[] exitCheckForUpdates = new boolean[]{false};
        SIPCommDialog dialog = new SIPCommDialog(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void close(boolean escaped) {
                boolean[] blArray = exitCheckForUpdates;
                synchronized (exitCheckForUpdates) {
                    if (exitCheckForUpdates[0]) {
                        UpdateServiceImpl.exitCheckForUpdates((JDialog)((Object)this));
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        ResourceManagementService r = Resources.getResources();
        dialog.setTitle(r.getI18NString("plugin.updatechecker.DIALOG_TITLE"));
        JEditorPane contentMessage = new JEditorPane();
        contentMessage.setContentType("text/html");
        contentMessage.setOpaque(false);
        contentMessage.setEditable(false);
        contentMessage.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        String dialogMsg = r.getI18NString("plugin.updatechecker.DIALOG_MESSAGE", new String[]{r.getSettingsString("service.gui.APPLICATION_NAME")});
        if (latestVersion != null) {
            dialogMsg = dialogMsg + r.getI18NString("plugin.updatechecker.DIALOG_MESSAGE_2", new String[]{r.getSettingsString("service.gui.APPLICATION_NAME"), latestVersion});
        }
        contentMessage.setText(dialogMsg);
        SIPCommFrame.MainContentPane contentPane = new SIPCommFrame.MainContentPane();
        contentMessage.setBorder(BorderFactory.createEmptyBorder(10, 0, 20, 0));
        contentPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        contentPane.add((Component)contentMessage, "North");
        Component browser = UpdateServiceImpl.createBrowser(changesLink);
        if (browser != null) {
            browser.setPreferredSize(new Dimension(550, 200));
            contentPane.add(browser, "Center");
        }
        TransparentPanel buttonPanel = new TransparentPanel((LayoutManager)new FlowLayout(1, 10, 10));
        final JButton closeButton = new JButton(r.getI18NString("plugin.updatechecker.BUTTON_CLOSE"));
        closeButton.addActionListener(new ActionListener((JDialog)dialog, exitCheckForUpdates){
            final /* synthetic */ JDialog val$dialog;
            final /* synthetic */ boolean[] val$exitCheckForUpdates;
            {
                this.val$dialog = jDialog;
                this.val$exitCheckForUpdates = blArray;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$dialog.dispose();
                if (this.val$exitCheckForUpdates[0]) {
                    UpdateServiceImpl.exitCheckForUpdates(this.val$dialog);
                }
            }
        });
        if (downloadLink != null) {
            JButton installButton = new JButton(r.getI18NString("plugin.updatechecker.BUTTON_INSTALL"));
            installButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean windowsUpdateThreadHasStarted;
                    UpdateServiceImpl.enterCheckForUpdates(null);
                    try {
                        closeButton.doClick();
                        windowsUpdateThreadHasStarted = false;
                    }
                    catch (Throwable throwable) {
                        boolean windowsUpdateThreadHasStarted2 = false;
                        try {
                            new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        UpdateServiceImpl.windowsUpdate();
                                    }
                                    finally {
                                        UpdateServiceImpl.exitCheckForUpdates(null);
                                    }
                                }
                            }.start();
                            windowsUpdateThreadHasStarted2 = true;
                        }
                        finally {
                            if (!windowsUpdateThreadHasStarted2) {
                                UpdateServiceImpl.exitCheckForUpdates(null);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        new /* invalid duplicate definition of identical inner class */.start();
                        windowsUpdateThreadHasStarted = true;
                    }
                    finally {
                        if (!windowsUpdateThreadHasStarted) {
                            UpdateServiceImpl.exitCheckForUpdates(null);
                        }
                    }
                }
            });
            buttonPanel.add(installButton);
        }
        buttonPanel.add(closeButton);
        contentPane.add((Component)buttonPanel, "South");
        dialog.setContentPane((Container)contentPane);
        dialog.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation(screenSize.width / 2 - dialog.getWidth() / 2, screenSize.height / 2 - dialog.getHeight() / 2);
        boolean[] blArray = exitCheckForUpdates;
        synchronized (exitCheckForUpdates) {
            UpdateServiceImpl.enterCheckForUpdates((JDialog)dialog);
            exitCheckForUpdates[0] = true;
            // ** MonitorExit[var10_10] (shouldn't be in output)
            try {
                dialog.setVisible(true);
            }
            finally {
                blArray = exitCheckForUpdates;
                synchronized (exitCheckForUpdates) {
                    if (exitCheckForUpdates[0] && dialog.isModal()) {
                        UpdateServiceImpl.exitCheckForUpdates((JDialog)dialog);
                    }
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void windowsUpdate() {
        File delta = null;
        boolean deleteDelta = true;
        File msi = null;
        try {
            String deltaTarget = null;
            Version ver = UpdateServiceImpl.getCurrentVersion();
            deltaTarget = ver.isNightly() ? ver.getNightlyBuildID() : ver.toString();
            String deltaLink = downloadLink.replace(latestVersion, latestVersion + "-delta-" + deltaTarget);
            if (!deltaLink.equalsIgnoreCase(downloadLink)) {
                delta = UpdateServiceImpl.download(deltaLink);
            }
            if (delta != null) {
                File[] deltaMsi = new File[1];
                UpdateServiceImpl.createTempFileOutputStream(delta.toURI().toURL(), ".msi", true, deltaMsi);
                Process process = new ProcessBuilder(delta.getCanonicalPath(), "--quiet", deltaMsi[0].getCanonicalPath()).start();
                int exitCode = 1;
                while (true) {
                    try {
                        exitCode = process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                if (0 == exitCode) {
                    deleteDelta = false;
                    msi = deltaMsi[0];
                }
            }
        }
        catch (Exception deltaTarget) {
        }
        finally {
            if (deleteDelta && delta != null) {
                delta.delete();
                delta = null;
            }
        }
        boolean deleteMsi = true;
        deleteDelta = true;
        try {
            if (msi == null) {
                msi = UpdateServiceImpl.download(downloadLink);
            }
            if (msi != null) {
                ResourceManagementService resources = Resources.getResources();
                if (UpdateActivator.getUIService().getPopupDialog().showConfirmPopupDialog((Object)resources.getI18NString("plugin.updatechecker.DIALOG_WARN", new String[]{resources.getSettingsString("service.gui.APPLICATION_NAME")}), resources.getI18NString("plugin.updatechecker.DIALOG_TITLE"), 0, 3) == 0) {
                    ArrayList<String> command = new ArrayList<String>();
                    command.add((delta == null ? msi : delta).getCanonicalPath());
                    command.add("--wait-parent");
                    if (delta != null) {
                        command.add("--msiexec");
                        command.add(msi.getCanonicalPath());
                    }
                    command.add("SIP_COMMUNICATOR_AUTOUPDATE_INSTALLDIR=\"" + System.getProperty("user.dir") + "\"");
                    deleteMsi = false;
                    deleteDelta = false;
                    new ProcessBuilder(command).start();
                    UpdateActivator.getShutdownService().beginShutdown();
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            ResourceManagementService resources = Resources.getResources();
            UpdateActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)resources.getI18NString("plugin.updatechecker.DIALOG_MISSING_UPDATE"), resources.getI18NString("plugin.updatechecker.DIALOG_NOUPDATE_TITLE"), 1);
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Could not update", (Throwable)e);
            }
        }
        finally {
            if (deleteMsi && msi != null) {
                msi.delete();
                msi = null;
            }
            if (deleteDelta && delta != null) {
                delta.delete();
                delta = null;
            }
        }
    }

    public synchronized void checkForUpdates(final boolean notifyAboutNewestVersion) {
        if (inCheckForUpdates > 0) {
            if (checkForUpdatesDialog != null) {
                checkForUpdatesDialog.toFront();
            }
            return;
        }
        Thread checkForUpdatesThread = new Thread(){

            @Override
            public void run() {
                try {
                    UpdateServiceImpl.runInCheckForUpdatesThread(notifyAboutNewestVersion);
                }
                finally {
                    UpdateServiceImpl.exitCheckForUpdates(null);
                }
            }
        };
        checkForUpdatesThread.setDaemon(true);
        checkForUpdatesThread.setName(this.getClass().getName() + ".checkForUpdates");
        UpdateServiceImpl.enterCheckForUpdates(null);
        try {
            checkForUpdatesThread.start();
            checkForUpdatesThread = null;
        }
        finally {
            if (checkForUpdatesThread != null) {
                UpdateServiceImpl.exitCheckForUpdates(null);
            }
        }
    }

    static {
        inCheckForUpdates = 0;
        logger = Logger.getLogger(UpdateServiceImpl.class);
    }
}

