/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.pluginmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.java.sip.communicator.plugin.desktoputil.GenericFileDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileChooser;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.pluginmanager.PluginManagerActivator;
import net.java.sip.communicator.plugin.pluginmanager.Resources;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleException;

public class NewBundleDialog
extends SIPCommDialog
implements ActionListener {
    private Logger logger = Logger.getLogger(NewBundleDialog.class);
    private static final long serialVersionUID = 7638976584338100969L;
    private JButton installButton = new JButton(Resources.getString("plugin.pluginmanager.INSTALL"));
    private JButton cancelButton = new JButton(Resources.getString("service.gui.CANCEL"));
    private JTextField bundlePathField = new JTextField();
    private JLabel bundlePathLabel = new JLabel(Resources.getString("plugin.pluginmanager.URL") + ": ");
    private JPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
    private JPanel dataPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
    private JPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private JButton fileChooserButton = new JButton(Resources.getString("plugin.pluginmanager.CHOOSE_FILE"));

    public NewBundleDialog() {
        this.mainPanel.setPreferredSize(new Dimension(450, 150));
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.mainPanel.add((Component)this.dataPanel, "North");
        this.mainPanel.add((Component)this.buttonsPanel, "South");
        this.buttonsPanel.add(this.installButton);
        this.buttonsPanel.add(this.cancelButton);
        this.installButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.fileChooserButton.addActionListener(this);
        this.fileChooserButton.setOpaque(false);
        this.dataPanel.add((Component)this.bundlePathLabel, "West");
        this.dataPanel.add((Component)this.bundlePathField, "Center");
        this.dataPanel.add((Component)this.fileChooserButton, "East");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        JButton sourceButton = (JButton)e.getSource();
        if (sourceButton.equals(this.installButton)) {
            if (this.bundlePathField.getText().length() > 0) {
                try {
                    PluginManagerActivator.bundleContext.installBundle(this.bundlePathField.getText());
                }
                catch (BundleException ex) {
                    this.logger.info((Object)"Failed to install bundle.", (Throwable)ex);
                    PluginManagerActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)ex.getMessage(), "Error", 0);
                }
                catch (Throwable ex) {
                    this.logger.info((Object)"Failed to install bundle.", ex);
                }
                finally {
                    this.dispose();
                }
            }
        } else if (sourceButton.equals(this.fileChooserButton)) {
            SipCommFileChooser chooser = GenericFileDialog.create(null, (String)"New bundle...", (int)0);
            File newBundleFile = chooser.getFileFromDialog();
            if (newBundleFile != null) {
                try {
                    this.bundlePathField.setText(newBundleFile.toURI().toURL().toString());
                }
                catch (MalformedURLException ex) {
                    this.logger.info((Object)"Failed parse URL.", (Throwable)ex);
                }
            }
        } else {
            this.dispose();
        }
    }

    protected void close(boolean isEscaped) {
        this.cancelButton.doClick();
    }
}

