/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.menus;

import java.awt.Component;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.event.PluginComponentEvent;
import net.java.sip.communicator.impl.gui.event.PluginComponentListener;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ViewMenu
extends SIPCommMenu
implements PluginComponentListener {
    private static final long serialVersionUID = 0L;
    private final Logger logger = Logger.getLogger(ViewMenu.class);

    public ViewMenu(MainFrame mainFrame) {
        super(GuiActivator.getResources().getI18NString("service.gui.VIEW"));
        this.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.VIEW"));
        this.initPluginComponents();
    }

    private void initPluginComponents() {
        ServiceReference[] serRefs = null;
        String osgiFilter = "(CONTAINER_ID=" + Container.CONTAINER_VIEW_MENU.getID() + ")";
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(PluginComponentFactory.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException exc) {
            this.logger.error((Object)"Could not obtain plugin reference.", (Throwable)exc);
        }
        if (serRefs != null) {
            for (ServiceReference serRef : serRefs) {
                final PluginComponentFactory f = (PluginComponentFactory)GuiActivator.bundleContext.getService(serRef);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ViewMenu.this.add((Component)f.getPluginComponentInstance((Object)ViewMenu.this).getComponent());
                    }
                });
            }
        }
        GuiActivator.getUIService().addPluginComponentListener(this);
    }

    @Override
    public void pluginComponentAdded(PluginComponentEvent event) {
        PluginComponentFactory c = event.getPluginComponentFactory();
        if (c.getContainer().equals((Object)Container.CONTAINER_VIEW_MENU)) {
            this.add((Component)c.getPluginComponentInstance((Object)this).getComponent());
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void pluginComponentRemoved(PluginComponentEvent event) {
        PluginComponentFactory c = event.getPluginComponentFactory();
        if (c.getContainer().equals((Object)Container.CONTAINER_VIEW_MENU)) {
            this.remove((Component)c.getPluginComponentInstance((Object)this).getComponent());
        }
    }
}

