/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.contactlist.AddContactDialog;
import net.java.sip.communicator.impl.gui.utils.SMSManager;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.event.TextFieldChangeListener;
import net.java.sip.communicator.service.protocol.OperationSetSmsMessaging;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.util.StringUtils;

public class UnknownContactPanel
extends TransparentPanel
implements TextFieldChangeListener,
Skinnable {
    private final JButton addButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.ADD_CONTACT"));
    private final JButton callButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CALL_CONTACT"));
    private JButton smsButton;
    private final JTextPane textArea = new JTextPane();
    private final TransparentPanel buttonPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
    private MainFrame parentWindow;

    public UnknownContactPanel() {
    }

    public UnknownContactPanel(MainFrame window) {
        super((LayoutManager)new BorderLayout());
        this.parentWindow = window;
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        this.add((Component)mainPanel, "North");
        if (!ConfigurationUtils.isAddContactDisabled()) {
            this.initAddContactButton();
        }
        this.initCallButton();
        this.initSMSButton();
        this.initTextArea();
        mainPanel.add((Component)this.textArea, (Object)"Center");
        if (this.callButton.getParent() != null) {
            this.textArea.setText(GuiActivator.getResources().getI18NString("service.gui.NO_CONTACTS_FOUND", new String[]{'\"' + this.parentWindow.getCurrentSearchText() + '\"'}));
        } else {
            this.textArea.setText(GuiActivator.getResources().getI18NString("service.gui.NO_CONTACTS_FOUND_SHORT"));
        }
        if (this.buttonPanel.getComponentCount() > 0) {
            TransparentPanel southPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
            southPanel.add((Component)this.buttonPanel);
            mainPanel.add((Component)southPanel, (Object)"South");
        }
        this.loadSkin();
    }

    private void initAddContactButton() {
        this.addButton.setAlignmentX(0.5f);
        this.addButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.ADD_CONTACT"));
        this.buttonPanel.add((Component)this.addButton);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddContactDialog dialog = new AddContactDialog((Frame)((Object)UnknownContactPanel.this.parentWindow));
                dialog.setContactAddress(UnknownContactPanel.this.parentWindow.getCurrentSearchText());
                dialog.setVisible(true);
            }
        });
    }

    private void initCallButton() {
        List<ProtocolProviderService> telephonyProviders = CallManager.getTelephonyProviders();
        if (telephonyProviders != null && telephonyProviders.size() > 0) {
            if (this.callButton.getParent() != null) {
                return;
            }
            this.callButton.setAlignmentX(0.5f);
            this.callButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CALL_CONTACT"));
            this.buttonPanel.add((Component)this.callButton);
            this.callButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String searchText = UnknownContactPanel.this.parentWindow.getCurrentSearchText();
                    if (searchText == null) {
                        return;
                    }
                    CallManager.createCall(searchText, UnknownContactPanel.this.callButton);
                }
            });
        } else {
            this.buttonPanel.remove((Component)this.callButton);
        }
    }

    private void initSMSButton() {
        if (this.parentWindow.hasOperationSet(OperationSetSmsMessaging.class) && !StringUtils.containsLetters((String)this.parentWindow.getCurrentSearchText())) {
            if (this.smsButton != null && this.smsButton.getParent() != null) {
                return;
            }
            this.smsButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.SEND_SMS"));
            this.smsButton.setIcon(GuiActivator.getResources().getImage("service.gui.icons.SMS_BUTTON_ICON"));
            this.buttonPanel.add((Component)this.smsButton);
            this.smsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String searchText = UnknownContactPanel.this.parentWindow.getCurrentSearchText();
                    if (searchText == null) {
                        return;
                    }
                    SMSManager.sendSMS(UnknownContactPanel.this.smsButton, searchText);
                }
            });
        } else if (this.smsButton != null) {
            this.buttonPanel.remove((Component)this.smsButton);
        }
    }

    public void startCall() {
        this.callButton.doClick();
    }

    public void addUnknownContact() {
        this.addButton.doClick();
    }

    public void textInserted() {
        this.updateTextArea(this.parentWindow.getCurrentSearchText());
    }

    public void textRemoved() {
        this.updateTextArea(this.parentWindow.getCurrentSearchText());
    }

    private void initTextArea() {
        this.textArea.setOpaque(false);
        this.textArea.setEditable(false);
        StyledDocument doc = this.textArea.getStyledDocument();
        SimpleAttributeSet standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(standard, 1);
        StyleConstants.setFontFamily(standard, this.textArea.getFont().getFamily());
        StyleConstants.setFontSize(standard, 12);
        doc.setParagraphAttributes(0, 0, standard, true);
        this.parentWindow.addSearchFieldListener(this);
    }

    private void updateTextArea(String searchText) {
        if (this.callButton.getParent() != null) {
            this.textArea.setText(GuiActivator.getResources().getI18NString("service.gui.NO_CONTACTS_FOUND", new String[]{'\"' + searchText + '\"'}));
            this.revalidate();
            this.repaint();
        }
    }

    public void loadSkin() {
        this.addButton.setIcon(GuiActivator.getResources().getImage("service.gui.icons.ADD_CONTACT_16x16_ICON"));
        this.callButton.setIcon(GuiActivator.getResources().getImage("service.gui.icons.CALL_16x16_ICON"));
        if (this.smsButton != null) {
            this.smsButton.setIcon(GuiActivator.getResources().getImage("service.gui.icons.SMS_BUTTON_ICON"));
        }
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.initCallButton();
            this.initSMSButton();
        }
        super.setVisible(isVisible);
    }
}

