/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.toolBars;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatChangeListener;
import net.java.sip.communicator.impl.gui.main.chat.ChatContainer;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.history.HistoryWindow;
import net.java.sip.communicator.impl.gui.main.chat.history.HistoryWindowManager;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.MessageDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.filehistory.FileHistoryService;
import net.java.sip.communicator.service.gui.ChatLinkClickedListener;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleContext;

public class HistorySelectorBox
extends SIPCommMenu
implements ActionListener,
PropertyChangeListener,
ChatChangeListener,
ChatLinkClickedListener,
Skinnable {
    private Logger logger = Logger.getLogger(HistorySelectorBox.class);
    private JPopupMenu popupMenu;
    private JCheckBoxMenuItem toggleHistoryPerContact;
    private JCheckBoxMenuItem toggleAllHistory;
    private JMenuItem eraseHistoryPerContact;
    private ChatContainer chatContainer;

    public HistorySelectorBox(ChatContainer chatContainer) {
        this.chatContainer = chatContainer;
        this.setOpaque(false);
        this.popupMenu = this.getPopupMenu();
        this.popupMenu.setBackground(Color.WHITE);
        this.init();
        this.loadSkin();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MessageDialog dialog;
        String menuItemName = ((JMenuItem)e.getSource()).getName();
        ChatPanel chatPanel = this.chatContainer.getCurrentChat();
        if (menuItemName.equals("history")) {
            ChatSession chatSession;
            HistoryWindowManager historyWindowManager = GuiActivator.getUIService().getHistoryWindowManager();
            if (historyWindowManager.containsHistoryWindowForContact((chatSession = chatPanel.getChatSession()).getDescriptor())) {
                HistoryWindow history = historyWindowManager.getHistoryWindowForContact(chatSession.getDescriptor());
                if (history.getState() == 1) {
                    history.setState(0);
                }
                history.toFront();
            } else {
                HistoryWindow history = new HistoryWindow(chatPanel.getChatSession().getDescriptor());
                history.setVisible(true);
                historyWindowManager.addHistoryWindowForContact(chatSession.getDescriptor(), history);
            }
        } else if (menuItemName.equals("toggleAllHistory")) {
            boolean isHistoryEnabled = GuiActivator.getMessageHistoryService().isHistoryLoggingEnabled();
            GuiActivator.getMessageHistoryService().setHistoryLoggingEnabled(!isHistoryEnabled);
        } else if (menuItemName.equals("toggleHistoryPerContact")) {
            Object desc = chatPanel.getChatSession().getDescriptor();
            if (desc instanceof MetaContact) {
                MetaContact currentContact = (MetaContact)desc;
                boolean isHistoryEnabled = GuiActivator.getMessageHistoryService().isHistoryLoggingEnabled(currentContact.getMetaUID());
                GuiActivator.getMessageHistoryService().setHistoryLoggingEnabled(!isHistoryEnabled, currentContact.getMetaUID());
            } else if (desc instanceof ChatRoomWrapper) {
                ChatRoom currentChatRoom = ((ChatRoomWrapper)desc).getChatRoom();
                boolean isHistoryEnabled = GuiActivator.getMessageHistoryService().isHistoryLoggingEnabled(currentChatRoom.getIdentifier());
                GuiActivator.getMessageHistoryService().setHistoryLoggingEnabled(!isHistoryEnabled, currentChatRoom.getIdentifier());
            }
        } else if (menuItemName.equals("eraseHistoryPerContact")) {
            String destination;
            Object desc = chatPanel.getChatSession().getDescriptor();
            if (desc instanceof MetaContact) {
                destination = ((MetaContact)desc).getDisplayName();
            } else if (desc instanceof ChatRoomWrapper) {
                destination = ((ChatRoomWrapper)desc).getChatRoomName();
            } else {
                return;
            }
            MessageDialog dialog2 = new MessageDialog(null, GuiActivator.getResources().getI18NString("service.gui.WARNING"), GuiActivator.getResources().getI18NString("service.gui.HISTORY_REMOVE_PER_CONTACT_WARNING", new String[]{destination}), GuiActivator.getResources().getI18NString("service.gui.OK"), false);
            if (dialog2.showDialog() == 0) {
                try {
                    if (desc instanceof MetaContact) {
                        ((MessageHistoryService)ServiceUtils.getService((BundleContext)GuiActivator.bundleContext, MessageHistoryService.class)).eraseLocallyStoredHistory((MetaContact)desc);
                        ((FileHistoryService)ServiceUtils.getService((BundleContext)GuiActivator.bundleContext, FileHistoryService.class)).eraseLocallyStoredHistory((MetaContact)desc);
                    } else if (desc instanceof ChatRoomWrapper) {
                        ((MessageHistoryService)ServiceUtils.getService((BundleContext)GuiActivator.bundleContext, MessageHistoryService.class)).eraseLocallyStoredHistory(((ChatRoomWrapper)desc).getChatRoom());
                    }
                }
                catch (IOException ex) {
                    this.logger.error((Object)"Error removing history", (Throwable)ex);
                    chatPanel.addErrorMessage(destination, GuiActivator.getResources().getI18NString("service.gui.HISTORY_REMOVE_ERROR"), ex.getLocalizedMessage());
                }
            }
        } else if (menuItemName.equals("eraseAllHistory") && (dialog = new MessageDialog(null, GuiActivator.getResources().getI18NString("service.gui.WARNING"), GuiActivator.getResources().getI18NString("service.gui.HISTORY_REMOVE_ALL_WARNING"), GuiActivator.getResources().getI18NString("service.gui.OK"), false)).showDialog() == 0) {
            try {
                ((MessageHistoryService)ServiceUtils.getService((BundleContext)GuiActivator.bundleContext, MessageHistoryService.class)).eraseLocallyStoredHistory();
                ((FileHistoryService)ServiceUtils.getService((BundleContext)GuiActivator.bundleContext, FileHistoryService.class)).eraseLocallyStoredHistory();
            }
            catch (IOException ex) {
                this.logger.error((Object)"Error removing history", (Throwable)ex);
                chatPanel.addErrorMessage("all", GuiActivator.getResources().getI18NString("service.gui.HISTORY_REMOVE_ERROR"), ex.getLocalizedMessage());
            }
        }
    }

    private void init() {
        ResourceManagementService R = GuiActivator.getResources();
        JMenuItem historyButton = new JMenuItem(R.getI18NString("service.gui.HISTORY"));
        historyButton.setName("history");
        historyButton.setToolTipText(R.getI18NString("service.gui.HISTORY") + " Ctrl-H");
        historyButton.addActionListener(this);
        this.popupMenu.add(historyButton);
        this.popupMenu.addSeparator();
        this.toggleHistoryPerContact = new JCheckBoxMenuItem();
        this.toggleHistoryPerContact.setName("toggleHistoryPerContact");
        this.toggleHistoryPerContact.addActionListener(this);
        this.popupMenu.add(this.toggleHistoryPerContact);
        this.toggleAllHistory = new JCheckBoxMenuItem(R.getI18NString("service.gui.HISTORY_TOGGLE_ALL"));
        this.toggleAllHistory.setName("toggleAllHistory");
        this.toggleAllHistory.addActionListener(this);
        this.popupMenu.add(this.toggleAllHistory);
        this.popupMenu.addSeparator();
        this.eraseHistoryPerContact = new JMenuItem();
        this.eraseHistoryPerContact.setName("eraseHistoryPerContact");
        this.eraseHistoryPerContact.addActionListener(this);
        this.popupMenu.add(this.eraseHistoryPerContact);
        JMenuItem eraseAllHistory = new JMenuItem(R.getI18NString("service.gui.HISTORY_ERASE_ALL", new String[]{R.getSettingsString("service.gui.APPLICATION_NAME")}));
        eraseAllHistory.setName("eraseAllHistory");
        eraseAllHistory.addActionListener(this);
        this.popupMenu.add(eraseAllHistory);
        GuiActivator.getConfigurationService().addPropertyChangeListener((PropertyChangeListener)this);
        this.chatContainer.addChatChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("net.java.sip.communicator.service.msghistory.IS_MESSAGE_HISTORY_ENABLED")) {
            this.updateMenus();
        } else if (evt.getPropertyName().startsWith("net.java.sip.communicator.service.msghistory.contact")) {
            Object desc = this.chatContainer.getCurrentChat().getChatSession().getDescriptor();
            if (desc instanceof MetaContact) {
                MetaContact contact = (MetaContact)desc;
                if (evt.getPropertyName().endsWith(contact.getMetaUID())) {
                    this.updateMenus();
                }
            } else if (desc instanceof ChatRoomWrapper && evt.getPropertyName().endsWith(((ChatRoomWrapper)desc).getChatRoom().getIdentifier())) {
                this.updateMenus();
            }
        }
    }

    public void loadSkin() {
        this.updateMenus();
    }

    private void updateMenus() {
        this.toggleAllHistory.setSelected(false);
        this.toggleHistoryPerContact.setSelected(false);
        MessageHistoryService mhs = GuiActivator.getMessageHistoryService();
        if (!mhs.isHistoryLoggingEnabled()) {
            this.toggleAllHistory.setSelected(true);
        }
        if (this.chatContainer.getCurrentChat() != null) {
            ResourceManagementService R = GuiActivator.getResources();
            Object desc = this.chatContainer.getCurrentChat().getChatSession().getDescriptor();
            if (desc instanceof MetaContact) {
                MetaContact contact = (MetaContact)desc;
                if (!mhs.isHistoryLoggingEnabled(contact.getMetaUID())) {
                    this.toggleHistoryPerContact.setSelected(true);
                }
                this.toggleHistoryPerContact.setText(R.getI18NString("service.gui.HISTORY_TOGGLE_PER_CONTACT"));
                this.eraseHistoryPerContact.setText(R.getI18NString("service.gui.HISTORY_ERASE_PER_CONTACT"));
            } else if (desc instanceof ChatRoomWrapper) {
                if (!mhs.isHistoryLoggingEnabled(((ChatRoomWrapper)desc).getChatRoom().getIdentifier())) {
                    this.toggleHistoryPerContact.setSelected(true);
                }
                this.toggleHistoryPerContact.setText(R.getI18NString("service.gui.HISTORY_TOGGLE_PER_CHATROOM"));
                this.eraseHistoryPerContact.setText(R.getI18NString("service.gui.HISTORY_ERASE_PER_CHATROOM"));
            }
        }
        if (this.toggleAllHistory.isSelected() || this.toggleHistoryPerContact.isSelected()) {
            this.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.HISTORY_ICON_OFF)));
        } else {
            this.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.HISTORY_ICON_ON)));
        }
    }

    public void dispose() {
        GuiActivator.getConfigurationService().removePropertyChangeListener((PropertyChangeListener)this);
        this.chatContainer.removeChatChangeListener(this);
    }

    @Override
    public void chatChanged(ChatPanel panel) {
        this.updateMenus();
        panel.addChatLinkClickedListener(this);
    }

    public void chatLinkClicked(URI url) {
        if (url.getPath().equals("/showHistoryPopupMenu")) {
            this.doClick();
        }
    }
}

