/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.JFrame;
import javax.swing.Timer;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallContainer;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.CallPanel;
import net.java.sip.communicator.impl.gui.main.call.CallPeerRendererUtils;
import net.java.sip.communicator.impl.gui.main.call.CallTitleListener;
import net.java.sip.communicator.plugin.desktoputil.SIPCommFrame;

public class CallDialog
extends SIPCommFrame
implements CallContainer,
CallTitleListener {
    private static final long serialVersionUID = 0L;
    private static final String FORCE_MINIMIZED_MODE = "net.java.sip.communicator.impl.gui.main.call.FORCE_MINIMIZED_MODE";
    private CallPanel callPanel;
    private final WindowStateListener windowStateListener = new WindowStateListener(){

        @Override
        public void windowStateChanged(WindowEvent ev) {
            switch (ev.getID()) {
                case 203: 
                case 206: 
                case 208: {
                    CallDialog.this.setFullScreen(false);
                }
            }
        }
    };

    private static Container findClosestAncestorWithSetPreferredSize(Component component) {
        Container parent;
        if (component instanceof Container && component.isPreferredSizeSet()) {
            return (Container)component;
        }
        while ((parent = component.getParent()) != null) {
            if (parent.isPreferredSizeSet()) {
                return parent;
            }
            component = parent;
        }
        return null;
    }

    public CallDialog() {
        super(true, false);
        this.setMinimumSize(new Dimension(360, 300));
    }

    @Override
    public void addCallPanel(CallPanel callPanel) {
        this.callPanel = callPanel;
        this.getContentPane().add((Component)((Object)callPanel));
        callPanel.addCallTitleListener(this);
        this.setTitle(callPanel.getCallTitle());
        if (!this.isVisible()) {
            this.pack();
            if (GuiActivator.getConfigurationService().getBoolean(FORCE_MINIMIZED_MODE, false)) {
                this.setState(1);
            }
            this.setVisible(true);
        }
    }

    @Override
    public void callTitleChanged(CallPanel callPanel) {
        if (this.callPanel.equals(callPanel)) {
            this.setTitle(callPanel.getCallTitle());
        }
    }

    protected void close(boolean escape) {
        if (escape) {
            if (this.isFullScreen()) {
                this.setFullScreen(false);
                return;
            }
        } else {
            this.callPanel.disposeCallInfoFrame();
            this.setVisible(false);
        }
        this.callPanel.actionPerformedOnHangupButton(escape);
    }

    @Override
    public void close(CallPanel callPanel, boolean delay) {
        if (this.callPanel.equals(callPanel)) {
            if (delay) {
                Timer timer = new Timer(5000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        CallDialog.this.dispose();
                    }
                });
                timer.setRepeats(false);
                timer.start();
            } else {
                this.dispose();
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.callPanel != null) {
            this.callPanel.disposeCallInfoFrame();
            this.callPanel.dispose();
        }
    }

    @Override
    public void ensureSize(Component component, int width, int height) {
        boolean changeHeight;
        CallManager.assertIsEventDispatchingThread();
        Frame frame = CallPeerRendererUtils.getFrame((Component)component);
        if (frame == null) {
            return;
        }
        if ((frame.getExtendedState() & 6) == 6) {
            return;
        }
        if (frame.equals(frame.getGraphicsConfiguration().getDevice().getFullScreenWindow())) {
            return;
        }
        if (!frame.equals(this)) {
            return;
        }
        if (((Component)component).getHeight() >= height && ((Component)component).getWidth() >= width) {
            return;
        }
        if (this.callPanel != null) {
            Object ancestor = CallDialog.findClosestAncestorWithSetPreferredSize((Component)component);
            if (ancestor == null) {
                ancestor = this.callPanel;
            }
            if (((Component)ancestor).isPreferredSizeSet()) {
                Dimension preferredLayoutSize;
                LayoutManager ancestorLayout = ((Container)ancestor).getLayout();
                if (ancestorLayout != null && (preferredLayoutSize = ancestorLayout.preferredLayoutSize((Container)ancestor)) != null) {
                    component = ancestor;
                    width = preferredLayoutSize.width;
                    height = preferredLayoutSize.height;
                }
            } else {
                Dimension prefSize = ((Container)ancestor).getPreferredSize();
                if (prefSize != null) {
                    component = ancestor;
                    width = prefSize.width;
                    height = prefSize.height;
                }
            }
        }
        Dimension componentSize = ((Component)component).getSize();
        if (componentSize.width < 1 || componentSize.height < 1) {
            return;
        }
        Dimension frameSize = frame.getSize();
        int newFrameWidth = frameSize.width + width - componentSize.width;
        int newFrameHeight = frameSize.height + height - componentSize.height;
        Dimension minSize = frame.getMinimumSize();
        if (newFrameWidth < minSize.width) {
            newFrameWidth = minSize.width;
        }
        if (newFrameHeight < minSize.height) {
            newFrameHeight = minSize.height;
        }
        Rectangle screenBounds = frame.getGraphicsConfiguration().getBounds();
        if (newFrameWidth > screenBounds.width) {
            newFrameWidth = screenBounds.width;
        }
        if (newFrameHeight > screenBounds.height) {
            newFrameHeight = screenBounds.height;
        }
        boolean changeWidth = newFrameWidth - frameSize.width > 1;
        boolean bl = changeHeight = newFrameHeight - frameSize.height > 1;
        if (changeWidth || changeHeight) {
            if (!changeWidth) {
                newFrameWidth = frameSize.width;
            } else if (!changeHeight) {
                newFrameHeight = frameSize.height;
            }
            int newFrameX = screenBounds.x + (screenBounds.width - newFrameWidth) / 2;
            int newFrameY = screenBounds.y + (screenBounds.height - newFrameHeight) / 2;
            if (newFrameX < screenBounds.x) {
                newFrameX = screenBounds.x;
            }
            if (newFrameY < screenBounds.y) {
                newFrameY = screenBounds.y;
            }
            frame.setBounds(newFrameX, newFrameY, newFrameWidth, newFrameHeight);
            if (frame.isDisplayable()) {
                if (frame.isValid()) {
                    frame.doLayout();
                } else {
                    frame.validate();
                }
                frame.repaint();
            } else {
                frame.doLayout();
            }
        }
    }

    @Override
    public JFrame getFrame() {
        return this;
    }

    public Dimension getMinimumSize() {
        int minButtonWidth;
        Dimension minSize = super.getMinimumSize();
        if (this.callPanel != null && (double)(minButtonWidth = this.callPanel.getMinimumButtonWidth()) > minSize.getWidth()) {
            minSize = new Dimension(minButtonWidth, 300);
        }
        return minSize;
    }

    public boolean isCallVisible(CallPanel callPanel) {
        return this.callPanel.equals(callPanel) ? this.isVisible() : false;
    }

    @Override
    public boolean isFullScreen() {
        return CallDialog.isFullScreen(this.getFrame());
    }

    public static boolean isFullScreen(Window window) {
        GraphicsDevice device;
        GraphicsConfiguration graphicsConfiguration = window.getGraphicsConfiguration();
        if (graphicsConfiguration != null && (device = graphicsConfiguration.getDevice()) != null) {
            return window.equals(device.getFullScreenWindow());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFullScreen(boolean fullScreen) {
        GraphicsDevice device;
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration != null && (device = graphicsConfiguration.getDevice()) != null) {
            boolean thisIsFullScreen = this.equals(device.getFullScreenWindow());
            boolean firePropertyChange = false;
            boolean setVisible = this.isVisible();
            try {
                if (fullScreen) {
                    if (!thisIsFullScreen) {
                        this.windowDispose();
                        this.setUndecorated(true);
                        device.setFullScreenWindow((Window)((Object)this));
                        firePropertyChange = true;
                    }
                } else if (thisIsFullScreen) {
                    this.windowDispose();
                    this.setUndecorated(false);
                    device.setFullScreenWindow(null);
                    firePropertyChange = true;
                }
                if (firePropertyChange) {
                    if (fullScreen) {
                        this.addWindowStateListener(this.windowStateListener);
                        this.getContentPane().setBackground(Color.BLACK);
                    } else {
                        this.removeWindowStateListener(this.windowStateListener);
                        this.getContentPane().setBackground(null);
                    }
                    this.firePropertyChange("fullScreen", thisIsFullScreen, fullScreen);
                }
            }
            finally {
                if (setVisible) {
                    this.setVisible(true);
                }
            }
        }
    }
}

