/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.domain;

import com.ircclouds.irc.api.domain.messages.interfaces.ISource;
import java.net.Proxy;

public class IRCServer
implements ISource {
    private static final int DEFAULT_IRC_SERVER_PORT = 6667;
    private static final int DEFAULT_SSL_IRC_SERVER_PORT = 6697;
    private final String hostname;
    private final String password;
    private final int port;
    private final Boolean isSSL;
    private final Proxy proxy;
    private final boolean resolveByProxy;

    public IRCServer(String aHostname) {
        this(aHostname, 6667);
    }

    public IRCServer(String aHostname, Boolean aSSLServer) {
        this.port = aSSLServer != false ? 6697 : 6667;
        this.hostname = aHostname;
        this.password = "";
        this.isSSL = aSSLServer;
        this.proxy = null;
        this.resolveByProxy = false;
    }

    public IRCServer(String aHostname, int aPort) {
        this(aHostname, aPort, "", false, null, false);
    }

    public IRCServer(String aHostname, int aPort, Boolean aIsSSL) {
        this(aHostname, aPort, "", aIsSSL, null, false);
    }

    public IRCServer(String aHostname, int aPort, String aPassword, Boolean aIsSSL) {
        this(aHostname, aPort, aPassword, aIsSSL, null, false);
    }

    public IRCServer(String aHostname, int aPort, String aPassword, Boolean aIsSSL, Proxy aProxy, boolean aResolveByProxy) {
        this.hostname = aHostname;
        this.port = aPort;
        this.password = aPassword;
        this.isSSL = aIsSSL;
        this.proxy = aProxy;
        this.resolveByProxy = aResolveByProxy;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public Boolean isSSL() {
        return this.isSSL;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public boolean isResolveByProxy() {
        return this.resolveByProxy;
    }

    public String toString() {
        return this.hostname;
    }
}

