/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.translator;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.LinkedList;
import java.util.List;
import javax.media.protocol.PushSourceStream;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.RTPConnector;
import org.jitsi.impl.neomedia.rtp.translator.OutputDataStreamImpl;
import org.jitsi.impl.neomedia.rtp.translator.Payload;
import org.jitsi.impl.neomedia.rtp.translator.PushSourceStreamImpl;
import org.jitsi.impl.neomedia.rtp.translator.RTPConnectorDesc;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.service.neomedia.MediaStream;

class RTPConnectorImpl
implements RTPConnector {
    private final List<RTPConnectorDesc> connectors = new LinkedList<RTPConnectorDesc>();
    private PushSourceStreamImpl controlInputStream;
    private OutputDataStreamImpl controlOutputStream;
    private PushSourceStreamImpl dataInputStream;
    private OutputDataStreamImpl dataOutputStream;
    public final RTPTranslatorImpl translator;

    public RTPConnectorImpl(RTPTranslatorImpl translator) {
        this.translator = translator;
    }

    public synchronized void addConnector(RTPConnectorDesc connector) {
        if (!this.connectors.contains(connector)) {
            this.connectors.add(connector);
            if (this.controlInputStream != null) {
                PushSourceStream controlInputStream = null;
                try {
                    controlInputStream = connector.connector.getControlInputStream();
                }
                catch (IOException ioe) {
                    throw new UndeclaredThrowableException(ioe);
                }
                if (controlInputStream != null) {
                    this.controlInputStream.addStream(connector, controlInputStream);
                }
            }
            if (this.controlOutputStream != null) {
                OutputDataStream controlOutputStream = null;
                try {
                    controlOutputStream = connector.connector.getControlOutputStream();
                }
                catch (IOException ioe) {
                    throw new UndeclaredThrowableException(ioe);
                }
                if (controlOutputStream != null) {
                    this.controlOutputStream.addStream(connector, controlOutputStream);
                }
            }
            if (this.dataInputStream != null) {
                PushSourceStream dataInputStream = null;
                try {
                    dataInputStream = connector.connector.getDataInputStream();
                }
                catch (IOException ioe) {
                    throw new UndeclaredThrowableException(ioe);
                }
                if (dataInputStream != null) {
                    this.dataInputStream.addStream(connector, dataInputStream);
                }
            }
            if (this.dataOutputStream != null) {
                OutputDataStream dataOutputStream = null;
                try {
                    dataOutputStream = connector.connector.getDataOutputStream();
                }
                catch (IOException ioe) {
                    throw new UndeclaredThrowableException(ioe);
                }
                if (dataOutputStream != null) {
                    this.dataOutputStream.addStream(connector, dataOutputStream);
                }
            }
        }
    }

    public synchronized void close() {
        if (this.controlInputStream != null) {
            this.controlInputStream.close();
            this.controlInputStream = null;
        }
        if (this.controlOutputStream != null) {
            this.controlOutputStream.close();
            this.controlOutputStream = null;
        }
        if (this.dataInputStream != null) {
            this.dataInputStream.close();
            this.dataInputStream = null;
        }
        if (this.dataOutputStream != null) {
            this.dataOutputStream.close();
            this.dataOutputStream = null;
        }
        for (RTPConnectorDesc connectorDesc : this.connectors) {
            connectorDesc.connector.close();
        }
    }

    public synchronized PushSourceStream getControlInputStream() throws IOException {
        if (this.controlInputStream == null) {
            this.controlInputStream = new PushSourceStreamImpl(this, false);
            for (RTPConnectorDesc connectorDesc : this.connectors) {
                PushSourceStream controlInputStream = connectorDesc.connector.getControlInputStream();
                if (controlInputStream == null) continue;
                this.controlInputStream.addStream(connectorDesc, controlInputStream);
            }
        }
        return this.controlInputStream;
    }

    public synchronized OutputDataStreamImpl getControlOutputStream() throws IOException {
        if (this.controlOutputStream == null) {
            this.controlOutputStream = new OutputDataStreamImpl(this, false);
            for (RTPConnectorDesc connectorDesc : this.connectors) {
                OutputDataStream controlOutputStream = connectorDesc.connector.getControlOutputStream();
                if (controlOutputStream == null) continue;
                this.controlOutputStream.addStream(connectorDesc, controlOutputStream);
            }
        }
        return this.controlOutputStream;
    }

    public synchronized PushSourceStream getDataInputStream() throws IOException {
        if (this.dataInputStream == null) {
            this.dataInputStream = new PushSourceStreamImpl(this, true);
            for (RTPConnectorDesc connectorDesc : this.connectors) {
                PushSourceStream dataInputStream = connectorDesc.connector.getDataInputStream();
                if (dataInputStream == null) continue;
                this.dataInputStream.addStream(connectorDesc, dataInputStream);
            }
        }
        return this.dataInputStream;
    }

    public synchronized OutputDataStreamImpl getDataOutputStream() throws IOException {
        if (this.dataOutputStream == null) {
            this.dataOutputStream = new OutputDataStreamImpl(this, true);
            for (RTPConnectorDesc connectorDesc : this.connectors) {
                OutputDataStream dataOutputStream = connectorDesc.connector.getDataOutputStream();
                if (dataOutputStream == null) continue;
                this.dataOutputStream.addStream(connectorDesc, dataOutputStream);
            }
        }
        return this.dataOutputStream;
    }

    public int getReceiveBufferSize() {
        return -1;
    }

    public double getRTCPBandwidthFraction() {
        return -1.0;
    }

    public double getRTCPSenderBandwidthFraction() {
        return -1.0;
    }

    public int getSendBufferSize() {
        return -1;
    }

    public synchronized void removeConnector(RTPConnectorDesc connector) {
        if (this.connectors.contains(connector)) {
            if (this.controlInputStream != null) {
                this.controlInputStream.removeStreams(connector);
            }
            if (this.controlOutputStream != null) {
                this.controlOutputStream.removeStreams(connector);
            }
            if (this.dataInputStream != null) {
                this.dataInputStream.removeStreams(connector);
            }
            if (this.dataOutputStream != null) {
                this.dataOutputStream.removeStreams(connector);
            }
            this.connectors.remove(connector);
        }
    }

    public void setReceiveBufferSize(int receiveBufferSize) throws IOException {
    }

    public void setSendBufferSize(int sendBufferSize) throws IOException {
    }

    boolean writeControlPayload(Payload controlPayload, MediaStream destination) {
        OutputDataStreamImpl controlOutputStream = this.controlOutputStream;
        return controlOutputStream == null ? false : controlOutputStream.writeControlPayload(controlPayload, destination);
    }
}

